/*
 * Copyright (C) 2007, 2008 Apple Inc. All rights reserved.
 * Copyright (C) 2009 Torch Mobile Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 * 3.  Neither the name of Apple Inc. ("Apple") nor the names of
 *     its contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include <wtf/MainThread.h>

#include <wtf/Assertions.h>
#include <wtf/RunLoop.h>
#include <wtf/Threading.h>
#include <wtf/WindowsExtras.h>

namespace WTF
{

//+TELESCOPE_LIB_CHANGES
// 4/3/2020
// WebKit relies against Windows message queue for  trigger event from main thread to others. Due to the platform dependent, replacing it by adding WTF::dispatchFunctionsFromMainThread() into tick function.
static ThreadIdentifier mainThread { 0 };
static bool initialized = false;
//-TELESCOPE_LIB_CHANGES

void initializeMainThreadPlatform()
{


//+TELESCOPE_LIB_CHANGES
// 4/3/2020
// WebKit relies against Windows message queue for  trigger event from main thread to others. Due to the platform dependent, replacing it by adding WTF::dispatchFunctionsFromMainThread() into tick function.
    if ( !initialized )
        initialized = true;
    else
        return;
//-TELESCOPE_LIB_CHANGES
	mainThread = Thread::currentID();

	Thread::initializeCurrentThreadInternal( "Main Thread" );

    // TELESCOPE_LIB_CHANGES 1/15/2021 For unifying RunLoop implementation on all platforms.
	// RunLoop::registerRunLoopMessageWindowClass();
}

bool isMainThread()
{
    return mainThread == Thread::currentID();
}


//+TELESCOPE_LIB_CHANGES
// 4/3/2020
// WebKit relies against Windows message queue for  trigger event from main thread to others. Due to the platform dependent, replacing it by adding WTF::dispatchFunctionsFromMainThread() into tick function.
bool isMainThreadPlatformInitialized()
{
    return initialized;
}
//-TELESCOPE_LIB_CHANGES
void scheduleDispatchFunctionsOnMainThread()
{


//+TELESCOPE_LIB_CHANGES
// 4/3/2020
// WebKit relies against Windows message queue for  trigger event from main thread to others. Due to the platform dependent, replacing it by adding WTF::dispatchFunctionsFromMainThread() into tick function.
    // Nothing to do, but keep the stub.
//-TELESCOPE_LIB_CHANGES
}

} // namespace WTF
