/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "CurlReplacementImpl.h"
#include "ClientWrappers/HttpWrapperBase.h"

using namespace WebCore;

namespace Telescope
{
TELESCOPE_DEFINE_MEMORY_TAG( HTTP_MEMORY_TAG, "Http" );

static HttpWrapperBase *httpImpl;

void InstallHttpWrapper( HttpWrapperBase *httpWrapperImpl )
{
	httpImpl = httpWrapperImpl;
}


static HttpWrapperBase *getHttpWrapper()
{
	return httpImpl;
}


void *CurlReplacementImpl::createContext()
{
	return new HttpContext( Telescope_GetMemoryAllocator() );
}


void CurlReplacementImpl::destroyContext( void *context )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	delete httpContext;
}


bool CurlReplacementImpl::initRequest( void *context, const char *method, const char *url, const unsigned int timeout )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	return getHttpWrapper()->initRequest( httpContext, method, url, timeout );
}


void CurlReplacementImpl::addRequestHeader( void *context, const char *name, const char *value )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	getHttpWrapper()->addRequestHeader( httpContext, name, value );
}


void CurlReplacementImpl::removeRequestHeader( void *context, const char *name )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	getHttpWrapper()->removeRequestHeader( httpContext, name );
}


void CurlReplacementImpl::setSimpleUploadBuffer( void *context, const void *buffer, long size )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	getHttpWrapper()->setSimpleUploaderBuffer( httpContext, buffer, size );
}


void CurlReplacementImpl::perform( void *context )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	getHttpWrapper()->perform( httpContext );
}


void CurlReplacementImpl::abort( void *context )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	getHttpWrapper()->abort( httpContext );
}


void CurlReplacementImpl::finalize( void *context )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	getHttpWrapper()->finalize( httpContext );
}


long CurlReplacementImpl::getHttpVersion( void *context )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	return getHttpWrapper()->getHttpVersion( httpContext );
}


void CurlReplacementImpl::setPause( void *context, bool enabled )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	getHttpWrapper()->setPause( httpContext, enabled );
}


bool CurlReplacementImpl::isPause( void *context )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	return getHttpWrapper()->isPause( httpContext );
}


void CurlReplacementImpl::disableServerTrustEvaluation( void *context )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	getHttpWrapper()->disableServerTrustEvaluation( httpContext );
}


void CurlReplacementImpl::setChunkedTransferEnabled( void *context, bool enabled )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	getHttpWrapper()->setChunkedTransferEnabled( httpContext, enabled );
}


void CurlReplacementImpl::setHeaderReceiveCallback( void *context, DataSendRecvCB callback, void *userData )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	getHttpWrapper()->setHeaderReceiveCallback( httpContext, callback, userData );
}


void CurlReplacementImpl::setDataReceiveCallback( void *context, DataSendRecvCB callback, void *userData )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	getHttpWrapper()->setDataReceiveCallback( httpContext, callback, userData );
}


void CurlReplacementImpl::setDataSendCallback( void *context, DataSendRecvCB callback, void *userData )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	getHttpWrapper()->setDataSendCallback( httpContext, callback, userData );
}


int CurlReplacementImpl::getContentLength( void *context )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	return getHttpWrapper()->getContentLength( httpContext );
}


void CurlReplacementImpl::setContentLength( void *context, int size )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	getHttpWrapper()->setContentLength( httpContext, size );
}


int CurlReplacementImpl::getStatus( void *context )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	return getHttpWrapper()->getStatus( httpContext );
}


int CurlReplacementImpl::getLastErrorCode( void *context )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	return getHttpWrapper()->getLastErrorCode( httpContext );
}


int CurlReplacementImpl::getHttpStatus( void *context )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	return getHttpWrapper()->getHttpStatus( httpContext );
}


void CurlReplacementImpl::getUrl( void *context, const char **url )
{
	HttpContext *httpContext = reinterpret_cast<HttpContext *>( context );
	*url = httpContext->url;
}


CurlReplacementImpl::~CurlReplacementImpl()
{ // Nothing to do here.
}
} // End of namespace Telescope

std::unique_ptr<CurlReplacement> getCurlReplacementImplementation()
{
	return makeUnique<Telescope::CurlReplacementImpl>();
}
