/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once
#include <zlib.h>

#if defined( __cplusplus )
extern "C"
{
#endif // #if defined( __cplusplus )
int wrapper_deflate( z_streamp strm, int flush );

int wrapper_deflateEnd( z_streamp strm );

gzFile wrapper_gzdopen( int fd, const char *mode );

int wrapper_gzread( gzFile file, voidp buf, unsigned len );

int wrapper_gzwrite( gzFile file, voidpc buf, unsigned len );

int wrapper_gzdirect( gzFile file );

int wrapper_gzclose( gzFile file );

uLong wrapper_crc32( uLong crc, const Bytef *buf, uInt len );

int wrapper_deflateInit2_( z_streamp strm, int level, int method,
	int windowBits, int memLevel,
	int strategy );

gzFile wrapper_gzopen( const char *, const char * );

int wrapper_inflate( z_streamp z, int f );

int wrapper_inflateEnd( z_streamp z );

int wrapper_inflateInit2_( z_streamp z, int w );

int wrapper_uncompress( Bytef *dest, uLongf *destLen,
	const Bytef *source, uLong sourceLen );

uLong wrapper_deflateBound( z_streamp strm, uLong sourceLen );

int wrapper_inflateReset( z_streamp z );

int wrapper_deflateReset( z_streamp strm );

int wrapper_inflateReset2( z_streamp strm, int windowBits );

uLong wrapper_adler32( uLong adler, const Bytef *buf, uInt len );
#if defined( __cplusplus )
};
#endif // #if defined( __cplusplus )