/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "JSONInterfaces.h"
#include <wtf/JSONValues.h>

namespace Telescope
{
namespace JsonWrapper
{
typedef JSON::Value JValue;
typedef JSON::Object JObject;
typedef JSON::Array JArray;

//
// String
//

class String : public IString
{
	RefPtr<WTF::CStringBuffer> m_stringValue;

public:
	String() {}
	String( const RefPtr<WTF::CStringBuffer> &s );

	virtual void Release() override;

	virtual const char *CString() const override;
};


//
// Value
//

class Value : public IValue
{
	RefPtr<JValue> m_value;

public:
	Value( const RefPtr<JValue> &value );

	virtual void Release() override;

	virtual bool GetBoolean( bool &v ) const override;
	virtual bool GetInteger( int &v ) const override;
	virtual bool GetInteger( unsigned &v ) const override;
	virtual bool GetInteger( long &v ) const override;
	virtual bool GetInteger( long long &v ) const override;
	virtual bool GetInteger( unsigned long &v ) const override;
	virtual bool GetInteger( unsigned long long &v ) const override;
	virtual bool GetDouble( double &v ) const override;
	virtual bool GetFloat( float &v ) const override;
	virtual bool GetString( IString *&v ) const override;
	virtual StringPtr GetString() const override;

	virtual ObjectPtr AsObject() const override;
	virtual ArrayPtr AsArray() const override;
};


//
// Object
//

class Object : public IObject
{
	RefPtr<JObject> m_object;

public:
	Object( const RefPtr<JObject> &obj );

	virtual void Release() override;

	virtual ValuePtr GetValue( const char *pName ) const override;
	virtual ObjectPtr GetObject( const char *pName ) const override;
	virtual ArrayPtr GetArray( const char *pName ) const override;

	virtual IteratorPtr GetIterator() const override;

	class Iterator : public IIterator
	{
		JObject::const_iterator m_iter;
		JObject::const_iterator m_iterEnd;
		mutable RefPtr<WTF::CStringBuffer> m_name;

	public:
		Iterator( const RefPtr<JObject> &obj );

		virtual void Release() override;

		virtual bool End() const override;
		virtual void Next() override;
		virtual const char *Name() const override;
		virtual ValuePtr Value() const override;
	};
};


//
// Array
//

class Array : public IArray
{
	RefPtr<JArray> m_array;

public:
	Array( const RefPtr<JArray> &a );

	virtual void Release() override;

	virtual size_t Length() const override;
	virtual ValuePtr GetElement( size_t index ) const override;
};

} // namespace JsonWrapper
} // namespace Telescope