/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#pragma once

#include "TelescopeJSGlobal.h"

namespace JSC
{
namespace Bindings
{
class TelescopeClass;

class TelescopeInstance : public Instance
{
	WTF_MAKE_NONCOPYABLE( TelescopeInstance );

	//	don't construct manually
	TelescopeInstance( Telescope::IJSBoundObject *, RefPtr<RootObject> );

public:
	virtual ~TelescopeInstance();

public:
	//	Singleton design pattern
	static Ref<TelescopeInstance> Create( Telescope::IJSBoundObject *pObj, RefPtr<RootObject> pRootObj );

public:
	//	override virtual method
	virtual Class *getClass() const override;
	virtual void getPropertyNames( JSGlobalObject *, PropertyNameArray & ) override;

	virtual JSValue valueOf( JSGlobalObject * ) const override;
	virtual JSValue defaultValue( JSGlobalObject *, PreferredPrimitiveType ) const override;

	virtual JSValue getMethod( JSGlobalObject *, PropertyName ) override;
	virtual JSValue invokeMethod( JSGlobalObject *, CallFrame *, RuntimeMethod * ) override;
	virtual JSValue invokeDefaultMethod( JSGlobalObject *, CallFrame * ) override;
	virtual bool supportsInvokeDefaultMethod() const override;

public:
	Telescope_BoundObject *getBoundObj() const;

private:
	JSValue invokeMethodInternal( JSGlobalObject *, const char *pMethodName );

private:
	mutable TelescopeClass *m_pClass;
	Telescope_BoundObject *m_pBoundObject;
};
} // namespace Bindings
} // namespace JSC
