/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#pragma once

#include "PlatformFeatureDefs.h"
#include <../JavaScriptCore/API/JSValue.h>
#include <JavaScriptCore/ClassInfo.h>
#include <JavaScriptCore/Error.h>
#include <JavaScriptCore/JSLock.h>
#include <JavaScriptCore/JSGlobalObject.h>
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/JSCJSValueInlines.h>
#include <JavaScriptCore/JSFunction.h>
#include <JavaScriptCore/Protect.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/CallFrame.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/JSContextRef.h>
#include <JavaScriptCore/CallData.h>
#include <JavaScriptCore/Identifier.h>
#include <JavaScriptCore/IdentifierInlines.h>
#include <WebCore/BridgeJSC.h>
#include <WebCore/runtime_root.h>
#include <WebCore/CommonVM.h>
#include <WebCore/JSDOMBinding.h>
#include <WebCore/runtime_object.h>
#include <WebCore/JSDOMBinding.h>
#include <wtf/Noncopyable.h>
#include <wtf/text/ASCIILiteral.h>
#include <wtf/text/StringView.h>

//////////////////////////////////////////////////////////////////////////
//	Declare
namespace JSC
{
class JSArray;
class JSObject;
class JSFunction;
class JSGlobalObject;
class JSValue;
} // namespace JSC


//////////////////////////////////////////////////////////////////////////
//	Typedef
typedef JSC::JSArray JSC_Array;
typedef JSC::JSObject JSC_Object;
typedef JSC::JSFunction JSC_Function;
typedef JSC::JSGlobalObject JSC_GlobalObject;
typedef JSC::JSValue JSC_Value;


//////////////////////////////////////////////////////////////////////////
//	Telescope
namespace Telescope
{
class IJSBoundObject;
class TelescopeJSValue;

JSC_Array *ValToArr( JSC_GlobalObject *pGlobalObject, JSC_Value *pVal );
JSC_Object *ValToObj( JSC_Value *pVal );
JSC_Function *ValToFunc( JSC_Value *pVal );
} // namespace Telescope

typedef Telescope::IJSBoundObject Telescope_BoundObject;
typedef Telescope::TelescopeJSValue Telescope_Value;


//////////////////////////////////////////////////////////////////////////
//	JSC
namespace JSC
{
namespace Bindings
{
void JS2Telescope( JSGlobalObject *pGlobalObject, const JSValue &rValue, Telescope_Value *pOut );
JSValue Telescope2JS( JSGlobalObject *pGlobalObject, const Telescope_Value &rValue );
} // namespace Bindings
} // namespace JSC

//////////////////////////////////////////////////////////////////////////
//	Macro
#define ASSERT_RETURN_FALSE \
	{                       \
		assert( 0 );        \
		return false;       \
	}
#define ASSERT_RETURN_NULLPTR \
	{                         \
		assert( 0 );          \
		return nullptr;       \
	}
#define ASSERT_RETURN_UNDEFINED \
	{                           \
		assert( 0 );            \
		return jsUndefined();   \
	}
#define SAFE_DELETE( p ) \
	{                    \
		if ( p )         \
		{                \
			delete p;    \
			p = nullptr; \
		}                \
	}