/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "config.h"
#include "TelescopeJSGlobal.h"
#include "TelescopePropertyIterator.h"
#include "TelescopeJavascriptValue.h"

namespace Telescope
{
//////////////////////////////////////////////////////////////////////////
//	JSBoundObjectPropertyIterator
JSBoundObjectPropertyIterator::JSBoundObjectPropertyIterator()
{
}


JSBoundObjectPropertyIterator::~JSBoundObjectPropertyIterator()
{
}


const char *JSBoundObjectPropertyIterator::GetKey() const
{
	return nullptr;
}


//////////////////////////////////////////////////////////////////////////
//	JSValuePropertyIterator
JSValuePropertyIterator::JSValuePropertyIterator( TelescopeJSValue *pOwner )
{
	m_pObj = pOwner;
	m_pItr = nullptr;

	new ( m_caNames ) JSC::PropertyNameArray(
		pOwner->m_pGlobalObject->vm(), JSC::PropertyNameMode::Strings, JSC::PrivateSymbolMode::Include );
}


JSValuePropertyIterator::~JSValuePropertyIterator()
{
	JSC::PropertyNameArray *pNames = reinterpret_cast<JSC::PropertyNameArray *>( (void *)m_caNames );
	pNames->~PropertyNameArray();
	m_pItr = nullptr;
}


void JSValuePropertyIterator::GetValue( TelescopeJSValue *pValOut ) const
{
	//  TODO: need to thread and init status here
	JSC::PropertyNameArray *pNames = reinterpret_cast<JSC::PropertyNameArray *>( (void *)m_caNames );
	JSC::PropertyNameArray::const_iterator ciItr = reinterpret_cast<JSC::PropertyNameArray::const_iterator>( m_pItr );
	assert( ciItr != pNames->end() );
	if ( ciItr == pNames->end() )
	{
		return;
	}
	JSC_Value oVal( ValToObj( m_pObj->GetImpl() )->get( m_pObj->m_pGlobalObject, *ciItr ) );
	*pValOut = TelescopeJSValue( &oVal, m_pObj->m_pGlobalObject );
}


const char *JSValuePropertyIterator::GetKey() const
{
	//  TODO: need to thread and init status here
	JSC::PropertyNameArray *pNames = reinterpret_cast<JSC::PropertyNameArray *>( (void *)m_caNames );
	JSC::PropertyNameArray::const_iterator ciItr = reinterpret_cast<JSC::PropertyNameArray::const_iterator>( m_pItr );
	assert( ciItr != pNames->end() );
	if ( ciItr == pNames->end() )
	{
		return nullptr;
	}
	return (char *)( ciItr->string().characters8() );
}


void JSValuePropertyIterator::SetValue( const TelescopeJSValue &rVal )
{
	//  TODO: need to thread and init status here
	JSC::PropertyNameArray *pNames = reinterpret_cast<JSC::PropertyNameArray *>( (void *)m_caNames );
	JSC::PropertyNameArray::const_iterator ciItr = reinterpret_cast<JSC::PropertyNameArray::const_iterator>( m_pItr );
	assert( ciItr != pNames->end() );
	if ( ciItr == pNames->end() )
	{
		return;
	}
	JSC::PutPropertySlot oSlot( *rVal.GetImpl() );
	JSC_Object::put( ValToObj( m_pObj->GetImpl() ), m_pObj->m_pGlobalObject, *ciItr, *rVal.GetImpl(), oSlot );
}
}; // namespace Telescope
