/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "TelescopeDll.h"
#include "TelescopeLib.h"
#include <WebCore/SharedBuffer.h>


extern "C" Telescope::TelescopeLib *CreateTelescopeInstance()
{
	static Telescope::TelescopeLib telescopeInstance;
	return &telescopeInstance;
}


RefPtr<WebCore::SharedBuffer> loadResourceIntoBuffer( const char *name )
{
	return nullptr;
}


#if ( defined( WIN32 ) || defined( _WIN32 ) ) && !defined( IS_XB )
/*this maybe not necessary let's wait and see if we need add any module attach detach event*/
#include <windows.h>
#include <webcore/WebCoreInstanceHandle.h>
#include <webcore/RenderThemeWin.h>
STDAPI_( BOOL )
DllMain( HMODULE hModule, DWORD ul_reason_for_call, LPVOID /*lpReserved*/ )
{
	switch ( ul_reason_for_call )
	{
	case DLL_PROCESS_ATTACH:
		WebCore::setInstanceHandle( hModule );
		return TRUE;

	case DLL_PROCESS_DETACH:
		WebCore::RenderThemeWin::setWebKitIsBeingUnloaded();
		break;

	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
		break;
	}
	return FALSE;
}
#endif // #if ( defined( WIN32 ) || defined( _WIN32 ) ) && !defined( IS_XB )