/*
 * Copyright (C) 2021 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "TelescopeMediaSourcePrivate.h"
#include "TelescopeMediaPlayerPrivate.h"
#include "TelescopeSourceBufferPrivate.h"

#include "NotImplemented.h"

#if ENABLE(MEDIA_SOURCE)

namespace Telescope
{
	Ref<TelescopeMediaSourcePrivate> TelescopeMediaSourcePrivate::create(TelescopeMediaPlayerPrivate* pParent, WebCore::MediaSourcePrivateClient* pClient)
	{
		return adoptRef(*new TelescopeMediaSourcePrivate(pParent, pClient));
	}

	TelescopeMediaSourcePrivate::TelescopeMediaSourcePrivate(TelescopeMediaPlayerPrivate* pParent, WebCore::MediaSourcePrivateClient* pClient)
		: m_pPlayer(pParent)
		, m_client(pClient)
		, m_isEnded(false)
		, m_readyState(WebCore::MediaPlayer::ReadyState::HaveNothing)
	{
	}

	TelescopeMediaSourcePrivate::~TelescopeMediaSourcePrivate()
	{
	}

	TelescopeMediaSourcePrivate::AddStatus TelescopeMediaSourcePrivate::addSourceBuffer(const WebCore::ContentType& contentType, RefPtr<WebCore::SourceBufferPrivate>& outPrivate)
	{
		WebCore::MediaEngineSupportParameters parameters;
		parameters.isMediaSource = true;
		parameters.type = contentType;
		if (!IsSupportsTypeAndCodecs(parameters))
		{
			return NotSupported;
		}
		auto newSourceBuffer = TelescopeSourceBufferPrivate::create(this, contentType);
		outPrivate = newSourceBuffer.copyRef();
		m_sourceBuffers.append(WTFMove(newSourceBuffer));
		return Ok;
	}

	void TelescopeMediaSourcePrivate::durationChanged()
	{
		// TODO: m_player->durationChanged();
		notImplemented();
	}

	void TelescopeMediaSourcePrivate::markEndOfStream(EndOfStreamStatus status)
	{
		// TODO: if (status == EosNoError) m_player->setNetworkState(WebCore::MediaPlayer::NetworkState::Loaded);
		m_isEnded = true;
	}

	void TelescopeMediaSourcePrivate::unmarkEndOfStream()
	{
		m_isEnded = false;
	}

	WebCore::MediaPlayer::ReadyState TelescopeMediaSourcePrivate::readyState() const
	{
		return m_readyState;
	}

	void TelescopeMediaSourcePrivate::setReadyState(WebCore::MediaPlayer::ReadyState readyState)
	{
		m_readyState = readyState;
	}

	void TelescopeMediaSourcePrivate::waitForSeekCompleted()
	{
		// TODO: m_player->seekCompleted();
		notImplemented();
	}

	void TelescopeMediaSourcePrivate::seekCompleted()
	{
		// TODO: m_player->seekCompleted();
		notImplemented();
	}

	TelescopeMediaPlayerPrivate* TelescopeMediaSourcePrivate::getPlayer() const
	{
		return m_pPlayer;
	}
}

#endif
