/*
 * Copyright (C) 2021 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "MediaSourcePrivate.h"
#include "MediaSourcePrivateClient.h"

#if ENABLE(MEDIA_SOURCE)

namespace Telescope
{
	class TelescopeMediaPlayerPrivate;
	class TelescopeSourceBufferPrivate;

	class TelescopeMediaSourcePrivate final : public WebCore::MediaSourcePrivate
	{
		WTF_MAKE_FAST_ALLOCATED;

	public:
		static Ref<TelescopeMediaSourcePrivate> create(TelescopeMediaPlayerPrivate*, WebCore::MediaSourcePrivateClient*);
		~TelescopeMediaSourcePrivate();

		AddStatus addSourceBuffer(const WebCore::ContentType&, RefPtr<WebCore::SourceBufferPrivate>&) final;
		void durationChanged() final;

		void markEndOfStream(EndOfStreamStatus) final;
		void unmarkEndOfStream() final;

		WebCore::MediaPlayer::ReadyState readyState() const final;
		void setReadyState(WebCore::MediaPlayer::ReadyState) final;

		void waitForSeekCompleted() final;
		void seekCompleted() final;

		TelescopeMediaPlayerPrivate* getPlayer() const;

	private:
		TelescopeMediaSourcePrivate(TelescopeMediaPlayerPrivate*, WebCore::MediaSourcePrivateClient*);

		TelescopeMediaPlayerPrivate* m_pPlayer;
		RefPtr<WebCore::MediaSourcePrivateClient> m_client;
		Vector<RefPtr<TelescopeSourceBufferPrivate>> m_sourceBuffers;
		bool m_isEnded;
		WebCore::MediaPlayer::ReadyState m_readyState;
	};

}

#endif
