/*
 * Copyright (C) 2021 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "TelescopeSourceBufferPrivate.h"
#include "TelescopeMediaSourcePrivate.h"
#include "TelescopeMediaPlayerPrivate.h"

#include "NotImplemented.h"
#include "SourceBufferPrivateClient.h"

#if ENABLE(MEDIA_SOURCE)

namespace Telescope
{
    Ref<TelescopeSourceBufferPrivate> TelescopeSourceBufferPrivate::create(TelescopeMediaSourcePrivate* pParent, const WebCore::ContentType& contentType)
    {
        return adoptRef(*new TelescopeSourceBufferPrivate(pParent, contentType));
    }

    TelescopeSourceBufferPrivate::TelescopeSourceBufferPrivate(TelescopeMediaSourcePrivate* pParent, const WebCore::ContentType& contentType)
        : m_pMediaSource(pParent)
#if !RELEASE_LOG_DISABLED
        , m_logger(Logger::create(this))
#endif
        , m_readyState(WebCore::MediaPlayer::ReadyState::HaveNothing)
        , m_contentType(contentType)
    {
    }

    TelescopeSourceBufferPrivate::~TelescopeSourceBufferPrivate()
    {
    }

    void TelescopeSourceBufferPrivate::setClient(WebCore::SourceBufferPrivateClient* pClient)
    {
        m_pClient = pClient;
    }

    void TelescopeSourceBufferPrivate::append(Vector<unsigned char>&& data)
    {
        m_pMediaSource->getPlayer()->appendData(WTFMove(data), m_contentType);
        m_pClient->sourceBufferPrivateAppendComplete(WebCore::SourceBufferPrivateClient::AppendSucceeded);
    }

    void TelescopeSourceBufferPrivate::abort()
    {
        notImplemented();
    }

    void TelescopeSourceBufferPrivate::resetParserState()
    {
        notImplemented();
    }

    void TelescopeSourceBufferPrivate::removedFromMediaSource()
    {
        // TODO: remove this source buffer from media source
        notImplemented();
    }

    WebCore::MediaPlayer::ReadyState TelescopeSourceBufferPrivate::readyState() const
    {
        return m_readyState;
    }

    void TelescopeSourceBufferPrivate::setReadyState(WebCore::MediaPlayer::ReadyState readyState)
    {
        m_readyState = readyState;
    }

    void TelescopeSourceBufferPrivate::flush(const AtomString&)
    {
        notImplemented();
    }

    void TelescopeSourceBufferPrivate::enqueueSample(Ref<WebCore::MediaSample>&&, const AtomString&)
    {
        notImplemented();
    }

    void TelescopeSourceBufferPrivate::allSamplesInTrackEnqueued(const AtomString&)
    {
        notImplemented();
    }

    bool TelescopeSourceBufferPrivate::isReadyForMoreSamples(const AtomString&)
    {
        return true;
    }

    void TelescopeSourceBufferPrivate::setActive(bool)
    {
        notImplemented();
    }

    void TelescopeSourceBufferPrivate::notifyClientWhenReadyForMoreSamples(const AtomString&)
    {
        notImplemented();
    }

    bool TelescopeSourceBufferPrivate::canSetMinimumUpcomingPresentationTime(const AtomString&) const
    {
        notImplemented();
        return false;
    }

    void TelescopeSourceBufferPrivate::setMinimumUpcomingPresentationTime(const AtomString&, const MediaTime&)
    {
        notImplemented();
    }

    void TelescopeSourceBufferPrivate::clearMinimumUpcomingPresentationTime(const AtomString&)
    {
        notImplemented();
    }

    bool TelescopeSourceBufferPrivate::canSwitchToType(const WebCore::ContentType&)
    {
        notImplemented();
        return false;
    }

    Vector<String> TelescopeSourceBufferPrivate::enqueuedSamplesForTrackID(const AtomString&)
    {
        notImplemented();
        return Vector<String>();
    }

    MediaTime TelescopeSourceBufferPrivate::minimumUpcomingPresentationTimeForTrackID(const AtomString&)
    {
        notImplemented();
        return MediaTime();
    }

    void TelescopeSourceBufferPrivate::setMaximumQueueDepthForTrackID(const AtomString&, size_t)
    {
        notImplemented();
    }

#if !RELEASE_LOG_DISABLED
    const Logger& TelescopeSourceBufferPrivate::sourceBufferLogger() const
    {
        return m_logger.get();
    }

    const void* TelescopeSourceBufferPrivate::sourceBufferLogIdentifier()
    {
        return this;
    }
#endif
}

#endif
