/*
 * Copyright (C) 2021 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "SourceBufferPrivate.h"

#if ENABLE(MEDIA_SOURCE)

namespace Telescope
{
	class TelescopeMediaSourcePrivate;

	class TelescopeSourceBufferPrivate final : public WebCore::SourceBufferPrivate, public CanMakeWeakPtr<TelescopeSourceBufferPrivate>
	{
		WTF_MAKE_FAST_ALLOCATED;

	public:
		static Ref<TelescopeSourceBufferPrivate> create(TelescopeMediaSourcePrivate*, const WebCore::ContentType&);
		~TelescopeSourceBufferPrivate();

        void setClient(WebCore::SourceBufferPrivateClient*) final;

        void append(Vector<unsigned char>&&) final;
        void abort() final;
        void resetParserState() final;
        void removedFromMediaSource() final;

        WebCore::MediaPlayer::ReadyState readyState() const final;
        void setReadyState(WebCore::MediaPlayer::ReadyState) final;

        void flush(const AtomString&) final;
        void enqueueSample(Ref<WebCore::MediaSample>&&, const AtomString&) final;
        void allSamplesInTrackEnqueued(const AtomString&) final;
        bool isReadyForMoreSamples(const AtomString&) final;
        void setActive(bool) final;
        void notifyClientWhenReadyForMoreSamples(const AtomString&) final;

        bool canSetMinimumUpcomingPresentationTime(const AtomString&) const final;
        void setMinimumUpcomingPresentationTime(const AtomString&, const MediaTime&) final;
        void clearMinimumUpcomingPresentationTime(const AtomString&) final;
        bool canSwitchToType(const WebCore::ContentType&) final;

        Vector<String> enqueuedSamplesForTrackID(const AtomString&) final;
        MediaTime minimumUpcomingPresentationTimeForTrackID(const AtomString&) final;
        void setMaximumQueueDepthForTrackID(const AtomString&, size_t) final;

#if !RELEASE_LOG_DISABLED
        const Logger& sourceBufferLogger() const final;
        const void* sourceBufferLogIdentifier() final;
#endif

    private:
        TelescopeSourceBufferPrivate(TelescopeMediaSourcePrivate*, const WebCore::ContentType&);

        TelescopeMediaSourcePrivate* m_pMediaSource;
        WebCore::SourceBufferPrivateClient* m_pClient = nullptr;
#if !RELEASE_LOG_DISABLED
        Ref<const Logger> m_logger;
#endif
        WebCore::MediaPlayer::ReadyState m_readyState;
        WebCore::ContentType m_contentType;
    };

}

#endif
