/*
 * Copyright (C) 2006-2017 Apple Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "WebEditorClient.h"

#include <WebCore/BString.h>
#include <WebCore/Document.h>
#include <WebCore/HTMLElement.h>
#include <WebCore/HTMLInputElement.h>
#include <WebCore/HTMLNames.h>
#include <WebCore/KeyboardEvent.h>
#include <WebCore/LocalizedStrings.h>
#include <WebCore/NotImplemented.h>
#include <WebCore/Page.h>
#include <WebCore/PlatformKeyboardEvent.h>
#include <WebCore/Range.h>
#include <WebCore/Settings.h>
#include <WebCore/UndoStep.h>
#include <WebCore/UserTypingGestureIndicator.h>
#include <WebCore/VisibleSelection.h>
#include <wtf/text/StringView.h>
#include "WebView.h"

using namespace WebCore;
using namespace HTMLNames;
using namespace Telescope;

bool WebEditorClient::m_bsEnableEditing = true;

WebEditorClient::WebEditorClient( WebView* webView )
    : m_webView( webView )
{
    m_bEditing = false;
}

WebEditorClient::~WebEditorClient()
{
}

bool WebEditorClient::isContinuousSpellCheckingEnabled()
{
    notImplemented();
    return false;
}

void WebEditorClient::toggleContinuousSpellChecking()
{
    notImplemented();
}

bool WebEditorClient::isGrammarCheckingEnabled()
{
    notImplemented();
    return false;
}

void WebEditorClient::toggleGrammarChecking()
{
    notImplemented();
}

int WebEditorClient::spellCheckerDocumentTag()
{
    // we don't use the concept of spelling tags
    notImplemented();
    ASSERT_NOT_REACHED();
    return 0;
}

bool WebEditorClient::shouldBeginEditing( WebCore::Range* range )
{
    notImplemented();
    return true;
}

bool WebEditorClient::shouldEndEditing( Range* range )
{
    notImplemented();
    return true;
}

void WebEditorClient::didBeginEditing()
{
    notImplemented();
    m_bEditing = true;
}

void WebEditorClient::respondToChangedContents()
{
    notImplemented();
}

void WebEditorClient::respondToChangedSelection( Frame* )
{
    notImplemented();
}

void WebEditorClient::discardedComposition( Frame* )
{
    notImplemented();
}

void WebEditorClient::canceledComposition()
{
    notImplemented();
}

void WebEditorClient::didEndEditing()
{
    notImplemented();
    m_bEditing = false;
}

void WebEditorClient::didWriteSelectionToPasteboard()
{
    notImplemented();
}

void WebEditorClient::willWriteSelectionToPasteboard( WebCore::Range* )
{
    notImplemented();
}

void WebEditorClient::getClientPasteboardDataForRange( WebCore::Range*, Vector<String>&, Vector<RefPtr<WebCore::SharedBuffer> >& )
{
    notImplemented();
}

bool WebEditorClient::shouldDeleteRange( Range* range )
{
    notImplemented();

    return true;
}

bool WebEditorClient::shouldInsertNode( Node* node, Range* insertingRange, EditorInsertAction givenAction )
{
    notImplemented();
    return m_bsEnableEditing;
}

bool WebEditorClient::shouldInsertText( const String& str, Range* insertingRange, EditorInsertAction givenAction )
{
    notImplemented();
    return m_bsEnableEditing;
}

bool WebEditorClient::shouldChangeSelectedRange( WebCore::Range* currentRange, WebCore::Range* proposedRange, WebCore::EAffinity selectionAffinity, bool flag )
{
    notImplemented();
    return m_bsEnableEditing;
}

bool WebEditorClient::shouldApplyStyle( StyleProperties*, Range* )
{
    notImplemented();
    return m_bsEnableEditing;
}

void WebEditorClient::didApplyStyle()
{
    notImplemented();
}

bool WebEditorClient::shouldMoveRangeAfterDelete( Range*, Range* )
{
    notImplemented();
    return true;
}

bool WebEditorClient::smartInsertDeleteEnabled( void )
{
    notImplemented();
    return false;
}

bool WebEditorClient::isSelectTrailingWhitespaceEnabled( void ) const
{
    notImplemented();
    return false;
}

void WebEditorClient::textFieldDidBeginEditing( Element* e )
{
    notImplemented();
    m_bEditing = true;
}

void WebEditorClient::textFieldDidEndEditing( Element* e )
{
    notImplemented();
    m_bEditing = false;
}

void WebEditorClient::textDidChangeInTextField( Element* e )
{
    notImplemented();
}

bool WebEditorClient::doTextFieldCommandFromEvent( Element* e, KeyboardEvent* ke )
{
    notImplemented();
    return false;
}

void WebEditorClient::textWillBeDeletedInTextField( Element* e )
{
    notImplemented();
}

void WebEditorClient::textDidChangeInTextArea( Element* e )
{
    notImplemented();
}


void WebEditorClient::registerUndoStep( UndoStep& step )
{
    notImplemented();
}

void WebEditorClient::registerRedoStep( UndoStep& step )
{
    notImplemented();
}

void WebEditorClient::clearUndoRedoOperations()
{
    notImplemented();
}

bool WebEditorClient::canCopyCut( Frame*, bool defaultValue ) const
{
    notImplemented();
    return defaultValue;
}

bool WebEditorClient::canPaste( Frame*, bool defaultValue ) const
{
    notImplemented();
    return defaultValue;
}

bool WebEditorClient::canUndo() const
{
    notImplemented();
    return false;
}

bool WebEditorClient::canRedo() const
{
    return false;
}

void WebEditorClient::undo()
{
    notImplemented();
}

void WebEditorClient::redo()
{
    notImplemented();
}

void WebEditorClient::handleKeyboardEvent( KeyboardEvent& event )
{
    if ( m_webView->handleEditingKeyboardEvent( &event ) )
        event.setDefaultHandled();
}

void WebEditorClient::handleInputMethodKeydown( KeyboardEvent& )
{
}

bool WebEditorClient::shouldEraseMarkersAfterChangeSelection( TextCheckingType ) const
{
    return true;
}

void WebEditorClient::ignoreWordInSpellDocument( const String& word )
{
    notImplemented();
}

void WebEditorClient::learnWord( const String& word )
{
    notImplemented();
}

void WebEditorClient::checkSpellingOfString( StringView text, int* misspellingLocation, int* misspellingLength )
{
    notImplemented();
}

String WebEditorClient::getAutoCorrectSuggestionForMisspelledWord( const String& inputWord )
{
    // This method can be implemented using customized algorithms for the particular browser.
    // Currently, it computes an empty string.
    return String();
}

void WebEditorClient::checkGrammarOfString( StringView text, Vector<GrammarDetail>& details, int* badGrammarLocation, int* badGrammarLength )
{
    notImplemented();
}

void WebEditorClient::updateSpellingUIWithGrammarString( const String& string, const WebCore::GrammarDetail& detail )
{
    notImplemented();
}

void WebEditorClient::updateSpellingUIWithMisspelledWord( const String& word )
{
    notImplemented();
}

void WebEditorClient::showSpellingUI( bool show )
{
    notImplemented();
}

bool WebEditorClient::spellingUIIsShowing()
{
    notImplemented();
    return false;
}

void WebEditorClient::getGuessesForWord( const String& word, const String& context, const VisibleSelection&, Vector<String>& guesses )
{
}

void WebEditorClient::willSetInputMethodState()
{
}

void WebEditorClient::setInputMethodState( WebCore::Element* element )
{
}
