/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <zlib.h>

class CompressionWrapperBase
{
public:
	virtual ~CompressionWrapperBase()
	{
	}
	virtual int deflate( z_streamp strm, int flush ) = 0;

	virtual int deflateEnd( z_streamp strm ) = 0;

	virtual gzFile gzdopen( int fd, const char *mode ) = 0;

	virtual int gzread( gzFile file, voidp buf, unsigned len ) = 0;

	virtual int gzwrite( gzFile file, voidpc buf, unsigned len ) = 0;

	virtual int gzdirect( gzFile file ) = 0;

	virtual int gzclose( gzFile file ) = 0;

	virtual uLong crc32( uLong crc, const Bytef *buf, uInt len ) = 0;

	virtual int deflateInit2_( z_streamp strm, int level, int method,
		int windowBits, int memLevel,
		int strategy ) = 0;

	virtual gzFile gzopen( const char *, const char * ) = 0;

	virtual int inflate( z_streamp z, int f ) = 0;

	virtual int inflateEnd( z_streamp z ) = 0;

	virtual int inflateInit2_( z_streamp z, int w ) = 0;

	virtual int uncompress( Bytef *dest, uLongf *destLen,
		const Bytef *source, uLong sourceLen ) = 0;

	virtual uLong deflateBound( z_streamp strm, uLong sourceLen ) = 0;

	virtual int inflateReset( z_streamp z ) = 0;

	virtual int deflateReset( z_streamp strm ) = 0;

	virtual int inflateReset2( z_streamp strm, int windowBits ) = 0;

	virtual uLong adler32( uLong adler, const Bytef *buf, uInt len ) = 0;
};