/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef WEBKIT_H_INCLUDE
#define WEBKIT_H_INCLUDE

namespace Telescope
{
#ifdef SONY_PLATFORM
#define WebURLErrorDomain	  "CFURLErrorDomain"
#define WebKitErrorDomain	  "WebKitErrorDomain"
#define WebErrorFailingURLKey "WebErrorFailingURLKey"
#else // #ifdef SONY_PLATFORM
#define WebURLErrorDomain	  TEXT( "CFURLErrorDomain" )
#define WebKitErrorDomain	  TEXT( "WebKitErrorDomain" )
#define WebErrorFailingURLKey TEXT( "WebErrorFailingURLKey" )
#endif // #else // #ifdef SONY_PLATFORM

enum WebUrlError
{
	WebURLErrorUnknown = -1,
	WebURLErrorCancelled = -999,
	WebURLErrorBadURL = -1000,
	WebURLErrorTimedOut = -1001,
	WebURLErrorUnsupportedURL = -1002,
	WebURLErrorCannotFindHost = -1003,
	WebURLErrorCannotConnectToHost = -1004,
	WebURLErrorNetworkConnectionLost = -1005,
	WebURLErrorDNSLookupFailed = -1006,
	WebURLErrorHTTPTooManyRedirects = -1007,
	WebURLErrorResourceUnavailable = -1008,
	WebURLErrorNotConnectedToInternet = -1009,
	WebURLErrorRedirectToNonExistentLocation = -1010,
	WebURLErrorBadServerResponse = -1011,
	WebURLErrorUserCancelledAuthentication = -1012,
	WebURLErrorUserAuthenticationRequired = -1013,
	WebURLErrorZeroByteResource = -1014,
	WebURLErrorFileDoesNotExist = -1100,
	WebURLErrorFileIsDirectory = -1101,
	WebURLErrorNoPermissionsToReadFile = -1102,
	WebURLErrorSecureConnectionFailed = -1200,
	WebURLErrorServerCertificateHasBadDate = -1201,
	WebURLErrorServerCertificateUntrusted = -1202,
	WebURLErrorServerCertificateHasUnknownRoot = -1203,
	WebURLErrorServerCertificateNotYetValid = -1204,
	WebURLErrorClientCertificateRejected = -1205,
	WebURLErrorClientCertificateRequired = -1206,
	WebURLErrorCannotLoadFromNetwork = -2000,
	WebURLErrorCannotCreateFile = -3000,
	WebURLErrorCannotOpenFile = -3001,
	WebURLErrorCannotCloseFile = -3002,
	WebURLErrorCannotWriteToFile = -3003,
	WebURLErrorCannotRemoveFile = -3004,
	WebURLErrorCannotMoveFile = -3005,
	WebURLErrorDownloadDecodingFailedMidStream = -3006,
	WebURLErrorDownloadDecodingFailedToComplete = -3007
};

enum WebKitError
{
	WebKitErrorCannotShowMIMEType = 100,
	WebKitErrorCannotShowURL = 101,
	WebKitErrorFrameLoadInterruptedByPolicyChange = 102,
	WebKitErrorCannotUseRestrictedPort = 103
};

#define WebKitErrorPlugInCancelledConnection 203
// FIXME: WebKitErrorPlugInWillHandleLoad is used for the cancel we do to prevent loading plugin content twice.  See <rdar://problem/4258008>
#define WebKitErrorPlugInWillHandleLoad 204
#define WEBKIT_MAJOR_VERSION			610
#define WEBKIT_MINOR_VERSION			1
} // namespace Telescope
#endif // #ifndef WEBKIT_H_INCLUDE