/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef WEBVIEW_H_INCLUDE
#define WEBVIEW_H_INCLUDE

#include "TelescopeViewParameter.h"
#include "ClientWrappers/MemoryAllocatorBase.h"
#include "TelescopeOperation.h"
#include "TelescopeJavascriptValue.h"
#include "TelescopeJSBoundObject.h"

namespace WebCore
{
class ResourceRequest;
class IntRect;
class KeyboardEvent;
class GraphicsLayer;
class HTMLVideoElement;
} // namespace WebCore

namespace Telescope
{
namespace WebKit
{
class IJSBoundObject;
}
} // namespace Telescope

namespace Telescope
{

class HardwareSurfaceBase;

class WebView
{
public:
	friend class ViewIME;

	explicit WebView();
	virtual ~WebView();

	virtual bool InitView( const ViewParameters &param );
	virtual void ShutdownView( void );

	virtual bool Paint();
	virtual void SetURI( const wchar_t *url );
	virtual void SetURI( const char *url );
	virtual void GetBuffer( void *&buffer, int &bufferSize );
	virtual void SetSize( int width, int height );
	virtual int Width() const;
	virtual int Height() const;

	virtual Telescope::IOperation *GetOperationInterface();
	virtual WebCore::Frame *TopLevelFrame();

	WebCore::IntRect *windowRect();
	static bool canHandleRequest( const WebCore::ResourceRequest * );
	bool transparent() const;
	void setTransparent( bool bTransparent );
	void enterVideoFullscreenForVideoElement();
	void exitVideoFullscreenForVideoElement();

	virtual void Refresh( bool ignoreCache );
	virtual void BindJavaScriptObject( const char *name, Telescope::IJSBoundObject *obj );
	virtual void RebindJavaScriptObject();
	virtual TelescopeJSValue *CreateJavaScriptValue();
	virtual void DestroyJavascriptValue( TelescopeJSValue *v );

	virtual void OnIMEMsg( unsigned int message, unsigned long long wParam, long long lParam );
	virtual void SetHWND( void *wnd );

	const char *interpretKeyEvent( const WebCore::KeyboardEvent * );
	bool handleEditingKeyboardEvent( WebCore::KeyboardEvent * );
	void AddDirtyRegion( const WebCore::IntRect *region );

	void flushPendingGraphicsLayerChangesSoon();
	void SetRootChildLayer( WebCore::GraphicsLayer *layer );

	virtual bool isAcceleratedCompositing() const;
	virtual const HardwareSurfaceBase *GetViewHardwareSurface() const;
	virtual void ToggleDevGUI( bool enable );

private:
	void ApplyTelescopeDefaultSettings();
	void PaintRegion( const WebCore::IntRect *region );

	void SetAcceleratedCompositing( bool accelerated );

	struct ViewPrivate *d;
	class ViewIME *ime;
};
} // namespace Telescope
#endif // #ifndef WEBVIEW_H_INCLUDE