// © 2016 and later: Unicode, Inc. and others.
// License & terms of use: http://www.unicode.org/copyright.html
/*
******************************************************************************
*
*   Copyright (C) 1999-2013, International Business Machines
*   Corporation and others.  All Rights Reserved.
*
******************************************************************************/


/*----------------------------------------------------------------------------
 *
 *       Memory mapped file wrappers for use by the ICU Data Implementation
 *       All of the platform-specific implementation for mapping data files
 *         is here.  The rest of the ICU Data implementation uses only the
 *         wrapper functions.
 *
 *----------------------------------------------------------------------------*/
/* Defines _XOPEN_SOURCE for access to POSIX functions.
 * Must be before any other #includes. */
#include "uposixdefs.h"

#include "unicode/putil.h"
#include "unicode/ustring.h"
#include "udatamem.h"
#include "umapfile.h"

//+TELESCOPE_LIB_CHANGES
// 2020-07-22
// Telescope should not have any I/O operation. If it really wants to get binary data from outside. Host engine should handle it. Telescope should not take care of how host engine process the way of access the file, maybe it was loaded with other element at the beginning of host engine starts up. So Telescope only accepts the binary which is finished processing by host engine regardless how host engine file access behavior.
// Changes:
// 1. umapfile.cpp: Disable ICU umapfile which access the file by using memory map file.
// 2. Adding OpenFileWrapperBase.h as the interface of access binaries.
// 3. TelescopeLib.h: adding openFileImpl into TelescopeConfig, host engine must pass the implementation when initializes.
extern bool Customize_MmapFile( const char* fileName, void* &outHandle, char* &outBuffer, size_t &outBufferSize );
extern void Customize_UnmapFile( void* handle, char* buffer );

U_CFUNC UBool uprv_mapFile( UDataMemory* pData, const char* path, UErrorCode* status )
{
	if( U_FAILURE( *status ) )
		return FALSE;

	void* handle;
	char* address;
	size_t length;

	bool success = Customize_MmapFile( path, handle, address, length );
	if( success )
	{
		pData->pHeader = (const DataHeader*)address;
		pData->mapAddr = address;
		pData->map = handle;
		pData->length = length;
		return TRUE;
	}
	return FALSE;
}

U_CFUNC void uprv_unmapFile( UDataMemory* pData )
{
	Customize_UnmapFile( pData->map, reinterpret_cast<char*>(pData->mapAddr) );
	pData->pHeader = nullptr;
	pData->mapAddr = nullptr;
	pData->map = nullptr;
}

//-TELESCOPE_LIB_CHANGES
