//  SHA1Hash: 81a389480327b85689eda08c7f0dfeaec449e66b
/*
 * Copyright (C) 2020 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 * Autogenerated, do not modify.
*/

#include "config.h"
#include "BytecodeDumper.h"

#include "BytecodeStructs.h"

namespace JSC {

void dumpBytecode(BytecodeDumperBase* dumper, InstructionStream::Offset __location, const Instruction* __instruction)
{
    switch (__instruction->opcodeID<JSOpcodeTraits>()) {
    case op_has_indexed_property:
        __instruction->as<OpHasIndexedProperty, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_profile_control_flow:
        __instruction->as<OpProfileControlFlow, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_profile_type:
        __instruction->as<OpProfileType, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_catch:
        __instruction->as<OpCatch, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_get_from_arguments:
        __instruction->as<OpGetFromArguments, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_put_to_scope:
        __instruction->as<OpPutToScope, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_get_from_scope:
        __instruction->as<OpGetFromScope, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_get_internal_field:
        __instruction->as<OpGetInternalField, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_create_this:
        __instruction->as<OpCreateThis, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_create_promise:
        __instruction->as<OpCreatePromise, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_resolve_scope:
        __instruction->as<OpResolveScope, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_construct_varargs:
        __instruction->as<OpConstructVarargs, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_create_generator:
        __instruction->as<OpCreateGenerator, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_create_async_generator:
        __instruction->as<OpCreateAsyncGenerator, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_get_argument:
        __instruction->as<OpGetArgument, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_construct:
        __instruction->as<OpConstruct, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_to_this:
        __instruction->as<OpToThis, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_tail_call_forward_arguments:
        __instruction->as<OpTailCallForwardArguments, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_new_object:
        __instruction->as<OpNewObject, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_new_array:
        __instruction->as<OpNewArray, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_new_array_with_size:
        __instruction->as<OpNewArrayWithSize, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_new_array_buffer:
        __instruction->as<OpNewArrayBuffer, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_tail_call_varargs:
        __instruction->as<OpTailCallVarargs, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_call_varargs:
        __instruction->as<OpCallVarargs, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_call_eval:
        __instruction->as<OpCallEval, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_tail_call:
        __instruction->as<OpTailCall, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_call:
        __instruction->as<OpCall, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jneq_ptr:
        __instruction->as<OpJneqPtr, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_put_by_val_direct:
        __instruction->as<OpPutByValDirect, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_put_by_val:
        __instruction->as<OpPutByVal, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_get_by_val:
        __instruction->as<OpGetByVal, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_get_direct_pname:
        __instruction->as<OpGetDirectPname, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_put_by_id:
        __instruction->as<OpPutById, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_try_get_by_id:
        __instruction->as<OpTryGetById, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_get_by_id_direct:
        __instruction->as<OpGetByIdDirect, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_get_by_val_with_this:
        __instruction->as<OpGetByValWithThis, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_get_by_id_with_this:
        __instruction->as<OpGetByIdWithThis, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_get_by_id:
        __instruction->as<OpGetById, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_in_by_val:
        __instruction->as<OpInByVal, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_add:
        __instruction->as<OpAdd, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_mul:
        __instruction->as<OpMul, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_div:
        __instruction->as<OpDiv, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_sub:
        __instruction->as<OpSub, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_bitand:
        __instruction->as<OpBitand, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_bitor:
        __instruction->as<OpBitor, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_bitxor:
        __instruction->as<OpBitxor, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_lshift:
        __instruction->as<OpLshift, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_rshift:
        __instruction->as<OpRshift, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_bitnot:
        __instruction->as<OpBitnot, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_negate:
        __instruction->as<OpNegate, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_to_numeric:
        __instruction->as<OpToNumeric, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_to_number:
        __instruction->as<OpToNumber, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_to_object:
        __instruction->as<OpToObject, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_dec:
        __instruction->as<OpDec, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_inc:
        __instruction->as<OpInc, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_is_undefined_or_null:
        __instruction->as<OpIsUndefinedOrNull, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_is_boolean:
        __instruction->as<OpIsBoolean, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_is_number:
        __instruction->as<OpIsNumber, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_is_object:
        __instruction->as<OpIsObject, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_is_object_or_null:
        __instruction->as<OpIsObjectOrNull, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_is_function:
        __instruction->as<OpIsFunction, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_is_undefined:
        __instruction->as<OpIsUndefined, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_is_empty:
        __instruction->as<OpIsEmpty, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_unsigned:
        __instruction->as<OpUnsigned, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_to_string:
        __instruction->as<OpToString, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_neq_null:
        __instruction->as<OpNeqNull, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_eq_null:
        __instruction->as<OpEqNull, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_not:
        __instruction->as<OpNot, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_identity_with_profile:
        __instruction->as<OpIdentityWithProfile, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_overrides_has_instance:
        __instruction->as<OpOverridesHasInstance, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_instanceof:
        __instruction->as<OpInstanceof, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_instanceof_custom:
        __instruction->as<OpInstanceofCustom, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_typeof:
        __instruction->as<OpTypeof, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_is_cell_with_type:
        __instruction->as<OpIsCellWithType, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_urshift:
        __instruction->as<OpUrshift, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_in_by_id:
        __instruction->as<OpInById, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_pow:
        __instruction->as<OpPow, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_mod:
        __instruction->as<OpMod, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_beloweq:
        __instruction->as<OpBeloweq, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_below:
        __instruction->as<OpBelow, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_greatereq:
        __instruction->as<OpGreatereq, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_greater:
        __instruction->as<OpGreater, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_lesseq:
        __instruction->as<OpLesseq, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_del_by_id:
        __instruction->as<OpDelById, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_less:
        __instruction->as<OpLess, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_nstricteq:
        __instruction->as<OpNstricteq, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_put_by_val_with_this:
        __instruction->as<OpPutByValWithThis, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_stricteq:
        __instruction->as<OpStricteq, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_del_by_val:
        __instruction->as<OpDelByVal, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_put_getter_by_id:
        __instruction->as<OpPutGetterById, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_put_setter_by_id:
        __instruction->as<OpPutSetterById, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_put_getter_setter_by_id:
        __instruction->as<OpPutGetterSetterById, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_put_getter_by_val:
        __instruction->as<OpPutGetterByVal, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_put_setter_by_val:
        __instruction->as<OpPutSetterByVal, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_define_data_property:
        __instruction->as<OpDefineDataProperty, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_define_accessor_property:
        __instruction->as<OpDefineAccessorProperty, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jmp:
        __instruction->as<OpJmp, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jtrue:
        __instruction->as<OpJtrue, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jfalse:
        __instruction->as<OpJfalse, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jeq_null:
        __instruction->as<OpJeqNull, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jneq_null:
        __instruction->as<OpJneqNull, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jundefined_or_null:
        __instruction->as<OpJundefinedOrNull, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jnundefined_or_null:
        __instruction->as<OpJnundefinedOrNull, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_neq:
        __instruction->as<OpNeq, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jeq:
        __instruction->as<OpJeq, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jstricteq:
        __instruction->as<OpJstricteq, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jneq:
        __instruction->as<OpJneq, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jnstricteq:
        __instruction->as<OpJnstricteq, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jless:
        __instruction->as<OpJless, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jlesseq:
        __instruction->as<OpJlesseq, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jgreater:
        __instruction->as<OpJgreater, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jgreatereq:
        __instruction->as<OpJgreatereq, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jnless:
        __instruction->as<OpJnless, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jnlesseq:
        __instruction->as<OpJnlesseq, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jngreater:
        __instruction->as<OpJngreater, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jngreatereq:
        __instruction->as<OpJngreatereq, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jbelow:
        __instruction->as<OpJbelow, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_jbeloweq:
        __instruction->as<OpJbeloweq, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_loop_hint:
        __instruction->as<OpLoopHint, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_switch_imm:
        __instruction->as<OpSwitchImm, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_switch_char:
        __instruction->as<OpSwitchChar, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_switch_string:
        __instruction->as<OpSwitchString, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_new_func:
        __instruction->as<OpNewFunc, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_new_func_exp:
        __instruction->as<OpNewFuncExp, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_new_generator_func:
        __instruction->as<OpNewGeneratorFunc, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_new_generator_func_exp:
        __instruction->as<OpNewGeneratorFuncExp, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_new_async_func:
        __instruction->as<OpNewAsyncFunc, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_new_async_func_exp:
        __instruction->as<OpNewAsyncFuncExp, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_new_async_generator_func:
        __instruction->as<OpNewAsyncGeneratorFunc, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_new_async_generator_func_exp:
        __instruction->as<OpNewAsyncGeneratorFuncExp, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_set_function_name:
        __instruction->as<OpSetFunctionName, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_eq:
        __instruction->as<OpEq, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_mov:
        __instruction->as<OpMov, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_new_regexp:
        __instruction->as<OpNewRegexp, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_spread:
        __instruction->as<OpSpread, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_new_array_with_spread:
        __instruction->as<OpNewArrayWithSpread, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_check_tdz:
        __instruction->as<OpCheckTdz, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_argument_count:
        __instruction->as<OpArgumentCount, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_new_generator:
        __instruction->as<OpNewGenerator, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_ret:
        __instruction->as<OpRet, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_strcat:
        __instruction->as<OpStrcat, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_to_primitive:
        __instruction->as<OpToPrimitive, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_to_property_key:
        __instruction->as<OpToPropertyKey, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_new_promise:
        __instruction->as<OpNewPromise, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_create_arguments_butterfly:
        __instruction->as<OpCreateArgumentsButterfly, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_create_cloned_arguments:
        __instruction->as<OpCreateClonedArguments, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_create_scoped_arguments:
        __instruction->as<OpCreateScopedArguments, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_put_to_arguments:
        __instruction->as<OpPutToArguments, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_push_with_scope:
        __instruction->as<OpPushWithScope, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_create_lexical_environment:
        __instruction->as<OpCreateLexicalEnvironment, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_create_generator_frame_environment:
        __instruction->as<OpCreateGeneratorFrameEnvironment, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_get_parent_scope:
        __instruction->as<OpGetParentScope, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_create_direct_arguments:
        __instruction->as<OpCreateDirectArguments, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_throw:
        __instruction->as<OpThrow, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_throw_static_error:
        __instruction->as<OpThrowStaticError, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_debug:
        __instruction->as<OpDebug, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_end:
        __instruction->as<OpEnd, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_get_scope:
        __instruction->as<OpGetScope, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_enter:
        __instruction->as<OpEnter, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_get_enumerable_length:
        __instruction->as<OpGetEnumerableLength, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_wide32:
        __instruction->as<OpWide32, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_has_structure_property:
        __instruction->as<OpHasStructureProperty, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_has_generic_property:
        __instruction->as<OpHasGenericProperty, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_put_by_id_with_this:
        __instruction->as<OpPutByIdWithThis, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_get_property_enumerator:
        __instruction->as<OpGetPropertyEnumerator, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_enumerator_structure_pname:
        __instruction->as<OpEnumeratorStructurePname, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_enumerator_generic_pname:
        __instruction->as<OpEnumeratorGenericPname, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_to_index_string:
        __instruction->as<OpToIndexString, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_unreachable:
        __instruction->as<OpUnreachable, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_create_rest:
        __instruction->as<OpCreateRest, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_get_rest_length:
        __instruction->as<OpGetRestLength, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_yield:
        __instruction->as<OpYield, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_check_traps:
        __instruction->as<OpCheckTraps, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_log_shadow_chicken_prologue:
        __instruction->as<OpLogShadowChickenPrologue, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_log_shadow_chicken_tail:
        __instruction->as<OpLogShadowChickenTail, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_resolve_scope_for_hoisting_func_decl_in_eval:
        __instruction->as<OpResolveScopeForHoistingFuncDeclInEval, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_wide16:
        __instruction->as<OpWide16, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_put_internal_field:
        __instruction->as<OpPutInternalField, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_nop:
        __instruction->as<OpNop, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_super_sampler_begin:
        __instruction->as<OpSuperSamplerBegin, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    case op_super_sampler_end:
        __instruction->as<OpSuperSamplerEnd, JSOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<JSOpcodeTraits>());
        break;
    default:
        ASSERT_NOT_REACHED();
    }
}

#if ENABLE(WEBASSEMBLY)
void dumpWasm(BytecodeDumperBase* dumper, InstructionStream::Offset __location, const Instruction* __instruction)
{
    switch (__instruction->opcodeID<WasmOpcodeTraits>()) {
    case wasm_i32_add:
        __instruction->as<WasmI32Add, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_sub:
        __instruction->as<WasmI32Sub, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_mul:
        __instruction->as<WasmI32Mul, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_div_s:
        __instruction->as<WasmI32DivS, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_div_u:
        __instruction->as<WasmI32DivU, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_rem_s:
        __instruction->as<WasmI32RemS, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_rem_u:
        __instruction->as<WasmI32RemU, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_and:
        __instruction->as<WasmI32And, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_or:
        __instruction->as<WasmI32Or, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_xor:
        __instruction->as<WasmI32Xor, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_shl:
        __instruction->as<WasmI32Shl, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_shr_u:
        __instruction->as<WasmI32ShrU, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_shr_s:
        __instruction->as<WasmI32ShrS, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_rotr:
        __instruction->as<WasmI32Rotr, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_rotl:
        __instruction->as<WasmI32Rotl, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_eq:
        __instruction->as<WasmI32Eq, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_ne:
        __instruction->as<WasmI32Ne, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_lt_s:
        __instruction->as<WasmI32LtS, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_le_s:
        __instruction->as<WasmI32LeS, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_lt_u:
        __instruction->as<WasmI32LtU, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_le_u:
        __instruction->as<WasmI32LeU, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_gt_s:
        __instruction->as<WasmI32GtS, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_ge_s:
        __instruction->as<WasmI32GeS, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_gt_u:
        __instruction->as<WasmI32GtU, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_ge_u:
        __instruction->as<WasmI32GeU, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_clz:
        __instruction->as<WasmI32Clz, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_ctz:
        __instruction->as<WasmI32Ctz, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_popcnt:
        __instruction->as<WasmI32Popcnt, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_eqz:
        __instruction->as<WasmI32Eqz, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_add:
        __instruction->as<WasmI64Add, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_sub:
        __instruction->as<WasmI64Sub, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_mul:
        __instruction->as<WasmI64Mul, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_div_s:
        __instruction->as<WasmI64DivS, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_div_u:
        __instruction->as<WasmI64DivU, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_rem_s:
        __instruction->as<WasmI64RemS, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_rem_u:
        __instruction->as<WasmI64RemU, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_and:
        __instruction->as<WasmI64And, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_or:
        __instruction->as<WasmI64Or, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_xor:
        __instruction->as<WasmI64Xor, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_shl:
        __instruction->as<WasmI64Shl, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_shr_u:
        __instruction->as<WasmI64ShrU, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_shr_s:
        __instruction->as<WasmI64ShrS, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_rotr:
        __instruction->as<WasmI64Rotr, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_rotl:
        __instruction->as<WasmI64Rotl, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_eq:
        __instruction->as<WasmI64Eq, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_ne:
        __instruction->as<WasmI64Ne, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_lt_s:
        __instruction->as<WasmI64LtS, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_le_s:
        __instruction->as<WasmI64LeS, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_lt_u:
        __instruction->as<WasmI64LtU, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_le_u:
        __instruction->as<WasmI64LeU, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_gt_s:
        __instruction->as<WasmI64GtS, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_ge_s:
        __instruction->as<WasmI64GeS, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_gt_u:
        __instruction->as<WasmI64GtU, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_ge_u:
        __instruction->as<WasmI64GeU, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_clz:
        __instruction->as<WasmI64Clz, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_ctz:
        __instruction->as<WasmI64Ctz, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_popcnt:
        __instruction->as<WasmI64Popcnt, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_eqz:
        __instruction->as<WasmI64Eqz, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_add:
        __instruction->as<WasmF32Add, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_sub:
        __instruction->as<WasmF32Sub, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_mul:
        __instruction->as<WasmF32Mul, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_div:
        __instruction->as<WasmF32Div, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_min:
        __instruction->as<WasmF32Min, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_max:
        __instruction->as<WasmF32Max, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_abs:
        __instruction->as<WasmF32Abs, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_neg:
        __instruction->as<WasmF32Neg, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_copysign:
        __instruction->as<WasmF32Copysign, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_ceil:
        __instruction->as<WasmF32Ceil, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_floor:
        __instruction->as<WasmF32Floor, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_trunc:
        __instruction->as<WasmF32Trunc, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_nearest:
        __instruction->as<WasmF32Nearest, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_sqrt:
        __instruction->as<WasmF32Sqrt, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_eq:
        __instruction->as<WasmF32Eq, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_ne:
        __instruction->as<WasmF32Ne, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_lt:
        __instruction->as<WasmF32Lt, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_le:
        __instruction->as<WasmF32Le, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_gt:
        __instruction->as<WasmF32Gt, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_ge:
        __instruction->as<WasmF32Ge, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_add:
        __instruction->as<WasmF64Add, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_sub:
        __instruction->as<WasmF64Sub, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_mul:
        __instruction->as<WasmF64Mul, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_div:
        __instruction->as<WasmF64Div, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_min:
        __instruction->as<WasmF64Min, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_max:
        __instruction->as<WasmF64Max, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_abs:
        __instruction->as<WasmF64Abs, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_neg:
        __instruction->as<WasmF64Neg, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_copysign:
        __instruction->as<WasmF64Copysign, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_ceil:
        __instruction->as<WasmF64Ceil, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_floor:
        __instruction->as<WasmF64Floor, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_trunc:
        __instruction->as<WasmF64Trunc, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_nearest:
        __instruction->as<WasmF64Nearest, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_sqrt:
        __instruction->as<WasmF64Sqrt, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_eq:
        __instruction->as<WasmF64Eq, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_ne:
        __instruction->as<WasmF64Ne, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_lt:
        __instruction->as<WasmF64Lt, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_le:
        __instruction->as<WasmF64Le, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_gt:
        __instruction->as<WasmF64Gt, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_ge:
        __instruction->as<WasmF64Ge, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_trunc_s_f32:
        __instruction->as<WasmI32TruncSF32, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_trunc_s_f64:
        __instruction->as<WasmI32TruncSF64, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_trunc_u_f32:
        __instruction->as<WasmI32TruncUF32, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_trunc_u_f64:
        __instruction->as<WasmI32TruncUF64, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_wrap_i64:
        __instruction->as<WasmI32WrapI64, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_trunc_s_f32:
        __instruction->as<WasmI64TruncSF32, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_trunc_s_f64:
        __instruction->as<WasmI64TruncSF64, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_trunc_u_f32:
        __instruction->as<WasmI64TruncUF32, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_trunc_u_f64:
        __instruction->as<WasmI64TruncUF64, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_extend_s_i32:
        __instruction->as<WasmI64ExtendSI32, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_extend_u_i32:
        __instruction->as<WasmI64ExtendUI32, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_convert_s_i32:
        __instruction->as<WasmF32ConvertSI32, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_convert_u_i32:
        __instruction->as<WasmF32ConvertUI32, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_convert_s_i64:
        __instruction->as<WasmF32ConvertSI64, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_convert_u_i64:
        __instruction->as<WasmF32ConvertUI64, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_demote_f64:
        __instruction->as<WasmF32DemoteF64, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f32_reinterpret_i32:
        __instruction->as<WasmF32ReinterpretI32, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_convert_s_i32:
        __instruction->as<WasmF64ConvertSI32, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_convert_u_i32:
        __instruction->as<WasmF64ConvertUI32, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_convert_s_i64:
        __instruction->as<WasmF64ConvertSI64, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_convert_u_i64:
        __instruction->as<WasmF64ConvertUI64, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_promote_f32:
        __instruction->as<WasmF64PromoteF32, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_f64_reinterpret_i64:
        __instruction->as<WasmF64ReinterpretI64, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_reinterpret_f32:
        __instruction->as<WasmI32ReinterpretF32, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_reinterpret_f64:
        __instruction->as<WasmI64ReinterpretF64, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_throw_from_slow_path_trampoline:
        __instruction->as<WasmThrowFromSlowPathTrampoline, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_wide16:
        __instruction->as<WasmWide16, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_wide32:
        __instruction->as<WasmWide32, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_enter:
        __instruction->as<WasmEnter, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_nop:
        __instruction->as<WasmNop, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_loop_hint:
        __instruction->as<WasmLoopHint, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_mov:
        __instruction->as<WasmMov, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_jtrue:
        __instruction->as<WasmJtrue, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_jfalse:
        __instruction->as<WasmJfalse, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_jmp:
        __instruction->as<WasmJmp, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_ret:
        __instruction->as<WasmRet, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_switch:
        __instruction->as<WasmSwitch, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_unreachable:
        __instruction->as<WasmUnreachable, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_ret_void:
        __instruction->as<WasmRetVoid, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_drop_keep:
        __instruction->as<WasmDropKeep, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_ref_is_null:
        __instruction->as<WasmRefIsNull, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_ref_func:
        __instruction->as<WasmRefFunc, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_get_global:
        __instruction->as<WasmGetGlobal, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_set_global:
        __instruction->as<WasmSetGlobal, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_set_global_ref:
        __instruction->as<WasmSetGlobalRef, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_get_global_portable_binding:
        __instruction->as<WasmGetGlobalPortableBinding, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_set_global_portable_binding:
        __instruction->as<WasmSetGlobalPortableBinding, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_set_global_ref_portable_binding:
        __instruction->as<WasmSetGlobalRefPortableBinding, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_table_get:
        __instruction->as<WasmTableGet, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_table_set:
        __instruction->as<WasmTableSet, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_table_size:
        __instruction->as<WasmTableSize, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_table_grow:
        __instruction->as<WasmTableGrow, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_table_fill:
        __instruction->as<WasmTableFill, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_call:
        __instruction->as<WasmCall, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_call_no_tls:
        __instruction->as<WasmCallNoTls, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_call_indirect:
        __instruction->as<WasmCallIndirect, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_call_indirect_no_tls:
        __instruction->as<WasmCallIndirectNoTls, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_current_memory:
        __instruction->as<WasmCurrentMemory, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_grow_memory:
        __instruction->as<WasmGrowMemory, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_select:
        __instruction->as<WasmSelect, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_load8_u:
        __instruction->as<WasmLoad8U, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_load16_u:
        __instruction->as<WasmLoad16U, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_load32_u:
        __instruction->as<WasmLoad32U, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_load64_u:
        __instruction->as<WasmLoad64U, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_load8_s:
        __instruction->as<WasmI32Load8S, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_load8_s:
        __instruction->as<WasmI64Load8S, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i32_load16_s:
        __instruction->as<WasmI32Load16S, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_load16_s:
        __instruction->as<WasmI64Load16S, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_i64_load32_s:
        __instruction->as<WasmI64Load32S, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_store8:
        __instruction->as<WasmStore8, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_store16:
        __instruction->as<WasmStore16, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_store32:
        __instruction->as<WasmStore32, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    case wasm_store64:
        __instruction->as<WasmStore64, WasmOpcodeTraits>().dump(dumper, __location, __instruction->sizeShiftAmount<WasmOpcodeTraits>());
        break;
    default:
        ASSERT_NOT_REACHED();
    }
}
#endif // ENABLE(WEBASSEMBLY)

} // namespace JSC
