/*
* Copyright (C) 2017-2019 Apple Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* 1.  Redistributions of source code must retain the above copyright
*     notice, this list of conditions and the following disclaimer.
* 2.  Redistributions in binary form must reproduce the above copyright
*     notice, this list of conditions and the following disclaimer in the
*     documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
* THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// DO NO EDIT! - This file was generated by JavaScriptCore/yarr/generateYarrUnicodePropertyTables.py
static std::unique_ptr<CharacterClass> createCharacterClass0()
{
    // Name = Any, number of codePoints: 1114112
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x00, 0x7f}}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0080, 0x10ffff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass1()
{
    // Name = ASCII, number of codePoints: 128
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x00, 0x7f}}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass2()
{
    // Name = Assigned, number of codePoints: 276955
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x00, 0x7f}}),
        std::initializer_list<UChar32>({0x038c, 0x085e, 0x09b2, 0x09d7, 0x0a3c, 0x0a51, 0x0a5e, 0x0ad0, 
                 0x0b9c, 0x0bd0, 0x0bd7, 0x0cde, 0x0dbd, 0x0dca, 0x0dd6, 0x0e84, 
                 0x0e8a, 0x0e8d, 0x0ea5, 0x0ea7, 0x0ec6, 0x10c7, 0x10cd, 0x1258, 
                 0x12c0, 0x1940, 0x1f59, 0x1f5b, 0x1f5d, 0x2d27, 0x2d2d, 0xfb3e, 
                 0xfeff, 0x101a0, 0x1056f, 0x10808, 0x1083c, 0x1093f, 0x110cd, 0x11288, 
                 0x11350, 0x11357, 0x1145b, 0x118ff, 0x11d3a, 0x1d4a2, 0x1d4bb, 0x1d546, 
                 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 0x1ee47, 0x1ee49, 0x1ee4b, 
                 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 0x1ee5f, 0x1ee64, 0x1ee7e, 
                 0x1f97a, 0xe0001}),
        std::initializer_list<CharacterRange>({{0x0080, 0x0377}, {0x037a, 0x037f}, {0x0384, 0x038a}, {0x038e, 0x03a1}, 
                 {0x03a3, 0x052f}, {0x0531, 0x0556}, {0x0559, 0x058a}, {0x058d, 0x058f}, 
                 {0x0591, 0x05c7}, {0x05d0, 0x05ea}, {0x05ef, 0x05f4}, {0x0600, 0x061c}, 
                 {0x061e, 0x070d}, {0x070f, 0x074a}, {0x074d, 0x07b1}, {0x07c0, 0x07fa}, 
                 {0x07fd, 0x082d}, {0x0830, 0x083e}, {0x0840, 0x085b}, {0x0860, 0x086a}, 
                 {0x08a0, 0x08b4}, {0x08b6, 0x08bd}, {0x08d3, 0x0983}, {0x0985, 0x098c}, 
                 {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, {0x09b6, 0x09b9}, 
                 {0x09bc, 0x09c4}, {0x09c7, 0x09c8}, {0x09cb, 0x09ce}, {0x09dc, 0x09dd}, 
                 {0x09df, 0x09e3}, {0x09e6, 0x09fe}, {0x0a01, 0x0a03}, {0x0a05, 0x0a0a}, 
                 {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, 
                 {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, 
                 {0x0a4b, 0x0a4d}, {0x0a59, 0x0a5c}, {0x0a66, 0x0a76}, {0x0a81, 0x0a83}, 
                 {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0}, 
                 {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0abc, 0x0ac5}, {0x0ac7, 0x0ac9}, 
                 {0x0acb, 0x0acd}, {0x0ae0, 0x0ae3}, {0x0ae6, 0x0af1}, {0x0af9, 0x0aff}, 
                 {0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, 
                 {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, {0x0b3c, 0x0b44}, 
                 {0x0b47, 0x0b48}, {0x0b4b, 0x0b4d}, {0x0b56, 0x0b57}, {0x0b5c, 0x0b5d}, 
                 {0x0b5f, 0x0b63}, {0x0b66, 0x0b77}, {0x0b82, 0x0b83}, {0x0b85, 0x0b8a}, 
                 {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9e, 0x0b9f}, 
                 {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, {0x0bbe, 0x0bc2}, 
                 {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd}, {0x0be6, 0x0bfa}, {0x0c00, 0x0c0c}, 
                 {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, {0x0c3d, 0x0c44}, 
                 {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56}, {0x0c58, 0x0c5a}, 
                 {0x0c60, 0x0c63}, {0x0c66, 0x0c6f}, {0x0c78, 0x0c8c}, {0x0c8e, 0x0c90}, 
                 {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0cbc, 0x0cc4}, 
                 {0x0cc6, 0x0cc8}, {0x0cca, 0x0ccd}, {0x0cd5, 0x0cd6}, {0x0ce0, 0x0ce3}, 
                 {0x0ce6, 0x0cef}, {0x0cf1, 0x0cf2}, {0x0d00, 0x0d03}, {0x0d05, 0x0d0c}, 
                 {0x0d0e, 0x0d10}, {0x0d12, 0x0d44}, {0x0d46, 0x0d48}, {0x0d4a, 0x0d4f}, 
                 {0x0d54, 0x0d63}, {0x0d66, 0x0d7f}, {0x0d82, 0x0d83}, {0x0d85, 0x0d96}, 
                 {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, {0x0dc0, 0x0dc6}, {0x0dcf, 0x0dd4}, 
                 {0x0dd8, 0x0ddf}, {0x0de6, 0x0def}, {0x0df2, 0x0df4}, {0x0e01, 0x0e3a}, 
                 {0x0e3f, 0x0e5b}, {0x0e81, 0x0e82}, {0x0e87, 0x0e88}, {0x0e94, 0x0e97}, 
                 {0x0e99, 0x0e9f}, {0x0ea1, 0x0ea3}, {0x0eaa, 0x0eab}, {0x0ead, 0x0eb9}, 
                 {0x0ebb, 0x0ebd}, {0x0ec0, 0x0ec4}, {0x0ec8, 0x0ecd}, {0x0ed0, 0x0ed9}, 
                 {0x0edc, 0x0edf}, {0x0f00, 0x0f47}, {0x0f49, 0x0f6c}, {0x0f71, 0x0f97}, 
                 {0x0f99, 0x0fbc}, {0x0fbe, 0x0fcc}, {0x0fce, 0x0fda}, {0x1000, 0x10c5}, 
                 {0x10d0, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x125a, 0x125d}, 
                 {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, 
                 {0x12b8, 0x12be}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, 
                 {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x137c}, {0x1380, 0x1399}, 
                 {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1400, 0x169c}, {0x16a0, 0x16f8}, 
                 {0x1700, 0x170c}, {0x170e, 0x1714}, {0x1720, 0x1736}, {0x1740, 0x1753}, 
                 {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17dd}, 
                 {0x17e0, 0x17e9}, {0x17f0, 0x17f9}, {0x1800, 0x180e}, {0x1810, 0x1819}, 
                 {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, 
                 {0x1920, 0x192b}, {0x1930, 0x193b}, {0x1944, 0x196d}, {0x1970, 0x1974}, 
                 {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x19de, 0x1a1b}, 
                 {0x1a1e, 0x1a5e}, {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, 
                 {0x1aa0, 0x1aad}, {0x1ab0, 0x1abe}, {0x1b00, 0x1b4b}, {0x1b50, 0x1b7c}, 
                 {0x1b80, 0x1bf3}, {0x1bfc, 0x1c37}, {0x1c3b, 0x1c49}, {0x1c4d, 0x1c88}, 
                 {0x1c90, 0x1cba}, {0x1cbd, 0x1cc7}, {0x1cd0, 0x1cf9}, {0x1d00, 0x1df9}, 
                 {0x1dfb, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, 
                 {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fc4}, 
                 {0x1fc6, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fdd, 0x1fef}, {0x1ff2, 0x1ff4}, 
                 {0x1ff6, 0x1ffe}, {0x2000, 0x2064}, {0x2066, 0x2071}, {0x2074, 0x208e}, 
                 {0x2090, 0x209c}, {0x20a0, 0x20bf}, {0x20d0, 0x20f0}, {0x2100, 0x218b}, 
                 {0x2190, 0x2426}, {0x2440, 0x244a}, {0x2460, 0x2b73}, {0x2b76, 0x2b95}, 
                 {0x2b98, 0x2bc8}, {0x2bca, 0x2bfe}, {0x2c00, 0x2c2e}, {0x2c30, 0x2c5e}, 
                 {0x2c60, 0x2cf3}, {0x2cf9, 0x2d25}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d70}, 
                 {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, 
                 {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, 
                 {0x2dd8, 0x2dde}, {0x2de0, 0x2e4e}, {0x2e80, 0x2e99}, {0x2e9b, 0x2ef3}, 
                 {0x2f00, 0x2fd5}, {0x2ff0, 0x2ffb}, {0x3000, 0x303f}, {0x3041, 0x3096}, 
                 {0x3099, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x3190, 0x31ba}, 
                 {0x31c0, 0x31e3}, {0x31f0, 0x321e}, {0x3220, 0x32fe}, {0x3300, 0x4db5}, 
                 {0x4dc0, 0x9fef}, {0xa000, 0xa48c}, {0xa490, 0xa4c6}, {0xa4d0, 0xa62b}, 
                 {0xa640, 0xa6f7}, {0xa700, 0xa7b9}, {0xa7f7, 0xa82b}, {0xa830, 0xa839}, 
                 {0xa840, 0xa877}, {0xa880, 0xa8c5}, {0xa8ce, 0xa8d9}, {0xa8e0, 0xa953}, 
                 {0xa95f, 0xa97c}, {0xa980, 0xa9cd}, {0xa9cf, 0xa9d9}, {0xa9de, 0xa9fe}, 
                 {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa5c, 0xaac2}, 
                 {0xaadb, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, 
                 {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab65}, {0xab70, 0xabed}, 
                 {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, 
                 {0xd800, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, 
                 {0xfb1d, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, 
                 {0xfb46, 0xfbc1}, {0xfbd3, 0xfd3f}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, 
                 {0xfdf0, 0xfdfd}, {0xfe00, 0xfe19}, {0xfe20, 0xfe52}, {0xfe54, 0xfe66}, 
                 {0xfe68, 0xfe6b}, {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, {0xff01, 0xffbe}, 
                 {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, 
                 {0xffe0, 0xffe6}, {0xffe8, 0xffee}, {0xfff9, 0xfffd}, {0x10000, 0x1000b}, 
                 {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, 
                 {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10100, 0x10102}, {0x10107, 0x10133}, 
                 {0x10137, 0x1018e}, {0x10190, 0x1019b}, {0x101d0, 0x101fd}, {0x10280, 0x1029c}, 
                 {0x102a0, 0x102d0}, {0x102e0, 0x102fb}, {0x10300, 0x10323}, {0x1032d, 0x1034a}, 
                 {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x1039f, 0x103c3}, {0x103c8, 0x103d5}, 
                 {0x10400, 0x1049d}, {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, 
                 {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10600, 0x10736}, {0x10740, 0x10755}, 
                 {0x10760, 0x10767}, {0x10800, 0x10805}, {0x1080a, 0x10835}, {0x10837, 0x10838}, 
                 {0x1083f, 0x10855}, {0x10857, 0x1089e}, {0x108a7, 0x108af}, {0x108e0, 0x108f2}, 
                 {0x108f4, 0x108f5}, {0x108fb, 0x1091b}, {0x1091f, 0x10939}, {0x10980, 0x109b7}, 
                 {0x109bc, 0x109cf}, {0x109d2, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, 
                 {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a48}, 
                 {0x10a50, 0x10a58}, {0x10a60, 0x10a9f}, {0x10ac0, 0x10ae6}, {0x10aeb, 0x10af6}, 
                 {0x10b00, 0x10b35}, {0x10b39, 0x10b55}, {0x10b58, 0x10b72}, {0x10b78, 0x10b91}, 
                 {0x10b99, 0x10b9c}, {0x10ba9, 0x10baf}, {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, 
                 {0x10cc0, 0x10cf2}, {0x10cfa, 0x10d27}, {0x10d30, 0x10d39}, {0x10e60, 0x10e7e}, 
                 {0x10f00, 0x10f27}, {0x10f30, 0x10f59}, {0x11000, 0x1104d}, {0x11052, 0x1106f}, 
                 {0x1107f, 0x110c1}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, 
                 {0x11136, 0x11146}, {0x11150, 0x11176}, {0x11180, 0x111cd}, {0x111d0, 0x111df}, 
                 {0x111e1, 0x111f4}, {0x11200, 0x11211}, {0x11213, 0x1123e}, {0x11280, 0x11286}, 
                 {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a9}, {0x112b0, 0x112ea}, 
                 {0x112f0, 0x112f9}, {0x11300, 0x11303}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, 
                 {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, 
                 {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d}, {0x1135d, 0x11363}, 
                 {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x11459}, {0x1145d, 0x1145e}, 
                 {0x11480, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115dd}, 
                 {0x11600, 0x11644}, {0x11650, 0x11659}, {0x11660, 0x1166c}, {0x11680, 0x116b7}, 
                 {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x1173f}, 
                 {0x11800, 0x1183b}, {0x118a0, 0x118f2}, {0x11a00, 0x11a47}, {0x11a50, 0x11a83}, 
                 {0x11a86, 0x11aa2}, {0x11ac0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, 
                 {0x11c38, 0x11c45}, {0x11c50, 0x11c6c}, {0x11c70, 0x11c8f}, {0x11c92, 0x11ca7}, 
                 {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, 
                 {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, {0x11d50, 0x11d59}, {0x11d60, 0x11d65}, 
                 {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, 
                 {0x11da0, 0x11da9}, {0x11ee0, 0x11ef8}, {0x12000, 0x12399}, {0x12400, 0x1246e}, 
                 {0x12470, 0x12474}, {0x12480, 0x12543}, {0x13000, 0x1342e}, {0x14400, 0x14646}, 
                 {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a6e, 0x16a6f}, 
                 {0x16ad0, 0x16aed}, {0x16af0, 0x16af5}, {0x16b00, 0x16b45}, {0x16b50, 0x16b59}, 
                 {0x16b5b, 0x16b61}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e9a}, 
                 {0x16f00, 0x16f44}, {0x16f50, 0x16f7e}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, 
                 {0x17000, 0x187f1}, {0x18800, 0x18af2}, {0x1b000, 0x1b11e}, {0x1b170, 0x1b2fb}, 
                 {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, 
                 {0x1bc9c, 0x1bca3}, {0x1d000, 0x1d0f5}, {0x1d100, 0x1d126}, {0x1d129, 0x1d1e8}, 
                 {0x1d200, 0x1d245}, {0x1d2e0, 0x1d2f3}, {0x1d300, 0x1d356}, {0x1d360, 0x1d378}, 
                 {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, 
                 {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, 
                 {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, 
                 {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, 
                 {0x1d6a8, 0x1d7cb}, {0x1d7ce, 0x1da8b}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, 
                 {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, 
                 {0x1e026, 0x1e02a}, {0x1e800, 0x1e8c4}, {0x1e8c7, 0x1e8d6}, {0x1e900, 0x1e94a}, 
                 {0x1e950, 0x1e959}, {0x1e95e, 0x1e95f}, {0x1ec71, 0x1ecb4}, {0x1ee00, 0x1ee03}, 
                 {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, 
                 {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, 
                 {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, 
                 {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, 
                 {0x1eef0, 0x1eef1}, {0x1f000, 0x1f02b}, {0x1f030, 0x1f093}, {0x1f0a0, 0x1f0ae}, 
                 {0x1f0b1, 0x1f0bf}, {0x1f0c1, 0x1f0cf}, {0x1f0d1, 0x1f0f5}, {0x1f100, 0x1f10c}, 
                 {0x1f110, 0x1f16b}, {0x1f170, 0x1f1ac}, {0x1f1e6, 0x1f202}, {0x1f210, 0x1f23b}, 
                 {0x1f240, 0x1f248}, {0x1f250, 0x1f251}, {0x1f260, 0x1f265}, {0x1f300, 0x1f6d4}, 
                 {0x1f6e0, 0x1f6ec}, {0x1f6f0, 0x1f6f9}, {0x1f700, 0x1f773}, {0x1f780, 0x1f7d8}, 
                 {0x1f800, 0x1f80b}, {0x1f810, 0x1f847}, {0x1f850, 0x1f859}, {0x1f860, 0x1f887}, 
                 {0x1f890, 0x1f8ad}, {0x1f900, 0x1f90b}, {0x1f910, 0x1f93e}, {0x1f940, 0x1f970}, 
                 {0x1f973, 0x1f976}, {0x1f97c, 0x1f9a2}, {0x1f9b0, 0x1f9b9}, {0x1f9c0, 0x1f9c2}, 
                 {0x1f9d0, 0x1f9ff}, {0x1fa60, 0x1fa6d}, {0x20000, 0x2a6d6}, {0x2a700, 0x2b734}, 
                 {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2f800, 0x2fa1d}, 
                 {0xe0020, 0xe007f}, {0xe0100, 0xe01ef}, {0xf0000, 0xffffd}, {0x100000, 0x10fffd}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass3()
{
    // Name = Other, number of codePoints: 976890
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x7f}),
        std::initializer_list<CharacterRange>({{0x00, 0x1f}}),
        std::initializer_list<UChar32>({0x00ad, 0x038b, 0x038d, 0x03a2, 0x0530, 0x0590, 0x06dd, 0x083f, 
                 0x085f, 0x08b5, 0x08e2, 0x0984, 0x09a9, 0x09b1, 0x09de, 0x0a04, 
                 0x0a29, 0x0a31, 0x0a34, 0x0a37, 0x0a3d, 0x0a5d, 0x0a84, 0x0a8e, 
                 0x0a92, 0x0aa9, 0x0ab1, 0x0ab4, 0x0ac6, 0x0aca, 0x0b00, 0x0b04, 
                 0x0b29, 0x0b31, 0x0b34, 0x0b5e, 0x0b84, 0x0b91, 0x0b9b, 0x0b9d, 
                 0x0bc9, 0x0c0d, 0x0c11, 0x0c29, 0x0c45, 0x0c49, 0x0c57, 0x0c8d, 
                 0x0c91, 0x0ca9, 0x0cb4, 0x0cc5, 0x0cc9, 0x0cdf, 0x0cf0, 0x0d04, 
                 0x0d0d, 0x0d11, 0x0d45, 0x0d49, 0x0d84, 0x0db2, 0x0dbc, 0x0dd5, 
                 0x0dd7, 0x0e83, 0x0e89, 0x0e98, 0x0ea0, 0x0ea4, 0x0ea6, 0x0eac, 
                 0x0eba, 0x0ec5, 0x0ec7, 0x0f48, 0x0f98, 0x0fbd, 0x0fcd, 0x10c6, 
                 0x1249, 0x1257, 0x1259, 0x1289, 0x12b1, 0x12bf, 0x12c1, 0x12d7, 
                 0x1311, 0x170d, 0x176d, 0x1771, 0x191f, 0x1a5f, 0x1dfa, 0x1f58, 
                 0x1f5a, 0x1f5c, 0x1f5e, 0x1fb5, 0x1fc5, 0x1fdc, 0x1ff5, 0x1fff, 
                 0x208f, 0x2bc9, 0x2bff, 0x2c2f, 0x2c5f, 0x2d26, 0x2da7, 0x2daf, 
                 0x2db7, 0x2dbf, 0x2dc7, 0x2dcf, 0x2dd7, 0x2ddf, 0x2e9a, 0x3040, 
                 0x3130, 0x318f, 0x321f, 0x32ff, 0xa9ce, 0xa9ff, 0xab27, 0xab2f, 
                 0xfb37, 0xfb3d, 0xfb3f, 0xfb42, 0xfb45, 0xfe53, 0xfe67, 0xfe75, 
                 0xffe7, 0x1000c, 0x10027, 0x1003b, 0x1003e, 0x1018f, 0x1039e, 0x10809, 
                 0x10836, 0x10856, 0x108f3, 0x10a04, 0x10a14, 0x10a18, 0x110bd, 0x11135, 
                 0x111e0, 0x11212, 0x11287, 0x11289, 0x1128e, 0x1129e, 0x11304, 0x11329, 
                 0x11331, 0x11334, 0x1133a, 0x1145a, 0x1145c, 0x11c09, 0x11c37, 0x11ca8, 
                 0x11d07, 0x11d0a, 0x11d3b, 0x11d3e, 0x11d66, 0x11d69, 0x11d8f, 0x11d92, 
                 0x1246f, 0x16a5f, 0x16b5a, 0x16b62, 0x1d455, 0x1d49d, 0x1d4ad, 0x1d4ba, 
                 0x1d4bc, 0x1d4c4, 0x1d506, 0x1d515, 0x1d51d, 0x1d53a, 0x1d53f, 0x1d545, 
                 0x1d551, 0x1daa0, 0x1e007, 0x1e022, 0x1e025, 0x1ee04, 0x1ee20, 0x1ee23, 
                 0x1ee28, 0x1ee33, 0x1ee38, 0x1ee3a, 0x1ee48, 0x1ee4a, 0x1ee4c, 0x1ee50, 
                 0x1ee53, 0x1ee58, 0x1ee5a, 0x1ee5c, 0x1ee5e, 0x1ee60, 0x1ee63, 0x1ee6b, 
                 0x1ee73, 0x1ee78, 0x1ee7d, 0x1ee7f, 0x1ee8a, 0x1eea4, 0x1eeaa, 0x1f0c0, 
                 0x1f0d0, 0x1f93f, 0x1f97b}),
        std::initializer_list<CharacterRange>({{0x0080, 0x009f}, {0x0378, 0x0379}, {0x0380, 0x0383}, {0x0557, 0x0558}, 
                 {0x058b, 0x058c}, {0x05c8, 0x05cf}, {0x05eb, 0x05ee}, {0x05f5, 0x0605}, 
                 {0x061c, 0x061d}, {0x070e, 0x070f}, {0x074b, 0x074c}, {0x07b2, 0x07bf}, 
                 {0x07fb, 0x07fc}, {0x082e, 0x082f}, {0x085c, 0x085d}, {0x086b, 0x089f}, 
                 {0x08be, 0x08d2}, {0x098d, 0x098e}, {0x0991, 0x0992}, {0x09b3, 0x09b5}, 
                 {0x09ba, 0x09bb}, {0x09c5, 0x09c6}, {0x09c9, 0x09ca}, {0x09cf, 0x09d6}, 
                 {0x09d8, 0x09db}, {0x09e4, 0x09e5}, {0x09ff, 0x0a00}, {0x0a0b, 0x0a0e}, 
                 {0x0a11, 0x0a12}, {0x0a3a, 0x0a3b}, {0x0a43, 0x0a46}, {0x0a49, 0x0a4a}, 
                 {0x0a4e, 0x0a50}, {0x0a52, 0x0a58}, {0x0a5f, 0x0a65}, {0x0a77, 0x0a80}, 
                 {0x0aba, 0x0abb}, {0x0ace, 0x0acf}, {0x0ad1, 0x0adf}, {0x0ae4, 0x0ae5}, 
                 {0x0af2, 0x0af8}, {0x0b0d, 0x0b0e}, {0x0b11, 0x0b12}, {0x0b3a, 0x0b3b}, 
                 {0x0b45, 0x0b46}, {0x0b49, 0x0b4a}, {0x0b4e, 0x0b55}, {0x0b58, 0x0b5b}, 
                 {0x0b64, 0x0b65}, {0x0b78, 0x0b81}, {0x0b8b, 0x0b8d}, {0x0b96, 0x0b98}, 
                 {0x0ba0, 0x0ba2}, {0x0ba5, 0x0ba7}, {0x0bab, 0x0bad}, {0x0bba, 0x0bbd}, 
                 {0x0bc3, 0x0bc5}, {0x0bce, 0x0bcf}, {0x0bd1, 0x0bd6}, {0x0bd8, 0x0be5}, 
                 {0x0bfb, 0x0bff}, {0x0c3a, 0x0c3c}, {0x0c4e, 0x0c54}, {0x0c5b, 0x0c5f}, 
                 {0x0c64, 0x0c65}, {0x0c70, 0x0c77}, {0x0cba, 0x0cbb}, {0x0cce, 0x0cd4}, 
                 {0x0cd7, 0x0cdd}, {0x0ce4, 0x0ce5}, {0x0cf3, 0x0cff}, {0x0d50, 0x0d53}, 
                 {0x0d64, 0x0d65}, {0x0d80, 0x0d81}, {0x0d97, 0x0d99}, {0x0dbe, 0x0dbf}, 
                 {0x0dc7, 0x0dc9}, {0x0dcb, 0x0dce}, {0x0de0, 0x0de5}, {0x0df0, 0x0df1}, 
                 {0x0df5, 0x0e00}, {0x0e3b, 0x0e3e}, {0x0e5c, 0x0e80}, {0x0e85, 0x0e86}, 
                 {0x0e8b, 0x0e8c}, {0x0e8e, 0x0e93}, {0x0ea8, 0x0ea9}, {0x0ebe, 0x0ebf}, 
                 {0x0ece, 0x0ecf}, {0x0eda, 0x0edb}, {0x0ee0, 0x0eff}, {0x0f6d, 0x0f70}, 
                 {0x0fdb, 0x0fff}, {0x10c8, 0x10cc}, {0x10ce, 0x10cf}, {0x124e, 0x124f}, 
                 {0x125e, 0x125f}, {0x128e, 0x128f}, {0x12b6, 0x12b7}, {0x12c6, 0x12c7}, 
                 {0x1316, 0x1317}, {0x135b, 0x135c}, {0x137d, 0x137f}, {0x139a, 0x139f}, 
                 {0x13f6, 0x13f7}, {0x13fe, 0x13ff}, {0x169d, 0x169f}, {0x16f9, 0x16ff}, 
                 {0x1715, 0x171f}, {0x1737, 0x173f}, {0x1754, 0x175f}, {0x1774, 0x177f}, 
                 {0x17de, 0x17df}, {0x17ea, 0x17ef}, {0x17fa, 0x17ff}, {0x180e, 0x180f}, 
                 {0x181a, 0x181f}, {0x1879, 0x187f}, {0x18ab, 0x18af}, {0x18f6, 0x18ff}, 
                 {0x192c, 0x192f}, {0x193c, 0x193f}, {0x1941, 0x1943}, {0x196e, 0x196f}, 
                 {0x1975, 0x197f}, {0x19ac, 0x19af}, {0x19ca, 0x19cf}, {0x19db, 0x19dd}, 
                 {0x1a1c, 0x1a1d}, {0x1a7d, 0x1a7e}, {0x1a8a, 0x1a8f}, {0x1a9a, 0x1a9f}, 
                 {0x1aae, 0x1aaf}, {0x1abf, 0x1aff}, {0x1b4c, 0x1b4f}, {0x1b7d, 0x1b7f}, 
                 {0x1bf4, 0x1bfb}, {0x1c38, 0x1c3a}, {0x1c4a, 0x1c4c}, {0x1c89, 0x1c8f}, 
                 {0x1cbb, 0x1cbc}, {0x1cc8, 0x1ccf}, {0x1cfa, 0x1cff}, {0x1f16, 0x1f17}, 
                 {0x1f1e, 0x1f1f}, {0x1f46, 0x1f47}, {0x1f4e, 0x1f4f}, {0x1f7e, 0x1f7f}, 
                 {0x1fd4, 0x1fd5}, {0x1ff0, 0x1ff1}, {0x200b, 0x200f}, {0x202a, 0x202e}, 
                 {0x2060, 0x206f}, {0x2072, 0x2073}, {0x209d, 0x209f}, {0x20c0, 0x20cf}, 
                 {0x20f1, 0x20ff}, {0x218c, 0x218f}, {0x2427, 0x243f}, {0x244b, 0x245f}, 
                 {0x2b74, 0x2b75}, {0x2b96, 0x2b97}, {0x2cf4, 0x2cf8}, {0x2d28, 0x2d2c}, 
                 {0x2d2e, 0x2d2f}, {0x2d68, 0x2d6e}, {0x2d71, 0x2d7e}, {0x2d97, 0x2d9f}, 
                 {0x2e4f, 0x2e7f}, {0x2ef4, 0x2eff}, {0x2fd6, 0x2fef}, {0x2ffc, 0x2fff}, 
                 {0x3097, 0x3098}, {0x3100, 0x3104}, {0x31bb, 0x31bf}, {0x31e4, 0x31ef}, 
                 {0x4db6, 0x4dbf}, {0x9ff0, 0x9fff}, {0xa48d, 0xa48f}, {0xa4c7, 0xa4cf}, 
                 {0xa62c, 0xa63f}, {0xa6f8, 0xa6ff}, {0xa7ba, 0xa7f6}, {0xa82c, 0xa82f}, 
                 {0xa83a, 0xa83f}, {0xa878, 0xa87f}, {0xa8c6, 0xa8cd}, {0xa8da, 0xa8df}, 
                 {0xa954, 0xa95e}, {0xa97d, 0xa97f}, {0xa9da, 0xa9dd}, {0xaa37, 0xaa3f}, 
                 {0xaa4e, 0xaa4f}, {0xaa5a, 0xaa5b}, {0xaac3, 0xaada}, {0xaaf7, 0xab00}, 
                 {0xab07, 0xab08}, {0xab0f, 0xab10}, {0xab17, 0xab1f}, {0xab66, 0xab6f}, 
                 {0xabee, 0xabef}, {0xabfa, 0xabff}, {0xd7a4, 0xd7af}, {0xd7c7, 0xd7ca}, 
                 {0xd7fc, 0xf8ff}, {0xfa6e, 0xfa6f}, {0xfada, 0xfaff}, {0xfb07, 0xfb12}, 
                 {0xfb18, 0xfb1c}, {0xfbc2, 0xfbd2}, {0xfd40, 0xfd4f}, {0xfd90, 0xfd91}, 
                 {0xfdc8, 0xfdef}, {0xfdfe, 0xfdff}, {0xfe1a, 0xfe1f}, {0xfe6c, 0xfe6f}, 
                 {0xfefd, 0xff00}, {0xffbf, 0xffc1}, {0xffc8, 0xffc9}, {0xffd0, 0xffd1}, 
                 {0xffd8, 0xffd9}, {0xffdd, 0xffdf}, {0xffef, 0xfffb}, {0xfffe, 0xffff}, 
                 {0x1004e, 0x1004f}, {0x1005e, 0x1007f}, {0x100fb, 0x100ff}, {0x10103, 0x10106}, 
                 {0x10134, 0x10136}, {0x1019c, 0x1019f}, {0x101a1, 0x101cf}, {0x101fe, 0x1027f}, 
                 {0x1029d, 0x1029f}, {0x102d1, 0x102df}, {0x102fc, 0x102ff}, {0x10324, 0x1032c}, 
                 {0x1034b, 0x1034f}, {0x1037b, 0x1037f}, {0x103c4, 0x103c7}, {0x103d6, 0x103ff}, 
                 {0x1049e, 0x1049f}, {0x104aa, 0x104af}, {0x104d4, 0x104d7}, {0x104fc, 0x104ff}, 
                 {0x10528, 0x1052f}, {0x10564, 0x1056e}, {0x10570, 0x105ff}, {0x10737, 0x1073f}, 
                 {0x10756, 0x1075f}, {0x10768, 0x107ff}, {0x10806, 0x10807}, {0x10839, 0x1083b}, 
                 {0x1083d, 0x1083e}, {0x1089f, 0x108a6}, {0x108b0, 0x108df}, {0x108f6, 0x108fa}, 
                 {0x1091c, 0x1091e}, {0x1093a, 0x1093e}, {0x10940, 0x1097f}, {0x109b8, 0x109bb}, 
                 {0x109d0, 0x109d1}, {0x10a07, 0x10a0b}, {0x10a36, 0x10a37}, {0x10a3b, 0x10a3e}, 
                 {0x10a49, 0x10a4f}, {0x10a59, 0x10a5f}, {0x10aa0, 0x10abf}, {0x10ae7, 0x10aea}, 
                 {0x10af7, 0x10aff}, {0x10b36, 0x10b38}, {0x10b56, 0x10b57}, {0x10b73, 0x10b77}, 
                 {0x10b92, 0x10b98}, {0x10b9d, 0x10ba8}, {0x10bb0, 0x10bff}, {0x10c49, 0x10c7f}, 
                 {0x10cb3, 0x10cbf}, {0x10cf3, 0x10cf9}, {0x10d28, 0x10d2f}, {0x10d3a, 0x10e5f}, 
                 {0x10e7f, 0x10eff}, {0x10f28, 0x10f2f}, {0x10f5a, 0x10fff}, {0x1104e, 0x11051}, 
                 {0x11070, 0x1107e}, {0x110c2, 0x110cf}, {0x110e9, 0x110ef}, {0x110fa, 0x110ff}, 
                 {0x11147, 0x1114f}, {0x11177, 0x1117f}, {0x111ce, 0x111cf}, {0x111f5, 0x111ff}, 
                 {0x1123f, 0x1127f}, {0x112aa, 0x112af}, {0x112eb, 0x112ef}, {0x112fa, 0x112ff}, 
                 {0x1130d, 0x1130e}, {0x11311, 0x11312}, {0x11345, 0x11346}, {0x11349, 0x1134a}, 
                 {0x1134e, 0x1134f}, {0x11351, 0x11356}, {0x11358, 0x1135c}, {0x11364, 0x11365}, 
                 {0x1136d, 0x1136f}, {0x11375, 0x113ff}, {0x1145f, 0x1147f}, {0x114c8, 0x114cf}, 
                 {0x114da, 0x1157f}, {0x115b6, 0x115b7}, {0x115de, 0x115ff}, {0x11645, 0x1164f}, 
                 {0x1165a, 0x1165f}, {0x1166d, 0x1167f}, {0x116b8, 0x116bf}, {0x116ca, 0x116ff}, 
                 {0x1171b, 0x1171c}, {0x1172c, 0x1172f}, {0x11740, 0x117ff}, {0x1183c, 0x1189f}, 
                 {0x118f3, 0x118fe}, {0x11900, 0x119ff}, {0x11a48, 0x11a4f}, {0x11a84, 0x11a85}, 
                 {0x11aa3, 0x11abf}, {0x11af9, 0x11bff}, {0x11c46, 0x11c4f}, {0x11c6d, 0x11c6f}, 
                 {0x11c90, 0x11c91}, {0x11cb7, 0x11cff}, {0x11d37, 0x11d39}, {0x11d48, 0x11d4f}, 
                 {0x11d5a, 0x11d5f}, {0x11d99, 0x11d9f}, {0x11daa, 0x11edf}, {0x11ef9, 0x11fff}, 
                 {0x1239a, 0x123ff}, {0x12475, 0x1247f}, {0x12544, 0x12fff}, {0x1342f, 0x143ff}, 
                 {0x14647, 0x167ff}, {0x16a39, 0x16a3f}, {0x16a6a, 0x16a6d}, {0x16a70, 0x16acf}, 
                 {0x16aee, 0x16aef}, {0x16af6, 0x16aff}, {0x16b46, 0x16b4f}, {0x16b78, 0x16b7c}, 
                 {0x16b90, 0x16e3f}, {0x16e9b, 0x16eff}, {0x16f45, 0x16f4f}, {0x16f7f, 0x16f8e}, 
                 {0x16fa0, 0x16fdf}, {0x16fe2, 0x16fff}, {0x187f2, 0x187ff}, {0x18af3, 0x1afff}, 
                 {0x1b11f, 0x1b16f}, {0x1b2fc, 0x1bbff}, {0x1bc6b, 0x1bc6f}, {0x1bc7d, 0x1bc7f}, 
                 {0x1bc89, 0x1bc8f}, {0x1bc9a, 0x1bc9b}, {0x1bca0, 0x1cfff}, {0x1d0f6, 0x1d0ff}, 
                 {0x1d127, 0x1d128}, {0x1d173, 0x1d17a}, {0x1d1e9, 0x1d1ff}, {0x1d246, 0x1d2df}, 
                 {0x1d2f4, 0x1d2ff}, {0x1d357, 0x1d35f}, {0x1d379, 0x1d3ff}, {0x1d4a0, 0x1d4a1}, 
                 {0x1d4a3, 0x1d4a4}, {0x1d4a7, 0x1d4a8}, {0x1d50b, 0x1d50c}, {0x1d547, 0x1d549}, 
                 {0x1d6a6, 0x1d6a7}, {0x1d7cc, 0x1d7cd}, {0x1da8c, 0x1da9a}, {0x1dab0, 0x1dfff}, 
                 {0x1e019, 0x1e01a}, {0x1e02b, 0x1e7ff}, {0x1e8c5, 0x1e8c6}, {0x1e8d7, 0x1e8ff}, 
                 {0x1e94b, 0x1e94f}, {0x1e95a, 0x1e95d}, {0x1e960, 0x1ec70}, {0x1ecb5, 0x1edff}, 
                 {0x1ee25, 0x1ee26}, {0x1ee3c, 0x1ee41}, {0x1ee43, 0x1ee46}, {0x1ee55, 0x1ee56}, 
                 {0x1ee65, 0x1ee66}, {0x1ee9c, 0x1eea0}, {0x1eebc, 0x1eeef}, {0x1eef2, 0x1efff}, 
                 {0x1f02c, 0x1f02f}, {0x1f094, 0x1f09f}, {0x1f0af, 0x1f0b0}, {0x1f0f6, 0x1f0ff}, 
                 {0x1f10d, 0x1f10f}, {0x1f16c, 0x1f16f}, {0x1f1ad, 0x1f1e5}, {0x1f203, 0x1f20f}, 
                 {0x1f23c, 0x1f23f}, {0x1f249, 0x1f24f}, {0x1f252, 0x1f25f}, {0x1f266, 0x1f2ff}, 
                 {0x1f6d5, 0x1f6df}, {0x1f6ed, 0x1f6ef}, {0x1f6fa, 0x1f6ff}, {0x1f774, 0x1f77f}, 
                 {0x1f7d9, 0x1f7ff}, {0x1f80c, 0x1f80f}, {0x1f848, 0x1f84f}, {0x1f85a, 0x1f85f}, 
                 {0x1f888, 0x1f88f}, {0x1f8ae, 0x1f8ff}, {0x1f90c, 0x1f90f}, {0x1f971, 0x1f972}, 
                 {0x1f977, 0x1f979}, {0x1f9a3, 0x1f9af}, {0x1f9ba, 0x1f9bf}, {0x1f9c3, 0x1f9cf}, 
                 {0x1fa00, 0x1fa5f}, {0x1fa6e, 0x1ffff}, {0x2a6d7, 0x2a6ff}, {0x2b735, 0x2b73f}, 
                 {0x2b81e, 0x2b81f}, {0x2cea2, 0x2ceaf}, {0x2ebe1, 0x2f7ff}, {0x2fa1e, 0xe00ff}, 
                 {0xe01f0, 0x10ffff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass4()
{
    // Name = Unassigned, number of codePoints: 837157
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x038b, 0x038d, 0x03a2, 0x0530, 0x0590, 0x061d, 0x070e, 0x083f, 
                 0x085f, 0x08b5, 0x0984, 0x09a9, 0x09b1, 0x09de, 0x0a04, 0x0a29, 
                 0x0a31, 0x0a34, 0x0a37, 0x0a3d, 0x0a5d, 0x0a84, 0x0a8e, 0x0a92, 
                 0x0aa9, 0x0ab1, 0x0ab4, 0x0ac6, 0x0aca, 0x0b00, 0x0b04, 0x0b29, 
                 0x0b31, 0x0b34, 0x0b5e, 0x0b84, 0x0b91, 0x0b9b, 0x0b9d, 0x0bc9, 
                 0x0c0d, 0x0c11, 0x0c29, 0x0c45, 0x0c49, 0x0c57, 0x0c8d, 0x0c91, 
                 0x0ca9, 0x0cb4, 0x0cc5, 0x0cc9, 0x0cdf, 0x0cf0, 0x0d04, 0x0d0d, 
                 0x0d11, 0x0d45, 0x0d49, 0x0d84, 0x0db2, 0x0dbc, 0x0dd5, 0x0dd7, 
                 0x0e83, 0x0e89, 0x0e98, 0x0ea0, 0x0ea4, 0x0ea6, 0x0eac, 0x0eba, 
                 0x0ec5, 0x0ec7, 0x0f48, 0x0f98, 0x0fbd, 0x0fcd, 0x10c6, 0x1249, 
                 0x1257, 0x1259, 0x1289, 0x12b1, 0x12bf, 0x12c1, 0x12d7, 0x1311, 
                 0x170d, 0x176d, 0x1771, 0x180f, 0x191f, 0x1a5f, 0x1dfa, 0x1f58, 
                 0x1f5a, 0x1f5c, 0x1f5e, 0x1fb5, 0x1fc5, 0x1fdc, 0x1ff5, 0x1fff, 
                 0x2065, 0x208f, 0x2bc9, 0x2bff, 0x2c2f, 0x2c5f, 0x2d26, 0x2da7, 
                 0x2daf, 0x2db7, 0x2dbf, 0x2dc7, 0x2dcf, 0x2dd7, 0x2ddf, 0x2e9a, 
                 0x3040, 0x3130, 0x318f, 0x321f, 0x32ff, 0xa9ce, 0xa9ff, 0xab27, 
                 0xab2f, 0xfb37, 0xfb3d, 0xfb3f, 0xfb42, 0xfb45, 0xfe53, 0xfe67, 
                 0xfe75, 0xff00, 0xffe7, 0x1000c, 0x10027, 0x1003b, 0x1003e, 0x1018f, 
                 0x1039e, 0x10809, 0x10836, 0x10856, 0x108f3, 0x10a04, 0x10a14, 0x10a18, 
                 0x11135, 0x111e0, 0x11212, 0x11287, 0x11289, 0x1128e, 0x1129e, 0x11304, 
                 0x11329, 0x11331, 0x11334, 0x1133a, 0x1145a, 0x1145c, 0x11c09, 0x11c37, 
                 0x11ca8, 0x11d07, 0x11d0a, 0x11d3b, 0x11d3e, 0x11d66, 0x11d69, 0x11d8f, 
                 0x11d92, 0x1246f, 0x16a5f, 0x16b5a, 0x16b62, 0x1d455, 0x1d49d, 0x1d4ad, 
                 0x1d4ba, 0x1d4bc, 0x1d4c4, 0x1d506, 0x1d515, 0x1d51d, 0x1d53a, 0x1d53f, 
                 0x1d545, 0x1d551, 0x1daa0, 0x1e007, 0x1e022, 0x1e025, 0x1ee04, 0x1ee20, 
                 0x1ee23, 0x1ee28, 0x1ee33, 0x1ee38, 0x1ee3a, 0x1ee48, 0x1ee4a, 0x1ee4c, 
                 0x1ee50, 0x1ee53, 0x1ee58, 0x1ee5a, 0x1ee5c, 0x1ee5e, 0x1ee60, 0x1ee63, 
                 0x1ee6b, 0x1ee73, 0x1ee78, 0x1ee7d, 0x1ee7f, 0x1ee8a, 0x1eea4, 0x1eeaa, 
                 0x1f0c0, 0x1f0d0, 0x1f93f, 0x1f97b}),
        std::initializer_list<CharacterRange>({{0x0378, 0x0379}, {0x0380, 0x0383}, {0x0557, 0x0558}, {0x058b, 0x058c}, 
                 {0x05c8, 0x05cf}, {0x05eb, 0x05ee}, {0x05f5, 0x05ff}, {0x074b, 0x074c}, 
                 {0x07b2, 0x07bf}, {0x07fb, 0x07fc}, {0x082e, 0x082f}, {0x085c, 0x085d}, 
                 {0x086b, 0x089f}, {0x08be, 0x08d2}, {0x098d, 0x098e}, {0x0991, 0x0992}, 
                 {0x09b3, 0x09b5}, {0x09ba, 0x09bb}, {0x09c5, 0x09c6}, {0x09c9, 0x09ca}, 
                 {0x09cf, 0x09d6}, {0x09d8, 0x09db}, {0x09e4, 0x09e5}, {0x09ff, 0x0a00}, 
                 {0x0a0b, 0x0a0e}, {0x0a11, 0x0a12}, {0x0a3a, 0x0a3b}, {0x0a43, 0x0a46}, 
                 {0x0a49, 0x0a4a}, {0x0a4e, 0x0a50}, {0x0a52, 0x0a58}, {0x0a5f, 0x0a65}, 
                 {0x0a77, 0x0a80}, {0x0aba, 0x0abb}, {0x0ace, 0x0acf}, {0x0ad1, 0x0adf}, 
                 {0x0ae4, 0x0ae5}, {0x0af2, 0x0af8}, {0x0b0d, 0x0b0e}, {0x0b11, 0x0b12}, 
                 {0x0b3a, 0x0b3b}, {0x0b45, 0x0b46}, {0x0b49, 0x0b4a}, {0x0b4e, 0x0b55}, 
                 {0x0b58, 0x0b5b}, {0x0b64, 0x0b65}, {0x0b78, 0x0b81}, {0x0b8b, 0x0b8d}, 
                 {0x0b96, 0x0b98}, {0x0ba0, 0x0ba2}, {0x0ba5, 0x0ba7}, {0x0bab, 0x0bad}, 
                 {0x0bba, 0x0bbd}, {0x0bc3, 0x0bc5}, {0x0bce, 0x0bcf}, {0x0bd1, 0x0bd6}, 
                 {0x0bd8, 0x0be5}, {0x0bfb, 0x0bff}, {0x0c3a, 0x0c3c}, {0x0c4e, 0x0c54}, 
                 {0x0c5b, 0x0c5f}, {0x0c64, 0x0c65}, {0x0c70, 0x0c77}, {0x0cba, 0x0cbb}, 
                 {0x0cce, 0x0cd4}, {0x0cd7, 0x0cdd}, {0x0ce4, 0x0ce5}, {0x0cf3, 0x0cff}, 
                 {0x0d50, 0x0d53}, {0x0d64, 0x0d65}, {0x0d80, 0x0d81}, {0x0d97, 0x0d99}, 
                 {0x0dbe, 0x0dbf}, {0x0dc7, 0x0dc9}, {0x0dcb, 0x0dce}, {0x0de0, 0x0de5}, 
                 {0x0df0, 0x0df1}, {0x0df5, 0x0e00}, {0x0e3b, 0x0e3e}, {0x0e5c, 0x0e80}, 
                 {0x0e85, 0x0e86}, {0x0e8b, 0x0e8c}, {0x0e8e, 0x0e93}, {0x0ea8, 0x0ea9}, 
                 {0x0ebe, 0x0ebf}, {0x0ece, 0x0ecf}, {0x0eda, 0x0edb}, {0x0ee0, 0x0eff}, 
                 {0x0f6d, 0x0f70}, {0x0fdb, 0x0fff}, {0x10c8, 0x10cc}, {0x10ce, 0x10cf}, 
                 {0x124e, 0x124f}, {0x125e, 0x125f}, {0x128e, 0x128f}, {0x12b6, 0x12b7}, 
                 {0x12c6, 0x12c7}, {0x1316, 0x1317}, {0x135b, 0x135c}, {0x137d, 0x137f}, 
                 {0x139a, 0x139f}, {0x13f6, 0x13f7}, {0x13fe, 0x13ff}, {0x169d, 0x169f}, 
                 {0x16f9, 0x16ff}, {0x1715, 0x171f}, {0x1737, 0x173f}, {0x1754, 0x175f}, 
                 {0x1774, 0x177f}, {0x17de, 0x17df}, {0x17ea, 0x17ef}, {0x17fa, 0x17ff}, 
                 {0x181a, 0x181f}, {0x1879, 0x187f}, {0x18ab, 0x18af}, {0x18f6, 0x18ff}, 
                 {0x192c, 0x192f}, {0x193c, 0x193f}, {0x1941, 0x1943}, {0x196e, 0x196f}, 
                 {0x1975, 0x197f}, {0x19ac, 0x19af}, {0x19ca, 0x19cf}, {0x19db, 0x19dd}, 
                 {0x1a1c, 0x1a1d}, {0x1a7d, 0x1a7e}, {0x1a8a, 0x1a8f}, {0x1a9a, 0x1a9f}, 
                 {0x1aae, 0x1aaf}, {0x1abf, 0x1aff}, {0x1b4c, 0x1b4f}, {0x1b7d, 0x1b7f}, 
                 {0x1bf4, 0x1bfb}, {0x1c38, 0x1c3a}, {0x1c4a, 0x1c4c}, {0x1c89, 0x1c8f}, 
                 {0x1cbb, 0x1cbc}, {0x1cc8, 0x1ccf}, {0x1cfa, 0x1cff}, {0x1f16, 0x1f17}, 
                 {0x1f1e, 0x1f1f}, {0x1f46, 0x1f47}, {0x1f4e, 0x1f4f}, {0x1f7e, 0x1f7f}, 
                 {0x1fd4, 0x1fd5}, {0x1ff0, 0x1ff1}, {0x2072, 0x2073}, {0x209d, 0x209f}, 
                 {0x20c0, 0x20cf}, {0x20f1, 0x20ff}, {0x218c, 0x218f}, {0x2427, 0x243f}, 
                 {0x244b, 0x245f}, {0x2b74, 0x2b75}, {0x2b96, 0x2b97}, {0x2cf4, 0x2cf8}, 
                 {0x2d28, 0x2d2c}, {0x2d2e, 0x2d2f}, {0x2d68, 0x2d6e}, {0x2d71, 0x2d7e}, 
                 {0x2d97, 0x2d9f}, {0x2e4f, 0x2e7f}, {0x2ef4, 0x2eff}, {0x2fd6, 0x2fef}, 
                 {0x2ffc, 0x2fff}, {0x3097, 0x3098}, {0x3100, 0x3104}, {0x31bb, 0x31bf}, 
                 {0x31e4, 0x31ef}, {0x4db6, 0x4dbf}, {0x9ff0, 0x9fff}, {0xa48d, 0xa48f}, 
                 {0xa4c7, 0xa4cf}, {0xa62c, 0xa63f}, {0xa6f8, 0xa6ff}, {0xa7ba, 0xa7f6}, 
                 {0xa82c, 0xa82f}, {0xa83a, 0xa83f}, {0xa878, 0xa87f}, {0xa8c6, 0xa8cd}, 
                 {0xa8da, 0xa8df}, {0xa954, 0xa95e}, {0xa97d, 0xa97f}, {0xa9da, 0xa9dd}, 
                 {0xaa37, 0xaa3f}, {0xaa4e, 0xaa4f}, {0xaa5a, 0xaa5b}, {0xaac3, 0xaada}, 
                 {0xaaf7, 0xab00}, {0xab07, 0xab08}, {0xab0f, 0xab10}, {0xab17, 0xab1f}, 
                 {0xab66, 0xab6f}, {0xabee, 0xabef}, {0xabfa, 0xabff}, {0xd7a4, 0xd7af}, 
                 {0xd7c7, 0xd7ca}, {0xd7fc, 0xd7ff}, {0xfa6e, 0xfa6f}, {0xfada, 0xfaff}, 
                 {0xfb07, 0xfb12}, {0xfb18, 0xfb1c}, {0xfbc2, 0xfbd2}, {0xfd40, 0xfd4f}, 
                 {0xfd90, 0xfd91}, {0xfdc8, 0xfdef}, {0xfdfe, 0xfdff}, {0xfe1a, 0xfe1f}, 
                 {0xfe6c, 0xfe6f}, {0xfefd, 0xfefe}, {0xffbf, 0xffc1}, {0xffc8, 0xffc9}, 
                 {0xffd0, 0xffd1}, {0xffd8, 0xffd9}, {0xffdd, 0xffdf}, {0xffef, 0xfff8}, 
                 {0xfffe, 0xffff}, {0x1004e, 0x1004f}, {0x1005e, 0x1007f}, {0x100fb, 0x100ff}, 
                 {0x10103, 0x10106}, {0x10134, 0x10136}, {0x1019c, 0x1019f}, {0x101a1, 0x101cf}, 
                 {0x101fe, 0x1027f}, {0x1029d, 0x1029f}, {0x102d1, 0x102df}, {0x102fc, 0x102ff}, 
                 {0x10324, 0x1032c}, {0x1034b, 0x1034f}, {0x1037b, 0x1037f}, {0x103c4, 0x103c7}, 
                 {0x103d6, 0x103ff}, {0x1049e, 0x1049f}, {0x104aa, 0x104af}, {0x104d4, 0x104d7}, 
                 {0x104fc, 0x104ff}, {0x10528, 0x1052f}, {0x10564, 0x1056e}, {0x10570, 0x105ff}, 
                 {0x10737, 0x1073f}, {0x10756, 0x1075f}, {0x10768, 0x107ff}, {0x10806, 0x10807}, 
                 {0x10839, 0x1083b}, {0x1083d, 0x1083e}, {0x1089f, 0x108a6}, {0x108b0, 0x108df}, 
                 {0x108f6, 0x108fa}, {0x1091c, 0x1091e}, {0x1093a, 0x1093e}, {0x10940, 0x1097f}, 
                 {0x109b8, 0x109bb}, {0x109d0, 0x109d1}, {0x10a07, 0x10a0b}, {0x10a36, 0x10a37}, 
                 {0x10a3b, 0x10a3e}, {0x10a49, 0x10a4f}, {0x10a59, 0x10a5f}, {0x10aa0, 0x10abf}, 
                 {0x10ae7, 0x10aea}, {0x10af7, 0x10aff}, {0x10b36, 0x10b38}, {0x10b56, 0x10b57}, 
                 {0x10b73, 0x10b77}, {0x10b92, 0x10b98}, {0x10b9d, 0x10ba8}, {0x10bb0, 0x10bff}, 
                 {0x10c49, 0x10c7f}, {0x10cb3, 0x10cbf}, {0x10cf3, 0x10cf9}, {0x10d28, 0x10d2f}, 
                 {0x10d3a, 0x10e5f}, {0x10e7f, 0x10eff}, {0x10f28, 0x10f2f}, {0x10f5a, 0x10fff}, 
                 {0x1104e, 0x11051}, {0x11070, 0x1107e}, {0x110c2, 0x110cc}, {0x110ce, 0x110cf}, 
                 {0x110e9, 0x110ef}, {0x110fa, 0x110ff}, {0x11147, 0x1114f}, {0x11177, 0x1117f}, 
                 {0x111ce, 0x111cf}, {0x111f5, 0x111ff}, {0x1123f, 0x1127f}, {0x112aa, 0x112af}, 
                 {0x112eb, 0x112ef}, {0x112fa, 0x112ff}, {0x1130d, 0x1130e}, {0x11311, 0x11312}, 
                 {0x11345, 0x11346}, {0x11349, 0x1134a}, {0x1134e, 0x1134f}, {0x11351, 0x11356}, 
                 {0x11358, 0x1135c}, {0x11364, 0x11365}, {0x1136d, 0x1136f}, {0x11375, 0x113ff}, 
                 {0x1145f, 0x1147f}, {0x114c8, 0x114cf}, {0x114da, 0x1157f}, {0x115b6, 0x115b7}, 
                 {0x115de, 0x115ff}, {0x11645, 0x1164f}, {0x1165a, 0x1165f}, {0x1166d, 0x1167f}, 
                 {0x116b8, 0x116bf}, {0x116ca, 0x116ff}, {0x1171b, 0x1171c}, {0x1172c, 0x1172f}, 
                 {0x11740, 0x117ff}, {0x1183c, 0x1189f}, {0x118f3, 0x118fe}, {0x11900, 0x119ff}, 
                 {0x11a48, 0x11a4f}, {0x11a84, 0x11a85}, {0x11aa3, 0x11abf}, {0x11af9, 0x11bff}, 
                 {0x11c46, 0x11c4f}, {0x11c6d, 0x11c6f}, {0x11c90, 0x11c91}, {0x11cb7, 0x11cff}, 
                 {0x11d37, 0x11d39}, {0x11d48, 0x11d4f}, {0x11d5a, 0x11d5f}, {0x11d99, 0x11d9f}, 
                 {0x11daa, 0x11edf}, {0x11ef9, 0x11fff}, {0x1239a, 0x123ff}, {0x12475, 0x1247f}, 
                 {0x12544, 0x12fff}, {0x1342f, 0x143ff}, {0x14647, 0x167ff}, {0x16a39, 0x16a3f}, 
                 {0x16a6a, 0x16a6d}, {0x16a70, 0x16acf}, {0x16aee, 0x16aef}, {0x16af6, 0x16aff}, 
                 {0x16b46, 0x16b4f}, {0x16b78, 0x16b7c}, {0x16b90, 0x16e3f}, {0x16e9b, 0x16eff}, 
                 {0x16f45, 0x16f4f}, {0x16f7f, 0x16f8e}, {0x16fa0, 0x16fdf}, {0x16fe2, 0x16fff}, 
                 {0x187f2, 0x187ff}, {0x18af3, 0x1afff}, {0x1b11f, 0x1b16f}, {0x1b2fc, 0x1bbff}, 
                 {0x1bc6b, 0x1bc6f}, {0x1bc7d, 0x1bc7f}, {0x1bc89, 0x1bc8f}, {0x1bc9a, 0x1bc9b}, 
                 {0x1bca4, 0x1cfff}, {0x1d0f6, 0x1d0ff}, {0x1d127, 0x1d128}, {0x1d1e9, 0x1d1ff}, 
                 {0x1d246, 0x1d2df}, {0x1d2f4, 0x1d2ff}, {0x1d357, 0x1d35f}, {0x1d379, 0x1d3ff}, 
                 {0x1d4a0, 0x1d4a1}, {0x1d4a3, 0x1d4a4}, {0x1d4a7, 0x1d4a8}, {0x1d50b, 0x1d50c}, 
                 {0x1d547, 0x1d549}, {0x1d6a6, 0x1d6a7}, {0x1d7cc, 0x1d7cd}, {0x1da8c, 0x1da9a}, 
                 {0x1dab0, 0x1dfff}, {0x1e019, 0x1e01a}, {0x1e02b, 0x1e7ff}, {0x1e8c5, 0x1e8c6}, 
                 {0x1e8d7, 0x1e8ff}, {0x1e94b, 0x1e94f}, {0x1e95a, 0x1e95d}, {0x1e960, 0x1ec70}, 
                 {0x1ecb5, 0x1edff}, {0x1ee25, 0x1ee26}, {0x1ee3c, 0x1ee41}, {0x1ee43, 0x1ee46}, 
                 {0x1ee55, 0x1ee56}, {0x1ee65, 0x1ee66}, {0x1ee9c, 0x1eea0}, {0x1eebc, 0x1eeef}, 
                 {0x1eef2, 0x1efff}, {0x1f02c, 0x1f02f}, {0x1f094, 0x1f09f}, {0x1f0af, 0x1f0b0}, 
                 {0x1f0f6, 0x1f0ff}, {0x1f10d, 0x1f10f}, {0x1f16c, 0x1f16f}, {0x1f1ad, 0x1f1e5}, 
                 {0x1f203, 0x1f20f}, {0x1f23c, 0x1f23f}, {0x1f249, 0x1f24f}, {0x1f252, 0x1f25f}, 
                 {0x1f266, 0x1f2ff}, {0x1f6d5, 0x1f6df}, {0x1f6ed, 0x1f6ef}, {0x1f6fa, 0x1f6ff}, 
                 {0x1f774, 0x1f77f}, {0x1f7d9, 0x1f7ff}, {0x1f80c, 0x1f80f}, {0x1f848, 0x1f84f}, 
                 {0x1f85a, 0x1f85f}, {0x1f888, 0x1f88f}, {0x1f8ae, 0x1f8ff}, {0x1f90c, 0x1f90f}, 
                 {0x1f971, 0x1f972}, {0x1f977, 0x1f979}, {0x1f9a3, 0x1f9af}, {0x1f9ba, 0x1f9bf}, 
                 {0x1f9c3, 0x1f9cf}, {0x1fa00, 0x1fa5f}, {0x1fa6e, 0x1ffff}, {0x2a6d7, 0x2a6ff}, 
                 {0x2b735, 0x2b73f}, {0x2b81e, 0x2b81f}, {0x2cea2, 0x2ceaf}, {0x2ebe1, 0x2f7ff}, 
                 {0x2fa1e, 0xe0000}, {0xe0002, 0xe001f}, {0xe0080, 0xe00ff}, {0xe01f0, 0xeffff}, 
                 {0xffffe, 0xfffff}, {0x10fffe, 0x10ffff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass5()
{
    // Name = Letter, number of codePoints: 125419
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<UChar32>({0x00aa, 0x00b5, 0x00ba, 0x02ec, 0x02ee, 0x037f, 0x0386, 0x038c, 
                 0x0559, 0x06d5, 0x06ff, 0x0710, 0x07b1, 0x07fa, 0x081a, 0x0824, 
                 0x0828, 0x093d, 0x0950, 0x09b2, 0x09bd, 0x09ce, 0x09fc, 0x0a5e, 
                 0x0abd, 0x0ad0, 0x0af9, 0x0b3d, 0x0b71, 0x0b83, 0x0b9c, 0x0bd0, 
                 0x0c3d, 0x0c80, 0x0cbd, 0x0cde, 0x0d3d, 0x0d4e, 0x0dbd, 0x0e84, 
                 0x0e8a, 0x0e8d, 0x0ea5, 0x0ea7, 0x0ebd, 0x0ec6, 0x0f00, 0x103f, 
                 0x1061, 0x108e, 0x10c7, 0x10cd, 0x1258, 0x12c0, 0x17d7, 0x17dc, 
                 0x18aa, 0x1aa7, 0x1f59, 0x1f5b, 0x1f5d, 0x1fbe, 0x2071, 0x207f, 
                 0x2102, 0x2107, 0x2115, 0x2124, 0x2126, 0x2128, 0x214e, 0x2d27, 
                 0x2d2d, 0x2d6f, 0x2e2f, 0xa8fb, 0xa9cf, 0xaa7a, 0xaab1, 0xaac0, 
                 0xaac2, 0xfb1d, 0xfb3e, 0x10808, 0x1083c, 0x10a00, 0x10f27, 0x11144, 
                 0x11176, 0x111da, 0x111dc, 0x11288, 0x1133d, 0x11350, 0x114c7, 0x11644, 
                 0x118ff, 0x11a00, 0x11a3a, 0x11a50, 0x11a9d, 0x11c40, 0x11d46, 0x11d98, 
                 0x16f50, 0x1d4a2, 0x1d4bb, 0x1d546, 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 
                 0x1ee42, 0x1ee47, 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 
                 0x1ee5d, 0x1ee5f, 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x02c1}, {0x02c6, 0x02d1}, 
                 {0x02e0, 0x02e4}, {0x0370, 0x0374}, {0x0376, 0x0377}, {0x037a, 0x037d}, 
                 {0x0388, 0x038a}, {0x038e, 0x03a1}, {0x03a3, 0x03f5}, {0x03f7, 0x0481}, 
                 {0x048a, 0x052f}, {0x0531, 0x0556}, {0x0560, 0x0588}, {0x05d0, 0x05ea}, 
                 {0x05ef, 0x05f2}, {0x0620, 0x064a}, {0x066e, 0x066f}, {0x0671, 0x06d3}, 
                 {0x06e5, 0x06e6}, {0x06ee, 0x06ef}, {0x06fa, 0x06fc}, {0x0712, 0x072f}, 
                 {0x074d, 0x07a5}, {0x07ca, 0x07ea}, {0x07f4, 0x07f5}, {0x0800, 0x0815}, 
                 {0x0840, 0x0858}, {0x0860, 0x086a}, {0x08a0, 0x08b4}, {0x08b6, 0x08bd}, 
                 {0x0904, 0x0939}, {0x0958, 0x0961}, {0x0971, 0x0980}, {0x0985, 0x098c}, 
                 {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, {0x09b6, 0x09b9}, 
                 {0x09dc, 0x09dd}, {0x09df, 0x09e1}, {0x09f0, 0x09f1}, {0x0a05, 0x0a0a}, 
                 {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, 
                 {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a59, 0x0a5c}, {0x0a72, 0x0a74}, 
                 {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0}, 
                 {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0ae0, 0x0ae1}, {0x0b05, 0x0b0c}, 
                 {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, 
                 {0x0b35, 0x0b39}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b61}, {0x0b85, 0x0b8a}, 
                 {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9e, 0x0b9f}, 
                 {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, {0x0c05, 0x0c0c}, 
                 {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, {0x0c58, 0x0c5a}, 
                 {0x0c60, 0x0c61}, {0x0c85, 0x0c8c}, {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, 
                 {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0ce0, 0x0ce1}, {0x0cf1, 0x0cf2}, 
                 {0x0d05, 0x0d0c}, {0x0d0e, 0x0d10}, {0x0d12, 0x0d3a}, {0x0d54, 0x0d56}, 
                 {0x0d5f, 0x0d61}, {0x0d7a, 0x0d7f}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, 
                 {0x0db3, 0x0dbb}, {0x0dc0, 0x0dc6}, {0x0e01, 0x0e30}, {0x0e32, 0x0e33}, 
                 {0x0e40, 0x0e46}, {0x0e81, 0x0e82}, {0x0e87, 0x0e88}, {0x0e94, 0x0e97}, 
                 {0x0e99, 0x0e9f}, {0x0ea1, 0x0ea3}, {0x0eaa, 0x0eab}, {0x0ead, 0x0eb0}, 
                 {0x0eb2, 0x0eb3}, {0x0ec0, 0x0ec4}, {0x0edc, 0x0edf}, {0x0f40, 0x0f47}, 
                 {0x0f49, 0x0f6c}, {0x0f88, 0x0f8c}, {0x1000, 0x102a}, {0x1050, 0x1055}, 
                 {0x105a, 0x105d}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081}, 
                 {0x10a0, 0x10c5}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, 
                 {0x1250, 0x1256}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, 
                 {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c2, 0x12c5}, 
                 {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, 
                 {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, 
                 {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16f1, 0x16f8}, 
                 {0x1700, 0x170c}, {0x170e, 0x1711}, {0x1720, 0x1731}, {0x1740, 0x1751}, 
                 {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x1820, 0x1878}, 
                 {0x1880, 0x1884}, {0x1887, 0x18a8}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, 
                 {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, 
                 {0x1a00, 0x1a16}, {0x1a20, 0x1a54}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4b}, 
                 {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, 
                 {0x1c4d, 0x1c4f}, {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, 
                 {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf1}, {0x1cf5, 0x1cf6}, 
                 {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, 
                 {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, 
                 {0x1fb6, 0x1fbc}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, 
                 {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, 
                 {0x2090, 0x209c}, {0x210a, 0x2113}, {0x2119, 0x211d}, {0x212a, 0x212d}, 
                 {0x212f, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149}, {0x2183, 0x2184}, 
                 {0x2c00, 0x2c2e}, {0x2c30, 0x2c5e}, {0x2c60, 0x2ce4}, {0x2ceb, 0x2cee}, 
                 {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d30, 0x2d67}, {0x2d80, 0x2d96}, 
                 {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, 
                 {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, 
                 {0x3005, 0x3006}, {0x3031, 0x3035}, {0x303b, 0x303c}, {0x3041, 0x3096}, 
                 {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, 
                 {0x3131, 0x318e}, {0x31a0, 0x31ba}, {0x31f0, 0x31ff}, {0x3400, 0x4db5}, 
                 {0x4e00, 0x9fef}, {0xa000, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, 
                 {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e}, {0xa67f, 0xa69d}, 
                 {0xa6a0, 0xa6e5}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7b9}, 
                 {0xa7f7, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, 
                 {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fd, 0xa8fe}, 
                 {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, 
                 {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef}, {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, 
                 {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7e, 0xaaaf}, 
                 {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, 
                 {0xaaf2, 0xaaf4}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, 
                 {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab65}, 
                 {0xab70, 0xabe2}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, 
                 {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, 
                 {0xfb1f, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, 
                 {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3d}, {0xfd50, 0xfd8f}, 
                 {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfb}, {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, 
                 {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xffbe}, {0xffc2, 0xffc7}, 
                 {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, 
                 {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, 
                 {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, 
                 {0x10300, 0x1031f}, {0x1032d, 0x10340}, {0x10342, 0x10349}, {0x10350, 0x10375}, 
                 {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x10400, 0x1049d}, 
                 {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, 
                 {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10800, 0x10805}, 
                 {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083f, 0x10855}, {0x10860, 0x10876}, 
                 {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, 
                 {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a10, 0x10a13}, 
                 {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, 
                 {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, 
                 {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, 
                 {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10f00, 0x10f1c}, {0x10f30, 0x10f45}, 
                 {0x11003, 0x11037}, {0x11083, 0x110af}, {0x110d0, 0x110e8}, {0x11103, 0x11126}, 
                 {0x11150, 0x11172}, {0x11183, 0x111b2}, {0x111c1, 0x111c4}, {0x11200, 0x11211}, 
                 {0x11213, 0x1122b}, {0x11280, 0x11286}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, 
                 {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, 
                 {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, 
                 {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x11480, 0x114af}, 
                 {0x114c4, 0x114c5}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, 
                 {0x11680, 0x116aa}, {0x11700, 0x1171a}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, 
                 {0x11a0b, 0x11a32}, {0x11a5c, 0x11a83}, {0x11a86, 0x11a89}, {0x11ac0, 0x11af8}, 
                 {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, 
                 {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, 
                 {0x11d6a, 0x11d89}, {0x11ee0, 0x11ef2}, {0x12000, 0x12399}, {0x12480, 0x12543}, 
                 {0x13000, 0x1342e}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, 
                 {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, 
                 {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f44}, {0x16f93, 0x16f9f}, 
                 {0x16fe0, 0x16fe1}, {0x17000, 0x187f1}, {0x18800, 0x18af2}, {0x1b000, 0x1b11e}, 
                 {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, 
                 {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, 
                 {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, 
                 {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, 
                 {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, 
                 {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, 
                 {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, 
                 {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, 
                 {0x1e800, 0x1e8c4}, {0x1e900, 0x1e943}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, 
                 {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, 
                 {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, 
                 {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, 
                 {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6d6}, 
                 {0x2a700, 0x2b734}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, 
                 {0x2f800, 0x2fa1d}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass6()
{
    // Name = Cased_Letter, number of codePoints: 3957
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<UChar32>({0x00b5, 0x037f, 0x0386, 0x038c, 0x10c7, 0x10cd, 0x1f59, 0x1f5b, 
                 0x1f5d, 0x1fbe, 0x2102, 0x2107, 0x2115, 0x2124, 0x2126, 0x2128, 
                 0x2139, 0x214e, 0x2d27, 0x2d2d, 0xa7fa, 0x1d4a2, 0x1d4bb, 0x1d546}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x01ba}, {0x01bc, 0x01bf}, 
                 {0x01c4, 0x0293}, {0x0295, 0x02af}, {0x0370, 0x0373}, {0x0376, 0x0377}, 
                 {0x037b, 0x037d}, {0x0388, 0x038a}, {0x038e, 0x03a1}, {0x03a3, 0x03f5}, 
                 {0x03f7, 0x0481}, {0x048a, 0x052f}, {0x0531, 0x0556}, {0x0560, 0x0588}, 
                 {0x10a0, 0x10c5}, {0x10d0, 0x10fa}, {0x10fd, 0x10ff}, {0x13a0, 0x13f5}, 
                 {0x13f8, 0x13fd}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, 
                 {0x1d00, 0x1d2b}, {0x1d6b, 0x1d77}, {0x1d79, 0x1d9a}, {0x1e00, 0x1f15}, 
                 {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, 
                 {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fc2, 0x1fc4}, 
                 {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, 
                 {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x210a, 0x2113}, {0x2119, 0x211d}, 
                 {0x212a, 0x212d}, {0x212f, 0x2134}, {0x213c, 0x213f}, {0x2145, 0x2149}, 
                 {0x2183, 0x2184}, {0x2c00, 0x2c2e}, {0x2c30, 0x2c5e}, {0x2c60, 0x2c7b}, 
                 {0x2c7e, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, 
                 {0xa640, 0xa66d}, {0xa680, 0xa69b}, {0xa722, 0xa76f}, {0xa771, 0xa787}, 
                 {0xa78b, 0xa78e}, {0xa790, 0xa7b9}, {0xab30, 0xab5a}, {0xab60, 0xab65}, 
                 {0xab70, 0xabbf}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xff21, 0xff3a}, 
                 {0xff41, 0xff5a}, {0x10400, 0x1044f}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, 
                 {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x118a0, 0x118df}, {0x16e40, 0x16e7f}, 
                 {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, 
                 {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, 
                 {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, 
                 {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, 
                 {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, 
                 {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, 
                 {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1e900, 0x1e943}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass7()
{
    // Name = Control, number of codePoints: 65
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x7f}),
        std::initializer_list<CharacterRange>({{0x00, 0x1f}}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0080, 0x009f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass8()
{
    // Name = Separator, number of codePoints: 19
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x20}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x00a0, 0x1680, 0x202f, 0x205f, 0x3000}),
        std::initializer_list<CharacterRange>({{0x2000, 0x200a}, {0x2028, 0x2029}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass9()
{
    // Name = Space_Separator, number of codePoints: 17
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x20}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x00a0, 0x1680, 0x202f, 0x205f, 0x3000}),
        std::initializer_list<CharacterRange>({{0x2000, 0x200a}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass10()
{
    // Name = Punctuation, number of codePoints: 788
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x5f, 0x7b, 0x7d}),
        std::initializer_list<CharacterRange>({{0x21, 0x23}, {0x25, 0x2a}, {0x2c, 0x2f}, {0x3a, 0x3b}, 
                 {0x3f, 0x40}, {0x5b, 0x5d}}),
        std::initializer_list<UChar32>({0x00a1, 0x00a7, 0x00ab, 0x00bb, 0x00bf, 0x037e, 0x0387, 0x05be, 
                 0x05c0, 0x05c3, 0x05c6, 0x061b, 0x06d4, 0x085e, 0x0970, 0x09fd, 
                 0x0a76, 0x0af0, 0x0c84, 0x0df4, 0x0e4f, 0x0f14, 0x0f85, 0x10fb, 
                 0x1400, 0x1cd3, 0x2d70, 0x3030, 0x303d, 0x30a0, 0x30fb, 0xa673, 
                 0xa67e, 0xa8fc, 0xa95f, 0xabeb, 0xfe63, 0xfe68, 0xff3f, 0xff5b, 
                 0xff5d, 0x1039f, 0x103d0, 0x1056f, 0x10857, 0x1091f, 0x1093f, 0x10a7f, 
                 0x111cd, 0x111db, 0x112a9, 0x1145b, 0x1145d, 0x114c6, 0x1183b, 0x16af5, 
                 0x16b44, 0x1bc9f}),
        std::initializer_list<CharacterRange>({{0x00b6, 0x00b7}, {0x055a, 0x055f}, {0x0589, 0x058a}, {0x05f3, 0x05f4}, 
                 {0x0609, 0x060a}, {0x060c, 0x060d}, {0x061e, 0x061f}, {0x066a, 0x066d}, 
                 {0x0700, 0x070d}, {0x07f7, 0x07f9}, {0x0830, 0x083e}, {0x0964, 0x0965}, 
                 {0x0e5a, 0x0e5b}, {0x0f04, 0x0f12}, {0x0f3a, 0x0f3d}, {0x0fd0, 0x0fd4}, 
                 {0x0fd9, 0x0fda}, {0x104a, 0x104f}, {0x1360, 0x1368}, {0x166d, 0x166e}, 
                 {0x169b, 0x169c}, {0x16eb, 0x16ed}, {0x1735, 0x1736}, {0x17d4, 0x17d6}, 
                 {0x17d8, 0x17da}, {0x1800, 0x180a}, {0x1944, 0x1945}, {0x1a1e, 0x1a1f}, 
                 {0x1aa0, 0x1aa6}, {0x1aa8, 0x1aad}, {0x1b5a, 0x1b60}, {0x1bfc, 0x1bff}, 
                 {0x1c3b, 0x1c3f}, {0x1c7e, 0x1c7f}, {0x1cc0, 0x1cc7}, {0x2010, 0x2027}, 
                 {0x2030, 0x2043}, {0x2045, 0x2051}, {0x2053, 0x205e}, {0x207d, 0x207e}, 
                 {0x208d, 0x208e}, {0x2308, 0x230b}, {0x2329, 0x232a}, {0x2768, 0x2775}, 
                 {0x27c5, 0x27c6}, {0x27e6, 0x27ef}, {0x2983, 0x2998}, {0x29d8, 0x29db}, 
                 {0x29fc, 0x29fd}, {0x2cf9, 0x2cfc}, {0x2cfe, 0x2cff}, {0x2e00, 0x2e2e}, 
                 {0x2e30, 0x2e4e}, {0x3001, 0x3003}, {0x3008, 0x3011}, {0x3014, 0x301f}, 
                 {0xa4fe, 0xa4ff}, {0xa60d, 0xa60f}, {0xa6f2, 0xa6f7}, {0xa874, 0xa877}, 
                 {0xa8ce, 0xa8cf}, {0xa8f8, 0xa8fa}, {0xa92e, 0xa92f}, {0xa9c1, 0xa9cd}, 
                 {0xa9de, 0xa9df}, {0xaa5c, 0xaa5f}, {0xaade, 0xaadf}, {0xaaf0, 0xaaf1}, 
                 {0xfd3e, 0xfd3f}, {0xfe10, 0xfe19}, {0xfe30, 0xfe52}, {0xfe54, 0xfe61}, 
                 {0xfe6a, 0xfe6b}, {0xff01, 0xff03}, {0xff05, 0xff0a}, {0xff0c, 0xff0f}, 
                 {0xff1a, 0xff1b}, {0xff1f, 0xff20}, {0xff3b, 0xff3d}, {0xff5f, 0xff65}, 
                 {0x10100, 0x10102}, {0x10a50, 0x10a58}, {0x10af0, 0x10af6}, {0x10b39, 0x10b3f}, 
                 {0x10b99, 0x10b9c}, {0x10f55, 0x10f59}, {0x11047, 0x1104d}, {0x110bb, 0x110bc}, 
                 {0x110be, 0x110c1}, {0x11140, 0x11143}, {0x11174, 0x11175}, {0x111c5, 0x111c8}, 
                 {0x111dd, 0x111df}, {0x11238, 0x1123d}, {0x1144b, 0x1144f}, {0x115c1, 0x115d7}, 
                 {0x11641, 0x11643}, {0x11660, 0x1166c}, {0x1173c, 0x1173e}, {0x11a3f, 0x11a46}, 
                 {0x11a9a, 0x11a9c}, {0x11a9e, 0x11aa2}, {0x11c41, 0x11c45}, {0x11c70, 0x11c71}, 
                 {0x11ef7, 0x11ef8}, {0x12470, 0x12474}, {0x16a6e, 0x16a6f}, {0x16b37, 0x16b3b}, 
                 {0x16e97, 0x16e9a}, {0x1da87, 0x1da8b}, {0x1e95e, 0x1e95f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass11()
{
    // Name = Other_Punctuation, number of codePoints: 584
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x2a, 0x2c, 0x5c}),
        std::initializer_list<CharacterRange>({{0x21, 0x23}, {0x25, 0x27}, {0x2e, 0x2f}, {0x3a, 0x3b}, 
                 {0x3f, 0x40}}),
        std::initializer_list<UChar32>({0x00a1, 0x00a7, 0x00bf, 0x037e, 0x0387, 0x0589, 0x05c0, 0x05c3, 
                 0x05c6, 0x061b, 0x06d4, 0x085e, 0x0970, 0x09fd, 0x0a76, 0x0af0, 
                 0x0c84, 0x0df4, 0x0e4f, 0x0f14, 0x0f85, 0x10fb, 0x1cd3, 0x2053, 
                 0x2d70, 0x2e0b, 0x2e1b, 0x2e41, 0x303d, 0x30fb, 0xa673, 0xa67e, 
                 0xa8fc, 0xa95f, 0xabeb, 0xfe19, 0xfe30, 0xfe68, 0xff0a, 0xff0c, 
                 0xff3c, 0xff61, 0x1039f, 0x103d0, 0x1056f, 0x10857, 0x1091f, 0x1093f, 
                 0x10a7f, 0x111cd, 0x111db, 0x112a9, 0x1145b, 0x1145d, 0x114c6, 0x1183b, 
                 0x16af5, 0x16b44, 0x1bc9f}),
        std::initializer_list<CharacterRange>({{0x00b6, 0x00b7}, {0x055a, 0x055f}, {0x05f3, 0x05f4}, {0x0609, 0x060a}, 
                 {0x060c, 0x060d}, {0x061e, 0x061f}, {0x066a, 0x066d}, {0x0700, 0x070d}, 
                 {0x07f7, 0x07f9}, {0x0830, 0x083e}, {0x0964, 0x0965}, {0x0e5a, 0x0e5b}, 
                 {0x0f04, 0x0f12}, {0x0fd0, 0x0fd4}, {0x0fd9, 0x0fda}, {0x104a, 0x104f}, 
                 {0x1360, 0x1368}, {0x166d, 0x166e}, {0x16eb, 0x16ed}, {0x1735, 0x1736}, 
                 {0x17d4, 0x17d6}, {0x17d8, 0x17da}, {0x1800, 0x1805}, {0x1807, 0x180a}, 
                 {0x1944, 0x1945}, {0x1a1e, 0x1a1f}, {0x1aa0, 0x1aa6}, {0x1aa8, 0x1aad}, 
                 {0x1b5a, 0x1b60}, {0x1bfc, 0x1bff}, {0x1c3b, 0x1c3f}, {0x1c7e, 0x1c7f}, 
                 {0x1cc0, 0x1cc7}, {0x2016, 0x2017}, {0x2020, 0x2027}, {0x2030, 0x2038}, 
                 {0x203b, 0x203e}, {0x2041, 0x2043}, {0x2047, 0x2051}, {0x2055, 0x205e}, 
                 {0x2cf9, 0x2cfc}, {0x2cfe, 0x2cff}, {0x2e00, 0x2e01}, {0x2e06, 0x2e08}, 
                 {0x2e0e, 0x2e16}, {0x2e18, 0x2e19}, {0x2e1e, 0x2e1f}, {0x2e2a, 0x2e2e}, 
                 {0x2e30, 0x2e39}, {0x2e3c, 0x2e3f}, {0x2e43, 0x2e4e}, {0x3001, 0x3003}, 
                 {0xa4fe, 0xa4ff}, {0xa60d, 0xa60f}, {0xa6f2, 0xa6f7}, {0xa874, 0xa877}, 
                 {0xa8ce, 0xa8cf}, {0xa8f8, 0xa8fa}, {0xa92e, 0xa92f}, {0xa9c1, 0xa9cd}, 
                 {0xa9de, 0xa9df}, {0xaa5c, 0xaa5f}, {0xaade, 0xaadf}, {0xaaf0, 0xaaf1}, 
                 {0xfe10, 0xfe16}, {0xfe45, 0xfe46}, {0xfe49, 0xfe4c}, {0xfe50, 0xfe52}, 
                 {0xfe54, 0xfe57}, {0xfe5f, 0xfe61}, {0xfe6a, 0xfe6b}, {0xff01, 0xff03}, 
                 {0xff05, 0xff07}, {0xff0e, 0xff0f}, {0xff1a, 0xff1b}, {0xff1f, 0xff20}, 
                 {0xff64, 0xff65}, {0x10100, 0x10102}, {0x10a50, 0x10a58}, {0x10af0, 0x10af6}, 
                 {0x10b39, 0x10b3f}, {0x10b99, 0x10b9c}, {0x10f55, 0x10f59}, {0x11047, 0x1104d}, 
                 {0x110bb, 0x110bc}, {0x110be, 0x110c1}, {0x11140, 0x11143}, {0x11174, 0x11175}, 
                 {0x111c5, 0x111c8}, {0x111dd, 0x111df}, {0x11238, 0x1123d}, {0x1144b, 0x1144f}, 
                 {0x115c1, 0x115d7}, {0x11641, 0x11643}, {0x11660, 0x1166c}, {0x1173c, 0x1173e}, 
                 {0x11a3f, 0x11a46}, {0x11a9a, 0x11a9c}, {0x11a9e, 0x11aa2}, {0x11c41, 0x11c45}, 
                 {0x11c70, 0x11c71}, {0x11ef7, 0x11ef8}, {0x12470, 0x12474}, {0x16a6e, 0x16a6f}, 
                 {0x16b37, 0x16b3b}, {0x16e97, 0x16e9a}, {0x1da87, 0x1da8b}, {0x1e95e, 0x1e95f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass12()
{
    // Name = Symbol, number of codePoints: 7110
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x24, 0x2b, 0x5e, 0x60, 0x7c, 0x7e}),
        std::initializer_list<CharacterRange>({{0x3c, 0x3e}}),
        std::initializer_list<UChar32>({0x00ac, 0x00b4, 0x00b8, 0x00d7, 0x00f7, 0x02ed, 0x0375, 0x03f6, 
                 0x0482, 0x060b, 0x06de, 0x06e9, 0x07f6, 0x0af1, 0x0b70, 0x0c7f, 
                 0x0d4f, 0x0d79, 0x0e3f, 0x0f13, 0x0f34, 0x0f36, 0x0f38, 0x17db, 
                 0x1940, 0x1fbd, 0x2044, 0x2052, 0x2114, 0x2125, 0x2127, 0x2129, 
                 0x212e, 0x214f, 0x3004, 0x3020, 0x3250, 0xab5b, 0xfb29, 0xfe62, 
                 0xfe69, 0xff04, 0xff0b, 0xff3e, 0xff40, 0xff5c, 0xff5e, 0x101a0, 
                 0x10ac8, 0x1173f, 0x16b45, 0x1bc9c, 0x1d245, 0x1d6c1, 0x1d6db, 0x1d6fb, 
                 0x1d715, 0x1d735, 0x1d74f, 0x1d76f, 0x1d789, 0x1d7a9, 0x1d7c3, 0x1ecac, 
                 0x1ecb0, 0x1f97a}),
        std::initializer_list<CharacterRange>({{0x00a2, 0x00a6}, {0x00a8, 0x00a9}, {0x00ae, 0x00b1}, {0x02c2, 0x02c5}, 
                 {0x02d2, 0x02df}, {0x02e5, 0x02eb}, {0x02ef, 0x02ff}, {0x0384, 0x0385}, 
                 {0x058d, 0x058f}, {0x0606, 0x0608}, {0x060e, 0x060f}, {0x06fd, 0x06fe}, 
                 {0x07fe, 0x07ff}, {0x09f2, 0x09f3}, {0x09fa, 0x09fb}, {0x0bf3, 0x0bfa}, 
                 {0x0f01, 0x0f03}, {0x0f15, 0x0f17}, {0x0f1a, 0x0f1f}, {0x0fbe, 0x0fc5}, 
                 {0x0fc7, 0x0fcc}, {0x0fce, 0x0fcf}, {0x0fd5, 0x0fd8}, {0x109e, 0x109f}, 
                 {0x1390, 0x1399}, {0x19de, 0x19ff}, {0x1b61, 0x1b6a}, {0x1b74, 0x1b7c}, 
                 {0x1fbf, 0x1fc1}, {0x1fcd, 0x1fcf}, {0x1fdd, 0x1fdf}, {0x1fed, 0x1fef}, 
                 {0x1ffd, 0x1ffe}, {0x207a, 0x207c}, {0x208a, 0x208c}, {0x20a0, 0x20bf}, 
                 {0x2100, 0x2101}, {0x2103, 0x2106}, {0x2108, 0x2109}, {0x2116, 0x2118}, 
                 {0x211e, 0x2123}, {0x213a, 0x213b}, {0x2140, 0x2144}, {0x214a, 0x214d}, 
                 {0x218a, 0x218b}, {0x2190, 0x2307}, {0x230c, 0x2328}, {0x232b, 0x2426}, 
                 {0x2440, 0x244a}, {0x249c, 0x24e9}, {0x2500, 0x2767}, {0x2794, 0x27c4}, 
                 {0x27c7, 0x27e5}, {0x27f0, 0x2982}, {0x2999, 0x29d7}, {0x29dc, 0x29fb}, 
                 {0x29fe, 0x2b73}, {0x2b76, 0x2b95}, {0x2b98, 0x2bc8}, {0x2bca, 0x2bfe}, 
                 {0x2ce5, 0x2cea}, {0x2e80, 0x2e99}, {0x2e9b, 0x2ef3}, {0x2f00, 0x2fd5}, 
                 {0x2ff0, 0x2ffb}, {0x3012, 0x3013}, {0x3036, 0x3037}, {0x303e, 0x303f}, 
                 {0x309b, 0x309c}, {0x3190, 0x3191}, {0x3196, 0x319f}, {0x31c0, 0x31e3}, 
                 {0x3200, 0x321e}, {0x322a, 0x3247}, {0x3260, 0x327f}, {0x328a, 0x32b0}, 
                 {0x32c0, 0x32fe}, {0x3300, 0x33ff}, {0x4dc0, 0x4dff}, {0xa490, 0xa4c6}, 
                 {0xa700, 0xa716}, {0xa720, 0xa721}, {0xa789, 0xa78a}, {0xa828, 0xa82b}, 
                 {0xa836, 0xa839}, {0xaa77, 0xaa79}, {0xfbb2, 0xfbc1}, {0xfdfc, 0xfdfd}, 
                 {0xfe64, 0xfe66}, {0xff1c, 0xff1e}, {0xffe0, 0xffe6}, {0xffe8, 0xffee}, 
                 {0xfffc, 0xfffd}, {0x10137, 0x1013f}, {0x10179, 0x10189}, {0x1018c, 0x1018e}, 
                 {0x10190, 0x1019b}, {0x101d0, 0x101fc}, {0x10877, 0x10878}, {0x16b3c, 0x16b3f}, 
                 {0x1d000, 0x1d0f5}, {0x1d100, 0x1d126}, {0x1d129, 0x1d164}, {0x1d16a, 0x1d16c}, 
                 {0x1d183, 0x1d184}, {0x1d18c, 0x1d1a9}, {0x1d1ae, 0x1d1e8}, {0x1d200, 0x1d241}, 
                 {0x1d300, 0x1d356}, {0x1d800, 0x1d9ff}, {0x1da37, 0x1da3a}, {0x1da6d, 0x1da74}, 
                 {0x1da76, 0x1da83}, {0x1da85, 0x1da86}, {0x1eef0, 0x1eef1}, {0x1f000, 0x1f02b}, 
                 {0x1f030, 0x1f093}, {0x1f0a0, 0x1f0ae}, {0x1f0b1, 0x1f0bf}, {0x1f0c1, 0x1f0cf}, 
                 {0x1f0d1, 0x1f0f5}, {0x1f110, 0x1f16b}, {0x1f170, 0x1f1ac}, {0x1f1e6, 0x1f202}, 
                 {0x1f210, 0x1f23b}, {0x1f240, 0x1f248}, {0x1f250, 0x1f251}, {0x1f260, 0x1f265}, 
                 {0x1f300, 0x1f6d4}, {0x1f6e0, 0x1f6ec}, {0x1f6f0, 0x1f6f9}, {0x1f700, 0x1f773}, 
                 {0x1f780, 0x1f7d8}, {0x1f800, 0x1f80b}, {0x1f810, 0x1f847}, {0x1f850, 0x1f859}, 
                 {0x1f860, 0x1f887}, {0x1f890, 0x1f8ad}, {0x1f900, 0x1f90b}, {0x1f910, 0x1f93e}, 
                 {0x1f940, 0x1f970}, {0x1f973, 0x1f976}, {0x1f97c, 0x1f9a2}, {0x1f9b0, 0x1f9b9}, 
                 {0x1f9c0, 0x1f9c2}, {0x1f9d0, 0x1f9ff}, {0x1fa60, 0x1fa6d}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass13()
{
    // Name = Currency_Symbol, number of codePoints: 57
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x24}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x058f, 0x060b, 0x09fb, 0x0af1, 0x0bf9, 0x0e3f, 0x17db, 0xa838, 
                 0xfdfc, 0xfe69, 0xff04, 0x1ecb0}),
        std::initializer_list<CharacterRange>({{0x00a2, 0x00a5}, {0x07fe, 0x07ff}, {0x09f2, 0x09f3}, {0x20a0, 0x20bf}, 
                 {0xffe0, 0xffe1}, {0xffe5, 0xffe6}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass14()
{
    // Name = Open_Punctuation, number of codePoints: 75
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x28, 0x5b, 0x7b}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0f3a, 0x0f3c, 0x169b, 0x201a, 0x201e, 0x2045, 0x207d, 0x208d, 
                 0x2308, 0x230a, 0x2329, 0x2768, 0x276a, 0x276c, 0x276e, 0x2770, 
                 0x2772, 0x2774, 0x27c5, 0x27e6, 0x27e8, 0x27ea, 0x27ec, 0x27ee, 
                 0x2983, 0x2985, 0x2987, 0x2989, 0x298b, 0x298d, 0x298f, 0x2991, 
                 0x2993, 0x2995, 0x2997, 0x29d8, 0x29da, 0x29fc, 0x2e22, 0x2e24, 
                 0x2e26, 0x2e28, 0x2e42, 0x3008, 0x300a, 0x300c, 0x300e, 0x3010, 
                 0x3014, 0x3016, 0x3018, 0x301a, 0x301d, 0xfd3f, 0xfe17, 0xfe35, 
                 0xfe37, 0xfe39, 0xfe3b, 0xfe3d, 0xfe3f, 0xfe41, 0xfe43, 0xfe47, 
                 0xfe59, 0xfe5b, 0xfe5d, 0xff08, 0xff3b, 0xff5b, 0xff5f, 0xff62}),
        std::initializer_list<CharacterRange>({}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass15()
{
    // Name = Close_Punctuation, number of codePoints: 73
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x29, 0x5d, 0x7d}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0f3b, 0x0f3d, 0x169c, 0x2046, 0x207e, 0x208e, 0x2309, 0x230b, 
                 0x232a, 0x2769, 0x276b, 0x276d, 0x276f, 0x2771, 0x2773, 0x2775, 
                 0x27c6, 0x27e7, 0x27e9, 0x27eb, 0x27ed, 0x27ef, 0x2984, 0x2986, 
                 0x2988, 0x298a, 0x298c, 0x298e, 0x2990, 0x2992, 0x2994, 0x2996, 
                 0x2998, 0x29d9, 0x29db, 0x29fd, 0x2e23, 0x2e25, 0x2e27, 0x2e29, 
                 0x3009, 0x300b, 0x300d, 0x300f, 0x3011, 0x3015, 0x3017, 0x3019, 
                 0x301b, 0xfd3e, 0xfe18, 0xfe36, 0xfe38, 0xfe3a, 0xfe3c, 0xfe3e, 
                 0xfe40, 0xfe42, 0xfe44, 0xfe48, 0xfe5a, 0xfe5c, 0xfe5e, 0xff09, 
                 0xff3d, 0xff5d, 0xff60, 0xff63}),
        std::initializer_list<CharacterRange>({{0x301e, 0x301f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass16()
{
    // Name = Math_Symbol, number of codePoints: 948
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x2b, 0x7c, 0x7e}),
        std::initializer_list<CharacterRange>({{0x3c, 0x3e}}),
        std::initializer_list<UChar32>({0x00ac, 0x00b1, 0x00d7, 0x00f7, 0x03f6, 0x2044, 0x2052, 0x2118, 
                 0x214b, 0x21a0, 0x21a3, 0x21a6, 0x21ae, 0x21d2, 0x21d4, 0x237c, 
                 0x25b7, 0x25c1, 0x266f, 0xfb29, 0xfe62, 0xff0b, 0xff5c, 0xff5e, 
                 0xffe2, 0x1d6c1, 0x1d6db, 0x1d6fb, 0x1d715, 0x1d735, 0x1d74f, 0x1d76f, 
                 0x1d789, 0x1d7a9, 0x1d7c3}),
        std::initializer_list<CharacterRange>({{0x0606, 0x0608}, {0x207a, 0x207c}, {0x208a, 0x208c}, {0x2140, 0x2144}, 
                 {0x2190, 0x2194}, {0x219a, 0x219b}, {0x21ce, 0x21cf}, {0x21f4, 0x22ff}, 
                 {0x2320, 0x2321}, {0x239b, 0x23b3}, {0x23dc, 0x23e1}, {0x25f8, 0x25ff}, 
                 {0x27c0, 0x27c4}, {0x27c7, 0x27e5}, {0x27f0, 0x27ff}, {0x2900, 0x2982}, 
                 {0x2999, 0x29d7}, {0x29dc, 0x29fb}, {0x29fe, 0x2aff}, {0x2b30, 0x2b44}, 
                 {0x2b47, 0x2b4c}, {0xfe64, 0xfe66}, {0xff1c, 0xff1e}, {0xffe9, 0xffec}, 
                 {0x1eef0, 0x1eef1}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass17()
{
    // Name = Dash_Punctuation, number of codePoints: 24
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x2d}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x058a, 0x05be, 0x1400, 0x1806, 0x2e17, 0x2e1a, 0x2e40, 0x301c, 
                 0x3030, 0x30a0, 0xfe58, 0xfe63, 0xff0d}),
        std::initializer_list<CharacterRange>({{0x2010, 0x2015}, {0x2e3a, 0x2e3b}, {0xfe31, 0xfe32}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass18()
{
    // Name = Number, number of codePoints: 1653
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x30, 0x39}}),
        std::initializer_list<UChar32>({0x00b9, 0x2070, 0x2cfd, 0x3007, 0x10341, 0x1034a}),
        std::initializer_list<CharacterRange>({{0x00b2, 0x00b3}, {0x00bc, 0x00be}, {0x0660, 0x0669}, {0x06f0, 0x06f9}, 
                 {0x07c0, 0x07c9}, {0x0966, 0x096f}, {0x09e6, 0x09ef}, {0x09f4, 0x09f9}, 
                 {0x0a66, 0x0a6f}, {0x0ae6, 0x0aef}, {0x0b66, 0x0b6f}, {0x0b72, 0x0b77}, 
                 {0x0be6, 0x0bf2}, {0x0c66, 0x0c6f}, {0x0c78, 0x0c7e}, {0x0ce6, 0x0cef}, 
                 {0x0d58, 0x0d5e}, {0x0d66, 0x0d78}, {0x0de6, 0x0def}, {0x0e50, 0x0e59}, 
                 {0x0ed0, 0x0ed9}, {0x0f20, 0x0f33}, {0x1040, 0x1049}, {0x1090, 0x1099}, 
                 {0x1369, 0x137c}, {0x16ee, 0x16f0}, {0x17e0, 0x17e9}, {0x17f0, 0x17f9}, 
                 {0x1810, 0x1819}, {0x1946, 0x194f}, {0x19d0, 0x19da}, {0x1a80, 0x1a89}, 
                 {0x1a90, 0x1a99}, {0x1b50, 0x1b59}, {0x1bb0, 0x1bb9}, {0x1c40, 0x1c49}, 
                 {0x1c50, 0x1c59}, {0x2074, 0x2079}, {0x2080, 0x2089}, {0x2150, 0x2182}, 
                 {0x2185, 0x2189}, {0x2460, 0x249b}, {0x24ea, 0x24ff}, {0x2776, 0x2793}, 
                 {0x3021, 0x3029}, {0x3038, 0x303a}, {0x3192, 0x3195}, {0x3220, 0x3229}, 
                 {0x3248, 0x324f}, {0x3251, 0x325f}, {0x3280, 0x3289}, {0x32b1, 0x32bf}, 
                 {0xa620, 0xa629}, {0xa6e6, 0xa6ef}, {0xa830, 0xa835}, {0xa8d0, 0xa8d9}, 
                 {0xa900, 0xa909}, {0xa9d0, 0xa9d9}, {0xa9f0, 0xa9f9}, {0xaa50, 0xaa59}, 
                 {0xabf0, 0xabf9}, {0xff10, 0xff19}, {0x10107, 0x10133}, {0x10140, 0x10178}, 
                 {0x1018a, 0x1018b}, {0x102e1, 0x102fb}, {0x10320, 0x10323}, {0x103d1, 0x103d5}, 
                 {0x104a0, 0x104a9}, {0x10858, 0x1085f}, {0x10879, 0x1087f}, {0x108a7, 0x108af}, 
                 {0x108fb, 0x108ff}, {0x10916, 0x1091b}, {0x109bc, 0x109bd}, {0x109c0, 0x109cf}, 
                 {0x109d2, 0x109ff}, {0x10a40, 0x10a48}, {0x10a7d, 0x10a7e}, {0x10a9d, 0x10a9f}, 
                 {0x10aeb, 0x10aef}, {0x10b58, 0x10b5f}, {0x10b78, 0x10b7f}, {0x10ba9, 0x10baf}, 
                 {0x10cfa, 0x10cff}, {0x10d30, 0x10d39}, {0x10e60, 0x10e7e}, {0x10f1d, 0x10f26}, 
                 {0x10f51, 0x10f54}, {0x11052, 0x1106f}, {0x110f0, 0x110f9}, {0x11136, 0x1113f}, 
                 {0x111d0, 0x111d9}, {0x111e1, 0x111f4}, {0x112f0, 0x112f9}, {0x11450, 0x11459}, 
                 {0x114d0, 0x114d9}, {0x11650, 0x11659}, {0x116c0, 0x116c9}, {0x11730, 0x1173b}, 
                 {0x118e0, 0x118f2}, {0x11c50, 0x11c6c}, {0x11d50, 0x11d59}, {0x11da0, 0x11da9}, 
                 {0x12400, 0x1246e}, {0x16a60, 0x16a69}, {0x16b50, 0x16b59}, {0x16b5b, 0x16b61}, 
                 {0x16e80, 0x16e96}, {0x1d2e0, 0x1d2f3}, {0x1d360, 0x1d378}, {0x1d7ce, 0x1d7ff}, 
                 {0x1e8c7, 0x1e8cf}, {0x1e950, 0x1e959}, {0x1ec71, 0x1ecab}, {0x1ecad, 0x1ecaf}, 
                 {0x1ecb1, 0x1ecb4}, {0x1f100, 0x1f10c}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass19()
{
    // Name = Decimal_Number, number of codePoints: 610
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x30, 0x39}}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0660, 0x0669}, {0x06f0, 0x06f9}, {0x07c0, 0x07c9}, {0x0966, 0x096f}, 
                 {0x09e6, 0x09ef}, {0x0a66, 0x0a6f}, {0x0ae6, 0x0aef}, {0x0b66, 0x0b6f}, 
                 {0x0be6, 0x0bef}, {0x0c66, 0x0c6f}, {0x0ce6, 0x0cef}, {0x0d66, 0x0d6f}, 
                 {0x0de6, 0x0def}, {0x0e50, 0x0e59}, {0x0ed0, 0x0ed9}, {0x0f20, 0x0f29}, 
                 {0x1040, 0x1049}, {0x1090, 0x1099}, {0x17e0, 0x17e9}, {0x1810, 0x1819}, 
                 {0x1946, 0x194f}, {0x19d0, 0x19d9}, {0x1a80, 0x1a89}, {0x1a90, 0x1a99}, 
                 {0x1b50, 0x1b59}, {0x1bb0, 0x1bb9}, {0x1c40, 0x1c49}, {0x1c50, 0x1c59}, 
                 {0xa620, 0xa629}, {0xa8d0, 0xa8d9}, {0xa900, 0xa909}, {0xa9d0, 0xa9d9}, 
                 {0xa9f0, 0xa9f9}, {0xaa50, 0xaa59}, {0xabf0, 0xabf9}, {0xff10, 0xff19}, 
                 {0x104a0, 0x104a9}, {0x10d30, 0x10d39}, {0x11066, 0x1106f}, {0x110f0, 0x110f9}, 
                 {0x11136, 0x1113f}, {0x111d0, 0x111d9}, {0x112f0, 0x112f9}, {0x11450, 0x11459}, 
                 {0x114d0, 0x114d9}, {0x11650, 0x11659}, {0x116c0, 0x116c9}, {0x11730, 0x11739}, 
                 {0x118e0, 0x118e9}, {0x11c50, 0x11c59}, {0x11d50, 0x11d59}, {0x11da0, 0x11da9}, 
                 {0x16a60, 0x16a69}, {0x16b50, 0x16b59}, {0x1d7ce, 0x1d7ff}, {0x1e950, 0x1e959}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass20()
{
    // Name = Uppercase_Letter, number of codePoints: 1781
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}}),
        std::initializer_list<UChar32>({0x0100, 0x0102, 0x0104, 0x0106, 0x0108, 0x010a, 0x010c, 0x010e, 
                 0x0110, 0x0112, 0x0114, 0x0116, 0x0118, 0x011a, 0x011c, 0x011e, 
                 0x0120, 0x0122, 0x0124, 0x0126, 0x0128, 0x012a, 0x012c, 0x012e, 
                 0x0130, 0x0132, 0x0134, 0x0136, 0x0139, 0x013b, 0x013d, 0x013f, 
                 0x0141, 0x0143, 0x0145, 0x0147, 0x014a, 0x014c, 0x014e, 0x0150, 
                 0x0152, 0x0154, 0x0156, 0x0158, 0x015a, 0x015c, 0x015e, 0x0160, 
                 0x0162, 0x0164, 0x0166, 0x0168, 0x016a, 0x016c, 0x016e, 0x0170, 
                 0x0172, 0x0174, 0x0176, 0x017b, 0x017d, 0x0184, 0x01a2, 0x01a4, 
                 0x01a9, 0x01ac, 0x01b5, 0x01bc, 0x01c4, 0x01c7, 0x01ca, 0x01cd, 
                 0x01cf, 0x01d1, 0x01d3, 0x01d5, 0x01d7, 0x01d9, 0x01db, 0x01de, 
                 0x01e0, 0x01e2, 0x01e4, 0x01e6, 0x01e8, 0x01ea, 0x01ec, 0x01ee, 
                 0x01f1, 0x01f4, 0x01fa, 0x01fc, 0x01fe, 0x0200, 0x0202, 0x0204, 
                 0x0206, 0x0208, 0x020a, 0x020c, 0x020e, 0x0210, 0x0212, 0x0214, 
                 0x0216, 0x0218, 0x021a, 0x021c, 0x021e, 0x0220, 0x0222, 0x0224, 
                 0x0226, 0x0228, 0x022a, 0x022c, 0x022e, 0x0230, 0x0232, 0x0241, 
                 0x0248, 0x024a, 0x024c, 0x024e, 0x0370, 0x0372, 0x0376, 0x037f, 
                 0x0386, 0x038c, 0x03cf, 0x03d8, 0x03da, 0x03dc, 0x03de, 0x03e0, 
                 0x03e2, 0x03e4, 0x03e6, 0x03e8, 0x03ea, 0x03ec, 0x03ee, 0x03f4, 
                 0x03f7, 0x0460, 0x0462, 0x0464, 0x0466, 0x0468, 0x046a, 0x046c, 
                 0x046e, 0x0470, 0x0472, 0x0474, 0x0476, 0x0478, 0x047a, 0x047c, 
                 0x047e, 0x0480, 0x048a, 0x048c, 0x048e, 0x0490, 0x0492, 0x0494, 
                 0x0496, 0x0498, 0x049a, 0x049c, 0x049e, 0x04a0, 0x04a2, 0x04a4, 
                 0x04a6, 0x04a8, 0x04aa, 0x04ac, 0x04ae, 0x04b0, 0x04b2, 0x04b4, 
                 0x04b6, 0x04b8, 0x04ba, 0x04bc, 0x04be, 0x04c3, 0x04c5, 0x04c7, 
                 0x04c9, 0x04cb, 0x04cd, 0x04d0, 0x04d2, 0x04d4, 0x04d6, 0x04d8, 
                 0x04da, 0x04dc, 0x04de, 0x04e0, 0x04e2, 0x04e4, 0x04e6, 0x04e8, 
                 0x04ea, 0x04ec, 0x04ee, 0x04f0, 0x04f2, 0x04f4, 0x04f6, 0x04f8, 
                 0x04fa, 0x04fc, 0x04fe, 0x0500, 0x0502, 0x0504, 0x0506, 0x0508, 
                 0x050a, 0x050c, 0x050e, 0x0510, 0x0512, 0x0514, 0x0516, 0x0518, 
                 0x051a, 0x051c, 0x051e, 0x0520, 0x0522, 0x0524, 0x0526, 0x0528, 
                 0x052a, 0x052c, 0x052e, 0x10c7, 0x10cd, 0x1e00, 0x1e02, 0x1e04, 
                 0x1e06, 0x1e08, 0x1e0a, 0x1e0c, 0x1e0e, 0x1e10, 0x1e12, 0x1e14, 
                 0x1e16, 0x1e18, 0x1e1a, 0x1e1c, 0x1e1e, 0x1e20, 0x1e22, 0x1e24, 
                 0x1e26, 0x1e28, 0x1e2a, 0x1e2c, 0x1e2e, 0x1e30, 0x1e32, 0x1e34, 
                 0x1e36, 0x1e38, 0x1e3a, 0x1e3c, 0x1e3e, 0x1e40, 0x1e42, 0x1e44, 
                 0x1e46, 0x1e48, 0x1e4a, 0x1e4c, 0x1e4e, 0x1e50, 0x1e52, 0x1e54, 
                 0x1e56, 0x1e58, 0x1e5a, 0x1e5c, 0x1e5e, 0x1e60, 0x1e62, 0x1e64, 
                 0x1e66, 0x1e68, 0x1e6a, 0x1e6c, 0x1e6e, 0x1e70, 0x1e72, 0x1e74, 
                 0x1e76, 0x1e78, 0x1e7a, 0x1e7c, 0x1e7e, 0x1e80, 0x1e82, 0x1e84, 
                 0x1e86, 0x1e88, 0x1e8a, 0x1e8c, 0x1e8e, 0x1e90, 0x1e92, 0x1e94, 
                 0x1e9e, 0x1ea0, 0x1ea2, 0x1ea4, 0x1ea6, 0x1ea8, 0x1eaa, 0x1eac, 
                 0x1eae, 0x1eb0, 0x1eb2, 0x1eb4, 0x1eb6, 0x1eb8, 0x1eba, 0x1ebc, 
                 0x1ebe, 0x1ec0, 0x1ec2, 0x1ec4, 0x1ec6, 0x1ec8, 0x1eca, 0x1ecc, 
                 0x1ece, 0x1ed0, 0x1ed2, 0x1ed4, 0x1ed6, 0x1ed8, 0x1eda, 0x1edc, 
                 0x1ede, 0x1ee0, 0x1ee2, 0x1ee4, 0x1ee6, 0x1ee8, 0x1eea, 0x1eec, 
                 0x1eee, 0x1ef0, 0x1ef2, 0x1ef4, 0x1ef6, 0x1ef8, 0x1efa, 0x1efc, 
                 0x1efe, 0x1f59, 0x1f5b, 0x1f5d, 0x1f5f, 0x2102, 0x2107, 0x2115, 
                 0x2124, 0x2126, 0x2128, 0x2145, 0x2183, 0x2c60, 0x2c67, 0x2c69, 
                 0x2c6b, 0x2c72, 0x2c75, 0x2c82, 0x2c84, 0x2c86, 0x2c88, 0x2c8a, 
                 0x2c8c, 0x2c8e, 0x2c90, 0x2c92, 0x2c94, 0x2c96, 0x2c98, 0x2c9a, 
                 0x2c9c, 0x2c9e, 0x2ca0, 0x2ca2, 0x2ca4, 0x2ca6, 0x2ca8, 0x2caa, 
                 0x2cac, 0x2cae, 0x2cb0, 0x2cb2, 0x2cb4, 0x2cb6, 0x2cb8, 0x2cba, 
                 0x2cbc, 0x2cbe, 0x2cc0, 0x2cc2, 0x2cc4, 0x2cc6, 0x2cc8, 0x2cca, 
                 0x2ccc, 0x2cce, 0x2cd0, 0x2cd2, 0x2cd4, 0x2cd6, 0x2cd8, 0x2cda, 
                 0x2cdc, 0x2cde, 0x2ce0, 0x2ce2, 0x2ceb, 0x2ced, 0x2cf2, 0xa640, 
                 0xa642, 0xa644, 0xa646, 0xa648, 0xa64a, 0xa64c, 0xa64e, 0xa650, 
                 0xa652, 0xa654, 0xa656, 0xa658, 0xa65a, 0xa65c, 0xa65e, 0xa660, 
                 0xa662, 0xa664, 0xa666, 0xa668, 0xa66a, 0xa66c, 0xa680, 0xa682, 
                 0xa684, 0xa686, 0xa688, 0xa68a, 0xa68c, 0xa68e, 0xa690, 0xa692, 
                 0xa694, 0xa696, 0xa698, 0xa69a, 0xa722, 0xa724, 0xa726, 0xa728, 
                 0xa72a, 0xa72c, 0xa72e, 0xa732, 0xa734, 0xa736, 0xa738, 0xa73a, 
                 0xa73c, 0xa73e, 0xa740, 0xa742, 0xa744, 0xa746, 0xa748, 0xa74a, 
                 0xa74c, 0xa74e, 0xa750, 0xa752, 0xa754, 0xa756, 0xa758, 0xa75a, 
                 0xa75c, 0xa75e, 0xa760, 0xa762, 0xa764, 0xa766, 0xa768, 0xa76a, 
                 0xa76c, 0xa76e, 0xa779, 0xa77b, 0xa780, 0xa782, 0xa784, 0xa786, 
                 0xa78b, 0xa78d, 0xa790, 0xa792, 0xa796, 0xa798, 0xa79a, 0xa79c, 
                 0xa79e, 0xa7a0, 0xa7a2, 0xa7a4, 0xa7a6, 0xa7a8, 0xa7b6, 0xa7b8, 
                 0x1d49c, 0x1d4a2, 0x1d546, 0x1d7ca}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00de}, {0x0178, 0x0179}, {0x0181, 0x0182}, 
                 {0x0186, 0x0187}, {0x0189, 0x018b}, {0x018e, 0x0191}, {0x0193, 0x0194}, 
                 {0x0196, 0x0198}, {0x019c, 0x019d}, {0x019f, 0x01a0}, {0x01a6, 0x01a7}, 
                 {0x01ae, 0x01af}, {0x01b1, 0x01b3}, {0x01b7, 0x01b8}, {0x01f6, 0x01f8}, 
                 {0x023a, 0x023b}, {0x023d, 0x023e}, {0x0243, 0x0246}, {0x0388, 0x038a}, 
                 {0x038e, 0x038f}, {0x0391, 0x03a1}, {0x03a3, 0x03ab}, {0x03d2, 0x03d4}, 
                 {0x03f9, 0x03fa}, {0x03fd, 0x042f}, {0x04c0, 0x04c1}, {0x0531, 0x0556}, 
                 {0x10a0, 0x10c5}, {0x13a0, 0x13f5}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, 
                 {0x1f08, 0x1f0f}, {0x1f18, 0x1f1d}, {0x1f28, 0x1f2f}, {0x1f38, 0x1f3f}, 
                 {0x1f48, 0x1f4d}, {0x1f68, 0x1f6f}, {0x1fb8, 0x1fbb}, {0x1fc8, 0x1fcb}, 
                 {0x1fd8, 0x1fdb}, {0x1fe8, 0x1fec}, {0x1ff8, 0x1ffb}, {0x210b, 0x210d}, 
                 {0x2110, 0x2112}, {0x2119, 0x211d}, {0x212a, 0x212d}, {0x2130, 0x2133}, 
                 {0x213e, 0x213f}, {0x2c00, 0x2c2e}, {0x2c62, 0x2c64}, {0x2c6d, 0x2c70}, 
                 {0x2c7e, 0x2c80}, {0xa77d, 0xa77e}, {0xa7aa, 0xa7ae}, {0xa7b0, 0xa7b4}, 
                 {0xff21, 0xff3a}, {0x10400, 0x10427}, {0x104b0, 0x104d3}, {0x10c80, 0x10cb2}, 
                 {0x118a0, 0x118bf}, {0x16e40, 0x16e5f}, {0x1d400, 0x1d419}, {0x1d434, 0x1d44d}, 
                 {0x1d468, 0x1d481}, {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, 
                 {0x1d4ae, 0x1d4b5}, {0x1d4d0, 0x1d4e9}, {0x1d504, 0x1d505}, {0x1d507, 0x1d50a}, 
                 {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d538, 0x1d539}, {0x1d53b, 0x1d53e}, 
                 {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, {0x1d56c, 0x1d585}, {0x1d5a0, 0x1d5b9}, 
                 {0x1d5d4, 0x1d5ed}, {0x1d608, 0x1d621}, {0x1d63c, 0x1d655}, {0x1d670, 0x1d689}, 
                 {0x1d6a8, 0x1d6c0}, {0x1d6e2, 0x1d6fa}, {0x1d71c, 0x1d734}, {0x1d756, 0x1d76e}, 
                 {0x1d790, 0x1d7a8}, {0x1e900, 0x1e921}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass21()
{
    // Name = Modifier_Symbol, number of codePoints: 121
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x5e, 0x60}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x00a8, 0x00af, 0x00b4, 0x00b8, 0x02ed, 0x0375, 0x1fbd, 0xab5b, 
                 0xff3e, 0xff40, 0xffe3}),
        std::initializer_list<CharacterRange>({{0x02c2, 0x02c5}, {0x02d2, 0x02df}, {0x02e5, 0x02eb}, {0x02ef, 0x02ff}, 
                 {0x0384, 0x0385}, {0x1fbf, 0x1fc1}, {0x1fcd, 0x1fcf}, {0x1fdd, 0x1fdf}, 
                 {0x1fed, 0x1fef}, {0x1ffd, 0x1ffe}, {0x309b, 0x309c}, {0xa700, 0xa716}, 
                 {0xa720, 0xa721}, {0xa789, 0xa78a}, {0xfbb2, 0xfbc1}, {0x1f3fb, 0x1f3ff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass22()
{
    // Name = Connector_Punctuation, number of codePoints: 10
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x5f}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x2054, 0xff3f}),
        std::initializer_list<CharacterRange>({{0x203f, 0x2040}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass23()
{
    // Name = Lowercase_Letter, number of codePoints: 2145
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x61, 0x7a}}),
        std::initializer_list<UChar32>({0x00b5, 0x0101, 0x0103, 0x0105, 0x0107, 0x0109, 0x010b, 0x010d, 
                 0x010f, 0x0111, 0x0113, 0x0115, 0x0117, 0x0119, 0x011b, 0x011d, 
                 0x011f, 0x0121, 0x0123, 0x0125, 0x0127, 0x0129, 0x012b, 0x012d, 
                 0x012f, 0x0131, 0x0133, 0x0135, 0x013a, 0x013c, 0x013e, 0x0140, 
                 0x0142, 0x0144, 0x0146, 0x014b, 0x014d, 0x014f, 0x0151, 0x0153, 
                 0x0155, 0x0157, 0x0159, 0x015b, 0x015d, 0x015f, 0x0161, 0x0163, 
                 0x0165, 0x0167, 0x0169, 0x016b, 0x016d, 0x016f, 0x0171, 0x0173, 
                 0x0175, 0x0177, 0x017a, 0x017c, 0x0183, 0x0185, 0x0188, 0x0192, 
                 0x0195, 0x019e, 0x01a1, 0x01a3, 0x01a5, 0x01a8, 0x01ad, 0x01b0, 
                 0x01b4, 0x01b6, 0x01c6, 0x01c9, 0x01cc, 0x01ce, 0x01d0, 0x01d2, 
                 0x01d4, 0x01d6, 0x01d8, 0x01da, 0x01df, 0x01e1, 0x01e3, 0x01e5, 
                 0x01e7, 0x01e9, 0x01eb, 0x01ed, 0x01f3, 0x01f5, 0x01f9, 0x01fb, 
                 0x01fd, 0x01ff, 0x0201, 0x0203, 0x0205, 0x0207, 0x0209, 0x020b, 
                 0x020d, 0x020f, 0x0211, 0x0213, 0x0215, 0x0217, 0x0219, 0x021b, 
                 0x021d, 0x021f, 0x0221, 0x0223, 0x0225, 0x0227, 0x0229, 0x022b, 
                 0x022d, 0x022f, 0x0231, 0x023c, 0x0242, 0x0247, 0x0249, 0x024b, 
                 0x024d, 0x0371, 0x0373, 0x0377, 0x0390, 0x03d9, 0x03db, 0x03dd, 
                 0x03df, 0x03e1, 0x03e3, 0x03e5, 0x03e7, 0x03e9, 0x03eb, 0x03ed, 
                 0x03f5, 0x03f8, 0x0461, 0x0463, 0x0465, 0x0467, 0x0469, 0x046b, 
                 0x046d, 0x046f, 0x0471, 0x0473, 0x0475, 0x0477, 0x0479, 0x047b, 
                 0x047d, 0x047f, 0x0481, 0x048b, 0x048d, 0x048f, 0x0491, 0x0493, 
                 0x0495, 0x0497, 0x0499, 0x049b, 0x049d, 0x049f, 0x04a1, 0x04a3, 
                 0x04a5, 0x04a7, 0x04a9, 0x04ab, 0x04ad, 0x04af, 0x04b1, 0x04b3, 
                 0x04b5, 0x04b7, 0x04b9, 0x04bb, 0x04bd, 0x04bf, 0x04c2, 0x04c4, 
                 0x04c6, 0x04c8, 0x04ca, 0x04cc, 0x04d1, 0x04d3, 0x04d5, 0x04d7, 
                 0x04d9, 0x04db, 0x04dd, 0x04df, 0x04e1, 0x04e3, 0x04e5, 0x04e7, 
                 0x04e9, 0x04eb, 0x04ed, 0x04ef, 0x04f1, 0x04f3, 0x04f5, 0x04f7, 
                 0x04f9, 0x04fb, 0x04fd, 0x04ff, 0x0501, 0x0503, 0x0505, 0x0507, 
                 0x0509, 0x050b, 0x050d, 0x050f, 0x0511, 0x0513, 0x0515, 0x0517, 
                 0x0519, 0x051b, 0x051d, 0x051f, 0x0521, 0x0523, 0x0525, 0x0527, 
                 0x0529, 0x052b, 0x052d, 0x052f, 0x1e01, 0x1e03, 0x1e05, 0x1e07, 
                 0x1e09, 0x1e0b, 0x1e0d, 0x1e0f, 0x1e11, 0x1e13, 0x1e15, 0x1e17, 
                 0x1e19, 0x1e1b, 0x1e1d, 0x1e1f, 0x1e21, 0x1e23, 0x1e25, 0x1e27, 
                 0x1e29, 0x1e2b, 0x1e2d, 0x1e2f, 0x1e31, 0x1e33, 0x1e35, 0x1e37, 
                 0x1e39, 0x1e3b, 0x1e3d, 0x1e3f, 0x1e41, 0x1e43, 0x1e45, 0x1e47, 
                 0x1e49, 0x1e4b, 0x1e4d, 0x1e4f, 0x1e51, 0x1e53, 0x1e55, 0x1e57, 
                 0x1e59, 0x1e5b, 0x1e5d, 0x1e5f, 0x1e61, 0x1e63, 0x1e65, 0x1e67, 
                 0x1e69, 0x1e6b, 0x1e6d, 0x1e6f, 0x1e71, 0x1e73, 0x1e75, 0x1e77, 
                 0x1e79, 0x1e7b, 0x1e7d, 0x1e7f, 0x1e81, 0x1e83, 0x1e85, 0x1e87, 
                 0x1e89, 0x1e8b, 0x1e8d, 0x1e8f, 0x1e91, 0x1e93, 0x1e9f, 0x1ea1, 
                 0x1ea3, 0x1ea5, 0x1ea7, 0x1ea9, 0x1eab, 0x1ead, 0x1eaf, 0x1eb1, 
                 0x1eb3, 0x1eb5, 0x1eb7, 0x1eb9, 0x1ebb, 0x1ebd, 0x1ebf, 0x1ec1, 
                 0x1ec3, 0x1ec5, 0x1ec7, 0x1ec9, 0x1ecb, 0x1ecd, 0x1ecf, 0x1ed1, 
                 0x1ed3, 0x1ed5, 0x1ed7, 0x1ed9, 0x1edb, 0x1edd, 0x1edf, 0x1ee1, 
                 0x1ee3, 0x1ee5, 0x1ee7, 0x1ee9, 0x1eeb, 0x1eed, 0x1eef, 0x1ef1, 
                 0x1ef3, 0x1ef5, 0x1ef7, 0x1ef9, 0x1efb, 0x1efd, 0x1fbe, 0x210a, 
                 0x2113, 0x212f, 0x2134, 0x2139, 0x214e, 0x2184, 0x2c61, 0x2c68, 
                 0x2c6a, 0x2c6c, 0x2c71, 0x2c81, 0x2c83, 0x2c85, 0x2c87, 0x2c89, 
                 0x2c8b, 0x2c8d, 0x2c8f, 0x2c91, 0x2c93, 0x2c95, 0x2c97, 0x2c99, 
                 0x2c9b, 0x2c9d, 0x2c9f, 0x2ca1, 0x2ca3, 0x2ca5, 0x2ca7, 0x2ca9, 
                 0x2cab, 0x2cad, 0x2caf, 0x2cb1, 0x2cb3, 0x2cb5, 0x2cb7, 0x2cb9, 
                 0x2cbb, 0x2cbd, 0x2cbf, 0x2cc1, 0x2cc3, 0x2cc5, 0x2cc7, 0x2cc9, 
                 0x2ccb, 0x2ccd, 0x2ccf, 0x2cd1, 0x2cd3, 0x2cd5, 0x2cd7, 0x2cd9, 
                 0x2cdb, 0x2cdd, 0x2cdf, 0x2ce1, 0x2cec, 0x2cee, 0x2cf3, 0x2d27, 
                 0x2d2d, 0xa641, 0xa643, 0xa645, 0xa647, 0xa649, 0xa64b, 0xa64d, 
                 0xa64f, 0xa651, 0xa653, 0xa655, 0xa657, 0xa659, 0xa65b, 0xa65d, 
                 0xa65f, 0xa661, 0xa663, 0xa665, 0xa667, 0xa669, 0xa66b, 0xa66d, 
                 0xa681, 0xa683, 0xa685, 0xa687, 0xa689, 0xa68b, 0xa68d, 0xa68f, 
                 0xa691, 0xa693, 0xa695, 0xa697, 0xa699, 0xa69b, 0xa723, 0xa725, 
                 0xa727, 0xa729, 0xa72b, 0xa72d, 0xa733, 0xa735, 0xa737, 0xa739, 
                 0xa73b, 0xa73d, 0xa73f, 0xa741, 0xa743, 0xa745, 0xa747, 0xa749, 
                 0xa74b, 0xa74d, 0xa74f, 0xa751, 0xa753, 0xa755, 0xa757, 0xa759, 
                 0xa75b, 0xa75d, 0xa75f, 0xa761, 0xa763, 0xa765, 0xa767, 0xa769, 
                 0xa76b, 0xa76d, 0xa76f, 0xa77a, 0xa77c, 0xa77f, 0xa781, 0xa783, 
                 0xa785, 0xa787, 0xa78c, 0xa78e, 0xa791, 0xa797, 0xa799, 0xa79b, 
                 0xa79d, 0xa79f, 0xa7a1, 0xa7a3, 0xa7a5, 0xa7a7, 0xa7a9, 0xa7af, 
                 0xa7b5, 0xa7b7, 0xa7b9, 0xa7fa, 0x1d4bb, 0x1d7cb}),
        std::initializer_list<CharacterRange>({{0x00df, 0x00f6}, {0x00f8, 0x00ff}, {0x0137, 0x0138}, {0x0148, 0x0149}, 
                 {0x017e, 0x0180}, {0x018c, 0x018d}, {0x0199, 0x019b}, {0x01aa, 0x01ab}, 
                 {0x01b9, 0x01ba}, {0x01bd, 0x01bf}, {0x01dc, 0x01dd}, {0x01ef, 0x01f0}, 
                 {0x0233, 0x0239}, {0x023f, 0x0240}, {0x024f, 0x0293}, {0x0295, 0x02af}, 
                 {0x037b, 0x037d}, {0x03ac, 0x03ce}, {0x03d0, 0x03d1}, {0x03d5, 0x03d7}, 
                 {0x03ef, 0x03f3}, {0x03fb, 0x03fc}, {0x0430, 0x045f}, {0x04ce, 0x04cf}, 
                 {0x0560, 0x0588}, {0x10d0, 0x10fa}, {0x10fd, 0x10ff}, {0x13f8, 0x13fd}, 
                 {0x1c80, 0x1c88}, {0x1d00, 0x1d2b}, {0x1d6b, 0x1d77}, {0x1d79, 0x1d9a}, 
                 {0x1e95, 0x1e9d}, {0x1eff, 0x1f07}, {0x1f10, 0x1f15}, {0x1f20, 0x1f27}, 
                 {0x1f30, 0x1f37}, {0x1f40, 0x1f45}, {0x1f50, 0x1f57}, {0x1f60, 0x1f67}, 
                 {0x1f70, 0x1f7d}, {0x1f80, 0x1f87}, {0x1f90, 0x1f97}, {0x1fa0, 0x1fa7}, 
                 {0x1fb0, 0x1fb4}, {0x1fb6, 0x1fb7}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fc7}, 
                 {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fd7}, {0x1fe0, 0x1fe7}, {0x1ff2, 0x1ff4}, 
                 {0x1ff6, 0x1ff7}, {0x210e, 0x210f}, {0x213c, 0x213d}, {0x2146, 0x2149}, 
                 {0x2c30, 0x2c5e}, {0x2c65, 0x2c66}, {0x2c73, 0x2c74}, {0x2c76, 0x2c7b}, 
                 {0x2ce3, 0x2ce4}, {0x2d00, 0x2d25}, {0xa72f, 0xa731}, {0xa771, 0xa778}, 
                 {0xa793, 0xa795}, {0xab30, 0xab5a}, {0xab60, 0xab65}, {0xab70, 0xabbf}, 
                 {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xff41, 0xff5a}, {0x10428, 0x1044f}, 
                 {0x104d8, 0x104fb}, {0x10cc0, 0x10cf2}, {0x118c0, 0x118df}, {0x16e60, 0x16e7f}, 
                 {0x1d41a, 0x1d433}, {0x1d44e, 0x1d454}, {0x1d456, 0x1d467}, {0x1d482, 0x1d49b}, 
                 {0x1d4b6, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d4cf}, {0x1d4ea, 0x1d503}, 
                 {0x1d51e, 0x1d537}, {0x1d552, 0x1d56b}, {0x1d586, 0x1d59f}, {0x1d5ba, 0x1d5d3}, 
                 {0x1d5ee, 0x1d607}, {0x1d622, 0x1d63b}, {0x1d656, 0x1d66f}, {0x1d68a, 0x1d6a5}, 
                 {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6e1}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d71b}, 
                 {0x1d736, 0x1d74e}, {0x1d750, 0x1d755}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d78f}, 
                 {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7c9}, {0x1e922, 0x1e943}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass24()
{
    // Name = Other_Symbol, number of codePoints: 5984
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x00a6, 0x00a9, 0x00ae, 0x00b0, 0x0482, 0x06de, 0x06e9, 0x07f6, 
                 0x09fa, 0x0b70, 0x0bfa, 0x0c7f, 0x0d4f, 0x0d79, 0x0f13, 0x0f34, 
                 0x0f36, 0x0f38, 0x1940, 0x2114, 0x2125, 0x2127, 0x2129, 0x212e, 
                 0x214a, 0x214f, 0x21d3, 0x3004, 0x3020, 0x3250, 0xa839, 0xfdfd, 
                 0xffe4, 0xffe8, 0x101a0, 0x10ac8, 0x1173f, 0x16b45, 0x1bc9c, 0x1d245, 
                 0x1ecac, 0x1f97a}),
        std::initializer_list<CharacterRange>({{0x058d, 0x058e}, {0x060e, 0x060f}, {0x06fd, 0x06fe}, {0x0bf3, 0x0bf8}, 
                 {0x0f01, 0x0f03}, {0x0f15, 0x0f17}, {0x0f1a, 0x0f1f}, {0x0fbe, 0x0fc5}, 
                 {0x0fc7, 0x0fcc}, {0x0fce, 0x0fcf}, {0x0fd5, 0x0fd8}, {0x109e, 0x109f}, 
                 {0x1390, 0x1399}, {0x19de, 0x19ff}, {0x1b61, 0x1b6a}, {0x1b74, 0x1b7c}, 
                 {0x2100, 0x2101}, {0x2103, 0x2106}, {0x2108, 0x2109}, {0x2116, 0x2117}, 
                 {0x211e, 0x2123}, {0x213a, 0x213b}, {0x214c, 0x214d}, {0x218a, 0x218b}, 
                 {0x2195, 0x2199}, {0x219c, 0x219f}, {0x21a1, 0x21a2}, {0x21a4, 0x21a5}, 
                 {0x21a7, 0x21ad}, {0x21af, 0x21cd}, {0x21d0, 0x21d1}, {0x21d5, 0x21f3}, 
                 {0x2300, 0x2307}, {0x230c, 0x231f}, {0x2322, 0x2328}, {0x232b, 0x237b}, 
                 {0x237d, 0x239a}, {0x23b4, 0x23db}, {0x23e2, 0x2426}, {0x2440, 0x244a}, 
                 {0x249c, 0x24e9}, {0x2500, 0x25b6}, {0x25b8, 0x25c0}, {0x25c2, 0x25f7}, 
                 {0x2600, 0x266e}, {0x2670, 0x2767}, {0x2794, 0x27bf}, {0x2800, 0x28ff}, 
                 {0x2b00, 0x2b2f}, {0x2b45, 0x2b46}, {0x2b4d, 0x2b73}, {0x2b76, 0x2b95}, 
                 {0x2b98, 0x2bc8}, {0x2bca, 0x2bfe}, {0x2ce5, 0x2cea}, {0x2e80, 0x2e99}, 
                 {0x2e9b, 0x2ef3}, {0x2f00, 0x2fd5}, {0x2ff0, 0x2ffb}, {0x3012, 0x3013}, 
                 {0x3036, 0x3037}, {0x303e, 0x303f}, {0x3190, 0x3191}, {0x3196, 0x319f}, 
                 {0x31c0, 0x31e3}, {0x3200, 0x321e}, {0x322a, 0x3247}, {0x3260, 0x327f}, 
                 {0x328a, 0x32b0}, {0x32c0, 0x32fe}, {0x3300, 0x33ff}, {0x4dc0, 0x4dff}, 
                 {0xa490, 0xa4c6}, {0xa828, 0xa82b}, {0xa836, 0xa837}, {0xaa77, 0xaa79}, 
                 {0xffed, 0xffee}, {0xfffc, 0xfffd}, {0x10137, 0x1013f}, {0x10179, 0x10189}, 
                 {0x1018c, 0x1018e}, {0x10190, 0x1019b}, {0x101d0, 0x101fc}, {0x10877, 0x10878}, 
                 {0x16b3c, 0x16b3f}, {0x1d000, 0x1d0f5}, {0x1d100, 0x1d126}, {0x1d129, 0x1d164}, 
                 {0x1d16a, 0x1d16c}, {0x1d183, 0x1d184}, {0x1d18c, 0x1d1a9}, {0x1d1ae, 0x1d1e8}, 
                 {0x1d200, 0x1d241}, {0x1d300, 0x1d356}, {0x1d800, 0x1d9ff}, {0x1da37, 0x1da3a}, 
                 {0x1da6d, 0x1da74}, {0x1da76, 0x1da83}, {0x1da85, 0x1da86}, {0x1f000, 0x1f02b}, 
                 {0x1f030, 0x1f093}, {0x1f0a0, 0x1f0ae}, {0x1f0b1, 0x1f0bf}, {0x1f0c1, 0x1f0cf}, 
                 {0x1f0d1, 0x1f0f5}, {0x1f110, 0x1f16b}, {0x1f170, 0x1f1ac}, {0x1f1e6, 0x1f202}, 
                 {0x1f210, 0x1f23b}, {0x1f240, 0x1f248}, {0x1f250, 0x1f251}, {0x1f260, 0x1f265}, 
                 {0x1f300, 0x1f3fa}, {0x1f400, 0x1f6d4}, {0x1f6e0, 0x1f6ec}, {0x1f6f0, 0x1f6f9}, 
                 {0x1f700, 0x1f773}, {0x1f780, 0x1f7d8}, {0x1f800, 0x1f80b}, {0x1f810, 0x1f847}, 
                 {0x1f850, 0x1f859}, {0x1f860, 0x1f887}, {0x1f890, 0x1f8ad}, {0x1f900, 0x1f90b}, 
                 {0x1f910, 0x1f93e}, {0x1f940, 0x1f970}, {0x1f973, 0x1f976}, {0x1f97c, 0x1f9a2}, 
                 {0x1f9b0, 0x1f9b9}, {0x1f9c0, 0x1f9c2}, {0x1f9d0, 0x1f9ff}, {0x1fa60, 0x1fa6d}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass25()
{
    // Name = Other_Letter, number of codePoints: 121212
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x00aa, 0x00ba, 0x01bb, 0x0294, 0x06d5, 0x06ff, 0x0710, 0x07b1, 
                 0x093d, 0x0950, 0x09b2, 0x09bd, 0x09ce, 0x09fc, 0x0a5e, 0x0abd, 
                 0x0ad0, 0x0af9, 0x0b3d, 0x0b71, 0x0b83, 0x0b9c, 0x0bd0, 0x0c3d, 
                 0x0c80, 0x0cbd, 0x0cde, 0x0d3d, 0x0d4e, 0x0dbd, 0x0e84, 0x0e8a, 
                 0x0e8d, 0x0ea5, 0x0ea7, 0x0ebd, 0x0f00, 0x103f, 0x1061, 0x108e, 
                 0x1258, 0x12c0, 0x17dc, 0x18aa, 0x3006, 0x303c, 0x309f, 0x30ff, 
                 0xa66e, 0xa78f, 0xa7f7, 0xa8fb, 0xaa7a, 0xaab1, 0xaac0, 0xaac2, 
                 0xaaf2, 0xfb1d, 0xfb3e, 0x10808, 0x1083c, 0x10a00, 0x10f27, 0x11144, 
                 0x11176, 0x111da, 0x111dc, 0x11288, 0x1133d, 0x11350, 0x114c7, 0x11644, 
                 0x118ff, 0x11a00, 0x11a3a, 0x11a50, 0x11a9d, 0x11c40, 0x11d46, 0x11d98, 
                 0x16f50, 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 0x1ee47, 0x1ee49, 
                 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 0x1ee5f, 0x1ee64, 
                 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x01c0, 0x01c3}, {0x05d0, 0x05ea}, {0x05ef, 0x05f2}, {0x0620, 0x063f}, 
                 {0x0641, 0x064a}, {0x066e, 0x066f}, {0x0671, 0x06d3}, {0x06ee, 0x06ef}, 
                 {0x06fa, 0x06fc}, {0x0712, 0x072f}, {0x074d, 0x07a5}, {0x07ca, 0x07ea}, 
                 {0x0800, 0x0815}, {0x0840, 0x0858}, {0x0860, 0x086a}, {0x08a0, 0x08b4}, 
                 {0x08b6, 0x08bd}, {0x0904, 0x0939}, {0x0958, 0x0961}, {0x0972, 0x0980}, 
                 {0x0985, 0x098c}, {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, 
                 {0x09b6, 0x09b9}, {0x09dc, 0x09dd}, {0x09df, 0x09e1}, {0x09f0, 0x09f1}, 
                 {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, 
                 {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a59, 0x0a5c}, 
                 {0x0a72, 0x0a74}, {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, 
                 {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0ae0, 0x0ae1}, 
                 {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, 
                 {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b61}, 
                 {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, 
                 {0x0b9e, 0x0b9f}, {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, 
                 {0x0c05, 0x0c0c}, {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, 
                 {0x0c58, 0x0c5a}, {0x0c60, 0x0c61}, {0x0c85, 0x0c8c}, {0x0c8e, 0x0c90}, 
                 {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0ce0, 0x0ce1}, 
                 {0x0cf1, 0x0cf2}, {0x0d05, 0x0d0c}, {0x0d0e, 0x0d10}, {0x0d12, 0x0d3a}, 
                 {0x0d54, 0x0d56}, {0x0d5f, 0x0d61}, {0x0d7a, 0x0d7f}, {0x0d85, 0x0d96}, 
                 {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, {0x0dc0, 0x0dc6}, {0x0e01, 0x0e30}, 
                 {0x0e32, 0x0e33}, {0x0e40, 0x0e45}, {0x0e81, 0x0e82}, {0x0e87, 0x0e88}, 
                 {0x0e94, 0x0e97}, {0x0e99, 0x0e9f}, {0x0ea1, 0x0ea3}, {0x0eaa, 0x0eab}, 
                 {0x0ead, 0x0eb0}, {0x0eb2, 0x0eb3}, {0x0ec0, 0x0ec4}, {0x0edc, 0x0edf}, 
                 {0x0f40, 0x0f47}, {0x0f49, 0x0f6c}, {0x0f88, 0x0f8c}, {0x1000, 0x102a}, 
                 {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1065, 0x1066}, {0x106e, 0x1070}, 
                 {0x1075, 0x1081}, {0x1100, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, 
                 {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, 
                 {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, 
                 {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, 
                 {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, 
                 {0x16f1, 0x16f8}, {0x1700, 0x170c}, {0x170e, 0x1711}, {0x1720, 0x1731}, 
                 {0x1740, 0x1751}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, 
                 {0x1820, 0x1842}, {0x1844, 0x1878}, {0x1880, 0x1884}, {0x1887, 0x18a8}, 
                 {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, 
                 {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54}, 
                 {0x1b05, 0x1b33}, {0x1b45, 0x1b4b}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, 
                 {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f}, {0x1c5a, 0x1c77}, 
                 {0x1ce9, 0x1cec}, {0x1cee, 0x1cf1}, {0x1cf5, 0x1cf6}, {0x2135, 0x2138}, 
                 {0x2d30, 0x2d67}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, 
                 {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, 
                 {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3041, 0x3096}, {0x30a1, 0x30fa}, 
                 {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31ba}, {0x31f0, 0x31ff}, 
                 {0x3400, 0x4db5}, {0x4e00, 0x9fef}, {0xa000, 0xa014}, {0xa016, 0xa48c}, 
                 {0xa4d0, 0xa4f7}, {0xa500, 0xa60b}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, 
                 {0xa6a0, 0xa6e5}, {0xa7fb, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, 
                 {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, 
                 {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, 
                 {0xa984, 0xa9b2}, {0xa9e0, 0xa9e4}, {0xa9e7, 0xa9ef}, {0xa9fa, 0xa9fe}, 
                 {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa6f}, 
                 {0xaa71, 0xaa76}, {0xaa7e, 0xaaaf}, {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, 
                 {0xaadb, 0xaadc}, {0xaae0, 0xaaea}, {0xab01, 0xab06}, {0xab09, 0xab0e}, 
                 {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xabc0, 0xabe2}, 
                 {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, 
                 {0xfa70, 0xfad9}, {0xfb1f, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, 
                 {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3d}, 
                 {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfb}, {0xfe70, 0xfe74}, 
                 {0xfe76, 0xfefc}, {0xff66, 0xff6f}, {0xff71, 0xff9d}, {0xffa0, 0xffbe}, 
                 {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, 
                 {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, 
                 {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10280, 0x1029c}, 
                 {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x10340}, {0x10342, 0x10349}, 
                 {0x10350, 0x10375}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, 
                 {0x10450, 0x1049d}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10600, 0x10736}, 
                 {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10800, 0x10805}, {0x1080a, 0x10835}, 
                 {0x10837, 0x10838}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, 
                 {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, 
                 {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, 
                 {0x10a19, 0x10a35}, {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, 
                 {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, 
                 {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, {0x10d00, 0x10d23}, {0x10f00, 0x10f1c}, 
                 {0x10f30, 0x10f45}, {0x11003, 0x11037}, {0x11083, 0x110af}, {0x110d0, 0x110e8}, 
                 {0x11103, 0x11126}, {0x11150, 0x11172}, {0x11183, 0x111b2}, {0x111c1, 0x111c4}, 
                 {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x11280, 0x11286}, {0x1128a, 0x1128d}, 
                 {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, 
                 {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, 
                 {0x11335, 0x11339}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, 
                 {0x11480, 0x114af}, {0x114c4, 0x114c5}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, 
                 {0x11600, 0x1162f}, {0x11680, 0x116aa}, {0x11700, 0x1171a}, {0x11800, 0x1182b}, 
                 {0x11a0b, 0x11a32}, {0x11a5c, 0x11a83}, {0x11a86, 0x11a89}, {0x11ac0, 0x11af8}, 
                 {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, 
                 {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, 
                 {0x11d6a, 0x11d89}, {0x11ee0, 0x11ef2}, {0x12000, 0x12399}, {0x12480, 0x12543}, 
                 {0x13000, 0x1342e}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, 
                 {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, 
                 {0x16f00, 0x16f44}, {0x17000, 0x187f1}, {0x18800, 0x18af2}, {0x1b000, 0x1b11e}, 
                 {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, 
                 {0x1bc90, 0x1bc99}, {0x1e800, 0x1e8c4}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, 
                 {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, 
                 {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, 
                 {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, 
                 {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6d6}, 
                 {0x2a700, 0x2b734}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, 
                 {0x2f800, 0x2fa1d}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass26()
{
    // Name = Initial_Punctuation, number of codePoints: 12
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x00ab, 0x2018, 0x201f, 0x2039, 0x2e02, 0x2e04, 0x2e09, 0x2e0c, 
                 0x2e1c, 0x2e20}),
        std::initializer_list<CharacterRange>({{0x201b, 0x201c}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass27()
{
    // Name = Format, number of codePoints: 152
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x00ad, 0x061c, 0x06dd, 0x070f, 0x08e2, 0x180e, 0xfeff, 0x110bd, 
                 0x110cd, 0xe0001}),
        std::initializer_list<CharacterRange>({{0x0600, 0x0605}, {0x200b, 0x200f}, {0x202a, 0x202e}, {0x2060, 0x2064}, 
                 {0x2066, 0x206f}, {0xfff9, 0xfffb}, {0x1bca0, 0x1bca3}, {0x1d173, 0x1d17a}, 
                 {0xe0020, 0xe007f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass28()
{
    // Name = Other_Number, number of codePoints: 807
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x00b9, 0x19da, 0x2070, 0x2189, 0x2cfd}),
        std::initializer_list<CharacterRange>({{0x00b2, 0x00b3}, {0x00bc, 0x00be}, {0x09f4, 0x09f9}, {0x0b72, 0x0b77}, 
                 {0x0bf0, 0x0bf2}, {0x0c78, 0x0c7e}, {0x0d58, 0x0d5e}, {0x0d70, 0x0d78}, 
                 {0x0f2a, 0x0f33}, {0x1369, 0x137c}, {0x17f0, 0x17f9}, {0x2074, 0x2079}, 
                 {0x2080, 0x2089}, {0x2150, 0x215f}, {0x2460, 0x249b}, {0x24ea, 0x24ff}, 
                 {0x2776, 0x2793}, {0x3192, 0x3195}, {0x3220, 0x3229}, {0x3248, 0x324f}, 
                 {0x3251, 0x325f}, {0x3280, 0x3289}, {0x32b1, 0x32bf}, {0xa830, 0xa835}, 
                 {0x10107, 0x10133}, {0x10175, 0x10178}, {0x1018a, 0x1018b}, {0x102e1, 0x102fb}, 
                 {0x10320, 0x10323}, {0x10858, 0x1085f}, {0x10879, 0x1087f}, {0x108a7, 0x108af}, 
                 {0x108fb, 0x108ff}, {0x10916, 0x1091b}, {0x109bc, 0x109bd}, {0x109c0, 0x109cf}, 
                 {0x109d2, 0x109ff}, {0x10a40, 0x10a48}, {0x10a7d, 0x10a7e}, {0x10a9d, 0x10a9f}, 
                 {0x10aeb, 0x10aef}, {0x10b58, 0x10b5f}, {0x10b78, 0x10b7f}, {0x10ba9, 0x10baf}, 
                 {0x10cfa, 0x10cff}, {0x10e60, 0x10e7e}, {0x10f1d, 0x10f26}, {0x10f51, 0x10f54}, 
                 {0x11052, 0x11065}, {0x111e1, 0x111f4}, {0x1173a, 0x1173b}, {0x118ea, 0x118f2}, 
                 {0x11c5a, 0x11c6c}, {0x16b5b, 0x16b61}, {0x16e80, 0x16e96}, {0x1d2e0, 0x1d2f3}, 
                 {0x1d360, 0x1d378}, {0x1e8c7, 0x1e8cf}, {0x1ec71, 0x1ecab}, {0x1ecad, 0x1ecaf}, 
                 {0x1ecb1, 0x1ecb4}, {0x1f100, 0x1f10c}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass29()
{
    // Name = Final_Punctuation, number of codePoints: 10
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x00bb, 0x2019, 0x201d, 0x203a, 0x2e03, 0x2e05, 0x2e0a, 0x2e0d, 
                 0x2e1d, 0x2e21}),
        std::initializer_list<CharacterRange>({}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass30()
{
    // Name = Titlecase_Letter, number of codePoints: 31
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x01c5, 0x01c8, 0x01cb, 0x01f2, 0x1fbc, 0x1fcc, 0x1ffc}),
        std::initializer_list<CharacterRange>({{0x1f88, 0x1f8f}, {0x1f98, 0x1f9f}, {0x1fa8, 0x1faf}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass31()
{
    // Name = Modifier_Letter, number of codePoints: 250
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x02ec, 0x02ee, 0x0374, 0x037a, 0x0559, 0x0640, 0x07fa, 0x081a, 
                 0x0824, 0x0828, 0x0971, 0x0e46, 0x0ec6, 0x10fc, 0x17d7, 0x1843, 
                 0x1aa7, 0x1d78, 0x2071, 0x207f, 0x2d6f, 0x2e2f, 0x3005, 0x303b, 
                 0xa015, 0xa60c, 0xa67f, 0xa770, 0xa788, 0xa9cf, 0xa9e6, 0xaa70, 
                 0xaadd, 0xff70}),
        std::initializer_list<CharacterRange>({{0x02b0, 0x02c1}, {0x02c6, 0x02d1}, {0x02e0, 0x02e4}, {0x06e5, 0x06e6}, 
                 {0x07f4, 0x07f5}, {0x1c78, 0x1c7d}, {0x1d2c, 0x1d6a}, {0x1d9b, 0x1dbf}, 
                 {0x2090, 0x209c}, {0x2c7c, 0x2c7d}, {0x3031, 0x3035}, {0x309d, 0x309e}, 
                 {0x30fc, 0x30fe}, {0xa4f8, 0xa4fd}, {0xa69c, 0xa69d}, {0xa717, 0xa71f}, 
                 {0xa7f8, 0xa7f9}, {0xaaf3, 0xaaf4}, {0xab5c, 0xab5f}, {0xff9e, 0xff9f}, 
                 {0x16b40, 0x16b43}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass32()
{
    // Name = Mark, number of codePoints: 2233
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x05bf, 0x05c7, 0x0670, 0x0711, 0x07fd, 0x09bc, 0x09d7, 0x09fe, 
                 0x0a3c, 0x0a51, 0x0a75, 0x0abc, 0x0b3c, 0x0b82, 0x0bd7, 0x0cbc, 
                 0x0d57, 0x0dca, 0x0dd6, 0x0e31, 0x0eb1, 0x0f35, 0x0f37, 0x0f39, 
                 0x0fc6, 0x108f, 0x17dd, 0x18a9, 0x1a7f, 0x1ced, 0x2d7f, 0xa802, 
                 0xa806, 0xa80b, 0xa8ff, 0xa9e5, 0xaa43, 0xaab0, 0xaac1, 0xfb1e, 
                 0x101fd, 0x102e0, 0x10a3f, 0x11173, 0x1123e, 0x11357, 0x1145e, 0x11a47, 
                 0x11d3a, 0x11d47, 0x1da75, 0x1da84}),
        std::initializer_list<CharacterRange>({{0x0300, 0x036f}, {0x0483, 0x0489}, {0x0591, 0x05bd}, {0x05c1, 0x05c2}, 
                 {0x05c4, 0x05c5}, {0x0610, 0x061a}, {0x064b, 0x065f}, {0x06d6, 0x06dc}, 
                 {0x06df, 0x06e4}, {0x06e7, 0x06e8}, {0x06ea, 0x06ed}, {0x0730, 0x074a}, 
                 {0x07a6, 0x07b0}, {0x07eb, 0x07f3}, {0x0816, 0x0819}, {0x081b, 0x0823}, 
                 {0x0825, 0x0827}, {0x0829, 0x082d}, {0x0859, 0x085b}, {0x08d3, 0x08e1}, 
                 {0x08e3, 0x0903}, {0x093a, 0x093c}, {0x093e, 0x094f}, {0x0951, 0x0957}, 
                 {0x0962, 0x0963}, {0x0981, 0x0983}, {0x09be, 0x09c4}, {0x09c7, 0x09c8}, 
                 {0x09cb, 0x09cd}, {0x09e2, 0x09e3}, {0x0a01, 0x0a03}, {0x0a3e, 0x0a42}, 
                 {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a70, 0x0a71}, {0x0a81, 0x0a83}, 
                 {0x0abe, 0x0ac5}, {0x0ac7, 0x0ac9}, {0x0acb, 0x0acd}, {0x0ae2, 0x0ae3}, 
                 {0x0afa, 0x0aff}, {0x0b01, 0x0b03}, {0x0b3e, 0x0b44}, {0x0b47, 0x0b48}, 
                 {0x0b4b, 0x0b4d}, {0x0b56, 0x0b57}, {0x0b62, 0x0b63}, {0x0bbe, 0x0bc2}, 
                 {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd}, {0x0c00, 0x0c04}, {0x0c3e, 0x0c44}, 
                 {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56}, {0x0c62, 0x0c63}, 
                 {0x0c81, 0x0c83}, {0x0cbe, 0x0cc4}, {0x0cc6, 0x0cc8}, {0x0cca, 0x0ccd}, 
                 {0x0cd5, 0x0cd6}, {0x0ce2, 0x0ce3}, {0x0d00, 0x0d03}, {0x0d3b, 0x0d3c}, 
                 {0x0d3e, 0x0d44}, {0x0d46, 0x0d48}, {0x0d4a, 0x0d4d}, {0x0d62, 0x0d63}, 
                 {0x0d82, 0x0d83}, {0x0dcf, 0x0dd4}, {0x0dd8, 0x0ddf}, {0x0df2, 0x0df3}, 
                 {0x0e34, 0x0e3a}, {0x0e47, 0x0e4e}, {0x0eb4, 0x0eb9}, {0x0ebb, 0x0ebc}, 
                 {0x0ec8, 0x0ecd}, {0x0f18, 0x0f19}, {0x0f3e, 0x0f3f}, {0x0f71, 0x0f84}, 
                 {0x0f86, 0x0f87}, {0x0f8d, 0x0f97}, {0x0f99, 0x0fbc}, {0x102b, 0x103e}, 
                 {0x1056, 0x1059}, {0x105e, 0x1060}, {0x1062, 0x1064}, {0x1067, 0x106d}, 
                 {0x1071, 0x1074}, {0x1082, 0x108d}, {0x109a, 0x109d}, {0x135d, 0x135f}, 
                 {0x1712, 0x1714}, {0x1732, 0x1734}, {0x1752, 0x1753}, {0x1772, 0x1773}, 
                 {0x17b4, 0x17d3}, {0x180b, 0x180d}, {0x1885, 0x1886}, {0x1920, 0x192b}, 
                 {0x1930, 0x193b}, {0x1a17, 0x1a1b}, {0x1a55, 0x1a5e}, {0x1a60, 0x1a7c}, 
                 {0x1ab0, 0x1abe}, {0x1b00, 0x1b04}, {0x1b34, 0x1b44}, {0x1b6b, 0x1b73}, 
                 {0x1b80, 0x1b82}, {0x1ba1, 0x1bad}, {0x1be6, 0x1bf3}, {0x1c24, 0x1c37}, 
                 {0x1cd0, 0x1cd2}, {0x1cd4, 0x1ce8}, {0x1cf2, 0x1cf4}, {0x1cf7, 0x1cf9}, 
                 {0x1dc0, 0x1df9}, {0x1dfb, 0x1dff}, {0x20d0, 0x20f0}, {0x2cef, 0x2cf1}, 
                 {0x2de0, 0x2dff}, {0x302a, 0x302f}, {0x3099, 0x309a}, {0xa66f, 0xa672}, 
                 {0xa674, 0xa67d}, {0xa69e, 0xa69f}, {0xa6f0, 0xa6f1}, {0xa823, 0xa827}, 
                 {0xa880, 0xa881}, {0xa8b4, 0xa8c5}, {0xa8e0, 0xa8f1}, {0xa926, 0xa92d}, 
                 {0xa947, 0xa953}, {0xa980, 0xa983}, {0xa9b3, 0xa9c0}, {0xaa29, 0xaa36}, 
                 {0xaa4c, 0xaa4d}, {0xaa7b, 0xaa7d}, {0xaab2, 0xaab4}, {0xaab7, 0xaab8}, 
                 {0xaabe, 0xaabf}, {0xaaeb, 0xaaef}, {0xaaf5, 0xaaf6}, {0xabe3, 0xabea}, 
                 {0xabec, 0xabed}, {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, {0x10376, 0x1037a}, 
                 {0x10a01, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a0f}, {0x10a38, 0x10a3a}, 
                 {0x10ae5, 0x10ae6}, {0x10d24, 0x10d27}, {0x10f46, 0x10f50}, {0x11000, 0x11002}, 
                 {0x11038, 0x11046}, {0x1107f, 0x11082}, {0x110b0, 0x110ba}, {0x11100, 0x11102}, 
                 {0x11127, 0x11134}, {0x11145, 0x11146}, {0x11180, 0x11182}, {0x111b3, 0x111c0}, 
                 {0x111c9, 0x111cc}, {0x1122c, 0x11237}, {0x112df, 0x112ea}, {0x11300, 0x11303}, 
                 {0x1133b, 0x1133c}, {0x1133e, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d}, 
                 {0x11362, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11435, 0x11446}, 
                 {0x114b0, 0x114c3}, {0x115af, 0x115b5}, {0x115b8, 0x115c0}, {0x115dc, 0x115dd}, 
                 {0x11630, 0x11640}, {0x116ab, 0x116b7}, {0x1171d, 0x1172b}, {0x1182c, 0x1183a}, 
                 {0x11a01, 0x11a0a}, {0x11a33, 0x11a39}, {0x11a3b, 0x11a3e}, {0x11a51, 0x11a5b}, 
                 {0x11a8a, 0x11a99}, {0x11c2f, 0x11c36}, {0x11c38, 0x11c3f}, {0x11c92, 0x11ca7}, 
                 {0x11ca9, 0x11cb6}, {0x11d31, 0x11d36}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d45}, 
                 {0x11d8a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d97}, {0x11ef3, 0x11ef6}, 
                 {0x16af0, 0x16af4}, {0x16b30, 0x16b36}, {0x16f51, 0x16f7e}, {0x16f8f, 0x16f92}, 
                 {0x1bc9d, 0x1bc9e}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, 
                 {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1da00, 0x1da36}, 
                 {0x1da3b, 0x1da6c}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1e000, 0x1e006}, 
                 {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, 
                 {0x1e8d0, 0x1e8d6}, {0x1e944, 0x1e94a}, {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass33()
{
    // Name = Nonspacing_Mark, number of codePoints: 1805
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x05bf, 0x05c7, 0x0670, 0x0711, 0x07fd, 0x093a, 0x093c, 0x094d, 
                 0x0981, 0x09bc, 0x09cd, 0x09fe, 0x0a3c, 0x0a51, 0x0a75, 0x0abc, 
                 0x0acd, 0x0b01, 0x0b3c, 0x0b3f, 0x0b4d, 0x0b56, 0x0b82, 0x0bc0, 
                 0x0bcd, 0x0c00, 0x0c04, 0x0c81, 0x0cbc, 0x0cbf, 0x0cc6, 0x0d4d, 
                 0x0dca, 0x0dd6, 0x0e31, 0x0eb1, 0x0f35, 0x0f37, 0x0f39, 0x0fc6, 
                 0x1082, 0x108d, 0x109d, 0x17c6, 0x17dd, 0x18a9, 0x1932, 0x1a1b, 
                 0x1a56, 0x1a60, 0x1a62, 0x1a7f, 0x1b34, 0x1b3c, 0x1b42, 0x1be6, 
                 0x1bed, 0x1ced, 0x1cf4, 0x20e1, 0x2d7f, 0xa66f, 0xa802, 0xa806, 
                 0xa80b, 0xa8ff, 0xa9b3, 0xa9bc, 0xa9e5, 0xaa43, 0xaa4c, 0xaa7c, 
                 0xaab0, 0xaac1, 0xaaf6, 0xabe5, 0xabe8, 0xabed, 0xfb1e, 0x101fd, 
                 0x102e0, 0x10a3f, 0x11001, 0x11173, 0x11234, 0x1123e, 0x112df, 0x11340, 
                 0x11446, 0x1145e, 0x114ba, 0x1163d, 0x116ab, 0x116ad, 0x116b7, 0x11a47, 
                 0x11c3f, 0x11d3a, 0x11d47, 0x11d95, 0x11d97, 0x1da75, 0x1da84}),
        std::initializer_list<CharacterRange>({{0x0300, 0x036f}, {0x0483, 0x0487}, {0x0591, 0x05bd}, {0x05c1, 0x05c2}, 
                 {0x05c4, 0x05c5}, {0x0610, 0x061a}, {0x064b, 0x065f}, {0x06d6, 0x06dc}, 
                 {0x06df, 0x06e4}, {0x06e7, 0x06e8}, {0x06ea, 0x06ed}, {0x0730, 0x074a}, 
                 {0x07a6, 0x07b0}, {0x07eb, 0x07f3}, {0x0816, 0x0819}, {0x081b, 0x0823}, 
                 {0x0825, 0x0827}, {0x0829, 0x082d}, {0x0859, 0x085b}, {0x08d3, 0x08e1}, 
                 {0x08e3, 0x0902}, {0x0941, 0x0948}, {0x0951, 0x0957}, {0x0962, 0x0963}, 
                 {0x09c1, 0x09c4}, {0x09e2, 0x09e3}, {0x0a01, 0x0a02}, {0x0a41, 0x0a42}, 
                 {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a70, 0x0a71}, {0x0a81, 0x0a82}, 
                 {0x0ac1, 0x0ac5}, {0x0ac7, 0x0ac8}, {0x0ae2, 0x0ae3}, {0x0afa, 0x0aff}, 
                 {0x0b41, 0x0b44}, {0x0b62, 0x0b63}, {0x0c3e, 0x0c40}, {0x0c46, 0x0c48}, 
                 {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56}, {0x0c62, 0x0c63}, {0x0ccc, 0x0ccd}, 
                 {0x0ce2, 0x0ce3}, {0x0d00, 0x0d01}, {0x0d3b, 0x0d3c}, {0x0d41, 0x0d44}, 
                 {0x0d62, 0x0d63}, {0x0dd2, 0x0dd4}, {0x0e34, 0x0e3a}, {0x0e47, 0x0e4e}, 
                 {0x0eb4, 0x0eb9}, {0x0ebb, 0x0ebc}, {0x0ec8, 0x0ecd}, {0x0f18, 0x0f19}, 
                 {0x0f71, 0x0f7e}, {0x0f80, 0x0f84}, {0x0f86, 0x0f87}, {0x0f8d, 0x0f97}, 
                 {0x0f99, 0x0fbc}, {0x102d, 0x1030}, {0x1032, 0x1037}, {0x1039, 0x103a}, 
                 {0x103d, 0x103e}, {0x1058, 0x1059}, {0x105e, 0x1060}, {0x1071, 0x1074}, 
                 {0x1085, 0x1086}, {0x135d, 0x135f}, {0x1712, 0x1714}, {0x1732, 0x1734}, 
                 {0x1752, 0x1753}, {0x1772, 0x1773}, {0x17b4, 0x17b5}, {0x17b7, 0x17bd}, 
                 {0x17c9, 0x17d3}, {0x180b, 0x180d}, {0x1885, 0x1886}, {0x1920, 0x1922}, 
                 {0x1927, 0x1928}, {0x1939, 0x193b}, {0x1a17, 0x1a18}, {0x1a58, 0x1a5e}, 
                 {0x1a65, 0x1a6c}, {0x1a73, 0x1a7c}, {0x1ab0, 0x1abd}, {0x1b00, 0x1b03}, 
                 {0x1b36, 0x1b3a}, {0x1b6b, 0x1b73}, {0x1b80, 0x1b81}, {0x1ba2, 0x1ba5}, 
                 {0x1ba8, 0x1ba9}, {0x1bab, 0x1bad}, {0x1be8, 0x1be9}, {0x1bef, 0x1bf1}, 
                 {0x1c2c, 0x1c33}, {0x1c36, 0x1c37}, {0x1cd0, 0x1cd2}, {0x1cd4, 0x1ce0}, 
                 {0x1ce2, 0x1ce8}, {0x1cf8, 0x1cf9}, {0x1dc0, 0x1df9}, {0x1dfb, 0x1dff}, 
                 {0x20d0, 0x20dc}, {0x20e5, 0x20f0}, {0x2cef, 0x2cf1}, {0x2de0, 0x2dff}, 
                 {0x302a, 0x302d}, {0x3099, 0x309a}, {0xa674, 0xa67d}, {0xa69e, 0xa69f}, 
                 {0xa6f0, 0xa6f1}, {0xa825, 0xa826}, {0xa8c4, 0xa8c5}, {0xa8e0, 0xa8f1}, 
                 {0xa926, 0xa92d}, {0xa947, 0xa951}, {0xa980, 0xa982}, {0xa9b6, 0xa9b9}, 
                 {0xaa29, 0xaa2e}, {0xaa31, 0xaa32}, {0xaa35, 0xaa36}, {0xaab2, 0xaab4}, 
                 {0xaab7, 0xaab8}, {0xaabe, 0xaabf}, {0xaaec, 0xaaed}, {0xfe00, 0xfe0f}, 
                 {0xfe20, 0xfe2f}, {0x10376, 0x1037a}, {0x10a01, 0x10a03}, {0x10a05, 0x10a06}, 
                 {0x10a0c, 0x10a0f}, {0x10a38, 0x10a3a}, {0x10ae5, 0x10ae6}, {0x10d24, 0x10d27}, 
                 {0x10f46, 0x10f50}, {0x11038, 0x11046}, {0x1107f, 0x11081}, {0x110b3, 0x110b6}, 
                 {0x110b9, 0x110ba}, {0x11100, 0x11102}, {0x11127, 0x1112b}, {0x1112d, 0x11134}, 
                 {0x11180, 0x11181}, {0x111b6, 0x111be}, {0x111c9, 0x111cc}, {0x1122f, 0x11231}, 
                 {0x11236, 0x11237}, {0x112e3, 0x112ea}, {0x11300, 0x11301}, {0x1133b, 0x1133c}, 
                 {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11438, 0x1143f}, {0x11442, 0x11444}, 
                 {0x114b3, 0x114b8}, {0x114bf, 0x114c0}, {0x114c2, 0x114c3}, {0x115b2, 0x115b5}, 
                 {0x115bc, 0x115bd}, {0x115bf, 0x115c0}, {0x115dc, 0x115dd}, {0x11633, 0x1163a}, 
                 {0x1163f, 0x11640}, {0x116b0, 0x116b5}, {0x1171d, 0x1171f}, {0x11722, 0x11725}, 
                 {0x11727, 0x1172b}, {0x1182f, 0x11837}, {0x11839, 0x1183a}, {0x11a01, 0x11a0a}, 
                 {0x11a33, 0x11a38}, {0x11a3b, 0x11a3e}, {0x11a51, 0x11a56}, {0x11a59, 0x11a5b}, 
                 {0x11a8a, 0x11a96}, {0x11a98, 0x11a99}, {0x11c30, 0x11c36}, {0x11c38, 0x11c3d}, 
                 {0x11c92, 0x11ca7}, {0x11caa, 0x11cb0}, {0x11cb2, 0x11cb3}, {0x11cb5, 0x11cb6}, 
                 {0x11d31, 0x11d36}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d45}, {0x11d90, 0x11d91}, 
                 {0x11ef3, 0x11ef4}, {0x16af0, 0x16af4}, {0x16b30, 0x16b36}, {0x16f8f, 0x16f92}, 
                 {0x1bc9d, 0x1bc9e}, {0x1d167, 0x1d169}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, 
                 {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c}, 
                 {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, 
                 {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e8d0, 0x1e8d6}, 
                 {0x1e944, 0x1e94a}, {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass34()
{
    // Name = Enclosing_Mark, number of codePoints: 13
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1abe}),
        std::initializer_list<CharacterRange>({{0x0488, 0x0489}, {0x20dd, 0x20e0}, {0x20e2, 0x20e4}, {0xa670, 0xa672}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass35()
{
    // Name = Spacing_Mark, number of codePoints: 415
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0903, 0x093b, 0x09d7, 0x0a03, 0x0a83, 0x0ac9, 0x0b3e, 0x0b40, 
                 0x0b57, 0x0bd7, 0x0cbe, 0x0d57, 0x0f7f, 0x1031, 0x1038, 0x108f, 
                 0x17b6, 0x1a55, 0x1a57, 0x1a61, 0x1b04, 0x1b35, 0x1b3b, 0x1b82, 
                 0x1ba1, 0x1baa, 0x1be7, 0x1bee, 0x1ce1, 0x1cf7, 0xa827, 0xa983, 
                 0xaa4d, 0xaa7b, 0xaa7d, 0xaaeb, 0xaaf5, 0xabec, 0x11000, 0x11002, 
                 0x11082, 0x1112c, 0x11182, 0x11235, 0x11357, 0x11445, 0x114b9, 0x114c1, 
                 0x115be, 0x1163e, 0x116ac, 0x116b6, 0x11726, 0x11838, 0x11a39, 0x11a97, 
                 0x11c2f, 0x11c3e, 0x11ca9, 0x11cb1, 0x11cb4, 0x11d96}),
        std::initializer_list<CharacterRange>({{0x093e, 0x0940}, {0x0949, 0x094c}, {0x094e, 0x094f}, {0x0982, 0x0983}, 
                 {0x09be, 0x09c0}, {0x09c7, 0x09c8}, {0x09cb, 0x09cc}, {0x0a3e, 0x0a40}, 
                 {0x0abe, 0x0ac0}, {0x0acb, 0x0acc}, {0x0b02, 0x0b03}, {0x0b47, 0x0b48}, 
                 {0x0b4b, 0x0b4c}, {0x0bbe, 0x0bbf}, {0x0bc1, 0x0bc2}, {0x0bc6, 0x0bc8}, 
                 {0x0bca, 0x0bcc}, {0x0c01, 0x0c03}, {0x0c41, 0x0c44}, {0x0c82, 0x0c83}, 
                 {0x0cc0, 0x0cc4}, {0x0cc7, 0x0cc8}, {0x0cca, 0x0ccb}, {0x0cd5, 0x0cd6}, 
                 {0x0d02, 0x0d03}, {0x0d3e, 0x0d40}, {0x0d46, 0x0d48}, {0x0d4a, 0x0d4c}, 
                 {0x0d82, 0x0d83}, {0x0dcf, 0x0dd1}, {0x0dd8, 0x0ddf}, {0x0df2, 0x0df3}, 
                 {0x0f3e, 0x0f3f}, {0x102b, 0x102c}, {0x103b, 0x103c}, {0x1056, 0x1057}, 
                 {0x1062, 0x1064}, {0x1067, 0x106d}, {0x1083, 0x1084}, {0x1087, 0x108c}, 
                 {0x109a, 0x109c}, {0x17be, 0x17c5}, {0x17c7, 0x17c8}, {0x1923, 0x1926}, 
                 {0x1929, 0x192b}, {0x1930, 0x1931}, {0x1933, 0x1938}, {0x1a19, 0x1a1a}, 
                 {0x1a63, 0x1a64}, {0x1a6d, 0x1a72}, {0x1b3d, 0x1b41}, {0x1b43, 0x1b44}, 
                 {0x1ba6, 0x1ba7}, {0x1bea, 0x1bec}, {0x1bf2, 0x1bf3}, {0x1c24, 0x1c2b}, 
                 {0x1c34, 0x1c35}, {0x1cf2, 0x1cf3}, {0x302e, 0x302f}, {0xa823, 0xa824}, 
                 {0xa880, 0xa881}, {0xa8b4, 0xa8c3}, {0xa952, 0xa953}, {0xa9b4, 0xa9b5}, 
                 {0xa9ba, 0xa9bb}, {0xa9bd, 0xa9c0}, {0xaa2f, 0xaa30}, {0xaa33, 0xaa34}, 
                 {0xaaee, 0xaaef}, {0xabe3, 0xabe4}, {0xabe6, 0xabe7}, {0xabe9, 0xabea}, 
                 {0x110b0, 0x110b2}, {0x110b7, 0x110b8}, {0x11145, 0x11146}, {0x111b3, 0x111b5}, 
                 {0x111bf, 0x111c0}, {0x1122c, 0x1122e}, {0x11232, 0x11233}, {0x112e0, 0x112e2}, 
                 {0x11302, 0x11303}, {0x1133e, 0x1133f}, {0x11341, 0x11344}, {0x11347, 0x11348}, 
                 {0x1134b, 0x1134d}, {0x11362, 0x11363}, {0x11435, 0x11437}, {0x11440, 0x11441}, 
                 {0x114b0, 0x114b2}, {0x114bb, 0x114be}, {0x115af, 0x115b1}, {0x115b8, 0x115bb}, 
                 {0x11630, 0x11632}, {0x1163b, 0x1163c}, {0x116ae, 0x116af}, {0x11720, 0x11721}, 
                 {0x1182c, 0x1182e}, {0x11a57, 0x11a58}, {0x11d8a, 0x11d8e}, {0x11d93, 0x11d94}, 
                 {0x11ef5, 0x11ef6}, {0x16f51, 0x16f7e}, {0x1d165, 0x1d166}, {0x1d16d, 0x1d172}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass36()
{
    // Name = Letter_Number, number of codePoints: 236
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x3007, 0x10341, 0x1034a}),
        std::initializer_list<CharacterRange>({{0x16ee, 0x16f0}, {0x2160, 0x2182}, {0x2185, 0x2188}, {0x3021, 0x3029}, 
                 {0x3038, 0x303a}, {0xa6e6, 0xa6ef}, {0x10140, 0x10174}, {0x103d1, 0x103d5}, 
                 {0x12400, 0x1246e}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass37()
{
    // Name = Line_Separator, number of codePoints: 1
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x2028}),
        std::initializer_list<CharacterRange>({}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass38()
{
    // Name = Paragraph_Separator, number of codePoints: 1
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x2029}),
        std::initializer_list<CharacterRange>({}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass39()
{
    // Name = Surrogate, number of codePoints: 2048
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xd800, 0xdfff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass40()
{
    // Name = Private_Use, number of codePoints: 137468
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xe000, 0xf8ff}, {0xf0000, 0xffffd}, {0x100000, 0x10fffd}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass41()
{
    // Name = Bidi_Mirrored, number of codePoints: 545
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x3c, 0x3e, 0x5b, 0x5d, 0x7b, 0x7d}),
        std::initializer_list<CharacterRange>({{0x28, 0x29}}),
        std::initializer_list<UChar32>({0x00ab, 0x00bb, 0x2140, 0x2211, 0x2224, 0x2226, 0x2239, 0x2262, 
                 0x2298, 0x27c0, 0x29b8, 0x29c9, 0x29e1, 0x2a24, 0x2a26, 0x2a29, 
                 0x2adc, 0x2ade, 0x2af3, 0x2afd, 0x2bfe, 0xff1c, 0xff1e, 0xff3b, 
                 0xff3d, 0xff5b, 0xff5d, 0x1d6db, 0x1d715, 0x1d74f, 0x1d789, 0x1d7c3}),
        std::initializer_list<CharacterRange>({{0x0f3a, 0x0f3d}, {0x169b, 0x169c}, {0x2039, 0x203a}, {0x2045, 0x2046}, 
                 {0x207d, 0x207e}, {0x208d, 0x208e}, {0x2201, 0x2204}, {0x2208, 0x220d}, 
                 {0x2215, 0x2216}, {0x221a, 0x221d}, {0x221f, 0x2222}, {0x222b, 0x2233}, 
                 {0x223b, 0x224c}, {0x2252, 0x2255}, {0x225f, 0x2260}, {0x2264, 0x226b}, 
                 {0x226e, 0x228c}, {0x228f, 0x2292}, {0x22a2, 0x22a3}, {0x22a6, 0x22b8}, 
                 {0x22be, 0x22bf}, {0x22c9, 0x22cd}, {0x22d0, 0x22d1}, {0x22d6, 0x22ed}, 
                 {0x22f0, 0x22ff}, {0x2308, 0x230b}, {0x2320, 0x2321}, {0x2329, 0x232a}, 
                 {0x2768, 0x2775}, {0x27c3, 0x27c6}, {0x27c8, 0x27c9}, {0x27cb, 0x27cd}, 
                 {0x27d3, 0x27d6}, {0x27dc, 0x27de}, {0x27e2, 0x27ef}, {0x2983, 0x2998}, 
                 {0x299b, 0x29a0}, {0x29a2, 0x29af}, {0x29c0, 0x29c5}, {0x29ce, 0x29d2}, 
                 {0x29d4, 0x29d5}, {0x29d8, 0x29dc}, {0x29e3, 0x29e5}, {0x29e8, 0x29e9}, 
                 {0x29f4, 0x29f9}, {0x29fc, 0x29fd}, {0x2a0a, 0x2a1c}, {0x2a1e, 0x2a21}, 
                 {0x2a2b, 0x2a2e}, {0x2a34, 0x2a35}, {0x2a3c, 0x2a3e}, {0x2a57, 0x2a58}, 
                 {0x2a64, 0x2a65}, {0x2a6a, 0x2a6d}, {0x2a6f, 0x2a70}, {0x2a73, 0x2a74}, 
                 {0x2a79, 0x2aa3}, {0x2aa6, 0x2aad}, {0x2aaf, 0x2ad6}, {0x2ae2, 0x2ae6}, 
                 {0x2aec, 0x2aee}, {0x2af7, 0x2afb}, {0x2e02, 0x2e05}, {0x2e09, 0x2e0a}, 
                 {0x2e0c, 0x2e0d}, {0x2e1c, 0x2e1d}, {0x2e20, 0x2e29}, {0x3008, 0x3011}, 
                 {0x3014, 0x301b}, {0xfe59, 0xfe5e}, {0xfe64, 0xfe65}, {0xff08, 0xff09}, 
                 {0xff5f, 0xff60}, {0xff62, 0xff63}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass42()
{
    // Name = Math, number of codePoints: 2310
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x2b, 0x5e, 0x7c, 0x7e}),
        std::initializer_list<CharacterRange>({{0x3c, 0x3e}}),
        std::initializer_list<UChar32>({0x00ac, 0x00b1, 0x00d7, 0x00f7, 0x03d5, 0x2016, 0x2040, 0x2044, 
                 0x2052, 0x20e1, 0x2102, 0x2107, 0x2115, 0x2124, 0x214b, 0x21dd, 
                 0x237c, 0x23b7, 0x23d0, 0x25e2, 0x25e4, 0x2640, 0x2642, 0xfb29, 
                 0xfe68, 0xff0b, 0xff3c, 0xff3e, 0xff5c, 0xff5e, 0xffe2, 0x1d4a2, 
                 0x1d4bb, 0x1d546, 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 0x1ee47, 
                 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 0x1ee5f, 
                 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x03d0, 0x03d2}, {0x03f0, 0x03f1}, {0x03f4, 0x03f6}, {0x0606, 0x0608}, 
                 {0x2032, 0x2034}, {0x2061, 0x2064}, {0x207a, 0x207e}, {0x208a, 0x208e}, 
                 {0x20d0, 0x20dc}, {0x20e5, 0x20e6}, {0x20eb, 0x20ef}, {0x210a, 0x2113}, 
                 {0x2118, 0x211d}, {0x2128, 0x2129}, {0x212c, 0x212d}, {0x212f, 0x2131}, 
                 {0x2133, 0x2138}, {0x213c, 0x2149}, {0x2190, 0x21a7}, {0x21a9, 0x21ae}, 
                 {0x21b0, 0x21b1}, {0x21b6, 0x21b7}, {0x21bc, 0x21db}, {0x21e4, 0x21e5}, 
                 {0x21f4, 0x22ff}, {0x2308, 0x230b}, {0x2320, 0x2321}, {0x239b, 0x23b5}, 
                 {0x23dc, 0x23e2}, {0x25a0, 0x25a1}, {0x25ae, 0x25b7}, {0x25bc, 0x25c1}, 
                 {0x25c6, 0x25c7}, {0x25ca, 0x25cb}, {0x25cf, 0x25d3}, {0x25e7, 0x25ec}, 
                 {0x25f8, 0x25ff}, {0x2605, 0x2606}, {0x2660, 0x2663}, {0x266d, 0x266f}, 
                 {0x27c0, 0x27ff}, {0x2900, 0x2aff}, {0x2b30, 0x2b44}, {0x2b47, 0x2b4c}, 
                 {0xfe61, 0xfe66}, {0xff1c, 0xff1e}, {0xffe9, 0xffec}, {0x1d400, 0x1d454}, 
                 {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, 
                 {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, 
                 {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, 
                 {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d7cb}, 
                 {0x1d7ce, 0x1d7ff}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, 
                 {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, 
                 {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, 
                 {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, 
                 {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1eef0, 0x1eef1}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass43()
{
    // Name = Alphabetic, number of codePoints: 126989
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<UChar32>({0x00aa, 0x00b5, 0x00ba, 0x02ec, 0x02ee, 0x0345, 0x037f, 0x0386, 
                 0x038c, 0x0559, 0x05bf, 0x05c7, 0x06ff, 0x07fa, 0x09b2, 0x09ce, 
                 0x09d7, 0x09fc, 0x0a51, 0x0a5e, 0x0ad0, 0x0b71, 0x0b9c, 0x0bd0, 
                 0x0bd7, 0x0cde, 0x0d4e, 0x0dbd, 0x0dd6, 0x0e4d, 0x0e84, 0x0e8a, 
                 0x0e8d, 0x0ea5, 0x0ea7, 0x0ec6, 0x0ecd, 0x0f00, 0x1038, 0x108e, 
                 0x10c7, 0x10cd, 0x1258, 0x12c0, 0x135f, 0x17d7, 0x17dc, 0x1aa7, 
                 0x1f59, 0x1f5b, 0x1f5d, 0x1fbe, 0x2071, 0x207f, 0x2102, 0x2107, 
                 0x2115, 0x2124, 0x2126, 0x2128, 0x214e, 0x2d27, 0x2d2d, 0x2d6f, 
                 0x2e2f, 0xa8c5, 0xa8fb, 0xa9cf, 0xaa7a, 0xaac0, 0xaac2, 0xfb3e, 
                 0x10808, 0x1083c, 0x10f27, 0x11176, 0x111da, 0x111dc, 0x11237, 0x1123e, 
                 0x11288, 0x11350, 0x11357, 0x114c7, 0x11640, 0x11644, 0x118ff, 0x11a9d, 
                 0x11c40, 0x11d3a, 0x11d43, 0x11d98, 0x1bc9e, 0x1d4a2, 0x1d4bb, 0x1d546, 
                 0x1e947, 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 0x1ee47, 0x1ee49, 
                 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 0x1ee5f, 0x1ee64, 
                 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x02c1}, {0x02c6, 0x02d1}, 
                 {0x02e0, 0x02e4}, {0x0370, 0x0374}, {0x0376, 0x0377}, {0x037a, 0x037d}, 
                 {0x0388, 0x038a}, {0x038e, 0x03a1}, {0x03a3, 0x03f5}, {0x03f7, 0x0481}, 
                 {0x048a, 0x052f}, {0x0531, 0x0556}, {0x0560, 0x0588}, {0x05b0, 0x05bd}, 
                 {0x05c1, 0x05c2}, {0x05c4, 0x05c5}, {0x05d0, 0x05ea}, {0x05ef, 0x05f2}, 
                 {0x0610, 0x061a}, {0x0620, 0x0657}, {0x0659, 0x065f}, {0x066e, 0x06d3}, 
                 {0x06d5, 0x06dc}, {0x06e1, 0x06e8}, {0x06ed, 0x06ef}, {0x06fa, 0x06fc}, 
                 {0x0710, 0x073f}, {0x074d, 0x07b1}, {0x07ca, 0x07ea}, {0x07f4, 0x07f5}, 
                 {0x0800, 0x0817}, {0x081a, 0x082c}, {0x0840, 0x0858}, {0x0860, 0x086a}, 
                 {0x08a0, 0x08b4}, {0x08b6, 0x08bd}, {0x08d4, 0x08df}, {0x08e3, 0x08e9}, 
                 {0x08f0, 0x093b}, {0x093d, 0x094c}, {0x094e, 0x0950}, {0x0955, 0x0963}, 
                 {0x0971, 0x0983}, {0x0985, 0x098c}, {0x098f, 0x0990}, {0x0993, 0x09a8}, 
                 {0x09aa, 0x09b0}, {0x09b6, 0x09b9}, {0x09bd, 0x09c4}, {0x09c7, 0x09c8}, 
                 {0x09cb, 0x09cc}, {0x09dc, 0x09dd}, {0x09df, 0x09e3}, {0x09f0, 0x09f1}, 
                 {0x0a01, 0x0a03}, {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, 
                 {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, 
                 {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, {0x0a4b, 0x0a4c}, {0x0a59, 0x0a5c}, 
                 {0x0a70, 0x0a75}, {0x0a81, 0x0a83}, {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, 
                 {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, 
                 {0x0abd, 0x0ac5}, {0x0ac7, 0x0ac9}, {0x0acb, 0x0acc}, {0x0ae0, 0x0ae3}, 
                 {0x0af9, 0x0afc}, {0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, 
                 {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, 
                 {0x0b3d, 0x0b44}, {0x0b47, 0x0b48}, {0x0b4b, 0x0b4c}, {0x0b56, 0x0b57}, 
                 {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b63}, {0x0b82, 0x0b83}, {0x0b85, 0x0b8a}, 
                 {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9e, 0x0b9f}, 
                 {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, {0x0bbe, 0x0bc2}, 
                 {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcc}, {0x0c00, 0x0c03}, {0x0c05, 0x0c0c}, 
                 {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, {0x0c3d, 0x0c44}, 
                 {0x0c46, 0x0c48}, {0x0c4a, 0x0c4c}, {0x0c55, 0x0c56}, {0x0c58, 0x0c5a}, 
                 {0x0c60, 0x0c63}, {0x0c80, 0x0c83}, {0x0c85, 0x0c8c}, {0x0c8e, 0x0c90}, 
                 {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0cbd, 0x0cc4}, 
                 {0x0cc6, 0x0cc8}, {0x0cca, 0x0ccc}, {0x0cd5, 0x0cd6}, {0x0ce0, 0x0ce3}, 
                 {0x0cf1, 0x0cf2}, {0x0d00, 0x0d03}, {0x0d05, 0x0d0c}, {0x0d0e, 0x0d10}, 
                 {0x0d12, 0x0d3a}, {0x0d3d, 0x0d44}, {0x0d46, 0x0d48}, {0x0d4a, 0x0d4c}, 
                 {0x0d54, 0x0d57}, {0x0d5f, 0x0d63}, {0x0d7a, 0x0d7f}, {0x0d82, 0x0d83}, 
                 {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, {0x0dc0, 0x0dc6}, 
                 {0x0dcf, 0x0dd4}, {0x0dd8, 0x0ddf}, {0x0df2, 0x0df3}, {0x0e01, 0x0e3a}, 
                 {0x0e40, 0x0e46}, {0x0e81, 0x0e82}, {0x0e87, 0x0e88}, {0x0e94, 0x0e97}, 
                 {0x0e99, 0x0e9f}, {0x0ea1, 0x0ea3}, {0x0eaa, 0x0eab}, {0x0ead, 0x0eb9}, 
                 {0x0ebb, 0x0ebd}, {0x0ec0, 0x0ec4}, {0x0edc, 0x0edf}, {0x0f40, 0x0f47}, 
                 {0x0f49, 0x0f6c}, {0x0f71, 0x0f81}, {0x0f88, 0x0f97}, {0x0f99, 0x0fbc}, 
                 {0x1000, 0x1036}, {0x103b, 0x103f}, {0x1050, 0x1062}, {0x1065, 0x1068}, 
                 {0x106e, 0x1086}, {0x109c, 0x109d}, {0x10a0, 0x10c5}, {0x10d0, 0x10fa}, 
                 {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x125a, 0x125d}, 
                 {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, 
                 {0x12b8, 0x12be}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, 
                 {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, 
                 {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, 
                 {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x170c}, {0x170e, 0x1713}, 
                 {0x1720, 0x1733}, {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, 
                 {0x1772, 0x1773}, {0x1780, 0x17b3}, {0x17b6, 0x17c8}, {0x1820, 0x1878}, 
                 {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1920, 0x192b}, 
                 {0x1930, 0x1938}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, 
                 {0x19b0, 0x19c9}, {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e}, {0x1a61, 0x1a74}, 
                 {0x1b00, 0x1b33}, {0x1b35, 0x1b43}, {0x1b45, 0x1b4b}, {0x1b80, 0x1ba9}, 
                 {0x1bac, 0x1baf}, {0x1bba, 0x1be5}, {0x1be7, 0x1bf1}, {0x1c00, 0x1c35}, 
                 {0x1c4d, 0x1c4f}, {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, 
                 {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, 
                 {0x1d00, 0x1dbf}, {0x1de7, 0x1df4}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, 
                 {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, 
                 {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, 
                 {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, 
                 {0x1ff6, 0x1ffc}, {0x2090, 0x209c}, {0x210a, 0x2113}, {0x2119, 0x211d}, 
                 {0x212a, 0x212d}, {0x212f, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149}, 
                 {0x2160, 0x2188}, {0x24b6, 0x24e9}, {0x2c00, 0x2c2e}, {0x2c30, 0x2c5e}, 
                 {0x2c60, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, 
                 {0x2d30, 0x2d67}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, 
                 {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, 
                 {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, 
                 {0x3021, 0x3029}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096}, 
                 {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, 
                 {0x3131, 0x318e}, {0x31a0, 0x31ba}, {0x31f0, 0x31ff}, {0x3400, 0x4db5}, 
                 {0x4e00, 0x9fef}, {0xa000, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, 
                 {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e}, {0xa674, 0xa67b}, 
                 {0xa67f, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7b9}, 
                 {0xa7f7, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa827}, 
                 {0xa840, 0xa873}, {0xa880, 0xa8c3}, {0xa8f2, 0xa8f7}, {0xa8fd, 0xa8fe}, 
                 {0xa90a, 0xa92a}, {0xa930, 0xa952}, {0xa960, 0xa97c}, {0xa980, 0xa9b2}, 
                 {0xa9b4, 0xa9bf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef}, {0xa9fa, 0xa9fe}, 
                 {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa60, 0xaa76}, {0xaa7e, 0xaabe}, 
                 {0xaadb, 0xaadd}, {0xaae0, 0xaaef}, {0xaaf2, 0xaaf5}, {0xab01, 0xab06}, 
                 {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, 
                 {0xab30, 0xab5a}, {0xab5c, 0xab65}, {0xab70, 0xabea}, {0xac00, 0xd7a3}, 
                 {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, 
                 {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, 
                 {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, 
                 {0xfbd3, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfb}, 
                 {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, 
                 {0xff66, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, 
                 {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, 
                 {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, 
                 {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, 
                 {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, 
                 {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, 
                 {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10600, 0x10736}, 
                 {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10800, 0x10805}, {0x1080a, 0x10835}, 
                 {0x10837, 0x10838}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, 
                 {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, 
                 {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, 
                 {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a60, 0x10a7c}, 
                 {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, 
                 {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, 
                 {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10f00, 0x10f1c}, 
                 {0x10f30, 0x10f45}, {0x11000, 0x11045}, {0x11082, 0x110b8}, {0x110d0, 0x110e8}, 
                 {0x11100, 0x11132}, {0x11144, 0x11146}, {0x11150, 0x11172}, {0x11180, 0x111bf}, 
                 {0x111c1, 0x111c4}, {0x11200, 0x11211}, {0x11213, 0x11234}, {0x11280, 0x11286}, 
                 {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112e8}, 
                 {0x11300, 0x11303}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, 
                 {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133d, 0x11344}, 
                 {0x11347, 0x11348}, {0x1134b, 0x1134c}, {0x1135d, 0x11363}, {0x11400, 0x11441}, 
                 {0x11443, 0x11445}, {0x11447, 0x1144a}, {0x11480, 0x114c1}, {0x114c4, 0x114c5}, 
                 {0x11580, 0x115b5}, {0x115b8, 0x115be}, {0x115d8, 0x115dd}, {0x11600, 0x1163e}, 
                 {0x11680, 0x116b5}, {0x11700, 0x1171a}, {0x1171d, 0x1172a}, {0x11800, 0x11838}, 
                 {0x118a0, 0x118df}, {0x11a00, 0x11a32}, {0x11a35, 0x11a3e}, {0x11a50, 0x11a83}, 
                 {0x11a86, 0x11a97}, {0x11ac0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, 
                 {0x11c38, 0x11c3e}, {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}, 
                 {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3c, 0x11d3d}, 
                 {0x11d3f, 0x11d41}, {0x11d46, 0x11d47}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, 
                 {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d96}, {0x11ee0, 0x11ef6}, 
                 {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x13000, 0x1342e}, 
                 {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16ad0, 0x16aed}, 
                 {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, 
                 {0x16e40, 0x16e7f}, {0x16f00, 0x16f44}, {0x16f50, 0x16f7e}, {0x16f93, 0x16f9f}, 
                 {0x16fe0, 0x16fe1}, {0x17000, 0x187f1}, {0x18800, 0x18af2}, {0x1b000, 0x1b11e}, 
                 {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, 
                 {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, 
                 {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, 
                 {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, 
                 {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, 
                 {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, 
                 {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, 
                 {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, 
                 {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, 
                 {0x1e026, 0x1e02a}, {0x1e800, 0x1e8c4}, {0x1e900, 0x1e943}, {0x1ee00, 0x1ee03}, 
                 {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, 
                 {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, 
                 {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, 
                 {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, 
                 {0x1f130, 0x1f149}, {0x1f150, 0x1f169}, {0x1f170, 0x1f189}, {0x20000, 0x2a6d6}, 
                 {0x2a700, 0x2b734}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, 
                 {0x2f800, 0x2fa1d}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass44()
{
    // Name = Lowercase, number of codePoints: 2334
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x61, 0x7a}}),
        std::initializer_list<UChar32>({0x00aa, 0x00b5, 0x00ba, 0x0101, 0x0103, 0x0105, 0x0107, 0x0109, 
                 0x010b, 0x010d, 0x010f, 0x0111, 0x0113, 0x0115, 0x0117, 0x0119, 
                 0x011b, 0x011d, 0x011f, 0x0121, 0x0123, 0x0125, 0x0127, 0x0129, 
                 0x012b, 0x012d, 0x012f, 0x0131, 0x0133, 0x0135, 0x013a, 0x013c, 
                 0x013e, 0x0140, 0x0142, 0x0144, 0x0146, 0x014b, 0x014d, 0x014f, 
                 0x0151, 0x0153, 0x0155, 0x0157, 0x0159, 0x015b, 0x015d, 0x015f, 
                 0x0161, 0x0163, 0x0165, 0x0167, 0x0169, 0x016b, 0x016d, 0x016f, 
                 0x0171, 0x0173, 0x0175, 0x0177, 0x017a, 0x017c, 0x0183, 0x0185, 
                 0x0188, 0x0192, 0x0195, 0x019e, 0x01a1, 0x01a3, 0x01a5, 0x01a8, 
                 0x01ad, 0x01b0, 0x01b4, 0x01b6, 0x01c6, 0x01c9, 0x01cc, 0x01ce, 
                 0x01d0, 0x01d2, 0x01d4, 0x01d6, 0x01d8, 0x01da, 0x01df, 0x01e1, 
                 0x01e3, 0x01e5, 0x01e7, 0x01e9, 0x01eb, 0x01ed, 0x01f3, 0x01f5, 
                 0x01f9, 0x01fb, 0x01fd, 0x01ff, 0x0201, 0x0203, 0x0205, 0x0207, 
                 0x0209, 0x020b, 0x020d, 0x020f, 0x0211, 0x0213, 0x0215, 0x0217, 
                 0x0219, 0x021b, 0x021d, 0x021f, 0x0221, 0x0223, 0x0225, 0x0227, 
                 0x0229, 0x022b, 0x022d, 0x022f, 0x0231, 0x023c, 0x0242, 0x0247, 
                 0x0249, 0x024b, 0x024d, 0x0345, 0x0371, 0x0373, 0x0377, 0x0390, 
                 0x03d9, 0x03db, 0x03dd, 0x03df, 0x03e1, 0x03e3, 0x03e5, 0x03e7, 
                 0x03e9, 0x03eb, 0x03ed, 0x03f5, 0x03f8, 0x0461, 0x0463, 0x0465, 
                 0x0467, 0x0469, 0x046b, 0x046d, 0x046f, 0x0471, 0x0473, 0x0475, 
                 0x0477, 0x0479, 0x047b, 0x047d, 0x047f, 0x0481, 0x048b, 0x048d, 
                 0x048f, 0x0491, 0x0493, 0x0495, 0x0497, 0x0499, 0x049b, 0x049d, 
                 0x049f, 0x04a1, 0x04a3, 0x04a5, 0x04a7, 0x04a9, 0x04ab, 0x04ad, 
                 0x04af, 0x04b1, 0x04b3, 0x04b5, 0x04b7, 0x04b9, 0x04bb, 0x04bd, 
                 0x04bf, 0x04c2, 0x04c4, 0x04c6, 0x04c8, 0x04ca, 0x04cc, 0x04d1, 
                 0x04d3, 0x04d5, 0x04d7, 0x04d9, 0x04db, 0x04dd, 0x04df, 0x04e1, 
                 0x04e3, 0x04e5, 0x04e7, 0x04e9, 0x04eb, 0x04ed, 0x04ef, 0x04f1, 
                 0x04f3, 0x04f5, 0x04f7, 0x04f9, 0x04fb, 0x04fd, 0x04ff, 0x0501, 
                 0x0503, 0x0505, 0x0507, 0x0509, 0x050b, 0x050d, 0x050f, 0x0511, 
                 0x0513, 0x0515, 0x0517, 0x0519, 0x051b, 0x051d, 0x051f, 0x0521, 
                 0x0523, 0x0525, 0x0527, 0x0529, 0x052b, 0x052d, 0x052f, 0x1e01, 
                 0x1e03, 0x1e05, 0x1e07, 0x1e09, 0x1e0b, 0x1e0d, 0x1e0f, 0x1e11, 
                 0x1e13, 0x1e15, 0x1e17, 0x1e19, 0x1e1b, 0x1e1d, 0x1e1f, 0x1e21, 
                 0x1e23, 0x1e25, 0x1e27, 0x1e29, 0x1e2b, 0x1e2d, 0x1e2f, 0x1e31, 
                 0x1e33, 0x1e35, 0x1e37, 0x1e39, 0x1e3b, 0x1e3d, 0x1e3f, 0x1e41, 
                 0x1e43, 0x1e45, 0x1e47, 0x1e49, 0x1e4b, 0x1e4d, 0x1e4f, 0x1e51, 
                 0x1e53, 0x1e55, 0x1e57, 0x1e59, 0x1e5b, 0x1e5d, 0x1e5f, 0x1e61, 
                 0x1e63, 0x1e65, 0x1e67, 0x1e69, 0x1e6b, 0x1e6d, 0x1e6f, 0x1e71, 
                 0x1e73, 0x1e75, 0x1e77, 0x1e79, 0x1e7b, 0x1e7d, 0x1e7f, 0x1e81, 
                 0x1e83, 0x1e85, 0x1e87, 0x1e89, 0x1e8b, 0x1e8d, 0x1e8f, 0x1e91, 
                 0x1e93, 0x1e9f, 0x1ea1, 0x1ea3, 0x1ea5, 0x1ea7, 0x1ea9, 0x1eab, 
                 0x1ead, 0x1eaf, 0x1eb1, 0x1eb3, 0x1eb5, 0x1eb7, 0x1eb9, 0x1ebb, 
                 0x1ebd, 0x1ebf, 0x1ec1, 0x1ec3, 0x1ec5, 0x1ec7, 0x1ec9, 0x1ecb, 
                 0x1ecd, 0x1ecf, 0x1ed1, 0x1ed3, 0x1ed5, 0x1ed7, 0x1ed9, 0x1edb, 
                 0x1edd, 0x1edf, 0x1ee1, 0x1ee3, 0x1ee5, 0x1ee7, 0x1ee9, 0x1eeb, 
                 0x1eed, 0x1eef, 0x1ef1, 0x1ef3, 0x1ef5, 0x1ef7, 0x1ef9, 0x1efb, 
                 0x1efd, 0x1fbe, 0x2071, 0x207f, 0x210a, 0x2113, 0x212f, 0x2134, 
                 0x2139, 0x214e, 0x2184, 0x2c61, 0x2c68, 0x2c6a, 0x2c6c, 0x2c71, 
                 0x2c81, 0x2c83, 0x2c85, 0x2c87, 0x2c89, 0x2c8b, 0x2c8d, 0x2c8f, 
                 0x2c91, 0x2c93, 0x2c95, 0x2c97, 0x2c99, 0x2c9b, 0x2c9d, 0x2c9f, 
                 0x2ca1, 0x2ca3, 0x2ca5, 0x2ca7, 0x2ca9, 0x2cab, 0x2cad, 0x2caf, 
                 0x2cb1, 0x2cb3, 0x2cb5, 0x2cb7, 0x2cb9, 0x2cbb, 0x2cbd, 0x2cbf, 
                 0x2cc1, 0x2cc3, 0x2cc5, 0x2cc7, 0x2cc9, 0x2ccb, 0x2ccd, 0x2ccf, 
                 0x2cd1, 0x2cd3, 0x2cd5, 0x2cd7, 0x2cd9, 0x2cdb, 0x2cdd, 0x2cdf, 
                 0x2ce1, 0x2cec, 0x2cee, 0x2cf3, 0x2d27, 0x2d2d, 0xa641, 0xa643, 
                 0xa645, 0xa647, 0xa649, 0xa64b, 0xa64d, 0xa64f, 0xa651, 0xa653, 
                 0xa655, 0xa657, 0xa659, 0xa65b, 0xa65d, 0xa65f, 0xa661, 0xa663, 
                 0xa665, 0xa667, 0xa669, 0xa66b, 0xa66d, 0xa681, 0xa683, 0xa685, 
                 0xa687, 0xa689, 0xa68b, 0xa68d, 0xa68f, 0xa691, 0xa693, 0xa695, 
                 0xa697, 0xa699, 0xa723, 0xa725, 0xa727, 0xa729, 0xa72b, 0xa72d, 
                 0xa733, 0xa735, 0xa737, 0xa739, 0xa73b, 0xa73d, 0xa73f, 0xa741, 
                 0xa743, 0xa745, 0xa747, 0xa749, 0xa74b, 0xa74d, 0xa74f, 0xa751, 
                 0xa753, 0xa755, 0xa757, 0xa759, 0xa75b, 0xa75d, 0xa75f, 0xa761, 
                 0xa763, 0xa765, 0xa767, 0xa769, 0xa76b, 0xa76d, 0xa77a, 0xa77c, 
                 0xa77f, 0xa781, 0xa783, 0xa785, 0xa787, 0xa78c, 0xa78e, 0xa791, 
                 0xa797, 0xa799, 0xa79b, 0xa79d, 0xa79f, 0xa7a1, 0xa7a3, 0xa7a5, 
                 0xa7a7, 0xa7a9, 0xa7af, 0xa7b5, 0xa7b7, 0xa7b9, 0x1d4bb, 0x1d7cb}),
        std::initializer_list<CharacterRange>({{0x00df, 0x00f6}, {0x00f8, 0x00ff}, {0x0137, 0x0138}, {0x0148, 0x0149}, 
                 {0x017e, 0x0180}, {0x018c, 0x018d}, {0x0199, 0x019b}, {0x01aa, 0x01ab}, 
                 {0x01b9, 0x01ba}, {0x01bd, 0x01bf}, {0x01dc, 0x01dd}, {0x01ef, 0x01f0}, 
                 {0x0233, 0x0239}, {0x023f, 0x0240}, {0x024f, 0x0293}, {0x0295, 0x02b8}, 
                 {0x02c0, 0x02c1}, {0x02e0, 0x02e4}, {0x037a, 0x037d}, {0x03ac, 0x03ce}, 
                 {0x03d0, 0x03d1}, {0x03d5, 0x03d7}, {0x03ef, 0x03f3}, {0x03fb, 0x03fc}, 
                 {0x0430, 0x045f}, {0x04ce, 0x04cf}, {0x0560, 0x0588}, {0x10d0, 0x10fa}, 
                 {0x10fd, 0x10ff}, {0x13f8, 0x13fd}, {0x1c80, 0x1c88}, {0x1d00, 0x1dbf}, 
                 {0x1e95, 0x1e9d}, {0x1eff, 0x1f07}, {0x1f10, 0x1f15}, {0x1f20, 0x1f27}, 
                 {0x1f30, 0x1f37}, {0x1f40, 0x1f45}, {0x1f50, 0x1f57}, {0x1f60, 0x1f67}, 
                 {0x1f70, 0x1f7d}, {0x1f80, 0x1f87}, {0x1f90, 0x1f97}, {0x1fa0, 0x1fa7}, 
                 {0x1fb0, 0x1fb4}, {0x1fb6, 0x1fb7}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fc7}, 
                 {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fd7}, {0x1fe0, 0x1fe7}, {0x1ff2, 0x1ff4}, 
                 {0x1ff6, 0x1ff7}, {0x2090, 0x209c}, {0x210e, 0x210f}, {0x213c, 0x213d}, 
                 {0x2146, 0x2149}, {0x2170, 0x217f}, {0x24d0, 0x24e9}, {0x2c30, 0x2c5e}, 
                 {0x2c65, 0x2c66}, {0x2c73, 0x2c74}, {0x2c76, 0x2c7d}, {0x2ce3, 0x2ce4}, 
                 {0x2d00, 0x2d25}, {0xa69b, 0xa69d}, {0xa72f, 0xa731}, {0xa76f, 0xa778}, 
                 {0xa793, 0xa795}, {0xa7f8, 0xa7fa}, {0xab30, 0xab5a}, {0xab5c, 0xab65}, 
                 {0xab70, 0xabbf}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xff41, 0xff5a}, 
                 {0x10428, 0x1044f}, {0x104d8, 0x104fb}, {0x10cc0, 0x10cf2}, {0x118c0, 0x118df}, 
                 {0x16e60, 0x16e7f}, {0x1d41a, 0x1d433}, {0x1d44e, 0x1d454}, {0x1d456, 0x1d467}, 
                 {0x1d482, 0x1d49b}, {0x1d4b6, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d4cf}, 
                 {0x1d4ea, 0x1d503}, {0x1d51e, 0x1d537}, {0x1d552, 0x1d56b}, {0x1d586, 0x1d59f}, 
                 {0x1d5ba, 0x1d5d3}, {0x1d5ee, 0x1d607}, {0x1d622, 0x1d63b}, {0x1d656, 0x1d66f}, 
                 {0x1d68a, 0x1d6a5}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6e1}, {0x1d6fc, 0x1d714}, 
                 {0x1d716, 0x1d71b}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d755}, {0x1d770, 0x1d788}, 
                 {0x1d78a, 0x1d78f}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7c9}, {0x1e922, 0x1e943}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass45()
{
    // Name = Uppercase, number of codePoints: 1901
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}}),
        std::initializer_list<UChar32>({0x0100, 0x0102, 0x0104, 0x0106, 0x0108, 0x010a, 0x010c, 0x010e, 
                 0x0110, 0x0112, 0x0114, 0x0116, 0x0118, 0x011a, 0x011c, 0x011e, 
                 0x0120, 0x0122, 0x0124, 0x0126, 0x0128, 0x012a, 0x012c, 0x012e, 
                 0x0130, 0x0132, 0x0134, 0x0136, 0x0139, 0x013b, 0x013d, 0x013f, 
                 0x0141, 0x0143, 0x0145, 0x0147, 0x014a, 0x014c, 0x014e, 0x0150, 
                 0x0152, 0x0154, 0x0156, 0x0158, 0x015a, 0x015c, 0x015e, 0x0160, 
                 0x0162, 0x0164, 0x0166, 0x0168, 0x016a, 0x016c, 0x016e, 0x0170, 
                 0x0172, 0x0174, 0x0176, 0x017b, 0x017d, 0x0184, 0x01a2, 0x01a4, 
                 0x01a9, 0x01ac, 0x01b5, 0x01bc, 0x01c4, 0x01c7, 0x01ca, 0x01cd, 
                 0x01cf, 0x01d1, 0x01d3, 0x01d5, 0x01d7, 0x01d9, 0x01db, 0x01de, 
                 0x01e0, 0x01e2, 0x01e4, 0x01e6, 0x01e8, 0x01ea, 0x01ec, 0x01ee, 
                 0x01f1, 0x01f4, 0x01fa, 0x01fc, 0x01fe, 0x0200, 0x0202, 0x0204, 
                 0x0206, 0x0208, 0x020a, 0x020c, 0x020e, 0x0210, 0x0212, 0x0214, 
                 0x0216, 0x0218, 0x021a, 0x021c, 0x021e, 0x0220, 0x0222, 0x0224, 
                 0x0226, 0x0228, 0x022a, 0x022c, 0x022e, 0x0230, 0x0232, 0x0241, 
                 0x0248, 0x024a, 0x024c, 0x024e, 0x0370, 0x0372, 0x0376, 0x037f, 
                 0x0386, 0x038c, 0x03cf, 0x03d8, 0x03da, 0x03dc, 0x03de, 0x03e0, 
                 0x03e2, 0x03e4, 0x03e6, 0x03e8, 0x03ea, 0x03ec, 0x03ee, 0x03f4, 
                 0x03f7, 0x0460, 0x0462, 0x0464, 0x0466, 0x0468, 0x046a, 0x046c, 
                 0x046e, 0x0470, 0x0472, 0x0474, 0x0476, 0x0478, 0x047a, 0x047c, 
                 0x047e, 0x0480, 0x048a, 0x048c, 0x048e, 0x0490, 0x0492, 0x0494, 
                 0x0496, 0x0498, 0x049a, 0x049c, 0x049e, 0x04a0, 0x04a2, 0x04a4, 
                 0x04a6, 0x04a8, 0x04aa, 0x04ac, 0x04ae, 0x04b0, 0x04b2, 0x04b4, 
                 0x04b6, 0x04b8, 0x04ba, 0x04bc, 0x04be, 0x04c3, 0x04c5, 0x04c7, 
                 0x04c9, 0x04cb, 0x04cd, 0x04d0, 0x04d2, 0x04d4, 0x04d6, 0x04d8, 
                 0x04da, 0x04dc, 0x04de, 0x04e0, 0x04e2, 0x04e4, 0x04e6, 0x04e8, 
                 0x04ea, 0x04ec, 0x04ee, 0x04f0, 0x04f2, 0x04f4, 0x04f6, 0x04f8, 
                 0x04fa, 0x04fc, 0x04fe, 0x0500, 0x0502, 0x0504, 0x0506, 0x0508, 
                 0x050a, 0x050c, 0x050e, 0x0510, 0x0512, 0x0514, 0x0516, 0x0518, 
                 0x051a, 0x051c, 0x051e, 0x0520, 0x0522, 0x0524, 0x0526, 0x0528, 
                 0x052a, 0x052c, 0x052e, 0x10c7, 0x10cd, 0x1e00, 0x1e02, 0x1e04, 
                 0x1e06, 0x1e08, 0x1e0a, 0x1e0c, 0x1e0e, 0x1e10, 0x1e12, 0x1e14, 
                 0x1e16, 0x1e18, 0x1e1a, 0x1e1c, 0x1e1e, 0x1e20, 0x1e22, 0x1e24, 
                 0x1e26, 0x1e28, 0x1e2a, 0x1e2c, 0x1e2e, 0x1e30, 0x1e32, 0x1e34, 
                 0x1e36, 0x1e38, 0x1e3a, 0x1e3c, 0x1e3e, 0x1e40, 0x1e42, 0x1e44, 
                 0x1e46, 0x1e48, 0x1e4a, 0x1e4c, 0x1e4e, 0x1e50, 0x1e52, 0x1e54, 
                 0x1e56, 0x1e58, 0x1e5a, 0x1e5c, 0x1e5e, 0x1e60, 0x1e62, 0x1e64, 
                 0x1e66, 0x1e68, 0x1e6a, 0x1e6c, 0x1e6e, 0x1e70, 0x1e72, 0x1e74, 
                 0x1e76, 0x1e78, 0x1e7a, 0x1e7c, 0x1e7e, 0x1e80, 0x1e82, 0x1e84, 
                 0x1e86, 0x1e88, 0x1e8a, 0x1e8c, 0x1e8e, 0x1e90, 0x1e92, 0x1e94, 
                 0x1e9e, 0x1ea0, 0x1ea2, 0x1ea4, 0x1ea6, 0x1ea8, 0x1eaa, 0x1eac, 
                 0x1eae, 0x1eb0, 0x1eb2, 0x1eb4, 0x1eb6, 0x1eb8, 0x1eba, 0x1ebc, 
                 0x1ebe, 0x1ec0, 0x1ec2, 0x1ec4, 0x1ec6, 0x1ec8, 0x1eca, 0x1ecc, 
                 0x1ece, 0x1ed0, 0x1ed2, 0x1ed4, 0x1ed6, 0x1ed8, 0x1eda, 0x1edc, 
                 0x1ede, 0x1ee0, 0x1ee2, 0x1ee4, 0x1ee6, 0x1ee8, 0x1eea, 0x1eec, 
                 0x1eee, 0x1ef0, 0x1ef2, 0x1ef4, 0x1ef6, 0x1ef8, 0x1efa, 0x1efc, 
                 0x1efe, 0x1f59, 0x1f5b, 0x1f5d, 0x1f5f, 0x2102, 0x2107, 0x2115, 
                 0x2124, 0x2126, 0x2128, 0x2145, 0x2183, 0x2c60, 0x2c67, 0x2c69, 
                 0x2c6b, 0x2c72, 0x2c75, 0x2c82, 0x2c84, 0x2c86, 0x2c88, 0x2c8a, 
                 0x2c8c, 0x2c8e, 0x2c90, 0x2c92, 0x2c94, 0x2c96, 0x2c98, 0x2c9a, 
                 0x2c9c, 0x2c9e, 0x2ca0, 0x2ca2, 0x2ca4, 0x2ca6, 0x2ca8, 0x2caa, 
                 0x2cac, 0x2cae, 0x2cb0, 0x2cb2, 0x2cb4, 0x2cb6, 0x2cb8, 0x2cba, 
                 0x2cbc, 0x2cbe, 0x2cc0, 0x2cc2, 0x2cc4, 0x2cc6, 0x2cc8, 0x2cca, 
                 0x2ccc, 0x2cce, 0x2cd0, 0x2cd2, 0x2cd4, 0x2cd6, 0x2cd8, 0x2cda, 
                 0x2cdc, 0x2cde, 0x2ce0, 0x2ce2, 0x2ceb, 0x2ced, 0x2cf2, 0xa640, 
                 0xa642, 0xa644, 0xa646, 0xa648, 0xa64a, 0xa64c, 0xa64e, 0xa650, 
                 0xa652, 0xa654, 0xa656, 0xa658, 0xa65a, 0xa65c, 0xa65e, 0xa660, 
                 0xa662, 0xa664, 0xa666, 0xa668, 0xa66a, 0xa66c, 0xa680, 0xa682, 
                 0xa684, 0xa686, 0xa688, 0xa68a, 0xa68c, 0xa68e, 0xa690, 0xa692, 
                 0xa694, 0xa696, 0xa698, 0xa69a, 0xa722, 0xa724, 0xa726, 0xa728, 
                 0xa72a, 0xa72c, 0xa72e, 0xa732, 0xa734, 0xa736, 0xa738, 0xa73a, 
                 0xa73c, 0xa73e, 0xa740, 0xa742, 0xa744, 0xa746, 0xa748, 0xa74a, 
                 0xa74c, 0xa74e, 0xa750, 0xa752, 0xa754, 0xa756, 0xa758, 0xa75a, 
                 0xa75c, 0xa75e, 0xa760, 0xa762, 0xa764, 0xa766, 0xa768, 0xa76a, 
                 0xa76c, 0xa76e, 0xa779, 0xa77b, 0xa780, 0xa782, 0xa784, 0xa786, 
                 0xa78b, 0xa78d, 0xa790, 0xa792, 0xa796, 0xa798, 0xa79a, 0xa79c, 
                 0xa79e, 0xa7a0, 0xa7a2, 0xa7a4, 0xa7a6, 0xa7a8, 0xa7b6, 0xa7b8, 
                 0x1d49c, 0x1d4a2, 0x1d546, 0x1d7ca}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00de}, {0x0178, 0x0179}, {0x0181, 0x0182}, 
                 {0x0186, 0x0187}, {0x0189, 0x018b}, {0x018e, 0x0191}, {0x0193, 0x0194}, 
                 {0x0196, 0x0198}, {0x019c, 0x019d}, {0x019f, 0x01a0}, {0x01a6, 0x01a7}, 
                 {0x01ae, 0x01af}, {0x01b1, 0x01b3}, {0x01b7, 0x01b8}, {0x01f6, 0x01f8}, 
                 {0x023a, 0x023b}, {0x023d, 0x023e}, {0x0243, 0x0246}, {0x0388, 0x038a}, 
                 {0x038e, 0x038f}, {0x0391, 0x03a1}, {0x03a3, 0x03ab}, {0x03d2, 0x03d4}, 
                 {0x03f9, 0x03fa}, {0x03fd, 0x042f}, {0x04c0, 0x04c1}, {0x0531, 0x0556}, 
                 {0x10a0, 0x10c5}, {0x13a0, 0x13f5}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, 
                 {0x1f08, 0x1f0f}, {0x1f18, 0x1f1d}, {0x1f28, 0x1f2f}, {0x1f38, 0x1f3f}, 
                 {0x1f48, 0x1f4d}, {0x1f68, 0x1f6f}, {0x1fb8, 0x1fbb}, {0x1fc8, 0x1fcb}, 
                 {0x1fd8, 0x1fdb}, {0x1fe8, 0x1fec}, {0x1ff8, 0x1ffb}, {0x210b, 0x210d}, 
                 {0x2110, 0x2112}, {0x2119, 0x211d}, {0x212a, 0x212d}, {0x2130, 0x2133}, 
                 {0x213e, 0x213f}, {0x2160, 0x216f}, {0x24b6, 0x24cf}, {0x2c00, 0x2c2e}, 
                 {0x2c62, 0x2c64}, {0x2c6d, 0x2c70}, {0x2c7e, 0x2c80}, {0xa77d, 0xa77e}, 
                 {0xa7aa, 0xa7ae}, {0xa7b0, 0xa7b4}, {0xff21, 0xff3a}, {0x10400, 0x10427}, 
                 {0x104b0, 0x104d3}, {0x10c80, 0x10cb2}, {0x118a0, 0x118bf}, {0x16e40, 0x16e5f}, 
                 {0x1d400, 0x1d419}, {0x1d434, 0x1d44d}, {0x1d468, 0x1d481}, {0x1d49e, 0x1d49f}, 
                 {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b5}, {0x1d4d0, 0x1d4e9}, 
                 {0x1d504, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, 
                 {0x1d538, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, 
                 {0x1d56c, 0x1d585}, {0x1d5a0, 0x1d5b9}, {0x1d5d4, 0x1d5ed}, {0x1d608, 0x1d621}, 
                 {0x1d63c, 0x1d655}, {0x1d670, 0x1d689}, {0x1d6a8, 0x1d6c0}, {0x1d6e2, 0x1d6fa}, 
                 {0x1d71c, 0x1d734}, {0x1d756, 0x1d76e}, {0x1d790, 0x1d7a8}, {0x1e900, 0x1e921}, 
                 {0x1f130, 0x1f149}, {0x1f150, 0x1f169}, {0x1f170, 0x1f189}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass46()
{
    // Name = Cased, number of codePoints: 4266
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<UChar32>({0x00aa, 0x00b5, 0x00ba, 0x0345, 0x037f, 0x0386, 0x038c, 0x10c7, 
                 0x10cd, 0x1f59, 0x1f5b, 0x1f5d, 0x1fbe, 0x2071, 0x207f, 0x2102, 
                 0x2107, 0x2115, 0x2124, 0x2126, 0x2128, 0x2139, 0x214e, 0x2d27, 
                 0x2d2d, 0x1d4a2, 0x1d4bb, 0x1d546}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x01ba}, {0x01bc, 0x01bf}, 
                 {0x01c4, 0x0293}, {0x0295, 0x02b8}, {0x02c0, 0x02c1}, {0x02e0, 0x02e4}, 
                 {0x0370, 0x0373}, {0x0376, 0x0377}, {0x037a, 0x037d}, {0x0388, 0x038a}, 
                 {0x038e, 0x03a1}, {0x03a3, 0x03f5}, {0x03f7, 0x0481}, {0x048a, 0x052f}, 
                 {0x0531, 0x0556}, {0x0560, 0x0588}, {0x10a0, 0x10c5}, {0x10d0, 0x10fa}, 
                 {0x10fd, 0x10ff}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1c80, 0x1c88}, 
                 {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, 
                 {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, 
                 {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fc2, 0x1fc4}, 
                 {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, 
                 {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2090, 0x209c}, {0x210a, 0x2113}, 
                 {0x2119, 0x211d}, {0x212a, 0x212d}, {0x212f, 0x2134}, {0x213c, 0x213f}, 
                 {0x2145, 0x2149}, {0x2160, 0x217f}, {0x2183, 0x2184}, {0x24b6, 0x24e9}, 
                 {0x2c00, 0x2c2e}, {0x2c30, 0x2c5e}, {0x2c60, 0x2ce4}, {0x2ceb, 0x2cee}, 
                 {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, {0xa640, 0xa66d}, {0xa680, 0xa69d}, 
                 {0xa722, 0xa787}, {0xa78b, 0xa78e}, {0xa790, 0xa7b9}, {0xa7f8, 0xa7fa}, 
                 {0xab30, 0xab5a}, {0xab5c, 0xab65}, {0xab70, 0xabbf}, {0xfb00, 0xfb06}, 
                 {0xfb13, 0xfb17}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0x10400, 0x1044f}, 
                 {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, 
                 {0x118a0, 0x118df}, {0x16e40, 0x16e7f}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, 
                 {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, 
                 {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, 
                 {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, 
                 {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, 
                 {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, 
                 {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, 
                 {0x1d7c4, 0x1d7cb}, {0x1e900, 0x1e943}, {0x1f130, 0x1f149}, {0x1f150, 0x1f169}, 
                 {0x1f170, 0x1f189}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass47()
{
    // Name = Case_Ignorable, number of codePoints: 2357
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x27, 0x2e, 0x3a, 0x5e, 0x60}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x00a8, 0x00ad, 0x00af, 0x00b4, 0x037a, 0x0387, 0x0559, 0x05bf, 
                 0x05c7, 0x05f4, 0x061c, 0x0640, 0x0670, 0x070f, 0x0711, 0x07fa, 
                 0x07fd, 0x093a, 0x093c, 0x094d, 0x0971, 0x0981, 0x09bc, 0x09cd, 
                 0x09fe, 0x0a3c, 0x0a51, 0x0a75, 0x0abc, 0x0acd, 0x0b01, 0x0b3c, 
                 0x0b3f, 0x0b4d, 0x0b56, 0x0b82, 0x0bc0, 0x0bcd, 0x0c00, 0x0c04, 
                 0x0c81, 0x0cbc, 0x0cbf, 0x0cc6, 0x0d4d, 0x0dca, 0x0dd6, 0x0e31, 
                 0x0eb1, 0x0ec6, 0x0f35, 0x0f37, 0x0f39, 0x0fc6, 0x1082, 0x108d, 
                 0x109d, 0x10fc, 0x17c6, 0x17d7, 0x17dd, 0x1843, 0x18a9, 0x1932, 
                 0x1a1b, 0x1a56, 0x1a60, 0x1a62, 0x1a7f, 0x1aa7, 0x1b34, 0x1b3c, 
                 0x1b42, 0x1be6, 0x1bed, 0x1ced, 0x1cf4, 0x1d78, 0x1fbd, 0x2024, 
                 0x2027, 0x2071, 0x207f, 0x2d6f, 0x2d7f, 0x2e2f, 0x3005, 0x303b, 
                 0xa015, 0xa60c, 0xa67f, 0xa770, 0xa802, 0xa806, 0xa80b, 0xa8ff, 
                 0xa9b3, 0xa9bc, 0xa9cf, 0xaa43, 0xaa4c, 0xaa70, 0xaa7c, 0xaab0, 
                 0xaac1, 0xaadd, 0xaaf6, 0xabe5, 0xabe8, 0xabed, 0xfb1e, 0xfe13, 
                 0xfe52, 0xfe55, 0xfeff, 0xff07, 0xff0e, 0xff1a, 0xff3e, 0xff40, 
                 0xff70, 0xffe3, 0x101fd, 0x102e0, 0x10a3f, 0x11001, 0x110bd, 0x110cd, 
                 0x11173, 0x11234, 0x1123e, 0x112df, 0x11340, 0x11446, 0x1145e, 0x114ba, 
                 0x1163d, 0x116ab, 0x116ad, 0x116b7, 0x11a47, 0x11c3f, 0x11d3a, 0x11d47, 
                 0x11d95, 0x11d97, 0x1da75, 0x1da84, 0xe0001}),
        std::initializer_list<CharacterRange>({{0x00b7, 0x00b8}, {0x02b0, 0x036f}, {0x0374, 0x0375}, {0x0384, 0x0385}, 
                 {0x0483, 0x0489}, {0x0591, 0x05bd}, {0x05c1, 0x05c2}, {0x05c4, 0x05c5}, 
                 {0x0600, 0x0605}, {0x0610, 0x061a}, {0x064b, 0x065f}, {0x06d6, 0x06dd}, 
                 {0x06df, 0x06e8}, {0x06ea, 0x06ed}, {0x0730, 0x074a}, {0x07a6, 0x07b0}, 
                 {0x07eb, 0x07f5}, {0x0816, 0x082d}, {0x0859, 0x085b}, {0x08d3, 0x0902}, 
                 {0x0941, 0x0948}, {0x0951, 0x0957}, {0x0962, 0x0963}, {0x09c1, 0x09c4}, 
                 {0x09e2, 0x09e3}, {0x0a01, 0x0a02}, {0x0a41, 0x0a42}, {0x0a47, 0x0a48}, 
                 {0x0a4b, 0x0a4d}, {0x0a70, 0x0a71}, {0x0a81, 0x0a82}, {0x0ac1, 0x0ac5}, 
                 {0x0ac7, 0x0ac8}, {0x0ae2, 0x0ae3}, {0x0afa, 0x0aff}, {0x0b41, 0x0b44}, 
                 {0x0b62, 0x0b63}, {0x0c3e, 0x0c40}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, 
                 {0x0c55, 0x0c56}, {0x0c62, 0x0c63}, {0x0ccc, 0x0ccd}, {0x0ce2, 0x0ce3}, 
                 {0x0d00, 0x0d01}, {0x0d3b, 0x0d3c}, {0x0d41, 0x0d44}, {0x0d62, 0x0d63}, 
                 {0x0dd2, 0x0dd4}, {0x0e34, 0x0e3a}, {0x0e46, 0x0e4e}, {0x0eb4, 0x0eb9}, 
                 {0x0ebb, 0x0ebc}, {0x0ec8, 0x0ecd}, {0x0f18, 0x0f19}, {0x0f71, 0x0f7e}, 
                 {0x0f80, 0x0f84}, {0x0f86, 0x0f87}, {0x0f8d, 0x0f97}, {0x0f99, 0x0fbc}, 
                 {0x102d, 0x1030}, {0x1032, 0x1037}, {0x1039, 0x103a}, {0x103d, 0x103e}, 
                 {0x1058, 0x1059}, {0x105e, 0x1060}, {0x1071, 0x1074}, {0x1085, 0x1086}, 
                 {0x135d, 0x135f}, {0x1712, 0x1714}, {0x1732, 0x1734}, {0x1752, 0x1753}, 
                 {0x1772, 0x1773}, {0x17b4, 0x17b5}, {0x17b7, 0x17bd}, {0x17c9, 0x17d3}, 
                 {0x180b, 0x180e}, {0x1885, 0x1886}, {0x1920, 0x1922}, {0x1927, 0x1928}, 
                 {0x1939, 0x193b}, {0x1a17, 0x1a18}, {0x1a58, 0x1a5e}, {0x1a65, 0x1a6c}, 
                 {0x1a73, 0x1a7c}, {0x1ab0, 0x1abe}, {0x1b00, 0x1b03}, {0x1b36, 0x1b3a}, 
                 {0x1b6b, 0x1b73}, {0x1b80, 0x1b81}, {0x1ba2, 0x1ba5}, {0x1ba8, 0x1ba9}, 
                 {0x1bab, 0x1bad}, {0x1be8, 0x1be9}, {0x1bef, 0x1bf1}, {0x1c2c, 0x1c33}, 
                 {0x1c36, 0x1c37}, {0x1c78, 0x1c7d}, {0x1cd0, 0x1cd2}, {0x1cd4, 0x1ce0}, 
                 {0x1ce2, 0x1ce8}, {0x1cf8, 0x1cf9}, {0x1d2c, 0x1d6a}, {0x1d9b, 0x1df9}, 
                 {0x1dfb, 0x1dff}, {0x1fbf, 0x1fc1}, {0x1fcd, 0x1fcf}, {0x1fdd, 0x1fdf}, 
                 {0x1fed, 0x1fef}, {0x1ffd, 0x1ffe}, {0x200b, 0x200f}, {0x2018, 0x2019}, 
                 {0x202a, 0x202e}, {0x2060, 0x2064}, {0x2066, 0x206f}, {0x2090, 0x209c}, 
                 {0x20d0, 0x20f0}, {0x2c7c, 0x2c7d}, {0x2cef, 0x2cf1}, {0x2de0, 0x2dff}, 
                 {0x302a, 0x302d}, {0x3031, 0x3035}, {0x3099, 0x309e}, {0x30fc, 0x30fe}, 
                 {0xa4f8, 0xa4fd}, {0xa66f, 0xa672}, {0xa674, 0xa67d}, {0xa69c, 0xa69f}, 
                 {0xa6f0, 0xa6f1}, {0xa700, 0xa721}, {0xa788, 0xa78a}, {0xa7f8, 0xa7f9}, 
                 {0xa825, 0xa826}, {0xa8c4, 0xa8c5}, {0xa8e0, 0xa8f1}, {0xa926, 0xa92d}, 
                 {0xa947, 0xa951}, {0xa980, 0xa982}, {0xa9b6, 0xa9b9}, {0xa9e5, 0xa9e6}, 
                 {0xaa29, 0xaa2e}, {0xaa31, 0xaa32}, {0xaa35, 0xaa36}, {0xaab2, 0xaab4}, 
                 {0xaab7, 0xaab8}, {0xaabe, 0xaabf}, {0xaaec, 0xaaed}, {0xaaf3, 0xaaf4}, 
                 {0xab5b, 0xab5f}, {0xfbb2, 0xfbc1}, {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, 
                 {0xff9e, 0xff9f}, {0xfff9, 0xfffb}, {0x10376, 0x1037a}, {0x10a01, 0x10a03}, 
                 {0x10a05, 0x10a06}, {0x10a0c, 0x10a0f}, {0x10a38, 0x10a3a}, {0x10ae5, 0x10ae6}, 
                 {0x10d24, 0x10d27}, {0x10f46, 0x10f50}, {0x11038, 0x11046}, {0x1107f, 0x11081}, 
                 {0x110b3, 0x110b6}, {0x110b9, 0x110ba}, {0x11100, 0x11102}, {0x11127, 0x1112b}, 
                 {0x1112d, 0x11134}, {0x11180, 0x11181}, {0x111b6, 0x111be}, {0x111c9, 0x111cc}, 
                 {0x1122f, 0x11231}, {0x11236, 0x11237}, {0x112e3, 0x112ea}, {0x11300, 0x11301}, 
                 {0x1133b, 0x1133c}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11438, 0x1143f}, 
                 {0x11442, 0x11444}, {0x114b3, 0x114b8}, {0x114bf, 0x114c0}, {0x114c2, 0x114c3}, 
                 {0x115b2, 0x115b5}, {0x115bc, 0x115bd}, {0x115bf, 0x115c0}, {0x115dc, 0x115dd}, 
                 {0x11633, 0x1163a}, {0x1163f, 0x11640}, {0x116b0, 0x116b5}, {0x1171d, 0x1171f}, 
                 {0x11722, 0x11725}, {0x11727, 0x1172b}, {0x1182f, 0x11837}, {0x11839, 0x1183a}, 
                 {0x11a01, 0x11a0a}, {0x11a33, 0x11a38}, {0x11a3b, 0x11a3e}, {0x11a51, 0x11a56}, 
                 {0x11a59, 0x11a5b}, {0x11a8a, 0x11a96}, {0x11a98, 0x11a99}, {0x11c30, 0x11c36}, 
                 {0x11c38, 0x11c3d}, {0x11c92, 0x11ca7}, {0x11caa, 0x11cb0}, {0x11cb2, 0x11cb3}, 
                 {0x11cb5, 0x11cb6}, {0x11d31, 0x11d36}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d45}, 
                 {0x11d90, 0x11d91}, {0x11ef3, 0x11ef4}, {0x16af0, 0x16af4}, {0x16b30, 0x16b36}, 
                 {0x16b40, 0x16b43}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x1bc9d, 0x1bc9e}, 
                 {0x1bca0, 0x1bca3}, {0x1d167, 0x1d169}, {0x1d173, 0x1d182}, {0x1d185, 0x1d18b}, 
                 {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c}, 
                 {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, 
                 {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e8d0, 0x1e8d6}, 
                 {0x1e944, 0x1e94a}, {0x1f3fb, 0x1f3ff}, {0xe0020, 0xe007f}, {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass48()
{
    // Name = Changes_When_Lowercased, number of codePoints: 1383
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}}),
        std::initializer_list<UChar32>({0x0100, 0x0102, 0x0104, 0x0106, 0x0108, 0x010a, 0x010c, 0x010e, 
                 0x0110, 0x0112, 0x0114, 0x0116, 0x0118, 0x011a, 0x011c, 0x011e, 
                 0x0120, 0x0122, 0x0124, 0x0126, 0x0128, 0x012a, 0x012c, 0x012e, 
                 0x0130, 0x0132, 0x0134, 0x0136, 0x0139, 0x013b, 0x013d, 0x013f, 
                 0x0141, 0x0143, 0x0145, 0x0147, 0x014a, 0x014c, 0x014e, 0x0150, 
                 0x0152, 0x0154, 0x0156, 0x0158, 0x015a, 0x015c, 0x015e, 0x0160, 
                 0x0162, 0x0164, 0x0166, 0x0168, 0x016a, 0x016c, 0x016e, 0x0170, 
                 0x0172, 0x0174, 0x0176, 0x017b, 0x017d, 0x0184, 0x01a2, 0x01a4, 
                 0x01a9, 0x01ac, 0x01b5, 0x01bc, 0x01cd, 0x01cf, 0x01d1, 0x01d3, 
                 0x01d5, 0x01d7, 0x01d9, 0x01db, 0x01de, 0x01e0, 0x01e2, 0x01e4, 
                 0x01e6, 0x01e8, 0x01ea, 0x01ec, 0x01ee, 0x01f4, 0x01fa, 0x01fc, 
                 0x01fe, 0x0200, 0x0202, 0x0204, 0x0206, 0x0208, 0x020a, 0x020c, 
                 0x020e, 0x0210, 0x0212, 0x0214, 0x0216, 0x0218, 0x021a, 0x021c, 
                 0x021e, 0x0220, 0x0222, 0x0224, 0x0226, 0x0228, 0x022a, 0x022c, 
                 0x022e, 0x0230, 0x0232, 0x0241, 0x0248, 0x024a, 0x024c, 0x024e, 
                 0x0370, 0x0372, 0x0376, 0x037f, 0x0386, 0x038c, 0x03cf, 0x03d8, 
                 0x03da, 0x03dc, 0x03de, 0x03e0, 0x03e2, 0x03e4, 0x03e6, 0x03e8, 
                 0x03ea, 0x03ec, 0x03ee, 0x03f4, 0x03f7, 0x0460, 0x0462, 0x0464, 
                 0x0466, 0x0468, 0x046a, 0x046c, 0x046e, 0x0470, 0x0472, 0x0474, 
                 0x0476, 0x0478, 0x047a, 0x047c, 0x047e, 0x0480, 0x048a, 0x048c, 
                 0x048e, 0x0490, 0x0492, 0x0494, 0x0496, 0x0498, 0x049a, 0x049c, 
                 0x049e, 0x04a0, 0x04a2, 0x04a4, 0x04a6, 0x04a8, 0x04aa, 0x04ac, 
                 0x04ae, 0x04b0, 0x04b2, 0x04b4, 0x04b6, 0x04b8, 0x04ba, 0x04bc, 
                 0x04be, 0x04c3, 0x04c5, 0x04c7, 0x04c9, 0x04cb, 0x04cd, 0x04d0, 
                 0x04d2, 0x04d4, 0x04d6, 0x04d8, 0x04da, 0x04dc, 0x04de, 0x04e0, 
                 0x04e2, 0x04e4, 0x04e6, 0x04e8, 0x04ea, 0x04ec, 0x04ee, 0x04f0, 
                 0x04f2, 0x04f4, 0x04f6, 0x04f8, 0x04fa, 0x04fc, 0x04fe, 0x0500, 
                 0x0502, 0x0504, 0x0506, 0x0508, 0x050a, 0x050c, 0x050e, 0x0510, 
                 0x0512, 0x0514, 0x0516, 0x0518, 0x051a, 0x051c, 0x051e, 0x0520, 
                 0x0522, 0x0524, 0x0526, 0x0528, 0x052a, 0x052c, 0x052e, 0x10c7, 
                 0x10cd, 0x1e00, 0x1e02, 0x1e04, 0x1e06, 0x1e08, 0x1e0a, 0x1e0c, 
                 0x1e0e, 0x1e10, 0x1e12, 0x1e14, 0x1e16, 0x1e18, 0x1e1a, 0x1e1c, 
                 0x1e1e, 0x1e20, 0x1e22, 0x1e24, 0x1e26, 0x1e28, 0x1e2a, 0x1e2c, 
                 0x1e2e, 0x1e30, 0x1e32, 0x1e34, 0x1e36, 0x1e38, 0x1e3a, 0x1e3c, 
                 0x1e3e, 0x1e40, 0x1e42, 0x1e44, 0x1e46, 0x1e48, 0x1e4a, 0x1e4c, 
                 0x1e4e, 0x1e50, 0x1e52, 0x1e54, 0x1e56, 0x1e58, 0x1e5a, 0x1e5c, 
                 0x1e5e, 0x1e60, 0x1e62, 0x1e64, 0x1e66, 0x1e68, 0x1e6a, 0x1e6c, 
                 0x1e6e, 0x1e70, 0x1e72, 0x1e74, 0x1e76, 0x1e78, 0x1e7a, 0x1e7c, 
                 0x1e7e, 0x1e80, 0x1e82, 0x1e84, 0x1e86, 0x1e88, 0x1e8a, 0x1e8c, 
                 0x1e8e, 0x1e90, 0x1e92, 0x1e94, 0x1e9e, 0x1ea0, 0x1ea2, 0x1ea4, 
                 0x1ea6, 0x1ea8, 0x1eaa, 0x1eac, 0x1eae, 0x1eb0, 0x1eb2, 0x1eb4, 
                 0x1eb6, 0x1eb8, 0x1eba, 0x1ebc, 0x1ebe, 0x1ec0, 0x1ec2, 0x1ec4, 
                 0x1ec6, 0x1ec8, 0x1eca, 0x1ecc, 0x1ece, 0x1ed0, 0x1ed2, 0x1ed4, 
                 0x1ed6, 0x1ed8, 0x1eda, 0x1edc, 0x1ede, 0x1ee0, 0x1ee2, 0x1ee4, 
                 0x1ee6, 0x1ee8, 0x1eea, 0x1eec, 0x1eee, 0x1ef0, 0x1ef2, 0x1ef4, 
                 0x1ef6, 0x1ef8, 0x1efa, 0x1efc, 0x1efe, 0x1f59, 0x1f5b, 0x1f5d, 
                 0x1f5f, 0x2126, 0x2132, 0x2183, 0x2c60, 0x2c67, 0x2c69, 0x2c6b, 
                 0x2c72, 0x2c75, 0x2c82, 0x2c84, 0x2c86, 0x2c88, 0x2c8a, 0x2c8c, 
                 0x2c8e, 0x2c90, 0x2c92, 0x2c94, 0x2c96, 0x2c98, 0x2c9a, 0x2c9c, 
                 0x2c9e, 0x2ca0, 0x2ca2, 0x2ca4, 0x2ca6, 0x2ca8, 0x2caa, 0x2cac, 
                 0x2cae, 0x2cb0, 0x2cb2, 0x2cb4, 0x2cb6, 0x2cb8, 0x2cba, 0x2cbc, 
                 0x2cbe, 0x2cc0, 0x2cc2, 0x2cc4, 0x2cc6, 0x2cc8, 0x2cca, 0x2ccc, 
                 0x2cce, 0x2cd0, 0x2cd2, 0x2cd4, 0x2cd6, 0x2cd8, 0x2cda, 0x2cdc, 
                 0x2cde, 0x2ce0, 0x2ce2, 0x2ceb, 0x2ced, 0x2cf2, 0xa640, 0xa642, 
                 0xa644, 0xa646, 0xa648, 0xa64a, 0xa64c, 0xa64e, 0xa650, 0xa652, 
                 0xa654, 0xa656, 0xa658, 0xa65a, 0xa65c, 0xa65e, 0xa660, 0xa662, 
                 0xa664, 0xa666, 0xa668, 0xa66a, 0xa66c, 0xa680, 0xa682, 0xa684, 
                 0xa686, 0xa688, 0xa68a, 0xa68c, 0xa68e, 0xa690, 0xa692, 0xa694, 
                 0xa696, 0xa698, 0xa69a, 0xa722, 0xa724, 0xa726, 0xa728, 0xa72a, 
                 0xa72c, 0xa72e, 0xa732, 0xa734, 0xa736, 0xa738, 0xa73a, 0xa73c, 
                 0xa73e, 0xa740, 0xa742, 0xa744, 0xa746, 0xa748, 0xa74a, 0xa74c, 
                 0xa74e, 0xa750, 0xa752, 0xa754, 0xa756, 0xa758, 0xa75a, 0xa75c, 
                 0xa75e, 0xa760, 0xa762, 0xa764, 0xa766, 0xa768, 0xa76a, 0xa76c, 
                 0xa76e, 0xa779, 0xa77b, 0xa780, 0xa782, 0xa784, 0xa786, 0xa78b, 
                 0xa78d, 0xa790, 0xa792, 0xa796, 0xa798, 0xa79a, 0xa79c, 0xa79e, 
                 0xa7a0, 0xa7a2, 0xa7a4, 0xa7a6, 0xa7a8, 0xa7b6, 0xa7b8}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00de}, {0x0178, 0x0179}, {0x0181, 0x0182}, 
                 {0x0186, 0x0187}, {0x0189, 0x018b}, {0x018e, 0x0191}, {0x0193, 0x0194}, 
                 {0x0196, 0x0198}, {0x019c, 0x019d}, {0x019f, 0x01a0}, {0x01a6, 0x01a7}, 
                 {0x01ae, 0x01af}, {0x01b1, 0x01b3}, {0x01b7, 0x01b8}, {0x01c4, 0x01c5}, 
                 {0x01c7, 0x01c8}, {0x01ca, 0x01cb}, {0x01f1, 0x01f2}, {0x01f6, 0x01f8}, 
                 {0x023a, 0x023b}, {0x023d, 0x023e}, {0x0243, 0x0246}, {0x0388, 0x038a}, 
                 {0x038e, 0x038f}, {0x0391, 0x03a1}, {0x03a3, 0x03ab}, {0x03f9, 0x03fa}, 
                 {0x03fd, 0x042f}, {0x04c0, 0x04c1}, {0x0531, 0x0556}, {0x10a0, 0x10c5}, 
                 {0x13a0, 0x13f5}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1f08, 0x1f0f}, 
                 {0x1f18, 0x1f1d}, {0x1f28, 0x1f2f}, {0x1f38, 0x1f3f}, {0x1f48, 0x1f4d}, 
                 {0x1f68, 0x1f6f}, {0x1f88, 0x1f8f}, {0x1f98, 0x1f9f}, {0x1fa8, 0x1faf}, 
                 {0x1fb8, 0x1fbc}, {0x1fc8, 0x1fcc}, {0x1fd8, 0x1fdb}, {0x1fe8, 0x1fec}, 
                 {0x1ff8, 0x1ffc}, {0x212a, 0x212b}, {0x2160, 0x216f}, {0x24b6, 0x24cf}, 
                 {0x2c00, 0x2c2e}, {0x2c62, 0x2c64}, {0x2c6d, 0x2c70}, {0x2c7e, 0x2c80}, 
                 {0xa77d, 0xa77e}, {0xa7aa, 0xa7ae}, {0xa7b0, 0xa7b4}, {0xff21, 0xff3a}, 
                 {0x10400, 0x10427}, {0x104b0, 0x104d3}, {0x10c80, 0x10cb2}, {0x118a0, 0x118bf}, 
                 {0x16e40, 0x16e5f}, {0x1e900, 0x1e921}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass49()
{
    // Name = Changes_When_Uppercased, number of codePoints: 1475
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x61, 0x7a}}),
        std::initializer_list<UChar32>({0x00b5, 0x0101, 0x0103, 0x0105, 0x0107, 0x0109, 0x010b, 0x010d, 
                 0x010f, 0x0111, 0x0113, 0x0115, 0x0117, 0x0119, 0x011b, 0x011d, 
                 0x011f, 0x0121, 0x0123, 0x0125, 0x0127, 0x0129, 0x012b, 0x012d, 
                 0x012f, 0x0131, 0x0133, 0x0135, 0x0137, 0x013a, 0x013c, 0x013e, 
                 0x0140, 0x0142, 0x0144, 0x0146, 0x014b, 0x014d, 0x014f, 0x0151, 
                 0x0153, 0x0155, 0x0157, 0x0159, 0x015b, 0x015d, 0x015f, 0x0161, 
                 0x0163, 0x0165, 0x0167, 0x0169, 0x016b, 0x016d, 0x016f, 0x0171, 
                 0x0173, 0x0175, 0x0177, 0x017a, 0x017c, 0x0183, 0x0185, 0x0188, 
                 0x018c, 0x0192, 0x0195, 0x019e, 0x01a1, 0x01a3, 0x01a5, 0x01a8, 
                 0x01ad, 0x01b0, 0x01b4, 0x01b6, 0x01b9, 0x01bd, 0x01bf, 0x01ce, 
                 0x01d0, 0x01d2, 0x01d4, 0x01d6, 0x01d8, 0x01da, 0x01df, 0x01e1, 
                 0x01e3, 0x01e5, 0x01e7, 0x01e9, 0x01eb, 0x01ed, 0x01f5, 0x01f9, 
                 0x01fb, 0x01fd, 0x01ff, 0x0201, 0x0203, 0x0205, 0x0207, 0x0209, 
                 0x020b, 0x020d, 0x020f, 0x0211, 0x0213, 0x0215, 0x0217, 0x0219, 
                 0x021b, 0x021d, 0x021f, 0x0223, 0x0225, 0x0227, 0x0229, 0x022b, 
                 0x022d, 0x022f, 0x0231, 0x0233, 0x023c, 0x0242, 0x0247, 0x0249, 
                 0x024b, 0x024d, 0x0259, 0x0263, 0x026f, 0x0275, 0x027d, 0x0280, 
                 0x0283, 0x0292, 0x0345, 0x0371, 0x0373, 0x0377, 0x0390, 0x03d9, 
                 0x03db, 0x03dd, 0x03df, 0x03e1, 0x03e3, 0x03e5, 0x03e7, 0x03e9, 
                 0x03eb, 0x03ed, 0x03f5, 0x03f8, 0x03fb, 0x0461, 0x0463, 0x0465, 
                 0x0467, 0x0469, 0x046b, 0x046d, 0x046f, 0x0471, 0x0473, 0x0475, 
                 0x0477, 0x0479, 0x047b, 0x047d, 0x047f, 0x0481, 0x048b, 0x048d, 
                 0x048f, 0x0491, 0x0493, 0x0495, 0x0497, 0x0499, 0x049b, 0x049d, 
                 0x049f, 0x04a1, 0x04a3, 0x04a5, 0x04a7, 0x04a9, 0x04ab, 0x04ad, 
                 0x04af, 0x04b1, 0x04b3, 0x04b5, 0x04b7, 0x04b9, 0x04bb, 0x04bd, 
                 0x04bf, 0x04c2, 0x04c4, 0x04c6, 0x04c8, 0x04ca, 0x04cc, 0x04d1, 
                 0x04d3, 0x04d5, 0x04d7, 0x04d9, 0x04db, 0x04dd, 0x04df, 0x04e1, 
                 0x04e3, 0x04e5, 0x04e7, 0x04e9, 0x04eb, 0x04ed, 0x04ef, 0x04f1, 
                 0x04f3, 0x04f5, 0x04f7, 0x04f9, 0x04fb, 0x04fd, 0x04ff, 0x0501, 
                 0x0503, 0x0505, 0x0507, 0x0509, 0x050b, 0x050d, 0x050f, 0x0511, 
                 0x0513, 0x0515, 0x0517, 0x0519, 0x051b, 0x051d, 0x051f, 0x0521, 
                 0x0523, 0x0525, 0x0527, 0x0529, 0x052b, 0x052d, 0x052f, 0x1d79, 
                 0x1d7d, 0x1e01, 0x1e03, 0x1e05, 0x1e07, 0x1e09, 0x1e0b, 0x1e0d, 
                 0x1e0f, 0x1e11, 0x1e13, 0x1e15, 0x1e17, 0x1e19, 0x1e1b, 0x1e1d, 
                 0x1e1f, 0x1e21, 0x1e23, 0x1e25, 0x1e27, 0x1e29, 0x1e2b, 0x1e2d, 
                 0x1e2f, 0x1e31, 0x1e33, 0x1e35, 0x1e37, 0x1e39, 0x1e3b, 0x1e3d, 
                 0x1e3f, 0x1e41, 0x1e43, 0x1e45, 0x1e47, 0x1e49, 0x1e4b, 0x1e4d, 
                 0x1e4f, 0x1e51, 0x1e53, 0x1e55, 0x1e57, 0x1e59, 0x1e5b, 0x1e5d, 
                 0x1e5f, 0x1e61, 0x1e63, 0x1e65, 0x1e67, 0x1e69, 0x1e6b, 0x1e6d, 
                 0x1e6f, 0x1e71, 0x1e73, 0x1e75, 0x1e77, 0x1e79, 0x1e7b, 0x1e7d, 
                 0x1e7f, 0x1e81, 0x1e83, 0x1e85, 0x1e87, 0x1e89, 0x1e8b, 0x1e8d, 
                 0x1e8f, 0x1e91, 0x1e93, 0x1ea1, 0x1ea3, 0x1ea5, 0x1ea7, 0x1ea9, 
                 0x1eab, 0x1ead, 0x1eaf, 0x1eb1, 0x1eb3, 0x1eb5, 0x1eb7, 0x1eb9, 
                 0x1ebb, 0x1ebd, 0x1ebf, 0x1ec1, 0x1ec3, 0x1ec5, 0x1ec7, 0x1ec9, 
                 0x1ecb, 0x1ecd, 0x1ecf, 0x1ed1, 0x1ed3, 0x1ed5, 0x1ed7, 0x1ed9, 
                 0x1edb, 0x1edd, 0x1edf, 0x1ee1, 0x1ee3, 0x1ee5, 0x1ee7, 0x1ee9, 
                 0x1eeb, 0x1eed, 0x1eef, 0x1ef1, 0x1ef3, 0x1ef5, 0x1ef7, 0x1ef9, 
                 0x1efb, 0x1efd, 0x1fbc, 0x1fbe, 0x1fcc, 0x1ffc, 0x214e, 0x2184, 
                 0x2c61, 0x2c68, 0x2c6a, 0x2c6c, 0x2c73, 0x2c76, 0x2c81, 0x2c83, 
                 0x2c85, 0x2c87, 0x2c89, 0x2c8b, 0x2c8d, 0x2c8f, 0x2c91, 0x2c93, 
                 0x2c95, 0x2c97, 0x2c99, 0x2c9b, 0x2c9d, 0x2c9f, 0x2ca1, 0x2ca3, 
                 0x2ca5, 0x2ca7, 0x2ca9, 0x2cab, 0x2cad, 0x2caf, 0x2cb1, 0x2cb3, 
                 0x2cb5, 0x2cb7, 0x2cb9, 0x2cbb, 0x2cbd, 0x2cbf, 0x2cc1, 0x2cc3, 
                 0x2cc5, 0x2cc7, 0x2cc9, 0x2ccb, 0x2ccd, 0x2ccf, 0x2cd1, 0x2cd3, 
                 0x2cd5, 0x2cd7, 0x2cd9, 0x2cdb, 0x2cdd, 0x2cdf, 0x2ce1, 0x2ce3, 
                 0x2cec, 0x2cee, 0x2cf3, 0x2d27, 0x2d2d, 0xa641, 0xa643, 0xa645, 
                 0xa647, 0xa649, 0xa64b, 0xa64d, 0xa64f, 0xa651, 0xa653, 0xa655, 
                 0xa657, 0xa659, 0xa65b, 0xa65d, 0xa65f, 0xa661, 0xa663, 0xa665, 
                 0xa667, 0xa669, 0xa66b, 0xa66d, 0xa681, 0xa683, 0xa685, 0xa687, 
                 0xa689, 0xa68b, 0xa68d, 0xa68f, 0xa691, 0xa693, 0xa695, 0xa697, 
                 0xa699, 0xa69b, 0xa723, 0xa725, 0xa727, 0xa729, 0xa72b, 0xa72d, 
                 0xa72f, 0xa733, 0xa735, 0xa737, 0xa739, 0xa73b, 0xa73d, 0xa73f, 
                 0xa741, 0xa743, 0xa745, 0xa747, 0xa749, 0xa74b, 0xa74d, 0xa74f, 
                 0xa751, 0xa753, 0xa755, 0xa757, 0xa759, 0xa75b, 0xa75d, 0xa75f, 
                 0xa761, 0xa763, 0xa765, 0xa767, 0xa769, 0xa76b, 0xa76d, 0xa76f, 
                 0xa77a, 0xa77c, 0xa77f, 0xa781, 0xa783, 0xa785, 0xa787, 0xa78c, 
                 0xa791, 0xa793, 0xa797, 0xa799, 0xa79b, 0xa79d, 0xa79f, 0xa7a1, 
                 0xa7a3, 0xa7a5, 0xa7a7, 0xa7a9, 0xa7b5, 0xa7b7, 0xa7b9, 0xab53}),
        std::initializer_list<CharacterRange>({{0x00df, 0x00f6}, {0x00f8, 0x00ff}, {0x0148, 0x0149}, {0x017e, 0x0180}, 
                 {0x0199, 0x019a}, {0x01c5, 0x01c6}, {0x01c8, 0x01c9}, {0x01cb, 0x01cc}, 
                 {0x01dc, 0x01dd}, {0x01ef, 0x01f0}, {0x01f2, 0x01f3}, {0x023f, 0x0240}, 
                 {0x024f, 0x0254}, {0x0256, 0x0257}, {0x025b, 0x025c}, {0x0260, 0x0261}, 
                 {0x0265, 0x0266}, {0x0268, 0x026c}, {0x0271, 0x0272}, {0x0287, 0x028c}, 
                 {0x029d, 0x029e}, {0x037b, 0x037d}, {0x03ac, 0x03ce}, {0x03d0, 0x03d1}, 
                 {0x03d5, 0x03d7}, {0x03ef, 0x03f3}, {0x0430, 0x045f}, {0x04ce, 0x04cf}, 
                 {0x0561, 0x0587}, {0x10d0, 0x10fa}, {0x10fd, 0x10ff}, {0x13f8, 0x13fd}, 
                 {0x1c80, 0x1c88}, {0x1e95, 0x1e9b}, {0x1eff, 0x1f07}, {0x1f10, 0x1f15}, 
                 {0x1f20, 0x1f27}, {0x1f30, 0x1f37}, {0x1f40, 0x1f45}, {0x1f50, 0x1f57}, 
                 {0x1f60, 0x1f67}, {0x1f70, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fb7}, 
                 {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fc7}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fd7}, 
                 {0x1fe0, 0x1fe7}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ff7}, {0x2170, 0x217f}, 
                 {0x24d0, 0x24e9}, {0x2c30, 0x2c5e}, {0x2c65, 0x2c66}, {0x2d00, 0x2d25}, 
                 {0xab70, 0xabbf}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xff41, 0xff5a}, 
                 {0x10428, 0x1044f}, {0x104d8, 0x104fb}, {0x10cc0, 0x10cf2}, {0x118c0, 0x118df}, 
                 {0x16e60, 0x16e7f}, {0x1e922, 0x1e943}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass50()
{
    // Name = Changes_When_Titlecased, number of codePoints: 1402
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x61, 0x7a}}),
        std::initializer_list<UChar32>({0x00b5, 0x0101, 0x0103, 0x0105, 0x0107, 0x0109, 0x010b, 0x010d, 
                 0x010f, 0x0111, 0x0113, 0x0115, 0x0117, 0x0119, 0x011b, 0x011d, 
                 0x011f, 0x0121, 0x0123, 0x0125, 0x0127, 0x0129, 0x012b, 0x012d, 
                 0x012f, 0x0131, 0x0133, 0x0135, 0x0137, 0x013a, 0x013c, 0x013e, 
                 0x0140, 0x0142, 0x0144, 0x0146, 0x014b, 0x014d, 0x014f, 0x0151, 
                 0x0153, 0x0155, 0x0157, 0x0159, 0x015b, 0x015d, 0x015f, 0x0161, 
                 0x0163, 0x0165, 0x0167, 0x0169, 0x016b, 0x016d, 0x016f, 0x0171, 
                 0x0173, 0x0175, 0x0177, 0x017a, 0x017c, 0x0183, 0x0185, 0x0188, 
                 0x018c, 0x0192, 0x0195, 0x019e, 0x01a1, 0x01a3, 0x01a5, 0x01a8, 
                 0x01ad, 0x01b0, 0x01b4, 0x01b6, 0x01b9, 0x01bd, 0x01bf, 0x01c4, 
                 0x01cc, 0x01ce, 0x01d0, 0x01d2, 0x01d4, 0x01d6, 0x01d8, 0x01da, 
                 0x01df, 0x01e1, 0x01e3, 0x01e5, 0x01e7, 0x01e9, 0x01eb, 0x01ed, 
                 0x01f3, 0x01f5, 0x01f9, 0x01fb, 0x01fd, 0x01ff, 0x0201, 0x0203, 
                 0x0205, 0x0207, 0x0209, 0x020b, 0x020d, 0x020f, 0x0211, 0x0213, 
                 0x0215, 0x0217, 0x0219, 0x021b, 0x021d, 0x021f, 0x0223, 0x0225, 
                 0x0227, 0x0229, 0x022b, 0x022d, 0x022f, 0x0231, 0x0233, 0x023c, 
                 0x0242, 0x0247, 0x0249, 0x024b, 0x024d, 0x0259, 0x0263, 0x026f, 
                 0x0275, 0x027d, 0x0280, 0x0283, 0x0292, 0x0345, 0x0371, 0x0373, 
                 0x0377, 0x0390, 0x03d9, 0x03db, 0x03dd, 0x03df, 0x03e1, 0x03e3, 
                 0x03e5, 0x03e7, 0x03e9, 0x03eb, 0x03ed, 0x03f5, 0x03f8, 0x03fb, 
                 0x0461, 0x0463, 0x0465, 0x0467, 0x0469, 0x046b, 0x046d, 0x046f, 
                 0x0471, 0x0473, 0x0475, 0x0477, 0x0479, 0x047b, 0x047d, 0x047f, 
                 0x0481, 0x048b, 0x048d, 0x048f, 0x0491, 0x0493, 0x0495, 0x0497, 
                 0x0499, 0x049b, 0x049d, 0x049f, 0x04a1, 0x04a3, 0x04a5, 0x04a7, 
                 0x04a9, 0x04ab, 0x04ad, 0x04af, 0x04b1, 0x04b3, 0x04b5, 0x04b7, 
                 0x04b9, 0x04bb, 0x04bd, 0x04bf, 0x04c2, 0x04c4, 0x04c6, 0x04c8, 
                 0x04ca, 0x04cc, 0x04d1, 0x04d3, 0x04d5, 0x04d7, 0x04d9, 0x04db, 
                 0x04dd, 0x04df, 0x04e1, 0x04e3, 0x04e5, 0x04e7, 0x04e9, 0x04eb, 
                 0x04ed, 0x04ef, 0x04f1, 0x04f3, 0x04f5, 0x04f7, 0x04f9, 0x04fb, 
                 0x04fd, 0x04ff, 0x0501, 0x0503, 0x0505, 0x0507, 0x0509, 0x050b, 
                 0x050d, 0x050f, 0x0511, 0x0513, 0x0515, 0x0517, 0x0519, 0x051b, 
                 0x051d, 0x051f, 0x0521, 0x0523, 0x0525, 0x0527, 0x0529, 0x052b, 
                 0x052d, 0x052f, 0x1d79, 0x1d7d, 0x1e01, 0x1e03, 0x1e05, 0x1e07, 
                 0x1e09, 0x1e0b, 0x1e0d, 0x1e0f, 0x1e11, 0x1e13, 0x1e15, 0x1e17, 
                 0x1e19, 0x1e1b, 0x1e1d, 0x1e1f, 0x1e21, 0x1e23, 0x1e25, 0x1e27, 
                 0x1e29, 0x1e2b, 0x1e2d, 0x1e2f, 0x1e31, 0x1e33, 0x1e35, 0x1e37, 
                 0x1e39, 0x1e3b, 0x1e3d, 0x1e3f, 0x1e41, 0x1e43, 0x1e45, 0x1e47, 
                 0x1e49, 0x1e4b, 0x1e4d, 0x1e4f, 0x1e51, 0x1e53, 0x1e55, 0x1e57, 
                 0x1e59, 0x1e5b, 0x1e5d, 0x1e5f, 0x1e61, 0x1e63, 0x1e65, 0x1e67, 
                 0x1e69, 0x1e6b, 0x1e6d, 0x1e6f, 0x1e71, 0x1e73, 0x1e75, 0x1e77, 
                 0x1e79, 0x1e7b, 0x1e7d, 0x1e7f, 0x1e81, 0x1e83, 0x1e85, 0x1e87, 
                 0x1e89, 0x1e8b, 0x1e8d, 0x1e8f, 0x1e91, 0x1e93, 0x1ea1, 0x1ea3, 
                 0x1ea5, 0x1ea7, 0x1ea9, 0x1eab, 0x1ead, 0x1eaf, 0x1eb1, 0x1eb3, 
                 0x1eb5, 0x1eb7, 0x1eb9, 0x1ebb, 0x1ebd, 0x1ebf, 0x1ec1, 0x1ec3, 
                 0x1ec5, 0x1ec7, 0x1ec9, 0x1ecb, 0x1ecd, 0x1ecf, 0x1ed1, 0x1ed3, 
                 0x1ed5, 0x1ed7, 0x1ed9, 0x1edb, 0x1edd, 0x1edf, 0x1ee1, 0x1ee3, 
                 0x1ee5, 0x1ee7, 0x1ee9, 0x1eeb, 0x1eed, 0x1eef, 0x1ef1, 0x1ef3, 
                 0x1ef5, 0x1ef7, 0x1ef9, 0x1efb, 0x1efd, 0x1fbe, 0x214e, 0x2184, 
                 0x2c61, 0x2c68, 0x2c6a, 0x2c6c, 0x2c73, 0x2c76, 0x2c81, 0x2c83, 
                 0x2c85, 0x2c87, 0x2c89, 0x2c8b, 0x2c8d, 0x2c8f, 0x2c91, 0x2c93, 
                 0x2c95, 0x2c97, 0x2c99, 0x2c9b, 0x2c9d, 0x2c9f, 0x2ca1, 0x2ca3, 
                 0x2ca5, 0x2ca7, 0x2ca9, 0x2cab, 0x2cad, 0x2caf, 0x2cb1, 0x2cb3, 
                 0x2cb5, 0x2cb7, 0x2cb9, 0x2cbb, 0x2cbd, 0x2cbf, 0x2cc1, 0x2cc3, 
                 0x2cc5, 0x2cc7, 0x2cc9, 0x2ccb, 0x2ccd, 0x2ccf, 0x2cd1, 0x2cd3, 
                 0x2cd5, 0x2cd7, 0x2cd9, 0x2cdb, 0x2cdd, 0x2cdf, 0x2ce1, 0x2ce3, 
                 0x2cec, 0x2cee, 0x2cf3, 0x2d27, 0x2d2d, 0xa641, 0xa643, 0xa645, 
                 0xa647, 0xa649, 0xa64b, 0xa64d, 0xa64f, 0xa651, 0xa653, 0xa655, 
                 0xa657, 0xa659, 0xa65b, 0xa65d, 0xa65f, 0xa661, 0xa663, 0xa665, 
                 0xa667, 0xa669, 0xa66b, 0xa66d, 0xa681, 0xa683, 0xa685, 0xa687, 
                 0xa689, 0xa68b, 0xa68d, 0xa68f, 0xa691, 0xa693, 0xa695, 0xa697, 
                 0xa699, 0xa69b, 0xa723, 0xa725, 0xa727, 0xa729, 0xa72b, 0xa72d, 
                 0xa72f, 0xa733, 0xa735, 0xa737, 0xa739, 0xa73b, 0xa73d, 0xa73f, 
                 0xa741, 0xa743, 0xa745, 0xa747, 0xa749, 0xa74b, 0xa74d, 0xa74f, 
                 0xa751, 0xa753, 0xa755, 0xa757, 0xa759, 0xa75b, 0xa75d, 0xa75f, 
                 0xa761, 0xa763, 0xa765, 0xa767, 0xa769, 0xa76b, 0xa76d, 0xa76f, 
                 0xa77a, 0xa77c, 0xa77f, 0xa781, 0xa783, 0xa785, 0xa787, 0xa78c, 
                 0xa791, 0xa793, 0xa797, 0xa799, 0xa79b, 0xa79d, 0xa79f, 0xa7a1, 
                 0xa7a3, 0xa7a5, 0xa7a7, 0xa7a9, 0xa7b5, 0xa7b7, 0xa7b9, 0xab53}),
        std::initializer_list<CharacterRange>({{0x00df, 0x00f6}, {0x00f8, 0x00ff}, {0x0148, 0x0149}, {0x017e, 0x0180}, 
                 {0x0199, 0x019a}, {0x01c6, 0x01c7}, {0x01c9, 0x01ca}, {0x01dc, 0x01dd}, 
                 {0x01ef, 0x01f1}, {0x023f, 0x0240}, {0x024f, 0x0254}, {0x0256, 0x0257}, 
                 {0x025b, 0x025c}, {0x0260, 0x0261}, {0x0265, 0x0266}, {0x0268, 0x026c}, 
                 {0x0271, 0x0272}, {0x0287, 0x028c}, {0x029d, 0x029e}, {0x037b, 0x037d}, 
                 {0x03ac, 0x03ce}, {0x03d0, 0x03d1}, {0x03d5, 0x03d7}, {0x03ef, 0x03f3}, 
                 {0x0430, 0x045f}, {0x04ce, 0x04cf}, {0x0561, 0x0587}, {0x13f8, 0x13fd}, 
                 {0x1c80, 0x1c88}, {0x1e95, 0x1e9b}, {0x1eff, 0x1f07}, {0x1f10, 0x1f15}, 
                 {0x1f20, 0x1f27}, {0x1f30, 0x1f37}, {0x1f40, 0x1f45}, {0x1f50, 0x1f57}, 
                 {0x1f60, 0x1f67}, {0x1f70, 0x1f7d}, {0x1f80, 0x1f87}, {0x1f90, 0x1f97}, 
                 {0x1fa0, 0x1fa7}, {0x1fb0, 0x1fb4}, {0x1fb6, 0x1fb7}, {0x1fc2, 0x1fc4}, 
                 {0x1fc6, 0x1fc7}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fd7}, {0x1fe0, 0x1fe7}, 
                 {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ff7}, {0x2170, 0x217f}, {0x24d0, 0x24e9}, 
                 {0x2c30, 0x2c5e}, {0x2c65, 0x2c66}, {0x2d00, 0x2d25}, {0xab70, 0xabbf}, 
                 {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xff41, 0xff5a}, {0x10428, 0x1044f}, 
                 {0x104d8, 0x104fb}, {0x10cc0, 0x10cf2}, {0x118c0, 0x118df}, {0x16e60, 0x16e7f}, 
                 {0x1e922, 0x1e943}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass51()
{
    // Name = Changes_When_Casefolded, number of codePoints: 1456
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}}),
        std::initializer_list<UChar32>({0x00b5, 0x0100, 0x0102, 0x0104, 0x0106, 0x0108, 0x010a, 0x010c, 
                 0x010e, 0x0110, 0x0112, 0x0114, 0x0116, 0x0118, 0x011a, 0x011c, 
                 0x011e, 0x0120, 0x0122, 0x0124, 0x0126, 0x0128, 0x012a, 0x012c, 
                 0x012e, 0x0130, 0x0132, 0x0134, 0x0136, 0x0139, 0x013b, 0x013d, 
                 0x013f, 0x0141, 0x0143, 0x0145, 0x0147, 0x014c, 0x014e, 0x0150, 
                 0x0152, 0x0154, 0x0156, 0x0158, 0x015a, 0x015c, 0x015e, 0x0160, 
                 0x0162, 0x0164, 0x0166, 0x0168, 0x016a, 0x016c, 0x016e, 0x0170, 
                 0x0172, 0x0174, 0x0176, 0x017b, 0x017d, 0x017f, 0x0184, 0x01a2, 
                 0x01a4, 0x01a9, 0x01ac, 0x01b5, 0x01bc, 0x01cd, 0x01cf, 0x01d1, 
                 0x01d3, 0x01d5, 0x01d7, 0x01d9, 0x01db, 0x01de, 0x01e0, 0x01e2, 
                 0x01e4, 0x01e6, 0x01e8, 0x01ea, 0x01ec, 0x01ee, 0x01f4, 0x01fa, 
                 0x01fc, 0x01fe, 0x0200, 0x0202, 0x0204, 0x0206, 0x0208, 0x020a, 
                 0x020c, 0x020e, 0x0210, 0x0212, 0x0214, 0x0216, 0x0218, 0x021a, 
                 0x021c, 0x021e, 0x0220, 0x0222, 0x0224, 0x0226, 0x0228, 0x022a, 
                 0x022c, 0x022e, 0x0230, 0x0232, 0x0241, 0x0248, 0x024a, 0x024c, 
                 0x024e, 0x0345, 0x0370, 0x0372, 0x0376, 0x037f, 0x0386, 0x038c, 
                 0x03c2, 0x03d8, 0x03da, 0x03dc, 0x03de, 0x03e0, 0x03e2, 0x03e4, 
                 0x03e6, 0x03e8, 0x03ea, 0x03ec, 0x03ee, 0x03f7, 0x0460, 0x0462, 
                 0x0464, 0x0466, 0x0468, 0x046a, 0x046c, 0x046e, 0x0470, 0x0472, 
                 0x0474, 0x0476, 0x0478, 0x047a, 0x047c, 0x047e, 0x0480, 0x048a, 
                 0x048c, 0x048e, 0x0490, 0x0492, 0x0494, 0x0496, 0x0498, 0x049a, 
                 0x049c, 0x049e, 0x04a0, 0x04a2, 0x04a4, 0x04a6, 0x04a8, 0x04aa, 
                 0x04ac, 0x04ae, 0x04b0, 0x04b2, 0x04b4, 0x04b6, 0x04b8, 0x04ba, 
                 0x04bc, 0x04be, 0x04c3, 0x04c5, 0x04c7, 0x04c9, 0x04cb, 0x04cd, 
                 0x04d0, 0x04d2, 0x04d4, 0x04d6, 0x04d8, 0x04da, 0x04dc, 0x04de, 
                 0x04e0, 0x04e2, 0x04e4, 0x04e6, 0x04e8, 0x04ea, 0x04ec, 0x04ee, 
                 0x04f0, 0x04f2, 0x04f4, 0x04f6, 0x04f8, 0x04fa, 0x04fc, 0x04fe, 
                 0x0500, 0x0502, 0x0504, 0x0506, 0x0508, 0x050a, 0x050c, 0x050e, 
                 0x0510, 0x0512, 0x0514, 0x0516, 0x0518, 0x051a, 0x051c, 0x051e, 
                 0x0520, 0x0522, 0x0524, 0x0526, 0x0528, 0x052a, 0x052c, 0x052e, 
                 0x0587, 0x10c7, 0x10cd, 0x1e00, 0x1e02, 0x1e04, 0x1e06, 0x1e08, 
                 0x1e0a, 0x1e0c, 0x1e0e, 0x1e10, 0x1e12, 0x1e14, 0x1e16, 0x1e18, 
                 0x1e1a, 0x1e1c, 0x1e1e, 0x1e20, 0x1e22, 0x1e24, 0x1e26, 0x1e28, 
                 0x1e2a, 0x1e2c, 0x1e2e, 0x1e30, 0x1e32, 0x1e34, 0x1e36, 0x1e38, 
                 0x1e3a, 0x1e3c, 0x1e3e, 0x1e40, 0x1e42, 0x1e44, 0x1e46, 0x1e48, 
                 0x1e4a, 0x1e4c, 0x1e4e, 0x1e50, 0x1e52, 0x1e54, 0x1e56, 0x1e58, 
                 0x1e5a, 0x1e5c, 0x1e5e, 0x1e60, 0x1e62, 0x1e64, 0x1e66, 0x1e68, 
                 0x1e6a, 0x1e6c, 0x1e6e, 0x1e70, 0x1e72, 0x1e74, 0x1e76, 0x1e78, 
                 0x1e7a, 0x1e7c, 0x1e7e, 0x1e80, 0x1e82, 0x1e84, 0x1e86, 0x1e88, 
                 0x1e8a, 0x1e8c, 0x1e8e, 0x1e90, 0x1e92, 0x1e94, 0x1e9e, 0x1ea0, 
                 0x1ea2, 0x1ea4, 0x1ea6, 0x1ea8, 0x1eaa, 0x1eac, 0x1eae, 0x1eb0, 
                 0x1eb2, 0x1eb4, 0x1eb6, 0x1eb8, 0x1eba, 0x1ebc, 0x1ebe, 0x1ec0, 
                 0x1ec2, 0x1ec4, 0x1ec6, 0x1ec8, 0x1eca, 0x1ecc, 0x1ece, 0x1ed0, 
                 0x1ed2, 0x1ed4, 0x1ed6, 0x1ed8, 0x1eda, 0x1edc, 0x1ede, 0x1ee0, 
                 0x1ee2, 0x1ee4, 0x1ee6, 0x1ee8, 0x1eea, 0x1eec, 0x1eee, 0x1ef0, 
                 0x1ef2, 0x1ef4, 0x1ef6, 0x1ef8, 0x1efa, 0x1efc, 0x1efe, 0x1f59, 
                 0x1f5b, 0x1f5d, 0x1f5f, 0x2126, 0x2132, 0x2183, 0x2c60, 0x2c67, 
                 0x2c69, 0x2c6b, 0x2c72, 0x2c75, 0x2c82, 0x2c84, 0x2c86, 0x2c88, 
                 0x2c8a, 0x2c8c, 0x2c8e, 0x2c90, 0x2c92, 0x2c94, 0x2c96, 0x2c98, 
                 0x2c9a, 0x2c9c, 0x2c9e, 0x2ca0, 0x2ca2, 0x2ca4, 0x2ca6, 0x2ca8, 
                 0x2caa, 0x2cac, 0x2cae, 0x2cb0, 0x2cb2, 0x2cb4, 0x2cb6, 0x2cb8, 
                 0x2cba, 0x2cbc, 0x2cbe, 0x2cc0, 0x2cc2, 0x2cc4, 0x2cc6, 0x2cc8, 
                 0x2cca, 0x2ccc, 0x2cce, 0x2cd0, 0x2cd2, 0x2cd4, 0x2cd6, 0x2cd8, 
                 0x2cda, 0x2cdc, 0x2cde, 0x2ce0, 0x2ce2, 0x2ceb, 0x2ced, 0x2cf2, 
                 0xa640, 0xa642, 0xa644, 0xa646, 0xa648, 0xa64a, 0xa64c, 0xa64e, 
                 0xa650, 0xa652, 0xa654, 0xa656, 0xa658, 0xa65a, 0xa65c, 0xa65e, 
                 0xa660, 0xa662, 0xa664, 0xa666, 0xa668, 0xa66a, 0xa66c, 0xa680, 
                 0xa682, 0xa684, 0xa686, 0xa688, 0xa68a, 0xa68c, 0xa68e, 0xa690, 
                 0xa692, 0xa694, 0xa696, 0xa698, 0xa69a, 0xa722, 0xa724, 0xa726, 
                 0xa728, 0xa72a, 0xa72c, 0xa72e, 0xa732, 0xa734, 0xa736, 0xa738, 
                 0xa73a, 0xa73c, 0xa73e, 0xa740, 0xa742, 0xa744, 0xa746, 0xa748, 
                 0xa74a, 0xa74c, 0xa74e, 0xa750, 0xa752, 0xa754, 0xa756, 0xa758, 
                 0xa75a, 0xa75c, 0xa75e, 0xa760, 0xa762, 0xa764, 0xa766, 0xa768, 
                 0xa76a, 0xa76c, 0xa76e, 0xa779, 0xa77b, 0xa780, 0xa782, 0xa784, 
                 0xa786, 0xa78b, 0xa78d, 0xa790, 0xa792, 0xa796, 0xa798, 0xa79a, 
                 0xa79c, 0xa79e, 0xa7a0, 0xa7a2, 0xa7a4, 0xa7a6, 0xa7a8, 0xa7b6, 
                 0xa7b8}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00df}, {0x0149, 0x014a}, {0x0178, 0x0179}, 
                 {0x0181, 0x0182}, {0x0186, 0x0187}, {0x0189, 0x018b}, {0x018e, 0x0191}, 
                 {0x0193, 0x0194}, {0x0196, 0x0198}, {0x019c, 0x019d}, {0x019f, 0x01a0}, 
                 {0x01a6, 0x01a7}, {0x01ae, 0x01af}, {0x01b1, 0x01b3}, {0x01b7, 0x01b8}, 
                 {0x01c4, 0x01c5}, {0x01c7, 0x01c8}, {0x01ca, 0x01cb}, {0x01f1, 0x01f2}, 
                 {0x01f6, 0x01f8}, {0x023a, 0x023b}, {0x023d, 0x023e}, {0x0243, 0x0246}, 
                 {0x0388, 0x038a}, {0x038e, 0x038f}, {0x0391, 0x03a1}, {0x03a3, 0x03ab}, 
                 {0x03cf, 0x03d1}, {0x03d5, 0x03d6}, {0x03f0, 0x03f1}, {0x03f4, 0x03f5}, 
                 {0x03f9, 0x03fa}, {0x03fd, 0x042f}, {0x04c0, 0x04c1}, {0x0531, 0x0556}, 
                 {0x10a0, 0x10c5}, {0x13f8, 0x13fd}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, 
                 {0x1cbd, 0x1cbf}, {0x1e9a, 0x1e9b}, {0x1f08, 0x1f0f}, {0x1f18, 0x1f1d}, 
                 {0x1f28, 0x1f2f}, {0x1f38, 0x1f3f}, {0x1f48, 0x1f4d}, {0x1f68, 0x1f6f}, 
                 {0x1f80, 0x1faf}, {0x1fb2, 0x1fb4}, {0x1fb7, 0x1fbc}, {0x1fc2, 0x1fc4}, 
                 {0x1fc7, 0x1fcc}, {0x1fd8, 0x1fdb}, {0x1fe8, 0x1fec}, {0x1ff2, 0x1ff4}, 
                 {0x1ff7, 0x1ffc}, {0x212a, 0x212b}, {0x2160, 0x216f}, {0x24b6, 0x24cf}, 
                 {0x2c00, 0x2c2e}, {0x2c62, 0x2c64}, {0x2c6d, 0x2c70}, {0x2c7e, 0x2c80}, 
                 {0xa77d, 0xa77e}, {0xa7aa, 0xa7ae}, {0xa7b0, 0xa7b4}, {0xab70, 0xabbf}, 
                 {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xff21, 0xff3a}, {0x10400, 0x10427}, 
                 {0x104b0, 0x104d3}, {0x10c80, 0x10cb2}, {0x118a0, 0x118bf}, {0x16e40, 0x16e5f}, 
                 {0x1e900, 0x1e921}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass52()
{
    // Name = Changes_When_Casemapped, number of codePoints: 2827
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<UChar32>({0x00b5, 0x01bf, 0x0259, 0x0263, 0x026f, 0x0275, 0x027d, 0x0280, 
                 0x0283, 0x0292, 0x0345, 0x037f, 0x0386, 0x038c, 0x10c7, 0x10cd, 
                 0x1d79, 0x1d7d, 0x1e9e, 0x1f59, 0x1f5b, 0x1f5d, 0x1fbe, 0x2126, 
                 0x2132, 0x214e, 0x2d27, 0x2d2d, 0xab53}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x0137}, {0x0139, 0x018c}, 
                 {0x018e, 0x019a}, {0x019c, 0x01a9}, {0x01ac, 0x01b9}, {0x01bc, 0x01bd}, 
                 {0x01c4, 0x0220}, {0x0222, 0x0233}, {0x023a, 0x0254}, {0x0256, 0x0257}, 
                 {0x025b, 0x025c}, {0x0260, 0x0261}, {0x0265, 0x0266}, {0x0268, 0x026c}, 
                 {0x0271, 0x0272}, {0x0287, 0x028c}, {0x029d, 0x029e}, {0x0370, 0x0373}, 
                 {0x0376, 0x0377}, {0x037b, 0x037d}, {0x0388, 0x038a}, {0x038e, 0x03a1}, 
                 {0x03a3, 0x03d1}, {0x03d5, 0x03f5}, {0x03f7, 0x03fb}, {0x03fd, 0x0481}, 
                 {0x048a, 0x052f}, {0x0531, 0x0556}, {0x0561, 0x0587}, {0x10a0, 0x10c5}, 
                 {0x10d0, 0x10fa}, {0x10fd, 0x10ff}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, 
                 {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1e00, 0x1e9b}, 
                 {0x1ea0, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, 
                 {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, 
                 {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, 
                 {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x212a, 0x212b}, 
                 {0x2160, 0x217f}, {0x2183, 0x2184}, {0x24b6, 0x24e9}, {0x2c00, 0x2c2e}, 
                 {0x2c30, 0x2c5e}, {0x2c60, 0x2c70}, {0x2c72, 0x2c73}, {0x2c75, 0x2c76}, 
                 {0x2c7e, 0x2ce3}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, 
                 {0xa640, 0xa66d}, {0xa680, 0xa69b}, {0xa722, 0xa72f}, {0xa732, 0xa76f}, 
                 {0xa779, 0xa787}, {0xa78b, 0xa78d}, {0xa790, 0xa793}, {0xa796, 0xa7ae}, 
                 {0xa7b0, 0xa7b9}, {0xab70, 0xabbf}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, 
                 {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0x10400, 0x1044f}, {0x104b0, 0x104d3}, 
                 {0x104d8, 0x104fb}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x118a0, 0x118df}, 
                 {0x16e40, 0x16e7f}, {0x1e900, 0x1e943}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass53()
{
    // Name = ID_Start, number of codePoints: 125660
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<UChar32>({0x00aa, 0x00b5, 0x00ba, 0x02ec, 0x02ee, 0x037f, 0x0386, 0x038c, 
                 0x0559, 0x06d5, 0x06ff, 0x0710, 0x07b1, 0x07fa, 0x081a, 0x0824, 
                 0x0828, 0x093d, 0x0950, 0x09b2, 0x09bd, 0x09ce, 0x09fc, 0x0a5e, 
                 0x0abd, 0x0ad0, 0x0af9, 0x0b3d, 0x0b71, 0x0b83, 0x0b9c, 0x0bd0, 
                 0x0c3d, 0x0c80, 0x0cbd, 0x0cde, 0x0d3d, 0x0d4e, 0x0dbd, 0x0e84, 
                 0x0e8a, 0x0e8d, 0x0ea5, 0x0ea7, 0x0ebd, 0x0ec6, 0x0f00, 0x103f, 
                 0x1061, 0x108e, 0x10c7, 0x10cd, 0x1258, 0x12c0, 0x17d7, 0x17dc, 
                 0x18aa, 0x1aa7, 0x1f59, 0x1f5b, 0x1f5d, 0x1fbe, 0x2071, 0x207f, 
                 0x2102, 0x2107, 0x2115, 0x2124, 0x2126, 0x2128, 0x214e, 0x2d27, 
                 0x2d2d, 0x2d6f, 0xa8fb, 0xa9cf, 0xaa7a, 0xaab1, 0xaac0, 0xaac2, 
                 0xfb1d, 0xfb3e, 0x10808, 0x1083c, 0x10a00, 0x10f27, 0x11144, 0x11176, 
                 0x111da, 0x111dc, 0x11288, 0x1133d, 0x11350, 0x114c7, 0x11644, 0x118ff, 
                 0x11a00, 0x11a3a, 0x11a50, 0x11a9d, 0x11c40, 0x11d46, 0x11d98, 0x16f50, 
                 0x1d4a2, 0x1d4bb, 0x1d546, 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 
                 0x1ee47, 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 
                 0x1ee5f, 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x02c1}, {0x02c6, 0x02d1}, 
                 {0x02e0, 0x02e4}, {0x0370, 0x0374}, {0x0376, 0x0377}, {0x037a, 0x037d}, 
                 {0x0388, 0x038a}, {0x038e, 0x03a1}, {0x03a3, 0x03f5}, {0x03f7, 0x0481}, 
                 {0x048a, 0x052f}, {0x0531, 0x0556}, {0x0560, 0x0588}, {0x05d0, 0x05ea}, 
                 {0x05ef, 0x05f2}, {0x0620, 0x064a}, {0x066e, 0x066f}, {0x0671, 0x06d3}, 
                 {0x06e5, 0x06e6}, {0x06ee, 0x06ef}, {0x06fa, 0x06fc}, {0x0712, 0x072f}, 
                 {0x074d, 0x07a5}, {0x07ca, 0x07ea}, {0x07f4, 0x07f5}, {0x0800, 0x0815}, 
                 {0x0840, 0x0858}, {0x0860, 0x086a}, {0x08a0, 0x08b4}, {0x08b6, 0x08bd}, 
                 {0x0904, 0x0939}, {0x0958, 0x0961}, {0x0971, 0x0980}, {0x0985, 0x098c}, 
                 {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, {0x09b6, 0x09b9}, 
                 {0x09dc, 0x09dd}, {0x09df, 0x09e1}, {0x09f0, 0x09f1}, {0x0a05, 0x0a0a}, 
                 {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, 
                 {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a59, 0x0a5c}, {0x0a72, 0x0a74}, 
                 {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0}, 
                 {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0ae0, 0x0ae1}, {0x0b05, 0x0b0c}, 
                 {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, 
                 {0x0b35, 0x0b39}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b61}, {0x0b85, 0x0b8a}, 
                 {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9e, 0x0b9f}, 
                 {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, {0x0c05, 0x0c0c}, 
                 {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, {0x0c58, 0x0c5a}, 
                 {0x0c60, 0x0c61}, {0x0c85, 0x0c8c}, {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, 
                 {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0ce0, 0x0ce1}, {0x0cf1, 0x0cf2}, 
                 {0x0d05, 0x0d0c}, {0x0d0e, 0x0d10}, {0x0d12, 0x0d3a}, {0x0d54, 0x0d56}, 
                 {0x0d5f, 0x0d61}, {0x0d7a, 0x0d7f}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, 
                 {0x0db3, 0x0dbb}, {0x0dc0, 0x0dc6}, {0x0e01, 0x0e30}, {0x0e32, 0x0e33}, 
                 {0x0e40, 0x0e46}, {0x0e81, 0x0e82}, {0x0e87, 0x0e88}, {0x0e94, 0x0e97}, 
                 {0x0e99, 0x0e9f}, {0x0ea1, 0x0ea3}, {0x0eaa, 0x0eab}, {0x0ead, 0x0eb0}, 
                 {0x0eb2, 0x0eb3}, {0x0ec0, 0x0ec4}, {0x0edc, 0x0edf}, {0x0f40, 0x0f47}, 
                 {0x0f49, 0x0f6c}, {0x0f88, 0x0f8c}, {0x1000, 0x102a}, {0x1050, 0x1055}, 
                 {0x105a, 0x105d}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081}, 
                 {0x10a0, 0x10c5}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, 
                 {0x1250, 0x1256}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, 
                 {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c2, 0x12c5}, 
                 {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, 
                 {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, 
                 {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, 
                 {0x1700, 0x170c}, {0x170e, 0x1711}, {0x1720, 0x1731}, {0x1740, 0x1751}, 
                 {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x1820, 0x1878}, 
                 {0x1880, 0x18a8}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, 
                 {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, 
                 {0x1a20, 0x1a54}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4b}, {0x1b83, 0x1ba0}, 
                 {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f}, 
                 {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, 
                 {0x1ce9, 0x1cec}, {0x1cee, 0x1cf1}, {0x1cf5, 0x1cf6}, {0x1d00, 0x1dbf}, 
                 {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, 
                 {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, 
                 {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, 
                 {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2090, 0x209c}, 
                 {0x210a, 0x2113}, {0x2118, 0x211d}, {0x212a, 0x2139}, {0x213c, 0x213f}, 
                 {0x2145, 0x2149}, {0x2160, 0x2188}, {0x2c00, 0x2c2e}, {0x2c30, 0x2c5e}, 
                 {0x2c60, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, 
                 {0x2d30, 0x2d67}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, 
                 {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, 
                 {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007}, {0x3021, 0x3029}, 
                 {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309b, 0x309f}, 
                 {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, 
                 {0x31a0, 0x31ba}, {0x31f0, 0x31ff}, {0x3400, 0x4db5}, {0x4e00, 0x9fef}, 
                 {0xa000, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, 
                 {0xa62a, 0xa62b}, {0xa640, 0xa66e}, {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, 
                 {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7b9}, {0xa7f7, 0xa801}, 
                 {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, 
                 {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, 
                 {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9e0, 0xa9e4}, 
                 {0xa9e6, 0xa9ef}, {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, 
                 {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7e, 0xaaaf}, {0xaab5, 0xaab6}, 
                 {0xaab9, 0xaabd}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, 
                 {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, 
                 {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab65}, {0xab70, 0xabe2}, 
                 {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, 
                 {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1f, 0xfb28}, 
                 {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, 
                 {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, 
                 {0xfdf0, 0xfdfb}, {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, {0xff21, 0xff3a}, 
                 {0xff41, 0xff5a}, {0xff66, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, 
                 {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, 
                 {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, 
                 {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, 
                 {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d}, 
                 {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, 
                 {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, 
                 {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10800, 0x10805}, 
                 {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083f, 0x10855}, {0x10860, 0x10876}, 
                 {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, 
                 {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a10, 0x10a13}, 
                 {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, 
                 {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, 
                 {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, 
                 {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10f00, 0x10f1c}, {0x10f30, 0x10f45}, 
                 {0x11003, 0x11037}, {0x11083, 0x110af}, {0x110d0, 0x110e8}, {0x11103, 0x11126}, 
                 {0x11150, 0x11172}, {0x11183, 0x111b2}, {0x111c1, 0x111c4}, {0x11200, 0x11211}, 
                 {0x11213, 0x1122b}, {0x11280, 0x11286}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, 
                 {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, 
                 {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, 
                 {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x11480, 0x114af}, 
                 {0x114c4, 0x114c5}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, 
                 {0x11680, 0x116aa}, {0x11700, 0x1171a}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, 
                 {0x11a0b, 0x11a32}, {0x11a5c, 0x11a83}, {0x11a86, 0x11a89}, {0x11ac0, 0x11af8}, 
                 {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, 
                 {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, 
                 {0x11d6a, 0x11d89}, {0x11ee0, 0x11ef2}, {0x12000, 0x12399}, {0x12400, 0x1246e}, 
                 {0x12480, 0x12543}, {0x13000, 0x1342e}, {0x14400, 0x14646}, {0x16800, 0x16a38}, 
                 {0x16a40, 0x16a5e}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, 
                 {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f44}, 
                 {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x17000, 0x187f1}, {0x18800, 0x18af2}, 
                 {0x1b000, 0x1b11e}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, 
                 {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, 
                 {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, 
                 {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, 
                 {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, 
                 {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, 
                 {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, 
                 {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, 
                 {0x1d7c4, 0x1d7cb}, {0x1e800, 0x1e8c4}, {0x1e900, 0x1e943}, {0x1ee00, 0x1ee03}, 
                 {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, 
                 {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, 
                 {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, 
                 {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, 
                 {0x20000, 0x2a6d6}, {0x2a700, 0x2b734}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, 
                 {0x2ceb0, 0x2ebe0}, {0x2f800, 0x2fa1d}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass54()
{
    // Name = ID_Continue, number of codePoints: 128510
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x5f}),
        std::initializer_list<CharacterRange>({{0x30, 0x39}, {0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<UChar32>({0x00aa, 0x00b5, 0x00b7, 0x00ba, 0x02ec, 0x02ee, 0x037f, 0x038c, 
                 0x0559, 0x05bf, 0x05c7, 0x06ff, 0x07fa, 0x07fd, 0x09b2, 0x09d7, 
                 0x09fc, 0x09fe, 0x0a3c, 0x0a51, 0x0a5e, 0x0ad0, 0x0b71, 0x0b9c, 
                 0x0bd0, 0x0bd7, 0x0cde, 0x0dbd, 0x0dca, 0x0dd6, 0x0e84, 0x0e8a, 
                 0x0e8d, 0x0ea5, 0x0ea7, 0x0ec6, 0x0f00, 0x0f35, 0x0f37, 0x0f39, 
                 0x0fc6, 0x10c7, 0x10cd, 0x1258, 0x12c0, 0x17d7, 0x1aa7, 0x1f59, 
                 0x1f5b, 0x1f5d, 0x1fbe, 0x2054, 0x2071, 0x207f, 0x20e1, 0x2102, 
                 0x2107, 0x2115, 0x2124, 0x2126, 0x2128, 0x214e, 0x2d27, 0x2d2d, 
                 0x2d6f, 0xa8fb, 0xfb3e, 0xff3f, 0x101fd, 0x102e0, 0x10808, 0x1083c, 
                 0x10a3f, 0x10f27, 0x11176, 0x111dc, 0x1123e, 0x11288, 0x11350, 0x11357, 
                 0x1145e, 0x114c7, 0x11644, 0x118ff, 0x11a47, 0x11a9d, 0x11d3a, 0x1d4a2, 
                 0x1d4bb, 0x1d546, 0x1da75, 0x1da84, 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 
                 0x1ee42, 0x1ee47, 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 
                 0x1ee5d, 0x1ee5f, 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x02c1}, {0x02c6, 0x02d1}, 
                 {0x02e0, 0x02e4}, {0x0300, 0x0374}, {0x0376, 0x0377}, {0x037a, 0x037d}, 
                 {0x0386, 0x038a}, {0x038e, 0x03a1}, {0x03a3, 0x03f5}, {0x03f7, 0x0481}, 
                 {0x0483, 0x0487}, {0x048a, 0x052f}, {0x0531, 0x0556}, {0x0560, 0x0588}, 
                 {0x0591, 0x05bd}, {0x05c1, 0x05c2}, {0x05c4, 0x05c5}, {0x05d0, 0x05ea}, 
                 {0x05ef, 0x05f2}, {0x0610, 0x061a}, {0x0620, 0x0669}, {0x066e, 0x06d3}, 
                 {0x06d5, 0x06dc}, {0x06df, 0x06e8}, {0x06ea, 0x06fc}, {0x0710, 0x074a}, 
                 {0x074d, 0x07b1}, {0x07c0, 0x07f5}, {0x0800, 0x082d}, {0x0840, 0x085b}, 
                 {0x0860, 0x086a}, {0x08a0, 0x08b4}, {0x08b6, 0x08bd}, {0x08d3, 0x08e1}, 
                 {0x08e3, 0x0963}, {0x0966, 0x096f}, {0x0971, 0x0983}, {0x0985, 0x098c}, 
                 {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, {0x09b6, 0x09b9}, 
                 {0x09bc, 0x09c4}, {0x09c7, 0x09c8}, {0x09cb, 0x09ce}, {0x09dc, 0x09dd}, 
                 {0x09df, 0x09e3}, {0x09e6, 0x09f1}, {0x0a01, 0x0a03}, {0x0a05, 0x0a0a}, 
                 {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, 
                 {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, 
                 {0x0a4b, 0x0a4d}, {0x0a59, 0x0a5c}, {0x0a66, 0x0a75}, {0x0a81, 0x0a83}, 
                 {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0}, 
                 {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0abc, 0x0ac5}, {0x0ac7, 0x0ac9}, 
                 {0x0acb, 0x0acd}, {0x0ae0, 0x0ae3}, {0x0ae6, 0x0aef}, {0x0af9, 0x0aff}, 
                 {0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, 
                 {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, {0x0b3c, 0x0b44}, 
                 {0x0b47, 0x0b48}, {0x0b4b, 0x0b4d}, {0x0b56, 0x0b57}, {0x0b5c, 0x0b5d}, 
                 {0x0b5f, 0x0b63}, {0x0b66, 0x0b6f}, {0x0b82, 0x0b83}, {0x0b85, 0x0b8a}, 
                 {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9e, 0x0b9f}, 
                 {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, {0x0bbe, 0x0bc2}, 
                 {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd}, {0x0be6, 0x0bef}, {0x0c00, 0x0c0c}, 
                 {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, {0x0c3d, 0x0c44}, 
                 {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56}, {0x0c58, 0x0c5a}, 
                 {0x0c60, 0x0c63}, {0x0c66, 0x0c6f}, {0x0c80, 0x0c83}, {0x0c85, 0x0c8c}, 
                 {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, 
                 {0x0cbc, 0x0cc4}, {0x0cc6, 0x0cc8}, {0x0cca, 0x0ccd}, {0x0cd5, 0x0cd6}, 
                 {0x0ce0, 0x0ce3}, {0x0ce6, 0x0cef}, {0x0cf1, 0x0cf2}, {0x0d00, 0x0d03}, 
                 {0x0d05, 0x0d0c}, {0x0d0e, 0x0d10}, {0x0d12, 0x0d44}, {0x0d46, 0x0d48}, 
                 {0x0d4a, 0x0d4e}, {0x0d54, 0x0d57}, {0x0d5f, 0x0d63}, {0x0d66, 0x0d6f}, 
                 {0x0d7a, 0x0d7f}, {0x0d82, 0x0d83}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, 
                 {0x0db3, 0x0dbb}, {0x0dc0, 0x0dc6}, {0x0dcf, 0x0dd4}, {0x0dd8, 0x0ddf}, 
                 {0x0de6, 0x0def}, {0x0df2, 0x0df3}, {0x0e01, 0x0e3a}, {0x0e40, 0x0e4e}, 
                 {0x0e50, 0x0e59}, {0x0e81, 0x0e82}, {0x0e87, 0x0e88}, {0x0e94, 0x0e97}, 
                 {0x0e99, 0x0e9f}, {0x0ea1, 0x0ea3}, {0x0eaa, 0x0eab}, {0x0ead, 0x0eb9}, 
                 {0x0ebb, 0x0ebd}, {0x0ec0, 0x0ec4}, {0x0ec8, 0x0ecd}, {0x0ed0, 0x0ed9}, 
                 {0x0edc, 0x0edf}, {0x0f18, 0x0f19}, {0x0f20, 0x0f29}, {0x0f3e, 0x0f47}, 
                 {0x0f49, 0x0f6c}, {0x0f71, 0x0f84}, {0x0f86, 0x0f97}, {0x0f99, 0x0fbc}, 
                 {0x1000, 0x1049}, {0x1050, 0x109d}, {0x10a0, 0x10c5}, {0x10d0, 0x10fa}, 
                 {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x125a, 0x125d}, 
                 {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, 
                 {0x12b8, 0x12be}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, 
                 {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371}, 
                 {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, 
                 {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, 
                 {0x1700, 0x170c}, {0x170e, 0x1714}, {0x1720, 0x1734}, {0x1740, 0x1753}, 
                 {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, 
                 {0x17dc, 0x17dd}, {0x17e0, 0x17e9}, {0x180b, 0x180d}, {0x1810, 0x1819}, 
                 {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, 
                 {0x1920, 0x192b}, {0x1930, 0x193b}, {0x1946, 0x196d}, {0x1970, 0x1974}, 
                 {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b}, 
                 {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, 
                 {0x1ab0, 0x1abd}, {0x1b00, 0x1b4b}, {0x1b50, 0x1b59}, {0x1b6b, 0x1b73}, 
                 {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, 
                 {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2}, 
                 {0x1cd4, 0x1cf9}, {0x1d00, 0x1df9}, {0x1dfb, 0x1f15}, {0x1f18, 0x1f1d}, 
                 {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, 
                 {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, 
                 {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, 
                 {0x1ff6, 0x1ffc}, {0x203f, 0x2040}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, 
                 {0x20e5, 0x20f0}, {0x210a, 0x2113}, {0x2118, 0x211d}, {0x212a, 0x2139}, 
                 {0x213c, 0x213f}, {0x2145, 0x2149}, {0x2160, 0x2188}, {0x2c00, 0x2c2e}, 
                 {0x2c30, 0x2c5e}, {0x2c60, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, 
                 {0x2d30, 0x2d67}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, 
                 {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, 
                 {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, 
                 {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096}, 
                 {0x3099, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, 
                 {0x3131, 0x318e}, {0x31a0, 0x31ba}, {0x31f0, 0x31ff}, {0x3400, 0x4db5}, 
                 {0x4e00, 0x9fef}, {0xa000, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, 
                 {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1}, 
                 {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7b9}, {0xa7f7, 0xa827}, 
                 {0xa840, 0xa873}, {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, 
                 {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c}, {0xa980, 0xa9c0}, 
                 {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, 
                 {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2}, {0xaadb, 0xaadd}, 
                 {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, 
                 {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, 
                 {0xab5c, 0xab65}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, 
                 {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, 
                 {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, 
                 {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, 
                 {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, 
                 {0xfdf0, 0xfdfb}, {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, 
                 {0xfe4d, 0xfe4f}, {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, {0xff10, 0xff19}, 
                 {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xffbe}, {0xffc2, 0xffc7}, 
                 {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, 
                 {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, 
                 {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, 
                 {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x1037a}, 
                 {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, 
                 {0x10400, 0x1049d}, {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, 
                 {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10600, 0x10736}, {0x10740, 0x10755}, 
                 {0x10760, 0x10767}, {0x10800, 0x10805}, {0x1080a, 0x10835}, {0x10837, 0x10838}, 
                 {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, 
                 {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, 
                 {0x109be, 0x109bf}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, 
                 {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a60, 0x10a7c}, 
                 {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, 
                 {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, 
                 {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, 
                 {0x10f00, 0x10f1c}, {0x10f30, 0x10f50}, {0x11000, 0x11046}, {0x11066, 0x1106f}, 
                 {0x1107f, 0x110ba}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, 
                 {0x11136, 0x1113f}, {0x11144, 0x11146}, {0x11150, 0x11173}, {0x11180, 0x111c4}, 
                 {0x111c9, 0x111cc}, {0x111d0, 0x111da}, {0x11200, 0x11211}, {0x11213, 0x11237}, 
                 {0x11280, 0x11286}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, 
                 {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303}, {0x11305, 0x1130c}, 
                 {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, 
                 {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d}, 
                 {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a}, 
                 {0x11450, 0x11459}, {0x11480, 0x114c5}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, 
                 {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640}, {0x11650, 0x11659}, 
                 {0x11680, 0x116b7}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, 
                 {0x11730, 0x11739}, {0x11800, 0x1183a}, {0x118a0, 0x118e9}, {0x11a00, 0x11a3e}, 
                 {0x11a50, 0x11a83}, {0x11a86, 0x11a99}, {0x11ac0, 0x11af8}, {0x11c00, 0x11c08}, 
                 {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, {0x11c72, 0x11c8f}, 
                 {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, 
                 {0x11d0b, 0x11d36}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, {0x11d50, 0x11d59}, 
                 {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, 
                 {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6}, {0x12000, 0x12399}, 
                 {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x13000, 0x1342e}, {0x14400, 0x14646}, 
                 {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16ad0, 0x16aed}, 
                 {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, 
                 {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f44}, 
                 {0x16f50, 0x16f7e}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x17000, 0x187f1}, 
                 {0x18800, 0x18af2}, {0x1b000, 0x1b11e}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, 
                 {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e}, 
                 {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, 
                 {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, 
                 {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, 
                 {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, 
                 {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, 
                 {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, 
                 {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, 
                 {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, 
                 {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c}, 
                 {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, 
                 {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e800, 0x1e8c4}, 
                 {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94a}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, 
                 {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, 
                 {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, 
                 {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, 
                 {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, 
                 {0x20000, 0x2a6d6}, {0x2a700, 0x2b734}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, 
                 {0x2ceb0, 0x2ebe0}, {0x2f800, 0x2fa1d}, {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass55()
{
    // Name = XID_Start, number of codePoints: 125637
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<UChar32>({0x00aa, 0x00b5, 0x00ba, 0x02ec, 0x02ee, 0x037f, 0x0386, 0x038c, 
                 0x0559, 0x06d5, 0x06ff, 0x0710, 0x07b1, 0x07fa, 0x081a, 0x0824, 
                 0x0828, 0x093d, 0x0950, 0x09b2, 0x09bd, 0x09ce, 0x09fc, 0x0a5e, 
                 0x0abd, 0x0ad0, 0x0af9, 0x0b3d, 0x0b71, 0x0b83, 0x0b9c, 0x0bd0, 
                 0x0c3d, 0x0c80, 0x0cbd, 0x0cde, 0x0d3d, 0x0d4e, 0x0dbd, 0x0e32, 
                 0x0e84, 0x0e8a, 0x0e8d, 0x0ea5, 0x0ea7, 0x0eb2, 0x0ebd, 0x0ec6, 
                 0x0f00, 0x103f, 0x1061, 0x108e, 0x10c7, 0x10cd, 0x1258, 0x12c0, 
                 0x17d7, 0x17dc, 0x18aa, 0x1aa7, 0x1f59, 0x1f5b, 0x1f5d, 0x1fbe, 
                 0x2071, 0x207f, 0x2102, 0x2107, 0x2115, 0x2124, 0x2126, 0x2128, 
                 0x214e, 0x2d27, 0x2d2d, 0x2d6f, 0xa8fb, 0xa9cf, 0xaa7a, 0xaab1, 
                 0xaac0, 0xaac2, 0xfb1d, 0xfb3e, 0xfe71, 0xfe73, 0xfe77, 0xfe79, 
                 0xfe7b, 0xfe7d, 0x10808, 0x1083c, 0x10a00, 0x10f27, 0x11144, 0x11176, 
                 0x111da, 0x111dc, 0x11288, 0x1133d, 0x11350, 0x114c7, 0x11644, 0x118ff, 
                 0x11a00, 0x11a3a, 0x11a50, 0x11a9d, 0x11c40, 0x11d46, 0x11d98, 0x16f50, 
                 0x1d4a2, 0x1d4bb, 0x1d546, 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 
                 0x1ee47, 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 
                 0x1ee5f, 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x02c1}, {0x02c6, 0x02d1}, 
                 {0x02e0, 0x02e4}, {0x0370, 0x0374}, {0x0376, 0x0377}, {0x037b, 0x037d}, 
                 {0x0388, 0x038a}, {0x038e, 0x03a1}, {0x03a3, 0x03f5}, {0x03f7, 0x0481}, 
                 {0x048a, 0x052f}, {0x0531, 0x0556}, {0x0560, 0x0588}, {0x05d0, 0x05ea}, 
                 {0x05ef, 0x05f2}, {0x0620, 0x064a}, {0x066e, 0x066f}, {0x0671, 0x06d3}, 
                 {0x06e5, 0x06e6}, {0x06ee, 0x06ef}, {0x06fa, 0x06fc}, {0x0712, 0x072f}, 
                 {0x074d, 0x07a5}, {0x07ca, 0x07ea}, {0x07f4, 0x07f5}, {0x0800, 0x0815}, 
                 {0x0840, 0x0858}, {0x0860, 0x086a}, {0x08a0, 0x08b4}, {0x08b6, 0x08bd}, 
                 {0x0904, 0x0939}, {0x0958, 0x0961}, {0x0971, 0x0980}, {0x0985, 0x098c}, 
                 {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, {0x09b6, 0x09b9}, 
                 {0x09dc, 0x09dd}, {0x09df, 0x09e1}, {0x09f0, 0x09f1}, {0x0a05, 0x0a0a}, 
                 {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, 
                 {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a59, 0x0a5c}, {0x0a72, 0x0a74}, 
                 {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0}, 
                 {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0ae0, 0x0ae1}, {0x0b05, 0x0b0c}, 
                 {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, 
                 {0x0b35, 0x0b39}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b61}, {0x0b85, 0x0b8a}, 
                 {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9e, 0x0b9f}, 
                 {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, {0x0c05, 0x0c0c}, 
                 {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, {0x0c58, 0x0c5a}, 
                 {0x0c60, 0x0c61}, {0x0c85, 0x0c8c}, {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, 
                 {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0ce0, 0x0ce1}, {0x0cf1, 0x0cf2}, 
                 {0x0d05, 0x0d0c}, {0x0d0e, 0x0d10}, {0x0d12, 0x0d3a}, {0x0d54, 0x0d56}, 
                 {0x0d5f, 0x0d61}, {0x0d7a, 0x0d7f}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, 
                 {0x0db3, 0x0dbb}, {0x0dc0, 0x0dc6}, {0x0e01, 0x0e30}, {0x0e40, 0x0e46}, 
                 {0x0e81, 0x0e82}, {0x0e87, 0x0e88}, {0x0e94, 0x0e97}, {0x0e99, 0x0e9f}, 
                 {0x0ea1, 0x0ea3}, {0x0eaa, 0x0eab}, {0x0ead, 0x0eb0}, {0x0ec0, 0x0ec4}, 
                 {0x0edc, 0x0edf}, {0x0f40, 0x0f47}, {0x0f49, 0x0f6c}, {0x0f88, 0x0f8c}, 
                 {0x1000, 0x102a}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1065, 0x1066}, 
                 {0x106e, 0x1070}, {0x1075, 0x1081}, {0x10a0, 0x10c5}, {0x10d0, 0x10fa}, 
                 {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x125a, 0x125d}, 
                 {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, 
                 {0x12b8, 0x12be}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, 
                 {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, 
                 {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, 
                 {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x170c}, {0x170e, 0x1711}, 
                 {0x1720, 0x1731}, {0x1740, 0x1751}, {0x1760, 0x176c}, {0x176e, 0x1770}, 
                 {0x1780, 0x17b3}, {0x1820, 0x1878}, {0x1880, 0x18a8}, {0x18b0, 0x18f5}, 
                 {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, 
                 {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54}, {0x1b05, 0x1b33}, 
                 {0x1b45, 0x1b4b}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, 
                 {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f}, {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, 
                 {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf1}, 
                 {0x1cf5, 0x1cf6}, {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, 
                 {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, 
                 {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, 
                 {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, 
                 {0x1ff6, 0x1ffc}, {0x2090, 0x209c}, {0x210a, 0x2113}, {0x2118, 0x211d}, 
                 {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149}, {0x2160, 0x2188}, 
                 {0x2c00, 0x2c2e}, {0x2c30, 0x2c5e}, {0x2c60, 0x2ce4}, {0x2ceb, 0x2cee}, 
                 {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d30, 0x2d67}, {0x2d80, 0x2d96}, 
                 {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, 
                 {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, 
                 {0x3005, 0x3007}, {0x3021, 0x3029}, {0x3031, 0x3035}, {0x3038, 0x303c}, 
                 {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, 
                 {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31ba}, {0x31f0, 0x31ff}, 
                 {0x3400, 0x4db5}, {0x4e00, 0x9fef}, {0xa000, 0xa48c}, {0xa4d0, 0xa4fd}, 
                 {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e}, 
                 {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, 
                 {0xa78b, 0xa7b9}, {0xa7f7, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, 
                 {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, 
                 {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, 
                 {0xa984, 0xa9b2}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef}, {0xa9fa, 0xa9fe}, 
                 {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, 
                 {0xaa7e, 0xaaaf}, {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaadb, 0xaadd}, 
                 {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06}, {0xab09, 0xab0e}, 
                 {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, 
                 {0xab5c, 0xab65}, {0xab70, 0xabe2}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, 
                 {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, 
                 {0xfb13, 0xfb17}, {0xfb1f, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, 
                 {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, 
                 {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, 
                 {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, 
                 {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, 
                 {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, 
                 {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, 
                 {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, 
                 {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, 
                 {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, 
                 {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10600, 0x10736}, 
                 {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10800, 0x10805}, {0x1080a, 0x10835}, 
                 {0x10837, 0x10838}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, 
                 {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, 
                 {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, 
                 {0x10a19, 0x10a35}, {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, 
                 {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, 
                 {0x10b80, 0x10b91}, {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, 
                 {0x10d00, 0x10d23}, {0x10f00, 0x10f1c}, {0x10f30, 0x10f45}, {0x11003, 0x11037}, 
                 {0x11083, 0x110af}, {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11150, 0x11172}, 
                 {0x11183, 0x111b2}, {0x111c1, 0x111c4}, {0x11200, 0x11211}, {0x11213, 0x1122b}, 
                 {0x11280, 0x11286}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, 
                 {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, 
                 {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1135d, 0x11361}, 
                 {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x11480, 0x114af}, {0x114c4, 0x114c5}, 
                 {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11680, 0x116aa}, 
                 {0x11700, 0x1171a}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x11a0b, 0x11a32}, 
                 {0x11a5c, 0x11a83}, {0x11a86, 0x11a89}, {0x11ac0, 0x11af8}, {0x11c00, 0x11c08}, 
                 {0x11c0a, 0x11c2e}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, 
                 {0x11d0b, 0x11d30}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d89}, 
                 {0x11ee0, 0x11ef2}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, 
                 {0x13000, 0x1342e}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, 
                 {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, 
                 {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f44}, {0x16f93, 0x16f9f}, 
                 {0x16fe0, 0x16fe1}, {0x17000, 0x187f1}, {0x18800, 0x18af2}, {0x1b000, 0x1b11e}, 
                 {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, 
                 {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, 
                 {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, 
                 {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, 
                 {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, 
                 {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, 
                 {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, 
                 {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, 
                 {0x1e800, 0x1e8c4}, {0x1e900, 0x1e943}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, 
                 {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, 
                 {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, 
                 {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, 
                 {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6d6}, 
                 {0x2a700, 0x2b734}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, 
                 {0x2f800, 0x2fa1d}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass56()
{
    // Name = XID_Continue, number of codePoints: 128491
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x5f}),
        std::initializer_list<CharacterRange>({{0x30, 0x39}, {0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<UChar32>({0x00aa, 0x00b5, 0x00b7, 0x00ba, 0x02ec, 0x02ee, 0x037f, 0x038c, 
                 0x0559, 0x05bf, 0x05c7, 0x06ff, 0x07fa, 0x07fd, 0x09b2, 0x09d7, 
                 0x09fc, 0x09fe, 0x0a3c, 0x0a51, 0x0a5e, 0x0ad0, 0x0b71, 0x0b9c, 
                 0x0bd0, 0x0bd7, 0x0cde, 0x0dbd, 0x0dca, 0x0dd6, 0x0e84, 0x0e8a, 
                 0x0e8d, 0x0ea5, 0x0ea7, 0x0ec6, 0x0f00, 0x0f35, 0x0f37, 0x0f39, 
                 0x0fc6, 0x10c7, 0x10cd, 0x1258, 0x12c0, 0x17d7, 0x1aa7, 0x1f59, 
                 0x1f5b, 0x1f5d, 0x1fbe, 0x2054, 0x2071, 0x207f, 0x20e1, 0x2102, 
                 0x2107, 0x2115, 0x2124, 0x2126, 0x2128, 0x214e, 0x2d27, 0x2d2d, 
                 0x2d6f, 0xa8fb, 0xfb3e, 0xfe71, 0xfe73, 0xfe77, 0xfe79, 0xfe7b, 
                 0xfe7d, 0xff3f, 0x101fd, 0x102e0, 0x10808, 0x1083c, 0x10a3f, 0x10f27, 
                 0x11176, 0x111dc, 0x1123e, 0x11288, 0x11350, 0x11357, 0x1145e, 0x114c7, 
                 0x11644, 0x118ff, 0x11a47, 0x11a9d, 0x11d3a, 0x1d4a2, 0x1d4bb, 0x1d546, 
                 0x1da75, 0x1da84, 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 0x1ee47, 
                 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 0x1ee5f, 
                 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x02c1}, {0x02c6, 0x02d1}, 
                 {0x02e0, 0x02e4}, {0x0300, 0x0374}, {0x0376, 0x0377}, {0x037b, 0x037d}, 
                 {0x0386, 0x038a}, {0x038e, 0x03a1}, {0x03a3, 0x03f5}, {0x03f7, 0x0481}, 
                 {0x0483, 0x0487}, {0x048a, 0x052f}, {0x0531, 0x0556}, {0x0560, 0x0588}, 
                 {0x0591, 0x05bd}, {0x05c1, 0x05c2}, {0x05c4, 0x05c5}, {0x05d0, 0x05ea}, 
                 {0x05ef, 0x05f2}, {0x0610, 0x061a}, {0x0620, 0x0669}, {0x066e, 0x06d3}, 
                 {0x06d5, 0x06dc}, {0x06df, 0x06e8}, {0x06ea, 0x06fc}, {0x0710, 0x074a}, 
                 {0x074d, 0x07b1}, {0x07c0, 0x07f5}, {0x0800, 0x082d}, {0x0840, 0x085b}, 
                 {0x0860, 0x086a}, {0x08a0, 0x08b4}, {0x08b6, 0x08bd}, {0x08d3, 0x08e1}, 
                 {0x08e3, 0x0963}, {0x0966, 0x096f}, {0x0971, 0x0983}, {0x0985, 0x098c}, 
                 {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, {0x09b6, 0x09b9}, 
                 {0x09bc, 0x09c4}, {0x09c7, 0x09c8}, {0x09cb, 0x09ce}, {0x09dc, 0x09dd}, 
                 {0x09df, 0x09e3}, {0x09e6, 0x09f1}, {0x0a01, 0x0a03}, {0x0a05, 0x0a0a}, 
                 {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, 
                 {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, 
                 {0x0a4b, 0x0a4d}, {0x0a59, 0x0a5c}, {0x0a66, 0x0a75}, {0x0a81, 0x0a83}, 
                 {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0}, 
                 {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0abc, 0x0ac5}, {0x0ac7, 0x0ac9}, 
                 {0x0acb, 0x0acd}, {0x0ae0, 0x0ae3}, {0x0ae6, 0x0aef}, {0x0af9, 0x0aff}, 
                 {0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, 
                 {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, {0x0b3c, 0x0b44}, 
                 {0x0b47, 0x0b48}, {0x0b4b, 0x0b4d}, {0x0b56, 0x0b57}, {0x0b5c, 0x0b5d}, 
                 {0x0b5f, 0x0b63}, {0x0b66, 0x0b6f}, {0x0b82, 0x0b83}, {0x0b85, 0x0b8a}, 
                 {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9e, 0x0b9f}, 
                 {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, {0x0bbe, 0x0bc2}, 
                 {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd}, {0x0be6, 0x0bef}, {0x0c00, 0x0c0c}, 
                 {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, {0x0c3d, 0x0c44}, 
                 {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56}, {0x0c58, 0x0c5a}, 
                 {0x0c60, 0x0c63}, {0x0c66, 0x0c6f}, {0x0c80, 0x0c83}, {0x0c85, 0x0c8c}, 
                 {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, 
                 {0x0cbc, 0x0cc4}, {0x0cc6, 0x0cc8}, {0x0cca, 0x0ccd}, {0x0cd5, 0x0cd6}, 
                 {0x0ce0, 0x0ce3}, {0x0ce6, 0x0cef}, {0x0cf1, 0x0cf2}, {0x0d00, 0x0d03}, 
                 {0x0d05, 0x0d0c}, {0x0d0e, 0x0d10}, {0x0d12, 0x0d44}, {0x0d46, 0x0d48}, 
                 {0x0d4a, 0x0d4e}, {0x0d54, 0x0d57}, {0x0d5f, 0x0d63}, {0x0d66, 0x0d6f}, 
                 {0x0d7a, 0x0d7f}, {0x0d82, 0x0d83}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, 
                 {0x0db3, 0x0dbb}, {0x0dc0, 0x0dc6}, {0x0dcf, 0x0dd4}, {0x0dd8, 0x0ddf}, 
                 {0x0de6, 0x0def}, {0x0df2, 0x0df3}, {0x0e01, 0x0e3a}, {0x0e40, 0x0e4e}, 
                 {0x0e50, 0x0e59}, {0x0e81, 0x0e82}, {0x0e87, 0x0e88}, {0x0e94, 0x0e97}, 
                 {0x0e99, 0x0e9f}, {0x0ea1, 0x0ea3}, {0x0eaa, 0x0eab}, {0x0ead, 0x0eb9}, 
                 {0x0ebb, 0x0ebd}, {0x0ec0, 0x0ec4}, {0x0ec8, 0x0ecd}, {0x0ed0, 0x0ed9}, 
                 {0x0edc, 0x0edf}, {0x0f18, 0x0f19}, {0x0f20, 0x0f29}, {0x0f3e, 0x0f47}, 
                 {0x0f49, 0x0f6c}, {0x0f71, 0x0f84}, {0x0f86, 0x0f97}, {0x0f99, 0x0fbc}, 
                 {0x1000, 0x1049}, {0x1050, 0x109d}, {0x10a0, 0x10c5}, {0x10d0, 0x10fa}, 
                 {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x125a, 0x125d}, 
                 {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, 
                 {0x12b8, 0x12be}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, 
                 {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371}, 
                 {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, 
                 {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, 
                 {0x1700, 0x170c}, {0x170e, 0x1714}, {0x1720, 0x1734}, {0x1740, 0x1753}, 
                 {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, 
                 {0x17dc, 0x17dd}, {0x17e0, 0x17e9}, {0x180b, 0x180d}, {0x1810, 0x1819}, 
                 {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, 
                 {0x1920, 0x192b}, {0x1930, 0x193b}, {0x1946, 0x196d}, {0x1970, 0x1974}, 
                 {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b}, 
                 {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, 
                 {0x1ab0, 0x1abd}, {0x1b00, 0x1b4b}, {0x1b50, 0x1b59}, {0x1b6b, 0x1b73}, 
                 {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, 
                 {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2}, 
                 {0x1cd4, 0x1cf9}, {0x1d00, 0x1df9}, {0x1dfb, 0x1f15}, {0x1f18, 0x1f1d}, 
                 {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, 
                 {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, 
                 {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, 
                 {0x1ff6, 0x1ffc}, {0x203f, 0x2040}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, 
                 {0x20e5, 0x20f0}, {0x210a, 0x2113}, {0x2118, 0x211d}, {0x212a, 0x2139}, 
                 {0x213c, 0x213f}, {0x2145, 0x2149}, {0x2160, 0x2188}, {0x2c00, 0x2c2e}, 
                 {0x2c30, 0x2c5e}, {0x2c60, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, 
                 {0x2d30, 0x2d67}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, 
                 {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, 
                 {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, 
                 {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096}, 
                 {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, 
                 {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31ba}, {0x31f0, 0x31ff}, 
                 {0x3400, 0x4db5}, {0x4e00, 0x9fef}, {0xa000, 0xa48c}, {0xa4d0, 0xa4fd}, 
                 {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, 
                 {0xa67f, 0xa6f1}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7b9}, 
                 {0xa7f7, 0xa827}, {0xa840, 0xa873}, {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, 
                 {0xa8e0, 0xa8f7}, {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c}, 
                 {0xa980, 0xa9c0}, {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, 
                 {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2}, 
                 {0xaadb, 0xaadd}, {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, 
                 {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, 
                 {0xab30, 0xab5a}, {0xab5c, 0xab65}, {0xab70, 0xabea}, {0xabec, 0xabed}, 
                 {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, 
                 {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, 
                 {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, 
                 {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, 
                 {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe00, 0xfe0f}, 
                 {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe7f, 0xfefc}, 
                 {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xffbe}, 
                 {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, 
                 {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, 
                 {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, 
                 {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, 
                 {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, 
                 {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, 
                 {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10600, 0x10736}, 
                 {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10800, 0x10805}, {0x1080a, 0x10835}, 
                 {0x10837, 0x10838}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, 
                 {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, 
                 {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, 
                 {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, 
                 {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, 
                 {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, 
                 {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, 
                 {0x10d30, 0x10d39}, {0x10f00, 0x10f1c}, {0x10f30, 0x10f50}, {0x11000, 0x11046}, 
                 {0x11066, 0x1106f}, {0x1107f, 0x110ba}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, 
                 {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11146}, {0x11150, 0x11173}, 
                 {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111d0, 0x111da}, {0x11200, 0x11211}, 
                 {0x11213, 0x11237}, {0x11280, 0x11286}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, 
                 {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303}, 
                 {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, 
                 {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, 
                 {0x1134b, 0x1134d}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, 
                 {0x11400, 0x1144a}, {0x11450, 0x11459}, {0x11480, 0x114c5}, {0x114d0, 0x114d9}, 
                 {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640}, 
                 {0x11650, 0x11659}, {0x11680, 0x116b7}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, 
                 {0x1171d, 0x1172b}, {0x11730, 0x11739}, {0x11800, 0x1183a}, {0x118a0, 0x118e9}, 
                 {0x11a00, 0x11a3e}, {0x11a50, 0x11a83}, {0x11a86, 0x11a99}, {0x11ac0, 0x11af8}, 
                 {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, 
                 {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, 
                 {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, 
                 {0x11d50, 0x11d59}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, 
                 {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6}, 
                 {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x13000, 0x1342e}, 
                 {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, 
                 {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, 
                 {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, 
                 {0x16f00, 0x16f44}, {0x16f50, 0x16f7e}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, 
                 {0x17000, 0x187f1}, {0x18800, 0x18af2}, {0x1b000, 0x1b11e}, {0x1b170, 0x1b2fb}, 
                 {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, 
                 {0x1bc9d, 0x1bc9e}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, 
                 {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1d400, 0x1d454}, 
                 {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, 
                 {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, 
                 {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, 
                 {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, 
                 {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, 
                 {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, 
                 {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36}, 
                 {0x1da3b, 0x1da6c}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1e000, 0x1e006}, 
                 {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, 
                 {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94a}, {0x1e950, 0x1e959}, 
                 {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, 
                 {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, 
                 {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, 
                 {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, 
                 {0x1eeab, 0x1eebb}, {0x20000, 0x2a6d6}, {0x2a700, 0x2b734}, {0x2b740, 0x2b81d}, 
                 {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2f800, 0x2fa1d}, {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass57()
{
    // Name = Default_Ignorable_Code_Point, number of codePoints: 4173
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x00ad, 0x034f, 0x061c, 0x3164, 0xfeff, 0xffa0}),
        std::initializer_list<CharacterRange>({{0x115f, 0x1160}, {0x17b4, 0x17b5}, {0x180b, 0x180e}, {0x200b, 0x200f}, 
                 {0x202a, 0x202e}, {0x2060, 0x206f}, {0xfe00, 0xfe0f}, {0xfff0, 0xfff8}, 
                 {0x1bca0, 0x1bca3}, {0x1d173, 0x1d17a}, {0xe0000, 0xe0fff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass58()
{
    // Name = Grapheme_Extend, number of codePoints: 1943
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x05bf, 0x05c7, 0x0670, 0x0711, 0x07fd, 0x093a, 0x093c, 0x094d, 
                 0x0981, 0x09bc, 0x09be, 0x09cd, 0x09d7, 0x09fe, 0x0a3c, 0x0a51, 
                 0x0a75, 0x0abc, 0x0acd, 0x0b01, 0x0b3c, 0x0b4d, 0x0b82, 0x0bbe, 
                 0x0bc0, 0x0bcd, 0x0bd7, 0x0c00, 0x0c04, 0x0c81, 0x0cbc, 0x0cbf, 
                 0x0cc2, 0x0cc6, 0x0d3e, 0x0d4d, 0x0d57, 0x0dca, 0x0dcf, 0x0dd6, 
                 0x0ddf, 0x0e31, 0x0eb1, 0x0f35, 0x0f37, 0x0f39, 0x0fc6, 0x1082, 
                 0x108d, 0x109d, 0x17c6, 0x17dd, 0x18a9, 0x1932, 0x1a1b, 0x1a56, 
                 0x1a60, 0x1a62, 0x1a7f, 0x1b34, 0x1b3c, 0x1b42, 0x1be6, 0x1bed, 
                 0x1ced, 0x1cf4, 0x200c, 0x2d7f, 0xa802, 0xa806, 0xa80b, 0xa8ff, 
                 0xa9b3, 0xa9bc, 0xa9e5, 0xaa43, 0xaa4c, 0xaa7c, 0xaab0, 0xaac1, 
                 0xaaf6, 0xabe5, 0xabe8, 0xabed, 0xfb1e, 0x101fd, 0x102e0, 0x10a3f, 
                 0x11001, 0x11173, 0x11234, 0x1123e, 0x112df, 0x1133e, 0x11340, 0x11357, 
                 0x11446, 0x1145e, 0x114b0, 0x114ba, 0x114bd, 0x115af, 0x1163d, 0x116ab, 
                 0x116ad, 0x116b7, 0x11a47, 0x11c3f, 0x11d3a, 0x11d47, 0x11d95, 0x11d97, 
                 0x1d165, 0x1da75, 0x1da84}),
        std::initializer_list<CharacterRange>({{0x0300, 0x036f}, {0x0483, 0x0489}, {0x0591, 0x05bd}, {0x05c1, 0x05c2}, 
                 {0x05c4, 0x05c5}, {0x0610, 0x061a}, {0x064b, 0x065f}, {0x06d6, 0x06dc}, 
                 {0x06df, 0x06e4}, {0x06e7, 0x06e8}, {0x06ea, 0x06ed}, {0x0730, 0x074a}, 
                 {0x07a6, 0x07b0}, {0x07eb, 0x07f3}, {0x0816, 0x0819}, {0x081b, 0x0823}, 
                 {0x0825, 0x0827}, {0x0829, 0x082d}, {0x0859, 0x085b}, {0x08d3, 0x08e1}, 
                 {0x08e3, 0x0902}, {0x0941, 0x0948}, {0x0951, 0x0957}, {0x0962, 0x0963}, 
                 {0x09c1, 0x09c4}, {0x09e2, 0x09e3}, {0x0a01, 0x0a02}, {0x0a41, 0x0a42}, 
                 {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a70, 0x0a71}, {0x0a81, 0x0a82}, 
                 {0x0ac1, 0x0ac5}, {0x0ac7, 0x0ac8}, {0x0ae2, 0x0ae3}, {0x0afa, 0x0aff}, 
                 {0x0b3e, 0x0b3f}, {0x0b41, 0x0b44}, {0x0b56, 0x0b57}, {0x0b62, 0x0b63}, 
                 {0x0c3e, 0x0c40}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56}, 
                 {0x0c62, 0x0c63}, {0x0ccc, 0x0ccd}, {0x0cd5, 0x0cd6}, {0x0ce2, 0x0ce3}, 
                 {0x0d00, 0x0d01}, {0x0d3b, 0x0d3c}, {0x0d41, 0x0d44}, {0x0d62, 0x0d63}, 
                 {0x0dd2, 0x0dd4}, {0x0e34, 0x0e3a}, {0x0e47, 0x0e4e}, {0x0eb4, 0x0eb9}, 
                 {0x0ebb, 0x0ebc}, {0x0ec8, 0x0ecd}, {0x0f18, 0x0f19}, {0x0f71, 0x0f7e}, 
                 {0x0f80, 0x0f84}, {0x0f86, 0x0f87}, {0x0f8d, 0x0f97}, {0x0f99, 0x0fbc}, 
                 {0x102d, 0x1030}, {0x1032, 0x1037}, {0x1039, 0x103a}, {0x103d, 0x103e}, 
                 {0x1058, 0x1059}, {0x105e, 0x1060}, {0x1071, 0x1074}, {0x1085, 0x1086}, 
                 {0x135d, 0x135f}, {0x1712, 0x1714}, {0x1732, 0x1734}, {0x1752, 0x1753}, 
                 {0x1772, 0x1773}, {0x17b4, 0x17b5}, {0x17b7, 0x17bd}, {0x17c9, 0x17d3}, 
                 {0x180b, 0x180d}, {0x1885, 0x1886}, {0x1920, 0x1922}, {0x1927, 0x1928}, 
                 {0x1939, 0x193b}, {0x1a17, 0x1a18}, {0x1a58, 0x1a5e}, {0x1a65, 0x1a6c}, 
                 {0x1a73, 0x1a7c}, {0x1ab0, 0x1abe}, {0x1b00, 0x1b03}, {0x1b36, 0x1b3a}, 
                 {0x1b6b, 0x1b73}, {0x1b80, 0x1b81}, {0x1ba2, 0x1ba5}, {0x1ba8, 0x1ba9}, 
                 {0x1bab, 0x1bad}, {0x1be8, 0x1be9}, {0x1bef, 0x1bf1}, {0x1c2c, 0x1c33}, 
                 {0x1c36, 0x1c37}, {0x1cd0, 0x1cd2}, {0x1cd4, 0x1ce0}, {0x1ce2, 0x1ce8}, 
                 {0x1cf8, 0x1cf9}, {0x1dc0, 0x1df9}, {0x1dfb, 0x1dff}, {0x20d0, 0x20f0}, 
                 {0x2cef, 0x2cf1}, {0x2de0, 0x2dff}, {0x302a, 0x302f}, {0x3099, 0x309a}, 
                 {0xa66f, 0xa672}, {0xa674, 0xa67d}, {0xa69e, 0xa69f}, {0xa6f0, 0xa6f1}, 
                 {0xa825, 0xa826}, {0xa8c4, 0xa8c5}, {0xa8e0, 0xa8f1}, {0xa926, 0xa92d}, 
                 {0xa947, 0xa951}, {0xa980, 0xa982}, {0xa9b6, 0xa9b9}, {0xaa29, 0xaa2e}, 
                 {0xaa31, 0xaa32}, {0xaa35, 0xaa36}, {0xaab2, 0xaab4}, {0xaab7, 0xaab8}, 
                 {0xaabe, 0xaabf}, {0xaaec, 0xaaed}, {0xfe00, 0xfe0f}, {0xfe20, 0xfe2f}, 
                 {0xff9e, 0xff9f}, {0x10376, 0x1037a}, {0x10a01, 0x10a03}, {0x10a05, 0x10a06}, 
                 {0x10a0c, 0x10a0f}, {0x10a38, 0x10a3a}, {0x10ae5, 0x10ae6}, {0x10d24, 0x10d27}, 
                 {0x10f46, 0x10f50}, {0x11038, 0x11046}, {0x1107f, 0x11081}, {0x110b3, 0x110b6}, 
                 {0x110b9, 0x110ba}, {0x11100, 0x11102}, {0x11127, 0x1112b}, {0x1112d, 0x11134}, 
                 {0x11180, 0x11181}, {0x111b6, 0x111be}, {0x111c9, 0x111cc}, {0x1122f, 0x11231}, 
                 {0x11236, 0x11237}, {0x112e3, 0x112ea}, {0x11300, 0x11301}, {0x1133b, 0x1133c}, 
                 {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11438, 0x1143f}, {0x11442, 0x11444}, 
                 {0x114b3, 0x114b8}, {0x114bf, 0x114c0}, {0x114c2, 0x114c3}, {0x115b2, 0x115b5}, 
                 {0x115bc, 0x115bd}, {0x115bf, 0x115c0}, {0x115dc, 0x115dd}, {0x11633, 0x1163a}, 
                 {0x1163f, 0x11640}, {0x116b0, 0x116b5}, {0x1171d, 0x1171f}, {0x11722, 0x11725}, 
                 {0x11727, 0x1172b}, {0x1182f, 0x11837}, {0x11839, 0x1183a}, {0x11a01, 0x11a0a}, 
                 {0x11a33, 0x11a38}, {0x11a3b, 0x11a3e}, {0x11a51, 0x11a56}, {0x11a59, 0x11a5b}, 
                 {0x11a8a, 0x11a96}, {0x11a98, 0x11a99}, {0x11c30, 0x11c36}, {0x11c38, 0x11c3d}, 
                 {0x11c92, 0x11ca7}, {0x11caa, 0x11cb0}, {0x11cb2, 0x11cb3}, {0x11cb5, 0x11cb6}, 
                 {0x11d31, 0x11d36}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d45}, {0x11d90, 0x11d91}, 
                 {0x11ef3, 0x11ef4}, {0x16af0, 0x16af4}, {0x16b30, 0x16b36}, {0x16f8f, 0x16f92}, 
                 {0x1bc9d, 0x1bc9e}, {0x1d167, 0x1d169}, {0x1d16e, 0x1d172}, {0x1d17b, 0x1d182}, 
                 {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1da00, 0x1da36}, 
                 {0x1da3b, 0x1da6c}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1e000, 0x1e006}, 
                 {0x1e008, 0x1e018}, {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, 
                 {0x1e8d0, 0x1e8d6}, {0x1e944, 0x1e94a}, {0xe0020, 0xe007f}, {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass59()
{
    // Name = Grapheme_Base, number of codePoints: 135374
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x20, 0x7e}}),
        std::initializer_list<UChar32>({0x038c, 0x05be, 0x05c0, 0x05c3, 0x05c6, 0x061b, 0x06de, 0x06e9, 
                 0x0710, 0x07b1, 0x081a, 0x0824, 0x0828, 0x085e, 0x093b, 0x09b2, 
                 0x09bd, 0x09ce, 0x0a03, 0x0a5e, 0x0a76, 0x0a83, 0x0ac9, 0x0ad0, 
                 0x0af9, 0x0b3d, 0x0b40, 0x0b83, 0x0b9c, 0x0bbf, 0x0bd0, 0x0c3d, 
                 0x0cde, 0x0d3d, 0x0dbd, 0x0e84, 0x0e8a, 0x0e8d, 0x0ea5, 0x0ea7, 
                 0x0ebd, 0x0ec6, 0x0f36, 0x0f38, 0x0f7f, 0x0f85, 0x1031, 0x1038, 
                 0x10c7, 0x10cd, 0x1258, 0x12c0, 0x17b6, 0x18aa, 0x1940, 0x1a57, 
                 0x1a61, 0x1b35, 0x1b3b, 0x1baa, 0x1be7, 0x1bee, 0x1cd3, 0x1ce1, 
                 0x1f59, 0x1f5b, 0x1f5d, 0x2d27, 0x2d2d, 0xa673, 0xaa4d, 0xaab1, 
                 0xaac0, 0xaac2, 0xfb1d, 0xfb3e, 0x101a0, 0x1056f, 0x10808, 0x1083c, 
                 0x1093f, 0x11000, 0x1112c, 0x111cd, 0x11235, 0x11288, 0x1133d, 0x1133f, 
                 0x11350, 0x11445, 0x1145b, 0x1145d, 0x114b9, 0x114be, 0x114c1, 0x115be, 
                 0x1163e, 0x116ac, 0x116b6, 0x11726, 0x11838, 0x1183b, 0x118ff, 0x11a00, 
                 0x11a50, 0x11a97, 0x11c3e, 0x11ca9, 0x11cb1, 0x11cb4, 0x11d46, 0x11d96, 
                 0x11d98, 0x16af5, 0x1bc9c, 0x1bc9f, 0x1d166, 0x1d245, 0x1d4a2, 0x1d4bb, 
                 0x1d546, 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 0x1ee47, 0x1ee49, 
                 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 0x1ee5f, 0x1ee64, 
                 0x1ee7e, 0x1f97a}),
        std::initializer_list<CharacterRange>({{0x00a0, 0x00ac}, {0x00ae, 0x02ff}, {0x0370, 0x0377}, {0x037a, 0x037f}, 
                 {0x0384, 0x038a}, {0x038e, 0x03a1}, {0x03a3, 0x0482}, {0x048a, 0x052f}, 
                 {0x0531, 0x0556}, {0x0559, 0x058a}, {0x058d, 0x058f}, {0x05d0, 0x05ea}, 
                 {0x05ef, 0x05f4}, {0x0606, 0x060f}, {0x061e, 0x064a}, {0x0660, 0x066f}, 
                 {0x0671, 0x06d5}, {0x06e5, 0x06e6}, {0x06ee, 0x070d}, {0x0712, 0x072f}, 
                 {0x074d, 0x07a5}, {0x07c0, 0x07ea}, {0x07f4, 0x07fa}, {0x07fe, 0x0815}, 
                 {0x0830, 0x083e}, {0x0840, 0x0858}, {0x0860, 0x086a}, {0x08a0, 0x08b4}, 
                 {0x08b6, 0x08bd}, {0x0903, 0x0939}, {0x093d, 0x0940}, {0x0949, 0x094c}, 
                 {0x094e, 0x0950}, {0x0958, 0x0961}, {0x0964, 0x0980}, {0x0982, 0x0983}, 
                 {0x0985, 0x098c}, {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, 
                 {0x09b6, 0x09b9}, {0x09bf, 0x09c0}, {0x09c7, 0x09c8}, {0x09cb, 0x09cc}, 
                 {0x09dc, 0x09dd}, {0x09df, 0x09e1}, {0x09e6, 0x09fd}, {0x0a05, 0x0a0a}, 
                 {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, 
                 {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a3e, 0x0a40}, {0x0a59, 0x0a5c}, 
                 {0x0a66, 0x0a6f}, {0x0a72, 0x0a74}, {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, 
                 {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, 
                 {0x0abd, 0x0ac0}, {0x0acb, 0x0acc}, {0x0ae0, 0x0ae1}, {0x0ae6, 0x0af1}, 
                 {0x0b02, 0x0b03}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, 
                 {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, {0x0b47, 0x0b48}, 
                 {0x0b4b, 0x0b4c}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b61}, {0x0b66, 0x0b77}, 
                 {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, 
                 {0x0b9e, 0x0b9f}, {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, 
                 {0x0bc1, 0x0bc2}, {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcc}, {0x0be6, 0x0bfa}, 
                 {0x0c01, 0x0c03}, {0x0c05, 0x0c0c}, {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, 
                 {0x0c2a, 0x0c39}, {0x0c41, 0x0c44}, {0x0c58, 0x0c5a}, {0x0c60, 0x0c61}, 
                 {0x0c66, 0x0c6f}, {0x0c78, 0x0c80}, {0x0c82, 0x0c8c}, {0x0c8e, 0x0c90}, 
                 {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0cbd, 0x0cbe}, 
                 {0x0cc0, 0x0cc1}, {0x0cc3, 0x0cc4}, {0x0cc7, 0x0cc8}, {0x0cca, 0x0ccb}, 
                 {0x0ce0, 0x0ce1}, {0x0ce6, 0x0cef}, {0x0cf1, 0x0cf2}, {0x0d02, 0x0d03}, 
                 {0x0d05, 0x0d0c}, {0x0d0e, 0x0d10}, {0x0d12, 0x0d3a}, {0x0d3f, 0x0d40}, 
                 {0x0d46, 0x0d48}, {0x0d4a, 0x0d4c}, {0x0d4e, 0x0d4f}, {0x0d54, 0x0d56}, 
                 {0x0d58, 0x0d61}, {0x0d66, 0x0d7f}, {0x0d82, 0x0d83}, {0x0d85, 0x0d96}, 
                 {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, {0x0dc0, 0x0dc6}, {0x0dd0, 0x0dd1}, 
                 {0x0dd8, 0x0dde}, {0x0de6, 0x0def}, {0x0df2, 0x0df4}, {0x0e01, 0x0e30}, 
                 {0x0e32, 0x0e33}, {0x0e3f, 0x0e46}, {0x0e4f, 0x0e5b}, {0x0e81, 0x0e82}, 
                 {0x0e87, 0x0e88}, {0x0e94, 0x0e97}, {0x0e99, 0x0e9f}, {0x0ea1, 0x0ea3}, 
                 {0x0eaa, 0x0eab}, {0x0ead, 0x0eb0}, {0x0eb2, 0x0eb3}, {0x0ec0, 0x0ec4}, 
                 {0x0ed0, 0x0ed9}, {0x0edc, 0x0edf}, {0x0f00, 0x0f17}, {0x0f1a, 0x0f34}, 
                 {0x0f3a, 0x0f47}, {0x0f49, 0x0f6c}, {0x0f88, 0x0f8c}, {0x0fbe, 0x0fc5}, 
                 {0x0fc7, 0x0fcc}, {0x0fce, 0x0fda}, {0x1000, 0x102c}, {0x103b, 0x103c}, 
                 {0x103f, 0x1057}, {0x105a, 0x105d}, {0x1061, 0x1070}, {0x1075, 0x1081}, 
                 {0x1083, 0x1084}, {0x1087, 0x108c}, {0x108e, 0x109c}, {0x109e, 0x10c5}, 
                 {0x10d0, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x125a, 0x125d}, 
                 {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, 
                 {0x12b8, 0x12be}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, 
                 {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1360, 0x137c}, {0x1380, 0x1399}, 
                 {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1400, 0x169c}, {0x16a0, 0x16f8}, 
                 {0x1700, 0x170c}, {0x170e, 0x1711}, {0x1720, 0x1731}, {0x1735, 0x1736}, 
                 {0x1740, 0x1751}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, 
                 {0x17be, 0x17c5}, {0x17c7, 0x17c8}, {0x17d4, 0x17dc}, {0x17e0, 0x17e9}, 
                 {0x17f0, 0x17f9}, {0x1800, 0x180a}, {0x1810, 0x1819}, {0x1820, 0x1878}, 
                 {0x1880, 0x1884}, {0x1887, 0x18a8}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, 
                 {0x1923, 0x1926}, {0x1929, 0x192b}, {0x1930, 0x1931}, {0x1933, 0x1938}, 
                 {0x1944, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, 
                 {0x19d0, 0x19da}, {0x19de, 0x1a16}, {0x1a19, 0x1a1a}, {0x1a1e, 0x1a55}, 
                 {0x1a63, 0x1a64}, {0x1a6d, 0x1a72}, {0x1a80, 0x1a89}, {0x1a90, 0x1a99}, 
                 {0x1aa0, 0x1aad}, {0x1b04, 0x1b33}, {0x1b3d, 0x1b41}, {0x1b43, 0x1b4b}, 
                 {0x1b50, 0x1b6a}, {0x1b74, 0x1b7c}, {0x1b82, 0x1ba1}, {0x1ba6, 0x1ba7}, 
                 {0x1bae, 0x1be5}, {0x1bea, 0x1bec}, {0x1bf2, 0x1bf3}, {0x1bfc, 0x1c2b}, 
                 {0x1c34, 0x1c35}, {0x1c3b, 0x1c49}, {0x1c4d, 0x1c88}, {0x1c90, 0x1cba}, 
                 {0x1cbd, 0x1cc7}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf7}, 
                 {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, 
                 {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, 
                 {0x1fb6, 0x1fc4}, {0x1fc6, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fdd, 0x1fef}, 
                 {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffe}, {0x2000, 0x200a}, {0x2010, 0x2027}, 
                 {0x202f, 0x205f}, {0x2070, 0x2071}, {0x2074, 0x208e}, {0x2090, 0x209c}, 
                 {0x20a0, 0x20bf}, {0x2100, 0x218b}, {0x2190, 0x2426}, {0x2440, 0x244a}, 
                 {0x2460, 0x2b73}, {0x2b76, 0x2b95}, {0x2b98, 0x2bc8}, {0x2bca, 0x2bfe}, 
                 {0x2c00, 0x2c2e}, {0x2c30, 0x2c5e}, {0x2c60, 0x2cee}, {0x2cf2, 0x2cf3}, 
                 {0x2cf9, 0x2d25}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d70}, {0x2d80, 0x2d96}, 
                 {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, 
                 {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, 
                 {0x2e00, 0x2e4e}, {0x2e80, 0x2e99}, {0x2e9b, 0x2ef3}, {0x2f00, 0x2fd5}, 
                 {0x2ff0, 0x2ffb}, {0x3000, 0x3029}, {0x3030, 0x303f}, {0x3041, 0x3096}, 
                 {0x309b, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x3190, 0x31ba}, 
                 {0x31c0, 0x31e3}, {0x31f0, 0x321e}, {0x3220, 0x32fe}, {0x3300, 0x4db5}, 
                 {0x4dc0, 0x9fef}, {0xa000, 0xa48c}, {0xa490, 0xa4c6}, {0xa4d0, 0xa62b}, 
                 {0xa640, 0xa66e}, {0xa67e, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa6f2, 0xa6f7}, 
                 {0xa700, 0xa7b9}, {0xa7f7, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, 
                 {0xa80c, 0xa824}, {0xa827, 0xa82b}, {0xa830, 0xa839}, {0xa840, 0xa877}, 
                 {0xa880, 0xa8c3}, {0xa8ce, 0xa8d9}, {0xa8f2, 0xa8fe}, {0xa900, 0xa925}, 
                 {0xa92e, 0xa946}, {0xa952, 0xa953}, {0xa95f, 0xa97c}, {0xa983, 0xa9b2}, 
                 {0xa9b4, 0xa9b5}, {0xa9ba, 0xa9bb}, {0xa9bd, 0xa9cd}, {0xa9cf, 0xa9d9}, 
                 {0xa9de, 0xa9e4}, {0xa9e6, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa2f, 0xaa30}, 
                 {0xaa33, 0xaa34}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa50, 0xaa59}, 
                 {0xaa5c, 0xaa7b}, {0xaa7d, 0xaaaf}, {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, 
                 {0xaadb, 0xaaeb}, {0xaaee, 0xaaf5}, {0xab01, 0xab06}, {0xab09, 0xab0e}, 
                 {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab65}, 
                 {0xab70, 0xabe4}, {0xabe6, 0xabe7}, {0xabe9, 0xabec}, {0xabf0, 0xabf9}, 
                 {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, 
                 {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1f, 0xfb36}, 
                 {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbc1}, 
                 {0xfbd3, 0xfd3f}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfd}, 
                 {0xfe10, 0xfe19}, {0xfe30, 0xfe52}, {0xfe54, 0xfe66}, {0xfe68, 0xfe6b}, 
                 {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, {0xff01, 0xff9d}, {0xffa0, 0xffbe}, 
                 {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, 
                 {0xffe0, 0xffe6}, {0xffe8, 0xffee}, {0xfffc, 0xfffd}, {0x10000, 0x1000b}, 
                 {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, 
                 {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10100, 0x10102}, {0x10107, 0x10133}, 
                 {0x10137, 0x1018e}, {0x10190, 0x1019b}, {0x101d0, 0x101fc}, {0x10280, 0x1029c}, 
                 {0x102a0, 0x102d0}, {0x102e1, 0x102fb}, {0x10300, 0x10323}, {0x1032d, 0x1034a}, 
                 {0x10350, 0x10375}, {0x10380, 0x1039d}, {0x1039f, 0x103c3}, {0x103c8, 0x103d5}, 
                 {0x10400, 0x1049d}, {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, 
                 {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10600, 0x10736}, {0x10740, 0x10755}, 
                 {0x10760, 0x10767}, {0x10800, 0x10805}, {0x1080a, 0x10835}, {0x10837, 0x10838}, 
                 {0x1083f, 0x10855}, {0x10857, 0x1089e}, {0x108a7, 0x108af}, {0x108e0, 0x108f2}, 
                 {0x108f4, 0x108f5}, {0x108fb, 0x1091b}, {0x1091f, 0x10939}, {0x10980, 0x109b7}, 
                 {0x109bc, 0x109cf}, {0x109d2, 0x10a00}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, 
                 {0x10a19, 0x10a35}, {0x10a40, 0x10a48}, {0x10a50, 0x10a58}, {0x10a60, 0x10a9f}, 
                 {0x10ac0, 0x10ae4}, {0x10aeb, 0x10af6}, {0x10b00, 0x10b35}, {0x10b39, 0x10b55}, 
                 {0x10b58, 0x10b72}, {0x10b78, 0x10b91}, {0x10b99, 0x10b9c}, {0x10ba9, 0x10baf}, 
                 {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10cfa, 0x10d23}, 
                 {0x10d30, 0x10d39}, {0x10e60, 0x10e7e}, {0x10f00, 0x10f27}, {0x10f30, 0x10f45}, 
                 {0x10f51, 0x10f59}, {0x11002, 0x11037}, {0x11047, 0x1104d}, {0x11052, 0x1106f}, 
                 {0x11082, 0x110b2}, {0x110b7, 0x110b8}, {0x110bb, 0x110bc}, {0x110be, 0x110c1}, 
                 {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11103, 0x11126}, {0x11136, 0x11146}, 
                 {0x11150, 0x11172}, {0x11174, 0x11176}, {0x11182, 0x111b5}, {0x111bf, 0x111c8}, 
                 {0x111d0, 0x111df}, {0x111e1, 0x111f4}, {0x11200, 0x11211}, {0x11213, 0x1122e}, 
                 {0x11232, 0x11233}, {0x11238, 0x1123d}, {0x11280, 0x11286}, {0x1128a, 0x1128d}, 
                 {0x1128f, 0x1129d}, {0x1129f, 0x112a9}, {0x112b0, 0x112de}, {0x112e0, 0x112e2}, 
                 {0x112f0, 0x112f9}, {0x11302, 0x11303}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, 
                 {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, 
                 {0x11341, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d}, {0x1135d, 0x11363}, 
                 {0x11400, 0x11437}, {0x11440, 0x11441}, {0x11447, 0x11459}, {0x11480, 0x114af}, 
                 {0x114b1, 0x114b2}, {0x114bb, 0x114bc}, {0x114c4, 0x114c7}, {0x114d0, 0x114d9}, 
                 {0x11580, 0x115ae}, {0x115b0, 0x115b1}, {0x115b8, 0x115bb}, {0x115c1, 0x115db}, 
                 {0x11600, 0x11632}, {0x1163b, 0x1163c}, {0x11641, 0x11644}, {0x11650, 0x11659}, 
                 {0x11660, 0x1166c}, {0x11680, 0x116aa}, {0x116ae, 0x116af}, {0x116c0, 0x116c9}, 
                 {0x11700, 0x1171a}, {0x11720, 0x11721}, {0x11730, 0x1173f}, {0x11800, 0x1182e}, 
                 {0x118a0, 0x118f2}, {0x11a0b, 0x11a32}, {0x11a39, 0x11a3a}, {0x11a3f, 0x11a46}, 
                 {0x11a57, 0x11a58}, {0x11a5c, 0x11a83}, {0x11a86, 0x11a89}, {0x11a9a, 0x11aa2}, 
                 {0x11ac0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2f}, {0x11c40, 0x11c45}, 
                 {0x11c50, 0x11c6c}, {0x11c70, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, 
                 {0x11d0b, 0x11d30}, {0x11d50, 0x11d59}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, 
                 {0x11d6a, 0x11d8e}, {0x11d93, 0x11d94}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef2}, 
                 {0x11ef5, 0x11ef8}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12470, 0x12474}, 
                 {0x12480, 0x12543}, {0x13000, 0x1342e}, {0x14400, 0x14646}, {0x16800, 0x16a38}, 
                 {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a6e, 0x16a6f}, {0x16ad0, 0x16aed}, 
                 {0x16b00, 0x16b2f}, {0x16b37, 0x16b45}, {0x16b50, 0x16b59}, {0x16b5b, 0x16b61}, 
                 {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e9a}, {0x16f00, 0x16f44}, 
                 {0x16f50, 0x16f7e}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x17000, 0x187f1}, 
                 {0x18800, 0x18af2}, {0x1b000, 0x1b11e}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, 
                 {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d000, 0x1d0f5}, 
                 {0x1d100, 0x1d126}, {0x1d129, 0x1d164}, {0x1d16a, 0x1d16d}, {0x1d183, 0x1d184}, 
                 {0x1d18c, 0x1d1a9}, {0x1d1ae, 0x1d1e8}, {0x1d200, 0x1d241}, {0x1d2e0, 0x1d2f3}, 
                 {0x1d300, 0x1d356}, {0x1d360, 0x1d378}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, 
                 {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, 
                 {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, 
                 {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, 
                 {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d7cb}, {0x1d7ce, 0x1d9ff}, 
                 {0x1da37, 0x1da3a}, {0x1da6d, 0x1da74}, {0x1da76, 0x1da83}, {0x1da85, 0x1da8b}, 
                 {0x1e800, 0x1e8c4}, {0x1e8c7, 0x1e8cf}, {0x1e900, 0x1e943}, {0x1e950, 0x1e959}, 
                 {0x1e95e, 0x1e95f}, {0x1ec71, 0x1ecb4}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, 
                 {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, 
                 {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, 
                 {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, 
                 {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1eef0, 0x1eef1}, 
                 {0x1f000, 0x1f02b}, {0x1f030, 0x1f093}, {0x1f0a0, 0x1f0ae}, {0x1f0b1, 0x1f0bf}, 
                 {0x1f0c1, 0x1f0cf}, {0x1f0d1, 0x1f0f5}, {0x1f100, 0x1f10c}, {0x1f110, 0x1f16b}, 
                 {0x1f170, 0x1f1ac}, {0x1f1e6, 0x1f202}, {0x1f210, 0x1f23b}, {0x1f240, 0x1f248}, 
                 {0x1f250, 0x1f251}, {0x1f260, 0x1f265}, {0x1f300, 0x1f6d4}, {0x1f6e0, 0x1f6ec}, 
                 {0x1f6f0, 0x1f6f9}, {0x1f700, 0x1f773}, {0x1f780, 0x1f7d8}, {0x1f800, 0x1f80b}, 
                 {0x1f810, 0x1f847}, {0x1f850, 0x1f859}, {0x1f860, 0x1f887}, {0x1f890, 0x1f8ad}, 
                 {0x1f900, 0x1f90b}, {0x1f910, 0x1f93e}, {0x1f940, 0x1f970}, {0x1f973, 0x1f976}, 
                 {0x1f97c, 0x1f9a2}, {0x1f9b0, 0x1f9b9}, {0x1f9c0, 0x1f9c2}, {0x1f9d0, 0x1f9ff}, 
                 {0x1fa60, 0x1fa6d}, {0x20000, 0x2a6d6}, {0x2a700, 0x2b734}, {0x2b740, 0x2b81d}, 
                 {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2f800, 0x2fa1d}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass60()
{
    // Name = Changes_When_NFKC_Casefolded, number of codePoints: 10306
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}}),
        std::initializer_list<UChar32>({0x00a0, 0x00a8, 0x00aa, 0x00ad, 0x00af, 0x0100, 0x0102, 0x0104, 
                 0x0106, 0x0108, 0x010a, 0x010c, 0x010e, 0x0110, 0x0112, 0x0114, 
                 0x0116, 0x0118, 0x011a, 0x011c, 0x011e, 0x0120, 0x0122, 0x0124, 
                 0x0126, 0x0128, 0x012a, 0x012c, 0x012e, 0x0130, 0x0136, 0x0139, 
                 0x013b, 0x013d, 0x0143, 0x0145, 0x0147, 0x014c, 0x014e, 0x0150, 
                 0x0152, 0x0154, 0x0156, 0x0158, 0x015a, 0x015c, 0x015e, 0x0160, 
                 0x0162, 0x0164, 0x0166, 0x0168, 0x016a, 0x016c, 0x016e, 0x0170, 
                 0x0172, 0x0174, 0x0176, 0x017b, 0x017d, 0x017f, 0x0184, 0x01a2, 
                 0x01a4, 0x01a9, 0x01ac, 0x01b5, 0x01bc, 0x01cf, 0x01d1, 0x01d3, 
                 0x01d5, 0x01d7, 0x01d9, 0x01db, 0x01de, 0x01e0, 0x01e2, 0x01e4, 
                 0x01e6, 0x01e8, 0x01ea, 0x01ec, 0x01ee, 0x01fa, 0x01fc, 0x01fe, 
                 0x0200, 0x0202, 0x0204, 0x0206, 0x0208, 0x020a, 0x020c, 0x020e, 
                 0x0210, 0x0212, 0x0214, 0x0216, 0x0218, 0x021a, 0x021c, 0x021e, 
                 0x0220, 0x0222, 0x0224, 0x0226, 0x0228, 0x022a, 0x022c, 0x022e, 
                 0x0230, 0x0232, 0x0241, 0x0248, 0x024a, 0x024c, 0x024e, 0x034f, 
                 0x0370, 0x0372, 0x0374, 0x0376, 0x037a, 0x038c, 0x03c2, 0x03d8, 
                 0x03da, 0x03dc, 0x03de, 0x03e0, 0x03e2, 0x03e4, 0x03e6, 0x03e8, 
                 0x03ea, 0x03ec, 0x03ee, 0x03f7, 0x0460, 0x0462, 0x0464, 0x0466, 
                 0x0468, 0x046a, 0x046c, 0x046e, 0x0470, 0x0472, 0x0474, 0x0476, 
                 0x0478, 0x047a, 0x047c, 0x047e, 0x0480, 0x048a, 0x048c, 0x048e, 
                 0x0490, 0x0492, 0x0494, 0x0496, 0x0498, 0x049a, 0x049c, 0x049e, 
                 0x04a0, 0x04a2, 0x04a4, 0x04a6, 0x04a8, 0x04aa, 0x04ac, 0x04ae, 
                 0x04b0, 0x04b2, 0x04b4, 0x04b6, 0x04b8, 0x04ba, 0x04bc, 0x04be, 
                 0x04c3, 0x04c5, 0x04c7, 0x04c9, 0x04cb, 0x04cd, 0x04d0, 0x04d2, 
                 0x04d4, 0x04d6, 0x04d8, 0x04da, 0x04dc, 0x04de, 0x04e0, 0x04e2, 
                 0x04e4, 0x04e6, 0x04e8, 0x04ea, 0x04ec, 0x04ee, 0x04f0, 0x04f2, 
                 0x04f4, 0x04f6, 0x04f8, 0x04fa, 0x04fc, 0x04fe, 0x0500, 0x0502, 
                 0x0504, 0x0506, 0x0508, 0x050a, 0x050c, 0x050e, 0x0510, 0x0512, 
                 0x0514, 0x0516, 0x0518, 0x051a, 0x051c, 0x051e, 0x0520, 0x0522, 
                 0x0524, 0x0526, 0x0528, 0x052a, 0x052c, 0x052e, 0x0587, 0x061c, 
                 0x09df, 0x0a33, 0x0a36, 0x0a5e, 0x0e33, 0x0eb3, 0x0f0c, 0x0f43, 
                 0x0f4d, 0x0f52, 0x0f57, 0x0f5c, 0x0f69, 0x0f73, 0x0f81, 0x0f93, 
                 0x0f9d, 0x0fa2, 0x0fa7, 0x0fac, 0x0fb9, 0x10c7, 0x10cd, 0x10fc, 
                 0x1d78, 0x1e00, 0x1e02, 0x1e04, 0x1e06, 0x1e08, 0x1e0a, 0x1e0c, 
                 0x1e0e, 0x1e10, 0x1e12, 0x1e14, 0x1e16, 0x1e18, 0x1e1a, 0x1e1c, 
                 0x1e1e, 0x1e20, 0x1e22, 0x1e24, 0x1e26, 0x1e28, 0x1e2a, 0x1e2c, 
                 0x1e2e, 0x1e30, 0x1e32, 0x1e34, 0x1e36, 0x1e38, 0x1e3a, 0x1e3c, 
                 0x1e3e, 0x1e40, 0x1e42, 0x1e44, 0x1e46, 0x1e48, 0x1e4a, 0x1e4c, 
                 0x1e4e, 0x1e50, 0x1e52, 0x1e54, 0x1e56, 0x1e58, 0x1e5a, 0x1e5c, 
                 0x1e5e, 0x1e60, 0x1e62, 0x1e64, 0x1e66, 0x1e68, 0x1e6a, 0x1e6c, 
                 0x1e6e, 0x1e70, 0x1e72, 0x1e74, 0x1e76, 0x1e78, 0x1e7a, 0x1e7c, 
                 0x1e7e, 0x1e80, 0x1e82, 0x1e84, 0x1e86, 0x1e88, 0x1e8a, 0x1e8c, 
                 0x1e8e, 0x1e90, 0x1e92, 0x1e94, 0x1e9e, 0x1ea0, 0x1ea2, 0x1ea4, 
                 0x1ea6, 0x1ea8, 0x1eaa, 0x1eac, 0x1eae, 0x1eb0, 0x1eb2, 0x1eb4, 
                 0x1eb6, 0x1eb8, 0x1eba, 0x1ebc, 0x1ebe, 0x1ec0, 0x1ec2, 0x1ec4, 
                 0x1ec6, 0x1ec8, 0x1eca, 0x1ecc, 0x1ece, 0x1ed0, 0x1ed2, 0x1ed4, 
                 0x1ed6, 0x1ed8, 0x1eda, 0x1edc, 0x1ede, 0x1ee0, 0x1ee2, 0x1ee4, 
                 0x1ee6, 0x1ee8, 0x1eea, 0x1eec, 0x1eee, 0x1ef0, 0x1ef2, 0x1ef4, 
                 0x1ef6, 0x1ef8, 0x1efa, 0x1efc, 0x1efe, 0x1f59, 0x1f5b, 0x1f5d, 
                 0x1f5f, 0x1f71, 0x1f73, 0x1f75, 0x1f77, 0x1f79, 0x1f7b, 0x1f7d, 
                 0x1fd3, 0x1fe3, 0x2011, 0x2017, 0x203c, 0x203e, 0x2057, 0x20a8, 
                 0x2124, 0x2126, 0x2128, 0x2183, 0x2189, 0x2a0c, 0x2adc, 0x2c60, 
                 0x2c67, 0x2c69, 0x2c6b, 0x2c72, 0x2c75, 0x2c82, 0x2c84, 0x2c86, 
                 0x2c88, 0x2c8a, 0x2c8c, 0x2c8e, 0x2c90, 0x2c92, 0x2c94, 0x2c96, 
                 0x2c98, 0x2c9a, 0x2c9c, 0x2c9e, 0x2ca0, 0x2ca2, 0x2ca4, 0x2ca6, 
                 0x2ca8, 0x2caa, 0x2cac, 0x2cae, 0x2cb0, 0x2cb2, 0x2cb4, 0x2cb6, 
                 0x2cb8, 0x2cba, 0x2cbc, 0x2cbe, 0x2cc0, 0x2cc2, 0x2cc4, 0x2cc6, 
                 0x2cc8, 0x2cca, 0x2ccc, 0x2cce, 0x2cd0, 0x2cd2, 0x2cd4, 0x2cd6, 
                 0x2cd8, 0x2cda, 0x2cdc, 0x2cde, 0x2ce0, 0x2ce2, 0x2ceb, 0x2ced, 
                 0x2cf2, 0x2d6f, 0x2e9f, 0x2ef3, 0x3000, 0x3036, 0x309f, 0x30ff, 
                 0xa640, 0xa642, 0xa644, 0xa646, 0xa648, 0xa64a, 0xa64c, 0xa64e, 
                 0xa650, 0xa652, 0xa654, 0xa656, 0xa658, 0xa65a, 0xa65c, 0xa65e, 
                 0xa660, 0xa662, 0xa664, 0xa666, 0xa668, 0xa66a, 0xa66c, 0xa680, 
                 0xa682, 0xa684, 0xa686, 0xa688, 0xa68a, 0xa68c, 0xa68e, 0xa690, 
                 0xa692, 0xa694, 0xa696, 0xa698, 0xa69a, 0xa722, 0xa724, 0xa726, 
                 0xa728, 0xa72a, 0xa72c, 0xa72e, 0xa732, 0xa734, 0xa736, 0xa738, 
                 0xa73a, 0xa73c, 0xa73e, 0xa740, 0xa742, 0xa744, 0xa746, 0xa748, 
                 0xa74a, 0xa74c, 0xa74e, 0xa750, 0xa752, 0xa754, 0xa756, 0xa758, 
                 0xa75a, 0xa75c, 0xa75e, 0xa760, 0xa762, 0xa764, 0xa766, 0xa768, 
                 0xa76a, 0xa76c, 0xa76e, 0xa770, 0xa779, 0xa77b, 0xa780, 0xa782, 
                 0xa784, 0xa786, 0xa78b, 0xa78d, 0xa790, 0xa792, 0xa796, 0xa798, 
                 0xa79a, 0xa79c, 0xa79e, 0xa7a0, 0xa7a2, 0xa7a4, 0xa7a6, 0xa7a8, 
                 0xa7b6, 0xa7b8, 0xfa10, 0xfa12, 0xfa20, 0xfa22, 0xfb1d, 0xfb3e, 
                 0xfe74, 0xfeff, 0x1d4a2, 0x1d4bb, 0x1d546, 0x1ee24, 0x1ee27, 0x1ee39, 
                 0x1ee3b, 0x1ee42, 0x1ee47, 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 
                 0x1ee5b, 0x1ee5d, 0x1ee5f, 0x1ee64, 0x1ee7e, 0x1f190}),
        std::initializer_list<CharacterRange>({{0x00b2, 0x00b5}, {0x00b8, 0x00ba}, {0x00bc, 0x00be}, {0x00c0, 0x00d6}, 
                 {0x00d8, 0x00df}, {0x0132, 0x0134}, {0x013f, 0x0141}, {0x0149, 0x014a}, 
                 {0x0178, 0x0179}, {0x0181, 0x0182}, {0x0186, 0x0187}, {0x0189, 0x018b}, 
                 {0x018e, 0x0191}, {0x0193, 0x0194}, {0x0196, 0x0198}, {0x019c, 0x019d}, 
                 {0x019f, 0x01a0}, {0x01a6, 0x01a7}, {0x01ae, 0x01af}, {0x01b1, 0x01b3}, 
                 {0x01b7, 0x01b8}, {0x01c4, 0x01cd}, {0x01f1, 0x01f4}, {0x01f6, 0x01f8}, 
                 {0x023a, 0x023b}, {0x023d, 0x023e}, {0x0243, 0x0246}, {0x02b0, 0x02b8}, 
                 {0x02d8, 0x02dd}, {0x02e0, 0x02e4}, {0x0340, 0x0341}, {0x0343, 0x0345}, 
                 {0x037e, 0x037f}, {0x0384, 0x038a}, {0x038e, 0x038f}, {0x0391, 0x03a1}, 
                 {0x03a3, 0x03ab}, {0x03cf, 0x03d6}, {0x03f0, 0x03f2}, {0x03f4, 0x03f5}, 
                 {0x03f9, 0x03fa}, {0x03fd, 0x042f}, {0x04c0, 0x04c1}, {0x0531, 0x0556}, 
                 {0x0675, 0x0678}, {0x0958, 0x095f}, {0x09dc, 0x09dd}, {0x0a59, 0x0a5b}, 
                 {0x0b5c, 0x0b5d}, {0x0edc, 0x0edd}, {0x0f75, 0x0f79}, {0x10a0, 0x10c5}, 
                 {0x115f, 0x1160}, {0x13f8, 0x13fd}, {0x17b4, 0x17b5}, {0x180b, 0x180e}, 
                 {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1d2c, 0x1d2e}, 
                 {0x1d30, 0x1d3a}, {0x1d3c, 0x1d4d}, {0x1d4f, 0x1d6a}, {0x1d9b, 0x1dbf}, 
                 {0x1e9a, 0x1e9b}, {0x1f08, 0x1f0f}, {0x1f18, 0x1f1d}, {0x1f28, 0x1f2f}, 
                 {0x1f38, 0x1f3f}, {0x1f48, 0x1f4d}, {0x1f68, 0x1f6f}, {0x1f80, 0x1faf}, 
                 {0x1fb2, 0x1fb4}, {0x1fb7, 0x1fc4}, {0x1fc7, 0x1fcf}, {0x1fd8, 0x1fdb}, 
                 {0x1fdd, 0x1fdf}, {0x1fe8, 0x1fef}, {0x1ff2, 0x1ff4}, {0x1ff7, 0x1ffe}, 
                 {0x2000, 0x200f}, {0x2024, 0x2026}, {0x202a, 0x202f}, {0x2033, 0x2034}, 
                 {0x2036, 0x2037}, {0x2047, 0x2049}, {0x205f, 0x2071}, {0x2074, 0x208e}, 
                 {0x2090, 0x209c}, {0x2100, 0x2103}, {0x2105, 0x2107}, {0x2109, 0x2113}, 
                 {0x2115, 0x2116}, {0x2119, 0x211d}, {0x2120, 0x2122}, {0x212a, 0x212d}, 
                 {0x212f, 0x2139}, {0x213b, 0x2140}, {0x2145, 0x2149}, {0x2150, 0x217f}, 
                 {0x222c, 0x222d}, {0x222f, 0x2230}, {0x2329, 0x232a}, {0x2460, 0x24ea}, 
                 {0x2a74, 0x2a76}, {0x2c00, 0x2c2e}, {0x2c62, 0x2c64}, {0x2c6d, 0x2c70}, 
                 {0x2c7c, 0x2c80}, {0x2f00, 0x2fd5}, {0x3038, 0x303a}, {0x309b, 0x309c}, 
                 {0x3131, 0x318e}, {0x3192, 0x319f}, {0x3200, 0x321e}, {0x3220, 0x3247}, 
                 {0x3250, 0x327e}, {0x3280, 0x32fe}, {0x3300, 0x33ff}, {0xa69c, 0xa69d}, 
                 {0xa77d, 0xa77e}, {0xa7aa, 0xa7ae}, {0xa7b0, 0xa7b4}, {0xa7f8, 0xa7f9}, 
                 {0xab5c, 0xab5f}, {0xab70, 0xabbf}, {0xf900, 0xfa0d}, {0xfa15, 0xfa1e}, 
                 {0xfa25, 0xfa26}, {0xfa2a, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, 
                 {0xfb13, 0xfb17}, {0xfb1f, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, 
                 {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3d}, {0xfd50, 0xfd8f}, 
                 {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfc}, {0xfe00, 0xfe19}, {0xfe30, 0xfe44}, 
                 {0xfe47, 0xfe52}, {0xfe54, 0xfe66}, {0xfe68, 0xfe6b}, {0xfe70, 0xfe72}, 
                 {0xfe76, 0xfefc}, {0xff01, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, 
                 {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0xffe0, 0xffe6}, {0xffe8, 0xffee}, 
                 {0xfff0, 0xfff8}, {0x10400, 0x10427}, {0x104b0, 0x104d3}, {0x10c80, 0x10cb2}, 
                 {0x118a0, 0x118bf}, {0x16e40, 0x16e5f}, {0x1bca0, 0x1bca3}, {0x1d15e, 0x1d164}, 
                 {0x1d173, 0x1d17a}, {0x1d1bb, 0x1d1c0}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, 
                 {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, 
                 {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, 
                 {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, 
                 {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, 
                 {0x1e900, 0x1e921}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, 
                 {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, 
                 {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, 
                 {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, 
                 {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1f100, 0x1f10a}, {0x1f110, 0x1f12e}, 
                 {0x1f130, 0x1f14f}, {0x1f16a, 0x1f16b}, {0x1f200, 0x1f202}, {0x1f210, 0x1f23b}, 
                 {0x1f240, 0x1f248}, {0x1f250, 0x1f251}, {0x2f800, 0x2fa1d}, {0xe0000, 0xe0fff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass61()
{
    // Name = White_Space, number of codePoints: 25
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x20}),
        std::initializer_list<CharacterRange>({{0x09, 0x0d}}),
        std::initializer_list<UChar32>({0x0085, 0x00a0, 0x1680, 0x202f, 0x205f, 0x3000}),
        std::initializer_list<CharacterRange>({{0x2000, 0x200a}, {0x2028, 0x2029}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass62()
{
    // Name = Bidi_Control, number of codePoints: 12
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x061c}),
        std::initializer_list<CharacterRange>({{0x200e, 0x200f}, {0x202a, 0x202e}, {0x2066, 0x2069}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass63()
{
    // Name = Join_Control, number of codePoints: 2
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x200c, 0x200d}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass64()
{
    // Name = Dash, number of codePoints: 28
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x2d}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x058a, 0x05be, 0x1400, 0x1806, 0x2053, 0x207b, 0x208b, 0x2212, 
                 0x2e17, 0x2e1a, 0x2e40, 0x301c, 0x3030, 0x30a0, 0xfe58, 0xfe63, 
                 0xff0d}),
        std::initializer_list<CharacterRange>({{0x2010, 0x2015}, {0x2e3a, 0x2e3b}, {0xfe31, 0xfe32}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass65()
{
    // Name = Quotation_Mark, number of codePoints: 30
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x22, 0x27}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x00ab, 0x00bb, 0x2e42, 0xff02, 0xff07}),
        std::initializer_list<CharacterRange>({{0x2018, 0x201f}, {0x2039, 0x203a}, {0x300c, 0x300f}, {0x301d, 0x301f}, 
                 {0xfe41, 0xfe44}, {0xff62, 0xff63}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass66()
{
    // Name = Terminal_Punctuation, number of codePoints: 264
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x21, 0x2c, 0x2e, 0x3f}),
        std::initializer_list<CharacterRange>({{0x3a, 0x3b}}),
        std::initializer_list<UChar32>({0x037e, 0x0387, 0x0589, 0x05c3, 0x060c, 0x061b, 0x06d4, 0x070c, 
                 0x085e, 0x0f08, 0x17da, 0x2e2e, 0x2e3c, 0x2e41, 0x2e4c, 0x2e4e, 
                 0xa92f, 0xaadf, 0xabeb, 0xff01, 0xff0c, 0xff0e, 0xff1f, 0xff61, 
                 0xff64, 0x1039f, 0x103d0, 0x10857, 0x1091f, 0x111cd, 0x112a9, 0x1145b, 
                 0x11c71, 0x16af5, 0x16b44, 0x1bc9f}),
        std::initializer_list<CharacterRange>({{0x061e, 0x061f}, {0x0700, 0x070a}, {0x07f8, 0x07f9}, {0x0830, 0x083e}, 
                 {0x0964, 0x0965}, {0x0e5a, 0x0e5b}, {0x0f0d, 0x0f12}, {0x104a, 0x104b}, 
                 {0x1361, 0x1368}, {0x166d, 0x166e}, {0x16eb, 0x16ed}, {0x1735, 0x1736}, 
                 {0x17d4, 0x17d6}, {0x1802, 0x1805}, {0x1808, 0x1809}, {0x1944, 0x1945}, 
                 {0x1aa8, 0x1aab}, {0x1b5a, 0x1b5b}, {0x1b5d, 0x1b5f}, {0x1c3b, 0x1c3f}, 
                 {0x1c7e, 0x1c7f}, {0x203c, 0x203d}, {0x2047, 0x2049}, {0x3001, 0x3002}, 
                 {0xa4fe, 0xa4ff}, {0xa60d, 0xa60f}, {0xa6f3, 0xa6f7}, {0xa876, 0xa877}, 
                 {0xa8ce, 0xa8cf}, {0xa9c7, 0xa9c9}, {0xaa5d, 0xaa5f}, {0xaaf0, 0xaaf1}, 
                 {0xfe50, 0xfe52}, {0xfe54, 0xfe57}, {0xff1a, 0xff1b}, {0x10a56, 0x10a57}, 
                 {0x10af0, 0x10af5}, {0x10b3a, 0x10b3f}, {0x10b99, 0x10b9c}, {0x10f55, 0x10f59}, 
                 {0x11047, 0x1104d}, {0x110be, 0x110c1}, {0x11141, 0x11143}, {0x111c5, 0x111c6}, 
                 {0x111de, 0x111df}, {0x11238, 0x1123c}, {0x1144b, 0x1144d}, {0x115c2, 0x115c5}, 
                 {0x115c9, 0x115d7}, {0x11641, 0x11642}, {0x1173c, 0x1173e}, {0x11a42, 0x11a43}, 
                 {0x11a9b, 0x11a9c}, {0x11aa1, 0x11aa2}, {0x11c41, 0x11c43}, {0x11ef7, 0x11ef8}, 
                 {0x12470, 0x12474}, {0x16a6e, 0x16a6f}, {0x16b37, 0x16b39}, {0x16e97, 0x16e98}, 
                 {0x1da87, 0x1da8a}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass67()
{
    // Name = Hex_Digit, number of codePoints: 44
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x30, 0x39}, {0x41, 0x46}, {0x61, 0x66}}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xff10, 0xff19}, {0xff21, 0xff26}, {0xff41, 0xff46}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass68()
{
    // Name = ASCII_Hex_Digit, number of codePoints: 22
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x30, 0x39}, {0x41, 0x46}, {0x61, 0x66}}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass69()
{
    // Name = Ideographic, number of codePoints: 96184
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x3006, 0x3007}, {0x3021, 0x3029}, {0x3038, 0x303a}, {0x3400, 0x4db5}, 
                 {0x4e00, 0x9fef}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0x17000, 0x187f1}, 
                 {0x18800, 0x18af2}, {0x1b170, 0x1b2fb}, {0x20000, 0x2a6d6}, {0x2a700, 0x2b734}, 
                 {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2f800, 0x2fa1d}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass70()
{
    // Name = Diacritic, number of codePoints: 818
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x5e, 0x60}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x00a8, 0x00af, 0x00b4, 0x037a, 0x0559, 0x05bf, 0x05c4, 0x093c, 
                 0x094d, 0x0971, 0x09bc, 0x09cd, 0x0a3c, 0x0a4d, 0x0abc, 0x0acd, 
                 0x0b3c, 0x0b4d, 0x0bcd, 0x0c4d, 0x0cbc, 0x0ccd, 0x0d4d, 0x0dca, 
                 0x0e4e, 0x0f35, 0x0f37, 0x0f39, 0x0fc6, 0x1037, 0x108f, 0x17dd, 
                 0x1a7f, 0x1b34, 0x1b44, 0x1ced, 0x1cf4, 0x1fbd, 0x2e2f, 0x30fc, 
                 0xa66f, 0xa67f, 0xa788, 0xa8c4, 0xa953, 0xa9b3, 0xa9c0, 0xa9e5, 
                 0xaaf6, 0xfb1e, 0xff3e, 0xff40, 0xff70, 0xffe3, 0x102e0, 0x11173, 
                 0x111c0, 0x1133c, 0x1134d, 0x11442, 0x11446, 0x1163f, 0x1172b, 0x11a34, 
                 0x11a47, 0x11a99, 0x11c3f, 0x11d42, 0x11d97}),
        std::initializer_list<CharacterRange>({{0x00b7, 0x00b8}, {0x02b0, 0x034e}, {0x0350, 0x0357}, {0x035d, 0x0362}, 
                 {0x0374, 0x0375}, {0x0384, 0x0385}, {0x0483, 0x0487}, {0x0591, 0x05a1}, 
                 {0x05a3, 0x05bd}, {0x05c1, 0x05c2}, {0x064b, 0x0652}, {0x0657, 0x0658}, 
                 {0x06df, 0x06e0}, {0x06e5, 0x06e6}, {0x06ea, 0x06ec}, {0x0730, 0x074a}, 
                 {0x07a6, 0x07b0}, {0x07eb, 0x07f5}, {0x0818, 0x0819}, {0x08e3, 0x08fe}, 
                 {0x0951, 0x0954}, {0x0afd, 0x0aff}, {0x0d3b, 0x0d3c}, {0x0e47, 0x0e4c}, 
                 {0x0ec8, 0x0ecc}, {0x0f18, 0x0f19}, {0x0f3e, 0x0f3f}, {0x0f82, 0x0f84}, 
                 {0x0f86, 0x0f87}, {0x1039, 0x103a}, {0x1087, 0x108d}, {0x109a, 0x109b}, 
                 {0x17c9, 0x17d3}, {0x1939, 0x193b}, {0x1a75, 0x1a7c}, {0x1ab0, 0x1abd}, 
                 {0x1b6b, 0x1b73}, {0x1baa, 0x1bab}, {0x1c36, 0x1c37}, {0x1c78, 0x1c7d}, 
                 {0x1cd0, 0x1ce8}, {0x1cf7, 0x1cf9}, {0x1d2c, 0x1d6a}, {0x1dc4, 0x1dcf}, 
                 {0x1df5, 0x1df9}, {0x1dfd, 0x1dff}, {0x1fbf, 0x1fc1}, {0x1fcd, 0x1fcf}, 
                 {0x1fdd, 0x1fdf}, {0x1fed, 0x1fef}, {0x1ffd, 0x1ffe}, {0x2cef, 0x2cf1}, 
                 {0x302a, 0x302f}, {0x3099, 0x309c}, {0xa67c, 0xa67d}, {0xa69c, 0xa69d}, 
                 {0xa6f0, 0xa6f1}, {0xa717, 0xa721}, {0xa7f8, 0xa7f9}, {0xa8e0, 0xa8f1}, 
                 {0xa92b, 0xa92e}, {0xaa7b, 0xaa7d}, {0xaabf, 0xaac2}, {0xab5b, 0xab5f}, 
                 {0xabec, 0xabed}, {0xfe20, 0xfe2f}, {0xff9e, 0xff9f}, {0x10ae5, 0x10ae6}, 
                 {0x10d22, 0x10d27}, {0x10f46, 0x10f50}, {0x110b9, 0x110ba}, {0x11133, 0x11134}, 
                 {0x111ca, 0x111cc}, {0x11235, 0x11236}, {0x112e9, 0x112ea}, {0x11366, 0x1136c}, 
                 {0x11370, 0x11374}, {0x114c2, 0x114c3}, {0x115bf, 0x115c0}, {0x116b6, 0x116b7}, 
                 {0x11839, 0x1183a}, {0x11d44, 0x11d45}, {0x16af0, 0x16af4}, {0x16f8f, 0x16f9f}, 
                 {0x1d167, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, 
                 {0x1d1aa, 0x1d1ad}, {0x1e8d0, 0x1e8d6}, {0x1e944, 0x1e946}, {0x1e948, 0x1e94a}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass71()
{
    // Name = Extender, number of codePoints: 44
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x00b7, 0x0640, 0x07fa, 0x0e46, 0x0ec6, 0x180a, 0x1843, 0x1aa7, 
                 0x1c36, 0x1c7b, 0x3005, 0xa015, 0xa60c, 0xa9cf, 0xa9e6, 0xaa70, 
                 0xaadd, 0xff70, 0x1135d, 0x11a98}),
        std::initializer_list<CharacterRange>({{0x02d0, 0x02d1}, {0x3031, 0x3035}, {0x309d, 0x309e}, {0x30fc, 0x30fe}, 
                 {0xaaf3, 0xaaf4}, {0x115c6, 0x115c8}, {0x16b42, 0x16b43}, {0x16fe0, 0x16fe1}, 
                 {0x1e944, 0x1e946}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass72()
{
    // Name = Noncharacter_Code_Point, number of codePoints: 66
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xfdd0, 0xfdef}, {0xfffe, 0xffff}, {0x1fffe, 0x1ffff}, {0x2fffe, 0x2ffff}, 
                 {0x3fffe, 0x3ffff}, {0x4fffe, 0x4ffff}, {0x5fffe, 0x5ffff}, {0x6fffe, 0x6ffff}, 
                 {0x7fffe, 0x7ffff}, {0x8fffe, 0x8ffff}, {0x9fffe, 0x9ffff}, {0xafffe, 0xaffff}, 
                 {0xbfffe, 0xbffff}, {0xcfffe, 0xcffff}, {0xdfffe, 0xdffff}, {0xefffe, 0xeffff}, 
                 {0xffffe, 0xfffff}, {0x10fffe, 0x10ffff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass73()
{
    // Name = IDS_Binary_Operator, number of codePoints: 10
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x2ff0, 0x2ff1}, {0x2ff4, 0x2ffb}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass74()
{
    // Name = IDS_Trinary_Operator, number of codePoints: 2
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x2ff2, 0x2ff3}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass75()
{
    // Name = Radical, number of codePoints: 329
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x2e80, 0x2e99}, {0x2e9b, 0x2ef3}, {0x2f00, 0x2fd5}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass76()
{
    // Name = Unified_Ideograph, number of codePoints: 87887
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0xfa11, 0xfa1f, 0xfa21}),
        std::initializer_list<CharacterRange>({{0x3400, 0x4db5}, {0x4e00, 0x9fef}, {0xfa0e, 0xfa0f}, {0xfa13, 0xfa14}, 
                 {0xfa23, 0xfa24}, {0xfa27, 0xfa29}, {0x20000, 0x2a6d6}, {0x2a700, 0x2b734}, 
                 {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass77()
{
    // Name = Deprecated, number of codePoints: 15
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0149, 0x0673, 0x0f77, 0x0f79, 0xe0001}),
        std::initializer_list<CharacterRange>({{0x17a3, 0x17a4}, {0x206a, 0x206f}, {0x2329, 0x232a}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass78()
{
    // Name = Soft_Dotted, number of codePoints: 46
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x69, 0x6a}}),
        std::initializer_list<UChar32>({0x012f, 0x0249, 0x0268, 0x029d, 0x02b2, 0x03f3, 0x0456, 0x0458, 
                 0x1d62, 0x1d96, 0x1da4, 0x1da8, 0x1e2d, 0x1ecb, 0x2071, 0x2c7c}),
        std::initializer_list<CharacterRange>({{0x2148, 0x2149}, {0x1d422, 0x1d423}, {0x1d456, 0x1d457}, {0x1d48a, 0x1d48b}, 
                 {0x1d4be, 0x1d4bf}, {0x1d4f2, 0x1d4f3}, {0x1d526, 0x1d527}, {0x1d55a, 0x1d55b}, 
                 {0x1d58e, 0x1d58f}, {0x1d5c2, 0x1d5c3}, {0x1d5f6, 0x1d5f7}, {0x1d62a, 0x1d62b}, 
                 {0x1d65e, 0x1d65f}, {0x1d692, 0x1d693}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass79()
{
    // Name = Logical_Order_Exception, number of codePoints: 19
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x19ba, 0xaab9}),
        std::initializer_list<CharacterRange>({{0x0e40, 0x0e44}, {0x0ec0, 0x0ec4}, {0x19b5, 0x19b7}, {0xaab5, 0xaab6}, 
                 {0xaabb, 0xaabc}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass80()
{
    // Name = Sentence_Terminal, number of codePoints: 141
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x21, 0x2e, 0x3f}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0589, 0x06d4, 0x07f9, 0x0837, 0x0839, 0x1362, 0x166e, 0x1803, 
                 0x1809, 0x2e2e, 0x2e3c, 0x3002, 0xa4ff, 0xa6f3, 0xa6f7, 0xa92f, 
                 0xabeb, 0xfe52, 0xff01, 0xff0e, 0xff1f, 0xff61, 0x111cd, 0x112a9, 
                 0x16af5, 0x16b44, 0x16e98, 0x1bc9f, 0x1da88}),
        std::initializer_list<CharacterRange>({{0x061e, 0x061f}, {0x0700, 0x0702}, {0x083d, 0x083e}, {0x0964, 0x0965}, 
                 {0x104a, 0x104b}, {0x1367, 0x1368}, {0x1735, 0x1736}, {0x1944, 0x1945}, 
                 {0x1aa8, 0x1aab}, {0x1b5a, 0x1b5b}, {0x1b5e, 0x1b5f}, {0x1c3b, 0x1c3c}, 
                 {0x1c7e, 0x1c7f}, {0x203c, 0x203d}, {0x2047, 0x2049}, {0xa60e, 0xa60f}, 
                 {0xa876, 0xa877}, {0xa8ce, 0xa8cf}, {0xa9c8, 0xa9c9}, {0xaa5d, 0xaa5f}, 
                 {0xaaf0, 0xaaf1}, {0xfe56, 0xfe57}, {0x10a56, 0x10a57}, {0x10f55, 0x10f59}, 
                 {0x11047, 0x11048}, {0x110be, 0x110c1}, {0x11141, 0x11143}, {0x111c5, 0x111c6}, 
                 {0x111de, 0x111df}, {0x11238, 0x11239}, {0x1123b, 0x1123c}, {0x1144b, 0x1144c}, 
                 {0x115c2, 0x115c3}, {0x115c9, 0x115d7}, {0x11641, 0x11642}, {0x1173c, 0x1173e}, 
                 {0x11a42, 0x11a43}, {0x11a9b, 0x11a9c}, {0x11c41, 0x11c42}, {0x11ef7, 0x11ef8}, 
                 {0x16a6e, 0x16a6f}, {0x16b37, 0x16b38}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass81()
{
    // Name = Variation_Selector, number of codePoints: 259
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x180b, 0x180d}, {0xfe00, 0xfe0f}, {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass82()
{
    // Name = Pattern_White_Space, number of codePoints: 11
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x20}),
        std::initializer_list<CharacterRange>({{0x09, 0x0d}}),
        std::initializer_list<UChar32>({0x0085}),
        std::initializer_list<CharacterRange>({{0x200e, 0x200f}, {0x2028, 0x2029}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass83()
{
    // Name = Pattern_Syntax, number of codePoints: 2760
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x60}),
        std::initializer_list<CharacterRange>({{0x21, 0x2f}, {0x3a, 0x40}, {0x5b, 0x5e}, {0x7b, 0x7e}}),
        std::initializer_list<UChar32>({0x00a9, 0x00ae, 0x00b6, 0x00bb, 0x00bf, 0x00d7, 0x00f7, 0x3030}),
        std::initializer_list<CharacterRange>({{0x00a1, 0x00a7}, {0x00ab, 0x00ac}, {0x00b0, 0x00b1}, {0x2010, 0x2027}, 
                 {0x2030, 0x203e}, {0x2041, 0x2053}, {0x2055, 0x205e}, {0x2190, 0x245f}, 
                 {0x2500, 0x2775}, {0x2794, 0x2bff}, {0x2e00, 0x2e7f}, {0x3001, 0x3003}, 
                 {0x3008, 0x3020}, {0xfd3e, 0xfd3f}, {0xfe45, 0xfe46}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass84()
{
    // Name = Regional_Indicator, number of codePoints: 26
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1f1e6, 0x1f1ff}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass85()
{
    // Name = Emoji, number of codePoints: 1250
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x23, 0x2a}),
        std::initializer_list<CharacterRange>({{0x30, 0x39}}),
        std::initializer_list<UChar32>({0x00a9, 0x00ae, 0x203c, 0x2049, 0x2122, 0x2139, 0x2328, 0x23cf, 
                 0x24c2, 0x25b6, 0x25c0, 0x260e, 0x2611, 0x2618, 0x261d, 0x2620, 
                 0x2626, 0x262a, 0x2640, 0x2642, 0x2663, 0x2668, 0x267b, 0x2699, 
                 0x26c8, 0x26d1, 0x26fd, 0x2702, 0x2705, 0x270f, 0x2712, 0x2714, 
                 0x2716, 0x271d, 0x2721, 0x2728, 0x2744, 0x2747, 0x274c, 0x274e, 
                 0x2757, 0x27a1, 0x27b0, 0x27bf, 0x2b50, 0x2b55, 0x3030, 0x303d, 
                 0x3297, 0x3299, 0x1f004, 0x1f0cf, 0x1f18e, 0x1f21a, 0x1f22f, 0x1f587, 
                 0x1f590, 0x1f5a8, 0x1f5bc, 0x1f5e1, 0x1f5e3, 0x1f5e8, 0x1f5ef, 0x1f5f3, 
                 0x1f6e9, 0x1f6f0, 0x1f97a}),
        std::initializer_list<CharacterRange>({{0x2194, 0x2199}, {0x21a9, 0x21aa}, {0x231a, 0x231b}, {0x23e9, 0x23f3}, 
                 {0x23f8, 0x23fa}, {0x25aa, 0x25ab}, {0x25fb, 0x25fe}, {0x2600, 0x2604}, 
                 {0x2614, 0x2615}, {0x2622, 0x2623}, {0x262e, 0x262f}, {0x2638, 0x263a}, 
                 {0x2648, 0x2653}, {0x265f, 0x2660}, {0x2665, 0x2666}, {0x267e, 0x267f}, 
                 {0x2692, 0x2697}, {0x269b, 0x269c}, {0x26a0, 0x26a1}, {0x26aa, 0x26ab}, 
                 {0x26b0, 0x26b1}, {0x26bd, 0x26be}, {0x26c4, 0x26c5}, {0x26ce, 0x26cf}, 
                 {0x26d3, 0x26d4}, {0x26e9, 0x26ea}, {0x26f0, 0x26f5}, {0x26f7, 0x26fa}, 
                 {0x2708, 0x270d}, {0x2733, 0x2734}, {0x2753, 0x2755}, {0x2763, 0x2764}, 
                 {0x2795, 0x2797}, {0x2934, 0x2935}, {0x2b05, 0x2b07}, {0x2b1b, 0x2b1c}, 
                 {0x1f170, 0x1f171}, {0x1f17e, 0x1f17f}, {0x1f191, 0x1f19a}, {0x1f1e6, 0x1f1ff}, 
                 {0x1f201, 0x1f202}, {0x1f232, 0x1f23a}, {0x1f250, 0x1f251}, {0x1f300, 0x1f321}, 
                 {0x1f324, 0x1f393}, {0x1f396, 0x1f397}, {0x1f399, 0x1f39b}, {0x1f39e, 0x1f3f0}, 
                 {0x1f3f3, 0x1f3f5}, {0x1f3f7, 0x1f4fd}, {0x1f4ff, 0x1f53d}, {0x1f549, 0x1f54e}, 
                 {0x1f550, 0x1f567}, {0x1f56f, 0x1f570}, {0x1f573, 0x1f57a}, {0x1f58a, 0x1f58d}, 
                 {0x1f595, 0x1f596}, {0x1f5a4, 0x1f5a5}, {0x1f5b1, 0x1f5b2}, {0x1f5c2, 0x1f5c4}, 
                 {0x1f5d1, 0x1f5d3}, {0x1f5dc, 0x1f5de}, {0x1f5fa, 0x1f64f}, {0x1f680, 0x1f6c5}, 
                 {0x1f6cb, 0x1f6d2}, {0x1f6e0, 0x1f6e5}, {0x1f6eb, 0x1f6ec}, {0x1f6f3, 0x1f6f9}, 
                 {0x1f910, 0x1f93a}, {0x1f93c, 0x1f93e}, {0x1f940, 0x1f945}, {0x1f947, 0x1f970}, 
                 {0x1f973, 0x1f976}, {0x1f97c, 0x1f9a2}, {0x1f9b0, 0x1f9b9}, {0x1f9c0, 0x1f9c2}, 
                 {0x1f9d0, 0x1f9ff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass86()
{
    // Name = Emoji_Presentation, number of codePoints: 1032
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x23f0, 0x23f3, 0x267f, 0x2693, 0x26a1, 0x26ce, 0x26d4, 0x26ea, 
                 0x26f5, 0x26fa, 0x26fd, 0x2705, 0x2728, 0x274c, 0x274e, 0x2757, 
                 0x27b0, 0x27bf, 0x2b50, 0x2b55, 0x1f004, 0x1f0cf, 0x1f18e, 0x1f201, 
                 0x1f21a, 0x1f22f, 0x1f3f4, 0x1f440, 0x1f57a, 0x1f5a4, 0x1f6cc, 0x1f97a}),
        std::initializer_list<CharacterRange>({{0x231a, 0x231b}, {0x23e9, 0x23ec}, {0x25fd, 0x25fe}, {0x2614, 0x2615}, 
                 {0x2648, 0x2653}, {0x26aa, 0x26ab}, {0x26bd, 0x26be}, {0x26c4, 0x26c5}, 
                 {0x26f2, 0x26f3}, {0x270a, 0x270b}, {0x2753, 0x2755}, {0x2795, 0x2797}, 
                 {0x2b1b, 0x2b1c}, {0x1f191, 0x1f19a}, {0x1f1e6, 0x1f1ff}, {0x1f232, 0x1f236}, 
                 {0x1f238, 0x1f23a}, {0x1f250, 0x1f251}, {0x1f300, 0x1f320}, {0x1f32d, 0x1f335}, 
                 {0x1f337, 0x1f37c}, {0x1f37e, 0x1f393}, {0x1f3a0, 0x1f3ca}, {0x1f3cf, 0x1f3d3}, 
                 {0x1f3e0, 0x1f3f0}, {0x1f3f8, 0x1f43e}, {0x1f442, 0x1f4fc}, {0x1f4ff, 0x1f53d}, 
                 {0x1f54b, 0x1f54e}, {0x1f550, 0x1f567}, {0x1f595, 0x1f596}, {0x1f5fb, 0x1f64f}, 
                 {0x1f680, 0x1f6c5}, {0x1f6d0, 0x1f6d2}, {0x1f6eb, 0x1f6ec}, {0x1f6f4, 0x1f6f9}, 
                 {0x1f910, 0x1f93a}, {0x1f93c, 0x1f93e}, {0x1f940, 0x1f945}, {0x1f947, 0x1f970}, 
                 {0x1f973, 0x1f976}, {0x1f97c, 0x1f9a2}, {0x1f9b0, 0x1f9b9}, {0x1f9c0, 0x1f9c2}, 
                 {0x1f9d0, 0x1f9ff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass87()
{
    // Name = Emoji_Modifier, number of codePoints: 5
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1f3fb, 0x1f3ff}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass88()
{
    // Name = Emoji_Modifier_Base, number of codePoints: 106
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x261d, 0x26f9, 0x1f385, 0x1f3c7, 0x1f46e, 0x1f47c, 0x1f4aa, 0x1f57a, 
                 0x1f590, 0x1f6a3, 0x1f6c0, 0x1f6cc, 0x1f926}),
        std::initializer_list<CharacterRange>({{0x270a, 0x270d}, {0x1f3c2, 0x1f3c4}, {0x1f3ca, 0x1f3cc}, {0x1f442, 0x1f443}, 
                 {0x1f446, 0x1f450}, {0x1f466, 0x1f469}, {0x1f470, 0x1f478}, {0x1f481, 0x1f483}, 
                 {0x1f485, 0x1f487}, {0x1f574, 0x1f575}, {0x1f595, 0x1f596}, {0x1f645, 0x1f647}, 
                 {0x1f64b, 0x1f64f}, {0x1f6b4, 0x1f6b6}, {0x1f918, 0x1f91c}, {0x1f91e, 0x1f91f}, 
                 {0x1f930, 0x1f939}, {0x1f93d, 0x1f93e}, {0x1f9b5, 0x1f9b6}, {0x1f9b8, 0x1f9b9}, 
                 {0x1f9d1, 0x1f9dd}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass89()
{
    // Name = Emoji_Component, number of codePoints: 146
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({0x23, 0x2a}),
        std::initializer_list<CharacterRange>({{0x30, 0x39}}),
        std::initializer_list<UChar32>({0x200d, 0x20e3, 0xfe0f}),
        std::initializer_list<CharacterRange>({{0x1f1e6, 0x1f1ff}, {0x1f3fb, 0x1f3ff}, {0x1f9b0, 0x1f9b3}, {0xe0020, 0xe007f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass90()
{
    // Name = Extended_Pictographic, number of codePoints: 3793
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x00a9, 0x00ae, 0x203c, 0x2049, 0x2122, 0x2139, 0x2328, 0x2388, 
                 0x23cf, 0x24c2, 0x25b6, 0x25c0, 0x2714, 0x2716, 0x271d, 0x2721, 
                 0x2728, 0x2744, 0x2747, 0x274c, 0x274e, 0x2757, 0x27a1, 0x27b0, 
                 0x27bf, 0x2b50, 0x2b55, 0x3030, 0x303d, 0x3297, 0x3299, 0x1f12f, 
                 0x1f18e, 0x1f21a, 0x1f22f}),
        std::initializer_list<CharacterRange>({{0x2194, 0x2199}, {0x21a9, 0x21aa}, {0x231a, 0x231b}, {0x23e9, 0x23f3}, 
                 {0x23f8, 0x23fa}, {0x25aa, 0x25ab}, {0x25fb, 0x25fe}, {0x2600, 0x2605}, 
                 {0x2607, 0x2612}, {0x2614, 0x2685}, {0x2690, 0x2705}, {0x2708, 0x2712}, 
                 {0x2733, 0x2734}, {0x2753, 0x2755}, {0x2763, 0x2767}, {0x2795, 0x2797}, 
                 {0x2934, 0x2935}, {0x2b05, 0x2b07}, {0x2b1b, 0x2b1c}, {0x1f000, 0x1f0ff}, 
                 {0x1f10d, 0x1f10f}, {0x1f16c, 0x1f171}, {0x1f17e, 0x1f17f}, {0x1f191, 0x1f19a}, 
                 {0x1f1ad, 0x1f1e5}, {0x1f201, 0x1f20f}, {0x1f232, 0x1f23a}, {0x1f23c, 0x1f23f}, 
                 {0x1f249, 0x1f3fa}, {0x1f400, 0x1f53d}, {0x1f546, 0x1f64f}, {0x1f680, 0x1f6ff}, 
                 {0x1f774, 0x1f77f}, {0x1f7d5, 0x1f7ff}, {0x1f80c, 0x1f80f}, {0x1f848, 0x1f84f}, 
                 {0x1f85a, 0x1f85f}, {0x1f888, 0x1f88f}, {0x1f8ae, 0x1f8ff}, {0x1f90c, 0x1f93a}, 
                 {0x1f93c, 0x1f945}, {0x1f947, 0x1fffd}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass91()
{
    // Name = Unknown, number of codePoints: 976673
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x038b, 0x038d, 0x03a2, 0x0530, 0x0590, 0x061d, 0x070e, 0x083f, 
                 0x085f, 0x08b5, 0x0984, 0x09a9, 0x09b1, 0x09de, 0x0a04, 0x0a29, 
                 0x0a31, 0x0a34, 0x0a37, 0x0a3d, 0x0a5d, 0x0a84, 0x0a8e, 0x0a92, 
                 0x0aa9, 0x0ab1, 0x0ab4, 0x0ac6, 0x0aca, 0x0b00, 0x0b04, 0x0b29, 
                 0x0b31, 0x0b34, 0x0b5e, 0x0b84, 0x0b91, 0x0b9b, 0x0b9d, 0x0bc9, 
                 0x0c0d, 0x0c11, 0x0c29, 0x0c45, 0x0c49, 0x0c57, 0x0c8d, 0x0c91, 
                 0x0ca9, 0x0cb4, 0x0cc5, 0x0cc9, 0x0cdf, 0x0cf0, 0x0d04, 0x0d0d, 
                 0x0d11, 0x0d45, 0x0d49, 0x0d84, 0x0db2, 0x0dbc, 0x0dd5, 0x0dd7, 
                 0x0e83, 0x0e89, 0x0e98, 0x0ea0, 0x0ea4, 0x0ea6, 0x0eac, 0x0eba, 
                 0x0ec5, 0x0ec7, 0x0f48, 0x0f98, 0x0fbd, 0x0fcd, 0x10c6, 0x1249, 
                 0x1257, 0x1259, 0x1289, 0x12b1, 0x12bf, 0x12c1, 0x12d7, 0x1311, 
                 0x170d, 0x176d, 0x1771, 0x180f, 0x191f, 0x1a5f, 0x1dfa, 0x1f58, 
                 0x1f5a, 0x1f5c, 0x1f5e, 0x1fb5, 0x1fc5, 0x1fdc, 0x1ff5, 0x1fff, 
                 0x2065, 0x208f, 0x2bc9, 0x2bff, 0x2c2f, 0x2c5f, 0x2d26, 0x2da7, 
                 0x2daf, 0x2db7, 0x2dbf, 0x2dc7, 0x2dcf, 0x2dd7, 0x2ddf, 0x2e9a, 
                 0x3040, 0x3130, 0x318f, 0x321f, 0x32ff, 0xa9ce, 0xa9ff, 0xab27, 
                 0xab2f, 0xfb37, 0xfb3d, 0xfb3f, 0xfb42, 0xfb45, 0xfe53, 0xfe67, 
                 0xfe75, 0xff00, 0xffe7, 0x1000c, 0x10027, 0x1003b, 0x1003e, 0x1018f, 
                 0x1039e, 0x10809, 0x10836, 0x10856, 0x108f3, 0x10a04, 0x10a14, 0x10a18, 
                 0x11135, 0x111e0, 0x11212, 0x11287, 0x11289, 0x1128e, 0x1129e, 0x11304, 
                 0x11329, 0x11331, 0x11334, 0x1133a, 0x1145a, 0x1145c, 0x11c09, 0x11c37, 
                 0x11ca8, 0x11d07, 0x11d0a, 0x11d3b, 0x11d3e, 0x11d66, 0x11d69, 0x11d8f, 
                 0x11d92, 0x1246f, 0x16a5f, 0x16b5a, 0x16b62, 0x1d455, 0x1d49d, 0x1d4ad, 
                 0x1d4ba, 0x1d4bc, 0x1d4c4, 0x1d506, 0x1d515, 0x1d51d, 0x1d53a, 0x1d53f, 
                 0x1d545, 0x1d551, 0x1daa0, 0x1e007, 0x1e022, 0x1e025, 0x1ee04, 0x1ee20, 
                 0x1ee23, 0x1ee28, 0x1ee33, 0x1ee38, 0x1ee3a, 0x1ee48, 0x1ee4a, 0x1ee4c, 
                 0x1ee50, 0x1ee53, 0x1ee58, 0x1ee5a, 0x1ee5c, 0x1ee5e, 0x1ee60, 0x1ee63, 
                 0x1ee6b, 0x1ee73, 0x1ee78, 0x1ee7d, 0x1ee7f, 0x1ee8a, 0x1eea4, 0x1eeaa, 
                 0x1f0c0, 0x1f0d0, 0x1f93f, 0x1f97b}),
        std::initializer_list<CharacterRange>({{0x0378, 0x0379}, {0x0380, 0x0383}, {0x0557, 0x0558}, {0x058b, 0x058c}, 
                 {0x05c8, 0x05cf}, {0x05eb, 0x05ee}, {0x05f5, 0x05ff}, {0x074b, 0x074c}, 
                 {0x07b2, 0x07bf}, {0x07fb, 0x07fc}, {0x082e, 0x082f}, {0x085c, 0x085d}, 
                 {0x086b, 0x089f}, {0x08be, 0x08d2}, {0x098d, 0x098e}, {0x0991, 0x0992}, 
                 {0x09b3, 0x09b5}, {0x09ba, 0x09bb}, {0x09c5, 0x09c6}, {0x09c9, 0x09ca}, 
                 {0x09cf, 0x09d6}, {0x09d8, 0x09db}, {0x09e4, 0x09e5}, {0x09ff, 0x0a00}, 
                 {0x0a0b, 0x0a0e}, {0x0a11, 0x0a12}, {0x0a3a, 0x0a3b}, {0x0a43, 0x0a46}, 
                 {0x0a49, 0x0a4a}, {0x0a4e, 0x0a50}, {0x0a52, 0x0a58}, {0x0a5f, 0x0a65}, 
                 {0x0a77, 0x0a80}, {0x0aba, 0x0abb}, {0x0ace, 0x0acf}, {0x0ad1, 0x0adf}, 
                 {0x0ae4, 0x0ae5}, {0x0af2, 0x0af8}, {0x0b0d, 0x0b0e}, {0x0b11, 0x0b12}, 
                 {0x0b3a, 0x0b3b}, {0x0b45, 0x0b46}, {0x0b49, 0x0b4a}, {0x0b4e, 0x0b55}, 
                 {0x0b58, 0x0b5b}, {0x0b64, 0x0b65}, {0x0b78, 0x0b81}, {0x0b8b, 0x0b8d}, 
                 {0x0b96, 0x0b98}, {0x0ba0, 0x0ba2}, {0x0ba5, 0x0ba7}, {0x0bab, 0x0bad}, 
                 {0x0bba, 0x0bbd}, {0x0bc3, 0x0bc5}, {0x0bce, 0x0bcf}, {0x0bd1, 0x0bd6}, 
                 {0x0bd8, 0x0be5}, {0x0bfb, 0x0bff}, {0x0c3a, 0x0c3c}, {0x0c4e, 0x0c54}, 
                 {0x0c5b, 0x0c5f}, {0x0c64, 0x0c65}, {0x0c70, 0x0c77}, {0x0cba, 0x0cbb}, 
                 {0x0cce, 0x0cd4}, {0x0cd7, 0x0cdd}, {0x0ce4, 0x0ce5}, {0x0cf3, 0x0cff}, 
                 {0x0d50, 0x0d53}, {0x0d64, 0x0d65}, {0x0d80, 0x0d81}, {0x0d97, 0x0d99}, 
                 {0x0dbe, 0x0dbf}, {0x0dc7, 0x0dc9}, {0x0dcb, 0x0dce}, {0x0de0, 0x0de5}, 
                 {0x0df0, 0x0df1}, {0x0df5, 0x0e00}, {0x0e3b, 0x0e3e}, {0x0e5c, 0x0e80}, 
                 {0x0e85, 0x0e86}, {0x0e8b, 0x0e8c}, {0x0e8e, 0x0e93}, {0x0ea8, 0x0ea9}, 
                 {0x0ebe, 0x0ebf}, {0x0ece, 0x0ecf}, {0x0eda, 0x0edb}, {0x0ee0, 0x0eff}, 
                 {0x0f6d, 0x0f70}, {0x0fdb, 0x0fff}, {0x10c8, 0x10cc}, {0x10ce, 0x10cf}, 
                 {0x124e, 0x124f}, {0x125e, 0x125f}, {0x128e, 0x128f}, {0x12b6, 0x12b7}, 
                 {0x12c6, 0x12c7}, {0x1316, 0x1317}, {0x135b, 0x135c}, {0x137d, 0x137f}, 
                 {0x139a, 0x139f}, {0x13f6, 0x13f7}, {0x13fe, 0x13ff}, {0x169d, 0x169f}, 
                 {0x16f9, 0x16ff}, {0x1715, 0x171f}, {0x1737, 0x173f}, {0x1754, 0x175f}, 
                 {0x1774, 0x177f}, {0x17de, 0x17df}, {0x17ea, 0x17ef}, {0x17fa, 0x17ff}, 
                 {0x181a, 0x181f}, {0x1879, 0x187f}, {0x18ab, 0x18af}, {0x18f6, 0x18ff}, 
                 {0x192c, 0x192f}, {0x193c, 0x193f}, {0x1941, 0x1943}, {0x196e, 0x196f}, 
                 {0x1975, 0x197f}, {0x19ac, 0x19af}, {0x19ca, 0x19cf}, {0x19db, 0x19dd}, 
                 {0x1a1c, 0x1a1d}, {0x1a7d, 0x1a7e}, {0x1a8a, 0x1a8f}, {0x1a9a, 0x1a9f}, 
                 {0x1aae, 0x1aaf}, {0x1abf, 0x1aff}, {0x1b4c, 0x1b4f}, {0x1b7d, 0x1b7f}, 
                 {0x1bf4, 0x1bfb}, {0x1c38, 0x1c3a}, {0x1c4a, 0x1c4c}, {0x1c89, 0x1c8f}, 
                 {0x1cbb, 0x1cbc}, {0x1cc8, 0x1ccf}, {0x1cfa, 0x1cff}, {0x1f16, 0x1f17}, 
                 {0x1f1e, 0x1f1f}, {0x1f46, 0x1f47}, {0x1f4e, 0x1f4f}, {0x1f7e, 0x1f7f}, 
                 {0x1fd4, 0x1fd5}, {0x1ff0, 0x1ff1}, {0x2072, 0x2073}, {0x209d, 0x209f}, 
                 {0x20c0, 0x20cf}, {0x20f1, 0x20ff}, {0x218c, 0x218f}, {0x2427, 0x243f}, 
                 {0x244b, 0x245f}, {0x2b74, 0x2b75}, {0x2b96, 0x2b97}, {0x2cf4, 0x2cf8}, 
                 {0x2d28, 0x2d2c}, {0x2d2e, 0x2d2f}, {0x2d68, 0x2d6e}, {0x2d71, 0x2d7e}, 
                 {0x2d97, 0x2d9f}, {0x2e4f, 0x2e7f}, {0x2ef4, 0x2eff}, {0x2fd6, 0x2fef}, 
                 {0x2ffc, 0x2fff}, {0x3097, 0x3098}, {0x3100, 0x3104}, {0x31bb, 0x31bf}, 
                 {0x31e4, 0x31ef}, {0x4db6, 0x4dbf}, {0x9ff0, 0x9fff}, {0xa48d, 0xa48f}, 
                 {0xa4c7, 0xa4cf}, {0xa62c, 0xa63f}, {0xa6f8, 0xa6ff}, {0xa7ba, 0xa7f6}, 
                 {0xa82c, 0xa82f}, {0xa83a, 0xa83f}, {0xa878, 0xa87f}, {0xa8c6, 0xa8cd}, 
                 {0xa8da, 0xa8df}, {0xa954, 0xa95e}, {0xa97d, 0xa97f}, {0xa9da, 0xa9dd}, 
                 {0xaa37, 0xaa3f}, {0xaa4e, 0xaa4f}, {0xaa5a, 0xaa5b}, {0xaac3, 0xaada}, 
                 {0xaaf7, 0xab00}, {0xab07, 0xab08}, {0xab0f, 0xab10}, {0xab17, 0xab1f}, 
                 {0xab66, 0xab6f}, {0xabee, 0xabef}, {0xabfa, 0xabff}, {0xd7a4, 0xd7af}, 
                 {0xd7c7, 0xd7ca}, {0xd7fc, 0xf8ff}, {0xfa6e, 0xfa6f}, {0xfada, 0xfaff}, 
                 {0xfb07, 0xfb12}, {0xfb18, 0xfb1c}, {0xfbc2, 0xfbd2}, {0xfd40, 0xfd4f}, 
                 {0xfd90, 0xfd91}, {0xfdc8, 0xfdef}, {0xfdfe, 0xfdff}, {0xfe1a, 0xfe1f}, 
                 {0xfe6c, 0xfe6f}, {0xfefd, 0xfefe}, {0xffbf, 0xffc1}, {0xffc8, 0xffc9}, 
                 {0xffd0, 0xffd1}, {0xffd8, 0xffd9}, {0xffdd, 0xffdf}, {0xffef, 0xfff8}, 
                 {0xfffe, 0xffff}, {0x1004e, 0x1004f}, {0x1005e, 0x1007f}, {0x100fb, 0x100ff}, 
                 {0x10103, 0x10106}, {0x10134, 0x10136}, {0x1019c, 0x1019f}, {0x101a1, 0x101cf}, 
                 {0x101fe, 0x1027f}, {0x1029d, 0x1029f}, {0x102d1, 0x102df}, {0x102fc, 0x102ff}, 
                 {0x10324, 0x1032c}, {0x1034b, 0x1034f}, {0x1037b, 0x1037f}, {0x103c4, 0x103c7}, 
                 {0x103d6, 0x103ff}, {0x1049e, 0x1049f}, {0x104aa, 0x104af}, {0x104d4, 0x104d7}, 
                 {0x104fc, 0x104ff}, {0x10528, 0x1052f}, {0x10564, 0x1056e}, {0x10570, 0x105ff}, 
                 {0x10737, 0x1073f}, {0x10756, 0x1075f}, {0x10768, 0x107ff}, {0x10806, 0x10807}, 
                 {0x10839, 0x1083b}, {0x1083d, 0x1083e}, {0x1089f, 0x108a6}, {0x108b0, 0x108df}, 
                 {0x108f6, 0x108fa}, {0x1091c, 0x1091e}, {0x1093a, 0x1093e}, {0x10940, 0x1097f}, 
                 {0x109b8, 0x109bb}, {0x109d0, 0x109d1}, {0x10a07, 0x10a0b}, {0x10a36, 0x10a37}, 
                 {0x10a3b, 0x10a3e}, {0x10a49, 0x10a4f}, {0x10a59, 0x10a5f}, {0x10aa0, 0x10abf}, 
                 {0x10ae7, 0x10aea}, {0x10af7, 0x10aff}, {0x10b36, 0x10b38}, {0x10b56, 0x10b57}, 
                 {0x10b73, 0x10b77}, {0x10b92, 0x10b98}, {0x10b9d, 0x10ba8}, {0x10bb0, 0x10bff}, 
                 {0x10c49, 0x10c7f}, {0x10cb3, 0x10cbf}, {0x10cf3, 0x10cf9}, {0x10d28, 0x10d2f}, 
                 {0x10d3a, 0x10e5f}, {0x10e7f, 0x10eff}, {0x10f28, 0x10f2f}, {0x10f5a, 0x10fff}, 
                 {0x1104e, 0x11051}, {0x11070, 0x1107e}, {0x110c2, 0x110cc}, {0x110ce, 0x110cf}, 
                 {0x110e9, 0x110ef}, {0x110fa, 0x110ff}, {0x11147, 0x1114f}, {0x11177, 0x1117f}, 
                 {0x111ce, 0x111cf}, {0x111f5, 0x111ff}, {0x1123f, 0x1127f}, {0x112aa, 0x112af}, 
                 {0x112eb, 0x112ef}, {0x112fa, 0x112ff}, {0x1130d, 0x1130e}, {0x11311, 0x11312}, 
                 {0x11345, 0x11346}, {0x11349, 0x1134a}, {0x1134e, 0x1134f}, {0x11351, 0x11356}, 
                 {0x11358, 0x1135c}, {0x11364, 0x11365}, {0x1136d, 0x1136f}, {0x11375, 0x113ff}, 
                 {0x1145f, 0x1147f}, {0x114c8, 0x114cf}, {0x114da, 0x1157f}, {0x115b6, 0x115b7}, 
                 {0x115de, 0x115ff}, {0x11645, 0x1164f}, {0x1165a, 0x1165f}, {0x1166d, 0x1167f}, 
                 {0x116b8, 0x116bf}, {0x116ca, 0x116ff}, {0x1171b, 0x1171c}, {0x1172c, 0x1172f}, 
                 {0x11740, 0x117ff}, {0x1183c, 0x1189f}, {0x118f3, 0x118fe}, {0x11900, 0x119ff}, 
                 {0x11a48, 0x11a4f}, {0x11a84, 0x11a85}, {0x11aa3, 0x11abf}, {0x11af9, 0x11bff}, 
                 {0x11c46, 0x11c4f}, {0x11c6d, 0x11c6f}, {0x11c90, 0x11c91}, {0x11cb7, 0x11cff}, 
                 {0x11d37, 0x11d39}, {0x11d48, 0x11d4f}, {0x11d5a, 0x11d5f}, {0x11d99, 0x11d9f}, 
                 {0x11daa, 0x11edf}, {0x11ef9, 0x11fff}, {0x1239a, 0x123ff}, {0x12475, 0x1247f}, 
                 {0x12544, 0x12fff}, {0x1342f, 0x143ff}, {0x14647, 0x167ff}, {0x16a39, 0x16a3f}, 
                 {0x16a6a, 0x16a6d}, {0x16a70, 0x16acf}, {0x16aee, 0x16aef}, {0x16af6, 0x16aff}, 
                 {0x16b46, 0x16b4f}, {0x16b78, 0x16b7c}, {0x16b90, 0x16e3f}, {0x16e9b, 0x16eff}, 
                 {0x16f45, 0x16f4f}, {0x16f7f, 0x16f8e}, {0x16fa0, 0x16fdf}, {0x16fe2, 0x16fff}, 
                 {0x187f2, 0x187ff}, {0x18af3, 0x1afff}, {0x1b11f, 0x1b16f}, {0x1b2fc, 0x1bbff}, 
                 {0x1bc6b, 0x1bc6f}, {0x1bc7d, 0x1bc7f}, {0x1bc89, 0x1bc8f}, {0x1bc9a, 0x1bc9b}, 
                 {0x1bca4, 0x1cfff}, {0x1d0f6, 0x1d0ff}, {0x1d127, 0x1d128}, {0x1d1e9, 0x1d1ff}, 
                 {0x1d246, 0x1d2df}, {0x1d2f4, 0x1d2ff}, {0x1d357, 0x1d35f}, {0x1d379, 0x1d3ff}, 
                 {0x1d4a0, 0x1d4a1}, {0x1d4a3, 0x1d4a4}, {0x1d4a7, 0x1d4a8}, {0x1d50b, 0x1d50c}, 
                 {0x1d547, 0x1d549}, {0x1d6a6, 0x1d6a7}, {0x1d7cc, 0x1d7cd}, {0x1da8c, 0x1da9a}, 
                 {0x1dab0, 0x1dfff}, {0x1e019, 0x1e01a}, {0x1e02b, 0x1e7ff}, {0x1e8c5, 0x1e8c6}, 
                 {0x1e8d7, 0x1e8ff}, {0x1e94b, 0x1e94f}, {0x1e95a, 0x1e95d}, {0x1e960, 0x1ec70}, 
                 {0x1ecb5, 0x1edff}, {0x1ee25, 0x1ee26}, {0x1ee3c, 0x1ee41}, {0x1ee43, 0x1ee46}, 
                 {0x1ee55, 0x1ee56}, {0x1ee65, 0x1ee66}, {0x1ee9c, 0x1eea0}, {0x1eebc, 0x1eeef}, 
                 {0x1eef2, 0x1efff}, {0x1f02c, 0x1f02f}, {0x1f094, 0x1f09f}, {0x1f0af, 0x1f0b0}, 
                 {0x1f0f6, 0x1f0ff}, {0x1f10d, 0x1f10f}, {0x1f16c, 0x1f16f}, {0x1f1ad, 0x1f1e5}, 
                 {0x1f203, 0x1f20f}, {0x1f23c, 0x1f23f}, {0x1f249, 0x1f24f}, {0x1f252, 0x1f25f}, 
                 {0x1f266, 0x1f2ff}, {0x1f6d5, 0x1f6df}, {0x1f6ed, 0x1f6ef}, {0x1f6fa, 0x1f6ff}, 
                 {0x1f774, 0x1f77f}, {0x1f7d9, 0x1f7ff}, {0x1f80c, 0x1f80f}, {0x1f848, 0x1f84f}, 
                 {0x1f85a, 0x1f85f}, {0x1f888, 0x1f88f}, {0x1f8ae, 0x1f8ff}, {0x1f90c, 0x1f90f}, 
                 {0x1f971, 0x1f972}, {0x1f977, 0x1f979}, {0x1f9a3, 0x1f9af}, {0x1f9ba, 0x1f9bf}, 
                 {0x1f9c3, 0x1f9cf}, {0x1fa00, 0x1fa5f}, {0x1fa6e, 0x1ffff}, {0x2a6d7, 0x2a6ff}, 
                 {0x2b735, 0x2b73f}, {0x2b81e, 0x2b81f}, {0x2cea2, 0x2ceaf}, {0x2ebe1, 0x2f7ff}, 
                 {0x2fa1e, 0xe0000}, {0xe0002, 0xe001f}, {0xe0080, 0xe00ff}, {0xe01f0, 0x10ffff}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass92()
{
    // Name = Common, number of codePoints: 7591
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x00, 0x40}, {0x5b, 0x60}, {0x7b, 0x7f}}),
        std::initializer_list<UChar32>({0x00d7, 0x00f7, 0x0374, 0x037e, 0x0385, 0x0387, 0x0589, 0x0605, 
                 0x060c, 0x061b, 0x061f, 0x0640, 0x06dd, 0x08e2, 0x0e3f, 0x10fb, 
                 0x1805, 0x1cd3, 0x1ce1, 0x3006, 0x30a0, 0xa92e, 0xa9cf, 0xab5b, 
                 0xfeff, 0xff70, 0x1d4a2, 0x1d4bb, 0x1d546, 0x1f97a, 0xe0001}),
        std::initializer_list<CharacterRange>({{0x0080, 0x00a9}, {0x00ab, 0x00b9}, {0x00bb, 0x00bf}, {0x02b9, 0x02df}, 
                 {0x02e5, 0x02e9}, {0x02ec, 0x02ff}, {0x0964, 0x0965}, {0x0fd5, 0x0fd8}, 
                 {0x16eb, 0x16ed}, {0x1735, 0x1736}, {0x1802, 0x1803}, {0x1ce9, 0x1cec}, 
                 {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf7}, {0x2000, 0x200b}, {0x200e, 0x2064}, 
                 {0x2066, 0x2070}, {0x2074, 0x207e}, {0x2080, 0x208e}, {0x20a0, 0x20bf}, 
                 {0x2100, 0x2125}, {0x2127, 0x2129}, {0x212c, 0x2131}, {0x2133, 0x214d}, 
                 {0x214f, 0x215f}, {0x2189, 0x218b}, {0x2190, 0x2426}, {0x2440, 0x244a}, 
                 {0x2460, 0x27ff}, {0x2900, 0x2b73}, {0x2b76, 0x2b95}, {0x2b98, 0x2bc8}, 
                 {0x2bca, 0x2bfe}, {0x2e00, 0x2e4e}, {0x2ff0, 0x2ffb}, {0x3000, 0x3004}, 
                 {0x3008, 0x3020}, {0x3030, 0x3037}, {0x303c, 0x303f}, {0x309b, 0x309c}, 
                 {0x30fb, 0x30fc}, {0x3190, 0x319f}, {0x31c0, 0x31e3}, {0x3220, 0x325f}, 
                 {0x327f, 0x32cf}, {0x3358, 0x33ff}, {0x4dc0, 0x4dff}, {0xa700, 0xa721}, 
                 {0xa788, 0xa78a}, {0xa830, 0xa839}, {0xfd3e, 0xfd3f}, {0xfe10, 0xfe19}, 
                 {0xfe30, 0xfe52}, {0xfe54, 0xfe66}, {0xfe68, 0xfe6b}, {0xff01, 0xff20}, 
                 {0xff3b, 0xff40}, {0xff5b, 0xff65}, {0xff9e, 0xff9f}, {0xffe0, 0xffe6}, 
                 {0xffe8, 0xffee}, {0xfff9, 0xfffd}, {0x10100, 0x10102}, {0x10107, 0x10133}, 
                 {0x10137, 0x1013f}, {0x10190, 0x1019b}, {0x101d0, 0x101fc}, {0x102e1, 0x102fb}, 
                 {0x1bca0, 0x1bca3}, {0x1d000, 0x1d0f5}, {0x1d100, 0x1d126}, {0x1d129, 0x1d166}, 
                 {0x1d16a, 0x1d17a}, {0x1d183, 0x1d184}, {0x1d18c, 0x1d1a9}, {0x1d1ae, 0x1d1e8}, 
                 {0x1d2e0, 0x1d2f3}, {0x1d300, 0x1d356}, {0x1d360, 0x1d378}, {0x1d400, 0x1d454}, 
                 {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, 
                 {0x1d4ae, 0x1d4b9}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, 
                 {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, 
                 {0x1d540, 0x1d544}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d7cb}, 
                 {0x1d7ce, 0x1d7ff}, {0x1ec71, 0x1ecb4}, {0x1f000, 0x1f02b}, {0x1f030, 0x1f093}, 
                 {0x1f0a0, 0x1f0ae}, {0x1f0b1, 0x1f0bf}, {0x1f0c1, 0x1f0cf}, {0x1f0d1, 0x1f0f5}, 
                 {0x1f100, 0x1f10c}, {0x1f110, 0x1f16b}, {0x1f170, 0x1f1ac}, {0x1f1e6, 0x1f1ff}, 
                 {0x1f201, 0x1f202}, {0x1f210, 0x1f23b}, {0x1f240, 0x1f248}, {0x1f250, 0x1f251}, 
                 {0x1f260, 0x1f265}, {0x1f300, 0x1f6d4}, {0x1f6e0, 0x1f6ec}, {0x1f6f0, 0x1f6f9}, 
                 {0x1f700, 0x1f773}, {0x1f780, 0x1f7d8}, {0x1f800, 0x1f80b}, {0x1f810, 0x1f847}, 
                 {0x1f850, 0x1f859}, {0x1f860, 0x1f887}, {0x1f890, 0x1f8ad}, {0x1f900, 0x1f90b}, 
                 {0x1f910, 0x1f93e}, {0x1f940, 0x1f970}, {0x1f973, 0x1f976}, {0x1f97c, 0x1f9a2}, 
                 {0x1f9b0, 0x1f9b9}, {0x1f9c0, 0x1f9c2}, {0x1f9d0, 0x1f9ff}, {0x1fa60, 0x1fa6d}, 
                 {0xe0020, 0xe007f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass93()
{
    // Name = Latin, number of codePoints: 1353
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<UChar32>({0x00aa, 0x00ba, 0x2071, 0x207f, 0x2132, 0x214e}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x02b8}, {0x02e0, 0x02e4}, 
                 {0x1d00, 0x1d25}, {0x1d2c, 0x1d5c}, {0x1d62, 0x1d65}, {0x1d6b, 0x1d77}, 
                 {0x1d79, 0x1dbe}, {0x1e00, 0x1eff}, {0x2090, 0x209c}, {0x212a, 0x212b}, 
                 {0x2160, 0x2188}, {0x2c60, 0x2c7f}, {0xa722, 0xa787}, {0xa78b, 0xa7b9}, 
                 {0xa7f7, 0xa7ff}, {0xab30, 0xab5a}, {0xab5c, 0xab64}, {0xfb00, 0xfb06}, 
                 {0xff21, 0xff3a}, {0xff41, 0xff5a}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass94()
{
    // Name = Greek, number of codePoints: 518
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x037f, 0x0384, 0x0386, 0x038c, 0x1dbf, 0x1f59, 0x1f5b, 0x1f5d, 
                 0x2126, 0xab65, 0x101a0}),
        std::initializer_list<CharacterRange>({{0x0370, 0x0373}, {0x0375, 0x0377}, {0x037a, 0x037d}, {0x0388, 0x038a}, 
                 {0x038e, 0x03a1}, {0x03a3, 0x03e1}, {0x03f0, 0x03ff}, {0x1d26, 0x1d2a}, 
                 {0x1d5d, 0x1d61}, {0x1d66, 0x1d6a}, {0x1f00, 0x1f15}, {0x1f18, 0x1f1d}, 
                 {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f5f, 0x1f7d}, 
                 {0x1f80, 0x1fb4}, {0x1fb6, 0x1fc4}, {0x1fc6, 0x1fd3}, {0x1fd6, 0x1fdb}, 
                 {0x1fdd, 0x1fef}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffe}, {0x10140, 0x1018e}, 
                 {0x1d200, 0x1d245}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass95()
{
    // Name = Cyrillic, number of codePoints: 443
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1d2b, 0x1d78}),
        std::initializer_list<CharacterRange>({{0x0400, 0x0484}, {0x0487, 0x052f}, {0x1c80, 0x1c88}, {0x2de0, 0x2dff}, 
                 {0xa640, 0xa69f}, {0xfe2e, 0xfe2f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass96()
{
    // Name = Armenian, number of codePoints: 95
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x058a}),
        std::initializer_list<CharacterRange>({{0x0531, 0x0556}, {0x0559, 0x0588}, {0x058d, 0x058f}, {0xfb13, 0xfb17}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass97()
{
    // Name = Hebrew, number of codePoints: 134
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0xfb3e}),
        std::initializer_list<CharacterRange>({{0x0591, 0x05c7}, {0x05d0, 0x05ea}, {0x05ef, 0x05f4}, {0xfb1d, 0xfb36}, 
                 {0xfb38, 0xfb3c}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfb4f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass98()
{
    // Name = Arabic, number of codePoints: 1281
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x061c, 0x061e, 0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 0x1ee47, 
                 0x1ee49, 0x1ee4b, 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 0x1ee5f, 
                 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x0600, 0x0604}, {0x0606, 0x060b}, {0x060d, 0x061a}, {0x0620, 0x063f}, 
                 {0x0641, 0x064a}, {0x0656, 0x066f}, {0x0671, 0x06dc}, {0x06de, 0x06ff}, 
                 {0x0750, 0x077f}, {0x08a0, 0x08b4}, {0x08b6, 0x08bd}, {0x08d3, 0x08e1}, 
                 {0x08e3, 0x08ff}, {0xfb50, 0xfbc1}, {0xfbd3, 0xfd3d}, {0xfd50, 0xfd8f}, 
                 {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfd}, {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, 
                 {0x10e60, 0x10e7e}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, 
                 {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, 
                 {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, 
                 {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, 
                 {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1eef0, 0x1eef1}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass99()
{
    // Name = Syriac, number of codePoints: 88
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0700, 0x070d}, {0x070f, 0x074a}, {0x074d, 0x074f}, {0x0860, 0x086a}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass100()
{
    // Name = Thaana, number of codePoints: 50
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0780, 0x07b1}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass101()
{
    // Name = Devanagari, number of codePoints: 156
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0900, 0x0950}, {0x0953, 0x0963}, {0x0966, 0x097f}, {0xa8e0, 0xa8ff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass102()
{
    // Name = Bengali, number of codePoints: 96
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x09b2, 0x09d7}),
        std::initializer_list<CharacterRange>({{0x0980, 0x0983}, {0x0985, 0x098c}, {0x098f, 0x0990}, {0x0993, 0x09a8}, 
                 {0x09aa, 0x09b0}, {0x09b6, 0x09b9}, {0x09bc, 0x09c4}, {0x09c7, 0x09c8}, 
                 {0x09cb, 0x09ce}, {0x09dc, 0x09dd}, {0x09df, 0x09e3}, {0x09e6, 0x09fe}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass103()
{
    // Name = Gurmukhi, number of codePoints: 80
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0a3c, 0x0a51, 0x0a5e}),
        std::initializer_list<CharacterRange>({{0x0a01, 0x0a03}, {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, 
                 {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, 
                 {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a59, 0x0a5c}, 
                 {0x0a66, 0x0a76}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass104()
{
    // Name = Gujarati, number of codePoints: 91
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0ad0}),
        std::initializer_list<CharacterRange>({{0x0a81, 0x0a83}, {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, 
                 {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0abc, 0x0ac5}, 
                 {0x0ac7, 0x0ac9}, {0x0acb, 0x0acd}, {0x0ae0, 0x0ae3}, {0x0ae6, 0x0af1}, 
                 {0x0af9, 0x0aff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass105()
{
    // Name = Oriya, number of codePoints: 90
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, 
                 {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, {0x0b3c, 0x0b44}, 
                 {0x0b47, 0x0b48}, {0x0b4b, 0x0b4d}, {0x0b56, 0x0b57}, {0x0b5c, 0x0b5d}, 
                 {0x0b5f, 0x0b63}, {0x0b66, 0x0b77}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass106()
{
    // Name = Tamil, number of codePoints: 72
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0b9c, 0x0bd0, 0x0bd7}),
        std::initializer_list<CharacterRange>({{0x0b82, 0x0b83}, {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, 
                 {0x0b99, 0x0b9a}, {0x0b9e, 0x0b9f}, {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, 
                 {0x0bae, 0x0bb9}, {0x0bbe, 0x0bc2}, {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd}, 
                 {0x0be6, 0x0bfa}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass107()
{
    // Name = Telugu, number of codePoints: 97
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0c00, 0x0c0c}, {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, 
                 {0x0c3d, 0x0c44}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56}, 
                 {0x0c58, 0x0c5a}, {0x0c60, 0x0c63}, {0x0c66, 0x0c6f}, {0x0c78, 0x0c7f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass108()
{
    // Name = Kannada, number of codePoints: 89
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0cde}),
        std::initializer_list<CharacterRange>({{0x0c80, 0x0c8c}, {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, 
                 {0x0cb5, 0x0cb9}, {0x0cbc, 0x0cc4}, {0x0cc6, 0x0cc8}, {0x0cca, 0x0ccd}, 
                 {0x0cd5, 0x0cd6}, {0x0ce0, 0x0ce3}, {0x0ce6, 0x0cef}, {0x0cf1, 0x0cf2}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass109()
{
    // Name = Malayalam, number of codePoints: 117
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0d00, 0x0d03}, {0x0d05, 0x0d0c}, {0x0d0e, 0x0d10}, {0x0d12, 0x0d44}, 
                 {0x0d46, 0x0d48}, {0x0d4a, 0x0d4f}, {0x0d54, 0x0d63}, {0x0d66, 0x0d7f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass110()
{
    // Name = Sinhala, number of codePoints: 110
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0dbd, 0x0dca, 0x0dd6}),
        std::initializer_list<CharacterRange>({{0x0d82, 0x0d83}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, 
                 {0x0dc0, 0x0dc6}, {0x0dcf, 0x0dd4}, {0x0dd8, 0x0ddf}, {0x0de6, 0x0def}, 
                 {0x0df2, 0x0df4}, {0x111e1, 0x111f4}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass111()
{
    // Name = Thai, number of codePoints: 86
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0e01, 0x0e3a}, {0x0e40, 0x0e5b}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass112()
{
    // Name = Lao, number of codePoints: 67
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0e84, 0x0e8a, 0x0e8d, 0x0ea5, 0x0ea7, 0x0ec6}),
        std::initializer_list<CharacterRange>({{0x0e81, 0x0e82}, {0x0e87, 0x0e88}, {0x0e94, 0x0e97}, {0x0e99, 0x0e9f}, 
                 {0x0ea1, 0x0ea3}, {0x0eaa, 0x0eab}, {0x0ead, 0x0eb9}, {0x0ebb, 0x0ebd}, 
                 {0x0ec0, 0x0ec4}, {0x0ec8, 0x0ecd}, {0x0ed0, 0x0ed9}, {0x0edc, 0x0edf}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass113()
{
    // Name = Tibetan, number of codePoints: 207
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0f00, 0x0f47}, {0x0f49, 0x0f6c}, {0x0f71, 0x0f97}, {0x0f99, 0x0fbc}, 
                 {0x0fbe, 0x0fcc}, {0x0fce, 0x0fd4}, {0x0fd9, 0x0fda}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass114()
{
    // Name = Myanmar, number of codePoints: 223
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1000, 0x109f}, {0xa9e0, 0xa9fe}, {0xaa60, 0xaa7f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass115()
{
    // Name = Georgian, number of codePoints: 173
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x10c7, 0x10cd, 0x2d27, 0x2d2d}),
        std::initializer_list<CharacterRange>({{0x10a0, 0x10c5}, {0x10d0, 0x10fa}, {0x10fc, 0x10ff}, {0x1c90, 0x1cba}, 
                 {0x1cbd, 0x1cbf}, {0x2d00, 0x2d25}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass116()
{
    // Name = Hangul, number of codePoints: 11739
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1100, 0x11ff}, {0x302e, 0x302f}, {0x3131, 0x318e}, {0x3200, 0x321e}, 
                 {0x3260, 0x327e}, {0xa960, 0xa97c}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, 
                 {0xd7cb, 0xd7fb}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, 
                 {0xffd2, 0xffd7}, {0xffda, 0xffdc}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass117()
{
    // Name = Ethiopic, number of codePoints: 495
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1258, 0x12c0}),
        std::initializer_list<CharacterRange>({{0x1200, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x125a, 0x125d}, 
                 {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, 
                 {0x12b8, 0x12be}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, 
                 {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x137c}, {0x1380, 0x1399}, 
                 {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, 
                 {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, 
                 {0x2dd8, 0x2dde}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, 
                 {0xab20, 0xab26}, {0xab28, 0xab2e}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass118()
{
    // Name = Cherokee, number of codePoints: 172
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0xab70, 0xabbf}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass119()
{
    // Name = Canadian_Aboriginal, number of codePoints: 710
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1400, 0x167f}, {0x18b0, 0x18f5}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass120()
{
    // Name = Ogham, number of codePoints: 29
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1680, 0x169c}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass121()
{
    // Name = Runic, number of codePoints: 86
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x16a0, 0x16ea}, {0x16ee, 0x16f8}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass122()
{
    // Name = Khmer, number of codePoints: 146
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1780, 0x17dd}, {0x17e0, 0x17e9}, {0x17f0, 0x17f9}, {0x19e0, 0x19ff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass123()
{
    // Name = Mongolian, number of codePoints: 167
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1804}),
        std::initializer_list<CharacterRange>({{0x1800, 0x1801}, {0x1806, 0x180e}, {0x1810, 0x1819}, {0x1820, 0x1878}, 
                 {0x1880, 0x18aa}, {0x11660, 0x1166c}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass124()
{
    // Name = Hiragana, number of codePoints: 376
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1f200}),
        std::initializer_list<CharacterRange>({{0x3041, 0x3096}, {0x309d, 0x309f}, {0x1b001, 0x1b11e}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass125()
{
    // Name = Katakana, number of codePoints: 300
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1b000}),
        std::initializer_list<CharacterRange>({{0x30a1, 0x30fa}, {0x30fd, 0x30ff}, {0x31f0, 0x31ff}, {0x32d0, 0x32fe}, 
                 {0x3300, 0x3357}, {0xff66, 0xff6f}, {0xff71, 0xff9d}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass126()
{
    // Name = Bopomofo, number of codePoints: 72
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x02ea, 0x02eb}, {0x3105, 0x312f}, {0x31a0, 0x31ba}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass127()
{
    // Name = Han, number of codePoints: 89233
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x3005, 0x3007}),
        std::initializer_list<CharacterRange>({{0x2e80, 0x2e99}, {0x2e9b, 0x2ef3}, {0x2f00, 0x2fd5}, {0x3021, 0x3029}, 
                 {0x3038, 0x303b}, {0x3400, 0x4db5}, {0x4e00, 0x9fef}, {0xf900, 0xfa6d}, 
                 {0xfa70, 0xfad9}, {0x20000, 0x2a6d6}, {0x2a700, 0x2b734}, {0x2b740, 0x2b81d}, 
                 {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2f800, 0x2fa1d}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass128()
{
    // Name = Yi, number of codePoints: 1220
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xa000, 0xa48c}, {0xa490, 0xa4c6}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass129()
{
    // Name = Old_Italic, number of codePoints: 39
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10300, 0x10323}, {0x1032d, 0x1032f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass130()
{
    // Name = Gothic, number of codePoints: 27
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10330, 0x1034a}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass131()
{
    // Name = Deseret, number of codePoints: 80
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10400, 0x1044f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass132()
{
    // Name = Inherited, number of codePoints: 569
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0670, 0x1ced, 0x1cf4, 0x101fd, 0x102e0, 0x1133b}),
        std::initializer_list<CharacterRange>({{0x0300, 0x036f}, {0x0485, 0x0486}, {0x064b, 0x0655}, {0x0951, 0x0952}, 
                 {0x1ab0, 0x1abe}, {0x1cd0, 0x1cd2}, {0x1cd4, 0x1ce0}, {0x1ce2, 0x1ce8}, 
                 {0x1cf8, 0x1cf9}, {0x1dc0, 0x1df9}, {0x1dfb, 0x1dff}, {0x200c, 0x200d}, 
                 {0x20d0, 0x20f0}, {0x302a, 0x302d}, {0x3099, 0x309a}, {0xfe00, 0xfe0f}, 
                 {0xfe20, 0xfe2d}, {0x1d167, 0x1d169}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, 
                 {0x1d1aa, 0x1d1ad}, {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass133()
{
    // Name = Tagalog, number of codePoints: 20
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1700, 0x170c}, {0x170e, 0x1714}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass134()
{
    // Name = Hanunoo, number of codePoints: 21
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1720, 0x1734}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass135()
{
    // Name = Buhid, number of codePoints: 20
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1740, 0x1753}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass136()
{
    // Name = Tagbanwa, number of codePoints: 18
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass137()
{
    // Name = Limbu, number of codePoints: 68
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1940}),
        std::initializer_list<CharacterRange>({{0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b}, {0x1944, 0x194f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass138()
{
    // Name = Tai_Le, number of codePoints: 35
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1950, 0x196d}, {0x1970, 0x1974}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass139()
{
    // Name = Linear_B, number of codePoints: 211
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, 
                 {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass140()
{
    // Name = Ugaritic, number of codePoints: 31
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1039f}),
        std::initializer_list<CharacterRange>({{0x10380, 0x1039d}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass141()
{
    // Name = Shavian, number of codePoints: 48
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10450, 0x1047f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass142()
{
    // Name = Osmanya, number of codePoints: 40
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10480, 0x1049d}, {0x104a0, 0x104a9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass143()
{
    // Name = Cypriot, number of codePoints: 55
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x10808, 0x1083c, 0x1083f}),
        std::initializer_list<CharacterRange>({{0x10800, 0x10805}, {0x1080a, 0x10835}, {0x10837, 0x10838}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass144()
{
    // Name = Braille, number of codePoints: 256
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x2800, 0x28ff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass145()
{
    // Name = Buginese, number of codePoints: 30
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1a00, 0x1a1b}, {0x1a1e, 0x1a1f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass146()
{
    // Name = Coptic, number of codePoints: 137
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x03e2, 0x03ef}, {0x2c80, 0x2cf3}, {0x2cf9, 0x2cff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass147()
{
    // Name = New_Tai_Lue, number of codePoints: 83
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x19de, 0x19df}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass148()
{
    // Name = Glagolitic, number of codePoints: 132
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x2c00, 0x2c2e}, {0x2c30, 0x2c5e}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, 
                 {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass149()
{
    // Name = Tifinagh, number of codePoints: 59
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x2d7f}),
        std::initializer_list<CharacterRange>({{0x2d30, 0x2d67}, {0x2d6f, 0x2d70}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass150()
{
    // Name = Syloti_Nagri, number of codePoints: 44
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xa800, 0xa82b}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass151()
{
    // Name = Old_Persian, number of codePoints: 50
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x103a0, 0x103c3}, {0x103c8, 0x103d5}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass152()
{
    // Name = Kharoshthi, number of codePoints: 68
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, 
                 {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a48}, {0x10a50, 0x10a58}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass153()
{
    // Name = Balinese, number of codePoints: 121
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1b00, 0x1b4b}, {0x1b50, 0x1b7c}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass154()
{
    // Name = Cuneiform, number of codePoints: 1234
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12470, 0x12474}, {0x12480, 0x12543}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass155()
{
    // Name = Phoenician, number of codePoints: 29
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1091f}),
        std::initializer_list<CharacterRange>({{0x10900, 0x1091b}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass156()
{
    // Name = Phags_Pa, number of codePoints: 56
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xa840, 0xa877}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass157()
{
    // Name = Nko, number of codePoints: 62
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x07c0, 0x07fa}, {0x07fd, 0x07ff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass158()
{
    // Name = Sundanese, number of codePoints: 72
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1b80, 0x1bbf}, {0x1cc0, 0x1cc7}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass159()
{
    // Name = Lepcha, number of codePoints: 74
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1c00, 0x1c37}, {0x1c3b, 0x1c49}, {0x1c4d, 0x1c4f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass160()
{
    // Name = Ol_Chiki, number of codePoints: 48
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1c50, 0x1c7f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass161()
{
    // Name = Vai, number of codePoints: 300
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xa500, 0xa62b}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass162()
{
    // Name = Saurashtra, number of codePoints: 82
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xa880, 0xa8c5}, {0xa8ce, 0xa8d9}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass163()
{
    // Name = Kayah_Li, number of codePoints: 47
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0xa92f}),
        std::initializer_list<CharacterRange>({{0xa900, 0xa92d}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass164()
{
    // Name = Rejang, number of codePoints: 37
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0xa95f}),
        std::initializer_list<CharacterRange>({{0xa930, 0xa953}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass165()
{
    // Name = Lycian, number of codePoints: 29
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10280, 0x1029c}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass166()
{
    // Name = Carian, number of codePoints: 49
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x102a0, 0x102d0}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass167()
{
    // Name = Lydian, number of codePoints: 27
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1093f}),
        std::initializer_list<CharacterRange>({{0x10920, 0x10939}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass168()
{
    // Name = Cham, number of codePoints: 83
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa5c, 0xaa5f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass169()
{
    // Name = Tai_Tham, number of codePoints: 127
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1a20, 0x1a5e}, {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, 
                 {0x1aa0, 0x1aad}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass170()
{
    // Name = Tai_Viet, number of codePoints: 72
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xaa80, 0xaac2}, {0xaadb, 0xaadf}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass171()
{
    // Name = Avestan, number of codePoints: 61
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10b00, 0x10b35}, {0x10b39, 0x10b3f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass172()
{
    // Name = Egyptian_Hieroglyphs, number of codePoints: 1071
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x13000, 0x1342e}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass173()
{
    // Name = Samaritan, number of codePoints: 61
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0800, 0x082d}, {0x0830, 0x083e}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass174()
{
    // Name = Lisu, number of codePoints: 48
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xa4d0, 0xa4ff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass175()
{
    // Name = Bamum, number of codePoints: 657
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xa6a0, 0xa6f7}, {0x16800, 0x16a38}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass176()
{
    // Name = Javanese, number of codePoints: 90
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xa980, 0xa9cd}, {0xa9d0, 0xa9d9}, {0xa9de, 0xa9df}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass177()
{
    // Name = Meetei_Mayek, number of codePoints: 79
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xaae0, 0xaaf6}, {0xabc0, 0xabed}, {0xabf0, 0xabf9}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass178()
{
    // Name = Imperial_Aramaic, number of codePoints: 31
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10840, 0x10855}, {0x10857, 0x1085f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass179()
{
    // Name = Old_South_Arabian, number of codePoints: 32
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10a60, 0x10a7f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass180()
{
    // Name = Inscriptional_Parthian, number of codePoints: 30
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10b40, 0x10b55}, {0x10b58, 0x10b5f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass181()
{
    // Name = Inscriptional_Pahlavi, number of codePoints: 27
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10b60, 0x10b72}, {0x10b78, 0x10b7f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass182()
{
    // Name = Old_Turkic, number of codePoints: 73
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10c00, 0x10c48}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass183()
{
    // Name = Kaithi, number of codePoints: 67
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x110cd}),
        std::initializer_list<CharacterRange>({{0x11080, 0x110c1}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass184()
{
    // Name = Batak, number of codePoints: 56
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1bc0, 0x1bf3}, {0x1bfc, 0x1bff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass185()
{
    // Name = Brahmi, number of codePoints: 109
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1107f}),
        std::initializer_list<CharacterRange>({{0x11000, 0x1104d}, {0x11052, 0x1106f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass186()
{
    // Name = Mandaic, number of codePoints: 29
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x085e}),
        std::initializer_list<CharacterRange>({{0x0840, 0x085b}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass187()
{
    // Name = Chakma, number of codePoints: 70
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11100, 0x11134}, {0x11136, 0x11146}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass188()
{
    // Name = Meroitic_Cursive, number of codePoints: 90
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x109a0, 0x109b7}, {0x109bc, 0x109cf}, {0x109d2, 0x109ff}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass189()
{
    // Name = Meroitic_Hieroglyphs, number of codePoints: 32
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10980, 0x1099f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass190()
{
    // Name = Miao, number of codePoints: 133
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x16f00, 0x16f44}, {0x16f50, 0x16f7e}, {0x16f8f, 0x16f9f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass191()
{
    // Name = Sharada, number of codePoints: 94
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11180, 0x111cd}, {0x111d0, 0x111df}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass192()
{
    // Name = Sora_Sompeng, number of codePoints: 35
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x110d0, 0x110e8}, {0x110f0, 0x110f9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass193()
{
    // Name = Takri, number of codePoints: 66
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11680, 0x116b7}, {0x116c0, 0x116c9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass194()
{
    // Name = Caucasian_Albanian, number of codePoints: 53
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1056f}),
        std::initializer_list<CharacterRange>({{0x10530, 0x10563}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass195()
{
    // Name = Bassa_Vah, number of codePoints: 36
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x16ad0, 0x16aed}, {0x16af0, 0x16af5}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass196()
{
    // Name = Duployan, number of codePoints: 143
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, 
                 {0x1bc9c, 0x1bc9f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass197()
{
    // Name = Elbasan, number of codePoints: 40
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10500, 0x10527}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass198()
{
    // Name = Grantha, number of codePoints: 85
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x11350, 0x11357}),
        std::initializer_list<CharacterRange>({{0x11300, 0x11303}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, 
                 {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133c, 0x11344}, 
                 {0x11347, 0x11348}, {0x1134b, 0x1134d}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, 
                 {0x11370, 0x11374}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass199()
{
    // Name = Pahawh_Hmong, number of codePoints: 127
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x16b00, 0x16b45}, {0x16b50, 0x16b59}, {0x16b5b, 0x16b61}, {0x16b63, 0x16b77}, 
                 {0x16b7d, 0x16b8f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass200()
{
    // Name = Khojki, number of codePoints: 62
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11200, 0x11211}, {0x11213, 0x1123e}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass201()
{
    // Name = Linear_A, number of codePoints: 341
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass202()
{
    // Name = Mahajani, number of codePoints: 39
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11150, 0x11176}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass203()
{
    // Name = Manichaean, number of codePoints: 51
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10ac0, 0x10ae6}, {0x10aeb, 0x10af6}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass204()
{
    // Name = Mende_Kikakui, number of codePoints: 213
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1e800, 0x1e8c4}, {0x1e8c7, 0x1e8d6}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass205()
{
    // Name = Modi, number of codePoints: 79
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11600, 0x11644}, {0x11650, 0x11659}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass206()
{
    // Name = Mro, number of codePoints: 43
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a6e, 0x16a6f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass207()
{
    // Name = Old_North_Arabian, number of codePoints: 32
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10a80, 0x10a9f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass208()
{
    // Name = Nabataean, number of codePoints: 40
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10880, 0x1089e}, {0x108a7, 0x108af}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass209()
{
    // Name = Palmyrene, number of codePoints: 32
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10860, 0x1087f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass210()
{
    // Name = Pau_Cin_Hau, number of codePoints: 57
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11ac0, 0x11af8}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass211()
{
    // Name = Old_Permic, number of codePoints: 43
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10350, 0x1037a}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass212()
{
    // Name = Psalter_Pahlavi, number of codePoints: 29
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10b80, 0x10b91}, {0x10b99, 0x10b9c}, {0x10ba9, 0x10baf}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass213()
{
    // Name = Siddham, number of codePoints: 92
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11580, 0x115b5}, {0x115b8, 0x115dd}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass214()
{
    // Name = Khudawadi, number of codePoints: 69
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x112b0, 0x112ea}, {0x112f0, 0x112f9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass215()
{
    // Name = Tirhuta, number of codePoints: 82
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11480, 0x114c7}, {0x114d0, 0x114d9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass216()
{
    // Name = Warang_Citi, number of codePoints: 84
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x118ff}),
        std::initializer_list<CharacterRange>({{0x118a0, 0x118f2}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass217()
{
    // Name = Ahom, number of codePoints: 58
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x1173f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass218()
{
    // Name = Anatolian_Hieroglyphs, number of codePoints: 583
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x14400, 0x14646}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass219()
{
    // Name = Hatran, number of codePoints: 26
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x108fb, 0x108ff}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass220()
{
    // Name = Multani, number of codePoints: 38
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x11288}),
        std::initializer_list<CharacterRange>({{0x11280, 0x11286}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass221()
{
    // Name = Old_Hungarian, number of codePoints: 108
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10cfa, 0x10cff}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass222()
{
    // Name = SignWriting, number of codePoints: 672
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1d800, 0x1da8b}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass223()
{
    // Name = Adlam, number of codePoints: 87
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1e900, 0x1e94a}, {0x1e950, 0x1e959}, {0x1e95e, 0x1e95f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass224()
{
    // Name = Bhaiksuki, number of codePoints: 97
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c45}, {0x11c50, 0x11c6c}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass225()
{
    // Name = Marchen, number of codePoints: 68
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11c70, 0x11c8f}, {0x11c92, 0x11ca7}, {0x11ca9, 0x11cb6}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass226()
{
    // Name = Newa, number of codePoints: 93
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1145b}),
        std::initializer_list<CharacterRange>({{0x11400, 0x11459}, {0x1145d, 0x1145e}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass227()
{
    // Name = Osage, number of codePoints: 72
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x104b0, 0x104d3}, {0x104d8, 0x104fb}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass228()
{
    // Name = Tangut, number of codePoints: 6886
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x16fe0}),
        std::initializer_list<CharacterRange>({{0x17000, 0x187f1}, {0x18800, 0x18af2}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass229()
{
    // Name = Masaram_Gondi, number of codePoints: 75
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x11d3a}),
        std::initializer_list<CharacterRange>({{0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3c, 0x11d3d}, 
                 {0x11d3f, 0x11d47}, {0x11d50, 0x11d59}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass230()
{
    // Name = Nushu, number of codePoints: 397
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x16fe1}),
        std::initializer_list<CharacterRange>({{0x1b170, 0x1b2fb}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass231()
{
    // Name = Soyombo, number of codePoints: 81
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11a50, 0x11a83}, {0x11a86, 0x11aa2}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass232()
{
    // Name = Zanabazar_Square, number of codePoints: 72
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11a00, 0x11a47}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass233()
{
    // Name = Dogra, number of codePoints: 60
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11800, 0x1183b}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass234()
{
    // Name = Gunjala_Gondi, number of codePoints: 63
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, 
                 {0x11d93, 0x11d98}, {0x11da0, 0x11da9}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass235()
{
    // Name = Makasar, number of codePoints: 25
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x11ee0, 0x11ef8}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass236()
{
    // Name = Medefaidrin, number of codePoints: 91
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x16e40, 0x16e9a}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass237()
{
    // Name = Hanifi_Rohingya, number of codePoints: 50
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10d00, 0x10d27}, {0x10d30, 0x10d39}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass238()
{
    // Name = Sogdian, number of codePoints: 42
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10f30, 0x10f59}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass239()
{
    // Name = Old_Sogdian, number of codePoints: 40
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10f00, 0x10f27}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass240()
{
    // Name = Common, number of codePoints: 7209
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x00, 0x40}, {0x5b, 0x60}, {0x7b, 0x7f}}),
        std::initializer_list<UChar32>({0x00d7, 0x00f7, 0x0374, 0x037e, 0x0385, 0x0387, 0x0605, 0x06dd, 
                 0x08e2, 0x0e3f, 0x3000, 0x3004, 0x3012, 0x3020, 0x3036, 0x327f, 
                 0x33ff, 0xab5b, 0xfeff, 0x1d4a2, 0x1d4bb, 0x1d546, 0x1f97a, 0xe0001}),
        std::initializer_list<CharacterRange>({{0x0080, 0x00a9}, {0x00ab, 0x00b9}, {0x00bb, 0x00bf}, {0x02b9, 0x02df}, 
                 {0x02e5, 0x02e9}, {0x02ec, 0x02ff}, {0x0fd5, 0x0fd8}, {0x16eb, 0x16ed}, 
                 {0x2000, 0x200b}, {0x200e, 0x2064}, {0x2066, 0x2070}, {0x2074, 0x207e}, 
                 {0x2080, 0x208e}, {0x20a0, 0x20bf}, {0x2100, 0x2125}, {0x2127, 0x2129}, 
                 {0x212c, 0x2131}, {0x2133, 0x214d}, {0x214f, 0x215f}, {0x2189, 0x218b}, 
                 {0x2190, 0x2426}, {0x2440, 0x244a}, {0x2460, 0x27ff}, {0x2900, 0x2b73}, 
                 {0x2b76, 0x2b95}, {0x2b98, 0x2bc8}, {0x2bca, 0x2bfe}, {0x2e00, 0x2e42}, 
                 {0x2e44, 0x2e4e}, {0x2ff0, 0x2ffb}, {0x3248, 0x325f}, {0x32b1, 0x32bf}, 
                 {0x32cc, 0x32cf}, {0x3371, 0x337a}, {0x3380, 0x33df}, {0x4dc0, 0x4dff}, 
                 {0xa700, 0xa721}, {0xa788, 0xa78a}, {0xfd3e, 0xfd3f}, {0xfe10, 0xfe19}, 
                 {0xfe30, 0xfe44}, {0xfe47, 0xfe52}, {0xfe54, 0xfe66}, {0xfe68, 0xfe6b}, 
                 {0xff01, 0xff20}, {0xff3b, 0xff40}, {0xff5b, 0xff60}, {0xffe0, 0xffe6}, 
                 {0xffe8, 0xffee}, {0xfff9, 0xfffd}, {0x10190, 0x1019b}, {0x101d0, 0x101fc}, 
                 {0x1d000, 0x1d0f5}, {0x1d100, 0x1d126}, {0x1d129, 0x1d166}, {0x1d16a, 0x1d17a}, 
                 {0x1d183, 0x1d184}, {0x1d18c, 0x1d1a9}, {0x1d1ae, 0x1d1e8}, {0x1d2e0, 0x1d2f3}, 
                 {0x1d300, 0x1d356}, {0x1d372, 0x1d378}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, 
                 {0x1d49e, 0x1d49f}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, 
                 {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, 
                 {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, 
                 {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, 
                 {0x1ec71, 0x1ecb4}, {0x1f000, 0x1f02b}, {0x1f030, 0x1f093}, {0x1f0a0, 0x1f0ae}, 
                 {0x1f0b1, 0x1f0bf}, {0x1f0c1, 0x1f0cf}, {0x1f0d1, 0x1f0f5}, {0x1f100, 0x1f10c}, 
                 {0x1f110, 0x1f16b}, {0x1f170, 0x1f1ac}, {0x1f1e6, 0x1f1ff}, {0x1f201, 0x1f202}, 
                 {0x1f210, 0x1f23b}, {0x1f240, 0x1f248}, {0x1f260, 0x1f265}, {0x1f300, 0x1f6d4}, 
                 {0x1f6e0, 0x1f6ec}, {0x1f6f0, 0x1f6f9}, {0x1f700, 0x1f773}, {0x1f780, 0x1f7d8}, 
                 {0x1f800, 0x1f80b}, {0x1f810, 0x1f847}, {0x1f850, 0x1f859}, {0x1f860, 0x1f887}, 
                 {0x1f890, 0x1f8ad}, {0x1f900, 0x1f90b}, {0x1f910, 0x1f93e}, {0x1f940, 0x1f970}, 
                 {0x1f973, 0x1f976}, {0x1f97c, 0x1f9a2}, {0x1f9b0, 0x1f9b9}, {0x1f9c0, 0x1f9c2}, 
                 {0x1f9d0, 0x1f9ff}, {0x1fa60, 0x1fa6d}, {0xe0020, 0xe007f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass241()
{
    // Name = Inherited, number of codePoints: 514
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x101fd}),
        std::initializer_list<CharacterRange>({{0x0300, 0x0341}, {0x0343, 0x0344}, {0x0346, 0x0362}, {0x1ab0, 0x1abe}, 
                 {0x1dc2, 0x1df9}, {0x1dfb, 0x1dff}, {0x200c, 0x200d}, {0x20d0, 0x20ef}, 
                 {0xfe00, 0xfe0f}, {0xfe20, 0xfe2d}, {0x1d167, 0x1d169}, {0x1d17b, 0x1d182}, 
                 {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0xe0100, 0xe01ef}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass242()
{
    // Name = Bengali, number of codePoints: 112
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x09b2, 0x09d7, 0x1cd0, 0x1cd2, 0x1cd8, 0x1ce1, 0x1cea, 0x1ced, 
                 0xa8f1}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0980, 0x0983}, {0x0985, 0x098c}, 
                 {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, {0x09b6, 0x09b9}, 
                 {0x09bc, 0x09c4}, {0x09c7, 0x09c8}, {0x09cb, 0x09ce}, {0x09dc, 0x09dd}, 
                 {0x09df, 0x09e3}, {0x09e6, 0x09fe}, {0x1cd5, 0x1cd6}, {0x1cf5, 0x1cf7}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass243()
{
    // Name = Devanagari, number of codePoints: 212
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x20f0}),
        std::initializer_list<CharacterRange>({{0x0900, 0x097f}, {0x1cd0, 0x1cf6}, {0x1cf8, 0x1cf9}, {0xa830, 0xa839}, 
                 {0xa8e0, 0xa8ff}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass244()
{
    // Name = Duployan, number of codePoints: 147
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, 
                 {0x1bc9c, 0x1bca3}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass245()
{
    // Name = Greek, number of codePoints: 522
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0342, 0x0345, 0x037f, 0x0384, 0x0386, 0x038c, 0x1f59, 0x1f5b, 
                 0x1f5d, 0x2126, 0xab65, 0x101a0}),
        std::initializer_list<CharacterRange>({{0x0370, 0x0373}, {0x0375, 0x0377}, {0x037a, 0x037d}, {0x0388, 0x038a}, 
                 {0x038e, 0x03a1}, {0x03a3, 0x03e1}, {0x03f0, 0x03ff}, {0x1d26, 0x1d2a}, 
                 {0x1d5d, 0x1d61}, {0x1d66, 0x1d6a}, {0x1dbf, 0x1dc1}, {0x1f00, 0x1f15}, 
                 {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, 
                 {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fc4}, {0x1fc6, 0x1fd3}, 
                 {0x1fd6, 0x1fdb}, {0x1fdd, 0x1fef}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffe}, 
                 {0x10140, 0x1018e}, {0x1d200, 0x1d245}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass246()
{
    // Name = Han, number of codePoints: 89512
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x3003, 0x3030, 0x30fb}),
        std::initializer_list<CharacterRange>({{0x2e80, 0x2e99}, {0x2e9b, 0x2ef3}, {0x2f00, 0x2fd5}, {0x3001, 0x3002}, 
                 {0x3005, 0x3011}, {0x3013, 0x301f}, {0x3021, 0x302d}, {0x3037, 0x303f}, 
                 {0x3190, 0x319f}, {0x31c0, 0x31e3}, {0x3220, 0x3247}, {0x3280, 0x32b0}, 
                 {0x32c0, 0x32cb}, {0x3358, 0x3370}, {0x337b, 0x337f}, {0x33e0, 0x33fe}, 
                 {0x3400, 0x4db5}, {0x4e00, 0x9fef}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, 
                 {0xfe45, 0xfe46}, {0xff61, 0xff65}, {0x1d360, 0x1d371}, {0x1f250, 0x1f251}, 
                 {0x20000, 0x2a6d6}, {0x2a700, 0x2b734}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, 
                 {0x2ceb0, 0x2ebe0}, {0x2f800, 0x2fa1d}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass247()
{
    // Name = Latin, number of codePoints: 1373
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x41, 0x5a}, {0x61, 0x7a}}),
        std::initializer_list<UChar32>({0x00aa, 0x00ba, 0x10fb, 0x2071, 0x207f, 0x20f0, 0x2132, 0x214e, 
                 0xa92e}),
        std::initializer_list<CharacterRange>({{0x00c0, 0x00d6}, {0x00d8, 0x00f6}, {0x00f8, 0x02b8}, {0x02e0, 0x02e4}, 
                 {0x0363, 0x036f}, {0x0485, 0x0486}, {0x0951, 0x0952}, {0x1d00, 0x1d25}, 
                 {0x1d2c, 0x1d5c}, {0x1d62, 0x1d65}, {0x1d6b, 0x1d77}, {0x1d79, 0x1dbe}, 
                 {0x1e00, 0x1eff}, {0x2090, 0x209c}, {0x212a, 0x212b}, {0x2160, 0x2188}, 
                 {0x2c60, 0x2c7f}, {0xa722, 0xa787}, {0xa78b, 0xa7b9}, {0xa7f7, 0xa7ff}, 
                 {0xab30, 0xab5a}, {0xab5c, 0xab64}, {0xfb00, 0xfb06}, {0xff21, 0xff3a}, 
                 {0xff41, 0xff5a}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass248()
{
    // Name = Arabic, number of codePoints: 1325
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1ee24, 0x1ee27, 0x1ee39, 0x1ee3b, 0x1ee42, 0x1ee47, 0x1ee49, 0x1ee4b, 
                 0x1ee54, 0x1ee57, 0x1ee59, 0x1ee5b, 0x1ee5d, 0x1ee5f, 0x1ee64, 0x1ee7e}),
        std::initializer_list<CharacterRange>({{0x0600, 0x0604}, {0x0606, 0x061c}, {0x061e, 0x06dc}, {0x06de, 0x06ff}, 
                 {0x0750, 0x077f}, {0x08a0, 0x08b4}, {0x08b6, 0x08bd}, {0x08d3, 0x08e1}, 
                 {0x08e3, 0x08ff}, {0xfb50, 0xfbc1}, {0xfbd3, 0xfd3d}, {0xfd50, 0xfd8f}, 
                 {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfd}, {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, 
                 {0x102e0, 0x102fb}, {0x10e60, 0x10e7e}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, 
                 {0x1ee21, 0x1ee22}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee4d, 0x1ee4f}, 
                 {0x1ee51, 0x1ee52}, {0x1ee61, 0x1ee62}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, 
                 {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, 
                 {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1eef0, 0x1eef1}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass249()
{
    // Name = Coptic, number of codePoints: 165
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x03e2, 0x03ef}, {0x2c80, 0x2cf3}, {0x2cf9, 0x2cff}, {0x102e0, 0x102fb}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass250()
{
    // Name = Hanifi_Rohingya, number of codePoints: 55
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x060c, 0x061b, 0x061f, 0x0640, 0x06d4}),
        std::initializer_list<CharacterRange>({{0x10d00, 0x10d27}, {0x10d30, 0x10d39}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass251()
{
    // Name = Syriac, number of codePoints: 105
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x060c, 0x061f, 0x0640, 0x0670}),
        std::initializer_list<CharacterRange>({{0x061b, 0x061c}, {0x064b, 0x0655}, {0x0700, 0x070d}, {0x070f, 0x074a}, 
                 {0x074d, 0x074f}, {0x0860, 0x086a}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass252()
{
    // Name = Thaana, number of codePoints: 66
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x060c, 0x061f, 0xfdf2, 0xfdfd}),
        std::initializer_list<CharacterRange>({{0x061b, 0x061c}, {0x0660, 0x0669}, {0x0780, 0x07b1}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass253()
{
    // Name = Armenian, number of codePoints: 96
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0531, 0x0556}, {0x0559, 0x058a}, {0x058d, 0x058f}, {0xfb13, 0xfb17}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass254()
{
    // Name = Georgian, number of codePoints: 175
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0589, 0x10c7, 0x10cd, 0x2d27, 0x2d2d}),
        std::initializer_list<CharacterRange>({{0x10a0, 0x10c5}, {0x10d0, 0x10ff}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, 
                 {0x2d00, 0x2d25}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass255()
{
    // Name = Bopomofo, number of codePoints: 112
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x3003, 0x3030, 0x3037, 0x30fb}),
        std::initializer_list<CharacterRange>({{0x02ea, 0x02eb}, {0x3001, 0x3002}, {0x3008, 0x3011}, {0x3013, 0x301f}, 
                 {0x302a, 0x302d}, {0x3105, 0x312f}, {0x31a0, 0x31ba}, {0xfe45, 0xfe46}, 
                 {0xff61, 0xff65}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass256()
{
    // Name = Buginese, number of codePoints: 31
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0xa9cf}),
        std::initializer_list<CharacterRange>({{0x1a00, 0x1a1b}, {0x1a1e, 0x1a1f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass257()
{
    // Name = Javanese, number of codePoints: 91
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xa980, 0xa9cd}, {0xa9cf, 0xa9d9}, {0xa9de, 0xa9df}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass258()
{
    // Name = Cypriot, number of codePoints: 112
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x10808, 0x1083c, 0x1083f}),
        std::initializer_list<CharacterRange>({{0x10100, 0x10102}, {0x10107, 0x10133}, {0x10137, 0x1013f}, {0x10800, 0x10805}, 
                 {0x1080a, 0x10835}, {0x10837, 0x10838}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass259()
{
    // Name = Linear_B, number of codePoints: 268
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, 
                 {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10100, 0x10102}, 
                 {0x10107, 0x10133}, {0x10137, 0x1013f}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass260()
{
    // Name = Cyrillic, number of codePoints: 446
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1d2b, 0x1d78, 0x2e43}),
        std::initializer_list<CharacterRange>({{0x0400, 0x052f}, {0x1c80, 0x1c88}, {0x2de0, 0x2dff}, {0xa640, 0xa69f}, 
                 {0xfe2e, 0xfe2f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass261()
{
    // Name = Glagolitic, number of codePoints: 136
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0484, 0x0487, 0x2e43, 0xa66f}),
        std::initializer_list<CharacterRange>({{0x2c00, 0x2c2e}, {0x2c30, 0x2c5e}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018}, 
                 {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass262()
{
    // Name = Old_Permic, number of codePoints: 44
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0483}),
        std::initializer_list<CharacterRange>({{0x10350, 0x1037a}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass263()
{
    // Name = Grantha, number of codePoints: 113
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1cd0, 0x20f0, 0x11350, 0x11357}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0be6, 0x0bf3}, {0x1cd2, 0x1cd3}, 
                 {0x1cf2, 0x1cf4}, {0x1cf8, 0x1cf9}, {0x11300, 0x11303}, {0x11305, 0x1130c}, 
                 {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, 
                 {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d}, 
                 {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass264()
{
    // Name = Sharada, number of codePoints: 100
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0951, 0x1cd7, 0x1cd9, 0x1ce0}),
        std::initializer_list<CharacterRange>({{0x1cdc, 0x1cdd}, {0x11180, 0x111cd}, {0x111d0, 0x111df}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass265()
{
    // Name = Tamil, number of codePoints: 82
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0b9c, 0x0bd0, 0x0bd7, 0x1cda, 0xa8f3, 0x11301, 0x11303}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0b82, 0x0b83}, {0x0b85, 0x0b8a}, 
                 {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9e, 0x0b9f}, 
                 {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, {0x0bbe, 0x0bc2}, 
                 {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd}, {0x0be6, 0x0bfa}, {0x1133b, 0x1133c}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass266()
{
    // Name = Gujarati, number of codePoints: 105
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0ad0}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0a81, 0x0a83}, {0x0a85, 0x0a8d}, 
                 {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, 
                 {0x0ab5, 0x0ab9}, {0x0abc, 0x0ac5}, {0x0ac7, 0x0ac9}, {0x0acb, 0x0acd}, 
                 {0x0ae0, 0x0ae3}, {0x0ae6, 0x0af1}, {0x0af9, 0x0aff}, {0xa830, 0xa839}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass267()
{
    // Name = Khojki, number of codePoints: 82
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0ae6, 0x0aef}, {0xa830, 0xa839}, {0x11200, 0x11211}, {0x11213, 0x1123e}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass268()
{
    // Name = Gurmukhi, number of codePoints: 94
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0a3c, 0x0a51, 0x0a5e}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0a01, 0x0a03}, {0x0a05, 0x0a0a}, 
                 {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, 
                 {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, 
                 {0x0a4b, 0x0a4d}, {0x0a59, 0x0a5c}, {0x0a66, 0x0a76}, {0xa830, 0xa839}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass269()
{
    // Name = Multani, number of codePoints: 48
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x11288}),
        std::initializer_list<CharacterRange>({{0x0a66, 0x0a6f}, {0x11280, 0x11286}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, 
                 {0x1129f, 0x112a9}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass270()
{
    // Name = Hiragana, number of codePoints: 428
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x3003, 0x3037, 0xff70, 0x1f200}),
        std::initializer_list<CharacterRange>({{0x3001, 0x3002}, {0x3008, 0x3011}, {0x3013, 0x301f}, {0x3030, 0x3035}, 
                 {0x303c, 0x303d}, {0x3041, 0x3096}, {0x3099, 0x30a0}, {0x30fb, 0x30fc}, 
                 {0xfe45, 0xfe46}, {0xff61, 0xff65}, {0xff9e, 0xff9f}, {0x1b001, 0x1b11e}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass271()
{
    // Name = Katakana, number of codePoints: 352
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x3003, 0x3037, 0x1b000}),
        std::initializer_list<CharacterRange>({{0x3001, 0x3002}, {0x3008, 0x3011}, {0x3013, 0x301f}, {0x3030, 0x3035}, 
                 {0x303c, 0x303d}, {0x3099, 0x309c}, {0x30a0, 0x30ff}, {0x31f0, 0x31ff}, 
                 {0x32d0, 0x32fe}, {0x3300, 0x3357}, {0xfe45, 0xfe46}, {0xff61, 0xff9f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass272()
{
    // Name = Mongolian, number of codePoints: 170
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1800, 0x180e}, {0x1810, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, 
                 {0x11660, 0x1166c}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass273()
{
    // Name = Phags_Pa, number of codePoints: 59
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1805}),
        std::initializer_list<CharacterRange>({{0x1802, 0x1803}, {0xa840, 0xa877}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass274()
{
    // Name = Chakma, number of codePoints: 90
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x09e6, 0x09ef}, {0x1040, 0x1049}, {0x11100, 0x11134}, {0x11136, 0x11146}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass275()
{
    // Name = Syloti_Nagri, number of codePoints: 56
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0964, 0x0965}, {0x09e6, 0x09ef}, {0xa800, 0xa82b}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass276()
{
    // Name = Myanmar, number of codePoints: 224
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0xa92e}),
        std::initializer_list<CharacterRange>({{0x1000, 0x109f}, {0xa9e0, 0xa9fe}, {0xaa60, 0xaa7f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass277()
{
    // Name = Tai_Le, number of codePoints: 45
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1040, 0x1049}, {0x1950, 0x196d}, {0x1970, 0x1974}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass278()
{
    // Name = Linear_A, number of codePoints: 386
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x10107, 0x10133}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}}),
        CharacterClassWidths::HasNonBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass279()
{
    // Name = Kannada, number of codePoints: 103
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0cde, 0x1cd0, 0x1cd2, 0x1cda, 0x1cf4}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0c80, 0x0c8c}, {0x0c8e, 0x0c90}, 
                 {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0cbc, 0x0cc4}, 
                 {0x0cc6, 0x0cc8}, {0x0cca, 0x0ccd}, {0x0cd5, 0x0cd6}, {0x0ce0, 0x0ce3}, 
                 {0x0ce6, 0x0cef}, {0x0cf1, 0x0cf2}, {0xa830, 0xa835}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass280()
{
    // Name = Kayah_Li, number of codePoints: 48
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xa900, 0xa92f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass281()
{
    // Name = Buhid, number of codePoints: 22
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1735, 0x1736}, {0x1740, 0x1753}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass282()
{
    // Name = Hanunoo, number of codePoints: 23
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1720, 0x1736}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass283()
{
    // Name = Tagbanwa, number of codePoints: 20
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1735, 0x1736}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass284()
{
    // Name = Tagalog, number of codePoints: 22
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x1700, 0x170c}, {0x170e, 0x1714}, {0x1735, 0x1736}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass285()
{
    // Name = Dogra, number of codePoints: 82
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0964, 0x096f}, {0xa830, 0xa839}, {0x11800, 0x1183b}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass286()
{
    // Name = Kaithi, number of codePoints: 87
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x110cd}),
        std::initializer_list<CharacterRange>({{0x0966, 0x096f}, {0xa830, 0xa839}, {0x11080, 0x110c1}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass287()
{
    // Name = Mahajani, number of codePoints: 61
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0964, 0x096f}, {0xa830, 0xa839}, {0x11150, 0x11176}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass288()
{
    // Name = Hangul, number of codePoints: 11775
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x3003, 0x3037, 0x30fb}),
        std::initializer_list<CharacterRange>({{0x1100, 0x11ff}, {0x3001, 0x3002}, {0x3008, 0x3011}, {0x3013, 0x301f}, 
                 {0x302e, 0x3030}, {0x3131, 0x318e}, {0x3200, 0x321e}, {0x3260, 0x327e}, 
                 {0xa960, 0xa97c}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, 
                 {0xfe45, 0xfe46}, {0xff61, 0xff65}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, 
                 {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass289()
{
    // Name = Yi, number of codePoints: 1246
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x30fb}),
        std::initializer_list<CharacterRange>({{0x3001, 0x3002}, {0x3008, 0x3011}, {0x3014, 0x301b}, {0xa000, 0xa48c}, 
                 {0xa490, 0xa4c6}, {0xff61, 0xff65}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass290()
{
    // Name = Malayalam, number of codePoints: 125
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1cda}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0d00, 0x0d03}, {0x0d05, 0x0d0c}, 
                 {0x0d0e, 0x0d10}, {0x0d12, 0x0d44}, {0x0d46, 0x0d48}, {0x0d4a, 0x0d4f}, 
                 {0x0d54, 0x0d63}, {0x0d66, 0x0d7f}, {0xa830, 0xa832}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass291()
{
    // Name = Oriya, number of codePoints: 95
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1cda}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, 
                 {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, 
                 {0x0b35, 0x0b39}, {0x0b3c, 0x0b44}, {0x0b47, 0x0b48}, {0x0b4b, 0x0b4d}, 
                 {0x0b56, 0x0b57}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b63}, {0x0b66, 0x0b77}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass292()
{
    // Name = Telugu, number of codePoints: 102
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x1cda}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0x0c00, 0x0c0c}, {0x0c0e, 0x0c10}, 
                 {0x0c12, 0x0c28}, {0x0c2a, 0x0c39}, {0x0c3d, 0x0c44}, {0x0c46, 0x0c48}, 
                 {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56}, {0x0c58, 0x0c5a}, {0x0c60, 0x0c63}, 
                 {0x0c66, 0x0c6f}, {0x0c78, 0x0c7f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass293()
{
    // Name = Adlam, number of codePoints: 88
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0640}),
        std::initializer_list<CharacterRange>({{0x1e900, 0x1e94a}, {0x1e950, 0x1e959}, {0x1e95e, 0x1e95f}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass294()
{
    // Name = Mandaic, number of codePoints: 30
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0640, 0x085e}),
        std::initializer_list<CharacterRange>({{0x0840, 0x085b}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass295()
{
    // Name = Manichaean, number of codePoints: 52
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0640}),
        std::initializer_list<CharacterRange>({{0x10ac0, 0x10ae6}, {0x10aeb, 0x10af6}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass296()
{
    // Name = Psalter_Pahlavi, number of codePoints: 30
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0640}),
        std::initializer_list<CharacterRange>({{0x10b80, 0x10b91}, {0x10b99, 0x10b9c}, {0x10ba9, 0x10baf}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass297()
{
    // Name = Sogdian, number of codePoints: 43
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0640}),
        std::initializer_list<CharacterRange>({{0x10f30, 0x10f59}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass298()
{
    // Name = Modi, number of codePoints: 89
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0xa830, 0xa839}, {0x11600, 0x11644}, {0x11650, 0x11659}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass299()
{
    // Name = Khudawadi, number of codePoints: 81
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0964, 0x0965}, {0xa830, 0xa839}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass300()
{
    // Name = Takri, number of codePoints: 78
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0964, 0x0965}, {0xa830, 0xa839}, {0x11680, 0x116b7}, {0x116c0, 0x116c9}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass301()
{
    // Name = Tirhuta, number of codePoints: 96
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0951, 0x0952}, {0x0964, 0x0965}, {0xa830, 0xa839}, {0x11480, 0x114c7}, 
                 {0x114d0, 0x114d9}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass302()
{
    // Name = Gunjala_Gondi, number of codePoints: 65
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({{0x0964, 0x0965}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, 
                 {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass303()
{
    // Name = Sinhala, number of codePoints: 112
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0dbd, 0x0dca, 0x0dd6}),
        std::initializer_list<CharacterRange>({{0x0964, 0x0965}, {0x0d82, 0x0d83}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, 
                 {0x0db3, 0x0dbb}, {0x0dc0, 0x0dc6}, {0x0dcf, 0x0dd4}, {0x0dd8, 0x0ddf}, 
                 {0x0de6, 0x0def}, {0x0df2, 0x0df4}, {0x111e1, 0x111f4}}),
        CharacterClassWidths::HasBothBMPAndNonBMP);
    return characterClass;
}

static std::unique_ptr<CharacterClass> createCharacterClass304()
{
    // Name = Limbu, number of codePoints: 69
    auto characterClass = makeUnique<CharacterClass>(
        std::initializer_list<UChar32>({}),
        std::initializer_list<CharacterRange>({}),
        std::initializer_list<UChar32>({0x0965, 0x1940}),
        std::initializer_list<CharacterRange>({{0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b}, {0x1944, 0x194f}}),
        CharacterClassWidths::HasBMPChars);
    return characterClass;
}

typedef std::unique_ptr<CharacterClass> (*CreateCharacterClass)();
static CreateCharacterClass createFunctions[305] = {
    createCharacterClass0, createCharacterClass1, createCharacterClass2, createCharacterClass3,
    createCharacterClass4, createCharacterClass5, createCharacterClass6, createCharacterClass7,
    createCharacterClass8, createCharacterClass9, createCharacterClass10, createCharacterClass11,
    createCharacterClass12, createCharacterClass13, createCharacterClass14, createCharacterClass15,
    createCharacterClass16, createCharacterClass17, createCharacterClass18, createCharacterClass19,
    createCharacterClass20, createCharacterClass21, createCharacterClass22, createCharacterClass23,
    createCharacterClass24, createCharacterClass25, createCharacterClass26, createCharacterClass27,
    createCharacterClass28, createCharacterClass29, createCharacterClass30, createCharacterClass31,
    createCharacterClass32, createCharacterClass33, createCharacterClass34, createCharacterClass35,
    createCharacterClass36, createCharacterClass37, createCharacterClass38, createCharacterClass39,
    createCharacterClass40, createCharacterClass41, createCharacterClass42, createCharacterClass43,
    createCharacterClass44, createCharacterClass45, createCharacterClass46, createCharacterClass47,
    createCharacterClass48, createCharacterClass49, createCharacterClass50, createCharacterClass51,
    createCharacterClass52, createCharacterClass53, createCharacterClass54, createCharacterClass55,
    createCharacterClass56, createCharacterClass57, createCharacterClass58, createCharacterClass59,
    createCharacterClass60, createCharacterClass61, createCharacterClass62, createCharacterClass63,
    createCharacterClass64, createCharacterClass65, createCharacterClass66, createCharacterClass67,
    createCharacterClass68, createCharacterClass69, createCharacterClass70, createCharacterClass71,
    createCharacterClass72, createCharacterClass73, createCharacterClass74, createCharacterClass75,
    createCharacterClass76, createCharacterClass77, createCharacterClass78, createCharacterClass79,
    createCharacterClass80, createCharacterClass81, createCharacterClass82, createCharacterClass83,
    createCharacterClass84, createCharacterClass85, createCharacterClass86, createCharacterClass87,
    createCharacterClass88, createCharacterClass89, createCharacterClass90, createCharacterClass91,
    createCharacterClass92, createCharacterClass93, createCharacterClass94, createCharacterClass95,
    createCharacterClass96, createCharacterClass97, createCharacterClass98, createCharacterClass99,
    createCharacterClass100, createCharacterClass101, createCharacterClass102, createCharacterClass103,
    createCharacterClass104, createCharacterClass105, createCharacterClass106, createCharacterClass107,
    createCharacterClass108, createCharacterClass109, createCharacterClass110, createCharacterClass111,
    createCharacterClass112, createCharacterClass113, createCharacterClass114, createCharacterClass115,
    createCharacterClass116, createCharacterClass117, createCharacterClass118, createCharacterClass119,
    createCharacterClass120, createCharacterClass121, createCharacterClass122, createCharacterClass123,
    createCharacterClass124, createCharacterClass125, createCharacterClass126, createCharacterClass127,
    createCharacterClass128, createCharacterClass129, createCharacterClass130, createCharacterClass131,
    createCharacterClass132, createCharacterClass133, createCharacterClass134, createCharacterClass135,
    createCharacterClass136, createCharacterClass137, createCharacterClass138, createCharacterClass139,
    createCharacterClass140, createCharacterClass141, createCharacterClass142, createCharacterClass143,
    createCharacterClass144, createCharacterClass145, createCharacterClass146, createCharacterClass147,
    createCharacterClass148, createCharacterClass149, createCharacterClass150, createCharacterClass151,
    createCharacterClass152, createCharacterClass153, createCharacterClass154, createCharacterClass155,
    createCharacterClass156, createCharacterClass157, createCharacterClass158, createCharacterClass159,
    createCharacterClass160, createCharacterClass161, createCharacterClass162, createCharacterClass163,
    createCharacterClass164, createCharacterClass165, createCharacterClass166, createCharacterClass167,
    createCharacterClass168, createCharacterClass169, createCharacterClass170, createCharacterClass171,
    createCharacterClass172, createCharacterClass173, createCharacterClass174, createCharacterClass175,
    createCharacterClass176, createCharacterClass177, createCharacterClass178, createCharacterClass179,
    createCharacterClass180, createCharacterClass181, createCharacterClass182, createCharacterClass183,
    createCharacterClass184, createCharacterClass185, createCharacterClass186, createCharacterClass187,
    createCharacterClass188, createCharacterClass189, createCharacterClass190, createCharacterClass191,
    createCharacterClass192, createCharacterClass193, createCharacterClass194, createCharacterClass195,
    createCharacterClass196, createCharacterClass197, createCharacterClass198, createCharacterClass199,
    createCharacterClass200, createCharacterClass201, createCharacterClass202, createCharacterClass203,
    createCharacterClass204, createCharacterClass205, createCharacterClass206, createCharacterClass207,
    createCharacterClass208, createCharacterClass209, createCharacterClass210, createCharacterClass211,
    createCharacterClass212, createCharacterClass213, createCharacterClass214, createCharacterClass215,
    createCharacterClass216, createCharacterClass217, createCharacterClass218, createCharacterClass219,
    createCharacterClass220, createCharacterClass221, createCharacterClass222, createCharacterClass223,
    createCharacterClass224, createCharacterClass225, createCharacterClass226, createCharacterClass227,
    createCharacterClass228, createCharacterClass229, createCharacterClass230, createCharacterClass231,
    createCharacterClass232, createCharacterClass233, createCharacterClass234, createCharacterClass235,
    createCharacterClass236, createCharacterClass237, createCharacterClass238, createCharacterClass239,
    createCharacterClass240, createCharacterClass241, createCharacterClass242, createCharacterClass243,
    createCharacterClass244, createCharacterClass245, createCharacterClass246, createCharacterClass247,
    createCharacterClass248, createCharacterClass249, createCharacterClass250, createCharacterClass251,
    createCharacterClass252, createCharacterClass253, createCharacterClass254, createCharacterClass255,
    createCharacterClass256, createCharacterClass257, createCharacterClass258, createCharacterClass259,
    createCharacterClass260, createCharacterClass261, createCharacterClass262, createCharacterClass263,
    createCharacterClass264, createCharacterClass265, createCharacterClass266, createCharacterClass267,
    createCharacterClass268, createCharacterClass269, createCharacterClass270, createCharacterClass271,
    createCharacterClass272, createCharacterClass273, createCharacterClass274, createCharacterClass275,
    createCharacterClass276, createCharacterClass277, createCharacterClass278, createCharacterClass279,
    createCharacterClass280, createCharacterClass281, createCharacterClass282, createCharacterClass283,
    createCharacterClass284, createCharacterClass285, createCharacterClass286, createCharacterClass287,
    createCharacterClass288, createCharacterClass289, createCharacterClass290, createCharacterClass291,
    createCharacterClass292, createCharacterClass293, createCharacterClass294, createCharacterClass295,
    createCharacterClass296, createCharacterClass297, createCharacterClass298, createCharacterClass299,
    createCharacterClass300, createCharacterClass301, createCharacterClass302, createCharacterClass303,
    createCharacterClass304,};

// General_Category:
static const struct HashIndex generalCategoryTableIndex[152] = {
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 31, -1 },
    { 1, 128 },
    { 73, -1 },
    { 26, 139 },
    { 46, -1 },
    { -1, -1 },
    { 45, 136 },
    { -1, -1 },
    { -1, -1 },
    { 50, -1 },
    { -1, -1 },
    { 29, -1 },
    { 51, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 34, 143 },
    { 20, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 37, -1 },
    { 61, -1 },
    { 82, -1 },
    { -1, -1 },
    { 69, 148 },
    { 79, -1 },
    { 27, 144 },
    { -1, -1 },
    { -1, -1 },
    { 21, -1 },
    { 24, 146 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 58, 150 },
    { -1, -1 },
    { 10, -1 },
    { 39, 138 },
    { 40, 137 },
    { 5, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 60, -1 },
    { -1, -1 },
    { 67, -1 },
    { -1, -1 },
    { -1, -1 },
    { 16, 142 },
    { 72, 149 },
    { 71, -1 },
    { -1, -1 },
    { 12, -1 },
    { 0, -1 },
    { 54, -1 },
    { 11, 133 },
    { 43, -1 },
    { 4, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 19, -1 },
    { 30, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 2, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 6, 140 },
    { 25, -1 },
    { 48, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 59, -1 },
    { 42, 151 },
    { 8, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 18, 131 },
    { 65, -1 },
    { -1, -1 },
    { -1, -1 },
    { 28, -1 },
    { 9, -1 },
    { -1, -1 },
    { 41, -1 },
    { -1, -1 },
    { -1, -1 },
    { 22, -1 },
    { 44, 145 },
    { 13, 134 },
    { 23, 132 },
    { 77, -1 },
    { -1, -1 },
    { -1, -1 },
    { 7, -1 },
    { -1, -1 },
    { 47, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 66, -1 },
    { -1, -1 },
    { 32, -1 },
    { -1, -1 },
    { -1, -1 },
    { 15, 130 },
    { -1, -1 },
    { 3, 129 },
    { 14, -1 },
    { 17, -1 },
    { 33, -1 },
    { 35, 135 },
    { 36, -1 },
    { 38, 141 },
    { 49, 147 },
    { 52, -1 },
    { 53, -1 },
    { 55, -1 },
    { 56, -1 },
    { 57, -1 },
    { 62, -1 },
    { 63, -1 },
    { 64, -1 },
    { 68, -1 },
    { 70, -1 },
    { 74, -1 },
    { 75, -1 },
    { 76, -1 },
    { 78, -1 },
    { 80, -1 },
    { 81, -1 },
};

static const struct HashValue generalCategoryTableValue[83] = {
    { "Spacing_Mark", 35 },
    { "Mc", 35 },
    { "Modifier_Symbol", 21 },
    { "Sk", 21 },
    { "Punctuation", 10 },
    { "P", 10 },
    { "punct", 10 },
    { "Decimal_Number", 19 },
    { "Nd", 19 },
    { "digit", 19 },
    { "Other_Number", 28 },
    { "No", 28 },
    { "Mark", 32 },
    { "M", 32 },
    { "Combining_Mark", 32 },
    { "Other", 3 },
    { "C", 3 },
    { "Nonspacing_Mark", 33 },
    { "Mn", 33 },
    { "Connector_Punctuation", 22 },
    { "Pc", 22 },
    { "Private_Use", 40 },
    { "Co", 40 },
    { "Format", 27 },
    { "Cf", 27 },
    { "Line_Separator", 37 },
    { "Zl", 37 },
    { "Symbol", 12 },
    { "S", 12 },
    { "Close_Punctuation", 15 },
    { "Pe", 15 },
    { "Cased_Letter", 6 },
    { "LC", 6 },
    { "Letter", 5 },
    { "L", 5 },
    { "Titlecase_Letter", 30 },
    { "Lt", 30 },
    { "Dash_Punctuation", 17 },
    { "Pd", 17 },
    { "Open_Punctuation", 14 },
    { "Ps", 14 },
    { "Enclosing_Mark", 34 },
    { "Me", 34 },
    { "Lowercase_Letter", 23 },
    { "Ll", 23 },
    { "Letter_Number", 36 },
    { "Nl", 36 },
    { "Surrogate", 39 },
    { "Cs", 39 },
    { "Currency_Symbol", 13 },
    { "Sc", 13 },
    { "Separator", 8 },
    { "Z", 8 },
    { "Other_Symbol", 24 },
    { "So", 24 },
    { "Final_Punctuation", 29 },
    { "Pf", 29 },
    { "Paragraph_Separator", 38 },
    { "Zp", 38 },
    { "Modifier_Letter", 31 },
    { "Lm", 31 },
    { "Control", 7 },
    { "Cc", 7 },
    { "cntrl", 7 },
    { "Initial_Punctuation", 26 },
    { "Pi", 26 },
    { "Other_Letter", 25 },
    { "Lo", 25 },
    { "Number", 18 },
    { "N", 18 },
    { "Any", 0 },
    { "Assigned", 2 },
    { "Unassigned", 4 },
    { "Cn", 4 },
    { "Other_Punctuation", 11 },
    { "Po", 11 },
    { "Uppercase_Letter", 20 },
    { "Lu", 20 },
    { "Math_Symbol", 16 },
    { "Sm", 16 },
    { "ASCII", 1 },
    { "Space_Separator", 9 },
    { "Zs", 9 },
};

static const struct HashTable generalCategoryHashTable = 
    { 83, 127, generalCategoryTableValue, generalCategoryTableIndex };

// binary properties:
static const struct HashIndex binaryPropertyTableIndex[152] = {
    { -1, -1 },
    { 38, -1 },
    { 11, -1 },
    { -1, -1 },
    { -1, -1 },
    { 74, -1 },
    { -1, -1 },
    { 5, 143 },
    { -1, -1 },
    { 35, -1 },
    { 67, 150 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 9, 137 },
    { 12, 132 },
    { -1, -1 },
    { 60, -1 },
    { 73, 151 },
    { -1, -1 },
    { -1, -1 },
    { 22, -1 },
    { 7, 141 },
    { 15, -1 },
    { 24, 136 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 34, -1 },
    { -1, -1 },
    { 4, 149 },
    { 89, -1 },
    { 85, 148 },
    { 2, -1 },
    { 80, -1 },
    { -1, -1 },
    { -1, -1 },
    { 6, -1 },
    { -1, -1 },
    { 83, -1 },
    { -1, -1 },
    { 47, -1 },
    { 29, 131 },
    { 23, -1 },
    { -1, -1 },
    { -1, -1 },
    { 41, -1 },
    { 25, 142 },
    { -1, -1 },
    { -1, -1 },
    { 93, -1 },
    { 28, 138 },
    { -1, -1 },
    { 1, 146 },
    { 0, 135 },
    { 50, -1 },
    { -1, -1 },
    { 48, -1 },
    { 66, -1 },
    { -1, -1 },
    { 42, 134 },
    { 33, -1 },
    { 51, -1 },
    { 68, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 56, -1 },
    { 31, -1 },
    { 71, -1 },
    { 77, -1 },
    { 59, 144 },
    { -1, -1 },
    { 10, -1 },
    { -1, -1 },
    { 70, -1 },
    { 36, -1 },
    { -1, -1 },
    { 19, -1 },
    { -1, -1 },
    { 17, 128 },
    { 27, -1 },
    { -1, -1 },
    { -1, -1 },
    { 94, -1 },
    { -1, -1 },
    { 84, -1 },
    { 16, 147 },
    { -1, -1 },
    { -1, -1 },
    { 79, -1 },
    { -1, -1 },
    { 64, -1 },
    { 63, -1 },
    { 3, -1 },
    { 40, -1 },
    { -1, -1 },
    { 72, -1 },
    { 75, 145 },
    { -1, -1 },
    { 26, 133 },
    { -1, -1 },
    { 13, 139 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 81, -1 },
    { 57, -1 },
    { -1, -1 },
    { 91, -1 },
    { 8, 129 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 49, -1 },
    { -1, -1 },
    { 14, -1 },
    { 62, -1 },
    { -1, -1 },
    { 61, -1 },
    { -1, -1 },
    { 90, -1 },
    { -1, -1 },
    { 37, -1 },
    { -1, -1 },
    { 18, 130 },
    { 20, -1 },
    { 21, -1 },
    { 30, -1 },
    { 32, -1 },
    { 39, -1 },
    { 43, -1 },
    { 44, -1 },
    { 45, -1 },
    { 46, -1 },
    { 52, 140 },
    { 53, -1 },
    { 54, -1 },
    { 55, -1 },
    { 58, -1 },
    { 65, -1 },
    { 69, -1 },
    { 76, -1 },
    { 78, -1 },
    { 82, -1 },
    { 86, -1 },
    { 87, -1 },
    { 88, -1 },
    { 92, -1 },
};

static const struct HashValue binaryPropertyTableValue[95] = {
    { "Grapheme_Extend", 58 },
    { "Gr_Ext", 58 },
    { "Extended_Pictographic", 90 },
    { "Emoji_Presentation", 86 },
    { "Pattern_White_Space", 82 },
    { "Pat_WS", 82 },
    { "Emoji_Component", 89 },
    { "Changes_When_Uppercased", 49 },
    { "CWU", 49 },
    { "Ideographic", 69 },
    { "Ideo", 69 },
    { "IDS_Binary_Operator", 73 },
    { "IDSB", 73 },
    { "Regional_Indicator", 84 },
    { "RI", 84 },
    { "Alphabetic", 43 },
    { "Alpha", 43 },
    { "Math", 42 },
    { "Math", 42 },
    { "Changes_When_Casemapped", 52 },
    { "CWCM", 52 },
    { "IDS_Trinary_Operator", 74 },
    { "IDST", 74 },
    { "Changes_When_NFKC_Casefolded", 60 },
    { "CWKCF", 60 },
    { "Bidi_Control", 62 },
    { "Bidi_C", 62 },
    { "ASCII_Hex_Digit", 68 },
    { "AHex", 68 },
    { "Cased", 46 },
    { "Cased", 46 },
    { "Soft_Dotted", 78 },
    { "SD", 78 },
    { "Case_Ignorable", 47 },
    { "CI", 47 },
    { "Extender", 71 },
    { "Ext", 71 },
    { "Changes_When_Titlecased", 50 },
    { "CWT", 50 },
    { "Lowercase", 44 },
    { "Lower", 44 },
    { "Sentence_Terminal", 80 },
    { "STerm", 80 },
    { "Deprecated", 77 },
    { "Dep", 77 },
    { "Pattern_Syntax", 83 },
    { "Pat_Syn", 83 },
    { "Emoji_Modifier_Base", 88 },
    { "Join_Control", 63 },
    { "Join_C", 63 },
    { "Logical_Order_Exception", 79 },
    { "LOE", 79 },
    { "XID_Start", 55 },
    { "XIDS", 55 },
    { "Emoji_Modifier", 87 },
    { "Terminal_Punctuation", 66 },
    { "Term", 66 },
    { "Variation_Selector", 81 },
    { "VS", 81 },
    { "ID_Continue", 54 },
    { "IDC", 54 },
    { "Hex_Digit", 67 },
    { "Hex", 67 },
    { "Grapheme_Base", 59 },
    { "Gr_Base", 59 },
    { "Diacritic", 70 },
    { "Dia", 70 },
    { "Uppercase", 45 },
    { "Upper", 45 },
    { "ID_Start", 53 },
    { "IDS", 53 },
    { "Unified_Ideograph", 76 },
    { "UIdeo", 76 },
    { "Bidi_Mirrored", 41 },
    { "Bidi_M", 41 },
    { "Dash", 64 },
    { "Dash", 64 },
    { "XID_Continue", 56 },
    { "XIDC", 56 },
    { "Changes_When_Lowercased", 48 },
    { "CWL", 48 },
    { "Changes_When_Casefolded", 51 },
    { "CWCF", 51 },
    { "Noncharacter_Code_Point", 72 },
    { "NChar", 72 },
    { "Radical", 75 },
    { "Radical", 75 },
    { "Quotation_Mark", 65 },
    { "QMark", 65 },
    { "White_Space", 61 },
    { "WSpace", 61 },
    { "space", 61 },
    { "Default_Ignorable_Code_Point", 57 },
    { "DI", 57 },
    { "Emoji", 85 },
};

static const struct HashTable binaryPropertyHashTable = 
    { 95, 127, binaryPropertyTableValue, binaryPropertyTableIndex };

// Scripts:
static const struct HashIndex scriptTableIndex[582] = {
    { -1, -1 },
    { -1, -1 },
    { 27, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 285, -1 },
    { -1, -1 },
    { -1, -1 },
    { 21, -1 },
    { -1, -1 },
    { -1, -1 },
    { 165, -1 },
    { 8, -1 },
    { -1, -1 },
    { 23, 515 },
    { 128, 579 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 71, -1 },
    { -1, -1 },
    { 38, -1 },
    { -1, -1 },
    { -1, -1 },
    { 36, -1 },
    { -1, -1 },
    { 247, -1 },
    { 51, 516 },
    { 153, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 202, -1 },
    { -1, -1 },
    { 101, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 212, -1 },
    { 271, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 279, -1 },
    { 188, -1 },
    { 7, 521 },
    { -1, -1 },
    { -1, -1 },
    { 138, 531 },
    { 171, -1 },
    { -1, -1 },
    { 193, -1 },
    { -1, -1 },
    { 163, 538 },
    { -1, -1 },
    { 289, -1 },
    { -1, -1 },
    { 262, -1 },
    { 137, -1 },
    { -1, -1 },
    { 290, -1 },
    { -1, -1 },
    { 83, -1 },
    { -1, -1 },
    { 2, -1 },
    { -1, -1 },
    { 174, -1 },
    { 197, -1 },
    { 268, -1 },
    { -1, -1 },
    { -1, -1 },
    { 241, -1 },
    { -1, -1 },
    { 232, 562 },
    { 181, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 68, -1 },
    { -1, -1 },
    { -1, -1 },
    { 236, -1 },
    { -1, -1 },
    { 223, -1 },
    { 255, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 234, 568 },
    { -1, -1 },
    { -1, -1 },
    { 134, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 37, -1 },
    { -1, -1 },
    { 158, 556 },
    { -1, -1 },
    { -1, -1 },
    { 220, -1 },
    { 164, -1 },
    { 28, 532 },
    { 5, 514 },
    { -1, -1 },
    { 64, -1 },
    { -1, -1 },
    { 80, -1 },
    { 254, -1 },
    { 145, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 175, -1 },
    { -1, -1 },
    { 155, 544 },
    { -1, -1 },
    { 139, 528 },
    { 277, -1 },
    { 198, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 265, -1 },
    { 248, -1 },
    { 52, 565 },
    { 129, 542 },
    { 93, -1 },
    { 260, -1 },
    { 132, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 124, -1 },
    { 215, -1 },
    { 114, -1 },
    { 74, -1 },
    { -1, -1 },
    { -1, -1 },
    { 296, -1 },
    { -1, -1 },
    { -1, -1 },
    { 43, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 205, -1 },
    { -1, -1 },
    { 82, 553 },
    { 273, -1 },
    { -1, -1 },
    { 19, -1 },
    { 50, -1 },
    { 116, -1 },
    { -1, -1 },
    { 61, -1 },
    { 39, -1 },
    { 100, -1 },
    { -1, -1 },
    { -1, -1 },
    { 120, -1 },
    { 107, 576 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 243, -1 },
    { 119, 539 },
    { -1, -1 },
    { 231, -1 },
    { 70, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 214, -1 },
    { -1, -1 },
    { 9, 527 },
    { 121, 525 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 157, -1 },
    { -1, -1 },
    { -1, -1 },
    { 44, 551 },
    { 203, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 87, -1 },
    { 92, -1 },
    { -1, -1 },
    { -1, -1 },
    { 253, -1 },
    { -1, -1 },
    { 156, -1 },
    { 251, -1 },
    { 84, 519 },
    { -1, -1 },
    { 266, -1 },
    { 65, -1 },
    { 256, -1 },
    { 63, -1 },
    { 227, -1 },
    { -1, -1 },
    { 1, 530 },
    { -1, -1 },
    { 166, -1 },
    { 102, 558 },
    { 280, -1 },
    { 294, -1 },
    { 250, -1 },
    { 34, -1 },
    { -1, -1 },
    { -1, -1 },
    { 25, 512 },
    { 204, -1 },
    { 217, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 216, -1 },
    { -1, -1 },
    { -1, -1 },
    { 85, -1 },
    { 31, -1 },
    { -1, -1 },
    { 113, 526 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 66, 549 },
    { -1, -1 },
    { 48, -1 },
    { 104, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 201, -1 },
    { -1, -1 },
    { 183, 552 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 135, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 154, -1 },
    { 4, -1 },
    { 186, -1 },
    { -1, -1 },
    { 218, -1 },
    { 168, -1 },
    { 192, 555 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 54, 522 },
    { 127, 580 },
    { -1, -1 },
    { 162, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 91, 534 },
    { 257, -1 },
    { -1, -1 },
    { 261, -1 },
    { 56, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 184, 548 },
    { 14, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 224, 564 },
    { 41, 547 },
    { -1, -1 },
    { 10, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 53, -1 },
    { 239, -1 },
    { 11, -1 },
    { 60, -1 },
    { -1, -1 },
    { 274, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 206, -1 },
    { 249, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 97, 540 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 35, -1 },
    { -1, -1 },
    { 210, -1 },
    { -1, -1 },
    { 283, -1 },
    { 208, -1 },
    { 226, -1 },
    { -1, -1 },
    { 276, -1 },
    { 103, 541 },
    { 0, -1 },
    { 75, 578 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 109, 569 },
    { -1, -1 },
    { -1, -1 },
    { 58, 517 },
    { 24, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 110, 533 },
    { -1, -1 },
    { -1, -1 },
    { 46, -1 },
    { 259, -1 },
    { -1, -1 },
    { -1, -1 },
    { 112, -1 },
    { -1, -1 },
    { 42, -1 },
    { 18, -1 },
    { -1, -1 },
    { -1, -1 },
    { 73, -1 },
    { 13, -1 },
    { 295, -1 },
    { 117, 574 },
    { 131, -1 },
    { 30, -1 },
    { -1, -1 },
    { -1, -1 },
    { 33, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 49, -1 },
    { 148, -1 },
    { -1, -1 },
    { 178, -1 },
    { 125, -1 },
    { 16, 523 },
    { -1, -1 },
    { -1, -1 },
    { 118, -1 },
    { 151, -1 },
    { -1, -1 },
    { 78, -1 },
    { -1, -1 },
    { -1, -1 },
    { 55, 536 },
    { -1, -1 },
    { 17, -1 },
    { 235, -1 },
    { -1, -1 },
    { 182, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 278, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 275, -1 },
    { 111, -1 },
    { -1, -1 },
    { -1, -1 },
    { 72, 518 },
    { -1, -1 },
    { -1, -1 },
    { 40, -1 },
    { -1, -1 },
    { -1, -1 },
    { 45, 524 },
    { -1, -1 },
    { 281, -1 },
    { -1, -1 },
    { 29, 535 },
    { 98, -1 },
    { -1, -1 },
    { -1, -1 },
    { 270, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 15, -1 },
    { 142, 546 },
    { -1, -1 },
    { 219, 557 },
    { -1, -1 },
    { -1, -1 },
    { 123, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 169, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 86, -1 },
    { -1, -1 },
    { -1, -1 },
    { 287, -1 },
    { -1, -1 },
    { -1, -1 },
    { 185, -1 },
    { 77, -1 },
    { -1, -1 },
    { 90, 561 },
    { 76, -1 },
    { 267, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 136, -1 },
    { 32, 573 },
    { -1, -1 },
    { -1, -1 },
    { 6, 513 },
    { 221, 560 },
    { -1, -1 },
    { 22, -1 },
    { -1, -1 },
    { -1, -1 },
    { 12, -1 },
    { 161, 567 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 67, -1 },
    { -1, -1 },
    { -1, -1 },
    { 57, 566 },
    { 20, -1 },
    { 62, -1 },
    { 246, -1 },
    { 108, -1 },
    { -1, -1 },
    { -1, -1 },
    { 3, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 133, -1 },
    { 81, 545 },
    { -1, -1 },
    { 94, -1 },
    { 191, -1 },
    { 167, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 297, -1 },
    { 149, -1 },
    { -1, -1 },
    { 26, -1 },
    { 47, -1 },
    { 59, -1 },
    { 69, 575 },
    { 79, -1 },
    { 88, -1 },
    { 89, -1 },
    { 95, 520 },
    { 96, -1 },
    { 99, 529 },
    { 105, -1 },
    { 106, -1 },
    { 115, 554 },
    { 122, 543 },
    { 126, -1 },
    { 130, -1 },
    { 140, -1 },
    { 141, -1 },
    { 143, -1 },
    { 144, 570 },
    { 146, -1 },
    { 147, -1 },
    { 150, 563 },
    { 152, -1 },
    { 159, 537 },
    { 160, -1 },
    { 170, -1 },
    { 172, -1 },
    { 173, -1 },
    { 176, 550 },
    { 177, -1 },
    { 179, -1 },
    { 180, 581 },
    { 187, -1 },
    { 189, 559 },
    { 190, -1 },
    { 194, -1 },
    { 195, -1 },
    { 196, -1 },
    { 199, -1 },
    { 200, 571 },
    { 207, -1 },
    { 209, -1 },
    { 211, -1 },
    { 213, -1 },
    { 222, -1 },
    { 225, 577 },
    { 228, -1 },
    { 229, -1 },
    { 230, -1 },
    { 233, -1 },
    { 237, -1 },
    { 238, -1 },
    { 240, -1 },
    { 242, -1 },
    { 244, -1 },
    { 245, -1 },
    { 252, -1 },
    { 258, -1 },
    { 263, 572 },
    { 264, -1 },
    { 269, -1 },
    { 272, -1 },
    { 282, -1 },
    { 284, -1 },
    { 286, -1 },
    { 288, -1 },
    { 291, -1 },
    { 292, -1 },
    { 293, -1 },
};

static const struct HashValue scriptTableValue[298] = {
    { "Tangut", 228 },
    { "Tang", 228 },
    { "Thaana", 100 },
    { "Thaa", 100 },
    { "Adlam", 223 },
    { "Adlm", 223 },
    { "Telugu", 107 },
    { "Telu", 107 },
    { "Cyrillic", 95 },
    { "Cyrl", 95 },
    { "Zanabazar_Square", 232 },
    { "Zanb", 232 },
    { "Hangul", 116 },
    { "Hang", 116 },
    { "Old_South_Arabian", 179 },
    { "Sarb", 179 },
    { "Ethiopic", 117 },
    { "Ethi", 117 },
    { "Inherited", 132 },
    { "Zinh", 132 },
    { "Qaai", 132 },
    { "Meroitic_Cursive", 188 },
    { "Merc", 188 },
    { "Bhaiksuki", 224 },
    { "Bhks", 224 },
    { "Ahom", 217 },
    { "Ahom", 217 },
    { "Han", 127 },
    { "Hani", 127 },
    { "Old_North_Arabian", 207 },
    { "Narb", 207 },
    { "Armenian", 96 },
    { "Armn", 96 },
    { "Tamil", 106 },
    { "Taml", 106 },
    { "Bopomofo", 126 },
    { "Bopo", 126 },
    { "Bassa_Vah", 195 },
    { "Bass", 195 },
    { "Sundanese", 158 },
    { "Sund", 158 },
    { "Osage", 227 },
    { "Osge", 227 },
    { "Old_Sogdian", 239 },
    { "Sogo", 239 },
    { "Tagalog", 133 },
    { "Tglg", 133 },
    { "Malayalam", 109 },
    { "Mlym", 109 },
    { "Marchen", 225 },
    { "Marc", 225 },
    { "Carian", 166 },
    { "Cari", 166 },
    { "Hiragana", 124 },
    { "Hira", 124 },
    { "Tagbanwa", 136 },
    { "Tagb", 136 },
    { "Meetei_Mayek", 177 },
    { "Mtei", 177 },
    { "Hanifi_Rohingya", 237 },
    { "Rohg", 237 },
    { "Pahawh_Hmong", 199 },
    { "Hmng", 199 },
    { "Tai_Le", 138 },
    { "Tale", 138 },
    { "Kayah_Li", 163 },
    { "Kali", 163 },
    { "Buginese", 145 },
    { "Bugi", 145 },
    { "Kharoshthi", 152 },
    { "Khar", 152 },
    { "Tai_Tham", 169 },
    { "Lana", 169 },
    { "Old_Italic", 129 },
    { "Ital", 129 },
    { "Old_Persian", 151 },
    { "Xpeo", 151 },
    { "Warang_Citi", 216 },
    { "Wara", 216 },
    { "Latin", 93 },
    { "Latn", 93 },
    { "Saurashtra", 162 },
    { "Saur", 162 },
    { "Shavian", 141 },
    { "Shaw", 141 },
    { "Georgian", 115 },
    { "Geor", 115 },
    { "Grantha", 198 },
    { "Gran", 198 },
    { "Duployan", 196 },
    { "Dupl", 196 },
    { "Batak", 184 },
    { "Batk", 184 },
    { "Devanagari", 101 },
    { "Deva", 101 },
    { "Thai", 111 },
    { "Thai", 111 },
    { "Tibetan", 113 },
    { "Tibt", 113 },
    { "Tifinagh", 149 },
    { "Tfng", 149 },
    { "Ugaritic", 140 },
    { "Ugar", 140 },
    { "Braille", 144 },
    { "Brai", 144 },
    { "Anatolian_Hieroglyphs", 218 },
    { "Hluw", 218 },
    { "Greek", 94 },
    { "Grek", 94 },
    { "Lycian", 165 },
    { "Lyci", 165 },
    { "Mende_Kikakui", 204 },
    { "Mend", 204 },
    { "Tai_Viet", 170 },
    { "Tavt", 170 },
    { "Vai", 161 },
    { "Vaii", 161 },
    { "Ogham", 120 },
    { "Ogam", 120 },
    { "Inscriptional_Parthian", 180 },
    { "Prti", 180 },
    { "Cham", 168 },
    { "Cham", 168 },
    { "Syriac", 99 },
    { "Syrc", 99 },
    { "Runic", 121 },
    { "Runr", 121 },
    { "Gothic", 130 },
    { "Goth", 130 },
    { "Mahajani", 202 },
    { "Mahj", 202 },
    { "Katakana", 125 },
    { "Kana", 125 },
    { "Osmanya", 142 },
    { "Osma", 142 },
    { "New_Tai_Lue", 147 },
    { "Talu", 147 },
    { "Ol_Chiki", 160 },
    { "Olck", 160 },
    { "Newa", 226 },
    { "Newa", 226 },
    { "Limbu", 137 },
    { "Limb", 137 },
    { "Pau_Cin_Hau", 210 },
    { "Pauc", 210 },
    { "Cherokee", 118 },
    { "Cher", 118 },
    { "Miao", 190 },
    { "Plrd", 190 },
    { "Oriya", 105 },
    { "Orya", 105 },
    { "Medefaidrin", 236 },
    { "Medf", 236 },
    { "Sharada", 191 },
    { "Shrd", 191 },
    { "Gujarati", 104 },
    { "Gujr", 104 },
    { "Nushu", 230 },
    { "Nshu", 230 },
    { "Modi", 205 },
    { "Modi", 205 },
    { "Gunjala_Gondi", 234 },
    { "Gong", 234 },
    { "Inscriptional_Pahlavi", 181 },
    { "Phli", 181 },
    { "Manichaean", 203 },
    { "Mani", 203 },
    { "Khmer", 122 },
    { "Khmr", 122 },
    { "Cuneiform", 154 },
    { "Xsux", 154 },
    { "Khudawadi", 214 },
    { "Sind", 214 },
    { "Mandaic", 186 },
    { "Mand", 186 },
    { "Hatran", 219 },
    { "Hatr", 219 },
    { "Syloti_Nagri", 150 },
    { "Sylo", 150 },
    { "Nko", 157 },
    { "Nkoo", 157 },
    { "Canadian_Aboriginal", 119 },
    { "Cans", 119 },
    { "Meroitic_Hieroglyphs", 189 },
    { "Mero", 189 },
    { "Phoenician", 155 },
    { "Phnx", 155 },
    { "Nabataean", 208 },
    { "Nbat", 208 },
    { "Bengali", 102 },
    { "Beng", 102 },
    { "Kaithi", 183 },
    { "Kthi", 183 },
    { "Glagolitic", 148 },
    { "Glag", 148 },
    { "Imperial_Aramaic", 178 },
    { "Armi", 178 },
    { "Sora_Sompeng", 192 },
    { "Sora", 192 },
    { "Gurmukhi", 103 },
    { "Guru", 103 },
    { "Javanese", 176 },
    { "Java", 176 },
    { "Old_Permic", 211 },
    { "Perm", 211 },
    { "Phags_Pa", 156 },
    { "Phag", 156 },
    { "Cypriot", 143 },
    { "Cprt", 143 },
    { "Kannada", 108 },
    { "Knda", 108 },
    { "Khojki", 200 },
    { "Khoj", 200 },
    { "Mongolian", 123 },
    { "Mong", 123 },
    { "Sinhala", 110 },
    { "Sinh", 110 },
    { "Brahmi", 185 },
    { "Brah", 185 },
    { "Elbasan", 197 },
    { "Elba", 197 },
    { "Deseret", 131 },
    { "Dsrt", 131 },
    { "Rejang", 164 },
    { "Rjng", 164 },
    { "SignWriting", 222 },
    { "Sgnw", 222 },
    { "Multani", 220 },
    { "Mult", 220 },
    { "Yi", 128 },
    { "Yiii", 128 },
    { "Balinese", 153 },
    { "Bali", 153 },
    { "Lao", 112 },
    { "Laoo", 112 },
    { "Hanunoo", 134 },
    { "Hano", 134 },
    { "Masaram_Gondi", 229 },
    { "Gonm", 229 },
    { "Linear_B", 139 },
    { "Linb", 139 },
    { "Linear_A", 201 },
    { "Lina", 201 },
    { "Dogra", 233 },
    { "Dogr", 233 },
    { "Old_Turkic", 182 },
    { "Orkh", 182 },
    { "Lepcha", 159 },
    { "Lepc", 159 },
    { "Lydian", 167 },
    { "Lydi", 167 },
    { "Egyptian_Hieroglyphs", 172 },
    { "Egyp", 172 },
    { "Sogdian", 238 },
    { "Sogd", 238 },
    { "Caucasian_Albanian", 194 },
    { "Aghb", 194 },
    { "Makasar", 235 },
    { "Maka", 235 },
    { "Old_Hungarian", 221 },
    { "Hung", 221 },
    { "Samaritan", 173 },
    { "Samr", 173 },
    { "Lisu", 174 },
    { "Lisu", 174 },
    { "Buhid", 135 },
    { "Buhd", 135 },
    { "Palmyrene", 209 },
    { "Palm", 209 },
    { "Tirhuta", 215 },
    { "Tirh", 215 },
    { "Mro", 206 },
    { "Mroo", 206 },
    { "Common", 92 },
    { "Zyyy", 92 },
    { "Coptic", 146 },
    { "Copt", 146 },
    { "Qaac", 146 },
    { "Chakma", 187 },
    { "Cakm", 187 },
    { "Arabic", 98 },
    { "Arab", 98 },
    { "Bamum", 175 },
    { "Bamu", 175 },
    { "Myanmar", 114 },
    { "Mymr", 114 },
    { "Siddham", 213 },
    { "Sidd", 213 },
    { "Soyombo", 231 },
    { "Soyo", 231 },
    { "Avestan", 171 },
    { "Avst", 171 },
    { "Hebrew", 97 },
    { "Hebr", 97 },
    { "Psalter_Pahlavi", 212 },
    { "Phlp", 212 },
    { "Takri", 193 },
    { "Takr", 193 },
};

static const struct HashTable scriptHashTable = 
    { 298, 511, scriptTableValue, scriptTableIndex };

// Script_Extensions:
static const struct HashIndex scriptExtensionTableIndex[582] = {
    { -1, -1 },
    { -1, -1 },
    { 27, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 285, -1 },
    { -1, -1 },
    { -1, -1 },
    { 21, -1 },
    { -1, -1 },
    { -1, -1 },
    { 169, -1 },
    { 8, -1 },
    { -1, -1 },
    { 23, 516 },
    { 132, 579 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 75, -1 },
    { -1, -1 },
    { 38, -1 },
    { -1, -1 },
    { -1, -1 },
    { 36, -1 },
    { -1, -1 },
    { 247, -1 },
    { 51, 517 },
    { 157, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 204, -1 },
    { -1, -1 },
    { 105, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 214, -1 },
    { 271, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 164, -1 },
    { 192, -1 },
    { 7, 522 },
    { -1, -1 },
    { -1, -1 },
    { 142, 555 },
    { 175, -1 },
    { -1, -1 },
    { 195, -1 },
    { -1, -1 },
    { 167, 535 },
    { -1, -1 },
    { 289, -1 },
    { -1, -1 },
    { 262, -1 },
    { 141, -1 },
    { -1, -1 },
    { 290, -1 },
    { -1, -1 },
    { 87, -1 },
    { -1, -1 },
    { 2, -1 },
    { -1, -1 },
    { 178, -1 },
    { 199, -1 },
    { 268, -1 },
    { -1, -1 },
    { -1, -1 },
    { 241, -1 },
    { -1, -1 },
    { 232, 560 },
    { 185, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 72, -1 },
    { -1, -1 },
    { -1, -1 },
    { 236, -1 },
    { -1, -1 },
    { 225, -1 },
    { 255, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 234, 566 },
    { -1, -1 },
    { -1, -1 },
    { 138, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 37, -1 },
    { -1, -1 },
    { 162, 553 },
    { -1, -1 },
    { -1, -1 },
    { 148, -1 },
    { 168, -1 },
    { 28, 531 },
    { 5, 514 },
    { -1, -1 },
    { 68, -1 },
    { -1, -1 },
    { 84, -1 },
    { 254, -1 },
    { 149, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 179, -1 },
    { -1, -1 },
    { 159, 541 },
    { -1, -1 },
    { 143, 528 },
    { 277, -1 },
    { 200, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 265, -1 },
    { 248, -1 },
    { 52, 563 },
    { 133, 539 },
    { 97, -1 },
    { 260, -1 },
    { 136, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 128, -1 },
    { 217, -1 },
    { 118, -1 },
    { 78, -1 },
    { -1, -1 },
    { -1, -1 },
    { 296, -1 },
    { -1, -1 },
    { -1, -1 },
    { 43, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 207, -1 },
    { -1, -1 },
    { 86, 550 },
    { 273, -1 },
    { -1, -1 },
    { 19, -1 },
    { 250, -1 },
    { 62, -1 },
    { -1, -1 },
    { 63, -1 },
    { 39, -1 },
    { 104, -1 },
    { -1, -1 },
    { -1, -1 },
    { 124, -1 },
    { 111, 576 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 243, -1 },
    { 123, 536 },
    { -1, -1 },
    { 231, -1 },
    { 74, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 216, -1 },
    { -1, -1 },
    { 9, 527 },
    { 125, 525 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 161, -1 },
    { -1, -1 },
    { -1, -1 },
    { 44, 547 },
    { 41, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 91, -1 },
    { 108, -1 },
    { -1, -1 },
    { -1, -1 },
    { 253, -1 },
    { -1, -1 },
    { 160, -1 },
    { 251, -1 },
    { 88, 520 },
    { -1, -1 },
    { 266, -1 },
    { 69, -1 },
    { 256, -1 },
    { 67, -1 },
    { 55, -1 },
    { -1, -1 },
    { 1, 554 },
    { -1, -1 },
    { 170, -1 },
    { 106, 557 },
    { 280, -1 },
    { 294, -1 },
    { 50, -1 },
    { 34, -1 },
    { -1, -1 },
    { -1, -1 },
    { 25, 512 },
    { 42, -1 },
    { 219, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 218, -1 },
    { -1, -1 },
    { -1, -1 },
    { 89, -1 },
    { 31, -1 },
    { -1, -1 },
    { 117, 526 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 70, 545 },
    { -1, -1 },
    { 48, -1 },
    { 96, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 203, -1 },
    { -1, -1 },
    { 187, 548 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 139, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 158, -1 },
    { 4, -1 },
    { 190, -1 },
    { -1, -1 },
    { 220, -1 },
    { 172, -1 },
    { 120, 552 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 54, 523 },
    { 131, 580 },
    { -1, -1 },
    { 166, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 107, 533 },
    { 257, -1 },
    { -1, -1 },
    { 261, -1 },
    { 66, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 188, 544 },
    { 14, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 226, 562 },
    { 194, 549 },
    { -1, -1 },
    { 10, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 53, -1 },
    { 239, -1 },
    { 11, -1 },
    { 60, -1 },
    { -1, -1 },
    { 274, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 208, -1 },
    { 49, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 101, 537 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 35, -1 },
    { -1, -1 },
    { 212, -1 },
    { -1, -1 },
    { 283, -1 },
    { 210, -1 },
    { 228, -1 },
    { -1, -1 },
    { 276, -1 },
    { 95, 538 },
    { 0, -1 },
    { 79, 578 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 113, 567 },
    { -1, -1 },
    { -1, -1 },
    { 58, 518 },
    { 24, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 114, 532 },
    { -1, -1 },
    { -1, -1 },
    { 46, -1 },
    { 259, -1 },
    { -1, -1 },
    { -1, -1 },
    { 116, -1 },
    { -1, -1 },
    { 206, -1 },
    { 18, -1 },
    { -1, -1 },
    { -1, -1 },
    { 77, -1 },
    { 13, -1 },
    { 295, -1 },
    { 121, 572 },
    { 135, -1 },
    { 30, -1 },
    { -1, -1 },
    { -1, -1 },
    { 33, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 249, -1 },
    { 152, -1 },
    { -1, -1 },
    { 182, -1 },
    { 129, -1 },
    { 16, 524 },
    { -1, -1 },
    { -1, -1 },
    { 122, -1 },
    { 155, -1 },
    { -1, -1 },
    { 82, -1 },
    { -1, -1 },
    { -1, -1 },
    { 65, 573 },
    { -1, -1 },
    { 17, -1 },
    { 235, -1 },
    { -1, -1 },
    { 186, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 163, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 275, -1 },
    { 115, -1 },
    { -1, -1 },
    { -1, -1 },
    { 76, 519 },
    { -1, -1 },
    { -1, -1 },
    { 40, -1 },
    { -1, -1 },
    { -1, -1 },
    { 45, 515 },
    { -1, -1 },
    { 281, -1 },
    { -1, -1 },
    { 29, 534 },
    { 102, -1 },
    { -1, -1 },
    { -1, -1 },
    { 270, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 15, -1 },
    { 56, 530 },
    { -1, -1 },
    { 147, 556 },
    { -1, -1 },
    { -1, -1 },
    { 127, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 173, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 90, -1 },
    { -1, -1 },
    { -1, -1 },
    { 287, -1 },
    { -1, -1 },
    { -1, -1 },
    { 189, -1 },
    { 81, -1 },
    { -1, -1 },
    { 94, 559 },
    { 80, -1 },
    { 267, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 140, -1 },
    { 32, 571 },
    { -1, -1 },
    { -1, -1 },
    { 6, 513 },
    { 223, 558 },
    { -1, -1 },
    { 22, -1 },
    { -1, -1 },
    { -1, -1 },
    { 12, -1 },
    { 165, 565 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 71, -1 },
    { -1, -1 },
    { -1, -1 },
    { 57, 564 },
    { 20, -1 },
    { 64, -1 },
    { 246, -1 },
    { 112, -1 },
    { -1, -1 },
    { -1, -1 },
    { 3, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 137, -1 },
    { 85, 542 },
    { -1, -1 },
    { 98, -1 },
    { 119, -1 },
    { 171, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 297, -1 },
    { 153, -1 },
    { -1, -1 },
    { 26, -1 },
    { 47, -1 },
    { 59, -1 },
    { 61, 551 },
    { 73, 575 },
    { 83, -1 },
    { 92, -1 },
    { 93, -1 },
    { 99, 521 },
    { 100, -1 },
    { 103, 529 },
    { 109, -1 },
    { 110, -1 },
    { 126, 540 },
    { 130, -1 },
    { 134, -1 },
    { 144, -1 },
    { 145, -1 },
    { 146, 543 },
    { 150, -1 },
    { 151, -1 },
    { 154, 561 },
    { 156, -1 },
    { 174, -1 },
    { 176, -1 },
    { 177, -1 },
    { 180, 546 },
    { 181, -1 },
    { 183, -1 },
    { 184, 581 },
    { 191, -1 },
    { 193, -1 },
    { 196, -1 },
    { 197, -1 },
    { 198, -1 },
    { 201, -1 },
    { 202, 569 },
    { 205, -1 },
    { 209, -1 },
    { 211, -1 },
    { 213, -1 },
    { 215, -1 },
    { 221, -1 },
    { 222, 568 },
    { 224, -1 },
    { 227, 577 },
    { 229, -1 },
    { 230, -1 },
    { 233, -1 },
    { 237, -1 },
    { 238, -1 },
    { 240, -1 },
    { 242, -1 },
    { 244, -1 },
    { 245, -1 },
    { 252, -1 },
    { 258, -1 },
    { 263, 570 },
    { 264, -1 },
    { 269, -1 },
    { 272, -1 },
    { 278, 574 },
    { 279, -1 },
    { 282, -1 },
    { 284, -1 },
    { 286, -1 },
    { 288, -1 },
    { 291, -1 },
    { 292, -1 },
    { 293, -1 },
};

static const struct HashValue scriptExtensionTableValue[298] = {
    { "Tangut", 228 },
    { "Tang", 228 },
    { "Thaana", 252 },
    { "Thaa", 252 },
    { "Adlam", 293 },
    { "Adlm", 293 },
    { "Telugu", 292 },
    { "Telu", 292 },
    { "Cyrillic", 260 },
    { "Cyrl", 260 },
    { "Zanabazar_Square", 232 },
    { "Zanb", 232 },
    { "Hangul", 288 },
    { "Hang", 288 },
    { "Old_South_Arabian", 179 },
    { "Sarb", 179 },
    { "Ethiopic", 117 },
    { "Ethi", 117 },
    { "Inherited", 241 },
    { "Zinh", 241 },
    { "Qaai", 241 },
    { "Meroitic_Cursive", 188 },
    { "Merc", 188 },
    { "Bhaiksuki", 224 },
    { "Bhks", 224 },
    { "Ahom", 217 },
    { "Ahom", 217 },
    { "Han", 246 },
    { "Hani", 246 },
    { "Old_North_Arabian", 207 },
    { "Narb", 207 },
    { "Armenian", 253 },
    { "Armn", 253 },
    { "Tamil", 265 },
    { "Taml", 265 },
    { "Bopomofo", 255 },
    { "Bopo", 255 },
    { "Bassa_Vah", 195 },
    { "Bass", 195 },
    { "Sundanese", 158 },
    { "Sund", 158 },
    { "Old_Permic", 262 },
    { "Perm", 262 },
    { "Old_Sogdian", 239 },
    { "Sogo", 239 },
    { "Tagalog", 284 },
    { "Tglg", 284 },
    { "Malayalam", 290 },
    { "Mlym", 290 },
    { "Lydian", 167 },
    { "Lydi", 167 },
    { "Carian", 166 },
    { "Cari", 166 },
    { "Hiragana", 270 },
    { "Hira", 270 },
    { "Multani", 269 },
    { "Mult", 269 },
    { "Meetei_Mayek", 177 },
    { "Mtei", 177 },
    { "Hanifi_Rohingya", 250 },
    { "Rohg", 250 },
    { "Vai", 161 },
    { "Vaii", 161 },
    { "Pahawh_Hmong", 199 },
    { "Hmng", 199 },
    { "Tagbanwa", 283 },
    { "Tagb", 283 },
    { "Tai_Le", 277 },
    { "Tale", 277 },
    { "Kayah_Li", 280 },
    { "Kali", 280 },
    { "Buginese", 256 },
    { "Bugi", 256 },
    { "Kharoshthi", 152 },
    { "Khar", 152 },
    { "Tai_Tham", 169 },
    { "Lana", 169 },
    { "Old_Italic", 129 },
    { "Ital", 129 },
    { "Old_Persian", 151 },
    { "Xpeo", 151 },
    { "Warang_Citi", 216 },
    { "Wara", 216 },
    { "Latin", 247 },
    { "Latn", 247 },
    { "Saurashtra", 162 },
    { "Saur", 162 },
    { "Shavian", 141 },
    { "Shaw", 141 },
    { "Georgian", 254 },
    { "Geor", 254 },
    { "Grantha", 263 },
    { "Gran", 263 },
    { "Duployan", 244 },
    { "Dupl", 244 },
    { "Braille", 144 },
    { "Brai", 144 },
    { "Devanagari", 243 },
    { "Deva", 243 },
    { "Thai", 111 },
    { "Thai", 111 },
    { "Tibetan", 113 },
    { "Tibt", 113 },
    { "Tifinagh", 149 },
    { "Tfng", 149 },
    { "Ugaritic", 140 },
    { "Ugar", 140 },
    { "Batak", 184 },
    { "Batk", 184 },
    { "Anatolian_Hieroglyphs", 218 },
    { "Hluw", 218 },
    { "Greek", 245 },
    { "Grek", 245 },
    { "Lycian", 165 },
    { "Lyci", 165 },
    { "Mende_Kikakui", 204 },
    { "Mend", 204 },
    { "Tai_Viet", 170 },
    { "Tavt", 170 },
    { "Kaithi", 286 },
    { "Kthi", 286 },
    { "Ogham", 120 },
    { "Ogam", 120 },
    { "Inscriptional_Parthian", 180 },
    { "Prti", 180 },
    { "Cham", 168 },
    { "Cham", 168 },
    { "Syriac", 251 },
    { "Syrc", 251 },
    { "Runic", 121 },
    { "Runr", 121 },
    { "Gothic", 130 },
    { "Goth", 130 },
    { "Mahajani", 287 },
    { "Mahj", 287 },
    { "Katakana", 271 },
    { "Kana", 271 },
    { "Osmanya", 142 },
    { "Osma", 142 },
    { "New_Tai_Lue", 147 },
    { "Talu", 147 },
    { "Ol_Chiki", 160 },
    { "Olck", 160 },
    { "Newa", 226 },
    { "Newa", 226 },
    { "Limbu", 304 },
    { "Limb", 304 },
    { "Elbasan", 197 },
    { "Elba", 197 },
    { "Cherokee", 118 },
    { "Cher", 118 },
    { "Miao", 190 },
    { "Plrd", 190 },
    { "Oriya", 291 },
    { "Orya", 291 },
    { "Medefaidrin", 236 },
    { "Medf", 236 },
    { "Sharada", 264 },
    { "Shrd", 264 },
    { "Gujarati", 266 },
    { "Gujr", 266 },
    { "Nushu", 230 },
    { "Nshu", 230 },
    { "Chakma", 274 },
    { "Cakm", 274 },
    { "Gunjala_Gondi", 302 },
    { "Gong", 302 },
    { "Inscriptional_Pahlavi", 181 },
    { "Phli", 181 },
    { "Manichaean", 295 },
    { "Mani", 295 },
    { "Khmer", 122 },
    { "Khmr", 122 },
    { "Cuneiform", 154 },
    { "Xsux", 154 },
    { "Khudawadi", 299 },
    { "Sind", 299 },
    { "Mandaic", 294 },
    { "Mand", 294 },
    { "Hatran", 219 },
    { "Hatr", 219 },
    { "Syloti_Nagri", 275 },
    { "Sylo", 275 },
    { "Nko", 157 },
    { "Nkoo", 157 },
    { "Canadian_Aboriginal", 119 },
    { "Cans", 119 },
    { "Meroitic_Hieroglyphs", 189 },
    { "Mero", 189 },
    { "Phoenician", 155 },
    { "Phnx", 155 },
    { "Nabataean", 208 },
    { "Nbat", 208 },
    { "Bengali", 242 },
    { "Beng", 242 },
    { "Glagolitic", 261 },
    { "Glag", 261 },
    { "Imperial_Aramaic", 178 },
    { "Armi", 178 },
    { "Sora_Sompeng", 192 },
    { "Sora", 192 },
    { "Gurmukhi", 268 },
    { "Guru", 268 },
    { "Javanese", 257 },
    { "Java", 257 },
    { "Osage", 227 },
    { "Osge", 227 },
    { "Phags_Pa", 273 },
    { "Phag", 273 },
    { "Cypriot", 258 },
    { "Cprt", 258 },
    { "Kannada", 279 },
    { "Knda", 279 },
    { "Khojki", 267 },
    { "Khoj", 267 },
    { "Mongolian", 272 },
    { "Mong", 272 },
    { "Sinhala", 303 },
    { "Sinh", 303 },
    { "Brahmi", 185 },
    { "Brah", 185 },
    { "Pau_Cin_Hau", 210 },
    { "Pauc", 210 },
    { "Deseret", 131 },
    { "Dsrt", 131 },
    { "Rejang", 164 },
    { "Rjng", 164 },
    { "SignWriting", 222 },
    { "Sgnw", 222 },
    { "Yi", 289 },
    { "Yiii", 289 },
    { "Balinese", 153 },
    { "Bali", 153 },
    { "Lao", 112 },
    { "Laoo", 112 },
    { "Hanunoo", 282 },
    { "Hano", 282 },
    { "Masaram_Gondi", 229 },
    { "Gonm", 229 },
    { "Linear_B", 259 },
    { "Linb", 259 },
    { "Linear_A", 278 },
    { "Lina", 278 },
    { "Dogra", 285 },
    { "Dogr", 285 },
    { "Old_Turkic", 182 },
    { "Orkh", 182 },
    { "Lepcha", 159 },
    { "Lepc", 159 },
    { "Marchen", 225 },
    { "Marc", 225 },
    { "Egyptian_Hieroglyphs", 172 },
    { "Egyp", 172 },
    { "Sogdian", 297 },
    { "Sogd", 297 },
    { "Caucasian_Albanian", 194 },
    { "Aghb", 194 },
    { "Makasar", 235 },
    { "Maka", 235 },
    { "Old_Hungarian", 221 },
    { "Hung", 221 },
    { "Samaritan", 173 },
    { "Samr", 173 },
    { "Lisu", 174 },
    { "Lisu", 174 },
    { "Buhid", 281 },
    { "Buhd", 281 },
    { "Palmyrene", 209 },
    { "Palm", 209 },
    { "Tirhuta", 301 },
    { "Tirh", 301 },
    { "Mro", 206 },
    { "Mroo", 206 },
    { "Common", 240 },
    { "Zyyy", 240 },
    { "Coptic", 249 },
    { "Copt", 249 },
    { "Qaac", 249 },
    { "Modi", 298 },
    { "Modi", 298 },
    { "Arabic", 248 },
    { "Arab", 248 },
    { "Bamum", 175 },
    { "Bamu", 175 },
    { "Myanmar", 276 },
    { "Mymr", 276 },
    { "Siddham", 213 },
    { "Sidd", 213 },
    { "Soyombo", 231 },
    { "Soyo", 231 },
    { "Avestan", 171 },
    { "Avst", 171 },
    { "Hebrew", 97 },
    { "Hebr", 97 },
    { "Psalter_Pahlavi", 296 },
    { "Phlp", 296 },
    { "Takri", 300 },
    { "Takr", 300 },
};

static const struct HashTable scriptExtensionHashTable = 
    { 298, 511, scriptExtensionTableValue, scriptExtensionTableIndex };


