//  SHA1Hash: 81a389480327b85689eda08c7f0dfeaec449e66b
/*
 * Copyright (C) 2020 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 * Autogenerated, do not modify.
*/

#pragma once

#include "ArithProfile.h"
#include "BytecodeDumper.h"
#include "Fits.h"
#include "GetByIdMetadata.h"
#include "GetByValHistory.h"
#include "Instruction.h"
#include "Opcode.h"
#include "PutByIdStatus.h"
#include "PutByIdFlags.h"
#include "ToThisStatus.h"

namespace JSC {

void dumpBytecode(BytecodeDumperBase* dumper, InstructionStream::Offset, const Instruction*);

#if ENABLE(WEBASSEMBLY)
void dumpWasm(BytecodeDumperBase* dumper, InstructionStream::Offset, const Instruction*);
#endif // ENABLE(WEBASSEMBLY)


struct OpHasIndexedProperty : public Instruction {
    static constexpr OpcodeID opcodeID = op_has_indexed_property;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& property, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**has_indexed_property"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_base, false);
        dumper->dumpOperand(m_property, false);
    }

    OpHasIndexedProperty(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpHasIndexedProperty(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpHasIndexedProperty(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpHasIndexedProperty decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpHasIndexedProperty&) { }

        ArrayProfile m_arrayProfile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_property;
    unsigned m_metadataID;
};

struct OpProfileControlFlow : public Instruction {
    static constexpr OpcodeID opcodeID = op_profile_control_flow;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, int textOffset)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, textOffset);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, int textOffset)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, textOffset, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, int textOffset)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, textOffset, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, int textOffset, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, textOffset, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, int textOffset)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, textOffset, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, textOffset, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, textOffset, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, int& textOffset, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<int, __size>::check(textOffset)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, int textOffset, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, textOffset, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<int, __size>::convert(textOffset));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**profile_control_flow"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_textOffset, true);
    }

    OpProfileControlFlow(const uint8_t* stream)
        : m_textOffset(Fits<int, OpcodeSize::Narrow>::convert(stream[0]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpProfileControlFlow(const uint16_t* stream)
        : m_textOffset(Fits<int, OpcodeSize::Wide16>::convert(stream[0]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpProfileControlFlow(const uint32_t* stream)
        : m_textOffset(Fits<int, OpcodeSize::Wide32>::convert(stream[0]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpProfileControlFlow decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setTextOffset(int value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTextOffset<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTextOffset<OpcodeSize::Wide16>(value, func);
        else
            setTextOffset<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTextOffset(int value, Functor func)
    {
        if (!Fits<int, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<int, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpProfileControlFlow&) { }

        BasicBlockLocation* m_basicBlockLocation;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    int m_textOffset;
    unsigned m_metadataID;
};

struct OpProfileType : public Instruction {
    static constexpr OpcodeID opcodeID = op_profile_type;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister targetVirtualRegister, SymbolTableOrScopeDepth symbolTableOrScopeDepth, ProfileTypeBytecodeFlag flag, unsigned identifier, ResolveType resolveType)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, targetVirtualRegister, symbolTableOrScopeDepth, flag, identifier, resolveType);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister targetVirtualRegister, SymbolTableOrScopeDepth symbolTableOrScopeDepth, ProfileTypeBytecodeFlag flag, unsigned identifier, ResolveType resolveType)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, targetVirtualRegister, symbolTableOrScopeDepth, flag, identifier, resolveType, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister targetVirtualRegister, SymbolTableOrScopeDepth symbolTableOrScopeDepth, ProfileTypeBytecodeFlag flag, unsigned identifier, ResolveType resolveType)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, targetVirtualRegister, symbolTableOrScopeDepth, flag, identifier, resolveType, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister targetVirtualRegister, SymbolTableOrScopeDepth symbolTableOrScopeDepth, ProfileTypeBytecodeFlag flag, unsigned identifier, ResolveType resolveType, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, targetVirtualRegister, symbolTableOrScopeDepth, flag, identifier, resolveType, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister targetVirtualRegister, SymbolTableOrScopeDepth symbolTableOrScopeDepth, ProfileTypeBytecodeFlag flag, unsigned identifier, ResolveType resolveType)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, targetVirtualRegister, symbolTableOrScopeDepth, flag, identifier, resolveType, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, targetVirtualRegister, symbolTableOrScopeDepth, flag, identifier, resolveType, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, targetVirtualRegister, symbolTableOrScopeDepth, flag, identifier, resolveType, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& targetVirtualRegister, SymbolTableOrScopeDepth& symbolTableOrScopeDepth, ProfileTypeBytecodeFlag& flag, unsigned& identifier, ResolveType& resolveType, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(targetVirtualRegister)
            && Fits<SymbolTableOrScopeDepth, __size>::check(symbolTableOrScopeDepth)
            && Fits<ProfileTypeBytecodeFlag, __size>::check(flag)
            && Fits<unsigned, __size>::check(identifier)
            && Fits<ResolveType, __size>::check(resolveType)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister targetVirtualRegister, SymbolTableOrScopeDepth symbolTableOrScopeDepth, ProfileTypeBytecodeFlag flag, unsigned identifier, ResolveType resolveType, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, targetVirtualRegister, symbolTableOrScopeDepth, flag, identifier, resolveType, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(targetVirtualRegister));
            gen->write(Fits<SymbolTableOrScopeDepth, __size>::convert(symbolTableOrScopeDepth));
            gen->write(Fits<ProfileTypeBytecodeFlag, __size>::convert(flag));
            gen->write(Fits<unsigned, __size>::convert(identifier));
            gen->write(Fits<ResolveType, __size>::convert(resolveType));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**profile_type"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_targetVirtualRegister, true);
        dumper->dumpOperand(m_symbolTableOrScopeDepth, false);
        dumper->dumpOperand(m_flag, false);
        dumper->dumpOperand(m_identifier, false);
        dumper->dumpOperand(m_resolveType, false);
    }

    OpProfileType(const uint8_t* stream)
        : m_targetVirtualRegister(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_symbolTableOrScopeDepth(Fits<SymbolTableOrScopeDepth, OpcodeSize::Narrow>::convert(stream[1]))
        , m_flag(Fits<ProfileTypeBytecodeFlag, OpcodeSize::Narrow>::convert(stream[2]))
        , m_identifier(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_resolveType(Fits<ResolveType, OpcodeSize::Narrow>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpProfileType(const uint16_t* stream)
        : m_targetVirtualRegister(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_symbolTableOrScopeDepth(Fits<SymbolTableOrScopeDepth, OpcodeSize::Wide16>::convert(stream[1]))
        , m_flag(Fits<ProfileTypeBytecodeFlag, OpcodeSize::Wide16>::convert(stream[2]))
        , m_identifier(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_resolveType(Fits<ResolveType, OpcodeSize::Wide16>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpProfileType(const uint32_t* stream)
        : m_targetVirtualRegister(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_symbolTableOrScopeDepth(Fits<SymbolTableOrScopeDepth, OpcodeSize::Wide32>::convert(stream[1]))
        , m_flag(Fits<ProfileTypeBytecodeFlag, OpcodeSize::Wide32>::convert(stream[2]))
        , m_identifier(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_resolveType(Fits<ResolveType, OpcodeSize::Wide32>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpProfileType decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setTargetVirtualRegister(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTargetVirtualRegister<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTargetVirtualRegister<OpcodeSize::Wide16>(value, func);
        else
            setTargetVirtualRegister<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetVirtualRegister(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setSymbolTableOrScopeDepth(SymbolTableOrScopeDepth value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setSymbolTableOrScopeDepth<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setSymbolTableOrScopeDepth<OpcodeSize::Wide16>(value, func);
        else
            setSymbolTableOrScopeDepth<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSymbolTableOrScopeDepth(SymbolTableOrScopeDepth value, Functor func)
    {
        if (!Fits<SymbolTableOrScopeDepth, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<SymbolTableOrScopeDepth, size>::convert(value);
    }

    template<typename Functor>
    void setFlag(ProfileTypeBytecodeFlag value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setFlag<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setFlag<OpcodeSize::Wide16>(value, func);
        else
            setFlag<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFlag(ProfileTypeBytecodeFlag value, Functor func)
    {
        if (!Fits<ProfileTypeBytecodeFlag, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<ProfileTypeBytecodeFlag, size>::convert(value);
    }

    template<typename Functor>
    void setIdentifier(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setIdentifier<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setIdentifier<OpcodeSize::Wide16>(value, func);
        else
            setIdentifier<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIdentifier(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setResolveType(ResolveType value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setResolveType<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setResolveType<OpcodeSize::Wide16>(value, func);
        else
            setResolveType<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setResolveType(ResolveType value, Functor func)
    {
        if (!Fits<ResolveType, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<ResolveType, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpProfileType&) { }

        TypeLocation* m_typeLocation;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_targetVirtualRegister;
    SymbolTableOrScopeDepth m_symbolTableOrScopeDepth;
    ProfileTypeBytecodeFlag m_flag;
    unsigned m_identifier;
    ResolveType m_resolveType;
    unsigned m_metadataID;
};

struct OpCatch : public Instruction {
    static constexpr OpcodeID opcodeID = op_catch;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister exception, VirtualRegister thrownValue)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, exception, thrownValue);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister exception, VirtualRegister thrownValue)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, exception, thrownValue, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister exception, VirtualRegister thrownValue)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, exception, thrownValue, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister exception, VirtualRegister thrownValue, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, exception, thrownValue, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister exception, VirtualRegister thrownValue)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, exception, thrownValue, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, exception, thrownValue, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, exception, thrownValue, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& exception, VirtualRegister& thrownValue, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(exception)
            && Fits<VirtualRegister, __size>::check(thrownValue)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister exception, VirtualRegister thrownValue, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, exception, thrownValue, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(exception));
            gen->write(Fits<VirtualRegister, __size>::convert(thrownValue));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**catch"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_exception, true);
        dumper->dumpOperand(m_thrownValue, false);
    }

    OpCatch(const uint8_t* stream)
        : m_exception(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_thrownValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpCatch(const uint16_t* stream)
        : m_exception(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_thrownValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpCatch(const uint32_t* stream)
        : m_exception(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_thrownValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpCatch decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setException(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setException<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setException<OpcodeSize::Wide16>(value, func);
        else
            setException<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setException(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThrownValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setThrownValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setThrownValue<OpcodeSize::Wide16>(value, func);
        else
            setThrownValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThrownValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpCatch&) { }

        ValueProfileAndVirtualRegisterBuffer* m_buffer;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_exception;
    VirtualRegister m_thrownValue;
    unsigned m_metadataID;
};

struct OpGetFromArguments : public Instruction {
    static constexpr OpcodeID opcodeID = op_get_from_arguments;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister arguments, unsigned index)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, arguments, index);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister arguments, unsigned index)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, arguments, index, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister arguments, unsigned index)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, arguments, index, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister arguments, unsigned index, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, arguments, index, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister arguments, unsigned index)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, arguments, index, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, arguments, index, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, arguments, index, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& arguments, unsigned& index, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(arguments)
            && Fits<unsigned, __size>::check(index)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister arguments, unsigned index, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, arguments, index, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(arguments));
            gen->write(Fits<unsigned, __size>::convert(index));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_from_arguments"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_arguments, false);
        dumper->dumpOperand(m_index, false);
    }

    OpGetFromArguments(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_index(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpGetFromArguments(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_index(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpGetFromArguments(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_index(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpGetFromArguments decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setArguments<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setArguments<OpcodeSize::Wide16>(value, func);
        else
            setArguments<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIndex(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setIndex<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setIndex<OpcodeSize::Wide16>(value, func);
        else
            setIndex<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIndex(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpGetFromArguments&) { }

        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_arguments;
    unsigned m_index;
    unsigned m_metadataID;
};

struct OpPutToScope : public Instruction {
    static constexpr OpcodeID opcodeID = op_put_to_scope;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister scope, unsigned var, VirtualRegister value, GetPutInfo getPutInfo, SymbolTableOrScopeDepth symbolTableOrScopeDepth, unsigned offset)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, scope, var, value, getPutInfo, symbolTableOrScopeDepth, offset);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister scope, unsigned var, VirtualRegister value, GetPutInfo getPutInfo, SymbolTableOrScopeDepth symbolTableOrScopeDepth, unsigned offset)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, scope, var, value, getPutInfo, symbolTableOrScopeDepth, offset, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister scope, unsigned var, VirtualRegister value, GetPutInfo getPutInfo, SymbolTableOrScopeDepth symbolTableOrScopeDepth, unsigned offset)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, scope, var, value, getPutInfo, symbolTableOrScopeDepth, offset, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister scope, unsigned var, VirtualRegister value, GetPutInfo getPutInfo, SymbolTableOrScopeDepth symbolTableOrScopeDepth, unsigned offset, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, scope, var, value, getPutInfo, symbolTableOrScopeDepth, offset, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister scope, unsigned var, VirtualRegister value, GetPutInfo getPutInfo, SymbolTableOrScopeDepth symbolTableOrScopeDepth, unsigned offset)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, scope, var, value, getPutInfo, symbolTableOrScopeDepth, offset, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, scope, var, value, getPutInfo, symbolTableOrScopeDepth, offset, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, scope, var, value, getPutInfo, symbolTableOrScopeDepth, offset, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& scope, unsigned& var, VirtualRegister& value, GetPutInfo& getPutInfo, SymbolTableOrScopeDepth& symbolTableOrScopeDepth, unsigned& offset, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(scope)
            && Fits<unsigned, __size>::check(var)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<GetPutInfo, __size>::check(getPutInfo)
            && Fits<SymbolTableOrScopeDepth, __size>::check(symbolTableOrScopeDepth)
            && Fits<unsigned, __size>::check(offset)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister scope, unsigned var, VirtualRegister value, GetPutInfo getPutInfo, SymbolTableOrScopeDepth symbolTableOrScopeDepth, unsigned offset, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, scope, var, value, getPutInfo, symbolTableOrScopeDepth, offset, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(scope));
            gen->write(Fits<unsigned, __size>::convert(var));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<GetPutInfo, __size>::convert(getPutInfo));
            gen->write(Fits<SymbolTableOrScopeDepth, __size>::convert(symbolTableOrScopeDepth));
            gen->write(Fits<unsigned, __size>::convert(offset));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_to_scope"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_scope, true);
        dumper->dumpOperand(m_var, false);
        dumper->dumpOperand(m_value, false);
        dumper->dumpOperand(m_getPutInfo, false);
        dumper->dumpOperand(m_symbolTableOrScopeDepth, false);
        dumper->dumpOperand(m_offset, false);
    }

    OpPutToScope(const uint8_t* stream)
        : m_scope(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_var(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_getPutInfo(Fits<GetPutInfo, OpcodeSize::Narrow>::convert(stream[3]))
        , m_symbolTableOrScopeDepth(Fits<SymbolTableOrScopeDepth, OpcodeSize::Narrow>::convert(stream[4]))
        , m_offset(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpPutToScope(const uint16_t* stream)
        : m_scope(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_var(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_getPutInfo(Fits<GetPutInfo, OpcodeSize::Wide16>::convert(stream[3]))
        , m_symbolTableOrScopeDepth(Fits<SymbolTableOrScopeDepth, OpcodeSize::Wide16>::convert(stream[4]))
        , m_offset(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpPutToScope(const uint32_t* stream)
        : m_scope(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_var(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_getPutInfo(Fits<GetPutInfo, OpcodeSize::Wide32>::convert(stream[3]))
        , m_symbolTableOrScopeDepth(Fits<SymbolTableOrScopeDepth, OpcodeSize::Wide32>::convert(stream[4]))
        , m_offset(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpPutToScope decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setScope(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setScope<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setScope<OpcodeSize::Wide16>(value, func);
        else
            setScope<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setScope(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setVar(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setVar<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setVar<OpcodeSize::Wide16>(value, func);
        else
            setVar<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setVar(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setGetPutInfo(GetPutInfo value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setGetPutInfo<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setGetPutInfo<OpcodeSize::Wide16>(value, func);
        else
            setGetPutInfo<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setGetPutInfo(GetPutInfo value, Functor func)
    {
        if (!Fits<GetPutInfo, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<GetPutInfo, size>::convert(value);
    }

    template<typename Functor>
    void setSymbolTableOrScopeDepth(SymbolTableOrScopeDepth value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setSymbolTableOrScopeDepth<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setSymbolTableOrScopeDepth<OpcodeSize::Wide16>(value, func);
        else
            setSymbolTableOrScopeDepth<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSymbolTableOrScopeDepth(SymbolTableOrScopeDepth value, Functor func)
    {
        if (!Fits<SymbolTableOrScopeDepth, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<SymbolTableOrScopeDepth, size>::convert(value);
    }

    template<typename Functor>
    void setOffset(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOffset<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOffset<OpcodeSize::Wide16>(value, func);
        else
            setOffset<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOffset(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpPutToScope& __op)
            : m_getPutInfo(__op.m_getPutInfo)
            , m_operand(__op.m_offset)
        { }

        GetPutInfo m_getPutInfo;
        union {
            WriteBarrierBase<Structure> m_structure;
            WatchpointSet* m_watchpointSet;
        };
        uintptr_t m_operand;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_scope;
    unsigned m_var;
    VirtualRegister m_value;
    GetPutInfo m_getPutInfo;
    SymbolTableOrScopeDepth m_symbolTableOrScopeDepth;
    unsigned m_offset;
    unsigned m_metadataID;
};

struct OpGetFromScope : public Instruction {
    static constexpr OpcodeID opcodeID = op_get_from_scope;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, GetPutInfo getPutInfo, unsigned localScopeDepth, unsigned offset)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, scope, var, getPutInfo, localScopeDepth, offset);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, GetPutInfo getPutInfo, unsigned localScopeDepth, unsigned offset)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, scope, var, getPutInfo, localScopeDepth, offset, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, GetPutInfo getPutInfo, unsigned localScopeDepth, unsigned offset)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, scope, var, getPutInfo, localScopeDepth, offset, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, GetPutInfo getPutInfo, unsigned localScopeDepth, unsigned offset, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, scope, var, getPutInfo, localScopeDepth, offset, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, GetPutInfo getPutInfo, unsigned localScopeDepth, unsigned offset)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, scope, var, getPutInfo, localScopeDepth, offset, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, scope, var, getPutInfo, localScopeDepth, offset, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, scope, var, getPutInfo, localScopeDepth, offset, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& scope, unsigned& var, GetPutInfo& getPutInfo, unsigned& localScopeDepth, unsigned& offset, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(scope)
            && Fits<unsigned, __size>::check(var)
            && Fits<GetPutInfo, __size>::check(getPutInfo)
            && Fits<unsigned, __size>::check(localScopeDepth)
            && Fits<unsigned, __size>::check(offset)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, GetPutInfo getPutInfo, unsigned localScopeDepth, unsigned offset, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, scope, var, getPutInfo, localScopeDepth, offset, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(scope));
            gen->write(Fits<unsigned, __size>::convert(var));
            gen->write(Fits<GetPutInfo, __size>::convert(getPutInfo));
            gen->write(Fits<unsigned, __size>::convert(localScopeDepth));
            gen->write(Fits<unsigned, __size>::convert(offset));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_from_scope"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_scope, false);
        dumper->dumpOperand(m_var, false);
        dumper->dumpOperand(m_getPutInfo, false);
        dumper->dumpOperand(m_localScopeDepth, false);
        dumper->dumpOperand(m_offset, false);
    }

    OpGetFromScope(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_scope(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_var(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_getPutInfo(Fits<GetPutInfo, OpcodeSize::Narrow>::convert(stream[3]))
        , m_localScopeDepth(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
        , m_offset(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpGetFromScope(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_scope(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_var(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_getPutInfo(Fits<GetPutInfo, OpcodeSize::Wide16>::convert(stream[3]))
        , m_localScopeDepth(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
        , m_offset(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpGetFromScope(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_scope(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_var(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_getPutInfo(Fits<GetPutInfo, OpcodeSize::Wide32>::convert(stream[3]))
        , m_localScopeDepth(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
        , m_offset(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpGetFromScope decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setScope(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setScope<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setScope<OpcodeSize::Wide16>(value, func);
        else
            setScope<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setScope(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setVar(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setVar<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setVar<OpcodeSize::Wide16>(value, func);
        else
            setVar<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setVar(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setGetPutInfo(GetPutInfo value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setGetPutInfo<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setGetPutInfo<OpcodeSize::Wide16>(value, func);
        else
            setGetPutInfo<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setGetPutInfo(GetPutInfo value, Functor func)
    {
        if (!Fits<GetPutInfo, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<GetPutInfo, size>::convert(value);
    }

    template<typename Functor>
    void setLocalScopeDepth(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLocalScopeDepth<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLocalScopeDepth<OpcodeSize::Wide16>(value, func);
        else
            setLocalScopeDepth<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLocalScopeDepth(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setOffset(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOffset<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOffset<OpcodeSize::Wide16>(value, func);
        else
            setOffset<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOffset(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpGetFromScope& __op)
            : m_getPutInfo(__op.m_getPutInfo)
            , m_operand(__op.m_offset)
        { }

        GetPutInfo m_getPutInfo;
        union {
            WatchpointSet* m_watchpointSet;
            WriteBarrierBase<Structure> m_structure;
        };
        uintptr_t m_operand;
        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_scope;
    unsigned m_var;
    GetPutInfo m_getPutInfo;
    unsigned m_localScopeDepth;
    unsigned m_offset;
    unsigned m_metadataID;
};

struct OpGetInternalField : public Instruction {
    static constexpr OpcodeID opcodeID = op_get_internal_field;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned index)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, index);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned index)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, index, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned index)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, index, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned index, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, index, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned index)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, index, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, index, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, index, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, unsigned& index, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(index)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned index, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, index, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(index));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_internal_field"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_base, false);
        dumper->dumpOperand(m_index, false);
    }

    OpGetInternalField(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_index(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpGetInternalField(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_index(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpGetInternalField(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_index(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpGetInternalField decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIndex(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setIndex<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setIndex<OpcodeSize::Wide16>(value, func);
        else
            setIndex<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIndex(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpGetInternalField&) { }

        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    unsigned m_index;
    unsigned m_metadataID;
};

struct OpCreateThis : public Instruction {
    static constexpr OpcodeID opcodeID = op_create_this;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned inlineCapacity)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, inlineCapacity);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned inlineCapacity)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, inlineCapacity, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned inlineCapacity)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, inlineCapacity, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned inlineCapacity, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, inlineCapacity, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned inlineCapacity)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, inlineCapacity, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, inlineCapacity, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, inlineCapacity, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, unsigned& inlineCapacity, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<unsigned, __size>::check(inlineCapacity)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned inlineCapacity, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, inlineCapacity, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<unsigned, __size>::convert(inlineCapacity));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**create_this"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_callee, false);
        dumper->dumpOperand(m_inlineCapacity, false);
    }

    OpCreateThis(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_inlineCapacity(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpCreateThis(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_inlineCapacity(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpCreateThis(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_inlineCapacity(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpCreateThis decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setInlineCapacity(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setInlineCapacity<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setInlineCapacity<OpcodeSize::Wide16>(value, func);
        else
            setInlineCapacity<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setInlineCapacity(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpCreateThis&) { }

        WriteBarrier<JSCell> m_cachedCallee;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    unsigned m_inlineCapacity;
    unsigned m_metadataID;
};

struct OpCreatePromise : public Instruction {
    static constexpr OpcodeID opcodeID = op_create_promise;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, bool isInternalPromise)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, isInternalPromise);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, bool isInternalPromise)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, isInternalPromise, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, bool isInternalPromise)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, isInternalPromise, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, bool isInternalPromise, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, isInternalPromise, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, bool isInternalPromise)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, isInternalPromise, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, isInternalPromise, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, isInternalPromise, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, bool& isInternalPromise, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<bool, __size>::check(isInternalPromise)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, bool isInternalPromise, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, isInternalPromise, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<bool, __size>::convert(isInternalPromise));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**create_promise"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_callee, false);
        dumper->dumpOperand(m_isInternalPromise, false);
    }

    OpCreatePromise(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_isInternalPromise(Fits<bool, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpCreatePromise(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_isInternalPromise(Fits<bool, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpCreatePromise(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_isInternalPromise(Fits<bool, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpCreatePromise decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIsInternalPromise(bool value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setIsInternalPromise<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setIsInternalPromise<OpcodeSize::Wide16>(value, func);
        else
            setIsInternalPromise<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIsInternalPromise(bool value, Functor func)
    {
        if (!Fits<bool, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<bool, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpCreatePromise&) { }

        WriteBarrier<JSCell> m_cachedCallee;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    bool m_isInternalPromise;
    unsigned m_metadataID;
};

struct OpResolveScope : public Instruction {
    static constexpr OpcodeID opcodeID = op_resolve_scope;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, ResolveType resolveType, unsigned localScopeDepth)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, scope, var, resolveType, localScopeDepth);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, ResolveType resolveType, unsigned localScopeDepth)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, scope, var, resolveType, localScopeDepth, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, ResolveType resolveType, unsigned localScopeDepth)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, scope, var, resolveType, localScopeDepth, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, ResolveType resolveType, unsigned localScopeDepth, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, scope, var, resolveType, localScopeDepth, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, ResolveType resolveType, unsigned localScopeDepth)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, scope, var, resolveType, localScopeDepth, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, scope, var, resolveType, localScopeDepth, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, scope, var, resolveType, localScopeDepth, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& scope, unsigned& var, ResolveType& resolveType, unsigned& localScopeDepth, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(scope)
            && Fits<unsigned, __size>::check(var)
            && Fits<ResolveType, __size>::check(resolveType)
            && Fits<unsigned, __size>::check(localScopeDepth)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister scope, unsigned var, ResolveType resolveType, unsigned localScopeDepth, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, scope, var, resolveType, localScopeDepth, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(scope));
            gen->write(Fits<unsigned, __size>::convert(var));
            gen->write(Fits<ResolveType, __size>::convert(resolveType));
            gen->write(Fits<unsigned, __size>::convert(localScopeDepth));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**resolve_scope"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_scope, false);
        dumper->dumpOperand(m_var, false);
        dumper->dumpOperand(m_resolveType, false);
        dumper->dumpOperand(m_localScopeDepth, false);
    }

    OpResolveScope(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_scope(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_var(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_resolveType(Fits<ResolveType, OpcodeSize::Narrow>::convert(stream[3]))
        , m_localScopeDepth(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpResolveScope(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_scope(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_var(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_resolveType(Fits<ResolveType, OpcodeSize::Wide16>::convert(stream[3]))
        , m_localScopeDepth(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpResolveScope(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_scope(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_var(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_resolveType(Fits<ResolveType, OpcodeSize::Wide32>::convert(stream[3]))
        , m_localScopeDepth(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpResolveScope decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setScope(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setScope<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setScope<OpcodeSize::Wide16>(value, func);
        else
            setScope<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setScope(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setVar(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setVar<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setVar<OpcodeSize::Wide16>(value, func);
        else
            setVar<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setVar(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setResolveType(ResolveType value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setResolveType<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setResolveType<OpcodeSize::Wide16>(value, func);
        else
            setResolveType<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setResolveType(ResolveType value, Functor func)
    {
        if (!Fits<ResolveType, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<ResolveType, size>::convert(value);
    }

    template<typename Functor>
    void setLocalScopeDepth(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLocalScopeDepth<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLocalScopeDepth<OpcodeSize::Wide16>(value, func);
        else
            setLocalScopeDepth<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLocalScopeDepth(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpResolveScope&) { }

        ResolveType m_resolveType;
        union {
            unsigned m_localScopeDepth;
            unsigned m_globalLexicalBindingEpoch;
        };
        union {
            WriteBarrierBase<JSCell> m_lexicalEnvironment;
            WriteBarrierBase<SymbolTable> m_symbolTable;
            WriteBarrierBase<JSScope> m_constantScope;
            WriteBarrierBase<JSGlobalLexicalEnvironment> m_globalLexicalEnvironment;
            WriteBarrierBase<JSGlobalObject> m_globalObject;
        };
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_scope;
    unsigned m_var;
    ResolveType m_resolveType;
    unsigned m_localScopeDepth;
    unsigned m_metadataID;
};

struct OpConstructVarargs : public Instruction {
    static constexpr OpcodeID opcodeID = op_construct_varargs;
    enum Tmps : uint8_t {
        argCountIncludingThis,
    };
    enum Checkpoints : uint8_t {
        determiningArgCount,
        makeCall,
        numberOfCheckpoints,
    };

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, VirtualRegister& thisValue, VirtualRegister& arguments, VirtualRegister& firstFree, int& firstVarArg, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<VirtualRegister, __size>::check(arguments)
            && Fits<VirtualRegister, __size>::check(firstFree)
            && Fits<int, __size>::check(firstVarArg)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned __metadataID)
    {
        gen->setUsesCheckpoints();
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<VirtualRegister, __size>::convert(arguments));
            gen->write(Fits<VirtualRegister, __size>::convert(firstFree));
            gen->write(Fits<int, __size>::convert(firstVarArg));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**construct_varargs"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_callee, false);
        dumper->dumpOperand(m_thisValue, false);
        dumper->dumpOperand(m_arguments, false);
        dumper->dumpOperand(m_firstFree, false);
        dumper->dumpOperand(m_firstVarArg, false);
    }

    OpConstructVarargs(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Narrow>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpConstructVarargs(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide16>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpConstructVarargs(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide32>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpConstructVarargs decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setArguments<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setArguments<OpcodeSize::Wide16>(value, func);
        else
            setArguments<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setFirstFree<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setFirstFree<OpcodeSize::Wide16>(value, func);
        else
            setFirstFree<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setFirstVarArg<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setFirstVarArg<OpcodeSize::Wide16>(value, func);
        else
            setFirstVarArg<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (!Fits<int, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<int, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpConstructVarargs&) { }

        ArrayProfile m_arrayProfile;
        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    VirtualRegister m_thisValue;
    VirtualRegister m_arguments;
    VirtualRegister m_firstFree;
    int m_firstVarArg;
    unsigned m_metadataID;
};

struct OpCreateGenerator : public Instruction {
    static constexpr OpcodeID opcodeID = op_create_generator;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**create_generator"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_callee, false);
    }

    OpCreateGenerator(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpCreateGenerator(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpCreateGenerator(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpCreateGenerator decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpCreateGenerator&) { }

        WriteBarrier<JSCell> m_cachedCallee;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    unsigned m_metadataID;
};

struct OpCreateAsyncGenerator : public Instruction {
    static constexpr OpcodeID opcodeID = op_create_async_generator;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**create_async_generator"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_callee, false);
    }

    OpCreateAsyncGenerator(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpCreateAsyncGenerator(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpCreateAsyncGenerator(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpCreateAsyncGenerator decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpCreateAsyncGenerator&) { }

        WriteBarrier<JSCell> m_cachedCallee;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    unsigned m_metadataID;
};

struct OpGetArgument : public Instruction {
    static constexpr OpcodeID opcodeID = op_get_argument;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, int index)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, index);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, int index)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, index, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, int index)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, index, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, int index, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, index, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, int index)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, index, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, index, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, index, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, int& index, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<int, __size>::check(index)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, int index, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, index, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<int, __size>::convert(index));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_argument"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_index, false);
    }

    OpGetArgument(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_index(Fits<int, OpcodeSize::Narrow>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpGetArgument(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_index(Fits<int, OpcodeSize::Wide16>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpGetArgument(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_index(Fits<int, OpcodeSize::Wide32>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpGetArgument decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIndex(int value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setIndex<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setIndex<OpcodeSize::Wide16>(value, func);
        else
            setIndex<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIndex(int value, Functor func)
    {
        if (!Fits<int, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<int, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpGetArgument&) { }

        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    int m_index;
    unsigned m_metadataID;
};

struct OpConstruct : public Instruction {
    static constexpr OpcodeID opcodeID = op_construct;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, argc, argv);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, argc, argv, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, argc, argv, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, argc, argv, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, argc, argv, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, unsigned& argc, unsigned& argv, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<unsigned, __size>::check(argc)
            && Fits<unsigned, __size>::check(argv)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, argc, argv, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<unsigned, __size>::convert(argc));
            gen->write(Fits<unsigned, __size>::convert(argv));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**construct"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_callee, false);
        dumper->dumpOperand(m_argc, false);
        dumper->dumpOperand(m_argv, false);
    }

    OpConstruct(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpConstruct(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpConstruct(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpConstruct decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setArgc<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setArgc<OpcodeSize::Wide16>(value, func);
        else
            setArgc<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setArgv<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setArgv<OpcodeSize::Wide16>(value, func);
        else
            setArgv<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpConstruct&) { }

        LLIntCallLinkInfo m_callLinkInfo;
        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    unsigned m_argc;
    unsigned m_argv;
    unsigned m_metadataID;
};

struct OpToThis : public Instruction {
    static constexpr OpcodeID opcodeID = op_to_this;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister srcDst)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, srcDst);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister srcDst)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, srcDst, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister srcDst)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, srcDst, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister srcDst, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, srcDst, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister srcDst)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, srcDst, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, srcDst, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, srcDst, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& srcDst, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(srcDst)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister srcDst, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, srcDst, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(srcDst));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**to_this"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_srcDst, true);
    }

    OpToThis(const uint8_t* stream)
        : m_srcDst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpToThis(const uint16_t* stream)
        : m_srcDst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpToThis(const uint32_t* stream)
        : m_srcDst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpToThis decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setSrcDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setSrcDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setSrcDst<OpcodeSize::Wide16>(value, func);
        else
            setSrcDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSrcDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpToThis&) { }

        StructureID m_cachedStructureID;
        ToThisStatus m_toThisStatus;
        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_srcDst;
    unsigned m_metadataID;
};

struct OpTailCallForwardArguments : public Instruction {
    static constexpr OpcodeID opcodeID = op_tail_call_forward_arguments;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, VirtualRegister& thisValue, VirtualRegister& arguments, VirtualRegister& firstFree, int& firstVarArg, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<VirtualRegister, __size>::check(arguments)
            && Fits<VirtualRegister, __size>::check(firstFree)
            && Fits<int, __size>::check(firstVarArg)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<VirtualRegister, __size>::convert(arguments));
            gen->write(Fits<VirtualRegister, __size>::convert(firstFree));
            gen->write(Fits<int, __size>::convert(firstVarArg));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**tail_call_forward_arguments"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_callee, false);
        dumper->dumpOperand(m_thisValue, false);
        dumper->dumpOperand(m_arguments, false);
        dumper->dumpOperand(m_firstFree, false);
        dumper->dumpOperand(m_firstVarArg, false);
    }

    OpTailCallForwardArguments(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Narrow>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpTailCallForwardArguments(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide16>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpTailCallForwardArguments(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide32>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpTailCallForwardArguments decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setArguments<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setArguments<OpcodeSize::Wide16>(value, func);
        else
            setArguments<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setFirstFree<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setFirstFree<OpcodeSize::Wide16>(value, func);
        else
            setFirstFree<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setFirstVarArg<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setFirstVarArg<OpcodeSize::Wide16>(value, func);
        else
            setFirstVarArg<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (!Fits<int, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<int, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpTailCallForwardArguments&) { }

        ArrayProfile m_arrayProfile;
        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    VirtualRegister m_thisValue;
    VirtualRegister m_arguments;
    VirtualRegister m_firstFree;
    int m_firstVarArg;
    unsigned m_metadataID;
};

struct OpNewObject : public Instruction {
    static constexpr OpcodeID opcodeID = op_new_object;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, unsigned inlineCapacity)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, inlineCapacity);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, unsigned inlineCapacity)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, inlineCapacity, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, unsigned inlineCapacity)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, inlineCapacity, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, unsigned inlineCapacity, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, inlineCapacity, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, unsigned inlineCapacity)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, inlineCapacity, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, inlineCapacity, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, inlineCapacity, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, unsigned& inlineCapacity, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<unsigned, __size>::check(inlineCapacity)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, unsigned inlineCapacity, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, inlineCapacity, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<unsigned, __size>::convert(inlineCapacity));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**new_object"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_inlineCapacity, false);
    }

    OpNewObject(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_inlineCapacity(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpNewObject(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_inlineCapacity(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpNewObject(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_inlineCapacity(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpNewObject decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setInlineCapacity(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setInlineCapacity<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setInlineCapacity<OpcodeSize::Wide16>(value, func);
        else
            setInlineCapacity<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setInlineCapacity(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpNewObject&) { }

        ObjectAllocationProfile m_objectAllocationProfile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    unsigned m_inlineCapacity;
    unsigned m_metadataID;
};

struct OpNewArray : public Instruction {
    static constexpr OpcodeID opcodeID = op_new_array;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister argv, unsigned argc, IndexingType recommendedIndexingType)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, argv, argc, recommendedIndexingType);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister argv, unsigned argc, IndexingType recommendedIndexingType)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, argv, argc, recommendedIndexingType, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister argv, unsigned argc, IndexingType recommendedIndexingType)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, argv, argc, recommendedIndexingType, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister argv, unsigned argc, IndexingType recommendedIndexingType, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, argv, argc, recommendedIndexingType, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister argv, unsigned argc, IndexingType recommendedIndexingType)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, argv, argc, recommendedIndexingType, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, argv, argc, recommendedIndexingType, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, argv, argc, recommendedIndexingType, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& argv, unsigned& argc, IndexingType& recommendedIndexingType, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(argv)
            && Fits<unsigned, __size>::check(argc)
            && Fits<IndexingType, __size>::check(recommendedIndexingType)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister argv, unsigned argc, IndexingType recommendedIndexingType, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, argv, argc, recommendedIndexingType, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(argv));
            gen->write(Fits<unsigned, __size>::convert(argc));
            gen->write(Fits<IndexingType, __size>::convert(recommendedIndexingType));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**new_array"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_argv, false);
        dumper->dumpOperand(m_argc, false);
        dumper->dumpOperand(m_recommendedIndexingType, false);
    }

    OpNewArray(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_argv(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_recommendedIndexingType(Fits<IndexingType, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpNewArray(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_argv(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_recommendedIndexingType(Fits<IndexingType, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpNewArray(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_argv(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_recommendedIndexingType(Fits<IndexingType, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpNewArray decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArgv(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setArgv<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setArgv<OpcodeSize::Wide16>(value, func);
        else
            setArgv<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgv(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setArgc<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setArgc<OpcodeSize::Wide16>(value, func);
        else
            setArgc<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setRecommendedIndexingType(IndexingType value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRecommendedIndexingType<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRecommendedIndexingType<OpcodeSize::Wide16>(value, func);
        else
            setRecommendedIndexingType<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRecommendedIndexingType(IndexingType value, Functor func)
    {
        if (!Fits<IndexingType, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<IndexingType, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpNewArray&) { }

        ArrayAllocationProfile m_arrayAllocationProfile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_argv;
    unsigned m_argc;
    IndexingType m_recommendedIndexingType;
    unsigned m_metadataID;
};

struct OpNewArrayWithSize : public Instruction {
    static constexpr OpcodeID opcodeID = op_new_array_with_size;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, length);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, length, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, length, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, length, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, length, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, length, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, length, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& length, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(length)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister length, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, length, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(length));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**new_array_with_size"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_length, false);
    }

    OpNewArrayWithSize(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_length(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpNewArrayWithSize(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_length(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpNewArrayWithSize(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_length(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpNewArrayWithSize decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLength(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLength<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLength<OpcodeSize::Wide16>(value, func);
        else
            setLength<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLength(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpNewArrayWithSize&) { }

        ArrayAllocationProfile m_arrayAllocationProfile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_length;
    unsigned m_metadataID;
};

struct OpNewArrayBuffer : public Instruction {
    static constexpr OpcodeID opcodeID = op_new_array_buffer;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister immutableButterfly, IndexingType recommendedIndexingType)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, immutableButterfly, recommendedIndexingType);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister immutableButterfly, IndexingType recommendedIndexingType)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, immutableButterfly, recommendedIndexingType, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister immutableButterfly, IndexingType recommendedIndexingType)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, immutableButterfly, recommendedIndexingType, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister immutableButterfly, IndexingType recommendedIndexingType, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, immutableButterfly, recommendedIndexingType, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister immutableButterfly, IndexingType recommendedIndexingType)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, immutableButterfly, recommendedIndexingType, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, immutableButterfly, recommendedIndexingType, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, immutableButterfly, recommendedIndexingType, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& immutableButterfly, IndexingType& recommendedIndexingType, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(immutableButterfly)
            && Fits<IndexingType, __size>::check(recommendedIndexingType)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister immutableButterfly, IndexingType recommendedIndexingType, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, immutableButterfly, recommendedIndexingType, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(immutableButterfly));
            gen->write(Fits<IndexingType, __size>::convert(recommendedIndexingType));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**new_array_buffer"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_immutableButterfly, false);
        dumper->dumpOperand(m_recommendedIndexingType, false);
    }

    OpNewArrayBuffer(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_immutableButterfly(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_recommendedIndexingType(Fits<IndexingType, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpNewArrayBuffer(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_immutableButterfly(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_recommendedIndexingType(Fits<IndexingType, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpNewArrayBuffer(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_immutableButterfly(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_recommendedIndexingType(Fits<IndexingType, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpNewArrayBuffer decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setImmutableButterfly(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setImmutableButterfly<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setImmutableButterfly<OpcodeSize::Wide16>(value, func);
        else
            setImmutableButterfly<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setImmutableButterfly(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRecommendedIndexingType(IndexingType value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRecommendedIndexingType<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRecommendedIndexingType<OpcodeSize::Wide16>(value, func);
        else
            setRecommendedIndexingType<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRecommendedIndexingType(IndexingType value, Functor func)
    {
        if (!Fits<IndexingType, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<IndexingType, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpNewArrayBuffer&) { }

        ArrayAllocationProfile m_arrayAllocationProfile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_immutableButterfly;
    IndexingType m_recommendedIndexingType;
    unsigned m_metadataID;
};

struct OpTailCallVarargs : public Instruction {
    static constexpr OpcodeID opcodeID = op_tail_call_varargs;
    enum Tmps : uint8_t {
        argCountIncludingThis,
    };
    enum Checkpoints : uint8_t {
        determiningArgCount,
        makeCall,
        numberOfCheckpoints,
    };

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, VirtualRegister& thisValue, VirtualRegister& arguments, VirtualRegister& firstFree, int& firstVarArg, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<VirtualRegister, __size>::check(arguments)
            && Fits<VirtualRegister, __size>::check(firstFree)
            && Fits<int, __size>::check(firstVarArg)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned __metadataID)
    {
        gen->setUsesCheckpoints();
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<VirtualRegister, __size>::convert(arguments));
            gen->write(Fits<VirtualRegister, __size>::convert(firstFree));
            gen->write(Fits<int, __size>::convert(firstVarArg));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**tail_call_varargs"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_callee, false);
        dumper->dumpOperand(m_thisValue, false);
        dumper->dumpOperand(m_arguments, false);
        dumper->dumpOperand(m_firstFree, false);
        dumper->dumpOperand(m_firstVarArg, false);
    }

    OpTailCallVarargs(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Narrow>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpTailCallVarargs(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide16>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpTailCallVarargs(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide32>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpTailCallVarargs decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setArguments<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setArguments<OpcodeSize::Wide16>(value, func);
        else
            setArguments<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setFirstFree<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setFirstFree<OpcodeSize::Wide16>(value, func);
        else
            setFirstFree<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setFirstVarArg<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setFirstVarArg<OpcodeSize::Wide16>(value, func);
        else
            setFirstVarArg<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (!Fits<int, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<int, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpTailCallVarargs&) { }

        ArrayProfile m_arrayProfile;
        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    VirtualRegister m_thisValue;
    VirtualRegister m_arguments;
    VirtualRegister m_firstFree;
    int m_firstVarArg;
    unsigned m_metadataID;
};

struct OpCallVarargs : public Instruction {
    static constexpr OpcodeID opcodeID = op_call_varargs;
    enum Tmps : uint8_t {
        argCountIncludingThis,
    };
    enum Checkpoints : uint8_t {
        determiningArgCount,
        makeCall,
        numberOfCheckpoints,
    };

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, VirtualRegister& thisValue, VirtualRegister& arguments, VirtualRegister& firstFree, int& firstVarArg, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<VirtualRegister, __size>::check(arguments)
            && Fits<VirtualRegister, __size>::check(firstFree)
            && Fits<int, __size>::check(firstVarArg)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, VirtualRegister thisValue, VirtualRegister arguments, VirtualRegister firstFree, int firstVarArg, unsigned __metadataID)
    {
        gen->setUsesCheckpoints();
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, thisValue, arguments, firstFree, firstVarArg, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<VirtualRegister, __size>::convert(arguments));
            gen->write(Fits<VirtualRegister, __size>::convert(firstFree));
            gen->write(Fits<int, __size>::convert(firstVarArg));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**call_varargs"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_callee, false);
        dumper->dumpOperand(m_thisValue, false);
        dumper->dumpOperand(m_arguments, false);
        dumper->dumpOperand(m_firstFree, false);
        dumper->dumpOperand(m_firstVarArg, false);
    }

    OpCallVarargs(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Narrow>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpCallVarargs(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide16>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpCallVarargs(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_arguments(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_firstFree(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_firstVarArg(Fits<int, OpcodeSize::Wide32>::convert(stream[5]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[6]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpCallVarargs decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setArguments<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setArguments<OpcodeSize::Wide16>(value, func);
        else
            setArguments<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArguments(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setFirstFree<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setFirstFree<OpcodeSize::Wide16>(value, func);
        else
            setFirstFree<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstFree(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setFirstVarArg<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setFirstVarArg<OpcodeSize::Wide16>(value, func);
        else
            setFirstVarArg<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFirstVarArg(int value, Functor func)
    {
        if (!Fits<int, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 5 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<int, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpCallVarargs&) { }

        ArrayProfile m_arrayProfile;
        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    VirtualRegister m_thisValue;
    VirtualRegister m_arguments;
    VirtualRegister m_firstFree;
    int m_firstVarArg;
    unsigned m_metadataID;
};

struct OpCallEval : public Instruction {
    static constexpr OpcodeID opcodeID = op_call_eval;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, argc, argv);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, argc, argv, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, argc, argv, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, argc, argv, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, argc, argv, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, unsigned& argc, unsigned& argv, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<unsigned, __size>::check(argc)
            && Fits<unsigned, __size>::check(argv)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, argc, argv, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<unsigned, __size>::convert(argc));
            gen->write(Fits<unsigned, __size>::convert(argv));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**call_eval"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_callee, false);
        dumper->dumpOperand(m_argc, false);
        dumper->dumpOperand(m_argv, false);
    }

    OpCallEval(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpCallEval(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpCallEval(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpCallEval decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setArgc<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setArgc<OpcodeSize::Wide16>(value, func);
        else
            setArgc<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setArgv<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setArgv<OpcodeSize::Wide16>(value, func);
        else
            setArgv<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpCallEval&) { }

        LLIntCallLinkInfo m_callLinkInfo;
        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    unsigned m_argc;
    unsigned m_argv;
    unsigned m_metadataID;
};

struct OpTailCall : public Instruction {
    static constexpr OpcodeID opcodeID = op_tail_call;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, argc, argv);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, argc, argv, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, argc, argv, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, argc, argv, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, argc, argv, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, unsigned& argc, unsigned& argv, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<unsigned, __size>::check(argc)
            && Fits<unsigned, __size>::check(argv)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, argc, argv, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<unsigned, __size>::convert(argc));
            gen->write(Fits<unsigned, __size>::convert(argv));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**tail_call"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_callee, false);
        dumper->dumpOperand(m_argc, false);
        dumper->dumpOperand(m_argv, false);
    }

    OpTailCall(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpTailCall(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpTailCall(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpTailCall decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setArgc<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setArgc<OpcodeSize::Wide16>(value, func);
        else
            setArgc<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setArgv<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setArgv<OpcodeSize::Wide16>(value, func);
        else
            setArgv<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpTailCall&) { }

        LLIntCallLinkInfo m_callLinkInfo;
        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    unsigned m_argc;
    unsigned m_argv;
    unsigned m_metadataID;
};

struct OpCall : public Instruction {
    static constexpr OpcodeID opcodeID = op_call;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, callee, argc, argv);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, callee, argc, argv, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, callee, argc, argv, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, callee, argc, argv, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, callee, argc, argv, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, callee, argc, argv, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& callee, unsigned& argc, unsigned& argv, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(callee)
            && Fits<unsigned, __size>::check(argc)
            && Fits<unsigned, __size>::check(argv)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister callee, unsigned argc, unsigned argv, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, callee, argc, argv, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(callee));
            gen->write(Fits<unsigned, __size>::convert(argc));
            gen->write(Fits<unsigned, __size>::convert(argv));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**call"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_callee, false);
        dumper->dumpOperand(m_argc, false);
        dumper->dumpOperand(m_argv, false);
    }

    OpCall(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpCall(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpCall(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_callee(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_argc(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_argv(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpCall decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setCallee<OpcodeSize::Wide16>(value, func);
        else
            setCallee<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCallee(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setArgc<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setArgc<OpcodeSize::Wide16>(value, func);
        else
            setArgc<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgc(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setArgv<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setArgv<OpcodeSize::Wide16>(value, func);
        else
            setArgv<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setArgv(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpCall&) { }

        LLIntCallLinkInfo m_callLinkInfo;
        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_callee;
    unsigned m_argc;
    unsigned m_argv;
    unsigned m_metadataID;
};

struct OpJneqPtr : public Instruction {
    static constexpr OpcodeID opcodeID = op_jneq_ptr;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister value, VirtualRegister specialPointer, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, value, specialPointer, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister value, VirtualRegister specialPointer, BoundLabel targetLabel)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, value, specialPointer, targetLabel, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister value, VirtualRegister specialPointer, BoundLabel targetLabel)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, value, specialPointer, targetLabel, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister value, VirtualRegister specialPointer, BoundLabel targetLabel, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, value, specialPointer, targetLabel, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister value, VirtualRegister specialPointer, BoundLabel targetLabel)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, value, specialPointer, targetLabel, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, value, specialPointer, targetLabel, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, value, specialPointer, targetLabel, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& value, VirtualRegister& specialPointer, BoundLabel& targetLabel, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<VirtualRegister, __size>::check(specialPointer)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister value, VirtualRegister specialPointer, BoundLabel targetLabel, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, value, specialPointer, targetLabel, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<VirtualRegister, __size>::convert(specialPointer));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jneq_ptr"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_value, true);
        dumper->dumpOperand(m_specialPointer, false);
        dumper->dumpOperand(m_targetLabel, false);
    }

    OpJneqPtr(const uint8_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_specialPointer(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpJneqPtr(const uint16_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_specialPointer(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpJneqPtr(const uint32_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_specialPointer(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpJneqPtr decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setSpecialPointer(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setSpecialPointer<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setSpecialPointer<OpcodeSize::Wide16>(value, func);
        else
            setSpecialPointer<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSpecialPointer(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpJneqPtr&) { }

        bool m_hasJumped;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_value;
    VirtualRegister m_specialPointer;
    BoundLabel m_targetLabel;
    unsigned m_metadataID;
};

struct OpPutByValDirect : public Instruction {
    static constexpr OpcodeID opcodeID = op_put_by_val_direct;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, value);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, base, property, value, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, base, property, value, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, value, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, value, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, value, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, value, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& property, VirtualRegister& value, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, value, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_by_val_direct"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_base, true);
        dumper->dumpOperand(m_property, false);
        dumper->dumpOperand(m_value, false);
    }

    OpPutByValDirect(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpPutByValDirect(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpPutByValDirect(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpPutByValDirect decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpPutByValDirect&) { }

        ArrayProfile m_arrayProfile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_base;
    VirtualRegister m_property;
    VirtualRegister m_value;
    unsigned m_metadataID;
};

struct OpPutByVal : public Instruction {
    static constexpr OpcodeID opcodeID = op_put_by_val;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, value);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, base, property, value, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, base, property, value, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, value, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, value, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, value, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, value, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& property, VirtualRegister& value, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, value, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_by_val"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_base, true);
        dumper->dumpOperand(m_property, false);
        dumper->dumpOperand(m_value, false);
    }

    OpPutByVal(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpPutByVal(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpPutByVal(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpPutByVal decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpPutByVal&) { }

        ArrayProfile m_arrayProfile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_base;
    VirtualRegister m_property;
    VirtualRegister m_value;
    unsigned m_metadataID;
};

struct OpGetByVal : public Instruction {
    static constexpr OpcodeID opcodeID = op_get_by_val;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& property, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_by_val"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_base, false);
        dumper->dumpOperand(m_property, false);
    }

    OpGetByVal(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpGetByVal(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpGetByVal(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpGetByVal decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpGetByVal&) { }

        ValueProfile m_profile;
        ArrayProfile m_arrayProfile;
        GetByValHistory m_seenIdentifiers;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_property;
    unsigned m_metadataID;
};

struct OpGetDirectPname : public Instruction {
    static constexpr OpcodeID opcodeID = op_get_direct_pname;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, VirtualRegister index, VirtualRegister enumerator)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property, index, enumerator);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, VirtualRegister index, VirtualRegister enumerator)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, property, index, enumerator, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, VirtualRegister index, VirtualRegister enumerator)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, property, index, enumerator, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, VirtualRegister index, VirtualRegister enumerator, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property, index, enumerator, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, VirtualRegister index, VirtualRegister enumerator)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, index, enumerator, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, index, enumerator, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property, index, enumerator, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& property, VirtualRegister& index, VirtualRegister& enumerator, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<VirtualRegister, __size>::check(index)
            && Fits<VirtualRegister, __size>::check(enumerator)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, VirtualRegister index, VirtualRegister enumerator, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property, index, enumerator, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<VirtualRegister, __size>::convert(index));
            gen->write(Fits<VirtualRegister, __size>::convert(enumerator));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_direct_pname"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_base, false);
        dumper->dumpOperand(m_property, false);
        dumper->dumpOperand(m_index, false);
        dumper->dumpOperand(m_enumerator, false);
    }

    OpGetDirectPname(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpGetDirectPname(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpGetDirectPname(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_index(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_enumerator(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[5]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpGetDirectPname decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setIndex(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setIndex<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setIndex<OpcodeSize::Wide16>(value, func);
        else
            setIndex<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setIndex(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setEnumerator(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setEnumerator<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setEnumerator<OpcodeSize::Wide16>(value, func);
        else
            setEnumerator<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setEnumerator(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpGetDirectPname&) { }

        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_property;
    VirtualRegister m_index;
    VirtualRegister m_enumerator;
    unsigned m_metadataID;
};

struct OpPutById : public Instruction {
    static constexpr OpcodeID opcodeID = op_put_by_id;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, VirtualRegister value, PutByIdFlags flags)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, value, flags);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, VirtualRegister value, PutByIdFlags flags)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, base, property, value, flags, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister base, unsigned property, VirtualRegister value, PutByIdFlags flags)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, base, property, value, flags, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, VirtualRegister value, PutByIdFlags flags, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, value, flags, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, unsigned property, VirtualRegister value, PutByIdFlags flags)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, value, flags, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, value, flags, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, value, flags, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, unsigned& property, VirtualRegister& value, PutByIdFlags& flags, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<PutByIdFlags, __size>::check(flags)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, unsigned property, VirtualRegister value, PutByIdFlags flags, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, value, flags, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<PutByIdFlags, __size>::convert(flags));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_by_id"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_base, true);
        dumper->dumpOperand(m_property, false);
        dumper->dumpOperand(m_value, false);
        dumper->dumpOperand(m_flags, false);
    }

    OpPutById(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_flags(Fits<PutByIdFlags, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpPutById(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_flags(Fits<PutByIdFlags, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpPutById(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_flags(Fits<PutByIdFlags, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpPutById decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setFlags(PutByIdFlags value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setFlags<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setFlags<OpcodeSize::Wide16>(value, func);
        else
            setFlags<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setFlags(PutByIdFlags value, Functor func)
    {
        if (!Fits<PutByIdFlags, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<PutByIdFlags, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpPutById&) { }

        StructureID m_oldStructureID;
        unsigned m_offset;
        StructureID m_newStructureID;
        WriteBarrierBase<StructureChain> m_structureChain;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_base;
    unsigned m_property;
    VirtualRegister m_value;
    PutByIdFlags m_flags;
    unsigned m_metadataID;
};

struct OpTryGetById : public Instruction {
    static constexpr OpcodeID opcodeID = op_try_get_by_id;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, unsigned& property, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**try_get_by_id"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_base, false);
        dumper->dumpOperand(m_property, false);
    }

    OpTryGetById(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpTryGetById(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpTryGetById(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpTryGetById decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpTryGetById&) { }

        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    unsigned m_property;
    unsigned m_metadataID;
};

struct OpGetByIdDirect : public Instruction {
    static constexpr OpcodeID opcodeID = op_get_by_id_direct;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, unsigned& property, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_by_id_direct"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_base, false);
        dumper->dumpOperand(m_property, false);
    }

    OpGetByIdDirect(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpGetByIdDirect(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpGetByIdDirect(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpGetByIdDirect decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpGetByIdDirect&) { }

        ValueProfile m_profile;
        StructureID m_structureID;
        unsigned m_offset;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    unsigned m_property;
    unsigned m_metadataID;
};

struct OpGetByValWithThis : public Instruction {
    static constexpr OpcodeID opcodeID = op_get_by_val_with_this;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, thisValue, property);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, thisValue, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, thisValue, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, thisValue, property, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, thisValue, property, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, thisValue, property, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, thisValue, property, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& thisValue, VirtualRegister& property, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, thisValue, property, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_by_val_with_this"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_base, false);
        dumper->dumpOperand(m_thisValue, false);
        dumper->dumpOperand(m_property, false);
    }

    OpGetByValWithThis(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpGetByValWithThis(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpGetByValWithThis(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpGetByValWithThis decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpGetByValWithThis&) { }

        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_thisValue;
    VirtualRegister m_property;
    unsigned m_metadataID;
};

struct OpGetByIdWithThis : public Instruction {
    static constexpr OpcodeID opcodeID = op_get_by_id_with_this;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, unsigned property)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, thisValue, property);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, unsigned property)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, thisValue, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, unsigned property)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, thisValue, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, unsigned property, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, thisValue, property, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, unsigned property)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, thisValue, property, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, thisValue, property, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, thisValue, property, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& thisValue, unsigned& property, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<unsigned, __size>::check(property)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister thisValue, unsigned property, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, thisValue, property, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_by_id_with_this"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_base, false);
        dumper->dumpOperand(m_thisValue, false);
        dumper->dumpOperand(m_property, false);
    }

    OpGetByIdWithThis(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpGetByIdWithThis(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpGetByIdWithThis(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpGetByIdWithThis decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpGetByIdWithThis&) { }

        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_thisValue;
    unsigned m_property;
    unsigned m_metadataID;
};

struct OpGetById : public Instruction {
    static constexpr OpcodeID opcodeID = op_get_by_id;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, unsigned& property, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**get_by_id"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_base, false);
        dumper->dumpOperand(m_property, false);
    }

    OpGetById(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpGetById(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpGetById(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpGetById decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpGetById&) { }

        GetByIdModeMetadata m_modeMetadata;
        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    unsigned m_property;
    unsigned m_metadataID;
};

struct OpInByVal : public Instruction {
    static constexpr OpcodeID opcodeID = op_in_by_val;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, base, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, base, property, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& property, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**in_by_val"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_base, false);
        dumper->dumpOperand(m_property, false);
    }

    OpInByVal(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpInByVal(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpInByVal(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpInByVal decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpInByVal&) { }

        ArrayProfile m_arrayProfile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_property;
    unsigned m_metadataID;
};

struct OpAdd : public Instruction {
    static constexpr OpcodeID opcodeID = op_add;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs, operandTypes);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, lhs, rhs, operandTypes, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, lhs, rhs, operandTypes, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs, operandTypes, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, operandTypes, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, operandTypes, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs, operandTypes, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs, OperandTypes& operandTypes, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<OperandTypes, __size>::check(operandTypes)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs, operandTypes, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<OperandTypes, __size>::convert(operandTypes));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**add"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
        dumper->dumpOperand(m_operandTypes, false);
    }

    OpAdd(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_operandTypes(Fits<OperandTypes, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpAdd(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_operandTypes(Fits<OperandTypes, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpAdd(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_operandTypes(Fits<OperandTypes, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpAdd decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperandTypes(OperandTypes value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperandTypes<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperandTypes<OpcodeSize::Wide16>(value, func);
        else
            setOperandTypes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperandTypes(OperandTypes value, Functor func)
    {
        if (!Fits<OperandTypes, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<OperandTypes, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpAdd&) { }

        BinaryArithProfile m_arithProfile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    OperandTypes m_operandTypes;
    unsigned m_metadataID;
};

struct OpMul : public Instruction {
    static constexpr OpcodeID opcodeID = op_mul;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs, operandTypes);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, lhs, rhs, operandTypes, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, lhs, rhs, operandTypes, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs, operandTypes, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, operandTypes, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, operandTypes, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs, operandTypes, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs, OperandTypes& operandTypes, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<OperandTypes, __size>::check(operandTypes)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs, operandTypes, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<OperandTypes, __size>::convert(operandTypes));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**mul"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
        dumper->dumpOperand(m_operandTypes, false);
    }

    OpMul(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_operandTypes(Fits<OperandTypes, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpMul(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_operandTypes(Fits<OperandTypes, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpMul(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_operandTypes(Fits<OperandTypes, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpMul decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperandTypes(OperandTypes value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperandTypes<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperandTypes<OpcodeSize::Wide16>(value, func);
        else
            setOperandTypes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperandTypes(OperandTypes value, Functor func)
    {
        if (!Fits<OperandTypes, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<OperandTypes, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpMul&) { }

        BinaryArithProfile m_arithProfile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    OperandTypes m_operandTypes;
    unsigned m_metadataID;
};

struct OpDiv : public Instruction {
    static constexpr OpcodeID opcodeID = op_div;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs, operandTypes);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, lhs, rhs, operandTypes, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, lhs, rhs, operandTypes, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs, operandTypes, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, operandTypes, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, operandTypes, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs, operandTypes, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs, OperandTypes& operandTypes, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<OperandTypes, __size>::check(operandTypes)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs, operandTypes, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<OperandTypes, __size>::convert(operandTypes));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**div"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
        dumper->dumpOperand(m_operandTypes, false);
    }

    OpDiv(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_operandTypes(Fits<OperandTypes, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpDiv(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_operandTypes(Fits<OperandTypes, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpDiv(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_operandTypes(Fits<OperandTypes, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpDiv decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperandTypes(OperandTypes value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperandTypes<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperandTypes<OpcodeSize::Wide16>(value, func);
        else
            setOperandTypes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperandTypes(OperandTypes value, Functor func)
    {
        if (!Fits<OperandTypes, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<OperandTypes, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpDiv&) { }

        BinaryArithProfile m_arithProfile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    OperandTypes m_operandTypes;
    unsigned m_metadataID;
};

struct OpSub : public Instruction {
    static constexpr OpcodeID opcodeID = op_sub;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs, operandTypes);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, lhs, rhs, operandTypes, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, lhs, rhs, operandTypes, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs, operandTypes, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, operandTypes, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, operandTypes, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs, operandTypes, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs, OperandTypes& operandTypes, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<OperandTypes, __size>::check(operandTypes)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, OperandTypes operandTypes, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs, operandTypes, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<OperandTypes, __size>::convert(operandTypes));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**sub"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
        dumper->dumpOperand(m_operandTypes, false);
    }

    OpSub(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_operandTypes(Fits<OperandTypes, OpcodeSize::Narrow>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpSub(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_operandTypes(Fits<OperandTypes, OpcodeSize::Wide16>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpSub(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_operandTypes(Fits<OperandTypes, OpcodeSize::Wide32>::convert(stream[3]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpSub decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperandTypes(OperandTypes value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperandTypes<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperandTypes<OpcodeSize::Wide16>(value, func);
        else
            setOperandTypes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperandTypes(OperandTypes value, Functor func)
    {
        if (!Fits<OperandTypes, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<OperandTypes, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpSub&) { }

        BinaryArithProfile m_arithProfile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    OperandTypes m_operandTypes;
    unsigned m_metadataID;
};

struct OpBitand : public Instruction {
    static constexpr OpcodeID opcodeID = op_bitand;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, lhs, rhs, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, lhs, rhs, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**bitand"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpBitand(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpBitand(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpBitand(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpBitand decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpBitand&) { }

        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    unsigned m_metadataID;
};

struct OpBitor : public Instruction {
    static constexpr OpcodeID opcodeID = op_bitor;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, lhs, rhs, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, lhs, rhs, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**bitor"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpBitor(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpBitor(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpBitor(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpBitor decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpBitor&) { }

        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    unsigned m_metadataID;
};

struct OpBitxor : public Instruction {
    static constexpr OpcodeID opcodeID = op_bitxor;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, lhs, rhs, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, lhs, rhs, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**bitxor"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpBitxor(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpBitxor(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpBitxor(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpBitxor decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpBitxor&) { }

        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    unsigned m_metadataID;
};

struct OpLshift : public Instruction {
    static constexpr OpcodeID opcodeID = op_lshift;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, lhs, rhs, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, lhs, rhs, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**lshift"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpLshift(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpLshift(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpLshift(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpLshift decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpLshift&) { }

        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    unsigned m_metadataID;
};

struct OpRshift : public Instruction {
    static constexpr OpcodeID opcodeID = op_rshift;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, lhs, rhs, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, lhs, rhs, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**rshift"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpRshift(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpRshift(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpRshift(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpRshift decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpRshift&) { }

        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    unsigned m_metadataID;
};

struct OpBitnot : public Instruction {
    static constexpr OpcodeID opcodeID = op_bitnot;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, operand, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, operand, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**bitnot"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
    }

    OpBitnot(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpBitnot(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpBitnot(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpBitnot decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpBitnot&) { }

        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
    unsigned m_metadataID;
};

struct OpNegate : public Instruction {
    static constexpr OpcodeID opcodeID = op_negate;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, ResultType resultType)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand, resultType);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, ResultType resultType)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, operand, resultType, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, ResultType resultType)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, operand, resultType, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, ResultType resultType, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand, resultType, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, ResultType resultType)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand, resultType, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand, resultType, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand, resultType, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand, ResultType& resultType, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && Fits<ResultType, __size>::check(resultType)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, ResultType resultType, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand, resultType, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            gen->write(Fits<ResultType, __size>::convert(resultType));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**negate"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
        dumper->dumpOperand(m_resultType, false);
    }

    OpNegate(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_resultType(Fits<ResultType, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpNegate(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_resultType(Fits<ResultType, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpNegate(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_resultType(Fits<ResultType, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpNegate decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setResultType(ResultType value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setResultType<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setResultType<OpcodeSize::Wide16>(value, func);
        else
            setResultType<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setResultType(ResultType value, Functor func)
    {
        if (!Fits<ResultType, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<ResultType, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpNegate&) { }

        UnaryArithProfile m_arithProfile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
    ResultType m_resultType;
    unsigned m_metadataID;
};

struct OpToNumeric : public Instruction {
    static constexpr OpcodeID opcodeID = op_to_numeric;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, operand, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, operand, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**to_numeric"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
    }

    OpToNumeric(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpToNumeric(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpToNumeric(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpToNumeric decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpToNumeric&) { }

        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
    unsigned m_metadataID;
};

struct OpToNumber : public Instruction {
    static constexpr OpcodeID opcodeID = op_to_number;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, operand, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, operand, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**to_number"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
    }

    OpToNumber(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpToNumber(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpToNumber(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpToNumber decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpToNumber&) { }

        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
    unsigned m_metadataID;
};

struct OpToObject : public Instruction {
    static constexpr OpcodeID opcodeID = op_to_object;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, unsigned message)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand, message);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, unsigned message)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, dst, operand, message, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, unsigned message)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, dst, operand, message, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, unsigned message, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand, message, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, unsigned message)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand, message, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand, message, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand, message, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand, unsigned& message, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && Fits<unsigned, __size>::check(message)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, unsigned message, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand, message, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            gen->write(Fits<unsigned, __size>::convert(message));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**to_object"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
        dumper->dumpOperand(m_message, false);
    }

    OpToObject(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_message(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpToObject(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_message(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpToObject(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_message(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpToObject decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setMessage(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setMessage<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setMessage<OpcodeSize::Wide16>(value, func);
        else
            setMessage<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setMessage(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpToObject&) { }

        ValueProfile m_profile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
    unsigned m_message;
    unsigned m_metadataID;
};

struct OpDec : public Instruction {
    static constexpr OpcodeID opcodeID = op_dec;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister srcDst)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, srcDst);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister srcDst)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, srcDst, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister srcDst)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, srcDst, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister srcDst, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, srcDst, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister srcDst)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, srcDst, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, srcDst, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, srcDst, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& srcDst, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(srcDst)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister srcDst, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, srcDst, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(srcDst));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**dec"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_srcDst, true);
    }

    OpDec(const uint8_t* stream)
        : m_srcDst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpDec(const uint16_t* stream)
        : m_srcDst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpDec(const uint32_t* stream)
        : m_srcDst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpDec decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setSrcDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setSrcDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setSrcDst<OpcodeSize::Wide16>(value, func);
        else
            setSrcDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSrcDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpDec&) { }

        UnaryArithProfile m_arithProfile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_srcDst;
    unsigned m_metadataID;
};

struct OpInc : public Instruction {
    static constexpr OpcodeID opcodeID = op_inc;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister srcDst)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, srcDst);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert>
    static bool emit(BytecodeGenerator* gen, VirtualRegister srcDst)
    {
        auto __metadataID = gen->addMetadataFor(opcodeID);
        return emit<__size, BytecodeGenerator, shouldAssert>(gen, srcDst, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkWithoutMetadataID(BytecodeGenerator* gen, VirtualRegister srcDst)
    {
        decltype(gen->addMetadataFor(opcodeID)) __metadataID { };
        return checkImpl<__size, BytecodeGenerator>(gen, srcDst, __metadataID);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister srcDst, unsigned __metadataID)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, srcDst, __metadataID);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister srcDst)
    {
        
        auto __metadataID = gen->addMetadataFor(opcodeID);
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, srcDst, __metadataID))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, srcDst, __metadataID))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, srcDst, __metadataID);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& srcDst, unsigned __metadataID)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(srcDst)
            && Fits<unsigned, __size>::check(__metadataID)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister srcDst, unsigned __metadataID)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, srcDst, __metadataID)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(srcDst));
            gen->write(Fits<unsigned, __size>::convert(__metadataID));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**inc"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_srcDst, true);
    }

    OpInc(const uint8_t* stream)
        : m_srcDst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpInc(const uint16_t* stream)
        : m_srcDst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpInc(const uint32_t* stream)
        : m_srcDst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_metadataID(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpInc decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setSrcDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setSrcDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setSrcDst<OpcodeSize::Wide16>(value, func);
        else
            setSrcDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSrcDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    struct Metadata {
        WTF_MAKE_NONCOPYABLE(Metadata);

    public:
        Metadata(const OpInc&) { }

        UnaryArithProfile m_arithProfile;
    };

    Metadata& metadata(CodeBlock* codeBlock) const
    {
        return codeBlock->metadata<Metadata>(opcodeID, m_metadataID);
    }

    VirtualRegister m_srcDst;
    unsigned m_metadataID;
};

struct OpIsUndefinedOrNull : public Instruction {
    static constexpr OpcodeID opcodeID = op_is_undefined_or_null;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**is_undefined_or_null"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
    }

    OpIsUndefinedOrNull(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpIsUndefinedOrNull(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpIsUndefinedOrNull(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpIsUndefinedOrNull decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
};

struct OpIsBoolean : public Instruction {
    static constexpr OpcodeID opcodeID = op_is_boolean;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**is_boolean"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
    }

    OpIsBoolean(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpIsBoolean(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpIsBoolean(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpIsBoolean decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
};

struct OpIsNumber : public Instruction {
    static constexpr OpcodeID opcodeID = op_is_number;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**is_number"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
    }

    OpIsNumber(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpIsNumber(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpIsNumber(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpIsNumber decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
};

struct OpIsObject : public Instruction {
    static constexpr OpcodeID opcodeID = op_is_object;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**is_object"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
    }

    OpIsObject(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpIsObject(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpIsObject(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpIsObject decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
};

struct OpIsObjectOrNull : public Instruction {
    static constexpr OpcodeID opcodeID = op_is_object_or_null;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**is_object_or_null"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
    }

    OpIsObjectOrNull(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpIsObjectOrNull(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpIsObjectOrNull(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpIsObjectOrNull decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
};

struct OpIsFunction : public Instruction {
    static constexpr OpcodeID opcodeID = op_is_function;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**is_function"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
    }

    OpIsFunction(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpIsFunction(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpIsFunction(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpIsFunction decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
};

struct OpIsUndefined : public Instruction {
    static constexpr OpcodeID opcodeID = op_is_undefined;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**is_undefined"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
    }

    OpIsUndefined(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpIsUndefined(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpIsUndefined(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpIsUndefined decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
};

struct OpIsEmpty : public Instruction {
    static constexpr OpcodeID opcodeID = op_is_empty;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**is_empty"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
    }

    OpIsEmpty(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpIsEmpty(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpIsEmpty(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpIsEmpty decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
};

struct OpUnsigned : public Instruction {
    static constexpr OpcodeID opcodeID = op_unsigned;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**unsigned"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
    }

    OpUnsigned(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpUnsigned(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpUnsigned(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpUnsigned decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
};

struct OpToString : public Instruction {
    static constexpr OpcodeID opcodeID = op_to_string;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**to_string"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
    }

    OpToString(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpToString(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpToString(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpToString decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
};

struct OpNeqNull : public Instruction {
    static constexpr OpcodeID opcodeID = op_neq_null;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**neq_null"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
    }

    OpNeqNull(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpNeqNull(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpNeqNull(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpNeqNull decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
};

struct OpEqNull : public Instruction {
    static constexpr OpcodeID opcodeID = op_eq_null;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**eq_null"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
    }

    OpEqNull(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpEqNull(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpEqNull(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpEqNull decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
};

struct OpNot : public Instruction {
    static constexpr OpcodeID opcodeID = op_not;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**not"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
    }

    OpNot(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpNot(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpNot(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpNot decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
};

struct OpIdentityWithProfile : public Instruction {
    static constexpr OpcodeID opcodeID = op_identity_with_profile;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister srcDst, unsigned topProfile, unsigned bottomProfile)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, srcDst, topProfile, bottomProfile);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister srcDst, unsigned topProfile, unsigned bottomProfile)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, srcDst, topProfile, bottomProfile);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister srcDst, unsigned topProfile, unsigned bottomProfile)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, srcDst, topProfile, bottomProfile))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, srcDst, topProfile, bottomProfile))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, srcDst, topProfile, bottomProfile);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& srcDst, unsigned& topProfile, unsigned& bottomProfile)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(srcDst)
            && Fits<unsigned, __size>::check(topProfile)
            && Fits<unsigned, __size>::check(bottomProfile)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister srcDst, unsigned topProfile, unsigned bottomProfile)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, srcDst, topProfile, bottomProfile)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(srcDst));
            gen->write(Fits<unsigned, __size>::convert(topProfile));
            gen->write(Fits<unsigned, __size>::convert(bottomProfile));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**identity_with_profile"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_srcDst, true);
        dumper->dumpOperand(m_topProfile, false);
        dumper->dumpOperand(m_bottomProfile, false);
    }

    OpIdentityWithProfile(const uint8_t* stream)
        : m_srcDst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_topProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
        , m_bottomProfile(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpIdentityWithProfile(const uint16_t* stream)
        : m_srcDst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_topProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
        , m_bottomProfile(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpIdentityWithProfile(const uint32_t* stream)
        : m_srcDst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_topProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
        , m_bottomProfile(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpIdentityWithProfile decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setSrcDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setSrcDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setSrcDst<OpcodeSize::Wide16>(value, func);
        else
            setSrcDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSrcDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTopProfile(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTopProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTopProfile<OpcodeSize::Wide16>(value, func);
        else
            setTopProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTopProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setBottomProfile(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBottomProfile<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBottomProfile<OpcodeSize::Wide16>(value, func);
        else
            setBottomProfile<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBottomProfile(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    VirtualRegister m_srcDst;
    unsigned m_topProfile;
    unsigned m_bottomProfile;
};

struct OpOverridesHasInstance : public Instruction {
    static constexpr OpcodeID opcodeID = op_overrides_has_instance;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister constructor, VirtualRegister hasInstanceValue)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, constructor, hasInstanceValue);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister constructor, VirtualRegister hasInstanceValue)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, constructor, hasInstanceValue);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister constructor, VirtualRegister hasInstanceValue)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, constructor, hasInstanceValue))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, constructor, hasInstanceValue))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, constructor, hasInstanceValue);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& constructor, VirtualRegister& hasInstanceValue)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(constructor)
            && Fits<VirtualRegister, __size>::check(hasInstanceValue)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister constructor, VirtualRegister hasInstanceValue)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, constructor, hasInstanceValue)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(constructor));
            gen->write(Fits<VirtualRegister, __size>::convert(hasInstanceValue));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**overrides_has_instance"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_constructor, false);
        dumper->dumpOperand(m_hasInstanceValue, false);
    }

    OpOverridesHasInstance(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_constructor(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_hasInstanceValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpOverridesHasInstance(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_constructor(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_hasInstanceValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpOverridesHasInstance(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_constructor(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_hasInstanceValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpOverridesHasInstance decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setConstructor(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setConstructor<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setConstructor<OpcodeSize::Wide16>(value, func);
        else
            setConstructor<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setConstructor(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setHasInstanceValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setHasInstanceValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setHasInstanceValue<OpcodeSize::Wide16>(value, func);
        else
            setHasInstanceValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setHasInstanceValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_constructor;
    VirtualRegister m_hasInstanceValue;
};

struct OpInstanceof : public Instruction {
    static constexpr OpcodeID opcodeID = op_instanceof;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, VirtualRegister prototype)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, value, prototype);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, VirtualRegister prototype)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, value, prototype);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, VirtualRegister prototype)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, value, prototype))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, value, prototype))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, value, prototype);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& value, VirtualRegister& prototype)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<VirtualRegister, __size>::check(prototype)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, VirtualRegister prototype)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, value, prototype)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<VirtualRegister, __size>::convert(prototype));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**instanceof"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_value, false);
        dumper->dumpOperand(m_prototype, false);
    }

    OpInstanceof(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_prototype(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpInstanceof(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_prototype(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpInstanceof(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_prototype(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpInstanceof decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setPrototype(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setPrototype<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setPrototype<OpcodeSize::Wide16>(value, func);
        else
            setPrototype<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setPrototype(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_value;
    VirtualRegister m_prototype;
};

struct OpInstanceofCustom : public Instruction {
    static constexpr OpcodeID opcodeID = op_instanceof_custom;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, VirtualRegister constructor, VirtualRegister hasInstanceValue)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, value, constructor, hasInstanceValue);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, VirtualRegister constructor, VirtualRegister hasInstanceValue)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, value, constructor, hasInstanceValue);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, VirtualRegister constructor, VirtualRegister hasInstanceValue)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, value, constructor, hasInstanceValue))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, value, constructor, hasInstanceValue))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, value, constructor, hasInstanceValue);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& value, VirtualRegister& constructor, VirtualRegister& hasInstanceValue)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<VirtualRegister, __size>::check(constructor)
            && Fits<VirtualRegister, __size>::check(hasInstanceValue)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value, VirtualRegister constructor, VirtualRegister hasInstanceValue)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, value, constructor, hasInstanceValue)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<VirtualRegister, __size>::convert(constructor));
            gen->write(Fits<VirtualRegister, __size>::convert(hasInstanceValue));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**instanceof_custom"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_value, false);
        dumper->dumpOperand(m_constructor, false);
        dumper->dumpOperand(m_hasInstanceValue, false);
    }

    OpInstanceofCustom(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_constructor(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_hasInstanceValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpInstanceofCustom(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_constructor(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_hasInstanceValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpInstanceofCustom(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_constructor(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_hasInstanceValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpInstanceofCustom decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setConstructor(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setConstructor<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setConstructor<OpcodeSize::Wide16>(value, func);
        else
            setConstructor<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setConstructor(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setHasInstanceValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setHasInstanceValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setHasInstanceValue<OpcodeSize::Wide16>(value, func);
        else
            setHasInstanceValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setHasInstanceValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_value;
    VirtualRegister m_constructor;
    VirtualRegister m_hasInstanceValue;
};

struct OpTypeof : public Instruction {
    static constexpr OpcodeID opcodeID = op_typeof;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, value);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, value);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, value))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, value))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, value);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& value)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(value)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister value)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, value)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**typeof"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_value, false);
    }

    OpTypeof(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpTypeof(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpTypeof(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpTypeof decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_value;
};

struct OpIsCellWithType : public Instruction {
    static constexpr OpcodeID opcodeID = op_is_cell_with_type;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, JSType type)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, operand, type);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, JSType type)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, operand, type);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, JSType type)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, operand, type))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, operand, type))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, operand, type);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& operand, JSType& type)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(operand)
            && Fits<JSType, __size>::check(type)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister operand, JSType type)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, operand, type)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(operand));
            gen->write(Fits<JSType, __size>::convert(type));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**is_cell_with_type"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_operand, false);
        dumper->dumpOperand(m_type, false);
    }

    OpIsCellWithType(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_type(Fits<JSType, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpIsCellWithType(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_type(Fits<JSType, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpIsCellWithType(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_operand(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_type(Fits<JSType, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpIsCellWithType decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setOperand<OpcodeSize::Wide16>(value, func);
        else
            setOperand<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setOperand(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setType(JSType value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setType<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setType<OpcodeSize::Wide16>(value, func);
        else
            setType<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setType(JSType value, Functor func)
    {
        if (!Fits<JSType, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<JSType, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_operand;
    JSType m_type;
};

struct OpUrshift : public Instruction {
    static constexpr OpcodeID opcodeID = op_urshift;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**urshift"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpUrshift(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpUrshift(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpUrshift(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpUrshift decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
};

struct OpInById : public Instruction {
    static constexpr OpcodeID opcodeID = op_in_by_id;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, unsigned& property)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**in_by_id"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_base, false);
        dumper->dumpOperand(m_property, false);
    }

    OpInById(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpInById(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpInById(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpInById decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    unsigned m_property;
};

struct OpPow : public Instruction {
    static constexpr OpcodeID opcodeID = op_pow;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**pow"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpPow(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpPow(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpPow(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpPow decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
};

struct OpMod : public Instruction {
    static constexpr OpcodeID opcodeID = op_mod;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**mod"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpMod(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpMod(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpMod(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpMod decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
};

struct OpBeloweq : public Instruction {
    static constexpr OpcodeID opcodeID = op_beloweq;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**beloweq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpBeloweq(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpBeloweq(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpBeloweq(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpBeloweq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
};

struct OpBelow : public Instruction {
    static constexpr OpcodeID opcodeID = op_below;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**below"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpBelow(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpBelow(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpBelow(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpBelow decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
};

struct OpGreatereq : public Instruction {
    static constexpr OpcodeID opcodeID = op_greatereq;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**greatereq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpGreatereq(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpGreatereq(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpGreatereq(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpGreatereq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
};

struct OpGreater : public Instruction {
    static constexpr OpcodeID opcodeID = op_greater;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**greater"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpGreater(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpGreater(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpGreater(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpGreater decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
};

struct OpLesseq : public Instruction {
    static constexpr OpcodeID opcodeID = op_lesseq;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**lesseq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpLesseq(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpLesseq(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpLesseq(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpLesseq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
};

struct OpDelById : public Instruction {
    static constexpr OpcodeID opcodeID = op_del_by_id;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, unsigned& property)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, unsigned property)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**del_by_id"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_base, false);
        dumper->dumpOperand(m_property, false);
    }

    OpDelById(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpDelById(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpDelById(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpDelById decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    unsigned m_property;
};

struct OpLess : public Instruction {
    static constexpr OpcodeID opcodeID = op_less;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**less"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpLess(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpLess(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpLess(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpLess decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
};

struct OpNstricteq : public Instruction {
    static constexpr OpcodeID opcodeID = op_nstricteq;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**nstricteq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpNstricteq(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpNstricteq(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpNstricteq(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpNstricteq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
};

struct OpPutByValWithThis : public Instruction {
    static constexpr OpcodeID opcodeID = op_put_by_val_with_this;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property, VirtualRegister value)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, thisValue, property, value);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property, VirtualRegister value)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, thisValue, property, value);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property, VirtualRegister value)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, thisValue, property, value))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, thisValue, property, value))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, thisValue, property, value);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& thisValue, VirtualRegister& property, VirtualRegister& value)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(thisValue)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<VirtualRegister, __size>::check(value)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister thisValue, VirtualRegister property, VirtualRegister value)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, thisValue, property, value)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(thisValue));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_by_val_with_this"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_base, true);
        dumper->dumpOperand(m_thisValue, false);
        dumper->dumpOperand(m_property, false);
        dumper->dumpOperand(m_value, false);
    }

    OpPutByValWithThis(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpPutByValWithThis(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpPutByValWithThis(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_thisValue(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpPutByValWithThis decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setThisValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setThisValue<OpcodeSize::Wide16>(value, func);
        else
            setThisValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setThisValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_base;
    VirtualRegister m_thisValue;
    VirtualRegister m_property;
    VirtualRegister m_value;
};

struct OpStricteq : public Instruction {
    static constexpr OpcodeID opcodeID = op_stricteq;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**stricteq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpStricteq(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpStricteq(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpStricteq(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpStricteq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
};

struct OpDelByVal : public Instruction {
    static constexpr OpcodeID opcodeID = op_del_by_val;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, base, property);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, base, property);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, base, property))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, base, property))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, base, property);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& base, VirtualRegister& property)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister base, VirtualRegister property)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, base, property)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**del_by_val"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_base, false);
        dumper->dumpOperand(m_property, false);
    }

    OpDelByVal(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpDelByVal(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpDelByVal(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpDelByVal decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_base;
    VirtualRegister m_property;
};

struct OpPutGetterById : public Instruction {
    static constexpr OpcodeID opcodeID = op_put_getter_by_id;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister accessor)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, attributes, accessor);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister accessor)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, attributes, accessor);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister accessor)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, accessor))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, accessor))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, attributes, accessor);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, unsigned& property, unsigned& attributes, VirtualRegister& accessor)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && Fits<unsigned, __size>::check(attributes)
            && Fits<VirtualRegister, __size>::check(accessor)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister accessor)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, attributes, accessor)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(attributes));
            gen->write(Fits<VirtualRegister, __size>::convert(accessor));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_getter_by_id"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_base, true);
        dumper->dumpOperand(m_property, false);
        dumper->dumpOperand(m_attributes, false);
        dumper->dumpOperand(m_accessor, false);
    }

    OpPutGetterById(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpPutGetterById(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpPutGetterById(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpPutGetterById decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setAttributes<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setAttributes<OpcodeSize::Wide16>(value, func);
        else
            setAttributes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setAccessor(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setAccessor<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setAccessor<OpcodeSize::Wide16>(value, func);
        else
            setAccessor<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAccessor(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_base;
    unsigned m_property;
    unsigned m_attributes;
    VirtualRegister m_accessor;
};

struct OpPutSetterById : public Instruction {
    static constexpr OpcodeID opcodeID = op_put_setter_by_id;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister accessor)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, attributes, accessor);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister accessor)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, attributes, accessor);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister accessor)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, accessor))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, accessor))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, attributes, accessor);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, unsigned& property, unsigned& attributes, VirtualRegister& accessor)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && Fits<unsigned, __size>::check(attributes)
            && Fits<VirtualRegister, __size>::check(accessor)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister accessor)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, attributes, accessor)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(attributes));
            gen->write(Fits<VirtualRegister, __size>::convert(accessor));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_setter_by_id"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_base, true);
        dumper->dumpOperand(m_property, false);
        dumper->dumpOperand(m_attributes, false);
        dumper->dumpOperand(m_accessor, false);
    }

    OpPutSetterById(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpPutSetterById(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpPutSetterById(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpPutSetterById decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setAttributes<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setAttributes<OpcodeSize::Wide16>(value, func);
        else
            setAttributes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setAccessor(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setAccessor<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setAccessor<OpcodeSize::Wide16>(value, func);
        else
            setAccessor<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAccessor(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_base;
    unsigned m_property;
    unsigned m_attributes;
    VirtualRegister m_accessor;
};

struct OpPutGetterSetterById : public Instruction {
    static constexpr OpcodeID opcodeID = op_put_getter_setter_by_id;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister getter, VirtualRegister setter)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, attributes, getter, setter);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister getter, VirtualRegister setter)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, attributes, getter, setter);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister getter, VirtualRegister setter)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, getter, setter))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, getter, setter))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, attributes, getter, setter);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, unsigned& property, unsigned& attributes, VirtualRegister& getter, VirtualRegister& setter)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<unsigned, __size>::check(property)
            && Fits<unsigned, __size>::check(attributes)
            && Fits<VirtualRegister, __size>::check(getter)
            && Fits<VirtualRegister, __size>::check(setter)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, unsigned property, unsigned attributes, VirtualRegister getter, VirtualRegister setter)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, attributes, getter, setter)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<unsigned, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(attributes));
            gen->write(Fits<VirtualRegister, __size>::convert(getter));
            gen->write(Fits<VirtualRegister, __size>::convert(setter));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_getter_setter_by_id"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_base, true);
        dumper->dumpOperand(m_property, false);
        dumper->dumpOperand(m_attributes, false);
        dumper->dumpOperand(m_getter, false);
        dumper->dumpOperand(m_setter, false);
    }

    OpPutGetterSetterById(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_getter(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_setter(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpPutGetterSetterById(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_getter(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_setter(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpPutGetterSetterById(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_getter(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_setter(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpPutGetterSetterById decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setAttributes<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setAttributes<OpcodeSize::Wide16>(value, func);
        else
            setAttributes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setGetter(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setGetter<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setGetter<OpcodeSize::Wide16>(value, func);
        else
            setGetter<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setGetter(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setSetter(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setSetter<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setSetter<OpcodeSize::Wide16>(value, func);
        else
            setSetter<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSetter(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_base;
    unsigned m_property;
    unsigned m_attributes;
    VirtualRegister m_getter;
    VirtualRegister m_setter;
};

struct OpPutGetterByVal : public Instruction {
    static constexpr OpcodeID opcodeID = op_put_getter_by_val;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, unsigned attributes, VirtualRegister accessor)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, attributes, accessor);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, unsigned attributes, VirtualRegister accessor)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, attributes, accessor);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, unsigned attributes, VirtualRegister accessor)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, accessor))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, accessor))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, attributes, accessor);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& property, unsigned& attributes, VirtualRegister& accessor)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<unsigned, __size>::check(attributes)
            && Fits<VirtualRegister, __size>::check(accessor)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, unsigned attributes, VirtualRegister accessor)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, attributes, accessor)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(attributes));
            gen->write(Fits<VirtualRegister, __size>::convert(accessor));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_getter_by_val"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_base, true);
        dumper->dumpOperand(m_property, false);
        dumper->dumpOperand(m_attributes, false);
        dumper->dumpOperand(m_accessor, false);
    }

    OpPutGetterByVal(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpPutGetterByVal(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpPutGetterByVal(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpPutGetterByVal decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setAttributes<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setAttributes<OpcodeSize::Wide16>(value, func);
        else
            setAttributes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setAccessor(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setAccessor<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setAccessor<OpcodeSize::Wide16>(value, func);
        else
            setAccessor<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAccessor(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_base;
    VirtualRegister m_property;
    unsigned m_attributes;
    VirtualRegister m_accessor;
};

struct OpPutSetterByVal : public Instruction {
    static constexpr OpcodeID opcodeID = op_put_setter_by_val;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, unsigned attributes, VirtualRegister accessor)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, attributes, accessor);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, unsigned attributes, VirtualRegister accessor)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, attributes, accessor);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, unsigned attributes, VirtualRegister accessor)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, accessor))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, attributes, accessor))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, attributes, accessor);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& property, unsigned& attributes, VirtualRegister& accessor)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<unsigned, __size>::check(attributes)
            && Fits<VirtualRegister, __size>::check(accessor)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, unsigned attributes, VirtualRegister accessor)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, attributes, accessor)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<unsigned, __size>::convert(attributes));
            gen->write(Fits<VirtualRegister, __size>::convert(accessor));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**put_setter_by_val"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_base, true);
        dumper->dumpOperand(m_property, false);
        dumper->dumpOperand(m_attributes, false);
        dumper->dumpOperand(m_accessor, false);
    }

    OpPutSetterByVal(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Narrow>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpPutSetterByVal(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide16>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpPutSetterByVal(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_attributes(Fits<unsigned, OpcodeSize::Wide32>::convert(stream[2]))
        , m_accessor(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpPutSetterByVal decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setAttributes<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setAttributes<OpcodeSize::Wide16>(value, func);
        else
            setAttributes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAttributes(unsigned value, Functor func)
    {
        if (!Fits<unsigned, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<unsigned, size>::convert(value);
    }

    template<typename Functor>
    void setAccessor(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setAccessor<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setAccessor<OpcodeSize::Wide16>(value, func);
        else
            setAccessor<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAccessor(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_base;
    VirtualRegister m_property;
    unsigned m_attributes;
    VirtualRegister m_accessor;
};

struct OpDefineDataProperty : public Instruction {
    static constexpr OpcodeID opcodeID = op_define_data_property;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, VirtualRegister attributes)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, value, attributes);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, VirtualRegister attributes)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, value, attributes);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, VirtualRegister attributes)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, value, attributes))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, value, attributes))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, value, attributes);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& property, VirtualRegister& value, VirtualRegister& attributes)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<VirtualRegister, __size>::check(attributes)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister value, VirtualRegister attributes)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, value, attributes)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<VirtualRegister, __size>::convert(attributes));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**define_data_property"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_base, true);
        dumper->dumpOperand(m_property, false);
        dumper->dumpOperand(m_value, false);
        dumper->dumpOperand(m_attributes, false);
    }

    OpDefineDataProperty(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_attributes(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpDefineDataProperty(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_attributes(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpDefineDataProperty(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_attributes(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpDefineDataProperty decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setAttributes(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setAttributes<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setAttributes<OpcodeSize::Wide16>(value, func);
        else
            setAttributes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAttributes(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_base;
    VirtualRegister m_property;
    VirtualRegister m_value;
    VirtualRegister m_attributes;
};

struct OpDefineAccessorProperty : public Instruction {
    static constexpr OpcodeID opcodeID = op_define_accessor_property;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister getter, VirtualRegister setter, VirtualRegister attributes)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, base, property, getter, setter, attributes);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister getter, VirtualRegister setter, VirtualRegister attributes)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, base, property, getter, setter, attributes);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister getter, VirtualRegister setter, VirtualRegister attributes)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, base, property, getter, setter, attributes))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, base, property, getter, setter, attributes))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, base, property, getter, setter, attributes);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& base, VirtualRegister& property, VirtualRegister& getter, VirtualRegister& setter, VirtualRegister& attributes)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(base)
            && Fits<VirtualRegister, __size>::check(property)
            && Fits<VirtualRegister, __size>::check(getter)
            && Fits<VirtualRegister, __size>::check(setter)
            && Fits<VirtualRegister, __size>::check(attributes)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister base, VirtualRegister property, VirtualRegister getter, VirtualRegister setter, VirtualRegister attributes)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, base, property, getter, setter, attributes)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(base));
            gen->write(Fits<VirtualRegister, __size>::convert(property));
            gen->write(Fits<VirtualRegister, __size>::convert(getter));
            gen->write(Fits<VirtualRegister, __size>::convert(setter));
            gen->write(Fits<VirtualRegister, __size>::convert(attributes));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**define_accessor_property"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_base, true);
        dumper->dumpOperand(m_property, false);
        dumper->dumpOperand(m_getter, false);
        dumper->dumpOperand(m_setter, false);
        dumper->dumpOperand(m_attributes, false);
    }

    OpDefineAccessorProperty(const uint8_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_getter(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
        , m_setter(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[3]))
        , m_attributes(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpDefineAccessorProperty(const uint16_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_getter(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
        , m_setter(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[3]))
        , m_attributes(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpDefineAccessorProperty(const uint32_t* stream)
        : m_base(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_property(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_getter(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
        , m_setter(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[3]))
        , m_attributes(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[4]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpDefineAccessorProperty decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setBase<OpcodeSize::Wide16>(value, func);
        else
            setBase<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setBase(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setProperty<OpcodeSize::Wide16>(value, func);
        else
            setProperty<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setProperty(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setGetter(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setGetter<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setGetter<OpcodeSize::Wide16>(value, func);
        else
            setGetter<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setGetter(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setSetter(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setSetter<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setSetter<OpcodeSize::Wide16>(value, func);
        else
            setSetter<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setSetter(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 3 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setAttributes(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setAttributes<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setAttributes<OpcodeSize::Wide16>(value, func);
        else
            setAttributes<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setAttributes(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 4 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_base;
    VirtualRegister m_property;
    VirtualRegister m_getter;
    VirtualRegister m_setter;
    VirtualRegister m_attributes;
};

struct OpJmp : public Instruction {
    static constexpr OpcodeID opcodeID = op_jmp;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jmp"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_targetLabel, true);
    }

    OpJmp(const uint8_t* stream)
        : m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[0]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpJmp(const uint16_t* stream)
        : m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[0]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpJmp(const uint32_t* stream)
        : m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[0]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpJmp decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    BoundLabel m_targetLabel;
};

struct OpJtrue : public Instruction {
    static constexpr OpcodeID opcodeID = op_jtrue;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister condition, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, condition, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister condition, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, condition, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister condition, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, condition, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, condition, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, condition, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& condition, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(condition)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister condition, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, condition, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(condition));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jtrue"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_condition, true);
        dumper->dumpOperand(m_targetLabel, false);
    }

    OpJtrue(const uint8_t* stream)
        : m_condition(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpJtrue(const uint16_t* stream)
        : m_condition(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpJtrue(const uint32_t* stream)
        : m_condition(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpJtrue decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setCondition(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setCondition<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setCondition<OpcodeSize::Wide16>(value, func);
        else
            setCondition<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCondition(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_condition;
    BoundLabel m_targetLabel;
};

struct OpJfalse : public Instruction {
    static constexpr OpcodeID opcodeID = op_jfalse;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister condition, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, condition, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister condition, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, condition, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister condition, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, condition, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, condition, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, condition, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& condition, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(condition)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister condition, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, condition, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(condition));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jfalse"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_condition, true);
        dumper->dumpOperand(m_targetLabel, false);
    }

    OpJfalse(const uint8_t* stream)
        : m_condition(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpJfalse(const uint16_t* stream)
        : m_condition(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpJfalse(const uint32_t* stream)
        : m_condition(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpJfalse decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setCondition(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setCondition<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setCondition<OpcodeSize::Wide16>(value, func);
        else
            setCondition<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setCondition(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_condition;
    BoundLabel m_targetLabel;
};

struct OpJeqNull : public Instruction {
    static constexpr OpcodeID opcodeID = op_jeq_null;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, value, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, value, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, value, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, value, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, value, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& value, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, value, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jeq_null"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_value, true);
        dumper->dumpOperand(m_targetLabel, false);
    }

    OpJeqNull(const uint8_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpJeqNull(const uint16_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpJeqNull(const uint32_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpJeqNull decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_value;
    BoundLabel m_targetLabel;
};

struct OpJneqNull : public Instruction {
    static constexpr OpcodeID opcodeID = op_jneq_null;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, value, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, value, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, value, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, value, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, value, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& value, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, value, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jneq_null"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_value, true);
        dumper->dumpOperand(m_targetLabel, false);
    }

    OpJneqNull(const uint8_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpJneqNull(const uint16_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpJneqNull(const uint32_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpJneqNull decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_value;
    BoundLabel m_targetLabel;
};

struct OpJundefinedOrNull : public Instruction {
    static constexpr OpcodeID opcodeID = op_jundefined_or_null;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, value, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, value, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, value, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, value, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, value, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& value, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, value, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jundefined_or_null"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_value, true);
        dumper->dumpOperand(m_targetLabel, false);
    }

    OpJundefinedOrNull(const uint8_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpJundefinedOrNull(const uint16_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpJundefinedOrNull(const uint32_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpJundefinedOrNull decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_value;
    BoundLabel m_targetLabel;
};

struct OpJnundefinedOrNull : public Instruction {
    static constexpr OpcodeID opcodeID = op_jnundefined_or_null;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, value, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, value, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, value, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, value, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, value, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& value, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(value)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister value, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, value, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(value));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jnundefined_or_null"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_value, true);
        dumper->dumpOperand(m_targetLabel, false);
    }

    OpJnundefinedOrNull(const uint8_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpJnundefinedOrNull(const uint16_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpJnundefinedOrNull(const uint32_t* stream)
        : m_value(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[1]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpJnundefinedOrNull decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setValue<OpcodeSize::Wide16>(value, func);
        else
            setValue<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setValue(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_value;
    BoundLabel m_targetLabel;
};

struct OpNeq : public Instruction {
    static constexpr OpcodeID opcodeID = op_neq;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, dst, lhs, rhs);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, dst, lhs, rhs);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, dst, lhs, rhs))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, dst, lhs, rhs);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& dst, VirtualRegister& lhs, VirtualRegister& rhs)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(dst)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister dst, VirtualRegister lhs, VirtualRegister rhs)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, dst, lhs, rhs)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(dst));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**neq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_dst, true);
        dumper->dumpOperand(m_lhs, false);
        dumper->dumpOperand(m_rhs, false);
    }

    OpNeq(const uint8_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpNeq(const uint16_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpNeq(const uint32_t* stream)
        : m_dst(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpNeq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setDst<OpcodeSize::Wide16>(value, func);
        else
            setDst<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setDst(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    VirtualRegister m_dst;
    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
};

struct OpJeq : public Instruction {
    static constexpr OpcodeID opcodeID = op_jeq;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jeq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_lhs, true);
        dumper->dumpOperand(m_rhs, false);
        dumper->dumpOperand(m_targetLabel, false);
    }

    OpJeq(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpJeq(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpJeq(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpJeq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    BoundLabel m_targetLabel;
};

struct OpJstricteq : public Instruction {
    static constexpr OpcodeID opcodeID = op_jstricteq;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jstricteq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_lhs, true);
        dumper->dumpOperand(m_rhs, false);
        dumper->dumpOperand(m_targetLabel, false);
    }

    OpJstricteq(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpJstricteq(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpJstricteq(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpJstricteq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    BoundLabel m_targetLabel;
};

struct OpJneq : public Instruction {
    static constexpr OpcodeID opcodeID = op_jneq;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jneq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_lhs, true);
        dumper->dumpOperand(m_rhs, false);
        dumper->dumpOperand(m_targetLabel, false);
    }

    OpJneq(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpJneq(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpJneq(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpJneq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    BoundLabel m_targetLabel;
};

struct OpJnstricteq : public Instruction {
    static constexpr OpcodeID opcodeID = op_jnstricteq;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jnstricteq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_lhs, true);
        dumper->dumpOperand(m_rhs, false);
        dumper->dumpOperand(m_targetLabel, false);
    }

    OpJnstricteq(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpJnstricteq(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpJnstricteq(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpJnstricteq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    BoundLabel m_targetLabel;
};

struct OpJless : public Instruction {
    static constexpr OpcodeID opcodeID = op_jless;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jless"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_lhs, true);
        dumper->dumpOperand(m_rhs, false);
        dumper->dumpOperand(m_targetLabel, false);
    }

    OpJless(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpJless(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpJless(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpJless decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    BoundLabel m_targetLabel;
};

struct OpJlesseq : public Instruction {
    static constexpr OpcodeID opcodeID = op_jlesseq;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jlesseq"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_lhs, true);
        dumper->dumpOperand(m_rhs, false);
        dumper->dumpOperand(m_targetLabel, false);
    }

    OpJlesseq(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpJlesseq(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpJlesseq(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpJlesseq decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    BoundLabel m_targetLabel;
};

struct OpJgreater : public Instruction {
    static constexpr OpcodeID opcodeID = op_jgreater;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize::Wide16 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide16) : true)
            && (__size == OpcodeSize::Wide32 ? Fits<OpcodeID, OpcodeSize::Narrow>::check(op_wide32) : true);
    }

    template<OpcodeSize __size, bool recordOpcode, typename BytecodeGenerator>
    static bool emitImpl(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (__size == OpcodeSize::Wide16)
            gen->alignWideOpcode16();
        else if (__size == OpcodeSize::Wide32)
            gen->alignWideOpcode32();
        if (checkImpl<__size>(gen, lhs, rhs, targetLabel)) {
            if (recordOpcode)
                gen->recordOpcode(opcodeID);
            if (__size == OpcodeSize::Wide16)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide16));
            else if (__size == OpcodeSize::Wide32)
                gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(op_wide32));
            gen->write(Fits<OpcodeID, OpcodeSize::Narrow>::convert(opcodeID));
            gen->write(Fits<VirtualRegister, __size>::convert(lhs));
            gen->write(Fits<VirtualRegister, __size>::convert(rhs));
            gen->write(Fits<BoundLabel, __size>::convert(targetLabel));
            return true;
        }
        return false;
    }

public:
    void dump(BytecodeDumperBase* dumper, InstructionStream::Offset __location, int __sizeShiftAmount)
    {
        dumper->printLocationAndOp(__location, &"**jgreater"[2 - __sizeShiftAmount]);
        dumper->dumpOperand(m_lhs, true);
        dumper->dumpOperand(m_rhs, false);
        dumper->dumpOperand(m_targetLabel, false);
    }

    OpJgreater(const uint8_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Narrow>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Narrow>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    OpJgreater(const uint16_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide16>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide16>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }


    OpJgreater(const uint32_t* stream)
        : m_lhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[0]))
        , m_rhs(Fits<VirtualRegister, OpcodeSize::Wide32>::convert(stream[1]))
        , m_targetLabel(Fits<BoundLabel, OpcodeSize::Wide32>::convert(stream[2]))
    {
        ASSERT_UNUSED(stream, bitwise_cast<const uint8_t*>(stream)[-1] == opcodeID);
    }

    static OpJgreater decode(const uint8_t* stream)
    {
        // A pointer is pointing to the first operand (opcode and prefix are not included).
        if (*stream == op_wide32)
            return { bitwise_cast<const uint32_t*>(stream + 2) };
        if (*stream == op_wide16)
            return { bitwise_cast<const uint16_t*>(stream + 2) };
        return { stream + 1 };
    }

    template<typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setLhs<OpcodeSize::Wide16>(value, func);
        else
            setLhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setLhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 0 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setRhs<OpcodeSize::Wide16>(value, func);
        else
            setRhs<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setRhs(VirtualRegister value, Functor func)
    {
        if (!Fits<VirtualRegister, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 1 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<VirtualRegister, size>::convert(value);
    }

    template<typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (isWide32<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide32>(value, func);
        else if (isWide16<JSOpcodeTraits>())
            setTargetLabel<OpcodeSize::Wide16>(value, func);
        else
            setTargetLabel<OpcodeSize::Narrow>(value, func);
    }

    template <OpcodeSize size, typename Functor>
    void setTargetLabel(BoundLabel value, Functor func)
    {
        if (!Fits<BoundLabel, size>::check(value))
            value = func();
        auto* stream = bitwise_cast<typename TypeBySize<size>::unsignedType*>(reinterpret_cast<uint8_t*>(this) + 2 * size + PaddingBySize<size>::value + /* Opcode size */ 1);
        *stream = Fits<BoundLabel, size>::convert(value);
    }

    VirtualRegister m_lhs;
    VirtualRegister m_rhs;
    BoundLabel m_targetLabel;
};

struct OpJgreatereq : public Instruction {
    static constexpr OpcodeID opcodeID = op_jgreatereq;
    
    

    template<typename BytecodeGenerator>
    static void emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        emitWithSmallestSizeRequirement<OpcodeSize::Narrow, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
    }

    template<OpcodeSize __size, typename BytecodeGenerator, FitsAssertion shouldAssert = Assert, bool recordOpcode = true>
    static bool emit(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        bool didEmit = emitImpl<__size, recordOpcode, BytecodeGenerator>(gen, lhs, rhs, targetLabel);
        if (shouldAssert == Assert)
            ASSERT(didEmit);
        return didEmit;
    }

    template<OpcodeSize __size, typename BytecodeGenerator>
    static void emitWithSmallestSizeRequirement(BytecodeGenerator* gen, VirtualRegister lhs, VirtualRegister rhs, BoundLabel targetLabel)
    {
        
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Narrow)) {
            if (emit<OpcodeSize::Narrow, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        if (static_cast<unsigned>(__size) <= static_cast<unsigned>(OpcodeSize::Wide16)) {
            if (emit<OpcodeSize::Wide16, BytecodeGenerator, NoAssert, true>(gen, lhs, rhs, targetLabel))
                return;
        }
        emit<OpcodeSize::Wide32, BytecodeGenerator, Assert, true>(gen, lhs, rhs, targetLabel);
    }

private:
    template<OpcodeSize __size, typename BytecodeGenerator>
    static bool checkImpl(BytecodeGenerator* gen, VirtualRegister& lhs, VirtualRegister& rhs, BoundLabel& targetLabel)
    {
        UNUSED_PARAM(gen);
#if OS(WINBASED) && ENABLE(C_LOOP)
        // FIXME: Disable wide16 optimization for Windows CLoop
        // https://bugs.webkit.org/show_bug.cgi?id=198283
        if (__size == OpcodeSize::Wide16)
            return false;
#endif
        return Fits<OpcodeID, __size>::check(opcodeID)
            && Fits<VirtualRegister, __size>::check(lhs)
            && Fits<VirtualRegister, __size>::check(rhs)
            && Fits<BoundLabel, __size>::check(targetLabel)
            && (__size == OpcodeSize: