/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json
// by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#include "config.h"
#include "InspectorFrontendDispatchers.h"

#include "InspectorFrontendRouter.h"
#include <wtf/text/CString.h>

namespace Inspector {

void AnimationFrontendDispatcher::animationCreated(RefPtr<Inspector::Protocol::Animation::Animation> animation)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Animation.animationCreated"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("animation"_s, animation);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void AnimationFrontendDispatcher::effectChanged(const String& animationId, RefPtr<Inspector::Protocol::Animation::Effect> effect)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Animation.effectChanged"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("animationId"_s, animationId);
    if (effect)
        paramsObject->setObject("effect"_s, effect);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void AnimationFrontendDispatcher::targetChanged(const String& animationId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Animation.targetChanged"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("animationId"_s, animationId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void AnimationFrontendDispatcher::animationDestroyed(const String& animationId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Animation.animationDestroyed"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("animationId"_s, animationId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void AnimationFrontendDispatcher::trackingStart(double timestamp)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Animation.trackingStart"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("timestamp"_s, timestamp);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void AnimationFrontendDispatcher::trackingUpdate(double timestamp, RefPtr<Inspector::Protocol::Animation::TrackingUpdate> event)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Animation.trackingUpdate"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("timestamp"_s, timestamp);
    paramsObject->setObject("event"_s, event);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void AnimationFrontendDispatcher::trackingComplete(double timestamp)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Animation.trackingComplete"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("timestamp"_s, timestamp);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void ApplicationCacheFrontendDispatcher::applicationCacheStatusUpdated(const String& frameId, const String& manifestURL, int status)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "ApplicationCache.applicationCacheStatusUpdated"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("frameId"_s, frameId);
    paramsObject->setString("manifestURL"_s, manifestURL);
    paramsObject->setInteger("status"_s, status);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void ApplicationCacheFrontendDispatcher::networkStateUpdated(bool isNowOnline)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "ApplicationCache.networkStateUpdated"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setBoolean("isNowOnline"_s, isNowOnline);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

#if ENABLE(RESOURCE_USAGE)
void CPUProfilerFrontendDispatcher::trackingStart(double timestamp)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "CPUProfiler.trackingStart"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("timestamp"_s, timestamp);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void CPUProfilerFrontendDispatcher::trackingUpdate(RefPtr<Inspector::Protocol::CPUProfiler::Event> event)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "CPUProfiler.trackingUpdate"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("event"_s, event);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void CPUProfilerFrontendDispatcher::trackingComplete(double timestamp)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "CPUProfiler.trackingComplete"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("timestamp"_s, timestamp);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}
#endif // ENABLE(RESOURCE_USAGE)

void CSSFrontendDispatcher::mediaQueryResultChanged()
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "CSS.mediaQueryResultChanged"_s);

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void CSSFrontendDispatcher::styleSheetChanged(const String& styleSheetId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "CSS.styleSheetChanged"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("styleSheetId"_s, styleSheetId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void CSSFrontendDispatcher::styleSheetAdded(RefPtr<Inspector::Protocol::CSS::CSSStyleSheetHeader> header)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "CSS.styleSheetAdded"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("header"_s, header);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void CSSFrontendDispatcher::styleSheetRemoved(const String& styleSheetId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "CSS.styleSheetRemoved"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("styleSheetId"_s, styleSheetId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::canvasAdded(RefPtr<Inspector::Protocol::Canvas::Canvas> canvas)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Canvas.canvasAdded"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("canvas"_s, canvas);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::canvasRemoved(const String& canvasId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Canvas.canvasRemoved"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("canvasId"_s, canvasId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::canvasMemoryChanged(const String& canvasId, double memoryCost)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Canvas.canvasMemoryChanged"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("canvasId"_s, canvasId);
    paramsObject->setDouble("memoryCost"_s, memoryCost);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::extensionEnabled(const String& canvasId, const String& extension)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Canvas.extensionEnabled"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("canvasId"_s, canvasId);
    paramsObject->setString("extension"_s, extension);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::clientNodesChanged(const String& canvasId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Canvas.clientNodesChanged"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("canvasId"_s, canvasId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::recordingStarted(const String& canvasId, Inspector::Protocol::Recording::Initiator initiator)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Canvas.recordingStarted"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("canvasId"_s, canvasId);
    paramsObject->setString("initiator"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(initiator));
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::recordingProgress(const String& canvasId, RefPtr<JSON::ArrayOf<Inspector::Protocol::Recording::Frame>> frames, int bufferUsed)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Canvas.recordingProgress"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("canvasId"_s, canvasId);
    paramsObject->setArray("frames"_s, frames);
    paramsObject->setInteger("bufferUsed"_s, bufferUsed);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::recordingFinished(const String& canvasId, RefPtr<Inspector::Protocol::Recording::Recording> recording)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Canvas.recordingFinished"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("canvasId"_s, canvasId);
    if (recording)
        paramsObject->setObject("recording"_s, recording);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::programCreated(RefPtr<Inspector::Protocol::Canvas::ShaderProgram> shaderProgram)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Canvas.programCreated"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("shaderProgram"_s, shaderProgram);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::programDeleted(const String& programId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Canvas.programDeleted"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("programId"_s, programId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void ConsoleFrontendDispatcher::messageAdded(RefPtr<Inspector::Protocol::Console::ConsoleMessage> message)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Console.messageAdded"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("message"_s, message);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void ConsoleFrontendDispatcher::messageRepeatCountUpdated(int count)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Console.messageRepeatCountUpdated"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("count"_s, count);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void ConsoleFrontendDispatcher::messagesCleared()
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Console.messagesCleared"_s);

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void ConsoleFrontendDispatcher::heapSnapshot(double timestamp, const String& snapshotData, const String* title)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Console.heapSnapshot"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("timestamp"_s, timestamp);
    paramsObject->setString("snapshotData"_s, snapshotData);
    if (title)
        paramsObject->setString("title"_s, *title);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::documentUpdated()
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.documentUpdated"_s);

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::inspect(int nodeId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.inspect"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("nodeId"_s, nodeId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::setChildNodes(int parentId, RefPtr<JSON::ArrayOf<Inspector::Protocol::DOM::Node>> nodes)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.setChildNodes"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("parentId"_s, parentId);
    paramsObject->setArray("nodes"_s, nodes);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::attributeModified(int nodeId, const String& name, const String& value)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.attributeModified"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("nodeId"_s, nodeId);
    paramsObject->setString("name"_s, name);
    paramsObject->setString("value"_s, value);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::attributeRemoved(int nodeId, const String& name)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.attributeRemoved"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("nodeId"_s, nodeId);
    paramsObject->setString("name"_s, name);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::inlineStyleInvalidated(RefPtr<JSON::ArrayOf<int>> nodeIds)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.inlineStyleInvalidated"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setArray("nodeIds"_s, nodeIds);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::characterDataModified(int nodeId, const String& characterData)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.characterDataModified"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("nodeId"_s, nodeId);
    paramsObject->setString("characterData"_s, characterData);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::childNodeCountUpdated(int nodeId, int childNodeCount)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.childNodeCountUpdated"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("nodeId"_s, nodeId);
    paramsObject->setInteger("childNodeCount"_s, childNodeCount);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::childNodeInserted(int parentNodeId, int previousNodeId, RefPtr<Inspector::Protocol::DOM::Node> node)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.childNodeInserted"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("parentNodeId"_s, parentNodeId);
    paramsObject->setInteger("previousNodeId"_s, previousNodeId);
    paramsObject->setObject("node"_s, node);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::childNodeRemoved(int parentNodeId, int nodeId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.childNodeRemoved"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("parentNodeId"_s, parentNodeId);
    paramsObject->setInteger("nodeId"_s, nodeId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::shadowRootPushed(int hostId, RefPtr<Inspector::Protocol::DOM::Node> root)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.shadowRootPushed"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("hostId"_s, hostId);
    paramsObject->setObject("root"_s, root);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::shadowRootPopped(int hostId, int rootId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.shadowRootPopped"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("hostId"_s, hostId);
    paramsObject->setInteger("rootId"_s, rootId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::customElementStateChanged(int nodeId, Inspector::Protocol::DOM::CustomElementState customElementState)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.customElementStateChanged"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("nodeId"_s, nodeId);
    paramsObject->setString("customElementState"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(customElementState));
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::pseudoElementAdded(int parentId, RefPtr<Inspector::Protocol::DOM::Node> pseudoElement)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.pseudoElementAdded"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("parentId"_s, parentId);
    paramsObject->setObject("pseudoElement"_s, pseudoElement);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::pseudoElementRemoved(int parentId, int pseudoElementId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.pseudoElementRemoved"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("parentId"_s, parentId);
    paramsObject->setInteger("pseudoElementId"_s, pseudoElementId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::didAddEventListener(int nodeId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.didAddEventListener"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("nodeId"_s, nodeId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::willRemoveEventListener(int nodeId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.willRemoveEventListener"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("nodeId"_s, nodeId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::didFireEvent(int nodeId, const String& eventName, double timestamp, RefPtr<JSON::Object> data)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.didFireEvent"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("nodeId"_s, nodeId);
    paramsObject->setString("eventName"_s, eventName);
    paramsObject->setDouble("timestamp"_s, timestamp);
    if (data)
        paramsObject->setObject("data"_s, data);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::powerEfficientPlaybackStateChanged(int nodeId, double timestamp, bool isPowerEfficient)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOM.powerEfficientPlaybackStateChanged"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("nodeId"_s, nodeId);
    paramsObject->setDouble("timestamp"_s, timestamp);
    paramsObject->setBoolean("isPowerEfficient"_s, isPowerEfficient);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMStorageFrontendDispatcher::domStorageItemsCleared(RefPtr<Inspector::Protocol::DOMStorage::StorageId> storageId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOMStorage.domStorageItemsCleared"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("storageId"_s, storageId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMStorageFrontendDispatcher::domStorageItemRemoved(RefPtr<Inspector::Protocol::DOMStorage::StorageId> storageId, const String& key)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOMStorage.domStorageItemRemoved"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("storageId"_s, storageId);
    paramsObject->setString("key"_s, key);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMStorageFrontendDispatcher::domStorageItemAdded(RefPtr<Inspector::Protocol::DOMStorage::StorageId> storageId, const String& key, const String& newValue)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOMStorage.domStorageItemAdded"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("storageId"_s, storageId);
    paramsObject->setString("key"_s, key);
    paramsObject->setString("newValue"_s, newValue);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DOMStorageFrontendDispatcher::domStorageItemUpdated(RefPtr<Inspector::Protocol::DOMStorage::StorageId> storageId, const String& key, const String& oldValue, const String& newValue)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "DOMStorage.domStorageItemUpdated"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("storageId"_s, storageId);
    paramsObject->setString("key"_s, key);
    paramsObject->setString("oldValue"_s, oldValue);
    paramsObject->setString("newValue"_s, newValue);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DatabaseFrontendDispatcher::addDatabase(RefPtr<Inspector::Protocol::Database::Database> database)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Database.addDatabase"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("database"_s, database);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DebuggerFrontendDispatcher::globalObjectCleared()
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Debugger.globalObjectCleared"_s);

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DebuggerFrontendDispatcher::scriptParsed(const String& scriptId, const String& url, int startLine, int startColumn, int endLine, int endColumn, const bool* isContentScript, const String* sourceURL, const String* sourceMapURL, const bool* module)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Debugger.scriptParsed"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("scriptId"_s, scriptId);
    paramsObject->setString("url"_s, url);
    paramsObject->setInteger("startLine"_s, startLine);
    paramsObject->setInteger("startColumn"_s, startColumn);
    paramsObject->setInteger("endLine"_s, endLine);
    paramsObject->setInteger("endColumn"_s, endColumn);
    if (isContentScript)
        paramsObject->setBoolean("isContentScript"_s, *isContentScript);
    if (sourceURL)
        paramsObject->setString("sourceURL"_s, *sourceURL);
    if (sourceMapURL)
        paramsObject->setString("sourceMapURL"_s, *sourceMapURL);
    if (module)
        paramsObject->setBoolean("module"_s, *module);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DebuggerFrontendDispatcher::scriptFailedToParse(const String& url, const String& scriptSource, int startLine, int errorLine, const String& errorMessage)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Debugger.scriptFailedToParse"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("url"_s, url);
    paramsObject->setString("scriptSource"_s, scriptSource);
    paramsObject->setInteger("startLine"_s, startLine);
    paramsObject->setInteger("errorLine"_s, errorLine);
    paramsObject->setString("errorMessage"_s, errorMessage);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DebuggerFrontendDispatcher::breakpointResolved(const String& breakpointId, RefPtr<Inspector::Protocol::Debugger::Location> location)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Debugger.breakpointResolved"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("breakpointId"_s, breakpointId);
    paramsObject->setObject("location"_s, location);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DebuggerFrontendDispatcher::paused(RefPtr<JSON::ArrayOf<Inspector::Protocol::Debugger::CallFrame>> callFrames, Reason reason, RefPtr<JSON::Object> data, RefPtr<Inspector::Protocol::Console::StackTrace> asyncStackTrace)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Debugger.paused"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setArray("callFrames"_s, callFrames);
    paramsObject->setString("reason"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(reason));
    if (data)
        paramsObject->setObject("data"_s, data);
    if (asyncStackTrace)
        paramsObject->setObject("asyncStackTrace"_s, asyncStackTrace);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DebuggerFrontendDispatcher::resumed()
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Debugger.resumed"_s);

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DebuggerFrontendDispatcher::didSampleProbe(RefPtr<Inspector::Protocol::Debugger::ProbeSample> sample)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Debugger.didSampleProbe"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("sample"_s, sample);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void DebuggerFrontendDispatcher::playBreakpointActionSound(int breakpointActionId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Debugger.playBreakpointActionSound"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setInteger("breakpointActionId"_s, breakpointActionId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void HeapFrontendDispatcher::garbageCollected(RefPtr<Inspector::Protocol::Heap::GarbageCollection> collection)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Heap.garbageCollected"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("collection"_s, collection);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void HeapFrontendDispatcher::trackingStart(double timestamp, const String& snapshotData)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Heap.trackingStart"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("timestamp"_s, timestamp);
    paramsObject->setString("snapshotData"_s, snapshotData);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void HeapFrontendDispatcher::trackingComplete(double timestamp, const String& snapshotData)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Heap.trackingComplete"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("timestamp"_s, timestamp);
    paramsObject->setString("snapshotData"_s, snapshotData);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void InspectorFrontendDispatcher::evaluateForTestInFrontend(const String& script)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Inspector.evaluateForTestInFrontend"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("script"_s, script);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void InspectorFrontendDispatcher::inspect(RefPtr<Inspector::Protocol::Runtime::RemoteObject> object, RefPtr<JSON::Object> hints)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Inspector.inspect"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("object"_s, object);
    paramsObject->setObject("hints"_s, hints);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void InspectorFrontendDispatcher::activateExtraDomains(RefPtr<JSON::ArrayOf<String>> domains)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Inspector.activateExtraDomains"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setArray("domains"_s, domains);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void LayerTreeFrontendDispatcher::layerTreeDidChange()
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "LayerTree.layerTreeDidChange"_s);

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

#if ENABLE(RESOURCE_USAGE)
void MemoryFrontendDispatcher::memoryPressure(double timestamp, Severity severity)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Memory.memoryPressure"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("timestamp"_s, timestamp);
    paramsObject->setString("severity"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(severity));
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void MemoryFrontendDispatcher::trackingStart(double timestamp)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Memory.trackingStart"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("timestamp"_s, timestamp);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void MemoryFrontendDispatcher::trackingUpdate(RefPtr<Inspector::Protocol::Memory::Event> event)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Memory.trackingUpdate"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("event"_s, event);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void MemoryFrontendDispatcher::trackingComplete(double timestamp)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Memory.trackingComplete"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("timestamp"_s, timestamp);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}
#endif // ENABLE(RESOURCE_USAGE)

void NetworkFrontendDispatcher::requestWillBeSent(const String& requestId, const String& frameId, const String& loaderId, const String& documentURL, RefPtr<Inspector::Protocol::Network::Request> request, double timestamp, double walltime, RefPtr<Inspector::Protocol::Network::Initiator> initiator, RefPtr<Inspector::Protocol::Network::Response> redirectResponse, Inspector::Protocol::Page::ResourceType* type, const String* targetId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Network.requestWillBeSent"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("requestId"_s, requestId);
    paramsObject->setString("frameId"_s, frameId);
    paramsObject->setString("loaderId"_s, loaderId);
    paramsObject->setString("documentURL"_s, documentURL);
    paramsObject->setObject("request"_s, request);
    paramsObject->setDouble("timestamp"_s, timestamp);
    paramsObject->setDouble("walltime"_s, walltime);
    paramsObject->setObject("initiator"_s, initiator);
    if (redirectResponse)
        paramsObject->setObject("redirectResponse"_s, redirectResponse);
    if (type)
        paramsObject->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(*type));
    if (targetId)
        paramsObject->setString("targetId"_s, *targetId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::responseReceived(const String& requestId, const String& frameId, const String& loaderId, double timestamp, Inspector::Protocol::Page::ResourceType type, RefPtr<Inspector::Protocol::Network::Response> response)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Network.responseReceived"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("requestId"_s, requestId);
    paramsObject->setString("frameId"_s, frameId);
    paramsObject->setString("loaderId"_s, loaderId);
    paramsObject->setDouble("timestamp"_s, timestamp);
    paramsObject->setString("type"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(type));
    paramsObject->setObject("response"_s, response);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::dataReceived(const String& requestId, double timestamp, int dataLength, int encodedDataLength)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Network.dataReceived"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("requestId"_s, requestId);
    paramsObject->setDouble("timestamp"_s, timestamp);
    paramsObject->setInteger("dataLength"_s, dataLength);
    paramsObject->setInteger("encodedDataLength"_s, encodedDataLength);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::loadingFinished(const String& requestId, double timestamp, const String* sourceMapURL, RefPtr<Inspector::Protocol::Network::Metrics> metrics)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Network.loadingFinished"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("requestId"_s, requestId);
    paramsObject->setDouble("timestamp"_s, timestamp);
    if (sourceMapURL)
        paramsObject->setString("sourceMapURL"_s, *sourceMapURL);
    if (metrics)
        paramsObject->setObject("metrics"_s, metrics);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::loadingFailed(const String& requestId, double timestamp, const String& errorText, const bool* canceled)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Network.loadingFailed"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("requestId"_s, requestId);
    paramsObject->setDouble("timestamp"_s, timestamp);
    paramsObject->setString("errorText"_s, errorText);
    if (canceled)
        paramsObject->setBoolean("canceled"_s, *canceled);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::requestServedFromMemoryCache(const String& requestId, const String& frameId, const String& loaderId, const String& documentURL, double timestamp, RefPtr<Inspector::Protocol::Network::Initiator> initiator, RefPtr<Inspector::Protocol::Network::CachedResource> resource)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Network.requestServedFromMemoryCache"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("requestId"_s, requestId);
    paramsObject->setString("frameId"_s, frameId);
    paramsObject->setString("loaderId"_s, loaderId);
    paramsObject->setString("documentURL"_s, documentURL);
    paramsObject->setDouble("timestamp"_s, timestamp);
    paramsObject->setObject("initiator"_s, initiator);
    paramsObject->setObject("resource"_s, resource);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::responseIntercepted(const String& requestId, RefPtr<Inspector::Protocol::Network::Response> response)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Network.responseIntercepted"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("requestId"_s, requestId);
    paramsObject->setObject("response"_s, response);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::webSocketWillSendHandshakeRequest(const String& requestId, double timestamp, double walltime, RefPtr<Inspector::Protocol::Network::WebSocketRequest> request)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Network.webSocketWillSendHandshakeRequest"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("requestId"_s, requestId);
    paramsObject->setDouble("timestamp"_s, timestamp);
    paramsObject->setDouble("walltime"_s, walltime);
    paramsObject->setObject("request"_s, request);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::webSocketHandshakeResponseReceived(const String& requestId, double timestamp, RefPtr<Inspector::Protocol::Network::WebSocketResponse> response)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Network.webSocketHandshakeResponseReceived"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("requestId"_s, requestId);
    paramsObject->setDouble("timestamp"_s, timestamp);
    paramsObject->setObject("response"_s, response);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::webSocketCreated(const String& requestId, const String& url)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Network.webSocketCreated"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("requestId"_s, requestId);
    paramsObject->setString("url"_s, url);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::webSocketClosed(const String& requestId, double timestamp)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Network.webSocketClosed"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("requestId"_s, requestId);
    paramsObject->setDouble("timestamp"_s, timestamp);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::webSocketFrameReceived(const String& requestId, double timestamp, RefPtr<Inspector::Protocol::Network::WebSocketFrame> response)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Network.webSocketFrameReceived"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("requestId"_s, requestId);
    paramsObject->setDouble("timestamp"_s, timestamp);
    paramsObject->setObject("response"_s, response);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::webSocketFrameError(const String& requestId, double timestamp, const String& errorMessage)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Network.webSocketFrameError"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("requestId"_s, requestId);
    paramsObject->setDouble("timestamp"_s, timestamp);
    paramsObject->setString("errorMessage"_s, errorMessage);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::webSocketFrameSent(const String& requestId, double timestamp, RefPtr<Inspector::Protocol::Network::WebSocketFrame> response)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Network.webSocketFrameSent"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("requestId"_s, requestId);
    paramsObject->setDouble("timestamp"_s, timestamp);
    paramsObject->setObject("response"_s, response);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void PageFrontendDispatcher::domContentEventFired(double timestamp)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Page.domContentEventFired"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("timestamp"_s, timestamp);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void PageFrontendDispatcher::loadEventFired(double timestamp)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Page.loadEventFired"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("timestamp"_s, timestamp);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void PageFrontendDispatcher::frameNavigated(RefPtr<Inspector::Protocol::Page::Frame> frame)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Page.frameNavigated"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("frame"_s, frame);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void PageFrontendDispatcher::frameDetached(const String& frameId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Page.frameDetached"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("frameId"_s, frameId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void PageFrontendDispatcher::frameStartedLoading(const String& frameId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Page.frameStartedLoading"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("frameId"_s, frameId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void PageFrontendDispatcher::frameStoppedLoading(const String& frameId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Page.frameStoppedLoading"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("frameId"_s, frameId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void PageFrontendDispatcher::frameScheduledNavigation(const String& frameId, double delay)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Page.frameScheduledNavigation"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("frameId"_s, frameId);
    paramsObject->setDouble("delay"_s, delay);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void PageFrontendDispatcher::frameClearedScheduledNavigation(const String& frameId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Page.frameClearedScheduledNavigation"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("frameId"_s, frameId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void PageFrontendDispatcher::defaultAppearanceDidChange(Inspector::Protocol::Page::Appearance appearance)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Page.defaultAppearanceDidChange"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("appearance"_s, Inspector::Protocol::InspectorHelpers::getEnumConstantValue(appearance));
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void RuntimeFrontendDispatcher::executionContextCreated(RefPtr<Inspector::Protocol::Runtime::ExecutionContextDescription> context)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Runtime.executionContextCreated"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("context"_s, context);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void ScriptProfilerFrontendDispatcher::trackingStart(double timestamp)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "ScriptProfiler.trackingStart"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("timestamp"_s, timestamp);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void ScriptProfilerFrontendDispatcher::trackingUpdate(RefPtr<Inspector::Protocol::ScriptProfiler::Event> event)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "ScriptProfiler.trackingUpdate"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("event"_s, event);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void ScriptProfilerFrontendDispatcher::trackingComplete(double timestamp, RefPtr<Inspector::Protocol::ScriptProfiler::Samples> samples)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "ScriptProfiler.trackingComplete"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("timestamp"_s, timestamp);
    if (samples)
        paramsObject->setObject("samples"_s, samples);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void TargetFrontendDispatcher::targetCreated(RefPtr<Inspector::Protocol::Target::TargetInfo> targetInfo)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Target.targetCreated"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("targetInfo"_s, targetInfo);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void TargetFrontendDispatcher::targetDestroyed(const String& targetId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Target.targetDestroyed"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("targetId"_s, targetId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void TargetFrontendDispatcher::didCommitProvisionalTarget(const String& oldTargetId, const String& newTargetId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Target.didCommitProvisionalTarget"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("oldTargetId"_s, oldTargetId);
    paramsObject->setString("newTargetId"_s, newTargetId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void TargetFrontendDispatcher::dispatchMessageFromTarget(const String& targetId, const String& message)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Target.dispatchMessageFromTarget"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("targetId"_s, targetId);
    paramsObject->setString("message"_s, message);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void TimelineFrontendDispatcher::eventRecorded(RefPtr<Inspector::Protocol::Timeline::TimelineEvent> record)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Timeline.eventRecorded"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setObject("record"_s, record);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void TimelineFrontendDispatcher::recordingStarted(double startTime)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Timeline.recordingStarted"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("startTime"_s, startTime);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void TimelineFrontendDispatcher::recordingStopped(double endTime)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Timeline.recordingStopped"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setDouble("endTime"_s, endTime);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void TimelineFrontendDispatcher::autoCaptureStarted()
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Timeline.autoCaptureStarted"_s);

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void WorkerFrontendDispatcher::workerCreated(const String& workerId, const String& url)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Worker.workerCreated"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("workerId"_s, workerId);
    paramsObject->setString("url"_s, url);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void WorkerFrontendDispatcher::workerTerminated(const String& workerId)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Worker.workerTerminated"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("workerId"_s, workerId);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

void WorkerFrontendDispatcher::dispatchMessageFromWorker(const String& workerId, const String& message)
{
    Ref<JSON::Object> jsonMessage = JSON::Object::create();
    jsonMessage->setString("method"_s, "Worker.dispatchMessageFromWorker"_s);
    Ref<JSON::Object> paramsObject = JSON::Object::create();
    paramsObject->setString("workerId"_s, workerId);
    paramsObject->setString("message"_s, message);
    jsonMessage->setObject("params"_s, WTFMove(paramsObject));

    m_frontendRouter.sendEvent(jsonMessage->toJSONString());
}

} // namespace Inspector
