/*
 * Copyright (C) 2018 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#if __has_include(<WebKitAdditions/JavaScriptCorePrefix.h>)
#include <WebKitAdditions/JavaScriptCorePrefix.h>
#endif

//+TELESCOPE_LIB_CHANGES
// 7/29/2020
// compile error fix
#ifdef __cplusplus
//#define NULL __null
#else
#define NULL ((void *)0)
#endif
//-TELESCOPE_LIB_CHANGES

 //+TELESCOPE_LIB_CHANGES
 // 7/29/2020
 // frequently included headers
#include <wtf/Platform.h>
#if OS(WINBASED)
#include <windows.h>
#endif
//-TELESCOPE_LIB_CHANGES

//+TELESCOPE_LIB_CHANGES
// 7/29/2020
// comment out outdated headers
#include <ctype.h>
#include <float.h>
#include <locale.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include <strings.h>
#include <time.h>
//#include <sys/param.h>
//#include <sys/time.h>
//#include <sys/timeb.h>
#include <sys/types.h>
//-TELESCOPE_LIB_CHANGES

#ifdef __cplusplus

#include <list>
#include <typeinfo>

 //+TELESCOPE_LIB_CHANGES
 // 7/29/2020
 // frequently included headers
#include "config.h"
#include "CodeBlock.h"
#include "VM.h"
#include "JSONObject.h"
#include "JSCJSValue.h"
#include "JSCInlines.h"
#include "DFGGraph.h"
#include "BytecodeStructs.h"
#include "InspectorProtocolObjects.h"
#include "JIT.h"
#include "InspectorBackendDispatchers.h"
#include "wtf/Atomics.h"
#include "wtf/FastMalloc.h"
//-TELESCOPE_LIB_CHANGES

#endif

#ifdef __cplusplus
#define new ("if you use new/delete make sure to include config.h at the top of the file"()) 
#define delete ("if you use new/delete make sure to include config.h at the top of the file"()) 
#endif

/* Work around bug with C++ library that screws up Objective-C++ when exception support is disabled. */
#undef try
#undef catch

