/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json
// by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#pragma once

#include "InspectorBackendDispatcher.h"
#include "InspectorProtocolObjects.h"
#include <wtf/text/WTFString.h>

namespace Inspector {

typedef String ErrorString;

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
class AlternateAnimationBackendDispatcher;
class AlternateApplicationCacheBackendDispatcher;
class AlternateAuditBackendDispatcher;
#if ENABLE(RESOURCE_USAGE)
class AlternateCPUProfilerBackendDispatcher;
#endif // ENABLE(RESOURCE_USAGE)
class AlternateCSSBackendDispatcher;
class AlternateCanvasBackendDispatcher;
class AlternateConsoleBackendDispatcher;
class AlternateDOMBackendDispatcher;
class AlternateDOMDebuggerBackendDispatcher;
class AlternateDOMStorageBackendDispatcher;
class AlternateDatabaseBackendDispatcher;
class AlternateDebuggerBackendDispatcher;
class AlternateHeapBackendDispatcher;
#if ENABLE(INDEXED_DATABASE)
class AlternateIndexedDBBackendDispatcher;
#endif // ENABLE(INDEXED_DATABASE)
class AlternateInspectorBackendDispatcher;
class AlternateLayerTreeBackendDispatcher;
#if ENABLE(RESOURCE_USAGE)
class AlternateMemoryBackendDispatcher;
#endif // ENABLE(RESOURCE_USAGE)
class AlternateNetworkBackendDispatcher;
class AlternatePageBackendDispatcher;
class AlternateRuntimeBackendDispatcher;
class AlternateScriptProfilerBackendDispatcher;
class AlternateServiceWorkerBackendDispatcher;
class AlternateTargetBackendDispatcher;
class AlternateTimelineBackendDispatcher;
class AlternateWorkerBackendDispatcher;
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

class JS_EXPORT_PRIVATE AnimationBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void requestEffectTarget(ErrorString&, const String& in_animationId, int* out_nodeId) = 0;
    virtual void resolveAnimation(ErrorString&, const String& in_animationId, const String* opt_in_objectGroup, RefPtr<Inspector::Protocol::Runtime::RemoteObject>& out_object) = 0;
    virtual void startTracking(ErrorString&) = 0;
    virtual void stopTracking(ErrorString&) = 0;
protected:
    virtual ~AnimationBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE ApplicationCacheBackendDispatcherHandler {
public:
    virtual void getFramesWithManifests(ErrorString&, RefPtr<JSON::ArrayOf<Inspector::Protocol::ApplicationCache::FrameWithManifest>>& out_frameIds) = 0;
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void getManifestForFrame(ErrorString&, const String& in_frameId, String* out_manifestURL) = 0;
    virtual void getApplicationCacheForFrame(ErrorString&, const String& in_frameId, RefPtr<Inspector::Protocol::ApplicationCache::ApplicationCache>& out_applicationCache) = 0;
protected:
    virtual ~ApplicationCacheBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE AuditBackendDispatcherHandler {
public:
    virtual void setup(ErrorString&, const int* opt_in_contextId) = 0;
    virtual void run(ErrorString&, const String& in_test, const int* opt_in_contextId, RefPtr<Inspector::Protocol::Runtime::RemoteObject>& out_result, Optional<bool>& opt_out_wasThrown) = 0;
    virtual void teardown(ErrorString&) = 0;
protected:
    virtual ~AuditBackendDispatcherHandler();
};

#if ENABLE(RESOURCE_USAGE)
class JS_EXPORT_PRIVATE CPUProfilerBackendDispatcherHandler {
public:
    virtual void startTracking(ErrorString&) = 0;
    virtual void stopTracking(ErrorString&) = 0;
protected:
    virtual ~CPUProfilerBackendDispatcherHandler();
};
#endif // ENABLE(RESOURCE_USAGE)

class JS_EXPORT_PRIVATE CSSBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void getMatchedStylesForNode(ErrorString&, int in_nodeId, const bool* opt_in_includePseudo, const bool* opt_in_includeInherited, RefPtr<JSON::ArrayOf<Inspector::Protocol::CSS::RuleMatch>>& opt_out_matchedCSSRules, RefPtr<JSON::ArrayOf<Inspector::Protocol::CSS::PseudoIdMatches>>& opt_out_pseudoElements, RefPtr<JSON::ArrayOf<Inspector::Protocol::CSS::InheritedStyleEntry>>& opt_out_inherited) = 0;
    virtual void getInlineStylesForNode(ErrorString&, int in_nodeId, RefPtr<Inspector::Protocol::CSS::CSSStyle>& opt_out_inlineStyle, RefPtr<Inspector::Protocol::CSS::CSSStyle>& opt_out_attributesStyle) = 0;
    virtual void getComputedStyleForNode(ErrorString&, int in_nodeId, RefPtr<JSON::ArrayOf<Inspector::Protocol::CSS::CSSComputedStyleProperty>>& out_computedStyle) = 0;
    virtual void getAllStyleSheets(ErrorString&, RefPtr<JSON::ArrayOf<Inspector::Protocol::CSS::CSSStyleSheetHeader>>& out_headers) = 0;
    virtual void getStyleSheet(ErrorString&, const String& in_styleSheetId, RefPtr<Inspector::Protocol::CSS::CSSStyleSheetBody>& out_styleSheet) = 0;
    virtual void getStyleSheetText(ErrorString&, const String& in_styleSheetId, String* out_text) = 0;
    virtual void setStyleSheetText(ErrorString&, const String& in_styleSheetId, const String& in_text) = 0;
    virtual void setStyleText(ErrorString&, const JSON::Object& in_styleId, const String& in_text, RefPtr<Inspector::Protocol::CSS::CSSStyle>& out_style) = 0;
    virtual void setRuleSelector(ErrorString&, const JSON::Object& in_ruleId, const String& in_selector, RefPtr<Inspector::Protocol::CSS::CSSRule>& out_rule) = 0;
    virtual void createStyleSheet(ErrorString&, const String& in_frameId, String* out_styleSheetId) = 0;
    virtual void addRule(ErrorString&, const String& in_styleSheetId, const String& in_selector, RefPtr<Inspector::Protocol::CSS::CSSRule>& out_rule) = 0;
    virtual void getSupportedCSSProperties(ErrorString&, RefPtr<JSON::ArrayOf<Inspector::Protocol::CSS::CSSPropertyInfo>>& out_cssProperties) = 0;
    virtual void getSupportedSystemFontFamilyNames(ErrorString&, RefPtr<JSON::ArrayOf<String>>& out_fontFamilyNames) = 0;
    virtual void forcePseudoState(ErrorString&, int in_nodeId, const JSON::Array& in_forcedPseudoClasses) = 0;
protected:
    virtual ~CSSBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE CanvasBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void requestNode(ErrorString&, const String& in_canvasId, int* out_nodeId) = 0;
    virtual void requestContent(ErrorString&, const String& in_canvasId, String* out_content) = 0;
    virtual void requestClientNodes(ErrorString&, const String& in_canvasId, RefPtr<JSON::ArrayOf<int>>& out_clientNodeIds) = 0;
    virtual void resolveContext(ErrorString&, const String& in_canvasId, const String* opt_in_objectGroup, RefPtr<Inspector::Protocol::Runtime::RemoteObject>& out_object) = 0;
    virtual void setRecordingAutoCaptureFrameCount(ErrorString&, int in_count) = 0;
    virtual void startRecording(ErrorString&, const String& in_canvasId, const int* opt_in_frameCount, const int* opt_in_memoryLimit) = 0;
    virtual void stopRecording(ErrorString&, const String& in_canvasId) = 0;
    virtual void requestShaderSource(ErrorString&, const String& in_programId, const String& in_shaderType, String* out_source) = 0;
    virtual void updateShader(ErrorString&, const String& in_programId, const String& in_shaderType, const String& in_source) = 0;
    virtual void setShaderProgramDisabled(ErrorString&, const String& in_programId, bool in_disabled) = 0;
    virtual void setShaderProgramHighlighted(ErrorString&, const String& in_programId, bool in_highlighted) = 0;
protected:
    virtual ~CanvasBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE ConsoleBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void clearMessages(ErrorString&) = 0;
    virtual void getLoggingChannels(ErrorString&, RefPtr<JSON::ArrayOf<Inspector::Protocol::Console::Channel>>& out_channels) = 0;
    virtual void setLoggingChannelLevel(ErrorString&, const String& in_source, const String& in_level) = 0;
protected:
    virtual ~ConsoleBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DOMBackendDispatcherHandler {
public:
    virtual void getDocument(ErrorString&, RefPtr<Inspector::Protocol::DOM::Node>& out_root) = 0;
    virtual void requestChildNodes(ErrorString&, int in_nodeId, const int* opt_in_depth) = 0;
    virtual void querySelector(ErrorString&, int in_nodeId, const String& in_selector, int* out_nodeId) = 0;
    virtual void querySelectorAll(ErrorString&, int in_nodeId, const String& in_selector, RefPtr<JSON::ArrayOf<int>>& out_nodeIds) = 0;
    virtual void setNodeName(ErrorString&, int in_nodeId, const String& in_name, int* out_nodeId) = 0;
    virtual void setNodeValue(ErrorString&, int in_nodeId, const String& in_value) = 0;
    virtual void removeNode(ErrorString&, int in_nodeId) = 0;
    virtual void setAttributeValue(ErrorString&, int in_nodeId, const String& in_name, const String& in_value) = 0;
    virtual void setAttributesAsText(ErrorString&, int in_nodeId, const String& in_text, const String* opt_in_name) = 0;
    virtual void removeAttribute(ErrorString&, int in_nodeId, const String& in_name) = 0;
    virtual void getSupportedEventNames(ErrorString&, RefPtr<JSON::ArrayOf<String>>& out_eventNames) = 0;
    virtual void getDataBindingsForNode(ErrorString&, int in_nodeId, RefPtr<JSON::ArrayOf<Inspector::Protocol::DOM::DataBinding>>& out_dataBindings) = 0;
    virtual void getAssociatedDataForNode(ErrorString&, int in_nodeId, Optional<String>& opt_out_associatedData) = 0;
    virtual void getEventListenersForNode(ErrorString&, int in_nodeId, RefPtr<JSON::ArrayOf<Inspector::Protocol::DOM::EventListener>>& out_listeners) = 0;
    virtual void setEventListenerDisabled(ErrorString&, int in_eventListenerId, bool in_disabled) = 0;
    virtual void setBreakpointForEventListener(ErrorString&, int in_eventListenerId) = 0;
    virtual void removeBreakpointForEventListener(ErrorString&, int in_eventListenerId) = 0;
    virtual void getAccessibilityPropertiesForNode(ErrorString&, int in_nodeId, RefPtr<Inspector::Protocol::DOM::AccessibilityProperties>& out_properties) = 0;
    virtual void getOuterHTML(ErrorString&, int in_nodeId, String* out_outerHTML) = 0;
    virtual void setOuterHTML(ErrorString&, int in_nodeId, const String& in_outerHTML) = 0;
    virtual void insertAdjacentHTML(ErrorString&, int in_nodeId, const String& in_position, const String& in_html) = 0;
    virtual void performSearch(ErrorString&, const String& in_query, const JSON::Array* opt_in_nodeIds, const bool* opt_in_caseSensitive, String* out_searchId, int* out_resultCount) = 0;
    virtual void getSearchResults(ErrorString&, const String& in_searchId, int in_fromIndex, int in_toIndex, RefPtr<JSON::ArrayOf<int>>& out_nodeIds) = 0;
    virtual void discardSearchResults(ErrorString&, const String& in_searchId) = 0;
    virtual void requestNode(ErrorString&, const String& in_objectId, int* out_nodeId) = 0;
    virtual void setInspectModeEnabled(ErrorString&, bool in_enabled, const JSON::Object* opt_in_highlightConfig, const bool* opt_in_showRulers) = 0;
    virtual void highlightRect(ErrorString&, int in_x, int in_y, int in_width, int in_height, const JSON::Object* opt_in_color, const JSON::Object* opt_in_outlineColor, const bool* opt_in_usePageCoordinates) = 0;
    virtual void highlightQuad(ErrorString&, const JSON::Array& in_quad, const JSON::Object* opt_in_color, const JSON::Object* opt_in_outlineColor, const bool* opt_in_usePageCoordinates) = 0;
    virtual void highlightSelector(ErrorString&, const JSON::Object& in_highlightConfig, const String& in_selectorString, const String* opt_in_frameId) = 0;
    virtual void highlightNode(ErrorString&, const JSON::Object& in_highlightConfig, const int* opt_in_nodeId, const String* opt_in_objectId) = 0;
    virtual void highlightNodeList(ErrorString&, const JSON::Array& in_nodeIds, const JSON::Object& in_highlightConfig) = 0;
    virtual void hideHighlight(ErrorString&) = 0;
    virtual void highlightFrame(ErrorString&, const String& in_frameId, const JSON::Object* opt_in_contentColor, const JSON::Object* opt_in_contentOutlineColor) = 0;
    virtual void pushNodeByPathToFrontend(ErrorString&, const String& in_path, int* out_nodeId) = 0;
    virtual void resolveNode(ErrorString&, int in_nodeId, const String* opt_in_objectGroup, RefPtr<Inspector::Protocol::Runtime::RemoteObject>& out_object) = 0;
    virtual void getAttributes(ErrorString&, int in_nodeId, RefPtr<JSON::ArrayOf<String>>& out_attributes) = 0;
    virtual void moveTo(ErrorString&, int in_nodeId, int in_targetNodeId, const int* opt_in_insertBeforeNodeId, int* out_nodeId) = 0;
    virtual void undo(ErrorString&) = 0;
    virtual void redo(ErrorString&) = 0;
    virtual void markUndoableState(ErrorString&) = 0;
    virtual void focus(ErrorString&, int in_nodeId) = 0;
    virtual void setInspectedNode(ErrorString&, int in_nodeId) = 0;
    virtual void setAllowEditingUserAgentShadowTrees(ErrorString&, bool in_allow) = 0;
protected:
    virtual ~DOMBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DOMDebuggerBackendDispatcherHandler {
public:
    virtual void setDOMBreakpoint(ErrorString&, int in_nodeId, const String& in_type) = 0;
    virtual void removeDOMBreakpoint(ErrorString&, int in_nodeId, const String& in_type) = 0;
    virtual void setEventBreakpoint(ErrorString&, const String& in_breakpointType, const String* opt_in_eventName) = 0;
    virtual void removeEventBreakpoint(ErrorString&, const String& in_breakpointType, const String* opt_in_eventName) = 0;
    virtual void setURLBreakpoint(ErrorString&, const String& in_url, const bool* opt_in_isRegex) = 0;
    virtual void removeURLBreakpoint(ErrorString&, const String& in_url) = 0;
protected:
    virtual ~DOMDebuggerBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DOMStorageBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void getDOMStorageItems(ErrorString&, const JSON::Object& in_storageId, RefPtr<JSON::ArrayOf<Inspector::Protocol::DOMStorage::Item>>& out_entries) = 0;
    virtual void setDOMStorageItem(ErrorString&, const JSON::Object& in_storageId, const String& in_key, const String& in_value) = 0;
    virtual void removeDOMStorageItem(ErrorString&, const JSON::Object& in_storageId, const String& in_key) = 0;
protected:
    virtual ~DOMStorageBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DatabaseBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void getDatabaseTableNames(ErrorString&, const String& in_databaseId, RefPtr<JSON::ArrayOf<String>>& out_tableNames) = 0;
    class JS_EXPORT_PRIVATE ExecuteSQLCallback : public BackendDispatcher::CallbackBase {
    public:
        ExecuteSQLCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(RefPtr<JSON::ArrayOf<String>>&& columnNames, RefPtr<JSON::ArrayOf<JSON::Value>>&& values, RefPtr<Inspector::Protocol::Database::Error>&& sqlError);
    };
    virtual void executeSQL(const String& in_databaseId, const String& in_query, Ref<ExecuteSQLCallback>&& callback) = 0;
protected:
    virtual ~DatabaseBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DebuggerBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void setAsyncStackTraceDepth(ErrorString&, int in_depth) = 0;
    virtual void setBreakpointsActive(ErrorString&, bool in_active) = 0;
    virtual void setBreakpointByUrl(ErrorString&, int in_lineNumber, const String* opt_in_url, const String* opt_in_urlRegex, const int* opt_in_columnNumber, const JSON::Object* opt_in_options, String* out_breakpointId, RefPtr<JSON::ArrayOf<Inspector::Protocol::Debugger::Location>>& out_locations) = 0;
    virtual void setBreakpoint(ErrorString&, const JSON::Object& in_location, const JSON::Object* opt_in_options, String* out_breakpointId, RefPtr<Inspector::Protocol::Debugger::Location>& out_actualLocation) = 0;
    virtual void removeBreakpoint(ErrorString&, const String& in_breakpointId) = 0;
    virtual void continueUntilNextRunLoop(ErrorString&) = 0;
    virtual void continueToLocation(ErrorString&, const JSON::Object& in_location) = 0;
    virtual void stepOver(ErrorString&) = 0;
    virtual void stepInto(ErrorString&) = 0;
    virtual void stepOut(ErrorString&) = 0;
    virtual void pause(ErrorString&) = 0;
    virtual void resume(ErrorString&) = 0;
    virtual void searchInContent(ErrorString&, const String& in_scriptId, const String& in_query, const bool* opt_in_caseSensitive, const bool* opt_in_isRegex, RefPtr<JSON::ArrayOf<Inspector::Protocol::GenericTypes::SearchMatch>>& out_result) = 0;
    virtual void getScriptSource(ErrorString&, const String& in_scriptId, String* out_scriptSource) = 0;
    virtual void getFunctionDetails(ErrorString&, const String& in_functionId, RefPtr<Inspector::Protocol::Debugger::FunctionDetails>& out_details) = 0;
    // Named after parameter 'state' while generating command/event setPauseOnExceptions.
    enum class State {
        None = 9,
        Uncaught = 243,
        All = 244,
    }; // enum class State
    virtual void setPauseOnExceptions(ErrorString&, const String& in_state) = 0;
    virtual void setPauseOnAssertions(ErrorString&, bool in_enabled) = 0;
    virtual void setPauseOnMicrotasks(ErrorString&, bool in_enabled) = 0;
    virtual void setPauseForInternalScripts(ErrorString&, bool in_shouldPause) = 0;
    virtual void evaluateOnCallFrame(ErrorString&, const String& in_callFrameId, const String& in_expression, const String* opt_in_objectGroup, const bool* opt_in_includeCommandLineAPI, const bool* opt_in_doNotPauseOnExceptionsAndMuteConsole, const bool* opt_in_returnByValue, const bool* opt_in_generatePreview, const bool* opt_in_saveResult, const bool* opt_in_emulateUserGesture, RefPtr<Inspector::Protocol::Runtime::RemoteObject>& out_result, Optional<bool>& opt_out_wasThrown, Optional<int>& opt_out_savedResultIndex) = 0;
    virtual void setShouldBlackboxURL(ErrorString&, const String& in_url, bool in_shouldBlackbox, const bool* opt_in_caseSensitive, const bool* opt_in_isRegex) = 0;
protected:
    virtual ~DebuggerBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE HeapBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void gc(ErrorString&) = 0;
    virtual void snapshot(ErrorString&, double* out_timestamp, String* out_snapshotData) = 0;
    virtual void startTracking(ErrorString&) = 0;
    virtual void stopTracking(ErrorString&) = 0;
    virtual void getPreview(ErrorString&, int in_heapObjectId, Optional<String>& opt_out_string, RefPtr<Inspector::Protocol::Debugger::FunctionDetails>& opt_out_functionDetails, RefPtr<Inspector::Protocol::Runtime::ObjectPreview>& opt_out_preview) = 0;
    virtual void getRemoteObject(ErrorString&, int in_heapObjectId, const String* opt_in_objectGroup, RefPtr<Inspector::Protocol::Runtime::RemoteObject>& out_result) = 0;
protected:
    virtual ~HeapBackendDispatcherHandler();
};

#if ENABLE(INDEXED_DATABASE)
class JS_EXPORT_PRIVATE IndexedDBBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    class JS_EXPORT_PRIVATE RequestDatabaseNamesCallback : public BackendDispatcher::CallbackBase {
    public:
        RequestDatabaseNamesCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(RefPtr<JSON::ArrayOf<String>>&& databaseNames);
    };
    virtual void requestDatabaseNames(const String& in_securityOrigin, Ref<RequestDatabaseNamesCallback>&& callback) = 0;
    class JS_EXPORT_PRIVATE RequestDatabaseCallback : public BackendDispatcher::CallbackBase {
    public:
        RequestDatabaseCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(RefPtr<Inspector::Protocol::IndexedDB::DatabaseWithObjectStores>&& databaseWithObjectStores);
    };
    virtual void requestDatabase(const String& in_securityOrigin, const String& in_databaseName, Ref<RequestDatabaseCallback>&& callback) = 0;
    class JS_EXPORT_PRIVATE RequestDataCallback : public BackendDispatcher::CallbackBase {
    public:
        RequestDataCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(RefPtr<JSON::ArrayOf<Inspector::Protocol::IndexedDB::DataEntry>>&& objectStoreDataEntries, bool hasMore);
    };
    virtual void requestData(const String& in_securityOrigin, const String& in_databaseName, const String& in_objectStoreName, const String& in_indexName, int in_skipCount, int in_pageSize, const JSON::Object* opt_in_keyRange, Ref<RequestDataCallback>&& callback) = 0;
    class JS_EXPORT_PRIVATE ClearObjectStoreCallback : public BackendDispatcher::CallbackBase {
    public:
        ClearObjectStoreCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void clearObjectStore(const String& in_securityOrigin, const String& in_databaseName, const String& in_objectStoreName, Ref<ClearObjectStoreCallback>&& callback) = 0;
protected:
    virtual ~IndexedDBBackendDispatcherHandler();
};
#endif // ENABLE(INDEXED_DATABASE)

class JS_EXPORT_PRIVATE InspectorBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void initialized(ErrorString&) = 0;
protected:
    virtual ~InspectorBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE LayerTreeBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void layersForNode(ErrorString&, int in_nodeId, RefPtr<JSON::ArrayOf<Inspector::Protocol::LayerTree::Layer>>& out_layers) = 0;
    virtual void reasonsForCompositingLayer(ErrorString&, const String& in_layerId, RefPtr<Inspector::Protocol::LayerTree::CompositingReasons>& out_compositingReasons) = 0;
protected:
    virtual ~LayerTreeBackendDispatcherHandler();
};

#if ENABLE(RESOURCE_USAGE)
class JS_EXPORT_PRIVATE MemoryBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void startTracking(ErrorString&) = 0;
    virtual void stopTracking(ErrorString&) = 0;
protected:
    virtual ~MemoryBackendDispatcherHandler();
};
#endif // ENABLE(RESOURCE_USAGE)

class JS_EXPORT_PRIVATE NetworkBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void setExtraHTTPHeaders(ErrorString&, const JSON::Object& in_headers) = 0;
    virtual void getResponseBody(ErrorString&, const String& in_requestId, String* out_body, bool* out_base64Encoded) = 0;
    virtual void setResourceCachingDisabled(ErrorString&, bool in_disabled) = 0;
    class JS_EXPORT_PRIVATE LoadResourceCallback : public BackendDispatcher::CallbackBase {
    public:
        LoadResourceCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(const String& content, const String& mimeType, int status);
    };
    virtual void loadResource(const String& in_frameId, const String& in_url, Ref<LoadResourceCallback>&& callback) = 0;
    virtual void getSerializedCertificate(ErrorString&, const String& in_requestId, String* out_serializedCertificate) = 0;
    virtual void resolveWebSocket(ErrorString&, const String& in_requestId, const String* opt_in_objectGroup, RefPtr<Inspector::Protocol::Runtime::RemoteObject>& out_object) = 0;
    virtual void setInterceptionEnabled(ErrorString&, bool in_enabled) = 0;
    virtual void addInterception(ErrorString&, const String& in_url, const bool* opt_in_caseSensitive, const bool* opt_in_isRegex, const String* opt_in_stage) = 0;
    virtual void removeInterception(ErrorString&, const String& in_url, const bool* opt_in_caseSensitive, const bool* opt_in_isRegex, const String* opt_in_stage) = 0;
    virtual void interceptContinue(ErrorString&, const String& in_requestId) = 0;
    virtual void interceptWithResponse(ErrorString&, const String& in_requestId, const String& in_content, bool in_base64Encoded, const String* opt_in_mimeType, const int* opt_in_status, const String* opt_in_statusText, const JSON::Object* opt_in_headers) = 0;
protected:
    virtual ~NetworkBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE PageBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void reload(ErrorString&, const bool* opt_in_ignoreCache, const bool* opt_in_revalidateAllResources) = 0;
    virtual void navigate(ErrorString&, const String& in_url) = 0;
    virtual void overrideUserAgent(ErrorString&, const String* opt_in_value) = 0;
    virtual void overrideSetting(ErrorString&, const String& in_setting, const bool* opt_in_value) = 0;
    virtual void getCookies(ErrorString&, RefPtr<JSON::ArrayOf<Inspector::Protocol::Page::Cookie>>& out_cookies) = 0;
    virtual void deleteCookie(ErrorString&, const String& in_cookieName, const String& in_url) = 0;
    virtual void getResourceTree(ErrorString&, RefPtr<Inspector::Protocol::Page::FrameResourceTree>& out_frameTree) = 0;
    virtual void getResourceContent(ErrorString&, const String& in_frameId, const String& in_url, String* out_content, bool* out_base64Encoded) = 0;
    virtual void setBootstrapScript(ErrorString&, const String* opt_in_source) = 0;
    virtual void searchInResource(ErrorString&, const String& in_frameId, const String& in_url, const String& in_query, const bool* opt_in_caseSensitive, const bool* opt_in_isRegex, const String* opt_in_requestId, RefPtr<JSON::ArrayOf<Inspector::Protocol::GenericTypes::SearchMatch>>& out_result) = 0;
    virtual void searchInResources(ErrorString&, const String& in_text, const bool* opt_in_caseSensitive, const bool* opt_in_isRegex, RefPtr<JSON::ArrayOf<Inspector::Protocol::Page::SearchResult>>& out_result) = 0;
    virtual void setShowRulers(ErrorString&, bool in_result) = 0;
    virtual void setShowPaintRects(ErrorString&, bool in_result) = 0;
    virtual void setEmulatedMedia(ErrorString&, const String& in_media) = 0;
    virtual void setForcedAppearance(ErrorString&, const String& in_appearance) = 0;
    virtual void snapshotNode(ErrorString&, int in_nodeId, String* out_dataURL) = 0;
    virtual void snapshotRect(ErrorString&, int in_x, int in_y, int in_width, int in_height, const String& in_coordinateSystem, String* out_dataURL) = 0;
    virtual void archive(ErrorString&, String* out_data) = 0;
protected:
    virtual ~PageBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE RuntimeBackendDispatcherHandler {
public:
    virtual void parse(ErrorString&, const String& in_source, Inspector::Protocol::Runtime::SyntaxErrorType* out_result, Optional<String>& opt_out_message, RefPtr<Inspector::Protocol::Runtime::ErrorRange>& opt_out_range) = 0;
    virtual void evaluate(ErrorString&, const String& in_expression, const String* opt_in_objectGroup, const bool* opt_in_includeCommandLineAPI, const bool* opt_in_doNotPauseOnExceptionsAndMuteConsole, const int* opt_in_contextId, const bool* opt_in_returnByValue, const bool* opt_in_generatePreview, const bool* opt_in_saveResult, const bool* opt_in_emulateUserGesture, RefPtr<Inspector::Protocol::Runtime::RemoteObject>& out_result, Optional<bool>& opt_out_wasThrown, Optional<int>& opt_out_savedResultIndex) = 0;
    class JS_EXPORT_PRIVATE AwaitPromiseCallback : public BackendDispatcher::CallbackBase {
    public:
        AwaitPromiseCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(RefPtr<Inspector::Protocol::Runtime::RemoteObject>&& result, Optional<bool>& wasThrown, Optional<int>& savedResultIndex);
    };
    virtual void awaitPromise(const String& in_promiseObjectId, const bool* opt_in_returnByValue, const bool* opt_in_generatePreview, const bool* opt_in_saveResult, Ref<AwaitPromiseCallback>&& callback) = 0;
    virtual void callFunctionOn(ErrorString&, const String& in_objectId, const String& in_functionDeclaration, const JSON::Array* opt_in_arguments, const bool* opt_in_doNotPauseOnExceptionsAndMuteConsole, const bool* opt_in_returnByValue, const bool* opt_in_generatePreview, const bool* opt_in_emulateUserGesture, RefPtr<Inspector::Protocol::Runtime::RemoteObject>& out_result, Optional<bool>& opt_out_wasThrown) = 0;
    virtual void getPreview(ErrorString&, const String& in_objectId, RefPtr<Inspector::Protocol::Runtime::ObjectPreview>& out_preview) = 0;
    virtual void getProperties(ErrorString&, const String& in_objectId, const bool* opt_in_ownProperties, const int* opt_in_fetchStart, const int* opt_in_fetchCount, const bool* opt_in_generatePreview, RefPtr<JSON::ArrayOf<Inspector::Protocol::Runtime::PropertyDescriptor>>& out_properties, RefPtr<JSON::ArrayOf<Inspector::Protocol::Runtime::InternalPropertyDescriptor>>& opt_out_internalProperties) = 0;
    virtual void getDisplayableProperties(ErrorString&, const String& in_objectId, const int* opt_in_fetchStart, const int* opt_in_fetchCount, const bool* opt_in_generatePreview, RefPtr<JSON::ArrayOf<Inspector::Protocol::Runtime::PropertyDescriptor>>& out_properties, RefPtr<JSON::ArrayOf<Inspector::Protocol::Runtime::InternalPropertyDescriptor>>& opt_out_internalProperties) = 0;
    virtual void getCollectionEntries(ErrorString&, const String& in_objectId, const String* opt_in_objectGroup, const int* opt_in_fetchStart, const int* opt_in_fetchCount, RefPtr<JSON::ArrayOf<Inspector::Protocol::Runtime::CollectionEntry>>& out_entries) = 0;
    virtual void saveResult(ErrorString&, const JSON::Object& in_value, const int* opt_in_contextId, Optional<int>& opt_out_savedResultIndex) = 0;
    virtual void setSavedResultAlias(ErrorString&, const String* opt_in_alias) = 0;
    virtual void releaseObject(ErrorString&, const String& in_objectId) = 0;
    virtual void releaseObjectGroup(ErrorString&, const String& in_objectGroup) = 0;
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void getRuntimeTypesForVariablesAtOffsets(ErrorString&, const JSON::Array& in_locations, RefPtr<JSON::ArrayOf<Inspector::Protocol::Runtime::TypeDescription>>& out_types) = 0;
    virtual void enableTypeProfiler(ErrorString&) = 0;
    virtual void disableTypeProfiler(ErrorString&) = 0;
    virtual void enableControlFlowProfiler(ErrorString&) = 0;
    virtual void disableControlFlowProfiler(ErrorString&) = 0;
    virtual void getBasicBlocks(ErrorString&, const String& in_sourceID, RefPtr<JSON::ArrayOf<Inspector::Protocol::Runtime::BasicBlock>>& out_basicBlocks) = 0;
protected:
    virtual ~RuntimeBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE ScriptProfilerBackendDispatcherHandler {
public:
    virtual void startTracking(ErrorString&, const bool* opt_in_includeSamples) = 0;
    virtual void stopTracking(ErrorString&) = 0;
protected:
    virtual ~ScriptProfilerBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE ServiceWorkerBackendDispatcherHandler {
public:
    virtual void getInitializationInfo(ErrorString&, RefPtr<Inspector::Protocol::ServiceWorker::Configuration>& out_info) = 0;
protected:
    virtual ~ServiceWorkerBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE TargetBackendDispatcherHandler {
public:
    virtual void setPauseOnStart(ErrorString&, bool in_pauseOnStart) = 0;
    virtual void resume(ErrorString&, const String& in_targetId) = 0;
    virtual void sendMessageToTarget(ErrorString&, const String& in_targetId, const String& in_message) = 0;
protected:
    virtual ~TargetBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE TimelineBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void start(ErrorString&, const int* opt_in_maxCallStackDepth) = 0;
    virtual void stop(ErrorString&) = 0;
    virtual void setAutoCaptureEnabled(ErrorString&, bool in_enabled) = 0;
    virtual void setInstruments(ErrorString&, const JSON::Array& in_instruments) = 0;
protected:
    virtual ~TimelineBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE WorkerBackendDispatcherHandler {
public:
    virtual void enable(ErrorString&) = 0;
    virtual void disable(ErrorString&) = 0;
    virtual void initialized(ErrorString&, const String& in_workerId) = 0;
    virtual void sendMessageToWorker(ErrorString&, const String& in_workerId, const String& in_message) = 0;
protected:
    virtual ~WorkerBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE AnimationBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<AnimationBackendDispatcher> create(BackendDispatcher&, AnimationBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void requestEffectTarget(long requestId, RefPtr<JSON::Object>&& parameters);
    void resolveAnimation(long requestId, RefPtr<JSON::Object>&& parameters);
    void startTracking(long requestId, RefPtr<JSON::Object>&& parameters);
    void stopTracking(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateAnimationBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateAnimationBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    AnimationBackendDispatcher(BackendDispatcher&, AnimationBackendDispatcherHandler*);
    AnimationBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE ApplicationCacheBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<ApplicationCacheBackendDispatcher> create(BackendDispatcher&, ApplicationCacheBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void getFramesWithManifests(long requestId, RefPtr<JSON::Object>&& parameters);
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void getManifestForFrame(long requestId, RefPtr<JSON::Object>&& parameters);
    void getApplicationCacheForFrame(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateApplicationCacheBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateApplicationCacheBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    ApplicationCacheBackendDispatcher(BackendDispatcher&, ApplicationCacheBackendDispatcherHandler*);
    ApplicationCacheBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE AuditBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<AuditBackendDispatcher> create(BackendDispatcher&, AuditBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void setup(long requestId, RefPtr<JSON::Object>&& parameters);
    void run(long requestId, RefPtr<JSON::Object>&& parameters);
    void teardown(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateAuditBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateAuditBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    AuditBackendDispatcher(BackendDispatcher&, AuditBackendDispatcherHandler*);
    AuditBackendDispatcherHandler* m_agent { nullptr };
};

#if ENABLE(RESOURCE_USAGE)
class JS_EXPORT_PRIVATE CPUProfilerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<CPUProfilerBackendDispatcher> create(BackendDispatcher&, CPUProfilerBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void startTracking(long requestId, RefPtr<JSON::Object>&& parameters);
    void stopTracking(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateCPUProfilerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateCPUProfilerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    CPUProfilerBackendDispatcher(BackendDispatcher&, CPUProfilerBackendDispatcherHandler*);
    CPUProfilerBackendDispatcherHandler* m_agent { nullptr };
};
#endif // ENABLE(RESOURCE_USAGE)

class JS_EXPORT_PRIVATE CSSBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<CSSBackendDispatcher> create(BackendDispatcher&, CSSBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void getMatchedStylesForNode(long requestId, RefPtr<JSON::Object>&& parameters);
    void getInlineStylesForNode(long requestId, RefPtr<JSON::Object>&& parameters);
    void getComputedStyleForNode(long requestId, RefPtr<JSON::Object>&& parameters);
    void getAllStyleSheets(long requestId, RefPtr<JSON::Object>&& parameters);
    void getStyleSheet(long requestId, RefPtr<JSON::Object>&& parameters);
    void getStyleSheetText(long requestId, RefPtr<JSON::Object>&& parameters);
    void setStyleSheetText(long requestId, RefPtr<JSON::Object>&& parameters);
    void setStyleText(long requestId, RefPtr<JSON::Object>&& parameters);
    void setRuleSelector(long requestId, RefPtr<JSON::Object>&& parameters);
    void createStyleSheet(long requestId, RefPtr<JSON::Object>&& parameters);
    void addRule(long requestId, RefPtr<JSON::Object>&& parameters);
    void getSupportedCSSProperties(long requestId, RefPtr<JSON::Object>&& parameters);
    void getSupportedSystemFontFamilyNames(long requestId, RefPtr<JSON::Object>&& parameters);
    void forcePseudoState(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateCSSBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateCSSBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    CSSBackendDispatcher(BackendDispatcher&, CSSBackendDispatcherHandler*);
    CSSBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE CanvasBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<CanvasBackendDispatcher> create(BackendDispatcher&, CanvasBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void requestNode(long requestId, RefPtr<JSON::Object>&& parameters);
    void requestContent(long requestId, RefPtr<JSON::Object>&& parameters);
    void requestClientNodes(long requestId, RefPtr<JSON::Object>&& parameters);
    void resolveContext(long requestId, RefPtr<JSON::Object>&& parameters);
    void setRecordingAutoCaptureFrameCount(long requestId, RefPtr<JSON::Object>&& parameters);
    void startRecording(long requestId, RefPtr<JSON::Object>&& parameters);
    void stopRecording(long requestId, RefPtr<JSON::Object>&& parameters);
    void requestShaderSource(long requestId, RefPtr<JSON::Object>&& parameters);
    void updateShader(long requestId, RefPtr<JSON::Object>&& parameters);
    void setShaderProgramDisabled(long requestId, RefPtr<JSON::Object>&& parameters);
    void setShaderProgramHighlighted(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateCanvasBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateCanvasBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    CanvasBackendDispatcher(BackendDispatcher&, CanvasBackendDispatcherHandler*);
    CanvasBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE ConsoleBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<ConsoleBackendDispatcher> create(BackendDispatcher&, ConsoleBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void clearMessages(long requestId, RefPtr<JSON::Object>&& parameters);
    void getLoggingChannels(long requestId, RefPtr<JSON::Object>&& parameters);
    void setLoggingChannelLevel(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateConsoleBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateConsoleBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    ConsoleBackendDispatcher(BackendDispatcher&, ConsoleBackendDispatcherHandler*);
    ConsoleBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE DOMBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DOMBackendDispatcher> create(BackendDispatcher&, DOMBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void getDocument(long requestId, RefPtr<JSON::Object>&& parameters);
    void requestChildNodes(long requestId, RefPtr<JSON::Object>&& parameters);
    void querySelector(long requestId, RefPtr<JSON::Object>&& parameters);
    void querySelectorAll(long requestId, RefPtr<JSON::Object>&& parameters);
    void setNodeName(long requestId, RefPtr<JSON::Object>&& parameters);
    void setNodeValue(long requestId, RefPtr<JSON::Object>&& parameters);
    void removeNode(long requestId, RefPtr<JSON::Object>&& parameters);
    void setAttributeValue(long requestId, RefPtr<JSON::Object>&& parameters);
    void setAttributesAsText(long requestId, RefPtr<JSON::Object>&& parameters);
    void removeAttribute(long requestId, RefPtr<JSON::Object>&& parameters);
    void getSupportedEventNames(long requestId, RefPtr<JSON::Object>&& parameters);
    void getDataBindingsForNode(long requestId, RefPtr<JSON::Object>&& parameters);
    void getAssociatedDataForNode(long requestId, RefPtr<JSON::Object>&& parameters);
    void getEventListenersForNode(long requestId, RefPtr<JSON::Object>&& parameters);
    void setEventListenerDisabled(long requestId, RefPtr<JSON::Object>&& parameters);
    void setBreakpointForEventListener(long requestId, RefPtr<JSON::Object>&& parameters);
    void removeBreakpointForEventListener(long requestId, RefPtr<JSON::Object>&& parameters);
    void getAccessibilityPropertiesForNode(long requestId, RefPtr<JSON::Object>&& parameters);
    void getOuterHTML(long requestId, RefPtr<JSON::Object>&& parameters);
    void setOuterHTML(long requestId, RefPtr<JSON::Object>&& parameters);
    void insertAdjacentHTML(long requestId, RefPtr<JSON::Object>&& parameters);
    void performSearch(long requestId, RefPtr<JSON::Object>&& parameters);
    void getSearchResults(long requestId, RefPtr<JSON::Object>&& parameters);
    void discardSearchResults(long requestId, RefPtr<JSON::Object>&& parameters);
    void requestNode(long requestId, RefPtr<JSON::Object>&& parameters);
    void setInspectModeEnabled(long requestId, RefPtr<JSON::Object>&& parameters);
    void highlightRect(long requestId, RefPtr<JSON::Object>&& parameters);
    void highlightQuad(long requestId, RefPtr<JSON::Object>&& parameters);
    void highlightSelector(long requestId, RefPtr<JSON::Object>&& parameters);
    void highlightNode(long requestId, RefPtr<JSON::Object>&& parameters);
    void highlightNodeList(long requestId, RefPtr<JSON::Object>&& parameters);
    void hideHighlight(long requestId, RefPtr<JSON::Object>&& parameters);
    void highlightFrame(long requestId, RefPtr<JSON::Object>&& parameters);
    void pushNodeByPathToFrontend(long requestId, RefPtr<JSON::Object>&& parameters);
    void resolveNode(long requestId, RefPtr<JSON::Object>&& parameters);
    void getAttributes(long requestId, RefPtr<JSON::Object>&& parameters);
    void moveTo(long requestId, RefPtr<JSON::Object>&& parameters);
    void undo(long requestId, RefPtr<JSON::Object>&& parameters);
    void redo(long requestId, RefPtr<JSON::Object>&& parameters);
    void markUndoableState(long requestId, RefPtr<JSON::Object>&& parameters);
    void focus(long requestId, RefPtr<JSON::Object>&& parameters);
    void setInspectedNode(long requestId, RefPtr<JSON::Object>&& parameters);
    void setAllowEditingUserAgentShadowTrees(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDOMBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDOMBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    DOMBackendDispatcher(BackendDispatcher&, DOMBackendDispatcherHandler*);
    DOMBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE DOMDebuggerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DOMDebuggerBackendDispatcher> create(BackendDispatcher&, DOMDebuggerBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void setDOMBreakpoint(long requestId, RefPtr<JSON::Object>&& parameters);
    void removeDOMBreakpoint(long requestId, RefPtr<JSON::Object>&& parameters);
    void setEventBreakpoint(long requestId, RefPtr<JSON::Object>&& parameters);
    void removeEventBreakpoint(long requestId, RefPtr<JSON::Object>&& parameters);
    void setURLBreakpoint(long requestId, RefPtr<JSON::Object>&& parameters);
    void removeURLBreakpoint(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDOMDebuggerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDOMDebuggerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    DOMDebuggerBackendDispatcher(BackendDispatcher&, DOMDebuggerBackendDispatcherHandler*);
    DOMDebuggerBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE DOMStorageBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DOMStorageBackendDispatcher> create(BackendDispatcher&, DOMStorageBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void getDOMStorageItems(long requestId, RefPtr<JSON::Object>&& parameters);
    void setDOMStorageItem(long requestId, RefPtr<JSON::Object>&& parameters);
    void removeDOMStorageItem(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDOMStorageBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDOMStorageBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    DOMStorageBackendDispatcher(BackendDispatcher&, DOMStorageBackendDispatcherHandler*);
    DOMStorageBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE DatabaseBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DatabaseBackendDispatcher> create(BackendDispatcher&, DatabaseBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void getDatabaseTableNames(long requestId, RefPtr<JSON::Object>&& parameters);
    void executeSQL(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDatabaseBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDatabaseBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    DatabaseBackendDispatcher(BackendDispatcher&, DatabaseBackendDispatcherHandler*);
    DatabaseBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE DebuggerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DebuggerBackendDispatcher> create(BackendDispatcher&, DebuggerBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void setAsyncStackTraceDepth(long requestId, RefPtr<JSON::Object>&& parameters);
    void setBreakpointsActive(long requestId, RefPtr<JSON::Object>&& parameters);
    void setBreakpointByUrl(long requestId, RefPtr<JSON::Object>&& parameters);
    void setBreakpoint(long requestId, RefPtr<JSON::Object>&& parameters);
    void removeBreakpoint(long requestId, RefPtr<JSON::Object>&& parameters);
    void continueUntilNextRunLoop(long requestId, RefPtr<JSON::Object>&& parameters);
    void continueToLocation(long requestId, RefPtr<JSON::Object>&& parameters);
    void stepOver(long requestId, RefPtr<JSON::Object>&& parameters);
    void stepInto(long requestId, RefPtr<JSON::Object>&& parameters);
    void stepOut(long requestId, RefPtr<JSON::Object>&& parameters);
    void pause(long requestId, RefPtr<JSON::Object>&& parameters);
    void resume(long requestId, RefPtr<JSON::Object>&& parameters);
    void searchInContent(long requestId, RefPtr<JSON::Object>&& parameters);
    void getScriptSource(long requestId, RefPtr<JSON::Object>&& parameters);
    void getFunctionDetails(long requestId, RefPtr<JSON::Object>&& parameters);
    void setPauseOnExceptions(long requestId, RefPtr<JSON::Object>&& parameters);
    void setPauseOnAssertions(long requestId, RefPtr<JSON::Object>&& parameters);
    void setPauseOnMicrotasks(long requestId, RefPtr<JSON::Object>&& parameters);
    void setPauseForInternalScripts(long requestId, RefPtr<JSON::Object>&& parameters);
    void evaluateOnCallFrame(long requestId, RefPtr<JSON::Object>&& parameters);
    void setShouldBlackboxURL(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDebuggerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDebuggerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    DebuggerBackendDispatcher(BackendDispatcher&, DebuggerBackendDispatcherHandler*);
    DebuggerBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE HeapBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<HeapBackendDispatcher> create(BackendDispatcher&, HeapBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void gc(long requestId, RefPtr<JSON::Object>&& parameters);
    void snapshot(long requestId, RefPtr<JSON::Object>&& parameters);
    void startTracking(long requestId, RefPtr<JSON::Object>&& parameters);
    void stopTracking(long requestId, RefPtr<JSON::Object>&& parameters);
    void getPreview(long requestId, RefPtr<JSON::Object>&& parameters);
    void getRemoteObject(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateHeapBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateHeapBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    HeapBackendDispatcher(BackendDispatcher&, HeapBackendDispatcherHandler*);
    HeapBackendDispatcherHandler* m_agent { nullptr };
};

#if ENABLE(INDEXED_DATABASE)
class JS_EXPORT_PRIVATE IndexedDBBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<IndexedDBBackendDispatcher> create(BackendDispatcher&, IndexedDBBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void requestDatabaseNames(long requestId, RefPtr<JSON::Object>&& parameters);
    void requestDatabase(long requestId, RefPtr<JSON::Object>&& parameters);
    void requestData(long requestId, RefPtr<JSON::Object>&& parameters);
    void clearObjectStore(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateIndexedDBBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateIndexedDBBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    IndexedDBBackendDispatcher(BackendDispatcher&, IndexedDBBackendDispatcherHandler*);
    IndexedDBBackendDispatcherHandler* m_agent { nullptr };
};
#endif // ENABLE(INDEXED_DATABASE)

class JS_EXPORT_PRIVATE InspectorBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<InspectorBackendDispatcher> create(BackendDispatcher&, InspectorBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void initialized(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateInspectorBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateInspectorBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    InspectorBackendDispatcher(BackendDispatcher&, InspectorBackendDispatcherHandler*);
    InspectorBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE LayerTreeBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<LayerTreeBackendDispatcher> create(BackendDispatcher&, LayerTreeBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void layersForNode(long requestId, RefPtr<JSON::Object>&& parameters);
    void reasonsForCompositingLayer(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateLayerTreeBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateLayerTreeBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    LayerTreeBackendDispatcher(BackendDispatcher&, LayerTreeBackendDispatcherHandler*);
    LayerTreeBackendDispatcherHandler* m_agent { nullptr };
};

#if ENABLE(RESOURCE_USAGE)
class JS_EXPORT_PRIVATE MemoryBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<MemoryBackendDispatcher> create(BackendDispatcher&, MemoryBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void startTracking(long requestId, RefPtr<JSON::Object>&& parameters);
    void stopTracking(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateMemoryBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateMemoryBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    MemoryBackendDispatcher(BackendDispatcher&, MemoryBackendDispatcherHandler*);
    MemoryBackendDispatcherHandler* m_agent { nullptr };
};
#endif // ENABLE(RESOURCE_USAGE)

class JS_EXPORT_PRIVATE NetworkBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<NetworkBackendDispatcher> create(BackendDispatcher&, NetworkBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void setExtraHTTPHeaders(long requestId, RefPtr<JSON::Object>&& parameters);
    void getResponseBody(long requestId, RefPtr<JSON::Object>&& parameters);
    void setResourceCachingDisabled(long requestId, RefPtr<JSON::Object>&& parameters);
    void loadResource(long requestId, RefPtr<JSON::Object>&& parameters);
    void getSerializedCertificate(long requestId, RefPtr<JSON::Object>&& parameters);
    void resolveWebSocket(long requestId, RefPtr<JSON::Object>&& parameters);
    void setInterceptionEnabled(long requestId, RefPtr<JSON::Object>&& parameters);
    void addInterception(long requestId, RefPtr<JSON::Object>&& parameters);
    void removeInterception(long requestId, RefPtr<JSON::Object>&& parameters);
    void interceptContinue(long requestId, RefPtr<JSON::Object>&& parameters);
    void interceptWithResponse(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateNetworkBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateNetworkBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    NetworkBackendDispatcher(BackendDispatcher&, NetworkBackendDispatcherHandler*);
    NetworkBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE PageBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<PageBackendDispatcher> create(BackendDispatcher&, PageBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void reload(long requestId, RefPtr<JSON::Object>&& parameters);
    void navigate(long requestId, RefPtr<JSON::Object>&& parameters);
    void overrideUserAgent(long requestId, RefPtr<JSON::Object>&& parameters);
    void overrideSetting(long requestId, RefPtr<JSON::Object>&& parameters);
    void getCookies(long requestId, RefPtr<JSON::Object>&& parameters);
    void deleteCookie(long requestId, RefPtr<JSON::Object>&& parameters);
    void getResourceTree(long requestId, RefPtr<JSON::Object>&& parameters);
    void getResourceContent(long requestId, RefPtr<JSON::Object>&& parameters);
    void setBootstrapScript(long requestId, RefPtr<JSON::Object>&& parameters);
    void searchInResource(long requestId, RefPtr<JSON::Object>&& parameters);
    void searchInResources(long requestId, RefPtr<JSON::Object>&& parameters);
    void setShowRulers(long requestId, RefPtr<JSON::Object>&& parameters);
    void setShowPaintRects(long requestId, RefPtr<JSON::Object>&& parameters);
    void setEmulatedMedia(long requestId, RefPtr<JSON::Object>&& parameters);
    void setForcedAppearance(long requestId, RefPtr<JSON::Object>&& parameters);
    void snapshotNode(long requestId, RefPtr<JSON::Object>&& parameters);
    void snapshotRect(long requestId, RefPtr<JSON::Object>&& parameters);
    void archive(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternatePageBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternatePageBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    PageBackendDispatcher(BackendDispatcher&, PageBackendDispatcherHandler*);
    PageBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE RuntimeBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<RuntimeBackendDispatcher> create(BackendDispatcher&, RuntimeBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void parse(long requestId, RefPtr<JSON::Object>&& parameters);
    void evaluate(long requestId, RefPtr<JSON::Object>&& parameters);
    void awaitPromise(long requestId, RefPtr<JSON::Object>&& parameters);
    void callFunctionOn(long requestId, RefPtr<JSON::Object>&& parameters);
    void getPreview(long requestId, RefPtr<JSON::Object>&& parameters);
    void getProperties(long requestId, RefPtr<JSON::Object>&& parameters);
    void getDisplayableProperties(long requestId, RefPtr<JSON::Object>&& parameters);
    void getCollectionEntries(long requestId, RefPtr<JSON::Object>&& parameters);
    void saveResult(long requestId, RefPtr<JSON::Object>&& parameters);
    void setSavedResultAlias(long requestId, RefPtr<JSON::Object>&& parameters);
    void releaseObject(long requestId, RefPtr<JSON::Object>&& parameters);
    void releaseObjectGroup(long requestId, RefPtr<JSON::Object>&& parameters);
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void getRuntimeTypesForVariablesAtOffsets(long requestId, RefPtr<JSON::Object>&& parameters);
    void enableTypeProfiler(long requestId, RefPtr<JSON::Object>&& parameters);
    void disableTypeProfiler(long requestId, RefPtr<JSON::Object>&& parameters);
    void enableControlFlowProfiler(long requestId, RefPtr<JSON::Object>&& parameters);
    void disableControlFlowProfiler(long requestId, RefPtr<JSON::Object>&& parameters);
    void getBasicBlocks(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateRuntimeBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateRuntimeBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    RuntimeBackendDispatcher(BackendDispatcher&, RuntimeBackendDispatcherHandler*);
    RuntimeBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE ScriptProfilerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<ScriptProfilerBackendDispatcher> create(BackendDispatcher&, ScriptProfilerBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void startTracking(long requestId, RefPtr<JSON::Object>&& parameters);
    void stopTracking(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateScriptProfilerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateScriptProfilerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    ScriptProfilerBackendDispatcher(BackendDispatcher&, ScriptProfilerBackendDispatcherHandler*);
    ScriptProfilerBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE ServiceWorkerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<ServiceWorkerBackendDispatcher> create(BackendDispatcher&, ServiceWorkerBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void getInitializationInfo(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateServiceWorkerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateServiceWorkerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    ServiceWorkerBackendDispatcher(BackendDispatcher&, ServiceWorkerBackendDispatcherHandler*);
    ServiceWorkerBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE TargetBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<TargetBackendDispatcher> create(BackendDispatcher&, TargetBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void setPauseOnStart(long requestId, RefPtr<JSON::Object>&& parameters);
    void resume(long requestId, RefPtr<JSON::Object>&& parameters);
    void sendMessageToTarget(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateTargetBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateTargetBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    TargetBackendDispatcher(BackendDispatcher&, TargetBackendDispatcherHandler*);
    TargetBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE TimelineBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<TimelineBackendDispatcher> create(BackendDispatcher&, TimelineBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void start(long requestId, RefPtr<JSON::Object>&& parameters);
    void stop(long requestId, RefPtr<JSON::Object>&& parameters);
    void setAutoCaptureEnabled(long requestId, RefPtr<JSON::Object>&& parameters);
    void setInstruments(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateTimelineBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateTimelineBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    TimelineBackendDispatcher(BackendDispatcher&, TimelineBackendDispatcherHandler*);
    TimelineBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE WorkerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<WorkerBackendDispatcher> create(BackendDispatcher&, WorkerBackendDispatcherHandler*);
    void dispatch(long requestId, const String& method, Ref<JSON::Object>&& message) override;
private:
    void enable(long requestId, RefPtr<JSON::Object>&& parameters);
    void disable(long requestId, RefPtr<JSON::Object>&& parameters);
    void initialized(long requestId, RefPtr<JSON::Object>&& parameters);
    void sendMessageToWorker(long requestId, RefPtr<JSON::Object>&& parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateWorkerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateWorkerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif
private:
    WorkerBackendDispatcher(BackendDispatcher&, WorkerBackendDispatcherHandler*);
    WorkerBackendDispatcherHandler* m_agent { nullptr };
};

} // namespace Inspector
