/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json
// by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#pragma once

#include "InspectorProtocolObjects.h"
#include <wtf/JSONValues.h>
#include <wtf/text/WTFString.h>

namespace Inspector {

class FrontendRouter;

class JS_EXPORT_PRIVATE AnimationFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    AnimationFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void animationCreated(RefPtr<Inspector::Protocol::Animation::Animation> animation);
    void effectChanged(const String& animationId, RefPtr<Inspector::Protocol::Animation::Effect> effect);
    void targetChanged(const String& animationId);
    void animationDestroyed(const String& animationId);
    void trackingStart(double timestamp);
    void trackingUpdate(double timestamp, RefPtr<Inspector::Protocol::Animation::TrackingUpdate> event);
    void trackingComplete(double timestamp);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE ApplicationCacheFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    ApplicationCacheFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void applicationCacheStatusUpdated(const String& frameId, const String& manifestURL, int status);
    void networkStateUpdated(bool isNowOnline);
private:
    FrontendRouter& m_frontendRouter;
};

#if ENABLE(RESOURCE_USAGE)
class JS_EXPORT_PRIVATE CPUProfilerFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    CPUProfilerFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void trackingStart(double timestamp);
    void trackingUpdate(RefPtr<Inspector::Protocol::CPUProfiler::Event> event);
    void trackingComplete(double timestamp);
private:
    FrontendRouter& m_frontendRouter;
};
#endif // ENABLE(RESOURCE_USAGE)

class JS_EXPORT_PRIVATE CSSFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    CSSFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void mediaQueryResultChanged();
    void styleSheetChanged(const String& styleSheetId);
    void styleSheetAdded(RefPtr<Inspector::Protocol::CSS::CSSStyleSheetHeader> header);
    void styleSheetRemoved(const String& styleSheetId);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE CanvasFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    CanvasFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void canvasAdded(RefPtr<Inspector::Protocol::Canvas::Canvas> canvas);
    void canvasRemoved(const String& canvasId);
    void canvasMemoryChanged(const String& canvasId, double memoryCost);
    void extensionEnabled(const String& canvasId, const String& extension);
    void clientNodesChanged(const String& canvasId);
        // Named after parameter 'initiator' while generating command/event recordingStarted.
        enum class Initiator {
            Frontend = 176,
            Console = 177,
            AutoCapture = 178,
        }; // enum class Initiator
    void recordingStarted(const String& canvasId, Inspector::Protocol::Recording::Initiator initiator);
    void recordingProgress(const String& canvasId, RefPtr<JSON::ArrayOf<Inspector::Protocol::Recording::Frame>> frames, int bufferUsed);
    void recordingFinished(const String& canvasId, RefPtr<Inspector::Protocol::Recording::Recording> recording);
    void programCreated(RefPtr<Inspector::Protocol::Canvas::ShaderProgram> shaderProgram);
    void programDeleted(const String& programId);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE ConsoleFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    ConsoleFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void messageAdded(RefPtr<Inspector::Protocol::Console::ConsoleMessage> message);
    void messageRepeatCountUpdated(int count);
    void messagesCleared();
    void heapSnapshot(double timestamp, const String& snapshotData, const String* title);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE DOMFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    DOMFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void documentUpdated();
    void inspect(int nodeId);
    void setChildNodes(int parentId, RefPtr<JSON::ArrayOf<Inspector::Protocol::DOM::Node>> nodes);
    void attributeModified(int nodeId, const String& name, const String& value);
    void attributeRemoved(int nodeId, const String& name);
    void inlineStyleInvalidated(RefPtr<JSON::ArrayOf<int>> nodeIds);
    void characterDataModified(int nodeId, const String& characterData);
    void childNodeCountUpdated(int nodeId, int childNodeCount);
    void childNodeInserted(int parentNodeId, int previousNodeId, RefPtr<Inspector::Protocol::DOM::Node> node);
    void childNodeRemoved(int parentNodeId, int nodeId);
    void shadowRootPushed(int hostId, RefPtr<Inspector::Protocol::DOM::Node> root);
    void shadowRootPopped(int hostId, int rootId);
        // Named after parameter 'customElementState' while generating command/event customElementStateChanged.
        enum class CustomElementState {
            Builtin = 88,
            Custom = 89,
            Waiting = 90,
            Failed = 91,
        }; // enum class CustomElementState
    void customElementStateChanged(int nodeId, Inspector::Protocol::DOM::CustomElementState customElementState);
    void pseudoElementAdded(int parentId, RefPtr<Inspector::Protocol::DOM::Node> pseudoElement);
    void pseudoElementRemoved(int parentId, int pseudoElementId);
    void didAddEventListener(int nodeId);
    void willRemoveEventListener(int nodeId);
    void didFireEvent(int nodeId, const String& eventName, double timestamp, RefPtr<JSON::Object> data);
    void powerEfficientPlaybackStateChanged(int nodeId, double timestamp, bool isPowerEfficient);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE DOMStorageFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    DOMStorageFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void domStorageItemsCleared(RefPtr<Inspector::Protocol::DOMStorage::StorageId> storageId);
    void domStorageItemRemoved(RefPtr<Inspector::Protocol::DOMStorage::StorageId> storageId, const String& key);
    void domStorageItemAdded(RefPtr<Inspector::Protocol::DOMStorage::StorageId> storageId, const String& key, const String& newValue);
    void domStorageItemUpdated(RefPtr<Inspector::Protocol::DOMStorage::StorageId> storageId, const String& key, const String& oldValue, const String& newValue);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE DatabaseFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    DatabaseFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void addDatabase(RefPtr<Inspector::Protocol::Database::Database> database);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE DebuggerFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    DebuggerFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void globalObjectCleared();
    void scriptParsed(const String& scriptId, const String& url, int startLine, int startColumn, int endLine, int endColumn, const bool* isContentScript, const String* sourceURL, const String* sourceMapURL, const bool* module);
    void scriptFailedToParse(const String& url, const String& scriptSource, int startLine, int errorLine, const String& errorMessage);
    void breakpointResolved(const String& breakpointId, RefPtr<Inspector::Protocol::Debugger::Location> location);
        // Named after parameter 'reason' while generating command/event paused.
        enum class Reason {
            XHR = 146,
            Fetch = 147,
            DOM = 230,
            AnimationFrame = 231,
            Interval = 232,
            Listener = 233,
            Timeout = 234,
            Exception = 235,
            Assert = 81,
            CSPViolation = 236,
            DebuggerStatement = 237,
            Breakpoint = 238,
            PauseOnNextStatement = 239,
            Microtask = 200,
            BlackboxedScript = 240,
            Other = 64,
        }; // enum class Reason
    void paused(RefPtr<JSON::ArrayOf<Inspector::Protocol::Debugger::CallFrame>> callFrames, Reason reason, RefPtr<JSON::Object> data, RefPtr<Inspector::Protocol::Console::StackTrace> asyncStackTrace);
    void resumed();
    void didSampleProbe(RefPtr<Inspector::Protocol::Debugger::ProbeSample> sample);
    void playBreakpointActionSound(int breakpointActionId);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE HeapFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    HeapFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void garbageCollected(RefPtr<Inspector::Protocol::Heap::GarbageCollection> collection);
    void trackingStart(double timestamp, const String& snapshotData);
    void trackingComplete(double timestamp, const String& snapshotData);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE InspectorFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    InspectorFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void evaluateForTestInFrontend(const String& script);
    void inspect(RefPtr<Inspector::Protocol::Runtime::RemoteObject> object, RefPtr<JSON::Object> hints);
    void activateExtraDomains(RefPtr<JSON::ArrayOf<String>> domains);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE LayerTreeFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    LayerTreeFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void layerTreeDidChange();
private:
    FrontendRouter& m_frontendRouter;
};

#if ENABLE(RESOURCE_USAGE)
class JS_EXPORT_PRIVATE MemoryFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    MemoryFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
        // Named after parameter 'severity' while generating command/event memoryPressure.
        enum class Severity {
            Critical = 241,
            NonCritical = 242,
        }; // enum class Severity
    void memoryPressure(double timestamp, Severity severity);
    void trackingStart(double timestamp);
    void trackingUpdate(RefPtr<Inspector::Protocol::Memory::Event> event);
    void trackingComplete(double timestamp);
private:
    FrontendRouter& m_frontendRouter;
};
#endif // ENABLE(RESOURCE_USAGE)

class JS_EXPORT_PRIVATE NetworkFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    NetworkFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
        // Named after parameter 'type' while generating command/event requestWillBeSent.
        enum class Type {
            Document = 141,
            StyleSheet = 142,
            Image = 143,
            Font = 144,
            Script = 145,
            XHR = 146,
            Fetch = 147,
            Ping = 148,
            Beacon = 149,
            WebSocket = 150,
            Other = 151,
        }; // enum class Type
    void requestWillBeSent(const String& requestId, const String& frameId, const String& loaderId, const String& documentURL, RefPtr<Inspector::Protocol::Network::Request> request, double timestamp, double walltime, RefPtr<Inspector::Protocol::Network::Initiator> initiator, RefPtr<Inspector::Protocol::Network::Response> redirectResponse, Inspector::Protocol::Page::ResourceType* type, const String* targetId);
    void responseReceived(const String& requestId, const String& frameId, const String& loaderId, double timestamp, Inspector::Protocol::Page::ResourceType type, RefPtr<Inspector::Protocol::Network::Response> response);
    void dataReceived(const String& requestId, double timestamp, int dataLength, int encodedDataLength);
    void loadingFinished(const String& requestId, double timestamp, const String* sourceMapURL, RefPtr<Inspector::Protocol::Network::Metrics> metrics);
    void loadingFailed(const String& requestId, double timestamp, const String& errorText, const bool* canceled);
    void requestServedFromMemoryCache(const String& requestId, const String& frameId, const String& loaderId, const String& documentURL, double timestamp, RefPtr<Inspector::Protocol::Network::Initiator> initiator, RefPtr<Inspector::Protocol::Network::CachedResource> resource);
    void responseIntercepted(const String& requestId, RefPtr<Inspector::Protocol::Network::Response> response);
    void webSocketWillSendHandshakeRequest(const String& requestId, double timestamp, double walltime, RefPtr<Inspector::Protocol::Network::WebSocketRequest> request);
    void webSocketHandshakeResponseReceived(const String& requestId, double timestamp, RefPtr<Inspector::Protocol::Network::WebSocketResponse> response);
    void webSocketCreated(const String& requestId, const String& url);
    void webSocketClosed(const String& requestId, double timestamp);
    void webSocketFrameReceived(const String& requestId, double timestamp, RefPtr<Inspector::Protocol::Network::WebSocketFrame> response);
    void webSocketFrameError(const String& requestId, double timestamp, const String& errorMessage);
    void webSocketFrameSent(const String& requestId, double timestamp, RefPtr<Inspector::Protocol::Network::WebSocketFrame> response);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE PageFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    PageFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void domContentEventFired(double timestamp);
    void loadEventFired(double timestamp);
    void frameNavigated(RefPtr<Inspector::Protocol::Page::Frame> frame);
    void frameDetached(const String& frameId);
    void frameStartedLoading(const String& frameId);
    void frameStoppedLoading(const String& frameId);
    void frameScheduledNavigation(const String& frameId, double delay);
    void frameClearedScheduledNavigation(const String& frameId);
        // Named after parameter 'appearance' while generating command/event defaultAppearanceDidChange.
        enum class Appearance {
            Light = 171,
            Dark = 172,
        }; // enum class Appearance
    void defaultAppearanceDidChange(Inspector::Protocol::Page::Appearance appearance);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE RuntimeFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    RuntimeFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void executionContextCreated(RefPtr<Inspector::Protocol::Runtime::ExecutionContextDescription> context);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE ScriptProfilerFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    ScriptProfilerFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void trackingStart(double timestamp);
    void trackingUpdate(RefPtr<Inspector::Protocol::ScriptProfiler::Event> event);
    void trackingComplete(double timestamp, RefPtr<Inspector::Protocol::ScriptProfiler::Samples> samples);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE TargetFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    TargetFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void targetCreated(RefPtr<Inspector::Protocol::Target::TargetInfo> targetInfo);
    void targetDestroyed(const String& targetId);
    void didCommitProvisionalTarget(const String& oldTargetId, const String& newTargetId);
    void dispatchMessageFromTarget(const String& targetId, const String& message);
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE TimelineFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    TimelineFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void eventRecorded(RefPtr<Inspector::Protocol::Timeline::TimelineEvent> record);
    void recordingStarted(double startTime);
    void recordingStopped(double endTime);
    void autoCaptureStarted();
private:
    FrontendRouter& m_frontendRouter;
};

class JS_EXPORT_PRIVATE WorkerFrontendDispatcher {
    WTF_MAKE_FAST_ALLOCATED;
public:
    WorkerFrontendDispatcher(FrontendRouter& frontendRouter) : m_frontendRouter(frontendRouter) { }
    void workerCreated(const String& workerId, const String& url);
    void workerTerminated(const String& workerId);
    void dispatchMessageFromWorker(const String& workerId, const String& message);
private:
    FrontendRouter& m_frontendRouter;
};

} // namespace Inspector
