/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSANGLEInstancedArrays.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsANGLEInstancedArraysPrototypeFunctionDrawArraysInstancedANGLE(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsANGLEInstancedArraysPrototypeFunctionDrawElementsInstancedANGLE(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsANGLEInstancedArraysPrototypeFunctionVertexAttribDivisorANGLE(JSC::JSGlobalObject*, JSC::CallFrame*);

class JSANGLEInstancedArraysPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSANGLEInstancedArraysPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSANGLEInstancedArraysPrototype* ptr = new (NotNull, JSC::allocateCell<JSANGLEInstancedArraysPrototype>(vm.heap)) JSANGLEInstancedArraysPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSANGLEInstancedArraysPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSANGLEInstancedArraysPrototype, JSANGLEInstancedArraysPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSANGLEInstancedArraysPrototypeTableValues[] =
{
    { "drawArraysInstancedANGLE", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsANGLEInstancedArraysPrototypeFunctionDrawArraysInstancedANGLE), (intptr_t) (4) } },
    { "drawElementsInstancedANGLE", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsANGLEInstancedArraysPrototypeFunctionDrawElementsInstancedANGLE), (intptr_t) (5) } },
    { "vertexAttribDivisorANGLE", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsANGLEInstancedArraysPrototypeFunctionVertexAttribDivisorANGLE), (intptr_t) (2) } },
    { "VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x88FE) } },
};

const ClassInfo JSANGLEInstancedArraysPrototype::s_info = { "ANGLEInstancedArraysPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSANGLEInstancedArraysPrototype) };

void JSANGLEInstancedArraysPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSANGLEInstancedArrays::info(), JSANGLEInstancedArraysPrototypeTableValues, *this);
}

const ClassInfo JSANGLEInstancedArrays::s_info = { "ANGLEInstancedArrays", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSANGLEInstancedArrays) };

JSANGLEInstancedArrays::JSANGLEInstancedArrays(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ANGLEInstancedArrays>&& impl)
    : JSDOMWrapper<ANGLEInstancedArrays>(structure, globalObject, WTFMove(impl))
{
}

void JSANGLEInstancedArrays::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, ANGLEInstancedArrays>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSANGLEInstancedArrays::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSANGLEInstancedArraysPrototype::create(vm, &globalObject, JSANGLEInstancedArraysPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSANGLEInstancedArrays::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSANGLEInstancedArrays>(vm, globalObject);
}

void JSANGLEInstancedArrays::destroy(JSC::JSCell* cell)
{
    JSANGLEInstancedArrays* thisObject = static_cast<JSANGLEInstancedArrays*>(cell);
    thisObject->JSANGLEInstancedArrays::~JSANGLEInstancedArrays();
}

template<> inline JSANGLEInstancedArrays* IDLOperation<JSANGLEInstancedArrays>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSANGLEInstancedArrays*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSC::EncodedJSValue jsANGLEInstancedArraysPrototypeFunctionDrawArraysInstancedANGLEBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSANGLEInstancedArrays>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto first = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto count = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto primcount = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.drawArraysInstancedANGLE(WTFMove(mode), WTFMove(first), WTFMove(count), WTFMove(primcount));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsANGLEInstancedArraysPrototypeFunctionDrawArraysInstancedANGLE(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSANGLEInstancedArrays>::call<jsANGLEInstancedArraysPrototypeFunctionDrawArraysInstancedANGLEBody>(*lexicalGlobalObject, *callFrame, "drawArraysInstancedANGLE");
}

static inline JSC::EncodedJSValue jsANGLEInstancedArraysPrototypeFunctionDrawElementsInstancedANGLEBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSANGLEInstancedArrays>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mode = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto count = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto offset = convert<IDLLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto primcount = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.drawElementsInstancedANGLE(WTFMove(mode), WTFMove(count), WTFMove(type), WTFMove(offset), WTFMove(primcount));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsANGLEInstancedArraysPrototypeFunctionDrawElementsInstancedANGLE(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSANGLEInstancedArrays>::call<jsANGLEInstancedArraysPrototypeFunctionDrawElementsInstancedANGLEBody>(*lexicalGlobalObject, *callFrame, "drawElementsInstancedANGLE");
}

static inline JSC::EncodedJSValue jsANGLEInstancedArraysPrototypeFunctionVertexAttribDivisorANGLEBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSANGLEInstancedArrays>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto divisor = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.vertexAttribDivisorANGLE(WTFMove(index), WTFMove(divisor));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsANGLEInstancedArraysPrototypeFunctionVertexAttribDivisorANGLE(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSANGLEInstancedArrays>::call<jsANGLEInstancedArraysPrototypeFunctionVertexAttribDivisorANGLEBody>(*lexicalGlobalObject, *callFrame, "vertexAttribDivisorANGLE");
}

void JSANGLEInstancedArrays::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSANGLEInstancedArrays*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSANGLEInstancedArraysOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsANGLEInstancedArrays = jsCast<JSANGLEInstancedArrays*>(handle.slot()->asCell());
    WebGLRenderingContextBase* root = WTF::getPtr(jsANGLEInstancedArrays->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from ANGLEInstancedArrays";
    return visitor.containsOpaqueRoot(root);
}

void JSANGLEInstancedArraysOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsANGLEInstancedArrays = static_cast<JSANGLEInstancedArrays*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsANGLEInstancedArrays->wrapped(), jsANGLEInstancedArrays);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ANGLEInstancedArrays@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20ANGLEInstancedArraysE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ANGLEInstancedArrays>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7ANGLEInstancedArrays@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore20ANGLEInstancedArraysE[2];
#endif

    // If this fails ANGLEInstancedArrays does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<ANGLEInstancedArrays>::value, "ANGLEInstancedArrays is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // ANGLEInstancedArrays has subclasses. If ANGLEInstancedArrays has subclasses that get passed
    // to toJS() we currently require ANGLEInstancedArrays you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<ANGLEInstancedArrays>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ANGLEInstancedArrays& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ANGLEInstancedArrays* JSANGLEInstancedArrays::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSANGLEInstancedArrays*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
