/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(PAYMENT_REQUEST)

#include "JSAddressErrors.h"

#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(PAYMENT_REQUEST)

template<> AddressErrors convertDictionary<AddressErrors>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    AddressErrors result;
    JSValue addressLineValue;
    if (isNullOrUndefined)
        addressLineValue = jsUndefined();
    else {
        addressLineValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "addressLine"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!addressLineValue.isUndefined()) {
        result.addressLine = convert<IDLDOMString>(lexicalGlobalObject, addressLineValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue cityValue;
    if (isNullOrUndefined)
        cityValue = jsUndefined();
    else {
        cityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "city"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cityValue.isUndefined()) {
        result.city = convert<IDLDOMString>(lexicalGlobalObject, cityValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue countryValue;
    if (isNullOrUndefined)
        countryValue = jsUndefined();
    else {
        countryValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "country"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!countryValue.isUndefined()) {
        result.country = convert<IDLDOMString>(lexicalGlobalObject, countryValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue dependentLocalityValue;
    if (isNullOrUndefined)
        dependentLocalityValue = jsUndefined();
    else {
        dependentLocalityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "dependentLocality"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dependentLocalityValue.isUndefined()) {
        result.dependentLocality = convert<IDLDOMString>(lexicalGlobalObject, dependentLocalityValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue languageCodeValue;
    if (isNullOrUndefined)
        languageCodeValue = jsUndefined();
    else {
        languageCodeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "languageCode"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!languageCodeValue.isUndefined()) {
        result.languageCode = convert<IDLDOMString>(lexicalGlobalObject, languageCodeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue organizationValue;
    if (isNullOrUndefined)
        organizationValue = jsUndefined();
    else {
        organizationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "organization"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!organizationValue.isUndefined()) {
        result.organization = convert<IDLDOMString>(lexicalGlobalObject, organizationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue phoneValue;
    if (isNullOrUndefined)
        phoneValue = jsUndefined();
    else {
        phoneValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "phone"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!phoneValue.isUndefined()) {
        result.phone = convert<IDLDOMString>(lexicalGlobalObject, phoneValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue postalCodeValue;
    if (isNullOrUndefined)
        postalCodeValue = jsUndefined();
    else {
        postalCodeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "postalCode"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!postalCodeValue.isUndefined()) {
        result.postalCode = convert<IDLDOMString>(lexicalGlobalObject, postalCodeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue recipientValue;
    if (isNullOrUndefined)
        recipientValue = jsUndefined();
    else {
        recipientValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "recipient"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!recipientValue.isUndefined()) {
        result.recipient = convert<IDLDOMString>(lexicalGlobalObject, recipientValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue regionValue;
    if (isNullOrUndefined)
        regionValue = jsUndefined();
    else {
        regionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "region"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!regionValue.isUndefined()) {
        result.region = convert<IDLDOMString>(lexicalGlobalObject, regionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue regionCodeValue;
    if (isNullOrUndefined)
        regionCodeValue = jsUndefined();
    else {
        regionCodeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "regionCode"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!regionCodeValue.isUndefined()) {
        result.regionCode = convert<IDLDOMString>(lexicalGlobalObject, regionCodeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue sortingCodeValue;
    if (isNullOrUndefined)
        sortingCodeValue = jsUndefined();
    else {
        sortingCodeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sortingCode"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sortingCodeValue.isUndefined()) {
        result.sortingCode = convert<IDLDOMString>(lexicalGlobalObject, sortingCodeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(PAYMENT_REQUEST)
