/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAnimationEvent.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> AnimationEvent::Init convertDictionary<AnimationEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    AnimationEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue animationNameValue;
    if (isNullOrUndefined)
        animationNameValue = jsUndefined();
    else {
        animationNameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "animationName"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!animationNameValue.isUndefined()) {
        result.animationName = convert<IDLDOMString>(lexicalGlobalObject, animationNameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.animationName = emptyString();
    JSValue elapsedTimeValue;
    if (isNullOrUndefined)
        elapsedTimeValue = jsUndefined();
    else {
        elapsedTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "elapsedTime"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!elapsedTimeValue.isUndefined()) {
        result.elapsedTime = convert<IDLDouble>(lexicalGlobalObject, elapsedTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.elapsedTime = 0.0;
    JSValue pseudoElementValue;
    if (isNullOrUndefined)
        pseudoElementValue = jsUndefined();
    else {
        pseudoElementValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pseudoElement"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pseudoElementValue.isUndefined()) {
        result.pseudoElement = convert<IDLDOMString>(lexicalGlobalObject, pseudoElementValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.pseudoElement = emptyString();
    return result;
}

// Attributes

JSC::EncodedJSValue jsAnimationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAnimationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAnimationEventAnimationName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAnimationEventElapsedTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAnimationEventPseudoElement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSAnimationEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAnimationEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAnimationEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSAnimationEventPrototype>(vm.heap)) JSAnimationEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAnimationEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAnimationEventPrototype, JSAnimationEventPrototype::Base);

using JSAnimationEventConstructor = JSDOMConstructor<JSAnimationEvent>;

template<> EncodedJSValue JSC_HOST_CALL JSAnimationEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSAnimationEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto animationEventInitDict = convert<IDLDictionary<AnimationEvent::Init>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = AnimationEvent::create(WTFMove(type), WTFMove(animationEventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<AnimationEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSAnimationEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSAnimationEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAnimationEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("AnimationEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSAnimationEventConstructor::s_info = { "AnimationEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAnimationEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnimationEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAnimationEventConstructor) } },
    { "animationName", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnimationEventAnimationName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "elapsedTime", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnimationEventElapsedTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "pseudoElement", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnimationEventPseudoElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSAnimationEventPrototype::s_info = { "AnimationEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationEventPrototype) };

void JSAnimationEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAnimationEvent::info(), JSAnimationEventPrototypeTableValues, *this);
}

const ClassInfo JSAnimationEvent::s_info = { "AnimationEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationEvent) };

JSAnimationEvent::JSAnimationEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AnimationEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

void JSAnimationEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, AnimationEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSAnimationEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSAnimationEventPrototype::create(vm, &globalObject, JSAnimationEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject)));
}

JSObject* JSAnimationEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAnimationEvent>(vm, globalObject);
}

JSValue JSAnimationEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAnimationEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSAnimationEvent* IDLAttribute<JSAnimationEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSAnimationEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsAnimationEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAnimationEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAnimationEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSAnimationEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAnimationEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsAnimationEventAnimationNameGetter(JSGlobalObject& lexicalGlobalObject, JSAnimationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.animationName());
    return result;
}

EncodedJSValue jsAnimationEventAnimationName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAnimationEvent>::get<jsAnimationEventAnimationNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "animationName");
}

static inline JSValue jsAnimationEventElapsedTimeGetter(JSGlobalObject& lexicalGlobalObject, JSAnimationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.elapsedTime());
    return result;
}

EncodedJSValue jsAnimationEventElapsedTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAnimationEvent>::get<jsAnimationEventElapsedTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "elapsedTime");
}

static inline JSValue jsAnimationEventPseudoElementGetter(JSGlobalObject& lexicalGlobalObject, JSAnimationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.pseudoElement());
    return result;
}

EncodedJSValue jsAnimationEventPseudoElement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAnimationEvent>::get<jsAnimationEventPseudoElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pseudoElement");
}

void JSAnimationEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAnimationEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AnimationEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14AnimationEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AnimationEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7AnimationEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14AnimationEventE[2];
#endif

    // If this fails AnimationEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<AnimationEvent>::value, "AnimationEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // AnimationEvent has subclasses. If AnimationEvent has subclasses that get passed
    // to toJS() we currently require AnimationEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<AnimationEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AnimationEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
