/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAnimationTimeline.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsAnimationTimelineConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAnimationTimelineConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAnimationTimelineCurrentTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSAnimationTimelinePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAnimationTimelinePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAnimationTimelinePrototype* ptr = new (NotNull, JSC::allocateCell<JSAnimationTimelinePrototype>(vm.heap)) JSAnimationTimelinePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAnimationTimelinePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAnimationTimelinePrototype, JSAnimationTimelinePrototype::Base);

using JSAnimationTimelineConstructor = JSDOMConstructorNotConstructable<JSAnimationTimeline>;

template<> JSValue JSAnimationTimelineConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSAnimationTimelineConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAnimationTimeline::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("AnimationTimeline"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSAnimationTimelineConstructor::s_info = { "AnimationTimeline", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationTimelineConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAnimationTimelinePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnimationTimelineConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAnimationTimelineConstructor) } },
    { "currentTime", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAnimationTimelineCurrentTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSAnimationTimelinePrototype::s_info = { "AnimationTimelinePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationTimelinePrototype) };

void JSAnimationTimelinePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAnimationTimeline::info(), JSAnimationTimelinePrototypeTableValues, *this);
}

const ClassInfo JSAnimationTimeline::s_info = { "AnimationTimeline", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAnimationTimeline) };

JSAnimationTimeline::JSAnimationTimeline(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AnimationTimeline>&& impl)
    : JSDOMWrapper<AnimationTimeline>(structure, globalObject, WTFMove(impl))
{
}

void JSAnimationTimeline::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, AnimationTimeline>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSAnimationTimeline::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSAnimationTimelinePrototype::create(vm, &globalObject, JSAnimationTimelinePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSAnimationTimeline::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAnimationTimeline>(vm, globalObject);
}

JSValue JSAnimationTimeline::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAnimationTimelineConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSAnimationTimeline::destroy(JSC::JSCell* cell)
{
    JSAnimationTimeline* thisObject = static_cast<JSAnimationTimeline*>(cell);
    thisObject->JSAnimationTimeline::~JSAnimationTimeline();
}

template<> inline JSAnimationTimeline* IDLAttribute<JSAnimationTimeline>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSAnimationTimeline*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsAnimationTimelineConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAnimationTimelinePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAnimationTimeline::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSAnimationTimelineConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAnimationTimelinePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsAnimationTimelineCurrentTimeGetter(JSGlobalObject& lexicalGlobalObject, JSAnimationTimeline& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDouble>>(lexicalGlobalObject, throwScope, impl.bindingsCurrentTime());
    return result;
}

EncodedJSValue jsAnimationTimelineCurrentTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAnimationTimeline>::get<jsAnimationTimelineCurrentTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "currentTime");
}

void JSAnimationTimeline::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAnimationTimeline*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSAnimationTimelineOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSAnimationTimelineOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAnimationTimeline = static_cast<JSAnimationTimeline*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsAnimationTimeline->wrapped(), jsAnimationTimeline);
}

AnimationTimeline* JSAnimationTimeline::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAnimationTimeline*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
