/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioBufferSourceNode.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSAudioBuffer.h"
#include "JSAudioParam.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsAudioBufferSourceNodePrototypeFunctionStart(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioBufferSourceNodePrototypeFunctionStop(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsAudioBufferSourceNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioBufferSourceNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioBufferSourceNodeBuffer(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioBufferSourceNodeBuffer(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioBufferSourceNodePlaybackState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioBufferSourceNodeGain(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioBufferSourceNodePlaybackRate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioBufferSourceNodeLoop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioBufferSourceNodeLoop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioBufferSourceNodeLoopStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioBufferSourceNodeLoopStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioBufferSourceNodeLoopEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioBufferSourceNodeLoopEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioBufferSourceNodeOnended(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioBufferSourceNodeOnended(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSAudioBufferSourceNodePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAudioBufferSourceNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioBufferSourceNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioBufferSourceNodePrototype>(vm.heap)) JSAudioBufferSourceNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioBufferSourceNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioBufferSourceNodePrototype, JSAudioBufferSourceNodePrototype::Base);

using JSAudioBufferSourceNodeConstructor = JSDOMConstructorNotConstructable<JSAudioBufferSourceNode>;

/* Hash table for constructor */

static const HashTableValue JSAudioBufferSourceNodeConstructorTableValues[] =
{
    { "UNSCHEDULED_STATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SCHEDULED_STATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "PLAYING_STATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "FINISHED_STATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

static_assert(AudioBufferSourceNode::UNSCHEDULED_STATE == 0, "UNSCHEDULED_STATE in AudioBufferSourceNode does not match value from IDL");
static_assert(AudioBufferSourceNode::SCHEDULED_STATE == 1, "SCHEDULED_STATE in AudioBufferSourceNode does not match value from IDL");
static_assert(AudioBufferSourceNode::PLAYING_STATE == 2, "PLAYING_STATE in AudioBufferSourceNode does not match value from IDL");
static_assert(AudioBufferSourceNode::FINISHED_STATE == 3, "FINISHED_STATE in AudioBufferSourceNode does not match value from IDL");

template<> JSValue JSAudioBufferSourceNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSAudioBufferSourceNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAudioBufferSourceNode::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("AudioBufferSourceNode"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSAudioBufferSourceNode::info(), JSAudioBufferSourceNodeConstructorTableValues, *this);
}

template<> const ClassInfo JSAudioBufferSourceNodeConstructor::s_info = { "AudioBufferSourceNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioBufferSourceNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAudioBufferSourceNodePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioBufferSourceNodeConstructor) } },
    { "buffer", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodeBuffer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioBufferSourceNodeBuffer) } },
    { "playbackState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodePlaybackState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "gain", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodeGain), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "playbackRate", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodePlaybackRate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "loop", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodeLoop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioBufferSourceNodeLoop) } },
    { "loopStart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodeLoopStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioBufferSourceNodeLoopStart) } },
    { "loopEnd", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodeLoopEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioBufferSourceNodeLoopEnd) } },
    { "onended", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioBufferSourceNodeOnended), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioBufferSourceNodeOnended) } },
    { "start", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioBufferSourceNodePrototypeFunctionStart), (intptr_t) (0) } },
    { "stop", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioBufferSourceNodePrototypeFunctionStop), (intptr_t) (0) } },
    { "UNSCHEDULED_STATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "SCHEDULED_STATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "PLAYING_STATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "FINISHED_STATE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
};

const ClassInfo JSAudioBufferSourceNodePrototype::s_info = { "AudioBufferSourceNodePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioBufferSourceNodePrototype) };

void JSAudioBufferSourceNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioBufferSourceNode::info(), JSAudioBufferSourceNodePrototypeTableValues, *this);
}

const ClassInfo JSAudioBufferSourceNode::s_info = { "AudioBufferSourceNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioBufferSourceNode) };

JSAudioBufferSourceNode::JSAudioBufferSourceNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioBufferSourceNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

void JSAudioBufferSourceNode::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, AudioBufferSourceNode>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSAudioBufferSourceNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSAudioBufferSourceNodePrototype::create(vm, &globalObject, JSAudioBufferSourceNodePrototype::createStructure(vm, &globalObject, JSAudioNode::prototype(vm, globalObject)));
}

JSObject* JSAudioBufferSourceNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAudioBufferSourceNode>(vm, globalObject);
}

JSValue JSAudioBufferSourceNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioBufferSourceNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSAudioBufferSourceNode* IDLAttribute<JSAudioBufferSourceNode>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSAudioBufferSourceNode*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSAudioBufferSourceNode* IDLOperation<JSAudioBufferSourceNode>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSAudioBufferSourceNode*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsAudioBufferSourceNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioBufferSourceNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAudioBufferSourceNode::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSAudioBufferSourceNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioBufferSourceNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsAudioBufferSourceNodeBufferGetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<AudioBuffer>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.buffer());
    return result;
}

EncodedJSValue jsAudioBufferSourceNodeBuffer(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioBufferSourceNode>::get<jsAudioBufferSourceNodeBufferGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "buffer");
}

static inline bool setJSAudioBufferSourceNodeBufferSetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLInterface<AudioBuffer>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "AudioBufferSourceNode", "buffer", "AudioBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBuffer(WTFMove(nativeValue));
    });
    return true;
}

bool setJSAudioBufferSourceNodeBuffer(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAudioBufferSourceNode>::set<setJSAudioBufferSourceNodeBufferSetter>(*lexicalGlobalObject, thisValue, encodedValue, "buffer");
}

static inline JSValue jsAudioBufferSourceNodePlaybackStateGetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.playbackState());
    return result;
}

EncodedJSValue jsAudioBufferSourceNodePlaybackState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioBufferSourceNode>::get<jsAudioBufferSourceNodePlaybackStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "playbackState");
}

static inline JSValue jsAudioBufferSourceNodeGainGetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.gain());
    return result;
}

EncodedJSValue jsAudioBufferSourceNodeGain(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioBufferSourceNode>::get<jsAudioBufferSourceNodeGainGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "gain");
}

static inline JSValue jsAudioBufferSourceNodePlaybackRateGetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.playbackRate());
    return result;
}

EncodedJSValue jsAudioBufferSourceNodePlaybackRate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioBufferSourceNode>::get<jsAudioBufferSourceNodePlaybackRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "playbackRate");
}

static inline JSValue jsAudioBufferSourceNodeLoopGetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.loop());
    return result;
}

EncodedJSValue jsAudioBufferSourceNodeLoop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioBufferSourceNode>::get<jsAudioBufferSourceNodeLoopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "loop");
}

static inline bool setJSAudioBufferSourceNodeLoopSetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLoop(WTFMove(nativeValue));
    });
    return true;
}

bool setJSAudioBufferSourceNodeLoop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAudioBufferSourceNode>::set<setJSAudioBufferSourceNodeLoopSetter>(*lexicalGlobalObject, thisValue, encodedValue, "loop");
}

static inline JSValue jsAudioBufferSourceNodeLoopStartGetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.loopStart());
    return result;
}

EncodedJSValue jsAudioBufferSourceNodeLoopStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioBufferSourceNode>::get<jsAudioBufferSourceNodeLoopStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "loopStart");
}

static inline bool setJSAudioBufferSourceNodeLoopStartSetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLoopStart(WTFMove(nativeValue));
    });
    return true;
}

bool setJSAudioBufferSourceNodeLoopStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAudioBufferSourceNode>::set<setJSAudioBufferSourceNodeLoopStartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "loopStart");
}

static inline JSValue jsAudioBufferSourceNodeLoopEndGetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.loopEnd());
    return result;
}

EncodedJSValue jsAudioBufferSourceNodeLoopEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioBufferSourceNode>::get<jsAudioBufferSourceNodeLoopEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "loopEnd");
}

static inline bool setJSAudioBufferSourceNodeLoopEndSetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLoopEnd(WTFMove(nativeValue));
    });
    return true;
}

bool setJSAudioBufferSourceNodeLoopEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAudioBufferSourceNode>::set<setJSAudioBufferSourceNodeLoopEndSetter>(*lexicalGlobalObject, thisValue, encodedValue, "loopEnd");
}

static inline JSValue jsAudioBufferSourceNodeOnendedGetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().endedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsAudioBufferSourceNodeOnended(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioBufferSourceNode>::get<jsAudioBufferSourceNodeOnendedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onended");
}

static inline bool setJSAudioBufferSourceNodeOnendedSetter(JSGlobalObject& lexicalGlobalObject, JSAudioBufferSourceNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().endedEvent, value);
    return true;
}

bool setJSAudioBufferSourceNodeOnended(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAudioBufferSourceNode>::set<setJSAudioBufferSourceNodeOnendedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onended");
}

static inline JSC::EncodedJSValue jsAudioBufferSourceNodePrototypeFunctionStartBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioBufferSourceNode>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto when = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto grainOffset = callFrame->argument(1).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto grainDuration = callFrame->argument(2).isUndefined() ? Optional<Converter<IDLUnrestrictedDouble>::ReturnType>() : Optional<Converter<IDLUnrestrictedDouble>::ReturnType>(convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.startLater(WTFMove(when), WTFMove(grainOffset), WTFMove(grainDuration)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioBufferSourceNodePrototypeFunctionStart(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioBufferSourceNode>::call<jsAudioBufferSourceNodePrototypeFunctionStartBody>(*lexicalGlobalObject, *callFrame, "start");
}

static inline JSC::EncodedJSValue jsAudioBufferSourceNodePrototypeFunctionStopBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioBufferSourceNode>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto when = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.stopLater(WTFMove(when)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioBufferSourceNodePrototypeFunctionStop(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioBufferSourceNode>::call<jsAudioBufferSourceNodePrototypeFunctionStopBody>(*lexicalGlobalObject, *callFrame, "stop");
}

void JSAudioBufferSourceNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAudioBufferSourceNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSAudioBufferSourceNodeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsAudioBufferSourceNode = jsCast<JSAudioBufferSourceNode*>(handle.slot()->asCell());
    if (jsAudioBufferSourceNode->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsAudioBufferSourceNode->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSAudioBufferSourceNodeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioBufferSourceNode = static_cast<JSAudioBufferSourceNode*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsAudioBufferSourceNode->wrapped(), jsAudioBufferSourceNode);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioBufferSourceNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21AudioBufferSourceNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AudioBufferSourceNode>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7AudioBufferSourceNode@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore21AudioBufferSourceNodeE[2];
#endif

    // If this fails AudioBufferSourceNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<AudioBufferSourceNode>::value, "AudioBufferSourceNode is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // AudioBufferSourceNode has subclasses. If AudioBufferSourceNode has subclasses that get passed
    // to toJS() we currently require AudioBufferSourceNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<AudioBufferSourceNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AudioBufferSourceNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
