/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioDestinationNode.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsAudioDestinationNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioDestinationNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioDestinationNodeMaxChannelCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSAudioDestinationNodePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAudioDestinationNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioDestinationNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioDestinationNodePrototype>(vm.heap)) JSAudioDestinationNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioDestinationNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioDestinationNodePrototype, JSAudioDestinationNodePrototype::Base);

using JSAudioDestinationNodeConstructor = JSDOMConstructorNotConstructable<JSAudioDestinationNode>;

template<> JSValue JSAudioDestinationNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSAudioDestinationNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAudioDestinationNode::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("AudioDestinationNode"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSAudioDestinationNodeConstructor::s_info = { "AudioDestinationNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioDestinationNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAudioDestinationNodePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioDestinationNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioDestinationNodeConstructor) } },
    { "maxChannelCount", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioDestinationNodeMaxChannelCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSAudioDestinationNodePrototype::s_info = { "AudioDestinationNodePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioDestinationNodePrototype) };

void JSAudioDestinationNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioDestinationNode::info(), JSAudioDestinationNodePrototypeTableValues, *this);
}

const ClassInfo JSAudioDestinationNode::s_info = { "AudioDestinationNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioDestinationNode) };

JSAudioDestinationNode::JSAudioDestinationNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioDestinationNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

void JSAudioDestinationNode::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, AudioDestinationNode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSAudioDestinationNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSAudioDestinationNodePrototype::create(vm, &globalObject, JSAudioDestinationNodePrototype::createStructure(vm, &globalObject, JSAudioNode::prototype(vm, globalObject)));
}

JSObject* JSAudioDestinationNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAudioDestinationNode>(vm, globalObject);
}

JSValue JSAudioDestinationNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioDestinationNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSAudioDestinationNode* IDLAttribute<JSAudioDestinationNode>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSAudioDestinationNode*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsAudioDestinationNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioDestinationNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAudioDestinationNode::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSAudioDestinationNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioDestinationNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsAudioDestinationNodeMaxChannelCountGetter(JSGlobalObject& lexicalGlobalObject, JSAudioDestinationNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxChannelCount());
    return result;
}

EncodedJSValue jsAudioDestinationNodeMaxChannelCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioDestinationNode>::get<jsAudioDestinationNodeMaxChannelCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "maxChannelCount");
}

void JSAudioDestinationNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAudioDestinationNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AudioDestinationNode>&& impl)
{
    return createWrapper<AudioDestinationNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AudioDestinationNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
