/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSAudioTrack.h"

#include "ActiveDOMObject.h"
#include "Element.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "JSNodeCustom.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsAudioTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioTrackId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioTrackKind(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(MEDIA_SOURCE)
bool setJSAudioTrackKind(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsAudioTrackLabel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioTrackLanguage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(MEDIA_SOURCE)
bool setJSAudioTrackLanguage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsAudioTrackEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioTrackEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSAudioTrackPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAudioTrackPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioTrackPrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioTrackPrototype>(vm.heap)) JSAudioTrackPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioTrackPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioTrackPrototype, JSAudioTrackPrototype::Base);

using JSAudioTrackConstructor = JSDOMConstructorNotConstructable<JSAudioTrack>;

template<> JSValue JSAudioTrackConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSAudioTrackConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAudioTrack::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("AudioTrack"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSAudioTrackConstructor::s_info = { "AudioTrack", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioTrackConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAudioTrackPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioTrackConstructor) } },
    { "id", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(MEDIA_SOURCE)
    { "kind", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackKind), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioTrackKind) } },
#else
    { "kind", JSC::PropertyAttribute::ReadOnly | static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackKind), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#endif
    { "label", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackLabel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(MEDIA_SOURCE)
    { "language", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackLanguage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioTrackLanguage) } },
#else
    { "language", JSC::PropertyAttribute::ReadOnly | static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackLanguage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#endif
    { "enabled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackEnabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioTrackEnabled) } },
};

const ClassInfo JSAudioTrackPrototype::s_info = { "AudioTrackPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioTrackPrototype) };

void JSAudioTrackPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioTrack::info(), JSAudioTrackPrototypeTableValues, *this);
}

const ClassInfo JSAudioTrack::s_info = { "AudioTrack", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioTrack) };

JSAudioTrack::JSAudioTrack(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioTrack>&& impl)
    : JSDOMWrapper<AudioTrack>(structure, globalObject, WTFMove(impl))
{
}

void JSAudioTrack::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, AudioTrack>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSAudioTrack::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSAudioTrackPrototype::create(vm, &globalObject, JSAudioTrackPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSAudioTrack::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAudioTrack>(vm, globalObject);
}

JSValue JSAudioTrack::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioTrackConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSAudioTrack::destroy(JSC::JSCell* cell)
{
    JSAudioTrack* thisObject = static_cast<JSAudioTrack*>(cell);
    thisObject->JSAudioTrack::~JSAudioTrack();
}

template<> inline JSAudioTrack* IDLAttribute<JSAudioTrack>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSAudioTrack*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsAudioTrackConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioTrackPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAudioTrack::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSAudioTrackConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioTrackPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsAudioTrackIdGetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id());
    return result;
}

EncodedJSValue jsAudioTrackId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioTrack>::get<jsAudioTrackIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "id");
}

static inline JSValue jsAudioTrackKindGetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.kind());
    return result;
}

EncodedJSValue jsAudioTrackKind(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioTrack>::get<jsAudioTrackKindGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "kind");
}

#if ENABLE(MEDIA_SOURCE)
static inline bool setJSAudioTrackKindSetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrack& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setKind(WTFMove(nativeValue));
    });
    return true;
}

bool setJSAudioTrackKind(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAudioTrack>::set<setJSAudioTrackKindSetter>(*lexicalGlobalObject, thisValue, encodedValue, "kind");
}

#endif

static inline JSValue jsAudioTrackLabelGetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.label());
    return result;
}

EncodedJSValue jsAudioTrackLabel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioTrack>::get<jsAudioTrackLabelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "label");
}

static inline JSValue jsAudioTrackLanguageGetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.language());
    return result;
}

EncodedJSValue jsAudioTrackLanguage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioTrack>::get<jsAudioTrackLanguageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "language");
}

#if ENABLE(MEDIA_SOURCE)
static inline bool setJSAudioTrackLanguageSetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrack& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLanguage(WTFMove(nativeValue));
    });
    return true;
}

bool setJSAudioTrackLanguage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAudioTrack>::set<setJSAudioTrackLanguageSetter>(*lexicalGlobalObject, thisValue, encodedValue, "language");
}

#endif

static inline JSValue jsAudioTrackEnabledGetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrack& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.enabled());
    return result;
}

EncodedJSValue jsAudioTrackEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioTrack>::get<jsAudioTrackEnabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "enabled");
}

static inline bool setJSAudioTrackEnabledSetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrack& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setEnabled(WTFMove(nativeValue));
    });
    return true;
}

bool setJSAudioTrackEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAudioTrack>::set<setJSAudioTrackEnabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "enabled");
}

void JSAudioTrack::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSAudioTrack*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSAudioTrack::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSAudioTrack*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSAudioTrack::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAudioTrack*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSAudioTrackOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsAudioTrack = jsCast<JSAudioTrack*>(handle.slot()->asCell());
    Element* element = WTF::getPtr(jsAudioTrack->wrapped().element());
    if (!element)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from AudioTrackOwner";
    void* root = WebCore::root(element);
    return visitor.containsOpaqueRoot(root);
}

void JSAudioTrackOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioTrack = static_cast<JSAudioTrack*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsAudioTrack->wrapped(), jsAudioTrack);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioTrack@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10AudioTrackE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AudioTrack>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7AudioTrack@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore10AudioTrackE[2];
#endif

    // If this fails AudioTrack does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<AudioTrack>::value, "AudioTrack is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // AudioTrack has subclasses. If AudioTrack has subclasses that get passed
    // to toJS() we currently require AudioTrack you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<AudioTrack>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AudioTrack& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

AudioTrack* JSAudioTrack::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAudioTrack*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO_TRACK)
