/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSAudioTrackList.h"

#include "ActiveDOMObject.h"
#include "Element.h"
#include "EventNames.h"
#include "JSAudioTrack.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSNodeCustom.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/ArrayPrototype.h>
#include <JavaScriptCore/BuiltinNames.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/PropertyNameArray.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsAudioTrackListPrototypeFunctionItem(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioTrackListPrototypeFunctionGetTrackById(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsAudioTrackListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioTrackListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioTrackListLength(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAudioTrackListOnchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioTrackListOnchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioTrackListOnaddtrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioTrackListOnaddtrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioTrackListOnremovetrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAudioTrackListOnremovetrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSAudioTrackListPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAudioTrackListPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioTrackListPrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioTrackListPrototype>(vm.heap)) JSAudioTrackListPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioTrackListPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioTrackListPrototype, JSAudioTrackListPrototype::Base);

using JSAudioTrackListConstructor = JSDOMConstructorNotConstructable<JSAudioTrackList>;

template<> JSValue JSAudioTrackListConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSAudioTrackListConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAudioTrackList::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("AudioTrackList"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSAudioTrackListConstructor::s_info = { "AudioTrackList", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioTrackListConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAudioTrackListPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioTrackListConstructor) } },
    { "length", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackListLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onchange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackListOnchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioTrackListOnchange) } },
    { "onaddtrack", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackListOnaddtrack), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioTrackListOnaddtrack) } },
    { "onremovetrack", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioTrackListOnremovetrack), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioTrackListOnremovetrack) } },
    { "item", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioTrackListPrototypeFunctionItem), (intptr_t) (1) } },
    { "getTrackById", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsAudioTrackListPrototypeFunctionGetTrackById), (intptr_t) (1) } },
};

const ClassInfo JSAudioTrackListPrototype::s_info = { "AudioTrackListPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioTrackListPrototype) };

void JSAudioTrackListPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioTrackList::info(), JSAudioTrackListPrototypeTableValues, *this);
    putDirect(vm, vm.propertyNames->iteratorSymbol, globalObject()->arrayPrototype()->getDirect(vm, vm.propertyNames->builtinNames().valuesPrivateName()), static_cast<unsigned>(JSC::PropertyAttribute::DontEnum));
}

const ClassInfo JSAudioTrackList::s_info = { "AudioTrackList", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioTrackList) };

JSAudioTrackList::JSAudioTrackList(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioTrackList>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSAudioTrackList::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, AudioTrackList>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSAudioTrackList::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSAudioTrackListPrototype::create(vm, &globalObject, JSAudioTrackListPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSAudioTrackList::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAudioTrackList>(vm, globalObject);
}

JSValue JSAudioTrackList::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioTrackListConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSAudioTrackList::getOwnPropertySlot(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSAudioTrackList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (auto index = parseIndex(propertyName)) {
        if (index.value() < thisObject->wrapped().length()) {
            auto value = toJS<IDLInterface<AudioTrack>>(*lexicalGlobalObject, *thisObject->globalObject(), thisObject->wrapped().item(index.value()));
            slot.setValue(thisObject, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), value);
            return true;
        }
    }
    return JSObject::getOwnPropertySlot(object, lexicalGlobalObject, propertyName, slot);
}

bool JSAudioTrackList::getOwnPropertySlotByIndex(JSObject* object, JSGlobalObject* lexicalGlobalObject, unsigned index, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSAudioTrackList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (LIKELY(index <= MAX_ARRAY_INDEX)) {
        if (index < thisObject->wrapped().length()) {
            auto value = toJS<IDLInterface<AudioTrack>>(*lexicalGlobalObject, *thisObject->globalObject(), thisObject->wrapped().item(index));
            slot.setValue(thisObject, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), value);
            return true;
        }
    }
    return JSObject::getOwnPropertySlotByIndex(object, lexicalGlobalObject, index, slot);
}

void JSAudioTrackList::getOwnPropertyNames(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto* thisObject = jsCast<JSAudioTrackList*>(object);
    ASSERT_GC_OBJECT_INHERITS(object, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(vm, i));
    JSObject::getOwnPropertyNames(object, lexicalGlobalObject, propertyNames, mode);
}

template<> inline JSAudioTrackList* IDLAttribute<JSAudioTrackList>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSAudioTrackList*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSAudioTrackList* IDLOperation<JSAudioTrackList>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSAudioTrackList*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsAudioTrackListConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioTrackListPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAudioTrackList::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSAudioTrackListConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioTrackListPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsAudioTrackListLengthGetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrackList& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.length());
    return result;
}

EncodedJSValue jsAudioTrackListLength(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioTrackList>::get<jsAudioTrackListLengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "length");
}

static inline JSValue jsAudioTrackListOnchangeGetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrackList& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().changeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsAudioTrackListOnchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioTrackList>::get<jsAudioTrackListOnchangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onchange");
}

static inline bool setJSAudioTrackListOnchangeSetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrackList& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().changeEvent, value);
    return true;
}

bool setJSAudioTrackListOnchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAudioTrackList>::set<setJSAudioTrackListOnchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onchange");
}

static inline JSValue jsAudioTrackListOnaddtrackGetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrackList& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().addtrackEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsAudioTrackListOnaddtrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioTrackList>::get<jsAudioTrackListOnaddtrackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onaddtrack");
}

static inline bool setJSAudioTrackListOnaddtrackSetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrackList& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().addtrackEvent, value);
    return true;
}

bool setJSAudioTrackListOnaddtrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAudioTrackList>::set<setJSAudioTrackListOnaddtrackSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onaddtrack");
}

static inline JSValue jsAudioTrackListOnremovetrackGetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrackList& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().removetrackEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsAudioTrackListOnremovetrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAudioTrackList>::get<jsAudioTrackListOnremovetrackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onremovetrack");
}

static inline bool setJSAudioTrackListOnremovetrackSetter(JSGlobalObject& lexicalGlobalObject, JSAudioTrackList& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().removetrackEvent, value);
    return true;
}

bool setJSAudioTrackListOnremovetrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSAudioTrackList>::set<setJSAudioTrackListOnremovetrackSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onremovetrack");
}

static inline JSC::EncodedJSValue jsAudioTrackListPrototypeFunctionItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioTrackList>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<AudioTrack>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.item(WTFMove(index))));
}

EncodedJSValue JSC_HOST_CALL jsAudioTrackListPrototypeFunctionItem(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioTrackList>::call<jsAudioTrackListPrototypeFunctionItemBody>(*lexicalGlobalObject, *callFrame, "item");
}

static inline JSC::EncodedJSValue jsAudioTrackListPrototypeFunctionGetTrackByIdBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioTrackList>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto id = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<AudioTrack>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getTrackById(WTFMove(id))));
}

EncodedJSValue JSC_HOST_CALL jsAudioTrackListPrototypeFunctionGetTrackById(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSAudioTrackList>::call<jsAudioTrackListPrototypeFunctionGetTrackByIdBody>(*lexicalGlobalObject, *callFrame, "getTrackById");
}

void JSAudioTrackList::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSAudioTrackList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSAudioTrackList::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSAudioTrackList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSAudioTrackList::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAudioTrackList*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSAudioTrackListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsAudioTrackList = jsCast<JSAudioTrackList*>(handle.slot()->asCell());
    if (jsAudioTrackList->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    Element* element = WTF::getPtr(jsAudioTrackList->wrapped().element());
    if (!element)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from AudioTrackListOwner";
    void* root = WebCore::root(element);
    return visitor.containsOpaqueRoot(root);
}

void JSAudioTrackListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioTrackList = static_cast<JSAudioTrackList*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsAudioTrackList->wrapped(), jsAudioTrackList);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioTrackList@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14AudioTrackListE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AudioTrackList>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7AudioTrackList@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14AudioTrackListE[2];
#endif

    // If this fails AudioTrackList does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<AudioTrackList>::value, "AudioTrackList is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // AudioTrackList has subclasses. If AudioTrackList has subclasses that get passed
    // to toJS() we currently require AudioTrackList you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<AudioTrackList>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AudioTrackList& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

AudioTrackList* JSAudioTrackList::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAudioTrackList*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO_TRACK)
