/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUTHN)

#include "JSAuthenticationExtensionsClientInputs.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUTHN)

template<> AuthenticationExtensionsClientInputs convertDictionary<AuthenticationExtensionsClientInputs>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    AuthenticationExtensionsClientInputs result;
    JSValue appidValue;
    if (isNullOrUndefined)
        appidValue = jsUndefined();
    else {
        appidValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "appid"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!appidValue.isUndefined()) {
        result.appid = convert<IDLUSVString>(lexicalGlobalObject, appidValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue googleLegacyAppidSupportValue;
    if (isNullOrUndefined)
        googleLegacyAppidSupportValue = jsUndefined();
    else {
        googleLegacyAppidSupportValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "googleLegacyAppidSupport"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!googleLegacyAppidSupportValue.isUndefined()) {
        result.googleLegacyAppidSupport = convert<IDLBoolean>(lexicalGlobalObject, googleLegacyAppidSupportValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.googleLegacyAppidSupport = true;
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUTHN)
