/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUTHN)

#include "JSAuthenticatorAssertionResponse.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsAuthenticatorAssertionResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSAuthenticatorAssertionResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAuthenticatorAssertionResponseAuthenticatorData(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAuthenticatorAssertionResponseSignature(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsAuthenticatorAssertionResponseUserHandle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSAuthenticatorAssertionResponsePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAuthenticatorAssertionResponsePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAuthenticatorAssertionResponsePrototype* ptr = new (NotNull, JSC::allocateCell<JSAuthenticatorAssertionResponsePrototype>(vm.heap)) JSAuthenticatorAssertionResponsePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAuthenticatorAssertionResponsePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAuthenticatorAssertionResponsePrototype, JSAuthenticatorAssertionResponsePrototype::Base);

using JSAuthenticatorAssertionResponseConstructor = JSDOMConstructorNotConstructable<JSAuthenticatorAssertionResponse>;

template<> JSValue JSAuthenticatorAssertionResponseConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAuthenticatorResponse::getConstructor(vm, &globalObject);
}

template<> void JSAuthenticatorAssertionResponseConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAuthenticatorAssertionResponse::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("AuthenticatorAssertionResponse"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSAuthenticatorAssertionResponseConstructor::s_info = { "AuthenticatorAssertionResponse", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAuthenticatorAssertionResponseConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAuthenticatorAssertionResponsePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAuthenticatorAssertionResponseConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAuthenticatorAssertionResponseConstructor) } },
    { "authenticatorData", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAuthenticatorAssertionResponseAuthenticatorData), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "signature", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAuthenticatorAssertionResponseSignature), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "userHandle", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAuthenticatorAssertionResponseUserHandle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSAuthenticatorAssertionResponsePrototype::s_info = { "AuthenticatorAssertionResponsePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAuthenticatorAssertionResponsePrototype) };

void JSAuthenticatorAssertionResponsePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAuthenticatorAssertionResponse::info(), JSAuthenticatorAssertionResponsePrototypeTableValues, *this);
}

const ClassInfo JSAuthenticatorAssertionResponse::s_info = { "AuthenticatorAssertionResponse", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAuthenticatorAssertionResponse) };

JSAuthenticatorAssertionResponse::JSAuthenticatorAssertionResponse(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AuthenticatorAssertionResponse>&& impl)
    : JSAuthenticatorResponse(structure, globalObject, WTFMove(impl))
{
}

void JSAuthenticatorAssertionResponse::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, AuthenticatorAssertionResponse>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSAuthenticatorAssertionResponse::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSAuthenticatorAssertionResponsePrototype::create(vm, &globalObject, JSAuthenticatorAssertionResponsePrototype::createStructure(vm, &globalObject, JSAuthenticatorResponse::prototype(vm, globalObject)));
}

JSObject* JSAuthenticatorAssertionResponse::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAuthenticatorAssertionResponse>(vm, globalObject);
}

JSValue JSAuthenticatorAssertionResponse::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAuthenticatorAssertionResponseConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSAuthenticatorAssertionResponse* IDLAttribute<JSAuthenticatorAssertionResponse>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSAuthenticatorAssertionResponse*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsAuthenticatorAssertionResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAuthenticatorAssertionResponsePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAuthenticatorAssertionResponse::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSAuthenticatorAssertionResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAuthenticatorAssertionResponsePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsAuthenticatorAssertionResponseAuthenticatorDataGetter(JSGlobalObject& lexicalGlobalObject, JSAuthenticatorAssertionResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLArrayBuffer>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.authenticatorData());
    return result;
}

EncodedJSValue jsAuthenticatorAssertionResponseAuthenticatorData(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAuthenticatorAssertionResponse>::get<jsAuthenticatorAssertionResponseAuthenticatorDataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "authenticatorData");
}

static inline JSValue jsAuthenticatorAssertionResponseSignatureGetter(JSGlobalObject& lexicalGlobalObject, JSAuthenticatorAssertionResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLArrayBuffer>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.signature());
    return result;
}

EncodedJSValue jsAuthenticatorAssertionResponseSignature(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAuthenticatorAssertionResponse>::get<jsAuthenticatorAssertionResponseSignatureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "signature");
}

static inline JSValue jsAuthenticatorAssertionResponseUserHandleGetter(JSGlobalObject& lexicalGlobalObject, JSAuthenticatorAssertionResponse& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLArrayBuffer>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.userHandle());
    return result;
}

EncodedJSValue jsAuthenticatorAssertionResponseUserHandle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSAuthenticatorAssertionResponse>::get<jsAuthenticatorAssertionResponseUserHandleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "userHandle");
}

void JSAuthenticatorAssertionResponse::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAuthenticatorAssertionResponse*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}

#endif // ENABLE(WEB_AUTHN)
