/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUTHN)

#include "JSAuthenticatorTransport.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(AuthenticatorTransport enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("usb"),
        MAKE_STATIC_STRING_IMPL("nfc"),
        MAKE_STATIC_STRING_IMPL("ble"),
        MAKE_STATIC_STRING_IMPL("internal"),
    };
    static_assert(static_cast<size_t>(AuthenticatorTransport::Usb) == 0, "AuthenticatorTransport::Usb is not 0 as expected");
    static_assert(static_cast<size_t>(AuthenticatorTransport::Nfc) == 1, "AuthenticatorTransport::Nfc is not 1 as expected");
    static_assert(static_cast<size_t>(AuthenticatorTransport::Ble) == 2, "AuthenticatorTransport::Ble is not 2 as expected");
    static_assert(static_cast<size_t>(AuthenticatorTransport::Internal) == 3, "AuthenticatorTransport::Internal is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, AuthenticatorTransport enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<AuthenticatorTransport> parseEnumeration<AuthenticatorTransport>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "usb")
        return AuthenticatorTransport::Usb;
    if (stringValue == "nfc")
        return AuthenticatorTransport::Nfc;
    if (stringValue == "ble")
        return AuthenticatorTransport::Ble;
    if (stringValue == "internal")
        return AuthenticatorTransport::Internal;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<AuthenticatorTransport>()
{
    return "\"usb\", \"nfc\", \"ble\", \"internal\"";
}

} // namespace WebCore

#endif // ENABLE(WEB_AUTHN)
