/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSRule.h"

#include "ActiveDOMObject.h"
#include "JSCSSRule.h"
#include "JSCSSStyleSheet.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsCSSRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCSSRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCSSRuleType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCSSRuleCssText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCSSRuleCssText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCSSRuleParentStyleSheet(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCSSRuleParentRule(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSCSSRulePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSRulePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSRulePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSRulePrototype>(vm.heap)) JSCSSRulePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSRulePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSRulePrototype, JSCSSRulePrototype::Base);

using JSCSSRuleConstructor = JSDOMConstructorNotConstructable<JSCSSRule>;

/* Hash table for constructor */

static const HashTableValue JSCSSRuleConstructorTableValues[] =
{
    { "UNKNOWN_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "STYLE_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CHARSET_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "IMPORT_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "MEDIA_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "FONT_FACE_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "PAGE_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "KEYFRAMES_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "KEYFRAME_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "NAMESPACE_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(10) } },
    { "SUPPORTS_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(12) } },
#if ENABLE(CSS_DEVICE_ADAPTATION)
    { "WEBKIT_VIEWPORT_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(15) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "WEBKIT_KEYFRAMES_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "WEBKIT_KEYFRAME_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(8) } },
};

static_assert(CSSRule::UNKNOWN_RULE == 0, "UNKNOWN_RULE in CSSRule does not match value from IDL");
static_assert(CSSRule::STYLE_RULE == 1, "STYLE_RULE in CSSRule does not match value from IDL");
static_assert(CSSRule::CHARSET_RULE == 2, "CHARSET_RULE in CSSRule does not match value from IDL");
static_assert(CSSRule::IMPORT_RULE == 3, "IMPORT_RULE in CSSRule does not match value from IDL");
static_assert(CSSRule::MEDIA_RULE == 4, "MEDIA_RULE in CSSRule does not match value from IDL");
static_assert(CSSRule::FONT_FACE_RULE == 5, "FONT_FACE_RULE in CSSRule does not match value from IDL");
static_assert(CSSRule::PAGE_RULE == 6, "PAGE_RULE in CSSRule does not match value from IDL");
static_assert(CSSRule::KEYFRAMES_RULE == 7, "KEYFRAMES_RULE in CSSRule does not match value from IDL");
static_assert(CSSRule::KEYFRAME_RULE == 8, "KEYFRAME_RULE in CSSRule does not match value from IDL");
static_assert(CSSRule::NAMESPACE_RULE == 10, "NAMESPACE_RULE in CSSRule does not match value from IDL");
static_assert(CSSRule::SUPPORTS_RULE == 12, "SUPPORTS_RULE in CSSRule does not match value from IDL");
#if ENABLE(CSS_DEVICE_ADAPTATION)
static_assert(CSSRule::WEBKIT_VIEWPORT_RULE == 15, "WEBKIT_VIEWPORT_RULE in CSSRule does not match value from IDL");
#endif
static_assert(CSSRule::WEBKIT_KEYFRAMES_RULE == 7, "WEBKIT_KEYFRAMES_RULE in CSSRule does not match value from IDL");
static_assert(CSSRule::WEBKIT_KEYFRAME_RULE == 8, "WEBKIT_KEYFRAME_RULE in CSSRule does not match value from IDL");

template<> JSValue JSCSSRuleConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCSSRuleConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCSSRule::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("CSSRule"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSCSSRule::info(), JSCSSRuleConstructorTableValues, *this);
}

template<> const ClassInfo JSCSSRuleConstructor::s_info = { "CSSRule", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSRuleConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCSSRulePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSRuleConstructor) } },
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "cssText", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleCssText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCSSRuleCssText) } },
    { "parentStyleSheet", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleParentStyleSheet), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "parentRule", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSRuleParentRule), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "UNKNOWN_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "STYLE_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "CHARSET_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "IMPORT_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "MEDIA_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "FONT_FACE_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "PAGE_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "KEYFRAMES_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "KEYFRAME_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "NAMESPACE_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(10) } },
    { "SUPPORTS_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(12) } },
#if ENABLE(CSS_DEVICE_ADAPTATION)
    { "WEBKIT_VIEWPORT_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(15) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "WEBKIT_KEYFRAMES_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "WEBKIT_KEYFRAME_RULE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(8) } },
};

const ClassInfo JSCSSRulePrototype::s_info = { "CSSRulePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSRulePrototype) };

void JSCSSRulePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSRule::info(), JSCSSRulePrototypeTableValues, *this);
}

const ClassInfo JSCSSRule::s_info = { "CSSRule", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSRule) };

JSCSSRule::JSCSSRule(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSRule>&& impl)
    : JSDOMWrapper<CSSRule>(structure, globalObject, WTFMove(impl))
{
}

void JSCSSRule::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, CSSRule>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSCSSRule::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSCSSRulePrototype::create(vm, &globalObject, JSCSSRulePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSCSSRule::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSRule>(vm, globalObject);
}

JSValue JSCSSRule::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSRuleConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCSSRule::destroy(JSC::JSCell* cell)
{
    JSCSSRule* thisObject = static_cast<JSCSSRule*>(cell);
    thisObject->JSCSSRule::~JSCSSRule();
}

template<> inline JSCSSRule* IDLAttribute<JSCSSRule>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSCSSRule*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsCSSRuleConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSRulePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSRule::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSCSSRuleConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSRulePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsCSSRuleTypeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSRule& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.type());
    return result;
}

EncodedJSValue jsCSSRuleType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCSSRule>::get<jsCSSRuleTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline JSValue jsCSSRuleCssTextGetter(JSGlobalObject& lexicalGlobalObject, JSCSSRule& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.cssText());
    return result;
}

EncodedJSValue jsCSSRuleCssText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCSSRule>::get<jsCSSRuleCssTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "cssText");
}

static inline bool setJSCSSRuleCssTextSetter(JSGlobalObject& lexicalGlobalObject, JSCSSRule& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setCssText(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCSSRuleCssText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCSSRule>::set<setJSCSSRuleCssTextSetter>(*lexicalGlobalObject, thisValue, encodedValue, "cssText");
}

static inline JSValue jsCSSRuleParentStyleSheetGetter(JSGlobalObject& lexicalGlobalObject, JSCSSRule& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<CSSStyleSheet>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.parentStyleSheet());
    return result;
}

EncodedJSValue jsCSSRuleParentStyleSheet(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCSSRule>::get<jsCSSRuleParentStyleSheetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "parentStyleSheet");
}

static inline JSValue jsCSSRuleParentRuleGetter(JSGlobalObject& lexicalGlobalObject, JSCSSRule& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<CSSRule>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.parentRule());
    return result;
}

EncodedJSValue jsCSSRuleParentRule(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCSSRule>::get<jsCSSRuleParentRuleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "parentRule");
}

void JSCSSRule::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSCSSRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSCSSRule::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSCSSRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSCSSRule::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSRule*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSCSSRuleOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsCSSRule = jsCast<JSCSSRule*>(handle.slot()->asCell());
    void* root = WebCore::root(&jsCSSRule->wrapped());
    if (UNLIKELY(reason))
        *reason = "Reachable from jsCSSRule";
    return visitor.containsOpaqueRoot(root);
}

void JSCSSRuleOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCSSRule = static_cast<JSCSSRule*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCSSRule->wrapped(), jsCSSRule);
}

CSSRule* JSCSSRule::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSRule*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
