/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCacheQueryOptions.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> CacheQueryOptions convertDictionary<CacheQueryOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    CacheQueryOptions result;
    JSValue cacheNameValue;
    if (isNullOrUndefined)
        cacheNameValue = jsUndefined();
    else {
        cacheNameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cacheName"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cacheNameValue.isUndefined()) {
        result.cacheName = convert<IDLDOMString>(lexicalGlobalObject, cacheNameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue ignoreMethodValue;
    if (isNullOrUndefined)
        ignoreMethodValue = jsUndefined();
    else {
        ignoreMethodValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ignoreMethod"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ignoreMethodValue.isUndefined()) {
        result.ignoreMethod = convert<IDLBoolean>(lexicalGlobalObject, ignoreMethodValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.ignoreMethod = false;
    JSValue ignoreSearchValue;
    if (isNullOrUndefined)
        ignoreSearchValue = jsUndefined();
    else {
        ignoreSearchValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ignoreSearch"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ignoreSearchValue.isUndefined()) {
        result.ignoreSearch = convert<IDLBoolean>(lexicalGlobalObject, ignoreSearchValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.ignoreSearch = false;
    JSValue ignoreVaryValue;
    if (isNullOrUndefined)
        ignoreVaryValue = jsUndefined();
    else {
        ignoreVaryValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ignoreVary"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ignoreVaryValue.isUndefined()) {
        result.ignoreVary = convert<IDLBoolean>(lexicalGlobalObject, ignoreVaryValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.ignoreVary = false;
    return result;
}

} // namespace WebCore
