/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasRenderingContext2D.h"

#include "ActiveDOMObject.h"
#include "CallTracer.h"
#include "JSCanvasDirection.h"
#include "JSCanvasFillRule.h"
#include "JSCanvasGradient.h"
#include "JSCanvasLineCap.h"
#include "JSCanvasLineJoin.h"
#include "JSCanvasPattern.h"
#include "JSCanvasTextAlign.h"
#include "JSCanvasTextBaseline.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMMatrix.h"
#include "JSDOMMatrix2DInit.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "JSHTMLCanvasElement.h"
#include "JSHTMLImageElement.h"
#include "JSHTMLVideoElement.h"
#include "JSImageBitmap.h"
#include "JSImageData.h"
#include "JSImageSmoothingQuality.h"
#include "JSPath2D.h"
#include "JSTextMetrics.h"
#include "JSTypedOMCSSImageValue.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetAlpha(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperation(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetFillColor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineWidth(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineCap(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineJoin(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimit(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetShadow(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClearShadow(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetPath(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionGetPath(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionBeginPath(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFill(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStroke(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClip(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionIsPointInStroke(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreatePattern(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateImageData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionGetImageData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionPutImageData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClosePath(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionMoveTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionLineTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionBezierCurveTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionArcTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionArc(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionEllipse(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineDash(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionGetLineDash(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClearRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFillRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStrokeRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSave(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRestore(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFillText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStrokeText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionMeasureText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionScale(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRotate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionTranslate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionTransform(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionGetTransform(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetTransform(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionResetTransform(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawFocusIfNeeded(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsCanvasRenderingContext2DConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DCanvas(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCanvasRenderingContext2DWebkitBackingStorePixelRatio(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCanvasRenderingContext2DWebkitImageSmoothingEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DWebkitImageSmoothingEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DWebkitLineDash(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DWebkitLineDash(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DWebkitLineDashOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DWebkitLineDashOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DGlobalAlpha(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DGlobalAlpha(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DGlobalCompositeOperation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DGlobalCompositeOperation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DStrokeStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DStrokeStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DFillStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DFillStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DImageSmoothingEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DImageSmoothingEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DImageSmoothingQuality(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DImageSmoothingQuality(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DCurrentX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCanvasRenderingContext2DCurrentY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsCanvasRenderingContext2DLineWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DLineWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DLineCap(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DLineCap(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DLineJoin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DLineJoin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DMiterLimit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DMiterLimit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DLineDashOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DLineDashOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DShadowOffsetX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DShadowOffsetX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DShadowOffsetY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DShadowOffsetY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DShadowBlur(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DShadowBlur(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DShadowColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DShadowColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DFont(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DFont(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DTextAlign(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DTextAlign(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DTextBaseline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DTextBaseline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsCanvasRenderingContext2DDirection(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCanvasRenderingContext2DDirection(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCanvasRenderingContext2DPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCanvasRenderingContext2DPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCanvasRenderingContext2DPrototype* ptr = new (NotNull, JSC::allocateCell<JSCanvasRenderingContext2DPrototype>(vm.heap)) JSCanvasRenderingContext2DPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCanvasRenderingContext2DPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCanvasRenderingContext2DPrototype, JSCanvasRenderingContext2DPrototype::Base);

using JSCanvasRenderingContext2DConstructor = JSDOMConstructorNotConstructable<JSCanvasRenderingContext2D>;

template<> JSValue JSCanvasRenderingContext2DConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCanvasRenderingContext2DConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCanvasRenderingContext2D::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("CanvasRenderingContext2D"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSCanvasRenderingContext2DConstructor::s_info = { "CanvasRenderingContext2D", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCanvasRenderingContext2DConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCanvasRenderingContext2DPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DConstructor) } },
    { "canvas", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DCanvas), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitBackingStorePixelRatio", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DWebkitBackingStorePixelRatio), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitImageSmoothingEnabled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DWebkitImageSmoothingEnabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DWebkitImageSmoothingEnabled) } },
    { "webkitLineDash", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DWebkitLineDash), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DWebkitLineDash) } },
    { "webkitLineDashOffset", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DWebkitLineDashOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DWebkitLineDashOffset) } },
    { "globalAlpha", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DGlobalAlpha), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DGlobalAlpha) } },
    { "globalCompositeOperation", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DGlobalCompositeOperation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DGlobalCompositeOperation) } },
    { "strokeStyle", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DStrokeStyle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DStrokeStyle) } },
    { "fillStyle", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DFillStyle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DFillStyle) } },
    { "imageSmoothingEnabled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DImageSmoothingEnabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DImageSmoothingEnabled) } },
    { "imageSmoothingQuality", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DImageSmoothingQuality), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DImageSmoothingQuality) } },
    { "currentX", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DCurrentX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "currentY", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DCurrentY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lineWidth", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DLineWidth) } },
    { "lineCap", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineCap), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DLineCap) } },
    { "lineJoin", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineJoin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DLineJoin) } },
    { "miterLimit", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DMiterLimit), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DMiterLimit) } },
    { "lineDashOffset", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineDashOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DLineDashOffset) } },
    { "shadowOffsetX", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowOffsetX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DShadowOffsetX) } },
    { "shadowOffsetY", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowOffsetY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DShadowOffsetY) } },
    { "shadowBlur", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowBlur), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DShadowBlur) } },
    { "shadowColor", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DShadowColor) } },
    { "font", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DFont), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DFont) } },
    { "textAlign", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DTextAlign), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DTextAlign) } },
    { "textBaseline", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DTextBaseline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DTextBaseline) } },
    { "direction", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DDirection), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCanvasRenderingContext2DDirection) } },
    { "setAlpha", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetAlpha), (intptr_t) (0) } },
    { "setCompositeOperation", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperation), (intptr_t) (0) } },
    { "drawImageFromRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRect), (intptr_t) (1) } },
    { "setStrokeColor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor), (intptr_t) (1) } },
    { "setFillColor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetFillColor), (intptr_t) (1) } },
    { "setLineWidth", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineWidth), (intptr_t) (0) } },
    { "setLineCap", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineCap), (intptr_t) (0) } },
    { "setLineJoin", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineJoin), (intptr_t) (0) } },
    { "setMiterLimit", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimit), (intptr_t) (0) } },
    { "setShadow", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetShadow), (intptr_t) (3) } },
    { "clearShadow", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClearShadow), (intptr_t) (0) } },
    { "setPath", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetPath), (intptr_t) (1) } },
    { "getPath", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionGetPath), (intptr_t) (0) } },
    { "drawImage", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionDrawImage), (intptr_t) (3) } },
    { "beginPath", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionBeginPath), (intptr_t) (0) } },
    { "fill", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionFill), (intptr_t) (0) } },
    { "stroke", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionStroke), (intptr_t) (0) } },
    { "clip", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClip), (intptr_t) (0) } },
    { "isPointInPath", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath), (intptr_t) (2) } },
    { "isPointInStroke", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionIsPointInStroke), (intptr_t) (2) } },
    { "createLinearGradient", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient), (intptr_t) (4) } },
    { "createRadialGradient", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient), (intptr_t) (6) } },
    { "createPattern", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreatePattern), (intptr_t) (2) } },
    { "createImageData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreateImageData), (intptr_t) (1) } },
    { "getImageData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionGetImageData), (intptr_t) (4) } },
    { "putImageData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionPutImageData), (intptr_t) (3) } },
    { "closePath", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClosePath), (intptr_t) (0) } },
    { "moveTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionMoveTo), (intptr_t) (2) } },
    { "lineTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionLineTo), (intptr_t) (2) } },
    { "quadraticCurveTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo), (intptr_t) (4) } },
    { "bezierCurveTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionBezierCurveTo), (intptr_t) (6) } },
    { "arcTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionArcTo), (intptr_t) (5) } },
    { "rect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionRect), (intptr_t) (4) } },
    { "arc", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionArc), (intptr_t) (5) } },
    { "ellipse", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionEllipse), (intptr_t) (7) } },
    { "setLineDash", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineDash), (intptr_t) (1) } },
    { "getLineDash", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionGetLineDash), (intptr_t) (0) } },
    { "clearRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClearRect), (intptr_t) (4) } },
    { "fillRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionFillRect), (intptr_t) (4) } },
    { "strokeRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionStrokeRect), (intptr_t) (4) } },
    { "save", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSave), (intptr_t) (0) } },
    { "restore", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionRestore), (intptr_t) (0) } },
    { "fillText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionFillText), (intptr_t) (3) } },
    { "strokeText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionStrokeText), (intptr_t) (3) } },
    { "measureText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionMeasureText), (intptr_t) (1) } },
    { "scale", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionScale), (intptr_t) (2) } },
    { "rotate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionRotate), (intptr_t) (1) } },
    { "translate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionTranslate), (intptr_t) (2) } },
    { "transform", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionTransform), (intptr_t) (6) } },
    { "getTransform", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionGetTransform), (intptr_t) (0) } },
    { "setTransform", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetTransform), (intptr_t) (0) } },
    { "resetTransform", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionResetTransform), (intptr_t) (0) } },
    { "drawFocusIfNeeded", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionDrawFocusIfNeeded), (intptr_t) (1) } },
};

const ClassInfo JSCanvasRenderingContext2DPrototype::s_info = { "CanvasRenderingContext2DPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCanvasRenderingContext2DPrototype) };

void JSCanvasRenderingContext2DPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCanvasRenderingContext2D::info(), JSCanvasRenderingContext2DPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().inspectorAdditionsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("setPath"), strlen("setPath"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().inspectorAdditionsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("getPath"), strlen("getPath"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().inspectorAdditionsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("currentX"), strlen("currentX"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().inspectorAdditionsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("currentY"), strlen("currentY"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSCanvasRenderingContext2D::s_info = { "CanvasRenderingContext2D", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCanvasRenderingContext2D) };

JSCanvasRenderingContext2D::JSCanvasRenderingContext2D(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CanvasRenderingContext2D>&& impl)
    : JSDOMWrapper<CanvasRenderingContext2D>(structure, globalObject, WTFMove(impl))
{
}

void JSCanvasRenderingContext2D::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, CanvasRenderingContext2D>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSCanvasRenderingContext2D::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSCanvasRenderingContext2DPrototype::create(vm, &globalObject, JSCanvasRenderingContext2DPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSCanvasRenderingContext2D::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCanvasRenderingContext2D>(vm, globalObject);
}

JSValue JSCanvasRenderingContext2D::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCanvasRenderingContext2DConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCanvasRenderingContext2D::destroy(JSC::JSCell* cell)
{
    JSCanvasRenderingContext2D* thisObject = static_cast<JSCanvasRenderingContext2D*>(cell);
    thisObject->JSCanvasRenderingContext2D::~JSCanvasRenderingContext2D();
}

template<> inline JSCanvasRenderingContext2D* IDLAttribute<JSCanvasRenderingContext2D>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSCanvasRenderingContext2D*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSCanvasRenderingContext2D* IDLOperation<JSCanvasRenderingContext2D>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSCanvasRenderingContext2D*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsCanvasRenderingContext2DConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCanvasRenderingContext2DPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCanvasRenderingContext2D::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSCanvasRenderingContext2DConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCanvasRenderingContext2DPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsCanvasRenderingContext2DCanvasGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLCanvasElement>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.canvas());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DCanvas(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DCanvasGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "canvas");
}

static inline JSValue jsCanvasRenderingContext2DWebkitBackingStorePixelRatioGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.webkitBackingStorePixelRatio());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DWebkitBackingStorePixelRatio(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DWebkitBackingStorePixelRatioGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitBackingStorePixelRatio");
}

static inline JSValue jsCanvasRenderingContext2DWebkitImageSmoothingEnabledGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "webkitImageSmoothingEnabled"_s);
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.imageSmoothingEnabled());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DWebkitImageSmoothingEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DWebkitImageSmoothingEnabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitImageSmoothingEnabled");
}

static inline bool setJSCanvasRenderingContext2DWebkitImageSmoothingEnabledSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "webkitImageSmoothingEnabled"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setImageSmoothingEnabled(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DWebkitImageSmoothingEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DWebkitImageSmoothingEnabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "webkitImageSmoothingEnabled");
}

static inline JSValue jsCanvasRenderingContext2DWebkitLineDashGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "webkitLineDash"_s);
    JSValue result = toJS<IDLSequence<IDLUnrestrictedFloat>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.webkitLineDash());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DWebkitLineDash(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DWebkitLineDashGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitLineDash");
}

static inline bool setJSCanvasRenderingContext2DWebkitLineDashSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLSequence<IDLUnrestrictedFloat>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "webkitLineDash"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setWebkitLineDash(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DWebkitLineDash(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DWebkitLineDashSetter>(*lexicalGlobalObject, thisValue, encodedValue, "webkitLineDash");
}

static inline JSValue jsCanvasRenderingContext2DWebkitLineDashOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "webkitLineDashOffset"_s);
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.lineDashOffset());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DWebkitLineDashOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DWebkitLineDashOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitLineDashOffset");
}

static inline bool setJSCanvasRenderingContext2DWebkitLineDashOffsetSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "webkitLineDashOffset"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineDashOffset(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DWebkitLineDashOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DWebkitLineDashOffsetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "webkitLineDashOffset");
}

static inline JSValue jsCanvasRenderingContext2DGlobalAlphaGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "globalAlpha"_s);
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.globalAlpha());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DGlobalAlpha(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DGlobalAlphaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "globalAlpha");
}

static inline bool setJSCanvasRenderingContext2DGlobalAlphaSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "globalAlpha"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setGlobalAlpha(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DGlobalAlpha(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DGlobalAlphaSetter>(*lexicalGlobalObject, thisValue, encodedValue, "globalAlpha");
}

static inline JSValue jsCanvasRenderingContext2DGlobalCompositeOperationGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "globalCompositeOperation"_s);
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.globalCompositeOperation());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DGlobalCompositeOperation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DGlobalCompositeOperationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "globalCompositeOperation");
}

static inline bool setJSCanvasRenderingContext2DGlobalCompositeOperationSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "globalCompositeOperation"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setGlobalCompositeOperation(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DGlobalCompositeOperation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DGlobalCompositeOperationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "globalCompositeOperation");
}

static inline JSValue jsCanvasRenderingContext2DStrokeStyleGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "strokeStyle"_s);
    JSValue result = toJS<IDLUnion<IDLDOMString, IDLInterface<CanvasGradient>, IDLInterface<CanvasPattern>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.strokeStyle());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DStrokeStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DStrokeStyleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "strokeStyle");
}

static inline bool setJSCanvasRenderingContext2DStrokeStyleSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDOMString, IDLInterface<CanvasGradient>, IDLInterface<CanvasPattern>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "strokeStyle"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setStrokeStyle(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DStrokeStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DStrokeStyleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "strokeStyle");
}

static inline JSValue jsCanvasRenderingContext2DFillStyleGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "fillStyle"_s);
    JSValue result = toJS<IDLUnion<IDLDOMString, IDLInterface<CanvasGradient>, IDLInterface<CanvasPattern>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.fillStyle());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DFillStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DFillStyleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "fillStyle");
}

static inline bool setJSCanvasRenderingContext2DFillStyleSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnion<IDLDOMString, IDLInterface<CanvasGradient>, IDLInterface<CanvasPattern>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "fillStyle"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setFillStyle(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DFillStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DFillStyleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "fillStyle");
}

static inline JSValue jsCanvasRenderingContext2DImageSmoothingEnabledGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "imageSmoothingEnabled"_s);
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.imageSmoothingEnabled());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DImageSmoothingEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DImageSmoothingEnabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "imageSmoothingEnabled");
}

static inline bool setJSCanvasRenderingContext2DImageSmoothingEnabledSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "imageSmoothingEnabled"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setImageSmoothingEnabled(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DImageSmoothingEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DImageSmoothingEnabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "imageSmoothingEnabled");
}

static inline JSValue jsCanvasRenderingContext2DImageSmoothingQualityGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "imageSmoothingQuality"_s);
    JSValue result = toJS<IDLEnumeration<ImageSmoothingQuality>>(lexicalGlobalObject, throwScope, impl.imageSmoothingQuality());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DImageSmoothingQuality(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DImageSmoothingQualityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "imageSmoothingQuality");
}

static inline bool setJSCanvasRenderingContext2DImageSmoothingQualitySetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<ImageSmoothingQuality>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "imageSmoothingQuality"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setImageSmoothingQuality(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DImageSmoothingQuality(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DImageSmoothingQualitySetter>(*lexicalGlobalObject, thisValue, encodedValue, "imageSmoothingQuality");
}

static inline JSValue jsCanvasRenderingContext2DCurrentXGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.currentX());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DCurrentX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DCurrentXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "currentX");
}

static inline JSValue jsCanvasRenderingContext2DCurrentYGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.currentY());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DCurrentY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DCurrentYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "currentY");
}

static inline JSValue jsCanvasRenderingContext2DLineWidthGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "lineWidth"_s);
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.lineWidth());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DLineWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DLineWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lineWidth");
}

static inline bool setJSCanvasRenderingContext2DLineWidthSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "lineWidth"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineWidth(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DLineWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DLineWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "lineWidth");
}

static inline JSValue jsCanvasRenderingContext2DLineCapGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "lineCap"_s);
    JSValue result = toJS<IDLEnumeration<CanvasLineCap>>(lexicalGlobalObject, throwScope, impl.lineCap());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DLineCap(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DLineCapGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lineCap");
}

static inline bool setJSCanvasRenderingContext2DLineCapSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CanvasLineCap>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "lineCap"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineCap(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DLineCap(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DLineCapSetter>(*lexicalGlobalObject, thisValue, encodedValue, "lineCap");
}

static inline JSValue jsCanvasRenderingContext2DLineJoinGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "lineJoin"_s);
    JSValue result = toJS<IDLEnumeration<CanvasLineJoin>>(lexicalGlobalObject, throwScope, impl.lineJoin());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DLineJoin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DLineJoinGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lineJoin");
}

static inline bool setJSCanvasRenderingContext2DLineJoinSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CanvasLineJoin>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "lineJoin"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineJoin(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DLineJoin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DLineJoinSetter>(*lexicalGlobalObject, thisValue, encodedValue, "lineJoin");
}

static inline JSValue jsCanvasRenderingContext2DMiterLimitGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "miterLimit"_s);
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.miterLimit());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DMiterLimit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DMiterLimitGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "miterLimit");
}

static inline bool setJSCanvasRenderingContext2DMiterLimitSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "miterLimit"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setMiterLimit(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DMiterLimit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DMiterLimitSetter>(*lexicalGlobalObject, thisValue, encodedValue, "miterLimit");
}

static inline JSValue jsCanvasRenderingContext2DLineDashOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "lineDashOffset"_s);
    JSValue result = toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.lineDashOffset());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DLineDashOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DLineDashOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lineDashOffset");
}

static inline bool setJSCanvasRenderingContext2DLineDashOffsetSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "lineDashOffset"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineDashOffset(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DLineDashOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DLineDashOffsetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "lineDashOffset");
}

static inline JSValue jsCanvasRenderingContext2DShadowOffsetXGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "shadowOffsetX"_s);
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.shadowOffsetX());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DShadowOffsetX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DShadowOffsetXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shadowOffsetX");
}

static inline bool setJSCanvasRenderingContext2DShadowOffsetXSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "shadowOffsetX"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setShadowOffsetX(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DShadowOffsetX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DShadowOffsetXSetter>(*lexicalGlobalObject, thisValue, encodedValue, "shadowOffsetX");
}

static inline JSValue jsCanvasRenderingContext2DShadowOffsetYGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "shadowOffsetY"_s);
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.shadowOffsetY());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DShadowOffsetY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DShadowOffsetYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shadowOffsetY");
}

static inline bool setJSCanvasRenderingContext2DShadowOffsetYSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "shadowOffsetY"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setShadowOffsetY(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DShadowOffsetY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DShadowOffsetYSetter>(*lexicalGlobalObject, thisValue, encodedValue, "shadowOffsetY");
}

static inline JSValue jsCanvasRenderingContext2DShadowBlurGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "shadowBlur"_s);
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.shadowBlur());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DShadowBlur(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DShadowBlurGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shadowBlur");
}

static inline bool setJSCanvasRenderingContext2DShadowBlurSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "shadowBlur"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setShadowBlur(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DShadowBlur(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DShadowBlurSetter>(*lexicalGlobalObject, thisValue, encodedValue, "shadowBlur");
}

static inline JSValue jsCanvasRenderingContext2DShadowColorGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "shadowColor"_s);
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.shadowColor());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DShadowColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DShadowColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shadowColor");
}

static inline bool setJSCanvasRenderingContext2DShadowColorSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "shadowColor"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setShadowColor(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DShadowColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DShadowColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "shadowColor");
}

static inline JSValue jsCanvasRenderingContext2DFontGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "font"_s);
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.font());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DFont(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DFontGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "font");
}

static inline bool setJSCanvasRenderingContext2DFontSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "font"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setFont(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DFont(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DFontSetter>(*lexicalGlobalObject, thisValue, encodedValue, "font");
}

static inline JSValue jsCanvasRenderingContext2DTextAlignGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "textAlign"_s);
    JSValue result = toJS<IDLEnumeration<CanvasTextAlign>>(lexicalGlobalObject, throwScope, impl.textAlign());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DTextAlign(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DTextAlignGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "textAlign");
}

static inline bool setJSCanvasRenderingContext2DTextAlignSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CanvasTextAlign>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "textAlign"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTextAlign(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DTextAlign(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DTextAlignSetter>(*lexicalGlobalObject, thisValue, encodedValue, "textAlign");
}

static inline JSValue jsCanvasRenderingContext2DTextBaselineGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "textBaseline"_s);
    JSValue result = toJS<IDLEnumeration<CanvasTextBaseline>>(lexicalGlobalObject, throwScope, impl.textBaseline());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DTextBaseline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DTextBaselineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "textBaseline");
}

static inline bool setJSCanvasRenderingContext2DTextBaselineSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CanvasTextBaseline>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "textBaseline"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTextBaseline(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DTextBaseline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DTextBaselineSetter>(*lexicalGlobalObject, thisValue, encodedValue, "textBaseline");
}

static inline JSValue jsCanvasRenderingContext2DDirectionGetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "direction"_s);
    JSValue result = toJS<IDLEnumeration<CanvasDirection>>(lexicalGlobalObject, throwScope, impl.direction());
    return result;
}

EncodedJSValue jsCanvasRenderingContext2DDirection(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::get<jsCanvasRenderingContext2DDirectionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "direction");
}

static inline bool setJSCanvasRenderingContext2DDirectionSetter(JSGlobalObject& lexicalGlobalObject, JSCanvasRenderingContext2D& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CanvasDirection>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "direction"_s, { nativeValue });
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDirection(WTFMove(nativeValue));
    });
    return true;
}

bool setJSCanvasRenderingContext2DDirection(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSCanvasRenderingContext2D>::set<setJSCanvasRenderingContext2DDirectionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "direction");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetAlphaBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto alpha = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setAlpha"_s, { alpha });
    impl.setGlobalAlpha(WTFMove(alpha));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetAlpha(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionSetAlphaBody>(*lexicalGlobalObject, *callFrame, "setAlpha");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto compositeOperation = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setCompositeOperation"_s, { compositeOperation });
    impl.setGlobalCompositeOperation(WTFMove(compositeOperation));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperation(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperationBody>(*lexicalGlobalObject, *callFrame, "setCompositeOperation");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto image = convert<IDLInterface<HTMLImageElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "image", "CanvasRenderingContext2D", "drawImageFromRect", "HTMLImageElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sx = callFrame->argument(1).isUndefined() ? 0 : convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sy = callFrame->argument(2).isUndefined() ? 0 : convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sw = callFrame->argument(3).isUndefined() ? 0 : convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sh = callFrame->argument(4).isUndefined() ? 0 : convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dx = callFrame->argument(5).isUndefined() ? 0 : convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dy = callFrame->argument(6).isUndefined() ? 0 : convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dw = callFrame->argument(7).isUndefined() ? 0 : convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dh = callFrame->argument(8).isUndefined() ? 0 : convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto compositeOperation = callFrame->argument(9).isUndefined() ? emptyString() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "drawImageFromRect"_s, { image, sx, sy, sw, sh, dx, dy, dw, dh, compositeOperation });
    impl.drawImageFromRect(*image, WTFMove(sx), WTFMove(sy), WTFMove(sw), WTFMove(sh), WTFMove(dx), WTFMove(dy), WTFMove(dw), WTFMove(dh), WTFMove(compositeOperation));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRectBody>(*lexicalGlobalObject, *callFrame, "drawImageFromRect");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto color = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto alpha = callFrame->argument(1).isUndefined() ? Optional<Converter<IDLUnrestrictedFloat>::ReturnType>() : Optional<Converter<IDLUnrestrictedFloat>::ReturnType>(convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setStrokeColor"_s, { color, alpha });
    impl.setStrokeColor(WTFMove(color), WTFMove(alpha));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto grayLevel = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto alpha = callFrame->argument(1).isUndefined() ? 1 : convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setStrokeColor"_s, { grayLevel, alpha });
    impl.setStrokeColor(WTFMove(grayLevel), WTFMove(alpha));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto r = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto g = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto b = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto a = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setStrokeColor"_s, { r, g, b, a });
    impl.setStrokeColor(WTFMove(r), WTFMove(g), WTFMove(b), WTFMove(a));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor4Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto c = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto m = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto k = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto a = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setStrokeColor"_s, { c, m, y, k, a });
    impl.setStrokeColor(WTFMove(c), WTFMove(m), WTFMove(y), WTFMove(k), WTFMove(a));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColorOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(5, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isNumber())
            return jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isNumber())
            return jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 4) {
        return jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 5) {
        return jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor4Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColorOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "setStrokeColor");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetFillColor1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto color = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto alpha = callFrame->argument(1).isUndefined() ? Optional<Converter<IDLUnrestrictedFloat>::ReturnType>() : Optional<Converter<IDLUnrestrictedFloat>::ReturnType>(convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setFillColor"_s, { color, alpha });
    impl.setFillColor(WTFMove(color), WTFMove(alpha));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetFillColor2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto grayLevel = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto alpha = callFrame->argument(1).isUndefined() ? 1 : convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setFillColor"_s, { grayLevel, alpha });
    impl.setFillColor(WTFMove(grayLevel), WTFMove(alpha));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetFillColor3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto r = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto g = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto b = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto a = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setFillColor"_s, { r, g, b, a });
    impl.setFillColor(WTFMove(r), WTFMove(g), WTFMove(b), WTFMove(a));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetFillColor4Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto c = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto m = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto k = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto a = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setFillColor"_s, { c, m, y, k, a });
    impl.setFillColor(WTFMove(c), WTFMove(m), WTFMove(y), WTFMove(k), WTFMove(a));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetFillColorOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(5, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isNumber())
            return jsCanvasRenderingContext2DPrototypeFunctionSetFillColor2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsCanvasRenderingContext2DPrototypeFunctionSetFillColor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isNumber())
            return jsCanvasRenderingContext2DPrototypeFunctionSetFillColor2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsCanvasRenderingContext2DPrototypeFunctionSetFillColor1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 4) {
        return jsCanvasRenderingContext2DPrototypeFunctionSetFillColor3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 5) {
        return jsCanvasRenderingContext2DPrototypeFunctionSetFillColor4Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetFillColor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionSetFillColorOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "setFillColor");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetLineWidthBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto width = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setLineWidth"_s, { width });
    impl.setLineWidth(WTFMove(width));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineWidth(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionSetLineWidthBody>(*lexicalGlobalObject, *callFrame, "setLineWidth");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetLineCapBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto cap = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setLineCap"_s, { cap });
    impl.setLineCap(WTFMove(cap));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineCap(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionSetLineCapBody>(*lexicalGlobalObject, *callFrame, "setLineCap");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetLineJoinBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto join = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setLineJoin"_s, { join });
    impl.setLineJoin(WTFMove(join));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineJoin(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionSetLineJoinBody>(*lexicalGlobalObject, *callFrame, "setLineJoin");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimitBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto limit = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setMiterLimit"_s, { limit });
    impl.setMiterLimit(WTFMove(limit));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimit(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimitBody>(*lexicalGlobalObject, *callFrame, "setMiterLimit");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetShadow1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto width = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto blur = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto color = callFrame->argument(3).isUndefined() ? String() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto alpha = callFrame->argument(4).isUndefined() ? Optional<Converter<IDLUnrestrictedFloat>::ReturnType>() : Optional<Converter<IDLUnrestrictedFloat>::ReturnType>(convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setShadow"_s, { width, height, blur, color, alpha });
    impl.setShadow(WTFMove(width), WTFMove(height), WTFMove(blur), WTFMove(color), WTFMove(alpha));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetShadow2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto width = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto blur = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto grayLevel = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto alpha = callFrame->argument(4).isUndefined() ? 1 : convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setShadow"_s, { width, height, blur, grayLevel, alpha });
    impl.setShadow(WTFMove(width), WTFMove(height), WTFMove(blur), WTFMove(grayLevel), WTFMove(alpha));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetShadow3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto width = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto blur = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto r = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto g = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto b = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto a = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setShadow"_s, { width, height, blur, r, g, b, a });
    impl.setShadow(WTFMove(width), WTFMove(height), WTFMove(blur), WTFMove(r), WTFMove(g), WTFMove(b), WTFMove(a));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetShadow4Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto width = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto blur = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto c = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto m = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto k = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto a = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setShadow"_s, { width, height, blur, c, m, y, k, a });
    impl.setShadow(WTFMove(width), WTFMove(height), WTFMove(blur), WTFMove(c), WTFMove(m), WTFMove(y), WTFMove(k), WTFMove(a));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetShadowOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(8, callFrame->argumentCount());
    if (argsCount == 3) {
        return jsCanvasRenderingContext2DPrototypeFunctionSetShadow1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 4) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(3);
        if (distinguishingArg.isUndefined())
            return jsCanvasRenderingContext2DPrototypeFunctionSetShadow1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isNumber())
            return jsCanvasRenderingContext2DPrototypeFunctionSetShadow2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsCanvasRenderingContext2DPrototypeFunctionSetShadow1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 5) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(3);
        if (distinguishingArg.isUndefined())
            return jsCanvasRenderingContext2DPrototypeFunctionSetShadow1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isNumber())
            return jsCanvasRenderingContext2DPrototypeFunctionSetShadow2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsCanvasRenderingContext2DPrototypeFunctionSetShadow1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 7) {
        return jsCanvasRenderingContext2DPrototypeFunctionSetShadow3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 8) {
        return jsCanvasRenderingContext2DPrototypeFunctionSetShadow4Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 3 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetShadow(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionSetShadowOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "setShadow");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionClearShadowBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "clearShadow"_s);
    impl.clearShadow();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClearShadow(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionClearShadowBody>(*lexicalGlobalObject, *callFrame, "clearShadow");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetPathBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "CanvasRenderingContext2D", "setPath", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setPath"_s, { path });
    impl.setPath(*path);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetPath(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionSetPathBody>(*lexicalGlobalObject, *callFrame, "setPath");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionGetPathBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getPath"_s);
    return JSValue::encode(toJSNewlyCreated<IDLInterface<Path2D>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getPath()));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionGetPath(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionGetPathBody>(*lexicalGlobalObject, *callFrame, "getPath");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionDrawImage1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
#if ENABLE(VIDEO)
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
#else
	auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
#endif
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dx = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dy = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "drawImage"_s, { image, dx, dy });
    propagateException(*lexicalGlobalObject, throwScope, impl.drawImage(WTFMove(image), WTFMove(dx), WTFMove(dy)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionDrawImage2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
#if ENABLE(VIDEO)
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
#else
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
#endif
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dx = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dy = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dw = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dh = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "drawImage"_s, { image, dx, dy, dw, dh });
    propagateException(*lexicalGlobalObject, throwScope, impl.drawImage(WTFMove(image), WTFMove(dx), WTFMove(dy), WTFMove(dw), WTFMove(dh)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionDrawImage3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
#if ENABLE(VIDEO)
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
#else
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
#endif
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sx = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sy = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sw = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sh = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dx = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dy = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dw = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dh = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "drawImage"_s, { image, sx, sy, sw, sh, dx, dy, dw, dh });
    propagateException(*lexicalGlobalObject, throwScope, impl.drawImage(WTFMove(image), WTFMove(sx), WTFMove(sy), WTFMove(sw), WTFMove(sh), WTFMove(dx), WTFMove(dy), WTFMove(dw), WTFMove(dh)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionDrawImageOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(9, callFrame->argumentCount());
    if (argsCount == 3) {
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 5) {
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 9) {
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage3Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 3 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionDrawImageOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "drawImage");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionBeginPathBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "beginPath"_s);
    impl.beginPath();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionBeginPath(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionBeginPathBody>(*lexicalGlobalObject, *callFrame, "beginPath");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionFill1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto fillRule = callFrame->argument(0).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "fillRule", "CanvasRenderingContext2D", "fill", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "fill"_s, { fillRule });
    impl.fill(WTFMove(fillRule));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionFill2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "CanvasRenderingContext2D", "fill", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto fillRule = callFrame->argument(1).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "fillRule", "CanvasRenderingContext2D", "fill", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "fill"_s, { path, fillRule });
    impl.fill(*path, WTFMove(fillRule));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionFillOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsCanvasRenderingContext2DPrototypeFunctionFill1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsCanvasRenderingContext2DPrototypeFunctionFill1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSPath2D>(vm))
            return jsCanvasRenderingContext2DPrototypeFunctionFill2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsCanvasRenderingContext2DPrototypeFunctionFill1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        return jsCanvasRenderingContext2DPrototypeFunctionFill2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFill(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionFillOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "fill");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionStroke1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "stroke"_s);
    impl.stroke();
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionStroke2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "CanvasRenderingContext2D", "stroke", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "stroke"_s, { path });
    impl.stroke(*path);
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionStrokeOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsCanvasRenderingContext2DPrototypeFunctionStroke1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        return jsCanvasRenderingContext2DPrototypeFunctionStroke2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStroke(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionStrokeOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "stroke");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionClip1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto fillRule = callFrame->argument(0).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "fillRule", "CanvasRenderingContext2D", "clip", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "clip"_s, { fillRule });
    impl.clip(WTFMove(fillRule));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionClip2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "CanvasRenderingContext2D", "clip", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto fillRule = callFrame->argument(1).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "fillRule", "CanvasRenderingContext2D", "clip", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "clip"_s, { path, fillRule });
    impl.clip(*path, WTFMove(fillRule));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionClipOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsCanvasRenderingContext2DPrototypeFunctionClip1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return jsCanvasRenderingContext2DPrototypeFunctionClip1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSPath2D>(vm))
            return jsCanvasRenderingContext2DPrototypeFunctionClip2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsCanvasRenderingContext2DPrototypeFunctionClip1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        return jsCanvasRenderingContext2DPrototypeFunctionClip2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClip(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionClipOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "clip");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto fillRule = callFrame->argument(2).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 2, "fillRule", "CanvasRenderingContext2D", "isPointInPath", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isPointInPath"_s, { x, y, fillRule });
    return JSValue::encode(toJS<IDLBoolean>(impl.isPointInPath(WTFMove(x), WTFMove(y), WTFMove(fillRule))));
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "CanvasRenderingContext2D", "isPointInPath", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto fillRule = callFrame->argument(3).isUndefined() ? CanvasFillRule::Nonzero : convert<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, callFrame->uncheckedArgument(3), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 3, "fillRule", "CanvasRenderingContext2D", "isPointInPath", expectedEnumerationValues<CanvasFillRule>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isPointInPath"_s, { path, x, y, fillRule });
    return JSValue::encode(toJS<IDLBoolean>(impl.isPointInPath(*path, WTFMove(x), WTFMove(y), WTFMove(fillRule))));
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionIsPointInPathOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 2) {
        return jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 3) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSPath2D>(vm))
            return jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isNumber())
            return jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        return jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 4) {
        return jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionIsPointInPathOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "isPointInPath");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionIsPointInStroke1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isPointInStroke"_s, { x, y });
    return JSValue::encode(toJS<IDLBoolean>(impl.isPointInStroke(WTFMove(x), WTFMove(y))));
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionIsPointInStroke2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "CanvasRenderingContext2D", "isPointInStroke", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "isPointInStroke"_s, { path, x, y });
    return JSValue::encode(toJS<IDLBoolean>(impl.isPointInStroke(*path, WTFMove(x), WTFMove(y))));
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionIsPointInStrokeOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 2) {
        return jsCanvasRenderingContext2DPrototypeFunctionIsPointInStroke1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 3) {
        return jsCanvasRenderingContext2DPrototypeFunctionIsPointInStroke2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionIsPointInStroke(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionIsPointInStrokeOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "isPointInStroke");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradientBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x0 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y0 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x1 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y1 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "createLinearGradient"_s, { x0, y0, x1, y1 });
    return JSValue::encode(toJS<IDLInterface<CanvasGradient>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createLinearGradient(WTFMove(x0), WTFMove(y0), WTFMove(x1), WTFMove(y1))));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradientBody>(*lexicalGlobalObject, *callFrame, "createLinearGradient");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradientBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x0 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y0 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto r0 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x1 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y1 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto r1 = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "createRadialGradient"_s, { x0, y0, r0, x1, y1, r1 });
    return JSValue::encode(toJS<IDLInterface<CanvasGradient>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createRadialGradient(WTFMove(x0), WTFMove(y0), WTFMove(r0), WTFMove(x1), WTFMove(y1), WTFMove(r1))));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradientBody>(*lexicalGlobalObject, *callFrame, "createRadialGradient");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionCreatePatternBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
#if ENABLE(VIDEO)
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>, IDLInterface<HTMLVideoElement>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
#else
    auto image = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<TypedOMCSSImageValue>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
#endif
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto repetition = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "createPattern"_s, { image, repetition });
    return JSValue::encode(toJS<IDLNullable<IDLInterface<CanvasPattern>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createPattern(WTFMove(image), WTFMove(repetition))));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreatePattern(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionCreatePatternBody>(*lexicalGlobalObject, *callFrame, "createPattern");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionCreateImageData1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto sw = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sh = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "createImageData"_s, { sw, sh });
    return JSValue::encode(toJS<IDLInterface<ImageData>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createImageData(WTFMove(sw), WTFMove(sh))));
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionCreateImageData2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto imagedata = convert<IDLInterface<ImageData>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "imagedata", "CanvasRenderingContext2D", "createImageData", "ImageData"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "createImageData"_s, { imagedata });
    return JSValue::encode(toJS<IDLInterface<ImageData>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createImageData(*imagedata)));
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionCreateImageDataOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 1) {
        return jsCanvasRenderingContext2DPrototypeFunctionCreateImageData2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        return jsCanvasRenderingContext2DPrototypeFunctionCreateImageData1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateImageData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionCreateImageDataOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "createImageData");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionGetImageDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sx = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sy = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sw = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto sh = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getImageData"_s, { sx, sy, sw, sh });
    return JSValue::encode(toJS<IDLInterface<ImageData>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getImageData(WTFMove(sx), WTFMove(sy), WTFMove(sw), WTFMove(sh))));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionGetImageData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionGetImageDataBody>(*lexicalGlobalObject, *callFrame, "getImageData");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionPutImageData1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto imagedata = convert<IDLInterface<ImageData>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "imagedata", "CanvasRenderingContext2D", "putImageData", "ImageData"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dx = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dy = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "putImageData"_s, { imagedata, dx, dy });
    impl.putImageData(*imagedata, WTFMove(dx), WTFMove(dy));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionPutImageData2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto imagedata = convert<IDLInterface<ImageData>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "imagedata", "CanvasRenderingContext2D", "putImageData", "ImageData"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dx = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dy = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dirtyX = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dirtyY = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dirtyWidth = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto dirtyHeight = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "putImageData"_s, { imagedata, dx, dy, dirtyX, dirtyY, dirtyWidth, dirtyHeight });
    impl.putImageData(*imagedata, WTFMove(dx), WTFMove(dy), WTFMove(dirtyX), WTFMove(dirtyY), WTFMove(dirtyWidth), WTFMove(dirtyHeight));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionPutImageDataOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(7, callFrame->argumentCount());
    if (argsCount == 3) {
        return jsCanvasRenderingContext2DPrototypeFunctionPutImageData1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 7) {
        return jsCanvasRenderingContext2DPrototypeFunctionPutImageData2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 3 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionPutImageData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionPutImageDataOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "putImageData");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionClosePathBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "closePath"_s);
    impl.closePath();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClosePath(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionClosePathBody>(*lexicalGlobalObject, *callFrame, "closePath");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionMoveToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "moveTo"_s, { x, y });
    impl.moveTo(WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionMoveTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionMoveToBody>(*lexicalGlobalObject, *callFrame, "moveTo");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionLineToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "lineTo"_s, { x, y });
    impl.lineTo(WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionLineTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionLineToBody>(*lexicalGlobalObject, *callFrame, "lineTo");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto cpx = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cpy = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "quadraticCurveTo"_s, { cpx, cpy, x, y });
    impl.quadraticCurveTo(WTFMove(cpx), WTFMove(cpy), WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveToBody>(*lexicalGlobalObject, *callFrame, "quadraticCurveTo");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionBezierCurveToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto cp1x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cp1y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cp2x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cp2y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "bezierCurveTo"_s, { cp1x, cp1y, cp2x, cp2y, x, y });
    impl.bezierCurveTo(WTFMove(cp1x), WTFMove(cp1y), WTFMove(cp2x), WTFMove(cp2y), WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionBezierCurveTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionBezierCurveToBody>(*lexicalGlobalObject, *callFrame, "bezierCurveTo");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionArcToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x1 = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y1 = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x2 = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y2 = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto radius = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "arcTo"_s, { x1, y1, x2, y2, radius });
    propagateException(*lexicalGlobalObject, throwScope, impl.arcTo(WTFMove(x1), WTFMove(y1), WTFMove(x2), WTFMove(y2), WTFMove(radius)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionArcTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionArcToBody>(*lexicalGlobalObject, *callFrame, "arcTo");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto h = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "rect"_s, { x, y, w, h });
    impl.rect(WTFMove(x), WTFMove(y), WTFMove(w), WTFMove(h));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionRectBody>(*lexicalGlobalObject, *callFrame, "rect");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionArcBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto radius = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto startAngle = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto endAngle = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto anticlockwise = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "arc"_s, { x, y, radius, startAngle, endAngle, anticlockwise });
    propagateException(*lexicalGlobalObject, throwScope, impl.arc(WTFMove(x), WTFMove(y), WTFMove(radius), WTFMove(startAngle), WTFMove(endAngle), WTFMove(anticlockwise)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionArc(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionArcBody>(*lexicalGlobalObject, *callFrame, "arc");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionEllipseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 7))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto radiusX = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto radiusY = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto rotation = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto startAngle = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto endAngle = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto anticlockwise = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "ellipse"_s, { x, y, radiusX, radiusY, rotation, startAngle, endAngle, anticlockwise });
    propagateException(*lexicalGlobalObject, throwScope, impl.ellipse(WTFMove(x), WTFMove(y), WTFMove(radiusX), WTFMove(radiusY), WTFMove(rotation), WTFMove(startAngle), WTFMove(endAngle), WTFMove(anticlockwise)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionEllipse(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionEllipseBody>(*lexicalGlobalObject, *callFrame, "ellipse");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetLineDashBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto segments = convert<IDLSequence<IDLUnrestrictedFloat>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setLineDash"_s, { segments });
    impl.setLineDash(WTFMove(segments));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineDash(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionSetLineDashBody>(*lexicalGlobalObject, *callFrame, "setLineDash");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionGetLineDashBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getLineDash"_s);
    return JSValue::encode(toJS<IDLSequence<IDLUnrestrictedFloat>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getLineDash()));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionGetLineDash(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionGetLineDashBody>(*lexicalGlobalObject, *callFrame, "getLineDash");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionClearRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto h = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "clearRect"_s, { x, y, w, h });
    impl.clearRect(WTFMove(x), WTFMove(y), WTFMove(w), WTFMove(h));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClearRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionClearRectBody>(*lexicalGlobalObject, *callFrame, "clearRect");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionFillRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto h = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "fillRect"_s, { x, y, w, h });
    impl.fillRect(WTFMove(x), WTFMove(y), WTFMove(w), WTFMove(h));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFillRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionFillRectBody>(*lexicalGlobalObject, *callFrame, "fillRect");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionStrokeRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto h = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "strokeRect"_s, { x, y, w, h });
    impl.strokeRect(WTFMove(x), WTFMove(y), WTFMove(w), WTFMove(h));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStrokeRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionStrokeRectBody>(*lexicalGlobalObject, *callFrame, "strokeRect");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSaveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "save"_s);
    impl.save();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSave(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionSaveBody>(*lexicalGlobalObject, *callFrame, "save");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionRestoreBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "restore"_s);
    impl.restore();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRestore(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionRestoreBody>(*lexicalGlobalObject, *callFrame, "restore");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionFillTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto text = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto maxWidth = callFrame->argument(3).isUndefined() ? Optional<Converter<IDLUnrestrictedFloat>::ReturnType>() : Optional<Converter<IDLUnrestrictedFloat>::ReturnType>(convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "fillText"_s, { text, x, y, maxWidth });
    impl.fillText(WTFMove(text), WTFMove(x), WTFMove(y), WTFMove(maxWidth));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFillText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionFillTextBody>(*lexicalGlobalObject, *callFrame, "fillText");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionStrokeTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto text = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto maxWidth = callFrame->argument(3).isUndefined() ? Optional<Converter<IDLUnrestrictedFloat>::ReturnType>() : Optional<Converter<IDLUnrestrictedFloat>::ReturnType>(convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "strokeText"_s, { text, x, y, maxWidth });
    impl.strokeText(WTFMove(text), WTFMove(x), WTFMove(y), WTFMove(maxWidth));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStrokeText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionStrokeTextBody>(*lexicalGlobalObject, *callFrame, "strokeText");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionMeasureTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto text = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "measureText"_s, { text });
    return JSValue::encode(toJS<IDLInterface<TextMetrics>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.measureText(WTFMove(text))));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionMeasureText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionMeasureTextBody>(*lexicalGlobalObject, *callFrame, "measureText");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionScaleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "scale"_s, { x, y });
    impl.scale(WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionScale(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionScaleBody>(*lexicalGlobalObject, *callFrame, "scale");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionRotateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto angle = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "rotate"_s, { angle });
    impl.rotate(WTFMove(angle));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRotate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionRotateBody>(*lexicalGlobalObject, *callFrame, "rotate");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionTranslateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "translate"_s, { x, y });
    impl.translate(WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionTranslate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionTranslateBody>(*lexicalGlobalObject, *callFrame, "translate");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionTransformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 6))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto a = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto b = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto c = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto d = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto e = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto f = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "transform"_s, { a, b, c, d, e, f });
    impl.transform(WTFMove(a), WTFMove(b), WTFMove(c), WTFMove(d), WTFMove(e), WTFMove(f));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionTransform(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionTransformBody>(*lexicalGlobalObject, *callFrame, "transform");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionGetTransformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "getTransform"_s);
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getTransform()));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionGetTransform(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionGetTransformBody>(*lexicalGlobalObject, *callFrame, "getTransform");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetTransform1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto a = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto b = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto c = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto d = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto e = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto f = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setTransform"_s, { a, b, c, d, e, f });
    impl.setTransform(WTFMove(a), WTFMove(b), WTFMove(c), WTFMove(d), WTFMove(e), WTFMove(f));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetTransform2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto transform = convert<IDLDictionary<DOMMatrix2DInit>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "setTransform"_s, { transform });
    propagateException(*lexicalGlobalObject, throwScope, impl.setTransform(WTFMove(transform)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionSetTransformOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(6, callFrame->argumentCount());
    if (argsCount == 0) {
        return jsCanvasRenderingContext2DPrototypeFunctionSetTransform2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 1) {
        return jsCanvasRenderingContext2DPrototypeFunctionSetTransform2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 6) {
        return jsCanvasRenderingContext2DPrototypeFunctionSetTransform1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetTransform(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionSetTransformOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "setTransform");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionResetTransformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "resetTransform"_s);
    impl.resetTransform();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionResetTransform(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionResetTransformBody>(*lexicalGlobalObject, *callFrame, "resetTransform");
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionDrawFocusIfNeeded1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "CanvasRenderingContext2D", "drawFocusIfNeeded", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "drawFocusIfNeeded"_s, { element });
    impl.drawFocusIfNeeded(*element);
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionDrawFocusIfNeeded2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto path = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path", "CanvasRenderingContext2D", "drawFocusIfNeeded", "Path2D"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "element", "CanvasRenderingContext2D", "drawFocusIfNeeded", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    if (UNLIKELY(impl.callTracingActive()))
        CallTracer::recordCanvasAction(impl, "drawFocusIfNeeded"_s, { path, element });
    impl.drawFocusIfNeeded(*path, *element);
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsCanvasRenderingContext2DPrototypeFunctionDrawFocusIfNeededOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCanvasRenderingContext2D>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 1) {
        return jsCanvasRenderingContext2DPrototypeFunctionDrawFocusIfNeeded1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 2) {
        return jsCanvasRenderingContext2DPrototypeFunctionDrawFocusIfNeeded2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawFocusIfNeeded(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCanvasRenderingContext2D>::call<jsCanvasRenderingContext2DPrototypeFunctionDrawFocusIfNeededOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "drawFocusIfNeeded");
}

void JSCanvasRenderingContext2D::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSCanvasRenderingContext2D*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSCanvasRenderingContext2D::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSCanvasRenderingContext2D*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSCanvasRenderingContext2D::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCanvasRenderingContext2D*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

void JSCanvasRenderingContext2DOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCanvasRenderingContext2D = static_cast<JSCanvasRenderingContext2D*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCanvasRenderingContext2D->wrapped(), jsCanvasRenderingContext2D);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CanvasRenderingContext2D@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore24CanvasRenderingContext2DE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CanvasRenderingContext2D>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7CanvasRenderingContext2D@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore24CanvasRenderingContext2DE[2];
#endif

    // If this fails CanvasRenderingContext2D does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<CanvasRenderingContext2D>::value, "CanvasRenderingContext2D is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // CanvasRenderingContext2D has subclasses. If CanvasRenderingContext2D has subclasses that get passed
    // to toJS() we currently require CanvasRenderingContext2D you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<CanvasRenderingContext2D>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CanvasRenderingContext2D& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CanvasRenderingContext2D* JSCanvasRenderingContext2D::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCanvasRenderingContext2D*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
