/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSClipboardItem.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "JSBlob.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "Navigator.h"
#include "ScriptExecutionContext.h"
#include "WorkerNavigator.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/Vector.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(ClipboardItem::PresentationStyle enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("unspecified"),
        MAKE_STATIC_STRING_IMPL("inline"),
        MAKE_STATIC_STRING_IMPL("attachment"),
    };
    static_assert(static_cast<size_t>(ClipboardItem::PresentationStyle::Unspecified) == 0, "ClipboardItem::PresentationStyle::Unspecified is not 0 as expected");
    static_assert(static_cast<size_t>(ClipboardItem::PresentationStyle::Inline) == 1, "ClipboardItem::PresentationStyle::Inline is not 1 as expected");
    static_assert(static_cast<size_t>(ClipboardItem::PresentationStyle::Attachment) == 2, "ClipboardItem::PresentationStyle::Attachment is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, ClipboardItem::PresentationStyle enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<ClipboardItem::PresentationStyle> parseEnumeration<ClipboardItem::PresentationStyle>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "unspecified")
        return ClipboardItem::PresentationStyle::Unspecified;
    if (stringValue == "inline")
        return ClipboardItem::PresentationStyle::Inline;
    if (stringValue == "attachment")
        return ClipboardItem::PresentationStyle::Attachment;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<ClipboardItem::PresentationStyle>()
{
    return "\"unspecified\", \"inline\", \"attachment\"";
}

template<> ClipboardItem::Options convertDictionary<ClipboardItem::Options>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    ClipboardItem::Options result;
    JSValue presentationStyleValue;
    if (isNullOrUndefined)
        presentationStyleValue = jsUndefined();
    else {
        presentationStyleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "presentationStyle"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!presentationStyleValue.isUndefined()) {
        result.presentationStyle = convert<IDLEnumeration<ClipboardItem::PresentationStyle>>(lexicalGlobalObject, presentationStyleValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.presentationStyle = ClipboardItem::PresentationStyle::Unspecified;
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsClipboardItemPrototypeFunctionGetType(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsClipboardItemConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSClipboardItemConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsClipboardItemTypes(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsClipboardItemPresentationStyle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSClipboardItemPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSClipboardItemPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSClipboardItemPrototype* ptr = new (NotNull, JSC::allocateCell<JSClipboardItemPrototype>(vm.heap)) JSClipboardItemPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSClipboardItemPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSClipboardItemPrototype, JSClipboardItemPrototype::Base);

using JSClipboardItemConstructor = JSDOMConstructor<JSClipboardItem>;

template<> EncodedJSValue JSC_HOST_CALL JSClipboardItemConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSClipboardItemConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto items = convert<IDLRecord<IDLDOMString, IDLPromise<IDLUnion<IDLDOMString, IDLInterface<Blob>>>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = convert<IDLDictionary<ClipboardItem::Options>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = ClipboardItem::create(WTFMove(items), WTFMove(options));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<ClipboardItem>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSClipboardItemConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSClipboardItemConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSClipboardItem::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("ClipboardItem"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSClipboardItemConstructor::s_info = { "ClipboardItem", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSClipboardItemConstructor) };

/* Hash table for prototype */

static const HashTableValue JSClipboardItemPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClipboardItemConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSClipboardItemConstructor) } },
    { "types", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClipboardItemTypes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "presentationStyle", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsClipboardItemPresentationStyle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "getType", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsClipboardItemPrototypeFunctionGetType), (intptr_t) (1) } },
};

const ClassInfo JSClipboardItemPrototype::s_info = { "ClipboardItemPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSClipboardItemPrototype) };

void JSClipboardItemPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSClipboardItem::info(), JSClipboardItemPrototypeTableValues, *this);
}

const ClassInfo JSClipboardItem::s_info = { "ClipboardItem", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSClipboardItem) };

JSClipboardItem::JSClipboardItem(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ClipboardItem>&& impl)
    : JSDOMWrapper<ClipboardItem>(structure, globalObject, WTFMove(impl))
{
}

void JSClipboardItem::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, ClipboardItem>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSClipboardItem::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSClipboardItemPrototype::create(vm, &globalObject, JSClipboardItemPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSClipboardItem::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSClipboardItem>(vm, globalObject);
}

JSValue JSClipboardItem::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSClipboardItemConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSClipboardItem::destroy(JSC::JSCell* cell)
{
    JSClipboardItem* thisObject = static_cast<JSClipboardItem*>(cell);
    thisObject->JSClipboardItem::~JSClipboardItem();
}

template<> inline JSClipboardItem* IDLAttribute<JSClipboardItem>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSClipboardItem*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSClipboardItem* IDLOperation<JSClipboardItem>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSClipboardItem*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsClipboardItemConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSClipboardItemPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSClipboardItem::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSClipboardItemConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSClipboardItemPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsClipboardItemTypesGetter(JSGlobalObject& lexicalGlobalObject, JSClipboardItem& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLFrozenArray<IDLDOMString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.types());
    return result;
}

EncodedJSValue jsClipboardItemTypes(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSClipboardItem>::get<jsClipboardItemTypesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "types");
}

static inline JSValue jsClipboardItemPresentationStyleGetter(JSGlobalObject& lexicalGlobalObject, JSClipboardItem& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<ClipboardItem::PresentationStyle>>(lexicalGlobalObject, throwScope, impl.presentationStyle());
    return result;
}

EncodedJSValue jsClipboardItemPresentationStyle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSClipboardItem>::get<jsClipboardItemPresentationStyleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "presentationStyle");
}

static inline JSC::EncodedJSValue jsClipboardItemPrototypeFunctionGetTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSClipboardItem>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.getType(WTFMove(type), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsClipboardItemPrototypeFunctionGetType(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSClipboardItem>::call<jsClipboardItemPrototypeFunctionGetTypeBody>(*lexicalGlobalObject, *callFrame, "getType");
}

void JSClipboardItem::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSClipboardItem*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSClipboardItemOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsClipboardItem = jsCast<JSClipboardItem*>(handle.slot()->asCell());
    NavigatorBase* root = WTF::getPtr(jsClipboardItem->wrapped().navigator());
    if (!root)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from Navigator";
    return visitor.containsOpaqueRoot(root);
}

void JSClipboardItemOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsClipboardItem = static_cast<JSClipboardItem*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsClipboardItem->wrapped(), jsClipboardItem);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ClipboardItem>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to ClipboardItem.
    static_assert(!std::is_polymorphic<ClipboardItem>::value, "ClipboardItem is polymorphic but the IDL claims it is not");
    return createWrapper<ClipboardItem>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ClipboardItem& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

ClipboardItem* JSClipboardItem::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSClipboardItem*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
