/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCommandLineAPIHost.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDatabase.h"
#include "JSEventTarget.h"
#include "JSStorage.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Vector.h>


namespace WebCore {
using namespace JSC;

template<> CommandLineAPIHost::ListenerEntry convertDictionary<CommandLineAPIHost::ListenerEntry>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    CommandLineAPIHost::ListenerEntry result;
    JSValue listenerValue;
    if (isNullOrUndefined)
        listenerValue = jsUndefined();
    else {
        listenerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "listener"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!listenerValue.isUndefined()) {
        result.listener = convert<IDLObject>(lexicalGlobalObject, listenerValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "listener", "ListenerEntry", "object");
        return { };
    }
    JSValue onceValue;
    if (isNullOrUndefined)
        onceValue = jsUndefined();
    else {
        onceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "once"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!onceValue.isUndefined()) {
        result.once = convert<IDLBoolean>(lexicalGlobalObject, onceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "once", "ListenerEntry", "boolean");
        return { };
    }
    JSValue passiveValue;
    if (isNullOrUndefined)
        passiveValue = jsUndefined();
    else {
        passiveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "passive"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!passiveValue.isUndefined()) {
        result.passive = convert<IDLBoolean>(lexicalGlobalObject, passiveValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "passive", "ListenerEntry", "boolean");
        return { };
    }
    JSValue useCaptureValue;
    if (isNullOrUndefined)
        useCaptureValue = jsUndefined();
    else {
        useCaptureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "useCapture"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!useCaptureValue.isUndefined()) {
        result.useCapture = convert<IDLBoolean>(lexicalGlobalObject, useCaptureValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "useCapture", "ListenerEntry", "boolean");
        return { };
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const CommandLineAPIHost::ListenerEntry& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto listenerValue = toJS<IDLObject>(dictionary.listener);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "listener"), listenerValue);
    auto onceValue = toJS<IDLBoolean>(dictionary.once);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "once"), onceValue);
    auto passiveValue = toJS<IDLBoolean>(dictionary.passive);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "passive"), passiveValue);
    auto useCaptureValue = toJS<IDLBoolean>(dictionary.useCapture);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "useCapture"), useCaptureValue);
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionClearConsoleMessages(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionCopyText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionInspect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionInspectedObject(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionGetEventListeners(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionDatabaseId(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionStorageId(JSC::JSGlobalObject*, JSC::CallFrame*);

class JSCommandLineAPIHostPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCommandLineAPIHostPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCommandLineAPIHostPrototype* ptr = new (NotNull, JSC::allocateCell<JSCommandLineAPIHostPrototype>(vm.heap)) JSCommandLineAPIHostPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCommandLineAPIHostPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCommandLineAPIHostPrototype, JSCommandLineAPIHostPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSCommandLineAPIHostPrototypeTableValues[] =
{
    { "clearConsoleMessages", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCommandLineAPIHostPrototypeFunctionClearConsoleMessages), (intptr_t) (0) } },
    { "copyText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCommandLineAPIHostPrototypeFunctionCopyText), (intptr_t) (1) } },
    { "inspect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCommandLineAPIHostPrototypeFunctionInspect), (intptr_t) (2) } },
    { "inspectedObject", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCommandLineAPIHostPrototypeFunctionInspectedObject), (intptr_t) (0) } },
    { "getEventListeners", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCommandLineAPIHostPrototypeFunctionGetEventListeners), (intptr_t) (1) } },
    { "databaseId", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCommandLineAPIHostPrototypeFunctionDatabaseId), (intptr_t) (1) } },
    { "storageId", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCommandLineAPIHostPrototypeFunctionStorageId), (intptr_t) (1) } },
};

const ClassInfo JSCommandLineAPIHostPrototype::s_info = { "CommandLineAPIHostPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCommandLineAPIHostPrototype) };

void JSCommandLineAPIHostPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCommandLineAPIHost::info(), JSCommandLineAPIHostPrototypeTableValues, *this);
}

const ClassInfo JSCommandLineAPIHost::s_info = { "CommandLineAPIHost", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCommandLineAPIHost) };

JSCommandLineAPIHost::JSCommandLineAPIHost(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CommandLineAPIHost>&& impl)
    : JSDOMWrapper<CommandLineAPIHost>(structure, globalObject, WTFMove(impl))
{
}

void JSCommandLineAPIHost::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, CommandLineAPIHost>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSCommandLineAPIHost::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSCommandLineAPIHostPrototype::create(vm, &globalObject, JSCommandLineAPIHostPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSCommandLineAPIHost::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCommandLineAPIHost>(vm, globalObject);
}

void JSCommandLineAPIHost::destroy(JSC::JSCell* cell)
{
    JSCommandLineAPIHost* thisObject = static_cast<JSCommandLineAPIHost*>(cell);
    thisObject->JSCommandLineAPIHost::~JSCommandLineAPIHost();
}

template<> inline JSCommandLineAPIHost* IDLOperation<JSCommandLineAPIHost>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSCommandLineAPIHost*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunctionClearConsoleMessagesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.clearConsoleMessages();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionClearConsoleMessages(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunctionClearConsoleMessagesBody>(*lexicalGlobalObject, *callFrame, "clearConsoleMessages");
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunctionCopyTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto text = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.copyText(WTFMove(text));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionCopyText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunctionCopyTextBody>(*lexicalGlobalObject, *callFrame, "copyText");
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunctionInspectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto objectToInspect = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto hints = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.inspect(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(objectToInspect), WTFMove(hints));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionInspect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunctionInspectBody>(*lexicalGlobalObject, *callFrame, "inspect");
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunctionInspectedObjectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLAny>(impl.inspectedObject(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject))));
}

EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionInspectedObject(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunctionInspectedObjectBody>(*lexicalGlobalObject, *callFrame, "inspectedObject");
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunctionGetEventListenersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLInterface<EventTarget>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target", "CommandLineAPIHost", "getEventListeners", "EventTarget"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLRecord<IDLDOMString, IDLSequence<IDLDictionary<CommandLineAPIHost::ListenerEntry>>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getEventListeners(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), *target)));
}

EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionGetEventListeners(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunctionGetEventListenersBody>(*lexicalGlobalObject, *callFrame, "getEventListeners");
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunctionDatabaseIdBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto database = convert<IDLInterface<Database>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "database", "CommandLineAPIHost", "databaseId", "Database"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.databaseId(*database)));
}

EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionDatabaseId(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunctionDatabaseIdBody>(*lexicalGlobalObject, *callFrame, "databaseId");
}

static inline JSC::EncodedJSValue jsCommandLineAPIHostPrototypeFunctionStorageIdBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCommandLineAPIHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto storage = convert<IDLInterface<Storage>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "storage", "CommandLineAPIHost", "storageId", "Storage"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.storageId(*storage)));
}

EncodedJSValue JSC_HOST_CALL jsCommandLineAPIHostPrototypeFunctionStorageId(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCommandLineAPIHost>::call<jsCommandLineAPIHostPrototypeFunctionStorageIdBody>(*lexicalGlobalObject, *callFrame, "storageId");
}

void JSCommandLineAPIHost::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCommandLineAPIHost*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSCommandLineAPIHostOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSCommandLineAPIHostOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCommandLineAPIHost = static_cast<JSCommandLineAPIHost*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCommandLineAPIHost->wrapped(), jsCommandLineAPIHost);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CommandLineAPIHost>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to CommandLineAPIHost.
    static_assert(!std::is_polymorphic<CommandLineAPIHost>::value, "CommandLineAPIHost is polymorphic but the IDL claims it is not");
    return createWrapper<CommandLineAPIHost>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CommandLineAPIHost& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CommandLineAPIHost* JSCommandLineAPIHost::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCommandLineAPIHost*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
