/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSConvolverNode.h"

#include "ActiveDOMObject.h"
#include "JSAudioBuffer.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsConvolverNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSConvolverNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsConvolverNodeBuffer(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSConvolverNodeBuffer(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsConvolverNodeNormalize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSConvolverNodeNormalize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSConvolverNodePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSConvolverNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSConvolverNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSConvolverNodePrototype>(vm.heap)) JSConvolverNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSConvolverNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSConvolverNodePrototype, JSConvolverNodePrototype::Base);

using JSConvolverNodeConstructor = JSDOMConstructorNotConstructable<JSConvolverNode>;

template<> JSValue JSConvolverNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSConvolverNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSConvolverNode::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("ConvolverNode"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSConvolverNodeConstructor::s_info = { "ConvolverNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSConvolverNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSConvolverNodePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsConvolverNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSConvolverNodeConstructor) } },
    { "buffer", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsConvolverNodeBuffer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSConvolverNodeBuffer) } },
    { "normalize", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsConvolverNodeNormalize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSConvolverNodeNormalize) } },
};

const ClassInfo JSConvolverNodePrototype::s_info = { "ConvolverNodePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSConvolverNodePrototype) };

void JSConvolverNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSConvolverNode::info(), JSConvolverNodePrototypeTableValues, *this);
}

const ClassInfo JSConvolverNode::s_info = { "ConvolverNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSConvolverNode) };

JSConvolverNode::JSConvolverNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ConvolverNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

void JSConvolverNode::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, ConvolverNode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSConvolverNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSConvolverNodePrototype::create(vm, &globalObject, JSConvolverNodePrototype::createStructure(vm, &globalObject, JSAudioNode::prototype(vm, globalObject)));
}

JSObject* JSConvolverNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSConvolverNode>(vm, globalObject);
}

JSValue JSConvolverNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSConvolverNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSConvolverNode* IDLAttribute<JSConvolverNode>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSConvolverNode*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsConvolverNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSConvolverNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSConvolverNode::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSConvolverNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSConvolverNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsConvolverNodeBufferGetter(JSGlobalObject& lexicalGlobalObject, JSConvolverNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<AudioBuffer>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.buffer());
    return result;
}

EncodedJSValue jsConvolverNodeBuffer(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSConvolverNode>::get<jsConvolverNodeBufferGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "buffer");
}

static inline bool setJSConvolverNodeBufferSetter(JSGlobalObject& lexicalGlobalObject, JSConvolverNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLInterface<AudioBuffer>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "ConvolverNode", "buffer", "AudioBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBuffer(WTFMove(nativeValue));
    });
    return true;
}

bool setJSConvolverNodeBuffer(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSConvolverNode>::set<setJSConvolverNodeBufferSetter>(*lexicalGlobalObject, thisValue, encodedValue, "buffer");
}

static inline JSValue jsConvolverNodeNormalizeGetter(JSGlobalObject& lexicalGlobalObject, JSConvolverNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.normalize());
    return result;
}

EncodedJSValue jsConvolverNodeNormalize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSConvolverNode>::get<jsConvolverNodeNormalizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "normalize");
}

static inline bool setJSConvolverNodeNormalizeSetter(JSGlobalObject& lexicalGlobalObject, JSConvolverNode& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setNormalize(WTFMove(nativeValue));
    });
    return true;
}

bool setJSConvolverNodeNormalize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSConvolverNode>::set<setJSConvolverNodeNormalizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "normalize");
}

void JSConvolverNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSConvolverNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ConvolverNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13ConvolverNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ConvolverNode>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7ConvolverNode@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore13ConvolverNodeE[2];
#endif

    // If this fails ConvolverNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<ConvolverNode>::value, "ConvolverNode is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // ConvolverNode has subclasses. If ConvolverNode has subclasses that get passed
    // to toJS() we currently require ConvolverNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<ConvolverNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ConvolverNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
