/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUTHN)

#include "JSCredentialCreationOptions.h"

#include "JSAbortSignal.h"
#include "JSDOMConvertInterface.h"
#include "JSPublicKeyCredentialCreationOptions.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUTHN)

template<> CredentialCreationOptions convertDictionary<CredentialCreationOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    CredentialCreationOptions result;
    JSValue publicKeyValue;
    if (isNullOrUndefined)
        publicKeyValue = jsUndefined();
    else {
        publicKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "publicKey"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!publicKeyValue.isUndefined()) {
        result.publicKey = convert<IDLDictionary<PublicKeyCredentialCreationOptions>>(lexicalGlobalObject, publicKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue signalValue;
    if (isNullOrUndefined)
        signalValue = jsUndefined();
    else {
        signalValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "signal"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!signalValue.isUndefined()) {
        result.signal = convert<IDLInterface<AbortSignal>>(lexicalGlobalObject, signalValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUTHN)
