/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCrypto.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(WEB_CRYPTO)
#include "JSDOMConvertInterface.h"
#include "JSDOMGlobalObject.h"
#include "JSSubtleCrypto.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCryptoPrototypeFunctionGetRandomValues(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsCryptoConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCryptoConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(WEB_CRYPTO)
JSC::EncodedJSValue jsCryptoSubtle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif

class JSCryptoPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCryptoPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCryptoPrototype* ptr = new (NotNull, JSC::allocateCell<JSCryptoPrototype>(vm.heap)) JSCryptoPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCryptoPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCryptoPrototype, JSCryptoPrototype::Base);

using JSCryptoConstructor = JSDOMConstructorNotConstructable<JSCrypto>;

template<> JSValue JSCryptoConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCryptoConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCrypto::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("Crypto"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSCryptoConstructor::s_info = { "Crypto", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCryptoConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCryptoPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCryptoConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCryptoConstructor) } },
#if ENABLE(WEB_CRYPTO)
    { "subtle", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCryptoSubtle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "getRandomValues", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCryptoPrototypeFunctionGetRandomValues), (intptr_t) (1) } },
};

const ClassInfo JSCryptoPrototype::s_info = { "CryptoPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCryptoPrototype) };

void JSCryptoPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCrypto::info(), JSCryptoPrototypeTableValues, *this);
}

const ClassInfo JSCrypto::s_info = { "Crypto", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCrypto) };

JSCrypto::JSCrypto(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Crypto>&& impl)
    : JSDOMWrapper<Crypto>(structure, globalObject, WTFMove(impl))
{
}

void JSCrypto::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, Crypto>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSCrypto::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSCryptoPrototype::create(vm, &globalObject, JSCryptoPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSCrypto::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCrypto>(vm, globalObject);
}

JSValue JSCrypto::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCryptoConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCrypto::destroy(JSC::JSCell* cell)
{
    JSCrypto* thisObject = static_cast<JSCrypto*>(cell);
    thisObject->JSCrypto::~JSCrypto();
}

template<> inline JSCrypto* IDLAttribute<JSCrypto>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSCrypto*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSCrypto* IDLOperation<JSCrypto>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSCrypto*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsCryptoConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCryptoPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCrypto::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSCryptoConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCryptoPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

#if ENABLE(WEB_CRYPTO)
static inline JSValue jsCryptoSubtleGetter(JSGlobalObject& lexicalGlobalObject, JSCrypto& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SubtleCrypto>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.subtle());
    return result;
}

EncodedJSValue jsCryptoSubtle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSCrypto>::get<jsCryptoSubtleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "subtle");
}

#endif

static inline JSC::EncodedJSValue jsCryptoPrototypeFunctionGetRandomValuesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCrypto>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto returnValue = callFrame->uncheckedArgument(0);
    auto array = convert<IDLArrayBufferView>(*lexicalGlobalObject, returnValue, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "array", "Crypto", "getRandomValues", "ArrayBufferView"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.getRandomValues(array.releaseNonNull()));
    return JSValue::encode(returnValue);
}

EncodedJSValue JSC_HOST_CALL jsCryptoPrototypeFunctionGetRandomValues(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCrypto>::call<jsCryptoPrototypeFunctionGetRandomValuesBody>(*lexicalGlobalObject, *callFrame, "getRandomValues");
}

void JSCrypto::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCrypto*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSCryptoOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsCrypto = jsCast<JSCrypto*>(handle.slot()->asCell());
    ScriptExecutionContext* root = WTF::getPtr(jsCrypto->wrapped().scriptExecutionContext());
    if (!root)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from ScriptExecutionContext";
    return visitor.containsOpaqueRoot(root);
}

void JSCryptoOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCrypto = static_cast<JSCrypto*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCrypto->wrapped(), jsCrypto);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Crypto@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore6CryptoE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<Crypto>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7Crypto@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore6CryptoE[2];
#endif

    // If this fails Crypto does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<Crypto>::value, "Crypto is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // Crypto has subclasses. If Crypto has subclasses that get passed
    // to toJS() we currently require Crypto you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<Crypto>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Crypto& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

Crypto* JSCrypto::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCrypto*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
