/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CRYPTO)

#include "JSCryptoKeyUsage.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(CryptoKeyUsage enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("encrypt"),
        MAKE_STATIC_STRING_IMPL("decrypt"),
        MAKE_STATIC_STRING_IMPL("sign"),
        MAKE_STATIC_STRING_IMPL("verify"),
        MAKE_STATIC_STRING_IMPL("deriveKey"),
        MAKE_STATIC_STRING_IMPL("deriveBits"),
        MAKE_STATIC_STRING_IMPL("wrapKey"),
        MAKE_STATIC_STRING_IMPL("unwrapKey"),
    };
    static_assert(static_cast<size_t>(CryptoKeyUsage::Encrypt) == 0, "CryptoKeyUsage::Encrypt is not 0 as expected");
    static_assert(static_cast<size_t>(CryptoKeyUsage::Decrypt) == 1, "CryptoKeyUsage::Decrypt is not 1 as expected");
    static_assert(static_cast<size_t>(CryptoKeyUsage::Sign) == 2, "CryptoKeyUsage::Sign is not 2 as expected");
    static_assert(static_cast<size_t>(CryptoKeyUsage::Verify) == 3, "CryptoKeyUsage::Verify is not 3 as expected");
    static_assert(static_cast<size_t>(CryptoKeyUsage::DeriveKey) == 4, "CryptoKeyUsage::DeriveKey is not 4 as expected");
    static_assert(static_cast<size_t>(CryptoKeyUsage::DeriveBits) == 5, "CryptoKeyUsage::DeriveBits is not 5 as expected");
    static_assert(static_cast<size_t>(CryptoKeyUsage::WrapKey) == 6, "CryptoKeyUsage::WrapKey is not 6 as expected");
    static_assert(static_cast<size_t>(CryptoKeyUsage::UnwrapKey) == 7, "CryptoKeyUsage::UnwrapKey is not 7 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, CryptoKeyUsage enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<CryptoKeyUsage> parseEnumeration<CryptoKeyUsage>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "encrypt")
        return CryptoKeyUsage::Encrypt;
    if (stringValue == "decrypt")
        return CryptoKeyUsage::Decrypt;
    if (stringValue == "sign")
        return CryptoKeyUsage::Sign;
    if (stringValue == "verify")
        return CryptoKeyUsage::Verify;
    if (stringValue == "deriveKey")
        return CryptoKeyUsage::DeriveKey;
    if (stringValue == "deriveBits")
        return CryptoKeyUsage::DeriveBits;
    if (stringValue == "wrapKey")
        return CryptoKeyUsage::WrapKey;
    if (stringValue == "unwrapKey")
        return CryptoKeyUsage::UnwrapKey;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<CryptoKeyUsage>()
{
    return "\"encrypt\", \"decrypt\", \"sign\", \"verify\", \"deriveKey\", \"deriveBits\", \"wrapKey\", \"unwrapKey\"";
}

} // namespace WebCore

#endif // ENABLE(WEB_CRYPTO)
