/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCustomElementRegistry.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsCustomElementRegistryPrototypeFunctionDefine(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCustomElementRegistryPrototypeFunctionGet(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCustomElementRegistryPrototypeFunctionWhenDefined(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsCustomElementRegistryPrototypeFunctionUpgrade(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsCustomElementRegistryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSCustomElementRegistryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSCustomElementRegistryPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCustomElementRegistryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCustomElementRegistryPrototype* ptr = new (NotNull, JSC::allocateCell<JSCustomElementRegistryPrototype>(vm.heap)) JSCustomElementRegistryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCustomElementRegistryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCustomElementRegistryPrototype, JSCustomElementRegistryPrototype::Base);

using JSCustomElementRegistryConstructor = JSDOMConstructorNotConstructable<JSCustomElementRegistry>;

template<> JSValue JSCustomElementRegistryConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSCustomElementRegistryConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSCustomElementRegistry::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("CustomElementRegistry"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSCustomElementRegistryConstructor::s_info = { "CustomElementRegistry", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCustomElementRegistryConstructor) };

/* Hash table for prototype */

static const HashTableValue JSCustomElementRegistryPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCustomElementRegistryConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSCustomElementRegistryConstructor) } },
    { "define", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCustomElementRegistryPrototypeFunctionDefine), (intptr_t) (2) } },
    { "get", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCustomElementRegistryPrototypeFunctionGet), (intptr_t) (1) } },
    { "whenDefined", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCustomElementRegistryPrototypeFunctionWhenDefined), (intptr_t) (1) } },
    { "upgrade", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsCustomElementRegistryPrototypeFunctionUpgrade), (intptr_t) (1) } },
};

const ClassInfo JSCustomElementRegistryPrototype::s_info = { "CustomElementRegistryPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCustomElementRegistryPrototype) };

void JSCustomElementRegistryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCustomElementRegistry::info(), JSCustomElementRegistryPrototypeTableValues, *this);
}

const ClassInfo JSCustomElementRegistry::s_info = { "CustomElementRegistry", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCustomElementRegistry) };

JSCustomElementRegistry::JSCustomElementRegistry(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CustomElementRegistry>&& impl)
    : JSDOMWrapper<CustomElementRegistry>(structure, globalObject, WTFMove(impl))
{
}

void JSCustomElementRegistry::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, CustomElementRegistry>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSCustomElementRegistry::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSCustomElementRegistryPrototype::create(vm, &globalObject, JSCustomElementRegistryPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSCustomElementRegistry::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCustomElementRegistry>(vm, globalObject);
}

JSValue JSCustomElementRegistry::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCustomElementRegistryConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSCustomElementRegistry::destroy(JSC::JSCell* cell)
{
    JSCustomElementRegistry* thisObject = static_cast<JSCustomElementRegistry*>(cell);
    thisObject->JSCustomElementRegistry::~JSCustomElementRegistry();
}

template<> inline JSCustomElementRegistry* IDLOperation<JSCustomElementRegistry>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSCustomElementRegistry*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsCustomElementRegistryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCustomElementRegistryPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCustomElementRegistry::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSCustomElementRegistryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCustomElementRegistryPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsCustomElementRegistryPrototypeFunctionDefineBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCustomElementRegistry>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    return JSValue::encode(castedThis->define(*lexicalGlobalObject, *callFrame));
}

EncodedJSValue JSC_HOST_CALL jsCustomElementRegistryPrototypeFunctionDefine(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCustomElementRegistry>::call<jsCustomElementRegistryPrototypeFunctionDefineBody>(*lexicalGlobalObject, *callFrame, "define");
}

static inline JSC::EncodedJSValue jsCustomElementRegistryPrototypeFunctionGetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCustomElementRegistry>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLAny>(impl.get(WTFMove(name))));
}

EncodedJSValue JSC_HOST_CALL jsCustomElementRegistryPrototypeFunctionGet(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCustomElementRegistry>::call<jsCustomElementRegistryPrototypeFunctionGetBody>(*lexicalGlobalObject, *callFrame, "get");
}

static inline JSC::EncodedJSValue jsCustomElementRegistryPrototypeFunctionWhenDefinedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSCustomElementRegistry>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    return JSValue::encode(castedThis->whenDefined(*lexicalGlobalObject, *callFrame));
}

EncodedJSValue JSC_HOST_CALL jsCustomElementRegistryPrototypeFunctionWhenDefined(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSCustomElementRegistry>::callReturningOwnPromise<jsCustomElementRegistryPrototypeFunctionWhenDefinedBody>(*lexicalGlobalObject, *callFrame, "whenDefined");
}

static inline JSC::EncodedJSValue jsCustomElementRegistryPrototypeFunctionUpgradeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCustomElementRegistry>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto root = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "root", "CustomElementRegistry", "upgrade", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.upgrade(*root);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCustomElementRegistryPrototypeFunctionUpgrade(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSCustomElementRegistry>::call<jsCustomElementRegistryPrototypeFunctionUpgradeBody>(*lexicalGlobalObject, *callFrame, "upgrade");
}

void JSCustomElementRegistry::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCustomElementRegistry*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSCustomElementRegistryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsCustomElementRegistry = jsCast<JSCustomElementRegistry*>(handle.slot()->asCell());
    ScriptExecutionContext* root = WTF::getPtr(jsCustomElementRegistry->wrapped().scriptExecutionContext());
    if (!root)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from ScriptExecutionContext";
    return visitor.containsOpaqueRoot(root);
}

void JSCustomElementRegistryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsCustomElementRegistry = static_cast<JSCustomElementRegistry*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsCustomElementRegistry->wrapped(), jsCustomElementRegistry);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CustomElementRegistry@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21CustomElementRegistryE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CustomElementRegistry>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7CustomElementRegistry@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore21CustomElementRegistryE[2];
#endif

    // If this fails CustomElementRegistry does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<CustomElementRegistry>::value, "CustomElementRegistry is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // CustomElementRegistry has subclasses. If CustomElementRegistry has subclasses that get passed
    // to toJS() we currently require CustomElementRegistry you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<CustomElementRegistry>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CustomElementRegistry& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CustomElementRegistry* JSCustomElementRegistry::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCustomElementRegistry*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
