/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMImplementation.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDocumentType.h"
#include "JSHTMLDocument.h"
#include "JSXMLDocument.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionCreateDocumentType(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionCreateDocument(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionCreateHTMLDocument(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionHasFeature(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsDOMImplementationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMImplementationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDOMImplementationPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMImplementationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMImplementationPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMImplementationPrototype>(vm.heap)) JSDOMImplementationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMImplementationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMImplementationPrototype, JSDOMImplementationPrototype::Base);

using JSDOMImplementationConstructor = JSDOMConstructorNotConstructable<JSDOMImplementation>;

template<> JSValue JSDOMImplementationConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMImplementationConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMImplementation::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("DOMImplementation"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSDOMImplementationConstructor::s_info = { "DOMImplementation", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMImplementationConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMImplementationPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMImplementationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMImplementationConstructor) } },
    { "createDocumentType", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMImplementationPrototypeFunctionCreateDocumentType), (intptr_t) (3) } },
    { "createDocument", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMImplementationPrototypeFunctionCreateDocument), (intptr_t) (2) } },
    { "createHTMLDocument", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMImplementationPrototypeFunctionCreateHTMLDocument), (intptr_t) (0) } },
    { "hasFeature", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMImplementationPrototypeFunctionHasFeature), (intptr_t) (0) } },
};

const ClassInfo JSDOMImplementationPrototype::s_info = { "DOMImplementationPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMImplementationPrototype) };

void JSDOMImplementationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMImplementation::info(), JSDOMImplementationPrototypeTableValues, *this);
}

const ClassInfo JSDOMImplementation::s_info = { "DOMImplementation", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMImplementation) };

JSDOMImplementation::JSDOMImplementation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMImplementation>&& impl)
    : JSDOMWrapper<DOMImplementation>(structure, globalObject, WTFMove(impl))
{
}

void JSDOMImplementation::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DOMImplementation>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDOMImplementation::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDOMImplementationPrototype::create(vm, &globalObject, JSDOMImplementationPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSDOMImplementation::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMImplementation>(vm, globalObject);
}

JSValue JSDOMImplementation::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMImplementationConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMImplementation::destroy(JSC::JSCell* cell)
{
    JSDOMImplementation* thisObject = static_cast<JSDOMImplementation*>(cell);
    thisObject->JSDOMImplementation::~JSDOMImplementation();
}

template<> inline JSDOMImplementation* IDLOperation<JSDOMImplementation>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSDOMImplementation*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsDOMImplementationConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMImplementationPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMImplementation::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDOMImplementationConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMImplementationPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsDOMImplementationPrototypeFunctionCreateDocumentTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMImplementation>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto qualifiedName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto publicId = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto systemId = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DocumentType>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createDocumentType(WTFMove(qualifiedName), WTFMove(publicId), WTFMove(systemId))));
}

EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionCreateDocumentType(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMImplementation>::call<jsDOMImplementationPrototypeFunctionCreateDocumentTypeBody>(*lexicalGlobalObject, *callFrame, "createDocumentType");
}

static inline JSC::EncodedJSValue jsDOMImplementationPrototypeFunctionCreateDocumentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMImplementation>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto namespaceURI = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto qualifiedName = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto doctype = convert<IDLNullable<IDLInterface<DocumentType>>>(*lexicalGlobalObject, callFrame->argument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "doctype", "DOMImplementation", "createDocument", "DocumentType"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<XMLDocument>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createDocument(WTFMove(namespaceURI), WTFMove(qualifiedName), WTFMove(doctype))));
}

EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionCreateDocument(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMImplementation>::call<jsDOMImplementationPrototypeFunctionCreateDocumentBody>(*lexicalGlobalObject, *callFrame, "createDocument");
}

static inline JSC::EncodedJSValue jsDOMImplementationPrototypeFunctionCreateHTMLDocumentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMImplementation>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto title = callFrame->argument(0).isUndefined() ? String() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<HTMLDocument>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createHTMLDocument(WTFMove(title))));
}

EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionCreateHTMLDocument(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMImplementation>::call<jsDOMImplementationPrototypeFunctionCreateHTMLDocumentBody>(*lexicalGlobalObject, *callFrame, "createHTMLDocument");
}

static inline JSC::EncodedJSValue jsDOMImplementationPrototypeFunctionHasFeatureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMImplementation>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.hasFeature()));
}

EncodedJSValue JSC_HOST_CALL jsDOMImplementationPrototypeFunctionHasFeature(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMImplementation>::call<jsDOMImplementationPrototypeFunctionHasFeatureBody>(*lexicalGlobalObject, *callFrame, "hasFeature");
}

void JSDOMImplementation::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMImplementation*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMImplementationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsDOMImplementation = jsCast<JSDOMImplementation*>(handle.slot()->asCell());
    Document* root = WTF::getPtr(jsDOMImplementation->wrapped().document());
    if (!root)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from Document";
    return visitor.containsOpaqueRoot(root);
}

void JSDOMImplementationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMImplementation = static_cast<JSDOMImplementation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMImplementation->wrapped(), jsDOMImplementation);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMImplementation>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DOMImplementation.
    static_assert(!std::is_polymorphic<DOMImplementation>::value, "DOMImplementation is polymorphic but the IDL claims it is not");
    return createWrapper<DOMImplementation>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMImplementation& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMImplementation* JSDOMImplementation::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMImplementation*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
