/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMMatrix.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMMatrix.h"
#include "JSDOMMatrixInit.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixConstructorFunctionFromMatrix(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixConstructorFunctionFromFloat32Array(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixConstructorFunctionFromFloat64Array(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionMultiplySelf(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionPreMultiplySelf(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionTranslateSelf(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionScaleSelf(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionScale3dSelf(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionRotateSelf(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionRotateFromVectorSelf(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionRotateAxisAngleSelf(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionSkewXSelf(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionSkewYSelf(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionInvertSelf(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionSetMatrixValue(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsDOMMatrixConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixA(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixA(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixB(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixB(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixC(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixC(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixD(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixD(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixE(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixE(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixF(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixF(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixM11(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixM11(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixM12(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixM12(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixM13(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixM13(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixM14(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixM14(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixM21(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixM21(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixM22(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixM22(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixM23(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixM23(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixM24(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixM24(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixM31(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixM31(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixM32(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixM32(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixM33(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixM33(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixM34(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixM34(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixM41(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixM41(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixM42(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixM42(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixM43(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixM43(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMMatrixM44(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMMatrixM44(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDOMMatrixPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMMatrixPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMMatrixPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMMatrixPrototype>(vm.heap)) JSDOMMatrixPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMMatrixPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMMatrixPrototype, JSDOMMatrixPrototype::Base);

using JSDOMMatrixConstructor = JSDOMConstructor<JSDOMMatrix>;

/* Hash table for constructor */

static const HashTableValue JSDOMMatrixConstructorTableValues[] =
{
    { "fromMatrix", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixConstructorFunctionFromMatrix), (intptr_t) (0) } },
    { "fromFloat32Array", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixConstructorFunctionFromFloat32Array), (intptr_t) (1) } },
    { "fromFloat64Array", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixConstructorFunctionFromFloat64Array), (intptr_t) (1) } },
};

template<> EncodedJSValue JSC_HOST_CALL JSDOMMatrixConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSDOMMatrixConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "DOMMatrix");
    auto init = callFrame->argument(0).isUndefined() ? Optional<Converter<IDLUnion<IDLDOMString, IDLSequence<IDLUnrestrictedDouble>>>::ReturnType>() : Optional<Converter<IDLUnion<IDLDOMString, IDLSequence<IDLUnrestrictedDouble>>>::ReturnType>(convert<IDLUnion<IDLDOMString, IDLSequence<IDLUnrestrictedDouble>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = DOMMatrix::create(*context, WTFMove(init));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> JSValue JSDOMMatrixConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSDOMMatrixReadOnly::getConstructor(vm, &globalObject);
}

template<> void JSDOMMatrixConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMMatrix::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("DOMMatrix"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSDOMMatrix::info(), JSDOMMatrixConstructorTableValues, *this);
}

template<> const ClassInfo JSDOMMatrixConstructor::s_info = { "DOMMatrix", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMatrixConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMMatrixPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixConstructor) } },
    { "a", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixA), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixA) } },
    { "b", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixB), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixB) } },
    { "c", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixC), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixC) } },
    { "d", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixD), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixD) } },
    { "e", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixE), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixE) } },
    { "f", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixF), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixF) } },
    { "m11", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixM11), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixM11) } },
    { "m12", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixM12), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixM12) } },
    { "m13", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixM13), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixM13) } },
    { "m14", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixM14), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixM14) } },
    { "m21", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixM21), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixM21) } },
    { "m22", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixM22), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixM22) } },
    { "m23", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixM23), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixM23) } },
    { "m24", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixM24), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixM24) } },
    { "m31", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixM31), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixM31) } },
    { "m32", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixM32), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixM32) } },
    { "m33", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixM33), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixM33) } },
    { "m34", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixM34), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixM34) } },
    { "m41", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixM41), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixM41) } },
    { "m42", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixM42), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixM42) } },
    { "m43", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixM43), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixM43) } },
    { "m44", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMMatrixM44), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMMatrixM44) } },
    { "multiplySelf", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixPrototypeFunctionMultiplySelf), (intptr_t) (0) } },
    { "preMultiplySelf", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixPrototypeFunctionPreMultiplySelf), (intptr_t) (0) } },
    { "translateSelf", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixPrototypeFunctionTranslateSelf), (intptr_t) (0) } },
    { "scaleSelf", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixPrototypeFunctionScaleSelf), (intptr_t) (0) } },
    { "scale3dSelf", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixPrototypeFunctionScale3dSelf), (intptr_t) (0) } },
    { "rotateSelf", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixPrototypeFunctionRotateSelf), (intptr_t) (0) } },
    { "rotateFromVectorSelf", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixPrototypeFunctionRotateFromVectorSelf), (intptr_t) (0) } },
    { "rotateAxisAngleSelf", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixPrototypeFunctionRotateAxisAngleSelf), (intptr_t) (0) } },
    { "skewXSelf", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixPrototypeFunctionSkewXSelf), (intptr_t) (0) } },
    { "skewYSelf", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixPrototypeFunctionSkewYSelf), (intptr_t) (0) } },
    { "invertSelf", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixPrototypeFunctionInvertSelf), (intptr_t) (0) } },
    { "setMatrixValue", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMMatrixPrototypeFunctionSetMatrixValue), (intptr_t) (1) } },
};

const ClassInfo JSDOMMatrixPrototype::s_info = { "DOMMatrixPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMatrixPrototype) };

void JSDOMMatrixPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMMatrix::info(), JSDOMMatrixPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isDocument()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("setMatrixValue"), strlen("setMatrixValue"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSDOMMatrix::s_info = { "DOMMatrix", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMMatrix) };

JSDOMMatrix::JSDOMMatrix(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMMatrix>&& impl)
    : JSDOMMatrixReadOnly(structure, globalObject, WTFMove(impl))
{
}

void JSDOMMatrix::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DOMMatrix>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDOMMatrix::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDOMMatrixPrototype::create(vm, &globalObject, JSDOMMatrixPrototype::createStructure(vm, &globalObject, JSDOMMatrixReadOnly::prototype(vm, globalObject)));
}

JSObject* JSDOMMatrix::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMMatrix>(vm, globalObject);
}

JSValue JSDOMMatrix::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMMatrixConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSDOMMatrix* IDLAttribute<JSDOMMatrix>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDOMMatrix*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSDOMMatrix* IDLOperation<JSDOMMatrix>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSDOMMatrix*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsDOMMatrixConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMMatrixPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMMatrix::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDOMMatrixConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMMatrixPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDOMMatrixAGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.a());
    return result;
}

EncodedJSValue jsDOMMatrixA(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixAGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "a");
}

static inline bool setJSDOMMatrixASetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setA(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixA(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixASetter>(*lexicalGlobalObject, thisValue, encodedValue, "a");
}

static inline JSValue jsDOMMatrixBGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.b());
    return result;
}

EncodedJSValue jsDOMMatrixB(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixBGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "b");
}

static inline bool setJSDOMMatrixBSetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setB(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixB(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixBSetter>(*lexicalGlobalObject, thisValue, encodedValue, "b");
}

static inline JSValue jsDOMMatrixCGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.c());
    return result;
}

EncodedJSValue jsDOMMatrixC(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixCGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "c");
}

static inline bool setJSDOMMatrixCSetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setC(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixC(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixCSetter>(*lexicalGlobalObject, thisValue, encodedValue, "c");
}

static inline JSValue jsDOMMatrixDGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.d());
    return result;
}

EncodedJSValue jsDOMMatrixD(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixDGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "d");
}

static inline bool setJSDOMMatrixDSetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setD(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixD(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixDSetter>(*lexicalGlobalObject, thisValue, encodedValue, "d");
}

static inline JSValue jsDOMMatrixEGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.e());
    return result;
}

EncodedJSValue jsDOMMatrixE(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixEGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "e");
}

static inline bool setJSDOMMatrixESetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setE(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixE(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixESetter>(*lexicalGlobalObject, thisValue, encodedValue, "e");
}

static inline JSValue jsDOMMatrixFGetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.f());
    return result;
}

EncodedJSValue jsDOMMatrixF(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixFGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "f");
}

static inline bool setJSDOMMatrixFSetter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setF(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixF(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixFSetter>(*lexicalGlobalObject, thisValue, encodedValue, "f");
}

static inline JSValue jsDOMMatrixM11Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m11());
    return result;
}

EncodedJSValue jsDOMMatrixM11(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixM11Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m11");
}

static inline bool setJSDOMMatrixM11Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM11(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixM11(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixM11Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m11");
}

static inline JSValue jsDOMMatrixM12Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m12());
    return result;
}

EncodedJSValue jsDOMMatrixM12(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixM12Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m12");
}

static inline bool setJSDOMMatrixM12Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM12(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixM12(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixM12Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m12");
}

static inline JSValue jsDOMMatrixM13Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m13());
    return result;
}

EncodedJSValue jsDOMMatrixM13(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixM13Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m13");
}

static inline bool setJSDOMMatrixM13Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM13(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixM13(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixM13Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m13");
}

static inline JSValue jsDOMMatrixM14Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m14());
    return result;
}

EncodedJSValue jsDOMMatrixM14(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixM14Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m14");
}

static inline bool setJSDOMMatrixM14Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM14(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixM14(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixM14Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m14");
}

static inline JSValue jsDOMMatrixM21Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m21());
    return result;
}

EncodedJSValue jsDOMMatrixM21(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixM21Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m21");
}

static inline bool setJSDOMMatrixM21Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM21(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixM21(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixM21Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m21");
}

static inline JSValue jsDOMMatrixM22Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m22());
    return result;
}

EncodedJSValue jsDOMMatrixM22(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixM22Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m22");
}

static inline bool setJSDOMMatrixM22Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM22(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixM22(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixM22Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m22");
}

static inline JSValue jsDOMMatrixM23Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m23());
    return result;
}

EncodedJSValue jsDOMMatrixM23(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixM23Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m23");
}

static inline bool setJSDOMMatrixM23Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM23(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixM23(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixM23Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m23");
}

static inline JSValue jsDOMMatrixM24Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m24());
    return result;
}

EncodedJSValue jsDOMMatrixM24(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixM24Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m24");
}

static inline bool setJSDOMMatrixM24Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM24(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixM24(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixM24Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m24");
}

static inline JSValue jsDOMMatrixM31Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m31());
    return result;
}

EncodedJSValue jsDOMMatrixM31(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixM31Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m31");
}

static inline bool setJSDOMMatrixM31Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM31(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixM31(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixM31Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m31");
}

static inline JSValue jsDOMMatrixM32Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m32());
    return result;
}

EncodedJSValue jsDOMMatrixM32(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixM32Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m32");
}

static inline bool setJSDOMMatrixM32Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM32(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixM32(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixM32Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m32");
}

static inline JSValue jsDOMMatrixM33Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m33());
    return result;
}

EncodedJSValue jsDOMMatrixM33(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixM33Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m33");
}

static inline bool setJSDOMMatrixM33Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM33(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixM33(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixM33Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m33");
}

static inline JSValue jsDOMMatrixM34Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m34());
    return result;
}

EncodedJSValue jsDOMMatrixM34(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixM34Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m34");
}

static inline bool setJSDOMMatrixM34Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM34(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixM34(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixM34Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m34");
}

static inline JSValue jsDOMMatrixM41Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m41());
    return result;
}

EncodedJSValue jsDOMMatrixM41(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixM41Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m41");
}

static inline bool setJSDOMMatrixM41Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM41(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixM41(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixM41Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m41");
}

static inline JSValue jsDOMMatrixM42Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m42());
    return result;
}

EncodedJSValue jsDOMMatrixM42(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixM42Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m42");
}

static inline bool setJSDOMMatrixM42Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM42(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixM42(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixM42Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m42");
}

static inline JSValue jsDOMMatrixM43Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m43());
    return result;
}

EncodedJSValue jsDOMMatrixM43(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixM43Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m43");
}

static inline bool setJSDOMMatrixM43Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM43(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixM43(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixM43Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m43");
}

static inline JSValue jsDOMMatrixM44Getter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.m44());
    return result;
}

EncodedJSValue jsDOMMatrixM44(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMMatrix>::get<jsDOMMatrixM44Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "m44");
}

static inline bool setJSDOMMatrixM44Setter(JSGlobalObject& lexicalGlobalObject, JSDOMMatrix& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setM44(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMMatrixM44(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMMatrix>::set<setJSDOMMatrixM44Setter>(*lexicalGlobalObject, thisValue, encodedValue, "m44");
}

static inline JSC::EncodedJSValue jsDOMMatrixConstructorFunctionFromMatrixBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto other = convert<IDLDictionary<DOMMatrixInit>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, DOMMatrix::fromMatrix(WTFMove(other))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixConstructorFunctionFromMatrix(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrix>::callStatic<jsDOMMatrixConstructorFunctionFromMatrixBody>(*lexicalGlobalObject, *callFrame, "fromMatrix");
}

static inline JSC::EncodedJSValue jsDOMMatrixConstructorFunctionFromFloat32ArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto array32 = convert<IDLFloat32Array>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "array32", "DOMMatrix", "fromFloat32Array", "Float32Array"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, DOMMatrix::fromFloat32Array(array32.releaseNonNull())));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixConstructorFunctionFromFloat32Array(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrix>::callStatic<jsDOMMatrixConstructorFunctionFromFloat32ArrayBody>(*lexicalGlobalObject, *callFrame, "fromFloat32Array");
}

static inline JSC::EncodedJSValue jsDOMMatrixConstructorFunctionFromFloat64ArrayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto array64 = convert<IDLFloat64Array>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "array64", "DOMMatrix", "fromFloat64Array", "Float64Array"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, DOMMatrix::fromFloat64Array(array64.releaseNonNull())));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixConstructorFunctionFromFloat64Array(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrix>::callStatic<jsDOMMatrixConstructorFunctionFromFloat64ArrayBody>(*lexicalGlobalObject, *callFrame, "fromFloat64Array");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunctionMultiplySelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto other = convert<IDLDictionary<DOMMatrixInit>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.multiplySelf(WTFMove(other))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionMultiplySelf(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunctionMultiplySelfBody>(*lexicalGlobalObject, *callFrame, "multiplySelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunctionPreMultiplySelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto other = convert<IDLDictionary<DOMMatrixInit>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.preMultiplySelf(WTFMove(other))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionPreMultiplySelf(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunctionPreMultiplySelfBody>(*lexicalGlobalObject, *callFrame, "preMultiplySelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunctionTranslateSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto tx = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto ty = callFrame->argument(1).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto tz = callFrame->argument(2).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.translateSelf(WTFMove(tx), WTFMove(ty), WTFMove(tz))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionTranslateSelf(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunctionTranslateSelfBody>(*lexicalGlobalObject, *callFrame, "translateSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunctionScaleSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto scaleX = callFrame->argument(0).isUndefined() ? 1 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto scaleY = callFrame->argument(1).isUndefined() ? Optional<Converter<IDLUnrestrictedDouble>::ReturnType>() : Optional<Converter<IDLUnrestrictedDouble>::ReturnType>(convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto scaleZ = callFrame->argument(2).isUndefined() ? 1 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto originX = callFrame->argument(3).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto originY = callFrame->argument(4).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto originZ = callFrame->argument(5).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.scaleSelf(WTFMove(scaleX), WTFMove(scaleY), WTFMove(scaleZ), WTFMove(originX), WTFMove(originY), WTFMove(originZ))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionScaleSelf(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunctionScaleSelfBody>(*lexicalGlobalObject, *callFrame, "scaleSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunctionScale3dSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto scale = callFrame->argument(0).isUndefined() ? 1 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto originX = callFrame->argument(1).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto originY = callFrame->argument(2).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto originZ = callFrame->argument(3).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.scale3dSelf(WTFMove(scale), WTFMove(originX), WTFMove(originY), WTFMove(originZ))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionScale3dSelf(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunctionScale3dSelfBody>(*lexicalGlobalObject, *callFrame, "scale3dSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunctionRotateSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto rotX = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto rotY = callFrame->argument(1).isUndefined() ? Optional<Converter<IDLUnrestrictedDouble>::ReturnType>() : Optional<Converter<IDLUnrestrictedDouble>::ReturnType>(convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto rotZ = callFrame->argument(2).isUndefined() ? Optional<Converter<IDLUnrestrictedDouble>::ReturnType>() : Optional<Converter<IDLUnrestrictedDouble>::ReturnType>(convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.rotateSelf(WTFMove(rotX), WTFMove(rotY), WTFMove(rotZ))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionRotateSelf(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunctionRotateSelfBody>(*lexicalGlobalObject, *callFrame, "rotateSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunctionRotateFromVectorSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = callFrame->argument(1).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.rotateFromVectorSelf(WTFMove(x), WTFMove(y))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionRotateFromVectorSelf(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunctionRotateFromVectorSelfBody>(*lexicalGlobalObject, *callFrame, "rotateFromVectorSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunctionRotateAxisAngleSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto x = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = callFrame->argument(1).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = callFrame->argument(2).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto angle = callFrame->argument(3).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.rotateAxisAngleSelf(WTFMove(x), WTFMove(y), WTFMove(z), WTFMove(angle))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionRotateAxisAngleSelf(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunctionRotateAxisAngleSelfBody>(*lexicalGlobalObject, *callFrame, "rotateAxisAngleSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunctionSkewXSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto sx = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.skewXSelf(WTFMove(sx))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionSkewXSelf(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunctionSkewXSelfBody>(*lexicalGlobalObject, *callFrame, "skewXSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunctionSkewYSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto sy = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.skewYSelf(WTFMove(sy))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionSkewYSelf(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunctionSkewYSelfBody>(*lexicalGlobalObject, *callFrame, "skewYSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunctionInvertSelfBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.invertSelf()));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionInvertSelf(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunctionInvertSelfBody>(*lexicalGlobalObject, *callFrame, "invertSelf");
}

static inline JSC::EncodedJSValue jsDOMMatrixPrototypeFunctionSetMatrixValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMMatrix>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto transformList = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.setMatrixValueForBindings(WTFMove(transformList))));
}

EncodedJSValue JSC_HOST_CALL jsDOMMatrixPrototypeFunctionSetMatrixValue(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMMatrix>::call<jsDOMMatrixPrototypeFunctionSetMatrixValueBody>(*lexicalGlobalObject, *callFrame, "setMatrixValue");
}

void JSDOMMatrix::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMMatrix*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMMatrix>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DOMMatrix.
    static_assert(!std::is_polymorphic<DOMMatrix>::value, "DOMMatrix is polymorphic but the IDL claims it is not");
    return createWrapper<DOMMatrix>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMMatrix& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
