/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMPoint.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMPoint.h"
#include "JSDOMPointInit.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMPointConstructorFunctionFromPoint(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsDOMPointConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMPointConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMPointX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMPointX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMPointY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMPointY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMPointZ(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMPointZ(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMPointW(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMPointW(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSDOMPointPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMPointPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMPointPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMPointPrototype>(vm.heap)) JSDOMPointPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMPointPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMPointPrototype, JSDOMPointPrototype::Base);

using JSDOMPointConstructor = JSDOMConstructor<JSDOMPoint>;

/* Hash table for constructor */

static const HashTableValue JSDOMPointConstructorTableValues[] =
{
    { "fromPoint", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMPointConstructorFunctionFromPoint), (intptr_t) (0) } },
};

static inline EncodedJSValue constructJSDOMPoint1(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSDOMPointConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto point = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = DOMPoint::create(WTFMove(point));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

static inline EncodedJSValue constructJSDOMPoint2(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSDOMPointConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto x = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = callFrame->argument(1).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = callFrame->argument(2).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = callFrame->argument(3).isUndefined() ? 1 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = DOMPoint::create(WTFMove(x), WTFMove(y), WTFMove(z), WTFMove(w));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> EncodedJSValue JSC_HOST_CALL JSDOMPointConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 0) {
        return constructJSDOMPoint2(lexicalGlobalObject, callFrame);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return constructJSDOMPoint2(lexicalGlobalObject, callFrame);
        if (distinguishingArg.isUndefinedOrNull())
            return constructJSDOMPoint1(lexicalGlobalObject, callFrame);
        if (distinguishingArg.isObject())
            return constructJSDOMPoint1(lexicalGlobalObject, callFrame);
        if (distinguishingArg.isNumber())
            return constructJSDOMPoint2(lexicalGlobalObject, callFrame);
        return constructJSDOMPoint2(lexicalGlobalObject, callFrame);
    }
    if (argsCount == 2) {
        return constructJSDOMPoint2(lexicalGlobalObject, callFrame);
    }
    if (argsCount == 3) {
        return constructJSDOMPoint2(lexicalGlobalObject, callFrame);
    }
    if (argsCount == 4) {
        return constructJSDOMPoint2(lexicalGlobalObject, callFrame);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

template<> JSValue JSDOMPointConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSDOMPointReadOnly::getConstructor(vm, &globalObject);
}

template<> void JSDOMPointConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMPoint::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("DOMPoint"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSDOMPoint::info(), JSDOMPointConstructorTableValues, *this);
}

template<> const ClassInfo JSDOMPointConstructor::s_info = { "DOMPoint", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMPointConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMPointPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPointConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMPointConstructor) } },
    { "x", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPointX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMPointX) } },
    { "y", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPointY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMPointY) } },
    { "z", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPointZ), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMPointZ) } },
    { "w", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPointW), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMPointW) } },
};

const ClassInfo JSDOMPointPrototype::s_info = { "DOMPointPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMPointPrototype) };

void JSDOMPointPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMPoint::info(), JSDOMPointPrototypeTableValues, *this);
}

const ClassInfo JSDOMPoint::s_info = { "DOMPoint", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMPoint) };

JSDOMPoint::JSDOMPoint(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMPoint>&& impl)
    : JSDOMPointReadOnly(structure, globalObject, WTFMove(impl))
{
}

void JSDOMPoint::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DOMPoint>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDOMPoint::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDOMPointPrototype::create(vm, &globalObject, JSDOMPointPrototype::createStructure(vm, &globalObject, JSDOMPointReadOnly::prototype(vm, globalObject)));
}

JSObject* JSDOMPoint::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMPoint>(vm, globalObject);
}

JSValue JSDOMPoint::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMPointConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSDOMPoint* IDLAttribute<JSDOMPoint>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDOMPoint*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSDOMPoint* IDLOperation<JSDOMPoint>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSDOMPoint*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsDOMPointConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMPointPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMPoint::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDOMPointConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMPointPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDOMPointXGetter(JSGlobalObject& lexicalGlobalObject, JSDOMPoint& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.x());
    return result;
}

EncodedJSValue jsDOMPointX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMPoint>::get<jsDOMPointXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "x");
}

static inline bool setJSDOMPointXSetter(JSGlobalObject& lexicalGlobalObject, JSDOMPoint& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setX(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMPointX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMPoint>::set<setJSDOMPointXSetter>(*lexicalGlobalObject, thisValue, encodedValue, "x");
}

static inline JSValue jsDOMPointYGetter(JSGlobalObject& lexicalGlobalObject, JSDOMPoint& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.y());
    return result;
}

EncodedJSValue jsDOMPointY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMPoint>::get<jsDOMPointYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "y");
}

static inline bool setJSDOMPointYSetter(JSGlobalObject& lexicalGlobalObject, JSDOMPoint& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setY(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMPointY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMPoint>::set<setJSDOMPointYSetter>(*lexicalGlobalObject, thisValue, encodedValue, "y");
}

static inline JSValue jsDOMPointZGetter(JSGlobalObject& lexicalGlobalObject, JSDOMPoint& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.z());
    return result;
}

EncodedJSValue jsDOMPointZ(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMPoint>::get<jsDOMPointZGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "z");
}

static inline bool setJSDOMPointZSetter(JSGlobalObject& lexicalGlobalObject, JSDOMPoint& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setZ(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMPointZ(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMPoint>::set<setJSDOMPointZSetter>(*lexicalGlobalObject, thisValue, encodedValue, "z");
}

static inline JSValue jsDOMPointWGetter(JSGlobalObject& lexicalGlobalObject, JSDOMPoint& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.w());
    return result;
}

EncodedJSValue jsDOMPointW(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMPoint>::get<jsDOMPointWGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "w");
}

static inline bool setJSDOMPointWSetter(JSGlobalObject& lexicalGlobalObject, JSDOMPoint& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setW(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMPointW(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMPoint>::set<setJSDOMPointWSetter>(*lexicalGlobalObject, thisValue, encodedValue, "w");
}

static inline JSC::EncodedJSValue jsDOMPointConstructorFunctionFromPointBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto other = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMPoint>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), DOMPoint::fromPoint(WTFMove(other))));
}

EncodedJSValue JSC_HOST_CALL jsDOMPointConstructorFunctionFromPoint(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMPoint>::callStatic<jsDOMPointConstructorFunctionFromPointBody>(*lexicalGlobalObject, *callFrame, "fromPoint");
}

void JSDOMPoint::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMPoint*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMPointOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsDOMPoint = jsCast<JSDOMPoint*>(handle.slot()->asCell());
    DOMPoint* root = &jsDOMPoint->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from DOMPoint";
    return visitor.containsOpaqueRoot(root);
}

void JSDOMPointOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMPoint = static_cast<JSDOMPoint*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMPoint->wrapped(), jsDOMPoint);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMPoint>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DOMPoint.
    static_assert(!std::is_polymorphic<DOMPoint>::value, "DOMPoint is polymorphic but the IDL claims it is not");
    return createWrapper<DOMPoint>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMPoint& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
