/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMPointReadOnly.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMMatrixInit.h"
#include "JSDOMOperation.h"
#include "JSDOMPoint.h"
#include "JSDOMPointInit.h"
#include "JSDOMPointReadOnly.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMPointReadOnlyConstructorFunctionFromPoint(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMPointReadOnlyPrototypeFunctionMatrixTransform(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMPointReadOnlyPrototypeFunctionToJSON(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsDOMPointReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMPointReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMPointReadOnlyX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMPointReadOnlyY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMPointReadOnlyZ(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMPointReadOnlyW(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSDOMPointReadOnlyPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDOMPointReadOnlyPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMPointReadOnlyPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMPointReadOnlyPrototype>(vm.heap)) JSDOMPointReadOnlyPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDOMPointReadOnlyPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDOMPointReadOnlyPrototype, JSDOMPointReadOnlyPrototype::Base);

using JSDOMPointReadOnlyConstructor = JSDOMConstructor<JSDOMPointReadOnly>;

/* Hash table for constructor */

static const HashTableValue JSDOMPointReadOnlyConstructorTableValues[] =
{
    { "fromPoint", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMPointReadOnlyConstructorFunctionFromPoint), (intptr_t) (0) } },
};

static inline EncodedJSValue constructJSDOMPointReadOnly1(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSDOMPointReadOnlyConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto point = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = DOMPointReadOnly::create(WTFMove(point));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMPointReadOnly>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

static inline EncodedJSValue constructJSDOMPointReadOnly2(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSDOMPointReadOnlyConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto x = callFrame->argument(0).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = callFrame->argument(1).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto z = callFrame->argument(2).isUndefined() ? 0 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = callFrame->argument(3).isUndefined() ? 1 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = DOMPointReadOnly::create(WTFMove(x), WTFMove(y), WTFMove(z), WTFMove(w));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMPointReadOnly>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> EncodedJSValue JSC_HOST_CALL JSDOMPointReadOnlyConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 0) {
        return constructJSDOMPointReadOnly2(lexicalGlobalObject, callFrame);
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            return constructJSDOMPointReadOnly2(lexicalGlobalObject, callFrame);
        if (distinguishingArg.isUndefinedOrNull())
            return constructJSDOMPointReadOnly1(lexicalGlobalObject, callFrame);
        if (distinguishingArg.isObject())
            return constructJSDOMPointReadOnly1(lexicalGlobalObject, callFrame);
        if (distinguishingArg.isNumber())
            return constructJSDOMPointReadOnly2(lexicalGlobalObject, callFrame);
        return constructJSDOMPointReadOnly2(lexicalGlobalObject, callFrame);
    }
    if (argsCount == 2) {
        return constructJSDOMPointReadOnly2(lexicalGlobalObject, callFrame);
    }
    if (argsCount == 3) {
        return constructJSDOMPointReadOnly2(lexicalGlobalObject, callFrame);
    }
    if (argsCount == 4) {
        return constructJSDOMPointReadOnly2(lexicalGlobalObject, callFrame);
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

template<> JSValue JSDOMPointReadOnlyConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSDOMPointReadOnlyConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSDOMPointReadOnly::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("DOMPointReadOnly"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSDOMPointReadOnly::info(), JSDOMPointReadOnlyConstructorTableValues, *this);
}

template<> const ClassInfo JSDOMPointReadOnlyConstructor::s_info = { "DOMPointReadOnly", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMPointReadOnlyConstructor) };

/* Hash table for prototype */

static const HashTableValue JSDOMPointReadOnlyPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPointReadOnlyConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMPointReadOnlyConstructor) } },
    { "x", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPointReadOnlyX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "y", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPointReadOnlyY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "z", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPointReadOnlyZ), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "w", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPointReadOnlyW), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "matrixTransform", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMPointReadOnlyPrototypeFunctionMatrixTransform), (intptr_t) (0) } },
    { "toJSON", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMPointReadOnlyPrototypeFunctionToJSON), (intptr_t) (0) } },
};

const ClassInfo JSDOMPointReadOnlyPrototype::s_info = { "DOMPointReadOnlyPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMPointReadOnlyPrototype) };

void JSDOMPointReadOnlyPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDOMPointReadOnly::info(), JSDOMPointReadOnlyPrototypeTableValues, *this);
}

const ClassInfo JSDOMPointReadOnly::s_info = { "DOMPointReadOnly", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMPointReadOnly) };

JSDOMPointReadOnly::JSDOMPointReadOnly(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DOMPointReadOnly>&& impl)
    : JSDOMWrapper<DOMPointReadOnly>(structure, globalObject, WTFMove(impl))
{
}

void JSDOMPointReadOnly::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, DOMPointReadOnly>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSDOMPointReadOnly::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSDOMPointReadOnlyPrototype::create(vm, &globalObject, JSDOMPointReadOnlyPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSDOMPointReadOnly::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDOMPointReadOnly>(vm, globalObject);
}

JSValue JSDOMPointReadOnly::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMPointReadOnlyConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSDOMPointReadOnly::destroy(JSC::JSCell* cell)
{
    JSDOMPointReadOnly* thisObject = static_cast<JSDOMPointReadOnly*>(cell);
    thisObject->JSDOMPointReadOnly::~JSDOMPointReadOnly();
}

template<> inline JSDOMPointReadOnly* IDLAttribute<JSDOMPointReadOnly>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSDOMPointReadOnly*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSDOMPointReadOnly* IDLOperation<JSDOMPointReadOnly>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSDOMPointReadOnly*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsDOMPointReadOnlyConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMPointReadOnlyPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMPointReadOnly::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDOMPointReadOnlyConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMPointReadOnlyPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDOMPointReadOnlyXGetter(JSGlobalObject& lexicalGlobalObject, JSDOMPointReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.x());
    return result;
}

EncodedJSValue jsDOMPointReadOnlyX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMPointReadOnly>::get<jsDOMPointReadOnlyXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "x");
}

static inline JSValue jsDOMPointReadOnlyYGetter(JSGlobalObject& lexicalGlobalObject, JSDOMPointReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.y());
    return result;
}

EncodedJSValue jsDOMPointReadOnlyY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMPointReadOnly>::get<jsDOMPointReadOnlyYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "y");
}

static inline JSValue jsDOMPointReadOnlyZGetter(JSGlobalObject& lexicalGlobalObject, JSDOMPointReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.z());
    return result;
}

EncodedJSValue jsDOMPointReadOnlyZ(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMPointReadOnly>::get<jsDOMPointReadOnlyZGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "z");
}

static inline JSValue jsDOMPointReadOnlyWGetter(JSGlobalObject& lexicalGlobalObject, JSDOMPointReadOnly& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.w());
    return result;
}

EncodedJSValue jsDOMPointReadOnlyW(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMPointReadOnly>::get<jsDOMPointReadOnlyWGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "w");
}

static inline JSC::EncodedJSValue jsDOMPointReadOnlyConstructorFunctionFromPointBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto other = convert<IDLDictionary<DOMPointInit>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<DOMPointReadOnly>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), DOMPointReadOnly::fromPoint(WTFMove(other))));
}

EncodedJSValue JSC_HOST_CALL jsDOMPointReadOnlyConstructorFunctionFromPoint(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMPointReadOnly>::callStatic<jsDOMPointReadOnlyConstructorFunctionFromPointBody>(*lexicalGlobalObject, *callFrame, "fromPoint");
}

static inline JSC::EncodedJSValue jsDOMPointReadOnlyPrototypeFunctionMatrixTransformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSDOMPointReadOnly>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto matrix = convert<IDLDictionary<DOMMatrixInit>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DOMPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.matrixTransform(WTFMove(matrix))));
}

EncodedJSValue JSC_HOST_CALL jsDOMPointReadOnlyPrototypeFunctionMatrixTransform(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMPointReadOnly>::call<jsDOMPointReadOnlyPrototypeFunctionMatrixTransformBody>(*lexicalGlobalObject, *callFrame, "matrixTransform");
}

JSC::JSObject* JSDOMPointReadOnly::serialize(JSGlobalObject& lexicalGlobalObject, JSDOMPointReadOnly& thisObject, JSDOMGlobalObject& globalObject, ThrowScope& throwScope)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto* result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto xValue = jsDOMPointReadOnlyXGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "x"), xValue);

    auto yValue = jsDOMPointReadOnlyYGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "y"), yValue);

    auto zValue = jsDOMPointReadOnlyZGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "z"), zValue);

    auto wValue = jsDOMPointReadOnlyWGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "w"), wValue);

    return result;
}

static inline EncodedJSValue jsDOMPointReadOnlyPrototypeFunctionToJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSDOMPointReadOnly* thisObject, JSC::ThrowScope& throwScope)
{
    return JSValue::encode(JSDOMPointReadOnly::serialize(*lexicalGlobalObject, *thisObject, *thisObject->globalObject(), throwScope));
}

EncodedJSValue JSC_HOST_CALL jsDOMPointReadOnlyPrototypeFunctionToJSON(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSDOMPointReadOnly>::call<jsDOMPointReadOnlyPrototypeFunctionToJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

void JSDOMPointReadOnly::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDOMPointReadOnly*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSDOMPointReadOnlyOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSDOMPointReadOnlyOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsDOMPointReadOnly = static_cast<JSDOMPointReadOnly*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsDOMPointReadOnly->wrapped(), jsDOMPointReadOnly);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DOMPointReadOnly>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to DOMPointReadOnly.
    static_assert(!std::is_polymorphic<DOMPointReadOnly>::value, "DOMPointReadOnly is polymorphic but the IDL claims it is not");
    return createWrapper<DOMPointReadOnly>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DOMPointReadOnly& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

DOMPointReadOnly* JSDOMPointReadOnly::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSDOMPointReadOnly*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
