/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMWindow.h"

#include "ActiveDOMObject.h"
#include "DOMWindowCaches.h"
#include "DOMWindowFetch.h"
#include "DOMWrapperWorld.h"
#include "Document.h"
#include "EventNames.h"
#include "JSAbortController.h"
#include "JSAbortSignal.h"
#include "JSAnimationEffect.h"
#include "JSAnimationEvent.h"
#include "JSAnimationPlaybackEvent.h"
#include "JSAnimationTimeline.h"
#include "JSAttr.h"
#include "JSBarProp.h"
#include "JSBeforeLoadEvent.h"
#include "JSBeforeUnloadEvent.h"
#include "JSBlob.h"
#include "JSCDATASection.h"
#include "JSCSSAnimation.h"
#include "JSCSSFontFaceRule.h"
#include "JSCSSImportRule.h"
#include "JSCSSKeyframeRule.h"
#include "JSCSSKeyframesRule.h"
#include "JSCSSMediaRule.h"
#include "JSCSSNamespaceRule.h"
#include "JSCSSPageRule.h"
#include "JSCSSRule.h"
#include "JSCSSRuleList.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSStyleRule.h"
#include "JSCSSStyleSheet.h"
#include "JSCSSSupportsRule.h"
#include "JSCSSTransition.h"
#include "JSCanvasGradient.h"
#include "JSCanvasPattern.h"
#include "JSCanvasRenderingContext2D.h"
#include "JSCharacterData.h"
#include "JSClipboard.h"
#include "JSClipboardEvent.h"
#include "JSClipboardItem.h"
#include "JSCloseEvent.h"
#include "JSComment.h"
#include "JSCompositionEvent.h"
#include "JSCrypto.h"
#include "JSCustomElementRegistry.h"
#include "JSCustomEvent.h"
#include "JSDOMApplicationCache.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMBindingSecurity.h"
#include "JSDOMCSSNamespace.h"
#include "JSDOMCache.h"
#include "JSDOMCacheStorage.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertScheduledAction.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertVariadic.h"
#include "JSDOMException.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMFileSystem.h"
#include "JSDOMFormData.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMImplementation.h"
#include "JSDOMMatrix.h"
#include "JSDOMMatrixReadOnly.h"
#include "JSDOMMimeType.h"
#include "JSDOMMimeTypeArray.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMParser.h"
#include "JSDOMPlugin.h"
#include "JSDOMPluginArray.h"
#include "JSDOMPoint.h"
#include "JSDOMPointReadOnly.h"
#include "JSDOMQuad.h"
#include "JSDOMRect.h"
#include "JSDOMRectList.h"
#include "JSDOMRectReadOnly.h"
#include "JSDOMSelection.h"
#include "JSDOMStringList.h"
#include "JSDOMStringMap.h"
#include "JSDOMTokenList.h"
#include "JSDOMURL.h"
#include "JSDOMWindow.h"
#include "JSDOMWrapperCache.h"
#include "JSDataTransfer.h"
#include "JSDataTransferItem.h"
#include "JSDataTransferItemList.h"
#include "JSDatabase.h"
#include "JSDeprecatedCSSOMCounter.h"
#include "JSDeprecatedCSSOMPrimitiveValue.h"
#include "JSDeprecatedCSSOMRGBColor.h"
#include "JSDeprecatedCSSOMRect.h"
#include "JSDeprecatedCSSOMValue.h"
#include "JSDeprecatedCSSOMValueList.h"
#include "JSDocument.h"
#include "JSDocumentFragment.h"
#include "JSDocumentTimeline.h"
#include "JSDocumentType.h"
#include "JSDragEvent.h"
#include "JSElement.h"
#include "JSErrorEvent.h"
#include "JSErrorHandler.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSEventSource.h"
#include "JSEventTarget.h"
#include "JSFetchHeaders.h"
#include "JSFetchRequest.h"
#include "JSFetchRequestInit.h"
#include "JSFetchResponse.h"
#include "JSFile.h"
#include "JSFileError.h"
#include "JSFileList.h"
#include "JSFileReader.h"
#include "JSFileSystemDirectoryEntry.h"
#include "JSFileSystemDirectoryReader.h"
#include "JSFileSystemEntry.h"
#include "JSFileSystemFileEntry.h"
#include "JSFocusEvent.h"
#include "JSFontFace.h"
#include "JSFontFaceSet.h"
#include "JSHTMLAllCollection.h"
#include "JSHTMLAnchorElement.h"
#include "JSHTMLAppletElement.h"
#include "JSHTMLAreaElement.h"
#include "JSHTMLBRElement.h"
#include "JSHTMLBaseElement.h"
#include "JSHTMLBodyElement.h"
#include "JSHTMLButtonElement.h"
#include "JSHTMLCanvasElement.h"
#include "JSHTMLCollection.h"
#include "JSHTMLDListElement.h"
#include "JSHTMLDataElement.h"
#include "JSHTMLDetailsElement.h"
#include "JSHTMLDialogElement.h"
#include "JSHTMLDirectoryElement.h"
#include "JSHTMLDivElement.h"
#include "JSHTMLDocument.h"
#include "JSHTMLElement.h"
#include "JSHTMLEmbedElement.h"
#include "JSHTMLFieldSetElement.h"
#include "JSHTMLFontElement.h"
#include "JSHTMLFormControlsCollection.h"
#include "JSHTMLFormElement.h"
#include "JSHTMLFrameElement.h"
#include "JSHTMLFrameSetElement.h"
#include "JSHTMLHRElement.h"
#include "JSHTMLHeadElement.h"
#include "JSHTMLHeadingElement.h"
#include "JSHTMLHtmlElement.h"
#include "JSHTMLIFrameElement.h"
#include "JSHTMLImageElement.h"
#include "JSHTMLInputElement.h"
#include "JSHTMLKeygenElement.h"
#include "JSHTMLLIElement.h"
#include "JSHTMLLabelElement.h"
#include "JSHTMLLegendElement.h"
#include "JSHTMLLinkElement.h"
#include "JSHTMLMapElement.h"
#include "JSHTMLMarqueeElement.h"
#include "JSHTMLMenuElement.h"
#include "JSHTMLMenuItemElement.h"
#include "JSHTMLMetaElement.h"
#include "JSHTMLModElement.h"
#include "JSHTMLOListElement.h"
#include "JSHTMLObjectElement.h"
#include "JSHTMLOptGroupElement.h"
#include "JSHTMLOptionElement.h"
#include "JSHTMLOptionsCollection.h"
#include "JSHTMLOutputElement.h"
#include "JSHTMLParagraphElement.h"
#include "JSHTMLParamElement.h"
#include "JSHTMLPictureElement.h"
#include "JSHTMLPreElement.h"
#include "JSHTMLProgressElement.h"
#include "JSHTMLQuoteElement.h"
#include "JSHTMLScriptElement.h"
#include "JSHTMLSelectElement.h"
#include "JSHTMLSlotElement.h"
#include "JSHTMLSourceElement.h"
#include "JSHTMLSpanElement.h"
#include "JSHTMLStyleElement.h"
#include "JSHTMLTableCaptionElement.h"
#include "JSHTMLTableCellElement.h"
#include "JSHTMLTableColElement.h"
#include "JSHTMLTableElement.h"
#include "JSHTMLTableRowElement.h"
#include "JSHTMLTableSectionElement.h"
#include "JSHTMLTemplateElement.h"
#include "JSHTMLTextAreaElement.h"
#include "JSHTMLTimeElement.h"
#include "JSHTMLTitleElement.h"
#include "JSHTMLUListElement.h"
#include "JSHTMLUnknownElement.h"
#include "JSHTMLVideoElement.h"
#include "JSHashChangeEvent.h"
#include "JSHighlightMap.h"
#include "JSHighlightRangeGroup.h"
#include "JSHistory.h"
#include "JSIdleDeadline.h"
#include "JSIdleRequestCallback.h"
#include "JSIdleRequestOptions.h"
#include "JSImageBitmap.h"
#include "JSImageBitmapOptions.h"
#include "JSImageBitmapRenderingContext.h"
#include "JSImageData.h"
#include "JSInputEvent.h"
#include "JSKeyboardEvent.h"
#include "JSKeyframeEffect.h"
#include "JSLocation.h"
#include "JSMediaCapabilities.h"
#include "JSMediaList.h"
#include "JSMediaQueryList.h"
#include "JSMessageEvent.h"
#include "JSMessagePort.h"
#include "JSMouseEvent.h"
#include "JSMutationEvent.h"
#include "JSMutationObserver.h"
#include "JSMutationRecord.h"
#include "JSNamedNodeMap.h"
#include "JSNavigator.h"
#include "JSNode.h"
#include "JSNodeFilter.h"
#include "JSNodeIterator.h"
#include "JSNodeList.h"
#include "JSOverflowEvent.h"
#include "JSPageTransitionEvent.h"
#include "JSPath2D.h"
#include "JSPerformance.h"
#include "JSPerformanceEntry.h"
#include "JSPerformanceMark.h"
#include "JSPerformanceMeasure.h"
#include "JSPerformanceNavigation.h"
#include "JSPerformanceObserver.h"
#include "JSPerformanceObserverEntryList.h"
#include "JSPerformanceResourceTiming.h"
#include "JSPerformanceServerTiming.h"
#include "JSPerformanceTiming.h"
#include "JSPopStateEvent.h"
#include "JSProcessingInstruction.h"
#include "JSProgressEvent.h"
#include "JSPromiseRejectionEvent.h"
#include "JSRadioNodeList.h"
#include "JSRange.h"
#include "JSRequestAnimationFrameCallback.h"
#include "JSSQLError.h"
#include "JSSQLResultSet.h"
#include "JSSQLResultSetRowList.h"
#include "JSSQLTransaction.h"
#include "JSSVGAElement.h"
#include "JSSVGAngle.h"
#include "JSSVGAnimateColorElement.h"
#include "JSSVGAnimateElement.h"
#include "JSSVGAnimateMotionElement.h"
#include "JSSVGAnimateTransformElement.h"
#include "JSSVGAnimatedAngle.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedInteger.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedLengthList.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedNumberList.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGAnimationElement.h"
#include "JSSVGCircleElement.h"
#include "JSSVGClipPathElement.h"
#include "JSSVGComponentTransferFunctionElement.h"
#include "JSSVGCursorElement.h"
#include "JSSVGDefsElement.h"
#include "JSSVGDescElement.h"
#include "JSSVGElement.h"
#include "JSSVGEllipseElement.h"
#include "JSSVGFEBlendElement.h"
#include "JSSVGFEColorMatrixElement.h"
#include "JSSVGFEComponentTransferElement.h"
#include "JSSVGFECompositeElement.h"
#include "JSSVGFEConvolveMatrixElement.h"
#include "JSSVGFEDiffuseLightingElement.h"
#include "JSSVGFEDisplacementMapElement.h"
#include "JSSVGFEDistantLightElement.h"
#include "JSSVGFEDropShadowElement.h"
#include "JSSVGFEFloodElement.h"
#include "JSSVGFEFuncAElement.h"
#include "JSSVGFEFuncBElement.h"
#include "JSSVGFEFuncGElement.h"
#include "JSSVGFEFuncRElement.h"
#include "JSSVGFEGaussianBlurElement.h"
#include "JSSVGFEImageElement.h"
#include "JSSVGFEMergeElement.h"
#include "JSSVGFEMergeNodeElement.h"
#include "JSSVGFEMorphologyElement.h"
#include "JSSVGFEOffsetElement.h"
#include "JSSVGFEPointLightElement.h"
#include "JSSVGFESpecularLightingElement.h"
#include "JSSVGFESpotLightElement.h"
#include "JSSVGFETileElement.h"
#include "JSSVGFETurbulenceElement.h"
#include "JSSVGFilterElement.h"
#include "JSSVGForeignObjectElement.h"
#include "JSSVGGElement.h"
#include "JSSVGGeometryElement.h"
#include "JSSVGGradientElement.h"
#include "JSSVGGraphicsElement.h"
#include "JSSVGImageElement.h"
#include "JSSVGLength.h"
#include "JSSVGLengthList.h"
#include "JSSVGLineElement.h"
#include "JSSVGLinearGradientElement.h"
#include "JSSVGMPathElement.h"
#include "JSSVGMarkerElement.h"
#include "JSSVGMaskElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGMetadataElement.h"
#include "JSSVGNumber.h"
#include "JSSVGNumberList.h"
#include "JSSVGPathElement.h"
#include "JSSVGPathSeg.h"
#include "JSSVGPathSegArcAbs.h"
#include "JSSVGPathSegArcRel.h"
#include "JSSVGPathSegClosePath.h"
#include "JSSVGPathSegCurvetoCubicAbs.h"
#include "JSSVGPathSegCurvetoCubicRel.h"
#include "JSSVGPathSegCurvetoCubicSmoothAbs.h"
#include "JSSVGPathSegCurvetoCubicSmoothRel.h"
#include "JSSVGPathSegCurvetoQuadraticAbs.h"
#include "JSSVGPathSegCurvetoQuadraticRel.h"
#include "JSSVGPathSegCurvetoQuadraticSmoothAbs.h"
#include "JSSVGPathSegCurvetoQuadraticSmoothRel.h"
#include "JSSVGPathSegLinetoAbs.h"
#include "JSSVGPathSegLinetoHorizontalAbs.h"
#include "JSSVGPathSegLinetoHorizontalRel.h"
#include "JSSVGPathSegLinetoRel.h"
#include "JSSVGPathSegLinetoVerticalAbs.h"
#include "JSSVGPathSegLinetoVerticalRel.h"
#include "JSSVGPathSegList.h"
#include "JSSVGPathSegMovetoAbs.h"
#include "JSSVGPathSegMovetoRel.h"
#include "JSSVGPatternElement.h"
#include "JSSVGPoint.h"
#include "JSSVGPointList.h"
#include "JSSVGPolygonElement.h"
#include "JSSVGPolylineElement.h"
#include "JSSVGPreserveAspectRatio.h"
#include "JSSVGRadialGradientElement.h"
#include "JSSVGRect.h"
#include "JSSVGRectElement.h"
#include "JSSVGRenderingIntent.h"
#include "JSSVGSVGElement.h"
#include "JSSVGScriptElement.h"
#include "JSSVGSetElement.h"
#include "JSSVGStopElement.h"
#include "JSSVGStringList.h"
#include "JSSVGStyleElement.h"
#include "JSSVGSwitchElement.h"
#include "JSSVGSymbolElement.h"
#include "JSSVGTRefElement.h"
#include "JSSVGTSpanElement.h"
#include "JSSVGTextContentElement.h"
#include "JSSVGTextElement.h"
#include "JSSVGTextPathElement.h"
#include "JSSVGTextPositioningElement.h"
#include "JSSVGTitleElement.h"
#include "JSSVGTransform.h"
#include "JSSVGTransformList.h"
#include "JSSVGUnitTypes.h"
#include "JSSVGUseElement.h"
#include "JSSVGViewElement.h"
#include "JSSVGViewSpec.h"
#include "JSSVGZoomEvent.h"
#include "JSScreen.h"
#include "JSScrollToOptions.h"
#include "JSSecurityPolicyViolationEvent.h"
#include "JSShadowRoot.h"
#include "JSStaticRange.h"
#include "JSStorage.h"
#include "JSStorageEvent.h"
#include "JSStyleMedia.h"
#include "JSStyleSheet.h"
#include "JSStyleSheetList.h"
#include "JSText.h"
#include "JSTextDecoder.h"
#include "JSTextEncoder.h"
#include "JSTextEvent.h"
#include "JSTextMetrics.h"
#include "JSTransitionEvent.h"
#include "JSTreeWalker.h"
#include "JSTypedOMCSSImageValue.h"
#include "JSUIEvent.h"
#include "JSURLSearchParams.h"
#include "JSUndoItem.h"
#include "JSUndoManager.h"
#include "JSValidityState.h"
#include "JSVisualViewport.h"
#include "JSWebAnimation.h"
#include "JSWebKitAnimationEvent.h"
#include "JSWebKitCSSMatrix.h"
#include "JSWebKitPoint.h"
#include "JSWebKitTransitionEvent.h"
#include "JSWebSocket.h"
#include "JSWheelEvent.h"
#include "JSWindowProxy.h"
#include "JSWorker.h"
#include "JSXMLDocument.h"
#include "JSXMLHttpRequest.h"
#include "JSXMLHttpRequestEventTarget.h"
#include "JSXMLHttpRequestProgressEvent.h"
#include "JSXMLHttpRequestUpload.h"
#include "JSXMLSerializer.h"
#include "JSXPathEvaluator.h"
#include "JSXPathExpression.h"
#include "JSXPathResult.h"
#include "Quirks.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/Variant.h>

#if ENABLE(ATTACHMENT_ELEMENT)
#include "JSHTMLAttachmentElement.h"
#endif

#if ENABLE(CHANNEL_MESSAGING)
#include "JSMessageChannel.h"
#endif

#if ENABLE(CSS_DEVICE_ADAPTATION)
#include "JSWebKitCSSViewportRule.h"
#endif

#if ENABLE(CSS_PAINTING_API)
#include "JSPaintRenderingContext2D.h"
#include "JSWorklet.h"
#endif

#if ENABLE(CSS_TYPED_OM)
#include "JSStylePropertyMap.h"
#include "JSStylePropertyMapReadOnly.h"
#include "JSTypedOMCSSNumericValue.h"
#include "JSTypedOMCSSStyleValue.h"
#include "JSTypedOMCSSUnitValue.h"
#include "JSTypedOMCSSUnparsedValue.h"
#endif

#if ENABLE(DATALIST_ELEMENT)
#include "JSHTMLDataListElement.h"
#endif

#if ENABLE(DEVICE_ORIENTATION)
#include "JSDeviceMotionEvent.h"
#include "JSDeviceOrientationEvent.h"
#endif

#if ENABLE(GEOLOCATION)
#include "JSGeolocation.h"
#include "JSGeolocationCoordinates.h"
#include "JSGeolocationPosition.h"
#include "JSGeolocationPositionError.h"
#endif

#if ENABLE(INDEXED_DATABASE)
#include "DOMWindowIndexedDatabase.h"
#include "JSIDBCursor.h"
#include "JSIDBCursorWithValue.h"
#include "JSIDBDatabase.h"
#include "JSIDBFactory.h"
#include "JSIDBIndex.h"
#include "JSIDBKeyRange.h"
#include "JSIDBObjectStore.h"
#include "JSIDBOpenDBRequest.h"
#include "JSIDBRequest.h"
#include "JSIDBTransaction.h"
#include "JSIDBVersionChangeEvent.h"
#endif

#if ENABLE(INTERSECTION_OBSERVER)
#include "JSIntersectionObserver.h"
#include "JSIntersectionObserverEntry.h"
#endif

#if ENABLE(MATHML)
#include "JSMathMLElement.h"
#include "JSMathMLMathElement.h"
#endif

#if ENABLE(MEDIA_SESSION)
#include "JSMediaRemoteControls.h"
#include "JSMediaSession.h"
#endif

#if ENABLE(MEDIA_SOURCE)
#include "JSMediaSource.h"
#include "JSSourceBuffer.h"
#include "JSSourceBufferList.h"
#endif

#if ENABLE(MEDIA_STREAM)
#include "JSBlobEvent.h"
#include "JSCanvasCaptureMediaStreamTrack.h"
#include "JSMediaDeviceInfo.h"
#include "JSMediaDevices.h"
#include "JSMediaRecorder.h"
#include "JSMediaRecorderErrorEvent.h"
#include "JSMediaStream.h"
#include "JSMediaStreamTrack.h"
#include "JSMediaStreamTrackEvent.h"
#include "JSOverconstrainedError.h"
#include "JSOverconstrainedErrorEvent.h"
#endif

#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_AUDIO)
#include "JSMediaStreamAudioDestinationNode.h"
#include "JSMediaStreamAudioSourceNode.h"
#endif

#if ENABLE(METER_ELEMENT)
#include "JSHTMLMeterElement.h"
#endif

#if ENABLE(NOTIFICATIONS)
#include "JSNotification.h"
#endif

#if ENABLE(OFFSCREEN_CANVAS)
#include "JSOffscreenCanvas.h"
#include "JSOffscreenCanvasRenderingContext2D.h"
#endif

#if ENABLE(PAYMENT_REQUEST)
#include "JSMerchantValidationEvent.h"
#include "JSPaymentAddress.h"
#include "JSPaymentMethodChangeEvent.h"
#include "JSPaymentRequest.h"
#include "JSPaymentRequestUpdateEvent.h"
#include "JSPaymentResponse.h"
#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
#include "JSEnterPictureInPictureEvent.h"
#include "JSPictureInPictureWindow.h"
#endif

#if ENABLE(POINTER_EVENTS)
#include "JSPointerEvent.h"
#endif

#if ENABLE(RESIZE_OBSERVER)
#include "JSResizeObserver.h"
#include "JSResizeObserverEntry.h"
#endif

#if ENABLE(SERVICE_WORKER)
#include "JSServiceWorker.h"
#include "JSServiceWorkerContainer.h"
#include "JSServiceWorkerRegistration.h"
#endif

#if ENABLE(SPEECH_SYNTHESIS)
#include "DOMWindowSpeechSynthesis.h"
#include "JSSpeechSynthesis.h"
#include "JSSpeechSynthesisEvent.h"
#include "JSSpeechSynthesisUtterance.h"
#endif

#if ENABLE(STREAMS_API)
#include "JSByteLengthQueuingStrategy.h"
#include "JSCountQueuingStrategy.h"
#include "JSReadableByteStreamController.h"
#include "JSReadableStream.h"
#include "JSReadableStreamBYOBReader.h"
#include "JSReadableStreamBYOBRequest.h"
#include "JSReadableStreamDefaultController.h"
#include "JSReadableStreamDefaultReader.h"
#include "JSWritableStream.h"
#endif

#if ENABLE(SVG_FONTS)
#include "JSSVGAltGlyphDefElement.h"
#include "JSSVGAltGlyphElement.h"
#include "JSSVGAltGlyphItemElement.h"
#include "JSSVGFontElement.h"
#include "JSSVGFontFaceElement.h"
#include "JSSVGFontFaceFormatElement.h"
#include "JSSVGFontFaceNameElement.h"
#include "JSSVGFontFaceSrcElement.h"
#include "JSSVGFontFaceUriElement.h"
#include "JSSVGGlyphElement.h"
#include "JSSVGGlyphRefElement.h"
#include "JSSVGHKernElement.h"
#include "JSSVGMissingGlyphElement.h"
#include "JSSVGVKernElement.h"
#endif

#if ENABLE(TOUCH_EVENTS)
#include "JSTouch.h"
#include "JSTouchEvent.h"
#include "JSTouchList.h"
#endif

#if ENABLE(USER_MESSAGE_HANDLERS)
#include "JSUserMessageHandler.h"
#include "JSUserMessageHandlersNamespace.h"
#include "JSWebKitNamespace.h"
#endif

#if ENABLE(VIDEO)
#include "JSHTMLAudioElement.h"
#include "JSHTMLMediaElement.h"
#include "JSMediaController.h"
#include "JSMediaError.h"
#include "JSTimeRanges.h"
#endif

#if ENABLE(VIDEO) && ENABLE(WEB_AUDIO)
#include "JSMediaElementAudioSourceNode.h"
#endif

#if ENABLE(VIDEO_TRACK)
#include "JSAudioTrack.h"
#include "JSAudioTrackList.h"
#include "JSDataCue.h"
#include "JSHTMLTrackElement.h"
#include "JSTextTrack.h"
#include "JSTextTrackCue.h"
#include "JSTextTrackCueList.h"
#include "JSTextTrackList.h"
#include "JSTrackEvent.h"
#include "JSVTTCue.h"
#include "JSVTTRegion.h"
#include "JSVideoTrack.h"
#include "JSVideoTrackList.h"
#endif

#if ENABLE(WEBGL)
#include "JSWebGLActiveInfo.h"
#include "JSWebGLBuffer.h"
#include "JSWebGLContextEvent.h"
#include "JSWebGLFramebuffer.h"
#include "JSWebGLProgram.h"
#include "JSWebGLQuery.h"
#include "JSWebGLRenderbuffer.h"
#include "JSWebGLRenderingContext.h"
#include "JSWebGLSampler.h"
#include "JSWebGLShader.h"
#include "JSWebGLShaderPrecisionFormat.h"
#include "JSWebGLSync.h"
#include "JSWebGLTexture.h"
#include "JSWebGLTransformFeedback.h"
#include "JSWebGLUniformLocation.h"
#endif

#if ENABLE(WEBGL2)
#include "JSWebGL2RenderingContext.h"
#include "JSWebGLVertexArrayObject.h"
#endif

#if ENABLE(WEBGPU)
#include "JSGPUBufferUsage.h"
#include "JSGPUCanvasContext.h"
#include "JSGPUColorWrite.h"
#include "JSGPUOutOfMemoryError.h"
#include "JSGPUShaderStage.h"
#include "JSGPUTextureUsage.h"
#include "JSGPUUncapturedErrorEvent.h"
#include "JSGPUValidationError.h"
#include "JSWebGPU.h"
#include "JSWebGPUAdapter.h"
#include "JSWebGPUBindGroup.h"
#include "JSWebGPUBindGroupLayout.h"
#include "JSWebGPUBuffer.h"
#include "JSWebGPUCommandBuffer.h"
#include "JSWebGPUCommandEncoder.h"
#include "JSWebGPUComputePassEncoder.h"
#include "JSWebGPUComputePipeline.h"
#include "JSWebGPUDevice.h"
#include "JSWebGPUPipelineLayout.h"
#include "JSWebGPUProgrammablePassEncoder.h"
#include "JSWebGPUQueue.h"
#include "JSWebGPURenderPassEncoder.h"
#include "JSWebGPURenderPipeline.h"
#include "JSWebGPUSampler.h"
#include "JSWebGPUShaderModule.h"
#include "JSWebGPUSwapChain.h"
#include "JSWebGPUTexture.h"
#include "JSWebGPUTextureView.h"
#endif

#if ENABLE(WEB_AUDIO)
#include "JSAnalyserNode.h"
#include "JSAudioBuffer.h"
#include "JSAudioBufferSourceNode.h"
#include "JSAudioContext.h"
#include "JSAudioDestinationNode.h"
#include "JSAudioListener.h"
#include "JSAudioNode.h"
#include "JSAudioParam.h"
#include "JSAudioProcessingEvent.h"
#include "JSBiquadFilterNode.h"
#include "JSChannelMergerNode.h"
#include "JSChannelSplitterNode.h"
#include "JSConvolverNode.h"
#include "JSDelayNode.h"
#include "JSDynamicsCompressorNode.h"
#include "JSGainNode.h"
#include "JSOfflineAudioCompletionEvent.h"
#include "JSOfflineAudioContext.h"
#include "JSOscillatorNode.h"
#include "JSPannerNode.h"
#include "JSPeriodicWave.h"
#include "JSScriptProcessorNode.h"
#include "JSWaveShaperNode.h"
#endif

#if ENABLE(WEB_AUTHN)
#include "JSAuthenticatorAssertionResponse.h"
#include "JSAuthenticatorAttestationResponse.h"
#include "JSAuthenticatorResponse.h"
#include "JSBasicCredential.h"
#include "JSCredentialsContainer.h"
#include "JSPublicKeyCredential.h"
#endif

#if ENABLE(WEB_CRYPTO)
#include "JSCryptoKey.h"
#include "JSSubtleCrypto.h"
#endif

#if ENABLE(WEB_RTC)
#include "JSRTCCertificate.h"
#include "JSRTCDTMFSender.h"
#include "JSRTCDTMFToneChangeEvent.h"
#include "JSRTCDataChannel.h"
#include "JSRTCDataChannelEvent.h"
#include "JSRTCIceCandidate.h"
#include "JSRTCIceTransport.h"
#include "JSRTCPeerConnection.h"
#include "JSRTCPeerConnectionIceEvent.h"
#include "JSRTCRtpReceiver.h"
#include "JSRTCRtpSender.h"
#include "JSRTCRtpTransceiver.h"
#include "JSRTCSessionDescription.h"
#include "JSRTCStatsReport.h"
#include "JSRTCTrackEvent.h"
#endif

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
#include "JSWebKitPlaybackTargetAvailabilityEvent.h"
#endif

#if ENABLE(XSLT)
#include "JSXSLTProcessor.h"
#endif


namespace WebCore {
using namespace JSC;

template<> WindowPostMessageOptions convertDictionary<WindowPostMessageOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WindowPostMessageOptions result;
    JSValue transferValue;
    if (isNullOrUndefined)
        transferValue = jsUndefined();
    else {
        transferValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "transfer"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!transferValue.isUndefined()) {
        result.transfer = convert<IDLSequence<IDLObject>>(lexicalGlobalObject, transferValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.transfer = Converter<IDLSequence<IDLObject>>::ReturnType{ };
    JSValue targetOriginValue;
    if (isNullOrUndefined)
        targetOriginValue = jsUndefined();
    else {
        targetOriginValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "targetOrigin"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!targetOriginValue.isUndefined()) {
        result.targetOrigin = convert<IDLUSVString>(lexicalGlobalObject, targetOriginValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.targetOrigin = "/"_s;
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionStop(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionOpen(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionAlert(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionConfirm(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionPrompt(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionPrint(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionRequestAnimationFrame(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionCancelAnimationFrame(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionRequestIdleCallback(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionCancelIdleCallback(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionCaptureEvents(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionReleaseEvents(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionGetComputedStyle(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionMatchMedia(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionMoveTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionMoveBy(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionResizeTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionResizeBy(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionScroll(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionScrollTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionScrollBy(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionGetSelection(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionFind(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionWebkitRequestAnimationFrame(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionWebkitCancelAnimationFrame(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionWebkitCancelRequestAnimationFrame(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionGetMatchedCSSRules(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionShowModalDialog(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionWebkitConvertPointFromPageToNode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionWebkitConvertPointFromNodeToPage(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionCollectMatchingElementsInFlatTree(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionMatchingElementInFlatTree(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionFetch(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionSetTimeout(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionClearTimeout(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionSetInterval(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionClearInterval(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionQueueMicrotask(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionAtob(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionBtoa(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowInstanceFunctionCreateImageBitmap(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsDOMWindowConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowWindow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMWindowSelf(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSelf(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDocument(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMWindowName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowLocation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowLocation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHistory(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMWindowCustomElements(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMWindowLocationbar(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowLocationbar(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowMenubar(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMenubar(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPersonalbar(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPersonalbar(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowScrollbars(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowScrollbars(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowStatusbar(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowStatusbar(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowToolbar(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowToolbar(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowStatus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowStatus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowFrames(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowFrames(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowLength(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowLength(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowTop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMWindowOpener(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOpener(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowParent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowParent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowFrameElement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMWindowNavigator(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMWindowApplicationCache(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMWindowSessionStorage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMWindowLocalStorage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMWindowScreen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowScreen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowInnerHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowInnerHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowInnerWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowInnerWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowScrollX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowScrollX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPageXOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPageXOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowScrollY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowScrollY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPageYOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPageYOffset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowVisualViewport(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowVisualViewport(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowScreenX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowScreenX(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowScreenY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowScreenY(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOuterWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOuterWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOuterHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOuterHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDevicePixelRatio(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDevicePixelRatio(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(ORIENTATION_EVENTS)
JSC::EncodedJSValue jsDOMWindowOrientation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsDOMWindowEvent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowEvent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDefaultStatus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDefaultStatus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDefaultstatus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDefaultstatus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOffscreenBuffering(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOffscreenBuffering(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowScreenLeft(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowScreenLeft(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowScreenTop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowScreenTop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowClientInformation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowClientInformation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowStyleMedia(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(IOS_GESTURE_EVENTS)
JSC::EncodedJSValue jsDOMWindowOngesturechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOngesturechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(IOS_GESTURE_EVENTS)
JSC::EncodedJSValue jsDOMWindowOngestureend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOngestureend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(IOS_GESTURE_EVENTS)
JSC::EncodedJSValue jsDOMWindowOngesturestart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOngesturestart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(DEVICE_ORIENTATION)
JSC::EncodedJSValue jsDOMWindowOndevicemotion(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOndevicemotion(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(DEVICE_ORIENTATION)
JSC::EncodedJSValue jsDOMWindowOndeviceorientation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOndeviceorientation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowOnwebkitanimationend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnwebkitanimationend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnwebkitanimationiteration(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnwebkitanimationiteration(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnwebkitanimationstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnwebkitanimationstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnwebkittransitionend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnwebkittransitionend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCaches(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(INDEXED_DATABASE)
JSC::EncodedJSValue jsDOMWindowIndexedDB(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::EncodedJSValue jsDOMWindowWebkitIndexedDB(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(SPEECH_SYNTHESIS)
JSC::EncodedJSValue jsDOMWindowSpeechSynthesis(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsDOMWindowOpenDatabase(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOpenDatabase(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnabort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnabort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnblur(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnblur(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOncanplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOncanplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOncanplaythrough(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOncanplaythrough(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnclick(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnclick(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOncontextmenu(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOncontextmenu(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOncuechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOncuechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOndblclick(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOndblclick(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOndrag(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOndrag(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOndragend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOndragend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOndragenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOndragenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOndragleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOndragleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOndragover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOndragover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOndragstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOndragstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOndrop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOndrop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOndurationchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOndurationchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnemptied(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnemptied(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnended(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnended(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnerror(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnfocus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnfocus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOninput(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOninput(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOninvalid(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOninvalid(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnkeydown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnkeydown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnkeypress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnkeypress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnkeyup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnkeyup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnloadeddata(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnloadeddata(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnloadedmetadata(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnloadedmetadata(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnloadstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnloadstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnmousedown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnmousedown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnmouseenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnmouseenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnmouseleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnmouseleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnmousemove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnmousemove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnmouseout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnmouseout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnmouseover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnmouseover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnmouseup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnmouseup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnmousewheel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnmousewheel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnpause(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnpause(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnplaying(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnplaying(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnprogress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnprogress(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnratechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnratechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnrejectionhandled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnrejectionhandled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnreset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnreset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnresize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnresize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnscroll(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnscroll(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnseeked(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnseeked(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnseeking(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnseeking(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnselect(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnselect(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnstalled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnstalled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnsubmit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnsubmit(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnsuspend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnsuspend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOntimeupdate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOntimeupdate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOntoggle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOntoggle(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnunhandledrejection(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnunhandledrejection(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnvolumechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnvolumechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnwaiting(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnwaiting(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOntransitionend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOntransitionend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOntransitionrun(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOntransitionrun(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOntransitionstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOntransitionstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOntransitioncancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOntransitioncancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnanimationend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnanimationend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnanimationiteration(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnanimationiteration(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnanimationstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnanimationstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnanimationcancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnanimationcancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOngotpointercapture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOngotpointercapture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnlostpointercapture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnlostpointercapture(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnpointerdown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnpointerdown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnpointermove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnpointermove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnpointerup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnpointerup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnpointercancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnpointercancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnpointerover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnpointerover(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnpointerout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnpointerout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnpointerenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnpointerenter(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnpointerleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnpointerleave(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnsearch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnsearch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnwheel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnwheel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDOMWindowOntouchcancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOntouchcancel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDOMWindowOntouchend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOntouchend(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDOMWindowOntouchmove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOntouchmove(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDOMWindowOntouchstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOntouchstart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDOMWindowOntouchforcechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOntouchforcechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsDOMWindowOnwebkitmouseforcechanged(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnwebkitmouseforcechanged(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsDOMWindowOnwebkitmouseforcedown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnwebkitmouseforcedown(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsDOMWindowOnwebkitmouseforcewillbegin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnwebkitmouseforcewillbegin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
JSC::EncodedJSValue jsDOMWindowOnwebkitmouseforceup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnwebkitmouseforceup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowCrypto(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsDOMWindowPerformance(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPerformance(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnafterprint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnafterprint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnbeforeprint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnbeforeprint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnbeforeunload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnbeforeunload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnhashchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnhashchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnlanguagechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnlanguagechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnmessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnmessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnoffline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnoffline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnonline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnonline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnpagehide(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnpagehide(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnpageshow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnpageshow(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnpopstate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnpopstate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnstorage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnstorage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOnunload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnunload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(ORIENTATION_EVENTS)
JSC::EncodedJSValue jsDOMWindowOnorientationchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOnorientationchange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowOrigin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOrigin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowIsSecureContext(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
JSC::EncodedJSValue jsDOMWindowWebKitPlaybackTargetAvailabilityEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebKitPlaybackTargetAvailabilityEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowClipboardConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowClipboardConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowClipboardItemConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowClipboardItemConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCacheConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCacheConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCacheStorageConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCacheStorageConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(WEB_AUTHN)
JSC::EncodedJSValue jsDOMWindowCredentialConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCredentialConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUTHN)
JSC::EncodedJSValue jsDOMWindowCredentialsContainerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCredentialsContainerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowFileSystemConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowFileSystemConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowFileSystemDirectoryEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowFileSystemDirectoryEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowFileSystemDirectoryReaderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowFileSystemDirectoryReaderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowFileSystemEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowFileSystemEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowFileSystemFileEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowFileSystemFileEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHeadersConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHeadersConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(GEOLOCATION)
JSC::EncodedJSValue jsDOMWindowGeolocationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGeolocationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(GEOLOCATION)
JSC::EncodedJSValue jsDOMWindowGeolocationCoordinatesConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGeolocationCoordinatesConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(GEOLOCATION)
JSC::EncodedJSValue jsDOMWindowGeolocationPositionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGeolocationPositionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(GEOLOCATION)
JSC::EncodedJSValue jsDOMWindowGeolocationPositionErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGeolocationPositionErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowHighlightMapConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHighlightMapConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHighlightRangeGroupConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHighlightRangeGroupConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(INDEXED_DATABASE)
JSC::EncodedJSValue jsDOMWindowIDBCursorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowIDBCursorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::EncodedJSValue jsDOMWindowIDBCursorWithValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowIDBCursorWithValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::EncodedJSValue jsDOMWindowIDBDatabaseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowIDBDatabaseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::EncodedJSValue jsDOMWindowIDBFactoryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowIDBFactoryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::EncodedJSValue jsDOMWindowIDBIndexConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowIDBIndexConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::EncodedJSValue jsDOMWindowIDBKeyRangeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowIDBKeyRangeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::EncodedJSValue jsDOMWindowIDBObjectStoreConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowIDBObjectStoreConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::EncodedJSValue jsDOMWindowIDBOpenDBRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowIDBOpenDBRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::EncodedJSValue jsDOMWindowIDBRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowIDBRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::EncodedJSValue jsDOMWindowIDBTransactionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowIDBTransactionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::EncodedJSValue jsDOMWindowIDBVersionChangeEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowIDBVersionChangeEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowMediaCapabilitiesConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaCapabilitiesConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue jsDOMWindowBlobEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowBlobEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue jsDOMWindowMediaRecorderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaRecorderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue jsDOMWindowMediaRecorderErrorEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaRecorderErrorEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_SESSION)
JSC::EncodedJSValue jsDOMWindowMediaRemoteControlsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaRemoteControlsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_SESSION)
JSC::EncodedJSValue jsDOMWindowMediaSessionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaSessionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_SOURCE)
JSC::EncodedJSValue jsDOMWindowMediaSourceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaSourceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_SOURCE)
JSC::EncodedJSValue jsDOMWindowSourceBufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSourceBufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_SOURCE)
JSC::EncodedJSValue jsDOMWindowSourceBufferListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSourceBufferListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue jsDOMWindowCanvasCaptureMediaStreamTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCanvasCaptureMediaStreamTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue jsDOMWindowMediaDeviceInfoConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaDeviceInfoConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue jsDOMWindowMediaDevicesConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaDevicesConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue jsDOMWindowMediaStreamConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaStreamConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue jsDOMWindowMediaStreamTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaStreamTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue jsDOMWindowMediaStreamTrackEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaStreamTrackEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue jsDOMWindowOverconstrainedErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOverconstrainedErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue jsDOMWindowOverconstrainedErrorEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOverconstrainedErrorEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue jsDOMWindowRTCCertificateConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRTCCertificateConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue jsDOMWindowRTCDTMFSenderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRTCDTMFSenderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue jsDOMWindowRTCDTMFToneChangeEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRTCDTMFToneChangeEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue jsDOMWindowRTCDataChannelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRTCDataChannelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue jsDOMWindowRTCDataChannelEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRTCDataChannelEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue jsDOMWindowRTCIceCandidateConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRTCIceCandidateConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue jsDOMWindowRTCIceTransportConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRTCIceTransportConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue jsDOMWindowRTCPeerConnectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRTCPeerConnectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue jsDOMWindowRTCPeerConnectionIceEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRTCPeerConnectionIceEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue jsDOMWindowRTCRtpReceiverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRTCRtpReceiverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue jsDOMWindowRTCRtpSenderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRTCRtpSenderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue jsDOMWindowRTCRtpTransceiverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRTCRtpTransceiverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue jsDOMWindowRTCSessionDescriptionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRTCSessionDescriptionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue jsDOMWindowRTCStatsReportConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRTCStatsReportConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue jsDOMWindowRTCTrackEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRTCTrackEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(NOTIFICATIONS)
JSC::EncodedJSValue jsDOMWindowNotificationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowNotificationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(PAYMENT_REQUEST)
JSC::EncodedJSValue jsDOMWindowMerchantValidationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMerchantValidationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(PAYMENT_REQUEST)
JSC::EncodedJSValue jsDOMWindowPaymentAddressConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPaymentAddressConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(PAYMENT_REQUEST)
JSC::EncodedJSValue jsDOMWindowPaymentMethodChangeEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPaymentMethodChangeEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(PAYMENT_REQUEST)
JSC::EncodedJSValue jsDOMWindowPaymentRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPaymentRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(PAYMENT_REQUEST)
JSC::EncodedJSValue jsDOMWindowPaymentRequestUpdateEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPaymentRequestUpdateEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(PAYMENT_REQUEST)
JSC::EncodedJSValue jsDOMWindowPaymentResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPaymentResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
JSC::EncodedJSValue jsDOMWindowEnterPictureInPictureEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowEnterPictureInPictureEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
JSC::EncodedJSValue jsDOMWindowPictureInPictureWindowConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPictureInPictureWindowConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SPEECH_SYNTHESIS)
JSC::EncodedJSValue jsDOMWindowSpeechSynthesisEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSpeechSynthesisEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SPEECH_SYNTHESIS)
JSC::EncodedJSValue jsDOMWindowSpeechSynthesisUtteranceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSpeechSynthesisUtteranceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(STREAMS_API)
JSC::EncodedJSValue jsDOMWindowByteLengthQueuingStrategyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowByteLengthQueuingStrategyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(STREAMS_API)
JSC::EncodedJSValue jsDOMWindowCountQueuingStrategyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCountQueuingStrategyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(STREAMS_API)
JSC::EncodedJSValue jsDOMWindowReadableByteStreamControllerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowReadableByteStreamControllerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(STREAMS_API)
JSC::EncodedJSValue jsDOMWindowReadableStreamConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowReadableStreamConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(STREAMS_API)
JSC::EncodedJSValue jsDOMWindowReadableStreamBYOBReaderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowReadableStreamBYOBReaderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(STREAMS_API)
JSC::EncodedJSValue jsDOMWindowReadableStreamBYOBRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowReadableStreamBYOBRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(STREAMS_API)
JSC::EncodedJSValue jsDOMWindowReadableStreamDefaultControllerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowReadableStreamDefaultControllerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(STREAMS_API)
JSC::EncodedJSValue jsDOMWindowReadableStreamDefaultReaderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowReadableStreamDefaultReaderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(STREAMS_API)
JSC::EncodedJSValue jsDOMWindowWritableStreamConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWritableStreamConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowAnalyserNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAnalyserNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowAudioBufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAudioBufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowAudioBufferSourceNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAudioBufferSourceNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowWebkitAudioContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebkitAudioContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowAudioDestinationNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAudioDestinationNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowAudioListenerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAudioListenerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowAudioNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAudioNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowAudioParamConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAudioParamConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowAudioProcessingEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAudioProcessingEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowBiquadFilterNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowBiquadFilterNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowChannelMergerNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowChannelMergerNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowChannelSplitterNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowChannelSplitterNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowConvolverNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowConvolverNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowDelayNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDelayNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowDynamicsCompressorNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDynamicsCompressorNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowGainNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGainNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO) && ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowMediaElementAudioSourceNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaElementAudioSourceNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowMediaStreamAudioDestinationNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaStreamAudioDestinationNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowMediaStreamAudioSourceNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaStreamAudioSourceNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowOfflineAudioCompletionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOfflineAudioCompletionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowWebkitOfflineAudioContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebkitOfflineAudioContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowOscillatorNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOscillatorNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowWebkitAudioPannerNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebkitAudioPannerNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowPeriodicWaveConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPeriodicWaveConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowScriptProcessorNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowScriptProcessorNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue jsDOMWindowWaveShaperNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWaveShaperNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUTHN)
JSC::EncodedJSValue jsDOMWindowAuthenticatorAssertionResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAuthenticatorAssertionResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUTHN)
JSC::EncodedJSValue jsDOMWindowAuthenticatorAttestationResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAuthenticatorAttestationResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUTHN)
JSC::EncodedJSValue jsDOMWindowAuthenticatorResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAuthenticatorResponseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_AUTHN)
JSC::EncodedJSValue jsDOMWindowPublicKeyCredentialConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPublicKeyCredentialConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowDatabaseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDatabaseConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSQLErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSQLErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSQLResultSetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSQLResultSetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSQLResultSetRowListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSQLResultSetRowListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSQLTransactionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSQLTransactionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUBufferUsageConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUBufferUsageConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUCanvasContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUCanvasContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUColorWriteConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUColorWriteConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUOutOfMemoryErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUOutOfMemoryErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUShaderStageConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUShaderStageConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUTextureUsageConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUTextureUsageConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUUncapturedErrorEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUUncapturedErrorEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUValidationErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUValidationErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUAdapterConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUAdapterConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUBindGroupConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUBindGroupConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUBindGroupLayoutConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUBindGroupLayoutConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUBufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUBufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUCommandBufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUCommandBufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUCommandEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUCommandEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUComputePassEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUComputePassEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUComputePipelineConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUComputePipelineConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUDeviceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUDeviceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUPipelineLayoutConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUPipelineLayoutConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUProgrammablePassEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUProgrammablePassEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUQueueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUQueueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPURenderPassEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPURenderPassEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPURenderPipelineConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPURenderPipelineConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUSamplerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUSamplerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUShaderModuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUShaderModuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUSwapChainConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUSwapChainConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUTextureConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUTextureConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGPU)
JSC::EncodedJSValue jsDOMWindowGPUTextureViewConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowGPUTextureViewConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowCloseEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCloseEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowWebSocketConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebSocketConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowAnimationEffectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAnimationEffectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowAnimationPlaybackEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAnimationPlaybackEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowAnimationTimelineConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAnimationTimelineConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSAnimationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSAnimationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSTransitionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSTransitionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDocumentTimelineConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDocumentTimelineConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowKeyframeEffectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowKeyframeEffectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowAnimationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAnimationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(WEB_CRYPTO)
JSC::EncodedJSValue jsDOMWindowCryptoKeyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCryptoKeyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEB_CRYPTO)
JSC::EncodedJSValue jsDOMWindowSubtleCryptoConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSubtleCryptoConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowCSSFontFaceRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSFontFaceRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSImportRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSImportRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSKeyframeRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSKeyframeRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSKeyframesRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSKeyframesRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSMediaRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSMediaRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSNamespaceRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSNamespaceRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSPageRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSPageRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSRuleListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSRuleListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSStyleDeclarationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSStyleDeclarationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSStyleRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSStyleRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSStyleSheetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSStyleSheetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSSupportsRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSSupportsRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDOMMatrixConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDOMMatrixConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDOMMatrixReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDOMMatrixReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCounterConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCounterConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSPrimitiveValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSPrimitiveValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowRGBColorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRGBColorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowRectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCSSValueListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSValueListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowFontFaceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowFontFaceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowFontFaceSetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowFontFaceSetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowMediaListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowStyleSheetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowStyleSheetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowStyleSheetListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowStyleSheetListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowWebKitCSSMatrixConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebKitCSSMatrixConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(CSS_DEVICE_ADAPTATION)
JSC::EncodedJSValue jsDOMWindowWebKitCSSViewportRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebKitCSSViewportRuleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CSS_TYPED_OM)
JSC::EncodedJSValue jsDOMWindowStylePropertyMapConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowStylePropertyMapConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CSS_TYPED_OM)
JSC::EncodedJSValue jsDOMWindowStylePropertyMapReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowStylePropertyMapReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CSS_TYPED_OM)
JSC::EncodedJSValue jsDOMWindowCSSImageValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSImageValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CSS_TYPED_OM)
JSC::EncodedJSValue jsDOMWindowCSSNumericValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSNumericValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CSS_TYPED_OM)
JSC::EncodedJSValue jsDOMWindowCSSStyleValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSStyleValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CSS_TYPED_OM)
JSC::EncodedJSValue jsDOMWindowCSSUnitValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSUnitValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CSS_TYPED_OM)
JSC::EncodedJSValue jsDOMWindowCSSUnparsedValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCSSUnparsedValueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowAbortControllerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAbortControllerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowAbortSignalConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAbortSignalConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowAnimationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAnimationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowAttrConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAttrConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowBeforeLoadEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowBeforeLoadEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowBeforeUnloadEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowBeforeUnloadEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCDATASectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCDATASectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCharacterDataConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCharacterDataConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowClipboardEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowClipboardEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCommentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCommentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCompositionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCompositionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCustomElementRegistryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCustomElementRegistryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCustomEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCustomEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDOMExceptionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDOMExceptionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDOMImplementationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDOMImplementationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDOMPointConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDOMPointConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDOMPointReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDOMPointReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDOMQuadConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDOMQuadConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDOMRectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDOMRectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDOMRectListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDOMRectListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDOMRectReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDOMRectReadOnlyConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDOMStringListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDOMStringListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDOMStringMapConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDOMStringMapConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDataTransferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDataTransferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDataTransferItemConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDataTransferItemConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDataTransferItemListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDataTransferItemListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(DEVICE_ORIENTATION)
JSC::EncodedJSValue jsDOMWindowDeviceMotionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDeviceMotionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(DEVICE_ORIENTATION)
JSC::EncodedJSValue jsDOMWindowDeviceOrientationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDeviceOrientationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowDocumentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDocumentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDocumentFragmentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDocumentFragmentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDocumentTypeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDocumentTypeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDragEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDragEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowErrorEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowErrorEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowEventTargetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowEventTargetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowFocusEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowFocusEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHashChangeEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHashChangeEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowIdleDeadlineConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowIdleDeadlineConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowInputEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowInputEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowKeyboardEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowKeyboardEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(CHANNEL_MESSAGING)
JSC::EncodedJSValue jsDOMWindowMessageChannelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMessageChannelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowMessageEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMessageEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowMessagePortConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMessagePortConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowMouseEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMouseEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowMutationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMutationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowMutationObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMutationObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowWebKitMutationObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebKitMutationObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowMutationRecordConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMutationRecordConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowNamedNodeMapConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowNamedNodeMapConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowNodeFilterConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowNodeFilterConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowNodeIteratorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowNodeIteratorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowNodeListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowNodeListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOverflowEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOverflowEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPageTransitionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPageTransitionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(POINTER_EVENTS)
JSC::EncodedJSValue jsDOMWindowPointerEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPointerEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowPopStateEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPopStateEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowProcessingInstructionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowProcessingInstructionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowProgressEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowProgressEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPromiseRejectionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPromiseRejectionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowRangeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRangeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSecurityPolicyViolationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSecurityPolicyViolationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowShadowRootConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowShadowRootConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowStaticRangeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowStaticRangeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowTextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowTextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowTextDecoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowTextDecoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowTextEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowTextEncoderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowTextEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowTextEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDOMWindowTouchConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowTouchConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDOMWindowTouchEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowTouchEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::EncodedJSValue jsDOMWindowTouchListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowTouchListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowTransitionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowTransitionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowTreeWalkerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowTreeWalkerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowUIEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowUIEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowWebKitAnimationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebKitAnimationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowWebKitTransitionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebKitTransitionEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowWheelEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWheelEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowXMLDocumentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowXMLDocumentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGDocumentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGDocumentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowBlobConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowBlobConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowFileConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowFileConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowFileErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowFileErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowFileListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowFileListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowFileReaderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowFileReaderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowFormDataConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowFormDataConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowDOMTokenListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDOMTokenListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowURLConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowURLConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowWebkitURLConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebkitURLConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLAllCollectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLAllCollectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLAnchorElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLAnchorElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLAppletElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLAppletElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLAreaElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLAreaElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(ATTACHMENT_ELEMENT)
JSC::EncodedJSValue jsDOMWindowHTMLAttachmentElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLAttachmentElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue jsDOMWindowHTMLAudioElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLAudioElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue jsDOMWindowAudioConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAudioConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowHTMLBRElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLBRElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLBaseElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLBaseElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLBodyElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLBodyElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLButtonElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLButtonElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLCanvasElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLCanvasElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLCollectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLCollectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLDListElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLDListElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLDataElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLDataElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(DATALIST_ELEMENT)
JSC::EncodedJSValue jsDOMWindowHTMLDataListElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLDataListElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowHTMLDetailsElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLDetailsElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLDialogElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLDialogElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLDirectoryElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLDirectoryElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLDivElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLDivElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLDocumentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLDocumentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLEmbedElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLEmbedElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLFieldSetElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLFieldSetElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLFontElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLFontElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLFormControlsCollectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLFormControlsCollectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLFormElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLFormElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLFrameElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLFrameElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLFrameSetElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLFrameSetElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLHRElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLHRElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLHeadElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLHeadElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLHeadingElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLHeadingElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLHtmlElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLHtmlElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLIFrameElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLIFrameElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLImageElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLImageElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowImageConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowImageConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLInputElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLInputElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLKeygenElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLKeygenElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLLIElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLLIElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLLabelElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLLabelElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLLegendElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLLegendElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLLinkElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLLinkElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLMapElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLMapElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLMarqueeElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLMarqueeElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(VIDEO)
JSC::EncodedJSValue jsDOMWindowHTMLMediaElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLMediaElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowHTMLMenuElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLMenuElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLMenuItemElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLMenuItemElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLMetaElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLMetaElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(METER_ELEMENT)
JSC::EncodedJSValue jsDOMWindowHTMLMeterElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLMeterElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowHTMLModElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLModElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLOListElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLOListElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLObjectElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLObjectElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLOptGroupElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLOptGroupElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLOptionElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLOptionElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowOptionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOptionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLOptionsCollectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLOptionsCollectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLOutputElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLOutputElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLParagraphElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLParagraphElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLParamElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLParamElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLPictureElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLPictureElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLPreElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLPreElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLProgressElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLProgressElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLQuoteElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLQuoteElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLScriptElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLScriptElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLSelectElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLSelectElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLSlotElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLSlotElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLSourceElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLSourceElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLSpanElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLSpanElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLStyleElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLStyleElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLTableCaptionElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLTableCaptionElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLTableCellElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLTableCellElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLTableColElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLTableColElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLTableElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLTableElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLTableRowElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLTableRowElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLTableSectionElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLTableSectionElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLTemplateElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLTemplateElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLTextAreaElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLTextAreaElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLTimeElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLTimeElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLTitleElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLTitleElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsDOMWindowHTMLTrackElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLTrackElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowHTMLUListElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLUListElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHTMLUnknownElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLUnknownElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(VIDEO)
JSC::EncodedJSValue jsDOMWindowHTMLVideoElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHTMLVideoElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowImageBitmapConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowImageBitmapConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowImageDataConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowImageDataConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(VIDEO)
JSC::EncodedJSValue jsDOMWindowMediaControllerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaControllerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue jsDOMWindowMediaErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMediaErrorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(OFFSCREEN_CANVAS)
JSC::EncodedJSValue jsDOMWindowOffscreenCanvasConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOffscreenCanvasConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowRadioNodeListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowRadioNodeListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowTextMetricsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowTextMetricsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(VIDEO)
JSC::EncodedJSValue jsDOMWindowTimeRangesConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowTimeRangesConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowURLSearchParamsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowURLSearchParamsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowValidityStateConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowValidityStateConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCanvasGradientConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCanvasGradientConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCanvasPatternConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCanvasPatternConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCanvasRenderingContext2DConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCanvasRenderingContext2DConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowImageBitmapRenderingContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowImageBitmapRenderingContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(OFFSCREEN_CANVAS)
JSC::EncodedJSValue jsDOMWindowOffscreenCanvasRenderingContext2DConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowOffscreenCanvasRenderingContext2DConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CSS_PAINTING_API)
JSC::EncodedJSValue jsDOMWindowPaintRenderingContext2DConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPaintRenderingContext2DConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowPath2DConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPath2DConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(WEBGL2)
JSC::EncodedJSValue jsDOMWindowWebGL2RenderingContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGL2RenderingContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsDOMWindowWebGLActiveInfoConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGLActiveInfoConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsDOMWindowWebGLBufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGLBufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsDOMWindowWebGLContextEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGLContextEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsDOMWindowWebGLFramebufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGLFramebufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsDOMWindowWebGLProgramConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGLProgramConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsDOMWindowWebGLQueryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGLQueryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsDOMWindowWebGLRenderbufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGLRenderbufferConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsDOMWindowWebGLRenderingContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGLRenderingContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsDOMWindowWebGLSamplerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGLSamplerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsDOMWindowWebGLShaderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGLShaderConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsDOMWindowWebGLShaderPrecisionFormatConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGLShaderPrecisionFormatConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsDOMWindowWebGLSyncConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGLSyncConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsDOMWindowWebGLTextureConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGLTextureConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsDOMWindowWebGLTransformFeedbackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGLTransformFeedbackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue jsDOMWindowWebGLUniformLocationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGLUniformLocationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(WEBGL2)
JSC::EncodedJSValue jsDOMWindowWebGLVertexArrayObjectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebGLVertexArrayObjectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsDOMWindowAudioTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAudioTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsDOMWindowAudioTrackListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowAudioTrackListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsDOMWindowDataCueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDataCueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsDOMWindowTextTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowTextTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsDOMWindowTextTrackCueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowTextTrackCueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsDOMWindowTextTrackCueListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowTextTrackCueListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsDOMWindowTextTrackListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowTextTrackListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsDOMWindowTrackEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowTrackEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsDOMWindowVTTCueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowVTTCueConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsDOMWindowVTTRegionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowVTTRegionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsDOMWindowVideoTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowVideoTrackConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsDOMWindowVideoTrackListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowVideoTrackListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowApplicationCacheConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowApplicationCacheConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(MATHML)
JSC::EncodedJSValue jsDOMWindowMathMLElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMathMLElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MATHML)
JSC::EncodedJSValue jsDOMWindowMathMLMathElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMathMLMathElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowBarPropConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowBarPropConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowCryptoConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowCryptoConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSelectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSelectionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowWindowConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWindowConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowEventSourceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowEventSourceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowHistoryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowHistoryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(INTERSECTION_OBSERVER)
JSC::EncodedJSValue jsDOMWindowIntersectionObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowIntersectionObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(INTERSECTION_OBSERVER)
JSC::EncodedJSValue jsDOMWindowIntersectionObserverEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowIntersectionObserverEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowLocationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowLocationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowNavigatorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowNavigatorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPerformanceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPerformanceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPerformanceEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPerformanceEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPerformanceMarkConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPerformanceMarkConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPerformanceMeasureConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPerformanceMeasureConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPerformanceNavigationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPerformanceNavigationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPerformanceObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPerformanceObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPerformanceObserverEntryListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPerformanceObserverEntryListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPerformanceResourceTimingConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPerformanceResourceTimingConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPerformanceServerTimingConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPerformanceServerTimingConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPerformanceTimingConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPerformanceTimingConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(RESIZE_OBSERVER)
JSC::EncodedJSValue jsDOMWindowResizeObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowResizeObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(RESIZE_OBSERVER)
JSC::EncodedJSValue jsDOMWindowResizeObserverEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowResizeObserverEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowScreenConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowScreenConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowUndoItemConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowUndoItemConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowUndoManagerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowUndoManagerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(USER_MESSAGE_HANDLERS)
JSC::EncodedJSValue jsDOMWindowUserMessageHandlerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowUserMessageHandlerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(USER_MESSAGE_HANDLERS)
JSC::EncodedJSValue jsDOMWindowUserMessageHandlersNamespaceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowUserMessageHandlersNamespaceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowVisualViewportConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowVisualViewportConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(USER_MESSAGE_HANDLERS)
JSC::EncodedJSValue jsDOMWindowWebKitNamespaceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebKitNamespaceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowWebKitPointConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWebKitPointConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowMimeTypeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMimeTypeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowMimeTypeArrayConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowMimeTypeArrayConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPluginConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPluginConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowPluginArrayConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowPluginArrayConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowStorageConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowStorageConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowStorageEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowStorageEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(SVG_FONTS)
JSC::EncodedJSValue jsDOMWindowSVGAltGlyphDefElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAltGlyphDefElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SVG_FONTS)
JSC::EncodedJSValue jsDOMWindowSVGAltGlyphElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAltGlyphElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SVG_FONTS)
JSC::EncodedJSValue jsDOMWindowSVGAltGlyphItemElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAltGlyphItemElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowSVGAngleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAngleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimateColorElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimateColorElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimateElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimateElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimateMotionElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimateMotionElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimateTransformElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimateTransformElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimatedAngleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimatedAngleConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimatedBooleanConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimatedBooleanConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimatedEnumerationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimatedEnumerationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimatedIntegerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimatedIntegerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimatedLengthConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimatedLengthConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimatedLengthListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimatedLengthListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimatedNumberConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimatedNumberConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimatedNumberListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimatedNumberListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimatedPreserveAspectRatioConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimatedPreserveAspectRatioConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimatedRectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimatedRectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimatedStringConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimatedStringConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimatedTransformListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimatedTransformListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGAnimationElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGAnimationElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGCircleElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGCircleElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGClipPathElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGClipPathElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGComponentTransferFunctionElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGComponentTransferFunctionElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGCursorElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGCursorElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGDefsElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGDefsElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGDescElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGDescElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGEllipseElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGEllipseElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEBlendElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEBlendElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEColorMatrixElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEColorMatrixElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEComponentTransferElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEComponentTransferElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFECompositeElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFECompositeElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEConvolveMatrixElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEConvolveMatrixElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEDiffuseLightingElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEDiffuseLightingElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEDisplacementMapElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEDisplacementMapElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEDistantLightElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEDistantLightElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEDropShadowElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEDropShadowElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEFloodElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEFloodElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEFuncAElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEFuncAElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEFuncBElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEFuncBElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEFuncGElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEFuncGElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEFuncRElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEFuncRElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEGaussianBlurElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEGaussianBlurElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEImageElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEImageElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEMergeElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEMergeElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEMergeNodeElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEMergeNodeElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEMorphologyElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEMorphologyElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEOffsetElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEOffsetElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFEPointLightElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFEPointLightElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFESpecularLightingElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFESpecularLightingElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFESpotLightElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFESpotLightElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFETileElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFETileElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFETurbulenceElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFETurbulenceElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGFilterElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFilterElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(SVG_FONTS)
JSC::EncodedJSValue jsDOMWindowSVGFontElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFontElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SVG_FONTS)
JSC::EncodedJSValue jsDOMWindowSVGFontFaceElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFontFaceElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SVG_FONTS)
JSC::EncodedJSValue jsDOMWindowSVGFontFaceFormatElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFontFaceFormatElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SVG_FONTS)
JSC::EncodedJSValue jsDOMWindowSVGFontFaceNameElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFontFaceNameElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SVG_FONTS)
JSC::EncodedJSValue jsDOMWindowSVGFontFaceSrcElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFontFaceSrcElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SVG_FONTS)
JSC::EncodedJSValue jsDOMWindowSVGFontFaceUriElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGFontFaceUriElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowSVGForeignObjectElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGForeignObjectElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGGElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGGElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGGeometryElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGGeometryElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(SVG_FONTS)
JSC::EncodedJSValue jsDOMWindowSVGGlyphElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGGlyphElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SVG_FONTS)
JSC::EncodedJSValue jsDOMWindowSVGGlyphRefElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGGlyphRefElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowSVGGradientElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGGradientElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGGraphicsElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGGraphicsElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(SVG_FONTS)
JSC::EncodedJSValue jsDOMWindowSVGHKernElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGHKernElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowSVGImageElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGImageElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGLengthConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGLengthConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGLengthListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGLengthListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGLineElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGLineElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGLinearGradientElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGLinearGradientElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGMPathElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGMPathElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGMarkerElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGMarkerElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGMaskElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGMaskElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGMatrixConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGMatrixConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGMetadataElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGMetadataElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(SVG_FONTS)
JSC::EncodedJSValue jsDOMWindowSVGMissingGlyphElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGMissingGlyphElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowSVGNumberConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGNumberConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGNumberListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGNumberListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegArcAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegArcAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegArcRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegArcRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegClosePathConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegClosePathConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegCurvetoCubicAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegCurvetoCubicAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegCurvetoCubicRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegCurvetoCubicRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegCurvetoCubicSmoothAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegCurvetoCubicSmoothAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegCurvetoCubicSmoothRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegCurvetoCubicSmoothRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegCurvetoQuadraticAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegCurvetoQuadraticAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegCurvetoQuadraticRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegCurvetoQuadraticRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegCurvetoQuadraticSmoothAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegCurvetoQuadraticSmoothAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegCurvetoQuadraticSmoothRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegCurvetoQuadraticSmoothRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegLinetoAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegLinetoAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegLinetoHorizontalAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegLinetoHorizontalAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegLinetoHorizontalRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegLinetoHorizontalRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegLinetoRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegLinetoRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegLinetoVerticalAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegLinetoVerticalAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegLinetoVerticalRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegLinetoVerticalRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegMovetoAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegMovetoAbsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPathSegMovetoRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPathSegMovetoRelConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPatternElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPatternElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPointConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPointConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPointListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPointListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPolygonElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPolygonElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPolylineElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPolylineElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGPreserveAspectRatioConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGPreserveAspectRatioConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGRadialGradientElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGRadialGradientElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGRectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGRectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGRectElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGRectElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGRenderingIntentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGRenderingIntentConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGSVGElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGSVGElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGScriptElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGScriptElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGSetElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGSetElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGStopElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGStopElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGStringListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGStringListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGStyleElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGStyleElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGSwitchElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGSwitchElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGSymbolElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGSymbolElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGTRefElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGTRefElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGTSpanElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGTSpanElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGTextContentElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGTextContentElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGTextElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGTextElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGTextPathElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGTextPathElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGTextPositioningElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGTextPositioningElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGTitleElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGTitleElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGTransformConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGTransformConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGTransformListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGTransformListConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGUnitTypesConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGUnitTypesConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGUseElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGUseElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(SVG_FONTS)
JSC::EncodedJSValue jsDOMWindowSVGVKernElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGVKernElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowSVGViewElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGViewElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGViewSpecConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGViewSpecConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowSVGZoomEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowSVGZoomEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowWorkerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWorkerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue jsDOMWindowServiceWorkerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowServiceWorkerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue jsDOMWindowServiceWorkerContainerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowServiceWorkerContainerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue jsDOMWindowServiceWorkerRegistrationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowServiceWorkerRegistrationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(CSS_PAINTING_API)
JSC::EncodedJSValue jsDOMWindowWorkletConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowWorkletConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
JSC::EncodedJSValue jsDOMWindowDOMParserConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowDOMParserConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowXMLHttpRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowXMLHttpRequestConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowXMLHttpRequestEventTargetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowXMLHttpRequestEventTargetConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowXMLHttpRequestProgressEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowXMLHttpRequestProgressEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowXMLHttpRequestUploadConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowXMLHttpRequestUploadConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowXMLSerializerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowXMLSerializerConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowXPathEvaluatorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowXPathEvaluatorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowXPathExpressionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowXPathExpressionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsDOMWindowXPathResultConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowXPathResultConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(XSLT)
JSC::EncodedJSValue jsDOMWindowXSLTProcessorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSDOMWindowXSLTProcessorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif

using JSDOMWindowConstructor = JSDOMConstructorNotConstructable<JSDOMWindow>;

/* Hash table */

static const struct CompactHashIndex JSDOMWindowTableIndex[2137] = {
    { 636, -1 },
    { 404, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 652, -1 },
    { 208, -1 },
    { -1, -1 },
    { 456, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 270, -1 },
    { 215, -1 },
    { -1, -1 },
    { 302, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 125, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 184, -1 },
    { -1, -1 },
    { -1, -1 },
    { 470, -1 },
    { -1, -1 },
    { 656, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 189, -1 },
    { 122, -1 },
    { -1, -1 },
    { 431, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 19, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 132, -1 },
    { 552, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 389, -1 },
    { -1, -1 },
    { -1, -1 },
    { 287, 2101 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 308, 2092 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 611, -1 },
    { -1, -1 },
    { -1, -1 },
    { 463, -1 },
    { 165, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 331, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 177, 2059 },
    { -1, -1 },
    { -1, -1 },
    { 490, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 501, -1 },
    { 260, -1 },
    { 354, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 196, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 43, 2054 },
    { 557, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 145, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 255, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 510, -1 },
    { 72, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 617, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 90, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 81, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 433, -1 },
    { -1, -1 },
    { 66, -1 },
    { -1, -1 },
    { 451, -1 },
    { -1, -1 },
    { 142, -1 },
    { -1, -1 },
    { -1, -1 },
    { 598, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 442, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 443, -1 },
    { -1, -1 },
    { -1, -1 },
    { 169, -1 },
    { -1, -1 },
    { 471, -1 },
    { 34, 2048 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 178, -1 },
    { 5, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 602, -1 },
    { -1, -1 },
    { -1, -1 },
    { 16, 2118 },
    { -1, -1 },
    { 570, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 548, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 18, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 295, -1 },
    { 326, -1 },
    { -1, -1 },
    { -1, -1 },
    { 410, -1 },
    { -1, -1 },
    { 646, -1 },
    { 390, -1 },
    { -1, -1 },
    { -1, -1 },
    { 462, -1 },
    { 120, -1 },
    { 367, -1 },
    { 150, -1 },
    { -1, -1 },
    { 237, -1 },
    { -1, -1 },
    { 80, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 180, 2063 },
    { 428, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 247, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 251, -1 },
    { -1, -1 },
    { -1, -1 },
    { 392, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 211, -1 },
    { 92, -1 },
    { -1, -1 },
    { 372, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 30, -1 },
    { 362, -1 },
    { -1, -1 },
    { -1, -1 },
    { 41, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 83, 2052 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 387, -1 },
    { -1, -1 },
    { -1, -1 },
    { 455, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 485, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 328, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 190, 2089 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 547, -1 },
    { -1, -1 },
    { 335, 2083 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 422, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 160, 2073 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 63, -1 },
    { 377, 2134 },
    { -1, -1 },
    { 321, -1 },
    { 181, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 114, 2088 },
    { -1, -1 },
    { 291, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 245, -1 },
    { -1, -1 },
    { 201, -1 },
    { 303, -1 },
    { 233, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 221, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 93, 2062 },
    { -1, -1 },
    { -1, -1 },
    { 654, -1 },
    { 129, 2095 },
    { 327, -1 },
    { -1, -1 },
    { 330, -1 },
    { 25, -1 },
    { -1, -1 },
    { -1, -1 },
    { 171, -1 },
    { -1, -1 },
    { -1, -1 },
    { 223, -1 },
    { -1, -1 },
    { 605, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 348, 2128 },
    { -1, -1 },
    { -1, -1 },
    { 508, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 461, -1 },
    { -1, -1 },
    { 195, 2071 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 315, -1 },
    { 620, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 40, -1 },
    { 282, -1 },
    { -1, -1 },
    { 399, 2114 },
    { -1, -1 },
    { -1, -1 },
    { 100, 2072 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 252, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 116, -1 },
    { -1, -1 },
    { 283, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 529, -1 },
    { -1, -1 },
    { -1, -1 },
    { 212, 2093 },
    { 379, -1 },
    { 423, -1 },
    { -1, -1 },
    { 71, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 345, -1 },
    { 336, -1 },
    { -1, -1 },
    { 313, -1 },
    { 594, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 645, -1 },
    { -1, -1 },
    { 593, -1 },
    { -1, -1 },
    { 109, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 333, -1 },
    { 175, 2119 },
    { 363, -1 },
    { -1, -1 },
    { -1, -1 },
    { 127, -1 },
    { 576, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 46, -1 },
    { -1, -1 },
    { 563, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 202, 2081 },
    { -1, -1 },
    { 324, -1 },
    { -1, -1 },
    { 278, -1 },
    { -1, -1 },
    { -1, -1 },
    { 99, -1 },
    { -1, -1 },
    { -1, -1 },
    { 118, -1 },
    { 115, -1 },
    { 473, -1 },
    { -1, -1 },
    { 373, -1 },
    { 249, -1 },
    { 567, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 432, -1 },
    { -1, -1 },
    { -1, -1 },
    { 111, -1 },
    { 565, -1 },
    { -1, -1 },
    { 33, -1 },
    { -1, -1 },
    { 97, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 74, -1 },
    { 128, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 360, -1 },
    { 254, 2122 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 37, -1 },
    { -1, -1 },
    { -1, -1 },
    { 240, 2094 },
    { -1, -1 },
    { 24, -1 },
    { -1, -1 },
    { 22, 2068 },
    { -1, -1 },
    { -1, -1 },
    { 198, 2074 },
    { -1, -1 },
    { -1, -1 },
    { 146, -1 },
    { 149, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 588, -1 },
    { 64, -1 },
    { 172, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 643, -1 },
    { -1, -1 },
    { 555, -1 },
    { -1, -1 },
    { 558, -1 },
    { -1, -1 },
    { -1, -1 },
    { 148, -1 },
    { -1, -1 },
    { -1, -1 },
    { 448, -1 },
    { -1, -1 },
    { 317, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 503, -1 },
    { -1, -1 },
    { -1, -1 },
    { 606, -1 },
    { -1, -1 },
    { -1, -1 },
    { 155, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 426, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 520, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 511, -1 },
    { 285, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 206, -1 },
    { -1, -1 },
    { -1, -1 },
    { 347, -1 },
    { -1, -1 },
    { -1, -1 },
    { 134, 2053 },
    { -1, -1 },
    { 105, -1 },
    { 235, 2085 },
    { -1, -1 },
    { -1, -1 },
    { 292, -1 },
    { -1, -1 },
    { -1, -1 },
    { 250, -1 },
    { -1, -1 },
    { -1, -1 },
    { 376, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 446, -1 },
    { 459, -1 },
    { -1, -1 },
    { -1, -1 },
    { 234, -1 },
    { -1, -1 },
    { 45, 2049 },
    { 458, -1 },
    { -1, -1 },
    { -1, -1 },
    { 500, -1 },
    { -1, -1 },
    { -1, -1 },
    { 440, -1 },
    { 409, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 381, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 427, -1 },
    { 493, -1 },
    { -1, -1 },
    { 475, -1 },
    { 494, -1 },
    { -1, -1 },
    { 55, -1 },
    { 73, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 267, -1 },
    { -1, -1 },
    { -1, -1 },
    { 628, -1 },
    { -1, -1 },
    { 264, -1 },
    { -1, -1 },
    { -1, -1 },
    { 183, -1 },
    { -1, -1 },
    { 8, -1 },
    { -1, -1 },
    { -1, -1 },
    { 388, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 161, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 61, -1 },
    { -1, -1 },
    { 301, 2102 },
    { 12, 2056 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 96, 2075 },
    { 121, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 408, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 353, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 35, 2050 },
    { 228, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 396, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 124, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 176, 2100 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 361, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 85, -1 },
    { -1, -1 },
    { 532, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 544, -1 },
    { 27, 2091 },
    { 143, -1 },
    { -1, -1 },
    { 53, -1 },
    { -1, -1 },
    { 32, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 595, -1 },
    { 0, -1 },
    { 332, -1 },
    { 259, -1 },
    { -1, -1 },
    { 279, -1 },
    { -1, -1 },
    { 42, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 531, -1 },
    { -1, -1 },
    { -1, -1 },
    { 54, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 479, -1 },
    { -1, -1 },
    { -1, -1 },
    { 194, -1 },
    { -1, -1 },
    { 163, -1 },
    { -1, -1 },
    { 65, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 380, -1 },
    { 489, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 310, -1 },
    { -1, -1 },
    { 266, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 625, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 136, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 649, -1 },
    { 648, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 241, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 579, -1 },
    { 478, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 600, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 355, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 39, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 158, -1 },
    { 421, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 509, 2123 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 640, -1 },
    { 487, -1 },
    { -1, -1 },
    { -1, -1 },
    { 276, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 62, -1 },
    { -1, -1 },
    { -1, -1 },
    { 530, -1 },
    { -1, -1 },
    { -1, -1 },
    { 553, -1 },
    { -1, -1 },
    { 131, -1 },
    { 269, 2079 },
    { -1, -1 },
    { -1, -1 },
    { 596, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 14, -1 },
    { -1, -1 },
    { -1, -1 },
    { 337, 2136 },
    { 454, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 539, -1 },
    { -1, -1 },
    { -1, -1 },
    { 151, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 106, 2115 },
    { 7, -1 },
    { 76, 2090 },
    { 110, -1 },
    { 477, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 28, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 15, -1 },
    { -1, -1 },
    { 210, -1 },
    { -1, -1 },
    { -1, -1 },
    { 236, 2125 },
    { 538, -1 },
    { 268, -1 },
    { 187, 2087 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 342, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 370, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 294, -1 },
    { -1, -1 },
    { 137, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 2, 2070 },
    { -1, -1 },
    { 102, -1 },
    { 386, -1 },
    { 644, -1 },
    { 51, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 306, 2127 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 371, -1 },
    { -1, -1 },
    { 616, -1 },
    { 340, -1 },
    { -1, -1 },
    { -1, -1 },
    { 168, -1 },
    { 10, -1 },
    { -1, -1 },
    { -1, -1 },
    { 391, -1 },
    { -1, -1 },
    { -1, -1 },
    { 70, -1 },
    { 325, -1 },
    { 467, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 188, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 79, 2130 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 23, 2067 },
    { 637, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 601, -1 },
    { 86, 2055 },
    { 403, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 445, -1 },
    { -1, -1 },
    { 138, -1 },
    { 3, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 309, -1 },
    { 365, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 281, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 384, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 655, -1 },
    { 141, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 52, -1 },
    { 414, -1 },
    { -1, -1 },
    { -1, -1 },
    { 528, -1 },
    { -1, -1 },
    { -1, -1 },
    { 535, -1 },
    { -1, -1 },
    { 393, -1 },
    { -1, -1 },
    { 618, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 227, -1 },
    { 91, -1 },
    { -1, -1 },
    { 316, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 44, -1 },
    { 612, -1 },
    { 253, -1 },
    { -1, -1 },
    { 68, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 36, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 47, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 416, -1 },
    { 653, -1 },
    { -1, -1 },
    { -1, -1 },
    { 117, -1 },
    { -1, -1 },
    { 338, -1 },
    { -1, -1 },
    { -1, -1 },
    { 154, -1 },
    { -1, -1 },
    { -1, -1 },
    { 29, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 466, -1 },
    { 522, -1 },
    { -1, -1 },
    { 67, 2082 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 633, -1 },
    { 299, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 286, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 610, -1 },
    { -1, -1 },
    { 375, -1 },
    { 192, -1 },
    { -1, -1 },
    { 170, -1 },
    { -1, -1 },
    { 1, 2066 },
    { -1, -1 },
    { -1, -1 },
    { 298, 2086 },
    { 288, -1 },
    { 319, -1 },
    { -1, -1 },
    { -1, -1 },
    { 290, 2113 },
    { 383, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 483, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 573, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 575, -1 },
    { -1, -1 },
    { 444, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 572, 2135 },
    { -1, -1 },
    { -1, -1 },
    { 95, -1 },
    { -1, -1 },
    { 406, 2117 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 481, 2106 },
    { 265, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 497, -1 },
    { 185, -1 },
    { 413, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 512, -1 },
    { -1, -1 },
    { 153, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 374, -1 },
    { -1, -1 },
    { -1, -1 },
    { 232, -1 },
    { -1, -1 },
    { 258, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 339, -1 },
    { -1, -1 },
    { 219, -1 },
    { 318, -1 },
    { -1, -1 },
    { -1, -1 },
    { 507, -1 },
    { -1, -1 },
    { 229, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 607, -1 },
    { -1, -1 },
    { -1, -1 },
    { 350, -1 },
    { 536, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 401, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 351, 2084 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 305, -1 },
    { 527, -1 },
    { 395, 2105 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 231, -1 },
    { -1, -1 },
    { -1, -1 },
    { 222, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 603, -1 },
    { -1, -1 },
    { -1, -1 },
    { 126, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 647, -1 },
    { -1, -1 },
    { 619, -1 },
    { 460, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 358, -1 },
    { -1, -1 },
    { 98, -1 },
    { -1, -1 },
    { 415, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 542, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 214, -1 },
    { 424, -1 },
    { 296, -1 },
    { 546, -1 },
    { 209, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 94, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 203, -1 },
    { -1, -1 },
    { 113, -1 },
    { 382, -1 },
    { -1, -1 },
    { -1, -1 },
    { 407, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 472, -1 },
    { 6, -1 },
    { -1, -1 },
    { 217, -1 },
    { -1, -1 },
    { 541, -1 },
    { -1, -1 },
    { -1, -1 },
    { 398, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 311, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 204, -1 },
    { 329, -1 },
    { 207, 2061 },
    { 453, -1 },
    { -1, -1 },
    { 578, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 205, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 304, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 521, -1 },
    { 641, -1 },
    { -1, -1 },
    { -1, -1 },
    { 504, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 359, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 488, -1 },
    { 474, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 174, -1 },
    { -1, -1 },
    { 343, -1 },
    { 639, -1 },
    { 523, -1 },
    { 4, -1 },
    { -1, -1 },
    { 108, -1 },
    { 9, 2051 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 341, 2099 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 263, -1 },
    { 517, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 352, -1 },
    { -1, -1 },
    { -1, -1 },
    { 17, 2064 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 78, -1 },
    { -1, -1 },
    { 385, -1 },
    { -1, -1 },
    { 581, -1 },
    { -1, -1 },
    { 356, -1 },
    { -1, -1 },
    { -1, -1 },
    { 224, 2065 },
    { -1, -1 },
    { 60, -1 },
    { 75, -1 },
    { 585, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 464, -1 },
    { 506, 2131 },
    { 480, -1 },
    { 13, -1 },
    { -1, -1 },
    { -1, -1 },
    { 239, -1 },
    { 609, -1 },
    { -1, -1 },
    { -1, -1 },
    { 20, -1 },
    { -1, -1 },
    { 323, -1 },
    { -1, -1 },
    { 561, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 614, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 624, -1 },
    { -1, -1 },
    { -1, -1 },
    { 89, -1 },
    { 164, -1 },
    { 135, -1 },
    { 262, -1 },
    { -1, -1 },
    { 533, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 551, -1 },
    { 418, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 159, -1 },
    { -1, -1 },
    { -1, -1 },
    { 103, -1 },
    { 468, -1 },
    { -1, -1 },
    { -1, -1 },
    { 450, -1 },
    { 179, 2129 },
    { -1, -1 },
    { 26, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 238, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 469, -1 },
    { -1, -1 },
    { 56, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 420, -1 },
    { -1, -1 },
    { -1, -1 },
    { 559, -1 },
    { -1, -1 },
    { 436, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 357, -1 },
    { -1, -1 },
    { -1, -1 },
    { 101, -1 },
    { 491, 2126 },
    { 419, 2116 },
    { -1, -1 },
    { 87, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 634, -1 },
    { 147, -1 },
    { -1, -1 },
    { -1, -1 },
    { 59, 2078 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 554, -1 },
    { -1, -1 },
    { 486, -1 },
    { -1, -1 },
    { -1, -1 },
    { 498, -1 },
    { 256, -1 },
    { 349, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 244, -1 },
    { -1, -1 },
    { 191, 2120 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 49, -1 },
    { 496, -1 },
    { 157, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 642, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 417, -1 },
    { 495, 2104 },
    { -1, -1 },
    { 297, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 537, -1 },
    { -1, -1 },
    { -1, -1 },
    { 405, -1 },
    { -1, -1 },
    { -1, -1 },
    { 107, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 133, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 447, -1 },
    { -1, -1 },
    { -1, -1 },
    { 226, -1 },
    { 166, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 604, 2133 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 344, -1 },
    { -1, -1 },
    { -1, -1 },
    { 599, -1 },
    { 592, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 378, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 248, 2098 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 322, -1 },
    { -1, -1 },
    { 626, -1 },
    { 516, -1 },
    { -1, -1 },
    { 621, -1 },
    { -1, -1 },
    { 82, -1 },
    { -1, -1 },
    { -1, -1 },
    { 11, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 441, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 437, 2112 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 277, 2080 },
    { -1, -1 },
    { 586, -1 },
    { -1, -1 },
    { -1, -1 },
    { 587, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 167, 2058 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 402, -1 },
    { -1, -1 },
    { 590, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 457, -1 },
    { 651, -1 },
    { -1, -1 },
    { 449, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 334, -1 },
    { 275, 2096 },
    { -1, -1 },
    { 173, -1 },
    { -1, -1 },
    { 140, -1 },
    { 57, -1 },
    { 48, 2076 },
    { -1, -1 },
    { 119, -1 },
    { 271, 2132 },
    { -1, -1 },
    { 38, -1 },
    { -1, -1 },
    { 560, -1 },
    { -1, -1 },
    { -1, -1 },
    { 50, -1 },
    { -1, -1 },
    { 31, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 130, 2111 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 156, -1 },
    { -1, -1 },
    { 439, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 505, -1 },
    { 200, 2060 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 312, -1 },
    { -1, -1 },
    { 564, -1 },
    { 112, 2057 },
    { -1, -1 },
    { -1, -1 },
    { 545, -1 },
    { -1, -1 },
    { -1, -1 },
    { 197, -1 },
    { 220, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 273, 2069 },
    { 622, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 21, -1 },
    { -1, -1 },
    { 225, -1 },
    { -1, -1 },
    { 84, 2097 },
    { -1, -1 },
    { 77, -1 },
    { -1, -1 },
    { 412, -1 },
    { 543, -1 },
    { 615, -1 },
    { 182, 2108 },
    { -1, -1 },
    { 452, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 630, -1 },
    { 514, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 243, -1 },
    { 58, -1 },
    { 69, -1 },
    { 88, -1 },
    { 104, -1 },
    { 123, -1 },
    { 139, -1 },
    { 144, -1 },
    { 152, -1 },
    { 162, 2109 },
    { 186, -1 },
    { 193, -1 },
    { 199, -1 },
    { 213, -1 },
    { 216, -1 },
    { 218, -1 },
    { 230, -1 },
    { 242, -1 },
    { 246, -1 },
    { 257, -1 },
    { 261, -1 },
    { 272, -1 },
    { 274, -1 },
    { 280, -1 },
    { 284, 2103 },
    { 289, 2077 },
    { 293, -1 },
    { 300, -1 },
    { 307, -1 },
    { 314, -1 },
    { 320, -1 },
    { 346, -1 },
    { 364, 2107 },
    { 366, -1 },
    { 368, -1 },
    { 369, -1 },
    { 394, 2121 },
    { 397, -1 },
    { 400, -1 },
    { 411, -1 },
    { 425, -1 },
    { 429, -1 },
    { 430, -1 },
    { 434, -1 },
    { 435, 2110 },
    { 438, -1 },
    { 465, -1 },
    { 476, -1 },
    { 482, -1 },
    { 484, -1 },
    { 492, -1 },
    { 499, -1 },
    { 502, -1 },
    { 513, -1 },
    { 515, -1 },
    { 518, -1 },
    { 519, -1 },
    { 524, -1 },
    { 525, -1 },
    { 526, -1 },
    { 534, -1 },
    { 540, -1 },
    { 549, -1 },
    { 550, -1 },
    { 556, -1 },
    { 562, -1 },
    { 566, -1 },
    { 568, 2124 },
    { 569, -1 },
    { 571, -1 },
    { 574, -1 },
    { 577, -1 },
    { 580, -1 },
    { 582, -1 },
    { 583, -1 },
    { 584, -1 },
    { 589, -1 },
    { 591, -1 },
    { 597, -1 },
    { 608, -1 },
    { 613, -1 },
    { 623, -1 },
    { 627, -1 },
    { 629, -1 },
    { 631, -1 },
    { 632, -1 },
    { 635, -1 },
    { 638, -1 },
    { 650, -1 },
    { 657, -1 },
};


static const HashTableValue JSDOMWindowTableValues[] =
{
    { "window", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWindow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "self", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSelf), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSelf) } },
    { "document", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDocument), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "name", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowName) } },
    { "location", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowLocation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowLocation) } },
    { "history", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHistory), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "locationbar", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowLocationbar), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowLocationbar) } },
    { "menubar", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMenubar), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMenubar) } },
    { "personalbar", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowPersonalbar), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowPersonalbar) } },
    { "scrollbars", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowScrollbars), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowScrollbars) } },
    { "statusbar", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowStatusbar), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowStatusbar) } },
    { "toolbar", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowToolbar), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowToolbar) } },
    { "status", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowStatus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowStatus) } },
    { "closed", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowClosed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "frames", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowFrames), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowFrames) } },
    { "length", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowLength) } },
    { "top", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "opener", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOpener), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOpener) } },
    { "parent", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowParent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowParent) } },
    { "frameElement", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowFrameElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "navigator", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowNavigator), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "applicationCache", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowApplicationCache), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "sessionStorage", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSessionStorage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "localStorage", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowLocalStorage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "screen", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowScreen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowScreen) } },
    { "innerHeight", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowInnerHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowInnerHeight) } },
    { "innerWidth", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowInnerWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowInnerWidth) } },
    { "scrollX", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowScrollX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowScrollX) } },
    { "pageXOffset", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowPageXOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowPageXOffset) } },
    { "scrollY", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowScrollY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowScrollY) } },
    { "pageYOffset", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowPageYOffset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowPageYOffset) } },
    { "screenX", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowScreenX), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowScreenX) } },
    { "screenY", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowScreenY), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowScreenY) } },
    { "outerWidth", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOuterWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOuterWidth) } },
    { "outerHeight", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOuterHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOuterHeight) } },
    { "devicePixelRatio", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDevicePixelRatio), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDevicePixelRatio) } },
#if ENABLE(ORIENTATION_EVENTS)
    { "orientation", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOrientation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "event", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowEvent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowEvent) } },
    { "defaultStatus", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDefaultStatus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDefaultStatus) } },
    { "defaultstatus", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDefaultstatus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDefaultstatus) } },
    { "offscreenBuffering", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOffscreenBuffering), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOffscreenBuffering) } },
    { "screenLeft", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowScreenLeft), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowScreenLeft) } },
    { "screenTop", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowScreenTop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowScreenTop) } },
    { "clientInformation", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowClientInformation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowClientInformation) } },
    { "styleMedia", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowStyleMedia), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(IOS_GESTURE_EVENTS)
    { "ongesturechange", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOngesturechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOngesturechange) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(IOS_GESTURE_EVENTS)
    { "ongestureend", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOngestureend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOngestureend) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(IOS_GESTURE_EVENTS)
    { "ongesturestart", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOngesturestart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOngesturestart) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(DEVICE_ORIENTATION)
    { "ondevicemotion", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOndevicemotion), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOndevicemotion) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(DEVICE_ORIENTATION)
    { "ondeviceorientation", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOndeviceorientation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOndeviceorientation) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "onwebkitanimationend", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnwebkitanimationend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnwebkitanimationend) } },
    { "onwebkitanimationiteration", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnwebkitanimationiteration), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnwebkitanimationiteration) } },
    { "onwebkitanimationstart", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnwebkitanimationstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnwebkitanimationstart) } },
    { "onwebkittransitionend", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnwebkittransitionend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnwebkittransitionend) } },
#if ENABLE(INDEXED_DATABASE)
    { "indexedDB", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowIndexedDB), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "webkitIndexedDB", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebkitIndexedDB), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(SPEECH_SYNTHESIS)
    { "speechSynthesis", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSpeechSynthesis), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "openDatabase", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOpenDatabase), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOpenDatabase) } },
    { "onabort", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnabort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnabort) } },
    { "onblur", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnblur), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnblur) } },
    { "oncanplay", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOncanplay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOncanplay) } },
    { "oncanplaythrough", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOncanplaythrough), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOncanplaythrough) } },
    { "onchange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnchange) } },
    { "onclick", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnclick), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnclick) } },
    { "oncontextmenu", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOncontextmenu), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOncontextmenu) } },
    { "oncuechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOncuechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOncuechange) } },
    { "ondblclick", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOndblclick), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOndblclick) } },
    { "ondrag", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOndrag), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOndrag) } },
    { "ondragend", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOndragend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOndragend) } },
    { "ondragenter", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOndragenter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOndragenter) } },
    { "ondragleave", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOndragleave), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOndragleave) } },
    { "ondragover", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOndragover), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOndragover) } },
    { "ondragstart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOndragstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOndragstart) } },
    { "ondrop", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOndrop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOndrop) } },
    { "ondurationchange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOndurationchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOndurationchange) } },
    { "onemptied", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnemptied), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnemptied) } },
    { "onended", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnended), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnended) } },
    { "onerror", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnerror), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnerror) } },
    { "onfocus", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnfocus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnfocus) } },
    { "oninput", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOninput), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOninput) } },
    { "oninvalid", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOninvalid), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOninvalid) } },
    { "onkeydown", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnkeydown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnkeydown) } },
    { "onkeypress", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnkeypress), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnkeypress) } },
    { "onkeyup", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnkeyup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnkeyup) } },
    { "onload", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnload) } },
    { "onloadeddata", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnloadeddata), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnloadeddata) } },
    { "onloadedmetadata", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnloadedmetadata), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnloadedmetadata) } },
    { "onloadstart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnloadstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnloadstart) } },
    { "onmousedown", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnmousedown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnmousedown) } },
    { "onmouseenter", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnmouseenter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnmouseenter) } },
    { "onmouseleave", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnmouseleave), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnmouseleave) } },
    { "onmousemove", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnmousemove), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnmousemove) } },
    { "onmouseout", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnmouseout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnmouseout) } },
    { "onmouseover", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnmouseover), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnmouseover) } },
    { "onmouseup", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnmouseup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnmouseup) } },
    { "onmousewheel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnmousewheel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnmousewheel) } },
    { "onpause", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnpause), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnpause) } },
    { "onplay", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnplay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnplay) } },
    { "onplaying", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnplaying), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnplaying) } },
    { "onprogress", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnprogress), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnprogress) } },
    { "onratechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnratechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnratechange) } },
    { "onrejectionhandled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnrejectionhandled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnrejectionhandled) } },
    { "onreset", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnreset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnreset) } },
    { "onresize", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnresize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnresize) } },
    { "onscroll", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnscroll), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnscroll) } },
    { "onseeked", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnseeked), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnseeked) } },
    { "onseeking", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnseeking), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnseeking) } },
    { "onselect", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnselect), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnselect) } },
    { "onstalled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnstalled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnstalled) } },
    { "onsubmit", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnsubmit), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnsubmit) } },
    { "onsuspend", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnsuspend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnsuspend) } },
    { "ontimeupdate", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOntimeupdate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOntimeupdate) } },
    { "ontoggle", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOntoggle), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOntoggle) } },
    { "onunhandledrejection", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnunhandledrejection), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnunhandledrejection) } },
    { "onvolumechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnvolumechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnvolumechange) } },
    { "onwaiting", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnwaiting), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnwaiting) } },
    { "ontransitionend", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOntransitionend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOntransitionend) } },
    { "ontransitionrun", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOntransitionrun), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOntransitionrun) } },
    { "ontransitionstart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOntransitionstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOntransitionstart) } },
    { "ontransitioncancel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOntransitioncancel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOntransitioncancel) } },
    { "onanimationend", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnanimationend), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnanimationend) } },
    { "onanimationiteration", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnanimationiteration), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnanimationiteration) } },
    { "onanimationstart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnanimationstart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnanimationstart) } },
    { "onanimationcancel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnanimationcancel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnanimationcancel) } },
    { "ongotpointercapture", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOngotpointercapture), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOngotpointercapture) } },
    { "onlostpointercapture", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnlostpointercapture), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnlostpointercapture) } },
    { "onpointerdown", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnpointerdown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnpointerdown) } },
    { "onpointermove", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnpointermove), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnpointermove) } },
    { "onpointerup", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnpointerup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnpointerup) } },
    { "onpointercancel", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnpointercancel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnpointercancel) } },
    { "onpointerover", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnpointerover), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnpointerover) } },
    { "onpointerout", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnpointerout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnpointerout) } },
    { "onpointerenter", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnpointerenter), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnpointerenter) } },
    { "onpointerleave", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnpointerleave), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnpointerleave) } },
    { "onsearch", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnsearch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnsearch) } },
    { "onwheel", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnwheel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnwheel) } },
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcechanged", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnwebkitmouseforcechanged), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnwebkitmouseforcechanged) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcedown", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnwebkitmouseforcedown), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnwebkitmouseforcedown) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforcewillbegin", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnwebkitmouseforcewillbegin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnwebkitmouseforcewillbegin) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MOUSE_FORCE_EVENTS)
    { "onwebkitmouseforceup", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnwebkitmouseforceup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnwebkitmouseforceup) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "crypto", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCrypto), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "performance", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowPerformance), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowPerformance) } },
    { "onafterprint", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnafterprint), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnafterprint) } },
    { "onbeforeprint", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnbeforeprint), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnbeforeprint) } },
    { "onbeforeunload", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnbeforeunload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnbeforeunload) } },
    { "onhashchange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnhashchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnhashchange) } },
    { "onlanguagechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnlanguagechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnlanguagechange) } },
    { "onmessage", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnmessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnmessage) } },
    { "onoffline", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnoffline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnoffline) } },
    { "ononline", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnonline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnonline) } },
    { "onpagehide", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnpagehide), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnpagehide) } },
    { "onpageshow", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnpageshow), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnpageshow) } },
    { "onpopstate", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnpopstate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnpopstate) } },
    { "onstorage", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnstorage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnstorage) } },
    { "onunload", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnunload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnunload) } },
#if ENABLE(ORIENTATION_EVENTS)
    { "onorientationchange", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOnorientationchange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOnorientationchange) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "origin", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOrigin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOrigin) } },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    { "WebKitPlaybackTargetAvailabilityEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebKitPlaybackTargetAvailabilityEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebKitPlaybackTargetAvailabilityEventConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(GEOLOCATION)
    { "Geolocation", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowGeolocationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowGeolocationConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(GEOLOCATION)
    { "GeolocationCoordinates", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowGeolocationCoordinatesConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowGeolocationCoordinatesConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(GEOLOCATION)
    { "GeolocationPosition", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowGeolocationPositionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowGeolocationPositionConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(GEOLOCATION)
    { "GeolocationPositionError", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowGeolocationPositionErrorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowGeolocationPositionErrorConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBCursor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowIDBCursorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowIDBCursorConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBCursorWithValue", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowIDBCursorWithValueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowIDBCursorWithValueConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBDatabase", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowIDBDatabaseConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowIDBDatabaseConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBFactory", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowIDBFactoryConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowIDBFactoryConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBIndex", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowIDBIndexConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowIDBIndexConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBKeyRange", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowIDBKeyRangeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowIDBKeyRangeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBObjectStore", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowIDBObjectStoreConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowIDBObjectStoreConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBOpenDBRequest", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowIDBOpenDBRequestConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowIDBOpenDBRequestConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBRequest", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowIDBRequestConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowIDBRequestConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBTransaction", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowIDBTransactionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowIDBTransactionConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(INDEXED_DATABASE)
    { "IDBVersionChangeEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowIDBVersionChangeEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowIDBVersionChangeEventConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SESSION)
    { "MediaRemoteControls", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMediaRemoteControlsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMediaRemoteControlsConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SESSION)
    { "MediaSession", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMediaSessionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMediaSessionConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SOURCE)
    { "SourceBuffer", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSourceBufferConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSourceBufferConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SOURCE)
    { "SourceBufferList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSourceBufferListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSourceBufferListConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "CanvasCaptureMediaStreamTrack", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCanvasCaptureMediaStreamTrackConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCanvasCaptureMediaStreamTrackConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "MediaDeviceInfo", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMediaDeviceInfoConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMediaDeviceInfoConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "MediaStream", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMediaStreamConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMediaStreamConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "MediaStreamTrack", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMediaStreamTrackConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMediaStreamTrackConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "MediaStreamTrackEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMediaStreamTrackEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMediaStreamTrackEventConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "OverconstrainedError", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOverconstrainedErrorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOverconstrainedErrorConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "OverconstrainedErrorEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOverconstrainedErrorEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOverconstrainedErrorEventConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(NOTIFICATIONS)
    { "Notification", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowNotificationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowNotificationConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(SPEECH_SYNTHESIS)
    { "SpeechSynthesisEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSpeechSynthesisEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSpeechSynthesisEventConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(SPEECH_SYNTHESIS)
    { "SpeechSynthesisUtterance", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSpeechSynthesisUtteranceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSpeechSynthesisUtteranceConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(STREAMS_API)
    { "ByteLengthQueuingStrategy", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowByteLengthQueuingStrategyConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowByteLengthQueuingStrategyConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(STREAMS_API)
    { "CountQueuingStrategy", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCountQueuingStrategyConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCountQueuingStrategyConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(STREAMS_API)
    { "ReadableStream", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowReadableStreamConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowReadableStreamConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "AnalyserNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowAnalyserNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowAnalyserNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "AudioBuffer", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowAudioBufferConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowAudioBufferConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "AudioBufferSourceNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowAudioBufferSourceNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowAudioBufferSourceNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "AudioDestinationNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowAudioDestinationNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowAudioDestinationNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "AudioListener", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowAudioListenerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowAudioListenerConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "AudioNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowAudioNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowAudioNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "AudioParam", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowAudioParamConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowAudioParamConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "AudioProcessingEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowAudioProcessingEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowAudioProcessingEventConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "BiquadFilterNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowBiquadFilterNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowBiquadFilterNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "ChannelMergerNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowChannelMergerNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowChannelMergerNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "ChannelSplitterNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowChannelSplitterNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowChannelSplitterNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "ConvolverNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowConvolverNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowConvolverNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "DelayNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDelayNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDelayNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "DynamicsCompressorNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDynamicsCompressorNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDynamicsCompressorNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "GainNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowGainNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowGainNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO) && ENABLE(WEB_AUDIO)
    { "MediaElementAudioSourceNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMediaElementAudioSourceNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMediaElementAudioSourceNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_AUDIO)
    { "MediaStreamAudioDestinationNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMediaStreamAudioDestinationNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMediaStreamAudioDestinationNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_AUDIO)
    { "MediaStreamAudioSourceNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMediaStreamAudioSourceNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMediaStreamAudioSourceNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "OfflineAudioCompletionEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOfflineAudioCompletionEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOfflineAudioCompletionEventConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "webkitOfflineAudioContext", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebkitOfflineAudioContextConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebkitOfflineAudioContextConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "OscillatorNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOscillatorNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOscillatorNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "webkitAudioPannerNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebkitAudioPannerNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebkitAudioPannerNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "PeriodicWave", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowPeriodicWaveConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowPeriodicWaveConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "ScriptProcessorNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowScriptProcessorNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowScriptProcessorNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "WaveShaperNode", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWaveShaperNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWaveShaperNodeConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "SQLTransaction", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSQLTransactionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSQLTransactionConstructor) } },
    { "CloseEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCloseEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCloseEventConstructor) } },
#if ENABLE(WEB_CRYPTO)
    { "CryptoKey", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCryptoKeyConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCryptoKeyConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_CRYPTO)
    { "SubtleCrypto", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSubtleCryptoConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSubtleCryptoConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "CSSFontFaceRule", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSFontFaceRuleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSFontFaceRuleConstructor) } },
    { "CSSImportRule", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSImportRuleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSImportRuleConstructor) } },
    { "CSSKeyframeRule", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSKeyframeRuleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSKeyframeRuleConstructor) } },
    { "CSSKeyframesRule", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSKeyframesRuleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSKeyframesRuleConstructor) } },
    { "CSSMediaRule", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSMediaRuleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSMediaRuleConstructor) } },
    { "CSSNamespaceRule", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSNamespaceRuleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSNamespaceRuleConstructor) } },
    { "CSSPageRule", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSPageRuleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSPageRuleConstructor) } },
    { "CSSRule", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSRuleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSRuleConstructor) } },
    { "CSSRuleList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSRuleListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSRuleListConstructor) } },
    { "CSSStyleDeclaration", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSStyleDeclarationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSStyleDeclarationConstructor) } },
    { "CSSStyleRule", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSStyleRuleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSStyleRuleConstructor) } },
    { "CSSStyleSheet", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSStyleSheetConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSStyleSheetConstructor) } },
    { "CSSSupportsRule", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSSupportsRuleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSSupportsRuleConstructor) } },
    { "CSS", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSConstructor) } },
    { "DOMMatrix", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDOMMatrixConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDOMMatrixConstructor) } },
    { "DOMMatrixReadOnly", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDOMMatrixReadOnlyConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDOMMatrixReadOnlyConstructor) } },
    { "Counter", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCounterConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCounterConstructor) } },
    { "CSSPrimitiveValue", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSPrimitiveValueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSPrimitiveValueConstructor) } },
    { "RGBColor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowRGBColorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowRGBColorConstructor) } },
    { "Rect", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowRectConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowRectConstructor) } },
    { "CSSValue", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSValueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSValueConstructor) } },
    { "CSSValueList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCSSValueListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCSSValueListConstructor) } },
    { "FontFace", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowFontFaceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowFontFaceConstructor) } },
    { "FontFaceSet", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowFontFaceSetConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowFontFaceSetConstructor) } },
    { "MediaList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMediaListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMediaListConstructor) } },
    { "StyleSheet", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowStyleSheetConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowStyleSheetConstructor) } },
    { "StyleSheetList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowStyleSheetListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowStyleSheetListConstructor) } },
    { "WebKitCSSMatrix", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebKitCSSMatrixConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebKitCSSMatrixConstructor) } },
#if ENABLE(CSS_DEVICE_ADAPTATION)
    { "WebKitCSSViewportRule", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebKitCSSViewportRuleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebKitCSSViewportRuleConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "AbortController", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowAbortControllerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowAbortControllerConstructor) } },
    { "AbortSignal", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowAbortSignalConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowAbortSignalConstructor) } },
    { "AnimationEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowAnimationEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowAnimationEventConstructor) } },
    { "Attr", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowAttrConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowAttrConstructor) } },
    { "BeforeLoadEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowBeforeLoadEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowBeforeLoadEventConstructor) } },
    { "BeforeUnloadEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowBeforeUnloadEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowBeforeUnloadEventConstructor) } },
    { "CDATASection", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCDATASectionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCDATASectionConstructor) } },
    { "CharacterData", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCharacterDataConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCharacterDataConstructor) } },
    { "ClipboardEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowClipboardEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowClipboardEventConstructor) } },
    { "Comment", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCommentConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCommentConstructor) } },
    { "CompositionEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCompositionEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCompositionEventConstructor) } },
    { "CustomEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCustomEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCustomEventConstructor) } },
    { "DOMException", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDOMExceptionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDOMExceptionConstructor) } },
    { "DOMImplementation", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDOMImplementationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDOMImplementationConstructor) } },
    { "DOMPoint", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDOMPointConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDOMPointConstructor) } },
    { "DOMPointReadOnly", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDOMPointReadOnlyConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDOMPointReadOnlyConstructor) } },
    { "DOMQuad", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDOMQuadConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDOMQuadConstructor) } },
    { "DOMRect", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDOMRectConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDOMRectConstructor) } },
    { "DOMRectList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDOMRectListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDOMRectListConstructor) } },
    { "DOMRectReadOnly", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDOMRectReadOnlyConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDOMRectReadOnlyConstructor) } },
    { "DOMStringList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDOMStringListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDOMStringListConstructor) } },
    { "DOMStringMap", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDOMStringMapConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDOMStringMapConstructor) } },
    { "DataTransfer", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDataTransferConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDataTransferConstructor) } },
#if ENABLE(DEVICE_ORIENTATION)
    { "DeviceMotionEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDeviceMotionEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDeviceMotionEventConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(DEVICE_ORIENTATION)
    { "DeviceOrientationEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDeviceOrientationEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDeviceOrientationEventConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "Document", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDocumentConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDocumentConstructor) } },
    { "DocumentFragment", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDocumentFragmentConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDocumentFragmentConstructor) } },
    { "DocumentType", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDocumentTypeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDocumentTypeConstructor) } },
    { "DragEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDragEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDragEventConstructor) } },
    { "Element", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowElementConstructor) } },
    { "ErrorEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowErrorEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowErrorEventConstructor) } },
    { "Event", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowEventConstructor) } },
    { "EventTarget", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowEventTargetConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowEventTargetConstructor) } },
    { "FocusEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowFocusEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowFocusEventConstructor) } },
    { "HashChangeEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHashChangeEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHashChangeEventConstructor) } },
    { "KeyboardEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowKeyboardEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowKeyboardEventConstructor) } },
#if ENABLE(CHANNEL_MESSAGING)
    { "MessageChannel", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMessageChannelConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMessageChannelConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "MessageEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMessageEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMessageEventConstructor) } },
    { "MessagePort", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMessagePortConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMessagePortConstructor) } },
    { "MouseEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMouseEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMouseEventConstructor) } },
    { "MutationEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMutationEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMutationEventConstructor) } },
    { "MutationObserver", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMutationObserverConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMutationObserverConstructor) } },
    { "WebKitMutationObserver", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebKitMutationObserverConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebKitMutationObserverConstructor) } },
    { "MutationRecord", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMutationRecordConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMutationRecordConstructor) } },
    { "NamedNodeMap", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowNamedNodeMapConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowNamedNodeMapConstructor) } },
    { "Node", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowNodeConstructor) } },
    { "NodeFilter", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowNodeFilterConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowNodeFilterConstructor) } },
    { "NodeIterator", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowNodeIteratorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowNodeIteratorConstructor) } },
    { "NodeList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowNodeListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowNodeListConstructor) } },
    { "OverflowEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOverflowEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOverflowEventConstructor) } },
    { "PageTransitionEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowPageTransitionEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowPageTransitionEventConstructor) } },
    { "PopStateEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowPopStateEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowPopStateEventConstructor) } },
    { "ProcessingInstruction", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowProcessingInstructionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowProcessingInstructionConstructor) } },
    { "ProgressEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowProgressEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowProgressEventConstructor) } },
    { "PromiseRejectionEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowPromiseRejectionEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowPromiseRejectionEventConstructor) } },
    { "Range", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowRangeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowRangeConstructor) } },
    { "SecurityPolicyViolationEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSecurityPolicyViolationEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSecurityPolicyViolationEventConstructor) } },
    { "Text", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTextConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowTextConstructor) } },
    { "TextDecoder", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTextDecoderConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowTextDecoderConstructor) } },
    { "TextEncoder", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTextEncoderConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowTextEncoderConstructor) } },
    { "TextEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTextEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowTextEventConstructor) } },
#if ENABLE(TOUCH_EVENTS)
    { "Touch", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTouchConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowTouchConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "TouchEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTouchEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowTouchEventConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "TouchList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTouchListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowTouchListConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "TransitionEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTransitionEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowTransitionEventConstructor) } },
    { "TreeWalker", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTreeWalkerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowTreeWalkerConstructor) } },
    { "UIEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowUIEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowUIEventConstructor) } },
    { "WebKitAnimationEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebKitAnimationEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebKitAnimationEventConstructor) } },
    { "WebKitTransitionEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebKitTransitionEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebKitTransitionEventConstructor) } },
    { "WheelEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWheelEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWheelEventConstructor) } },
    { "XMLDocument", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowXMLDocumentConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowXMLDocumentConstructor) } },
    { "SVGDocument", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGDocumentConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGDocumentConstructor) } },
    { "Blob", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowBlobConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowBlobConstructor) } },
    { "File", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowFileConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowFileConstructor) } },
    { "FileError", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowFileErrorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowFileErrorConstructor) } },
    { "FileList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowFileListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowFileListConstructor) } },
    { "FileReader", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowFileReaderConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowFileReaderConstructor) } },
    { "FormData", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowFormDataConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowFormDataConstructor) } },
    { "DOMTokenList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDOMTokenListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDOMTokenListConstructor) } },
    { "URL", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowURLConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowURLConstructor) } },
    { "webkitURL", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebkitURLConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebkitURLConstructor) } },
    { "HTMLAllCollection", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLAllCollectionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLAllCollectionConstructor) } },
    { "HTMLAnchorElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLAnchorElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLAnchorElementConstructor) } },
    { "HTMLAppletElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLAppletElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLAppletElementConstructor) } },
    { "HTMLAreaElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLAreaElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLAreaElementConstructor) } },
#if ENABLE(VIDEO)
    { "HTMLAudioElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLAudioElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLAudioElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "Audio", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowAudioConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowAudioConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "HTMLBRElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLBRElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLBRElementConstructor) } },
    { "HTMLBaseElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLBaseElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLBaseElementConstructor) } },
    { "HTMLBodyElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLBodyElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLBodyElementConstructor) } },
    { "HTMLButtonElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLButtonElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLButtonElementConstructor) } },
    { "HTMLCanvasElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLCanvasElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLCanvasElementConstructor) } },
    { "HTMLCollection", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLCollectionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLCollectionConstructor) } },
    { "HTMLDListElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLDListElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLDListElementConstructor) } },
    { "HTMLDataElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLDataElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLDataElementConstructor) } },
    { "HTMLDetailsElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLDetailsElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLDetailsElementConstructor) } },
    { "HTMLDirectoryElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLDirectoryElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLDirectoryElementConstructor) } },
    { "HTMLDivElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLDivElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLDivElementConstructor) } },
    { "HTMLDocument", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLDocumentConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLDocumentConstructor) } },
    { "HTMLElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLElementConstructor) } },
    { "HTMLEmbedElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLEmbedElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLEmbedElementConstructor) } },
    { "HTMLFieldSetElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLFieldSetElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLFieldSetElementConstructor) } },
    { "HTMLFontElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLFontElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLFontElementConstructor) } },
    { "HTMLFormControlsCollection", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLFormControlsCollectionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLFormControlsCollectionConstructor) } },
    { "HTMLFormElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLFormElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLFormElementConstructor) } },
    { "HTMLFrameElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLFrameElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLFrameElementConstructor) } },
    { "HTMLFrameSetElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLFrameSetElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLFrameSetElementConstructor) } },
    { "HTMLHRElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLHRElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLHRElementConstructor) } },
    { "HTMLHeadElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLHeadElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLHeadElementConstructor) } },
    { "HTMLHeadingElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLHeadingElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLHeadingElementConstructor) } },
    { "HTMLHtmlElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLHtmlElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLHtmlElementConstructor) } },
    { "HTMLIFrameElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLIFrameElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLIFrameElementConstructor) } },
    { "HTMLImageElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLImageElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLImageElementConstructor) } },
    { "Image", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowImageConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowImageConstructor) } },
    { "HTMLInputElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLInputElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLInputElementConstructor) } },
    { "HTMLLIElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLLIElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLLIElementConstructor) } },
    { "HTMLLabelElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLLabelElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLLabelElementConstructor) } },
    { "HTMLLegendElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLLegendElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLLegendElementConstructor) } },
    { "HTMLLinkElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLLinkElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLLinkElementConstructor) } },
    { "HTMLMapElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLMapElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLMapElementConstructor) } },
    { "HTMLMarqueeElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLMarqueeElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLMarqueeElementConstructor) } },
#if ENABLE(VIDEO)
    { "HTMLMediaElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLMediaElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLMediaElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "HTMLMenuElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLMenuElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLMenuElementConstructor) } },
    { "HTMLMetaElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLMetaElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLMetaElementConstructor) } },
#if ENABLE(METER_ELEMENT)
    { "HTMLMeterElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLMeterElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLMeterElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "HTMLModElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLModElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLModElementConstructor) } },
    { "HTMLOListElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLOListElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLOListElementConstructor) } },
    { "HTMLObjectElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLObjectElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLObjectElementConstructor) } },
    { "HTMLOptGroupElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLOptGroupElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLOptGroupElementConstructor) } },
    { "HTMLOptionElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLOptionElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLOptionElementConstructor) } },
    { "Option", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowOptionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowOptionConstructor) } },
    { "HTMLOptionsCollection", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLOptionsCollectionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLOptionsCollectionConstructor) } },
    { "HTMLOutputElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLOutputElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLOutputElementConstructor) } },
    { "HTMLParagraphElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLParagraphElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLParagraphElementConstructor) } },
    { "HTMLParamElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLParamElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLParamElementConstructor) } },
    { "HTMLPictureElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLPictureElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLPictureElementConstructor) } },
    { "HTMLPreElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLPreElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLPreElementConstructor) } },
    { "HTMLProgressElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLProgressElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLProgressElementConstructor) } },
    { "HTMLQuoteElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLQuoteElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLQuoteElementConstructor) } },
    { "HTMLScriptElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLScriptElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLScriptElementConstructor) } },
    { "HTMLSelectElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLSelectElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLSelectElementConstructor) } },
    { "HTMLSourceElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLSourceElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLSourceElementConstructor) } },
    { "HTMLSpanElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLSpanElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLSpanElementConstructor) } },
    { "HTMLStyleElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLStyleElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLStyleElementConstructor) } },
    { "HTMLTableCaptionElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLTableCaptionElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLTableCaptionElementConstructor) } },
    { "HTMLTableCellElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLTableCellElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLTableCellElementConstructor) } },
    { "HTMLTableColElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLTableColElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLTableColElementConstructor) } },
    { "HTMLTableElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLTableElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLTableElementConstructor) } },
    { "HTMLTableRowElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLTableRowElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLTableRowElementConstructor) } },
    { "HTMLTableSectionElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLTableSectionElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLTableSectionElementConstructor) } },
    { "HTMLTemplateElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLTemplateElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLTemplateElementConstructor) } },
    { "HTMLTextAreaElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLTextAreaElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLTextAreaElementConstructor) } },
    { "HTMLTimeElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLTimeElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLTimeElementConstructor) } },
    { "HTMLTitleElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLTitleElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLTitleElementConstructor) } },
#if ENABLE(VIDEO_TRACK)
    { "HTMLTrackElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLTrackElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLTrackElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "HTMLUListElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLUListElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLUListElementConstructor) } },
    { "HTMLUnknownElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLUnknownElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLUnknownElementConstructor) } },
#if ENABLE(VIDEO)
    { "HTMLVideoElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHTMLVideoElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHTMLVideoElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "ImageData", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowImageDataConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowImageDataConstructor) } },
#if ENABLE(VIDEO)
    { "MediaController", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMediaControllerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMediaControllerConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "MediaError", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMediaErrorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMediaErrorConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "RadioNodeList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowRadioNodeListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowRadioNodeListConstructor) } },
    { "TextMetrics", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTextMetricsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowTextMetricsConstructor) } },
#if ENABLE(VIDEO)
    { "TimeRanges", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTimeRangesConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowTimeRangesConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "URLSearchParams", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowURLSearchParamsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowURLSearchParamsConstructor) } },
    { "ValidityState", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowValidityStateConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowValidityStateConstructor) } },
    { "CanvasGradient", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCanvasGradientConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCanvasGradientConstructor) } },
    { "CanvasPattern", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCanvasPatternConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCanvasPatternConstructor) } },
    { "CanvasRenderingContext2D", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCanvasRenderingContext2DConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCanvasRenderingContext2DConstructor) } },
    { "Path2D", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowPath2DConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowPath2DConstructor) } },
#if ENABLE(WEBGL)
    { "WebGLActiveInfo", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebGLActiveInfoConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebGLActiveInfoConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "WebGLBuffer", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebGLBufferConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebGLBufferConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "WebGLContextEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebGLContextEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebGLContextEventConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "WebGLFramebuffer", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebGLFramebufferConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebGLFramebufferConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "WebGLProgram", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebGLProgramConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebGLProgramConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "WebGLQuery", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebGLQueryConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebGLQueryConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "WebGLRenderbuffer", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebGLRenderbufferConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebGLRenderbufferConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "WebGLRenderingContext", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebGLRenderingContextConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebGLRenderingContextConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "WebGLSampler", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebGLSamplerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebGLSamplerConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "WebGLShader", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebGLShaderConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebGLShaderConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "WebGLShaderPrecisionFormat", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebGLShaderPrecisionFormatConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebGLShaderPrecisionFormatConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "WebGLSync", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebGLSyncConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebGLSyncConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "WebGLTexture", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebGLTextureConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebGLTextureConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "WebGLTransformFeedback", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebGLTransformFeedbackConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebGLTransformFeedbackConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "WebGLUniformLocation", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebGLUniformLocationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebGLUniformLocationConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "AudioTrack", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowAudioTrackConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowAudioTrackConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "AudioTrackList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowAudioTrackListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowAudioTrackListConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "DataCue", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDataCueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDataCueConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "TextTrack", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTextTrackConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowTextTrackConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "TextTrackCue", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTextTrackCueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowTextTrackCueConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "TextTrackCueList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTextTrackCueListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowTextTrackCueListConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "TextTrackList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTextTrackListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowTextTrackListConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "TrackEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowTrackEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowTrackEventConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "VTTCue", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowVTTCueConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowVTTCueConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "VTTRegion", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowVTTRegionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowVTTRegionConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "VideoTrack", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowVideoTrackConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowVideoTrackConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "VideoTrackList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowVideoTrackListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowVideoTrackListConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "ApplicationCache", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowApplicationCacheConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowApplicationCacheConstructor) } },
#if ENABLE(MATHML)
    { "MathMLElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMathMLElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMathMLElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MATHML)
    { "MathMLMathElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMathMLMathElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMathMLMathElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "BarProp", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowBarPropConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowBarPropConstructor) } },
    { "Crypto", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowCryptoConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowCryptoConstructor) } },
    { "Selection", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSelectionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSelectionConstructor) } },
    { "Window", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWindowConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWindowConstructor) } },
    { "EventSource", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowEventSourceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowEventSourceConstructor) } },
    { "History", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowHistoryConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowHistoryConstructor) } },
    { "Location", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowLocationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowLocationConstructor) } },
    { "Navigator", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowNavigatorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowNavigatorConstructor) } },
    { "Performance", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowPerformanceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowPerformanceConstructor) } },
    { "PerformanceNavigation", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowPerformanceNavigationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowPerformanceNavigationConstructor) } },
    { "PerformanceTiming", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowPerformanceTimingConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowPerformanceTimingConstructor) } },
    { "Screen", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowScreenConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowScreenConstructor) } },
#if ENABLE(USER_MESSAGE_HANDLERS)
    { "UserMessageHandler", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowUserMessageHandlerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowUserMessageHandlerConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(USER_MESSAGE_HANDLERS)
    { "UserMessageHandlersNamespace", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowUserMessageHandlersNamespaceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowUserMessageHandlersNamespaceConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(USER_MESSAGE_HANDLERS)
    { "WebKitNamespace", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebKitNamespaceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebKitNamespaceConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "WebKitPoint", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWebKitPointConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWebKitPointConstructor) } },
    { "MimeType", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMimeTypeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMimeTypeConstructor) } },
    { "MimeTypeArray", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowMimeTypeArrayConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowMimeTypeArrayConstructor) } },
    { "Plugin", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowPluginConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowPluginConstructor) } },
    { "PluginArray", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowPluginArrayConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowPluginArrayConstructor) } },
    { "Storage", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowStorageConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowStorageConstructor) } },
    { "StorageEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowStorageEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowStorageEventConstructor) } },
    { "SVGAElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAElementConstructor) } },
#if ENABLE(SVG_FONTS)
    { "SVGAltGlyphDefElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAltGlyphDefElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAltGlyphDefElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(SVG_FONTS)
    { "SVGAltGlyphElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAltGlyphElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAltGlyphElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(SVG_FONTS)
    { "SVGAltGlyphItemElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAltGlyphItemElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAltGlyphItemElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "SVGAngle", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAngleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAngleConstructor) } },
    { "SVGAnimateColorElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimateColorElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimateColorElementConstructor) } },
    { "SVGAnimateElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimateElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimateElementConstructor) } },
    { "SVGAnimateMotionElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimateMotionElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimateMotionElementConstructor) } },
    { "SVGAnimateTransformElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimateTransformElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimateTransformElementConstructor) } },
    { "SVGAnimatedAngle", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimatedAngleConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimatedAngleConstructor) } },
    { "SVGAnimatedBoolean", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimatedBooleanConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimatedBooleanConstructor) } },
    { "SVGAnimatedEnumeration", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimatedEnumerationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimatedEnumerationConstructor) } },
    { "SVGAnimatedInteger", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimatedIntegerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimatedIntegerConstructor) } },
    { "SVGAnimatedLength", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimatedLengthConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimatedLengthConstructor) } },
    { "SVGAnimatedLengthList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimatedLengthListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimatedLengthListConstructor) } },
    { "SVGAnimatedNumber", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimatedNumberConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimatedNumberConstructor) } },
    { "SVGAnimatedNumberList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimatedNumberListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimatedNumberListConstructor) } },
    { "SVGAnimatedPreserveAspectRatio", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimatedPreserveAspectRatioConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimatedPreserveAspectRatioConstructor) } },
    { "SVGAnimatedRect", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimatedRectConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimatedRectConstructor) } },
    { "SVGAnimatedString", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimatedStringConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimatedStringConstructor) } },
    { "SVGAnimatedTransformList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimatedTransformListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimatedTransformListConstructor) } },
    { "SVGAnimationElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGAnimationElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGAnimationElementConstructor) } },
    { "SVGCircleElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGCircleElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGCircleElementConstructor) } },
    { "SVGClipPathElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGClipPathElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGClipPathElementConstructor) } },
    { "SVGComponentTransferFunctionElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGComponentTransferFunctionElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGComponentTransferFunctionElementConstructor) } },
    { "SVGCursorElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGCursorElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGCursorElementConstructor) } },
    { "SVGDefsElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGDefsElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGDefsElementConstructor) } },
    { "SVGDescElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGDescElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGDescElementConstructor) } },
    { "SVGElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGElementConstructor) } },
    { "SVGEllipseElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGEllipseElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGEllipseElementConstructor) } },
    { "SVGFEBlendElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEBlendElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEBlendElementConstructor) } },
    { "SVGFEColorMatrixElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEColorMatrixElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEColorMatrixElementConstructor) } },
    { "SVGFEComponentTransferElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEComponentTransferElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEComponentTransferElementConstructor) } },
    { "SVGFECompositeElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFECompositeElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFECompositeElementConstructor) } },
    { "SVGFEConvolveMatrixElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEConvolveMatrixElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEConvolveMatrixElementConstructor) } },
    { "SVGFEDiffuseLightingElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEDiffuseLightingElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEDiffuseLightingElementConstructor) } },
    { "SVGFEDisplacementMapElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEDisplacementMapElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEDisplacementMapElementConstructor) } },
    { "SVGFEDistantLightElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEDistantLightElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEDistantLightElementConstructor) } },
    { "SVGFEDropShadowElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEDropShadowElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEDropShadowElementConstructor) } },
    { "SVGFEFloodElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEFloodElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEFloodElementConstructor) } },
    { "SVGFEFuncAElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEFuncAElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEFuncAElementConstructor) } },
    { "SVGFEFuncBElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEFuncBElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEFuncBElementConstructor) } },
    { "SVGFEFuncGElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEFuncGElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEFuncGElementConstructor) } },
    { "SVGFEFuncRElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEFuncRElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEFuncRElementConstructor) } },
    { "SVGFEGaussianBlurElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEGaussianBlurElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEGaussianBlurElementConstructor) } },
    { "SVGFEImageElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEImageElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEImageElementConstructor) } },
    { "SVGFEMergeElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEMergeElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEMergeElementConstructor) } },
    { "SVGFEMergeNodeElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEMergeNodeElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEMergeNodeElementConstructor) } },
    { "SVGFEMorphologyElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEMorphologyElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEMorphologyElementConstructor) } },
    { "SVGFEOffsetElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEOffsetElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEOffsetElementConstructor) } },
    { "SVGFEPointLightElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFEPointLightElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFEPointLightElementConstructor) } },
    { "SVGFESpecularLightingElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFESpecularLightingElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFESpecularLightingElementConstructor) } },
    { "SVGFESpotLightElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFESpotLightElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFESpotLightElementConstructor) } },
    { "SVGFETileElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFETileElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFETileElementConstructor) } },
    { "SVGFETurbulenceElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFETurbulenceElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFETurbulenceElementConstructor) } },
    { "SVGFilterElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFilterElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFilterElementConstructor) } },
#if ENABLE(SVG_FONTS)
    { "SVGFontElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFontElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFontElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(SVG_FONTS)
    { "SVGFontFaceElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFontFaceElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFontFaceElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(SVG_FONTS)
    { "SVGFontFaceFormatElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFontFaceFormatElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFontFaceFormatElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(SVG_FONTS)
    { "SVGFontFaceNameElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFontFaceNameElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFontFaceNameElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(SVG_FONTS)
    { "SVGFontFaceSrcElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFontFaceSrcElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFontFaceSrcElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(SVG_FONTS)
    { "SVGFontFaceUriElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGFontFaceUriElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGFontFaceUriElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "SVGForeignObjectElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGForeignObjectElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGForeignObjectElementConstructor) } },
    { "SVGGElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGGElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGGElementConstructor) } },
    { "SVGGeometryElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGGeometryElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGGeometryElementConstructor) } },
#if ENABLE(SVG_FONTS)
    { "SVGGlyphElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGGlyphElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGGlyphElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(SVG_FONTS)
    { "SVGGlyphRefElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGGlyphRefElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGGlyphRefElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "SVGGradientElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGGradientElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGGradientElementConstructor) } },
    { "SVGGraphicsElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGGraphicsElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGGraphicsElementConstructor) } },
#if ENABLE(SVG_FONTS)
    { "SVGHKernElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGHKernElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGHKernElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "SVGImageElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGImageElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGImageElementConstructor) } },
    { "SVGLength", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGLengthConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGLengthConstructor) } },
    { "SVGLengthList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGLengthListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGLengthListConstructor) } },
    { "SVGLineElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGLineElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGLineElementConstructor) } },
    { "SVGLinearGradientElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGLinearGradientElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGLinearGradientElementConstructor) } },
    { "SVGMPathElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGMPathElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGMPathElementConstructor) } },
    { "SVGMarkerElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGMarkerElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGMarkerElementConstructor) } },
    { "SVGMaskElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGMaskElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGMaskElementConstructor) } },
    { "SVGMatrix", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGMatrixConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGMatrixConstructor) } },
    { "SVGMetadataElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGMetadataElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGMetadataElementConstructor) } },
#if ENABLE(SVG_FONTS)
    { "SVGMissingGlyphElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGMissingGlyphElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGMissingGlyphElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "SVGNumber", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGNumberConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGNumberConstructor) } },
    { "SVGNumberList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGNumberListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGNumberListConstructor) } },
    { "SVGPathElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathElementConstructor) } },
    { "SVGPathSeg", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegConstructor) } },
    { "SVGPathSegArcAbs", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegArcAbsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegArcAbsConstructor) } },
    { "SVGPathSegArcRel", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegArcRelConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegArcRelConstructor) } },
    { "SVGPathSegClosePath", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegClosePathConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegClosePathConstructor) } },
    { "SVGPathSegCurvetoCubicAbs", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegCurvetoCubicAbsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegCurvetoCubicAbsConstructor) } },
    { "SVGPathSegCurvetoCubicRel", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegCurvetoCubicRelConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegCurvetoCubicRelConstructor) } },
    { "SVGPathSegCurvetoCubicSmoothAbs", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegCurvetoCubicSmoothAbsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegCurvetoCubicSmoothAbsConstructor) } },
    { "SVGPathSegCurvetoCubicSmoothRel", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegCurvetoCubicSmoothRelConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegCurvetoCubicSmoothRelConstructor) } },
    { "SVGPathSegCurvetoQuadraticAbs", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegCurvetoQuadraticAbsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegCurvetoQuadraticAbsConstructor) } },
    { "SVGPathSegCurvetoQuadraticRel", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegCurvetoQuadraticRelConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegCurvetoQuadraticRelConstructor) } },
    { "SVGPathSegCurvetoQuadraticSmoothAbs", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegCurvetoQuadraticSmoothAbsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegCurvetoQuadraticSmoothAbsConstructor) } },
    { "SVGPathSegCurvetoQuadraticSmoothRel", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegCurvetoQuadraticSmoothRelConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegCurvetoQuadraticSmoothRelConstructor) } },
    { "SVGPathSegLinetoAbs", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegLinetoAbsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegLinetoAbsConstructor) } },
    { "SVGPathSegLinetoHorizontalAbs", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegLinetoHorizontalAbsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegLinetoHorizontalAbsConstructor) } },
    { "SVGPathSegLinetoHorizontalRel", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegLinetoHorizontalRelConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegLinetoHorizontalRelConstructor) } },
    { "SVGPathSegLinetoRel", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegLinetoRelConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegLinetoRelConstructor) } },
    { "SVGPathSegLinetoVerticalAbs", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegLinetoVerticalAbsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegLinetoVerticalAbsConstructor) } },
    { "SVGPathSegLinetoVerticalRel", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegLinetoVerticalRelConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegLinetoVerticalRelConstructor) } },
    { "SVGPathSegList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegListConstructor) } },
    { "SVGPathSegMovetoAbs", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegMovetoAbsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegMovetoAbsConstructor) } },
    { "SVGPathSegMovetoRel", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPathSegMovetoRelConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPathSegMovetoRelConstructor) } },
    { "SVGPatternElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPatternElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPatternElementConstructor) } },
    { "SVGPoint", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPointConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPointConstructor) } },
    { "SVGPointList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPointListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPointListConstructor) } },
    { "SVGPolygonElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPolygonElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPolygonElementConstructor) } },
    { "SVGPolylineElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPolylineElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPolylineElementConstructor) } },
    { "SVGPreserveAspectRatio", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGPreserveAspectRatioConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGPreserveAspectRatioConstructor) } },
    { "SVGRadialGradientElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGRadialGradientElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGRadialGradientElementConstructor) } },
    { "SVGRect", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGRectConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGRectConstructor) } },
    { "SVGRectElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGRectElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGRectElementConstructor) } },
    { "SVGRenderingIntent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGRenderingIntentConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGRenderingIntentConstructor) } },
    { "SVGSVGElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGSVGElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGSVGElementConstructor) } },
    { "SVGScriptElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGScriptElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGScriptElementConstructor) } },
    { "SVGSetElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGSetElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGSetElementConstructor) } },
    { "SVGStopElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGStopElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGStopElementConstructor) } },
    { "SVGStringList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGStringListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGStringListConstructor) } },
    { "SVGStyleElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGStyleElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGStyleElementConstructor) } },
    { "SVGSwitchElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGSwitchElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGSwitchElementConstructor) } },
    { "SVGSymbolElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGSymbolElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGSymbolElementConstructor) } },
    { "SVGTRefElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGTRefElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGTRefElementConstructor) } },
    { "SVGTSpanElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGTSpanElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGTSpanElementConstructor) } },
    { "SVGTextContentElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGTextContentElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGTextContentElementConstructor) } },
    { "SVGTextElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGTextElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGTextElementConstructor) } },
    { "SVGTextPathElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGTextPathElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGTextPathElementConstructor) } },
    { "SVGTextPositioningElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGTextPositioningElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGTextPositioningElementConstructor) } },
    { "SVGTitleElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGTitleElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGTitleElementConstructor) } },
    { "SVGTransform", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGTransformConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGTransformConstructor) } },
    { "SVGTransformList", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGTransformListConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGTransformListConstructor) } },
    { "SVGUnitTypes", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGUnitTypesConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGUnitTypesConstructor) } },
    { "SVGUseElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGUseElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGUseElementConstructor) } },
#if ENABLE(SVG_FONTS)
    { "SVGVKernElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGVKernElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGVKernElementConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "SVGViewElement", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGViewElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGViewElementConstructor) } },
    { "SVGViewSpec", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGViewSpecConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGViewSpecConstructor) } },
    { "SVGZoomEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowSVGZoomEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowSVGZoomEventConstructor) } },
    { "Worker", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowWorkerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowWorkerConstructor) } },
    { "DOMParser", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowDOMParserConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowDOMParserConstructor) } },
    { "XMLHttpRequest", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowXMLHttpRequestConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowXMLHttpRequestConstructor) } },
    { "XMLHttpRequestEventTarget", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowXMLHttpRequestEventTargetConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowXMLHttpRequestEventTargetConstructor) } },
    { "XMLHttpRequestProgressEvent", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowXMLHttpRequestProgressEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowXMLHttpRequestProgressEventConstructor) } },
    { "XMLHttpRequestUpload", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowXMLHttpRequestUploadConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowXMLHttpRequestUploadConstructor) } },
    { "XMLSerializer", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowXMLSerializerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowXMLSerializerConstructor) } },
    { "XPathEvaluator", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowXPathEvaluatorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowXPathEvaluatorConstructor) } },
    { "XPathExpression", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowXPathExpressionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowXPathExpressionConstructor) } },
    { "XPathResult", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowXPathResultConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowXPathResultConstructor) } },
#if ENABLE(XSLT)
    { "XSLTProcessor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowXSLTProcessorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowXSLTProcessorConstructor) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "close", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionClose), (intptr_t) (0) } },
    { "stop", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionStop), (intptr_t) (0) } },
    { "focus", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionFocus), (intptr_t) (0) } },
    { "blur", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionBlur), (intptr_t) (0) } },
    { "open", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionOpen), (intptr_t) (0) } },
    { "alert", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionAlert), (intptr_t) (0) } },
    { "confirm", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionConfirm), (intptr_t) (0) } },
    { "prompt", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionPrompt), (intptr_t) (0) } },
    { "print", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionPrint), (intptr_t) (0) } },
    { "requestAnimationFrame", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionRequestAnimationFrame), (intptr_t) (1) } },
    { "cancelAnimationFrame", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionCancelAnimationFrame), (intptr_t) (1) } },
    { "postMessage", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionPostMessage), (intptr_t) (1) } },
    { "captureEvents", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionCaptureEvents), (intptr_t) (0) } },
    { "releaseEvents", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionReleaseEvents), (intptr_t) (0) } },
    { "getComputedStyle", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionGetComputedStyle), (intptr_t) (1) } },
    { "matchMedia", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionMatchMedia), (intptr_t) (1) } },
    { "moveTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionMoveTo), (intptr_t) (0) } },
    { "moveBy", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionMoveBy), (intptr_t) (0) } },
    { "resizeTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionResizeTo), (intptr_t) (0) } },
    { "resizeBy", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionResizeBy), (intptr_t) (0) } },
    { "scroll", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionScroll), (intptr_t) (0) } },
    { "scrollTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionScrollTo), (intptr_t) (0) } },
    { "scrollBy", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionScrollBy), (intptr_t) (0) } },
    { "getSelection", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionGetSelection), (intptr_t) (0) } },
    { "find", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionFind), (intptr_t) (0) } },
    { "webkitRequestAnimationFrame", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionWebkitRequestAnimationFrame), (intptr_t) (1) } },
    { "webkitCancelAnimationFrame", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionWebkitCancelAnimationFrame), (intptr_t) (1) } },
    { "webkitCancelRequestAnimationFrame", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionWebkitCancelRequestAnimationFrame), (intptr_t) (1) } },
    { "getMatchedCSSRules", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionGetMatchedCSSRules), (intptr_t) (0) } },
    { "showModalDialog", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionShowModalDialog), (intptr_t) (1) } },
    { "webkitConvertPointFromPageToNode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionWebkitConvertPointFromPageToNode), (intptr_t) (0) } },
    { "webkitConvertPointFromNodeToPage", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionWebkitConvertPointFromNodeToPage), (intptr_t) (0) } },
    { "setTimeout", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionSetTimeout), (intptr_t) (1) } },
    { "clearTimeout", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionClearTimeout), (intptr_t) (0) } },
    { "setInterval", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionSetInterval), (intptr_t) (1) } },
    { "clearInterval", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionClearInterval), (intptr_t) (0) } },
    { "queueMicrotask", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionQueueMicrotask), (intptr_t) (1) } },
    { "atob", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionAtob), (intptr_t) (1) } },
    { "btoa", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsDOMWindowInstanceFunctionBtoa), (intptr_t) (1) } },
};

static const HashTable JSDOMWindowTable = { 658, 2047, true, JSDOMWindow::info(), JSDOMWindowTableValues, JSDOMWindowTableIndex };
template<> JSValue JSDOMWindowConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSDOMWindowConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, globalObject.getPrototypeDirect(vm), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("Window"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSDOMWindowConstructor::s_info = { "Window", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDOMWindowConstructor) };

/* Hash table for prototype */

static const struct CompactHashIndex JSDOMWindowPrototypeTableIndex[2] = {
    { -1, -1 },
    { 0, -1 },
};


static const HashTableValue JSDOMWindowPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMWindowConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSDOMWindowConstructor) } },
};

static const HashTable JSDOMWindowPrototypeTable = { 1, 1, true, JSDOMWindow::info(), JSDOMWindowPrototypeTableValues, JSDOMWindowPrototypeTableIndex };
const ClassInfo JSDOMWindowPrototype::s_info = { "WindowPrototype", &Base::s_info, &JSDOMWindowPrototypeTable, nullptr, CREATE_METHOD_TABLE(JSDOMWindowPrototype) };

const ClassInfo JSDOMWindow::s_info = { "Window", &Base::s_info, &JSDOMWindowTable, nullptr, CREATE_METHOD_TABLE(JSDOMWindow) };

JSDOMWindow::JSDOMWindow(VM& vm, Structure* structure, Ref<DOMWindow>&& impl, JSWindowProxy* proxy)
    : JSDOMWindowBase(vm, structure, WTFMove(impl), proxy)
{
}

void JSDOMWindow::finishCreation(VM& vm, JSWindowProxy* proxy)
{
    Base::finishCreation(vm, proxy);

    static_assert(!std::is_base_of<ActiveDOMObject, DOMWindow>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

    if (RuntimeEnabledFeatures::sharedFeatures().customElementsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().customElementsPublicName(), CustomGetterSetter::create(vm, jsDOMWindowCustomElements, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor)));
    if (downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().visualViewportAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().visualViewportPublicName(), CustomGetterSetter::create(vm, jsDOMWindowVisualViewport, setJSDOMWindowVisualViewport), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor)));
    if (((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext()|| jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->hasServiceWorkerScheme()) && RuntimeEnabledFeatures::sharedFeatures().cacheAPIEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().cachesPublicName(), CustomGetterSetter::create(vm, jsDOMWindowCaches, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor)));
#if ENABLE(TOUCH_EVENTS)
    if (RuntimeEnabledFeatures::sharedFeatures().touchEventsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ontouchcancelPublicName(), CustomGetterSetter::create(vm, jsDOMWindowOntouchcancel, setJSDOMWindowOntouchcancel), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor)));
#endif
#if ENABLE(TOUCH_EVENTS)
    if (RuntimeEnabledFeatures::sharedFeatures().touchEventsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ontouchendPublicName(), CustomGetterSetter::create(vm, jsDOMWindowOntouchend, setJSDOMWindowOntouchend), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor)));
#endif
#if ENABLE(TOUCH_EVENTS)
    if (RuntimeEnabledFeatures::sharedFeatures().touchEventsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ontouchmovePublicName(), CustomGetterSetter::create(vm, jsDOMWindowOntouchmove, setJSDOMWindowOntouchmove), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor)));
#endif
#if ENABLE(TOUCH_EVENTS)
    if (RuntimeEnabledFeatures::sharedFeatures().touchEventsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ontouchstartPublicName(), CustomGetterSetter::create(vm, jsDOMWindowOntouchstart, setJSDOMWindowOntouchstart), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor)));
#endif
#if ENABLE(TOUCH_EVENTS)
    if (RuntimeEnabledFeatures::sharedFeatures().touchEventsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ontouchforcechangePublicName(), CustomGetterSetter::create(vm, jsDOMWindowOntouchforcechange, setJSDOMWindowOntouchforcechange), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::CustomAccessor)));
#endif
    if (RuntimeEnabledFeatures::sharedFeatures().isSecureContextAttributeEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().isSecureContextPublicName(), CustomGetterSetter::create(vm, jsDOMWindowIsSecureContext, nullptr), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().asyncClipboardAPIEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ClipboardPublicName(), CustomGetterSetter::create(vm, jsDOMWindowClipboardConstructor, setJSDOMWindowClipboardConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().asyncClipboardAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ClipboardItemPublicName(), CustomGetterSetter::create(vm, jsDOMWindowClipboardItemConstructor, setJSDOMWindowClipboardItemConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && RuntimeEnabledFeatures::sharedFeatures().cacheAPIEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CachePublicName(), CustomGetterSetter::create(vm, jsDOMWindowCacheConstructor, setJSDOMWindowCacheConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && RuntimeEnabledFeatures::sharedFeatures().cacheAPIEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CacheStoragePublicName(), CustomGetterSetter::create(vm, jsDOMWindowCacheStorageConstructor, setJSDOMWindowCacheStorageConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(WEB_AUTHN)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && RuntimeEnabledFeatures::sharedFeatures().webAuthenticationEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CredentialPublicName(), CustomGetterSetter::create(vm, jsDOMWindowCredentialConstructor, setJSDOMWindowCredentialConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_AUTHN)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && RuntimeEnabledFeatures::sharedFeatures().webAuthenticationEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CredentialsContainerPublicName(), CustomGetterSetter::create(vm, jsDOMWindowCredentialsContainerConstructor, setJSDOMWindowCredentialsContainerConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
    if (RuntimeEnabledFeatures::sharedFeatures().directoryUploadEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().FileSystemPublicName(), CustomGetterSetter::create(vm, jsDOMWindowFileSystemConstructor, setJSDOMWindowFileSystemConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().directoryUploadEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().FileSystemDirectoryEntryPublicName(), CustomGetterSetter::create(vm, jsDOMWindowFileSystemDirectoryEntryConstructor, setJSDOMWindowFileSystemDirectoryEntryConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().directoryUploadEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().FileSystemDirectoryReaderPublicName(), CustomGetterSetter::create(vm, jsDOMWindowFileSystemDirectoryReaderConstructor, setJSDOMWindowFileSystemDirectoryReaderConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().directoryUploadEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().FileSystemEntryPublicName(), CustomGetterSetter::create(vm, jsDOMWindowFileSystemEntryConstructor, setJSDOMWindowFileSystemEntryConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().directoryUploadEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().FileSystemFileEntryPublicName(), CustomGetterSetter::create(vm, jsDOMWindowFileSystemFileEntryConstructor, setJSDOMWindowFileSystemFileEntryConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().HeadersPublicName(), CustomGetterSetter::create(vm, jsDOMWindowHeadersConstructor, setJSDOMWindowHeadersConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RequestPublicName(), CustomGetterSetter::create(vm, jsDOMWindowRequestConstructor, setJSDOMWindowRequestConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ResponsePublicName(), CustomGetterSetter::create(vm, jsDOMWindowResponseConstructor, setJSDOMWindowResponseConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().highlightAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().HighlightMapPublicName(), CustomGetterSetter::create(vm, jsDOMWindowHighlightMapConstructor, setJSDOMWindowHighlightMapConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().highlightAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().HighlightRangeGroupPublicName(), CustomGetterSetter::create(vm, jsDOMWindowHighlightRangeGroupConstructor, setJSDOMWindowHighlightRangeGroupConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().mediaCapabilitiesEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().MediaCapabilitiesPublicName(), CustomGetterSetter::create(vm, jsDOMWindowMediaCapabilitiesConstructor, setJSDOMWindowMediaCapabilitiesConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(MEDIA_STREAM)
    if (RuntimeEnabledFeatures::sharedFeatures().mediaRecorderEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().BlobEventPublicName(), CustomGetterSetter::create(vm, jsDOMWindowBlobEventConstructor, setJSDOMWindowBlobEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(MEDIA_STREAM)
    if (RuntimeEnabledFeatures::sharedFeatures().mediaRecorderEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().MediaRecorderPublicName(), CustomGetterSetter::create(vm, jsDOMWindowMediaRecorderConstructor, setJSDOMWindowMediaRecorderConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(MEDIA_STREAM)
    if (RuntimeEnabledFeatures::sharedFeatures().mediaRecorderEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().MediaRecorderErrorEventPublicName(), CustomGetterSetter::create(vm, jsDOMWindowMediaRecorderErrorEventConstructor, setJSDOMWindowMediaRecorderErrorEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(MEDIA_SOURCE)
    if (downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().mediaSourceEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().MediaSourcePublicName(), CustomGetterSetter::create(vm, jsDOMWindowMediaSourceConstructor, setJSDOMWindowMediaSourceConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(MEDIA_STREAM)
    if (jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().MediaDevicesPublicName(), CustomGetterSetter::create(vm, jsDOMWindowMediaDevicesConstructor, setJSDOMWindowMediaDevicesConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (RuntimeEnabledFeatures::sharedFeatures().peerConnectionEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCCertificatePublicName(), CustomGetterSetter::create(vm, jsDOMWindowRTCCertificateConstructor, setJSDOMWindowRTCCertificateConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (RuntimeEnabledFeatures::sharedFeatures().peerConnectionEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCDTMFSenderPublicName(), CustomGetterSetter::create(vm, jsDOMWindowRTCDTMFSenderConstructor, setJSDOMWindowRTCDTMFSenderConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (RuntimeEnabledFeatures::sharedFeatures().peerConnectionEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCDTMFToneChangeEventPublicName(), CustomGetterSetter::create(vm, jsDOMWindowRTCDTMFToneChangeEventConstructor, setJSDOMWindowRTCDTMFToneChangeEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (RuntimeEnabledFeatures::sharedFeatures().peerConnectionEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCDataChannelPublicName(), CustomGetterSetter::create(vm, jsDOMWindowRTCDataChannelConstructor, setJSDOMWindowRTCDataChannelConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (RuntimeEnabledFeatures::sharedFeatures().peerConnectionEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCDataChannelEventPublicName(), CustomGetterSetter::create(vm, jsDOMWindowRTCDataChannelEventConstructor, setJSDOMWindowRTCDataChannelEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (RuntimeEnabledFeatures::sharedFeatures().peerConnectionEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCIceCandidatePublicName(), CustomGetterSetter::create(vm, jsDOMWindowRTCIceCandidateConstructor, setJSDOMWindowRTCIceCandidateConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (RuntimeEnabledFeatures::sharedFeatures().peerConnectionEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCIceTransportPublicName(), CustomGetterSetter::create(vm, jsDOMWindowRTCIceTransportConstructor, setJSDOMWindowRTCIceTransportConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (RuntimeEnabledFeatures::sharedFeatures().peerConnectionEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCPeerConnectionPublicName(), CustomGetterSetter::create(vm, jsDOMWindowRTCPeerConnectionConstructor, setJSDOMWindowRTCPeerConnectionConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (RuntimeEnabledFeatures::sharedFeatures().peerConnectionEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCPeerConnectionIceEventPublicName(), CustomGetterSetter::create(vm, jsDOMWindowRTCPeerConnectionIceEventConstructor, setJSDOMWindowRTCPeerConnectionIceEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (RuntimeEnabledFeatures::sharedFeatures().peerConnectionEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCRtpReceiverPublicName(), CustomGetterSetter::create(vm, jsDOMWindowRTCRtpReceiverConstructor, setJSDOMWindowRTCRtpReceiverConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (RuntimeEnabledFeatures::sharedFeatures().peerConnectionEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCRtpSenderPublicName(), CustomGetterSetter::create(vm, jsDOMWindowRTCRtpSenderConstructor, setJSDOMWindowRTCRtpSenderConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (RuntimeEnabledFeatures::sharedFeatures().peerConnectionEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCRtpTransceiverPublicName(), CustomGetterSetter::create(vm, jsDOMWindowRTCRtpTransceiverConstructor, setJSDOMWindowRTCRtpTransceiverConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (RuntimeEnabledFeatures::sharedFeatures().peerConnectionEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCSessionDescriptionPublicName(), CustomGetterSetter::create(vm, jsDOMWindowRTCSessionDescriptionConstructor, setJSDOMWindowRTCSessionDescriptionConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (RuntimeEnabledFeatures::sharedFeatures().peerConnectionEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCStatsReportPublicName(), CustomGetterSetter::create(vm, jsDOMWindowRTCStatsReportConstructor, setJSDOMWindowRTCStatsReportConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_RTC)
    if (RuntimeEnabledFeatures::sharedFeatures().peerConnectionEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCTrackEventPublicName(), CustomGetterSetter::create(vm, jsDOMWindowRTCTrackEventConstructor, setJSDOMWindowRTCTrackEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(PAYMENT_REQUEST)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().paymentRequestEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().MerchantValidationEventPublicName(), CustomGetterSetter::create(vm, jsDOMWindowMerchantValidationEventConstructor, setJSDOMWindowMerchantValidationEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(PAYMENT_REQUEST)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().paymentRequestEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PaymentAddressPublicName(), CustomGetterSetter::create(vm, jsDOMWindowPaymentAddressConstructor, setJSDOMWindowPaymentAddressConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(PAYMENT_REQUEST)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().paymentRequestEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PaymentMethodChangeEventPublicName(), CustomGetterSetter::create(vm, jsDOMWindowPaymentMethodChangeEventConstructor, setJSDOMWindowPaymentMethodChangeEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(PAYMENT_REQUEST)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().paymentRequestEnabled() && PaymentRequest::enabledForContext(*jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PaymentRequestPublicName(), CustomGetterSetter::create(vm, jsDOMWindowPaymentRequestConstructor, setJSDOMWindowPaymentRequestConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(PAYMENT_REQUEST)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().paymentRequestEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PaymentRequestUpdateEventPublicName(), CustomGetterSetter::create(vm, jsDOMWindowPaymentRequestUpdateEventConstructor, setJSDOMWindowPaymentRequestUpdateEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(PAYMENT_REQUEST)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().paymentRequestEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PaymentResponsePublicName(), CustomGetterSetter::create(vm, jsDOMWindowPaymentResponseConstructor, setJSDOMWindowPaymentResponseConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().pictureInPictureAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().EnterPictureInPictureEventPublicName(), CustomGetterSetter::create(vm, jsDOMWindowEnterPictureInPictureEventConstructor, setJSDOMWindowEnterPictureInPictureEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().pictureInPictureAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PictureInPictureWindowPublicName(), CustomGetterSetter::create(vm, jsDOMWindowPictureInPictureWindowConstructor, setJSDOMWindowPictureInPictureWindowConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(STREAMS_API)
    if (RuntimeEnabledFeatures::sharedFeatures().writableStreamAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().WritableStreamPublicName(), CustomGetterSetter::create(vm, jsDOMWindowWritableStreamConstructor, setJSDOMWindowWritableStreamConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_AUDIO)
    if (downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().webAudioEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().webkitAudioContextPublicName(), CustomGetterSetter::create(vm, jsDOMWindowWebkitAudioContextConstructor, setJSDOMWindowWebkitAudioContextConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_AUTHN)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && RuntimeEnabledFeatures::sharedFeatures().webAuthenticationEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().AuthenticatorAssertionResponsePublicName(), CustomGetterSetter::create(vm, jsDOMWindowAuthenticatorAssertionResponseConstructor, setJSDOMWindowAuthenticatorAssertionResponseConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_AUTHN)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && RuntimeEnabledFeatures::sharedFeatures().webAuthenticationEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().AuthenticatorAttestationResponsePublicName(), CustomGetterSetter::create(vm, jsDOMWindowAuthenticatorAttestationResponseConstructor, setJSDOMWindowAuthenticatorAttestationResponseConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_AUTHN)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && RuntimeEnabledFeatures::sharedFeatures().webAuthenticationEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().AuthenticatorResponsePublicName(), CustomGetterSetter::create(vm, jsDOMWindowAuthenticatorResponseConstructor, setJSDOMWindowAuthenticatorResponseConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEB_AUTHN)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && RuntimeEnabledFeatures::sharedFeatures().webAuthenticationEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PublicKeyCredentialPublicName(), CustomGetterSetter::create(vm, jsDOMWindowPublicKeyCredentialConstructor, setJSDOMWindowPublicKeyCredentialConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
    if (RuntimeEnabledFeatures::sharedFeatures().webSQLEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().DatabasePublicName(), CustomGetterSetter::create(vm, jsDOMWindowDatabaseConstructor, setJSDOMWindowDatabaseConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().webSQLEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().SQLErrorPublicName(), CustomGetterSetter::create(vm, jsDOMWindowSQLErrorConstructor, setJSDOMWindowSQLErrorConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().webSQLEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().SQLResultSetPublicName(), CustomGetterSetter::create(vm, jsDOMWindowSQLResultSetConstructor, setJSDOMWindowSQLResultSetConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().webSQLEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().SQLResultSetRowListPublicName(), CustomGetterSetter::create(vm, jsDOMWindowSQLResultSetRowListConstructor, setJSDOMWindowSQLResultSetRowListConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUBufferUsagePublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUBufferUsageConstructor, setJSDOMWindowGPUBufferUsageConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUCanvasContextPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUCanvasContextConstructor, setJSDOMWindowGPUCanvasContextConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUColorWritePublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUColorWriteConstructor, setJSDOMWindowGPUColorWriteConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUOutOfMemoryErrorPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUOutOfMemoryErrorConstructor, setJSDOMWindowGPUOutOfMemoryErrorConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUShaderStagePublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUShaderStageConstructor, setJSDOMWindowGPUShaderStageConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUTextureUsagePublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUTextureUsageConstructor, setJSDOMWindowGPUTextureUsageConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUUncapturedErrorEventPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUUncapturedErrorEventConstructor, setJSDOMWindowGPUUncapturedErrorEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUValidationErrorPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUValidationErrorConstructor, setJSDOMWindowGPUValidationErrorConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUConstructor, setJSDOMWindowGPUConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUAdapterPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUAdapterConstructor, setJSDOMWindowGPUAdapterConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUBindGroupPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUBindGroupConstructor, setJSDOMWindowGPUBindGroupConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUBindGroupLayoutPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUBindGroupLayoutConstructor, setJSDOMWindowGPUBindGroupLayoutConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUBufferPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUBufferConstructor, setJSDOMWindowGPUBufferConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUCommandBufferPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUCommandBufferConstructor, setJSDOMWindowGPUCommandBufferConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUCommandEncoderPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUCommandEncoderConstructor, setJSDOMWindowGPUCommandEncoderConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUComputePassEncoderPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUComputePassEncoderConstructor, setJSDOMWindowGPUComputePassEncoderConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUComputePipelinePublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUComputePipelineConstructor, setJSDOMWindowGPUComputePipelineConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUDevicePublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUDeviceConstructor, setJSDOMWindowGPUDeviceConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUPipelineLayoutPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUPipelineLayoutConstructor, setJSDOMWindowGPUPipelineLayoutConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUProgrammablePassEncoderPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUProgrammablePassEncoderConstructor, setJSDOMWindowGPUProgrammablePassEncoderConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUQueuePublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUQueueConstructor, setJSDOMWindowGPUQueueConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPURenderPassEncoderPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPURenderPassEncoderConstructor, setJSDOMWindowGPURenderPassEncoderConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPURenderPipelinePublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPURenderPipelineConstructor, setJSDOMWindowGPURenderPipelineConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUSamplerPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUSamplerConstructor, setJSDOMWindowGPUSamplerConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUShaderModulePublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUShaderModuleConstructor, setJSDOMWindowGPUShaderModuleConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUSwapChainPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUSwapChainConstructor, setJSDOMWindowGPUSwapChainConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUTexturePublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUTextureConstructor, setJSDOMWindowGPUTextureConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGPU)
    if (RuntimeEnabledFeatures::sharedFeatures().webGPUEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().GPUTextureViewPublicName(), CustomGetterSetter::create(vm, jsDOMWindowGPUTextureViewConstructor, setJSDOMWindowGPUTextureViewConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
    if (RuntimeEnabledFeatures::sharedFeatures().webSocketEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().WebSocketPublicName(), CustomGetterSetter::create(vm, jsDOMWindowWebSocketConstructor, setJSDOMWindowWebSocketConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().webAnimationsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().AnimationEffectPublicName(), CustomGetterSetter::create(vm, jsDOMWindowAnimationEffectConstructor, setJSDOMWindowAnimationEffectConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().webAnimationsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().AnimationPlaybackEventPublicName(), CustomGetterSetter::create(vm, jsDOMWindowAnimationPlaybackEventConstructor, setJSDOMWindowAnimationPlaybackEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().webAnimationsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().AnimationTimelinePublicName(), CustomGetterSetter::create(vm, jsDOMWindowAnimationTimelineConstructor, setJSDOMWindowAnimationTimelineConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().webAnimationsCSSIntegrationEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CSSAnimationPublicName(), CustomGetterSetter::create(vm, jsDOMWindowCSSAnimationConstructor, setJSDOMWindowCSSAnimationConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().webAnimationsCSSIntegrationEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CSSTransitionPublicName(), CustomGetterSetter::create(vm, jsDOMWindowCSSTransitionConstructor, setJSDOMWindowCSSTransitionConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().webAnimationsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().DocumentTimelinePublicName(), CustomGetterSetter::create(vm, jsDOMWindowDocumentTimelineConstructor, setJSDOMWindowDocumentTimelineConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().webAnimationsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().KeyframeEffectPublicName(), CustomGetterSetter::create(vm, jsDOMWindowKeyframeEffectConstructor, setJSDOMWindowKeyframeEffectConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().webAnimationsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().AnimationPublicName(), CustomGetterSetter::create(vm, jsDOMWindowAnimationConstructor, setJSDOMWindowAnimationConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(CSS_TYPED_OM)
    if (RuntimeEnabledFeatures::sharedFeatures().cssTypedOMEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().StylePropertyMapPublicName(), CustomGetterSetter::create(vm, jsDOMWindowStylePropertyMapConstructor, setJSDOMWindowStylePropertyMapConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(CSS_TYPED_OM)
    if (RuntimeEnabledFeatures::sharedFeatures().cssTypedOMEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().StylePropertyMapReadOnlyPublicName(), CustomGetterSetter::create(vm, jsDOMWindowStylePropertyMapReadOnlyConstructor, setJSDOMWindowStylePropertyMapReadOnlyConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(CSS_TYPED_OM)
    if (RuntimeEnabledFeatures::sharedFeatures().cssTypedOMEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CSSImageValuePublicName(), CustomGetterSetter::create(vm, jsDOMWindowCSSImageValueConstructor, setJSDOMWindowCSSImageValueConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(CSS_TYPED_OM)
    if (RuntimeEnabledFeatures::sharedFeatures().cssTypedOMEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CSSNumericValuePublicName(), CustomGetterSetter::create(vm, jsDOMWindowCSSNumericValueConstructor, setJSDOMWindowCSSNumericValueConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(CSS_TYPED_OM)
    if (RuntimeEnabledFeatures::sharedFeatures().cssTypedOMEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CSSStyleValuePublicName(), CustomGetterSetter::create(vm, jsDOMWindowCSSStyleValueConstructor, setJSDOMWindowCSSStyleValueConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(CSS_TYPED_OM)
    if (RuntimeEnabledFeatures::sharedFeatures().cssTypedOMEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CSSUnitValuePublicName(), CustomGetterSetter::create(vm, jsDOMWindowCSSUnitValueConstructor, setJSDOMWindowCSSUnitValueConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(CSS_TYPED_OM)
    if (RuntimeEnabledFeatures::sharedFeatures().cssTypedOMEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CSSUnparsedValuePublicName(), CustomGetterSetter::create(vm, jsDOMWindowCSSUnparsedValueConstructor, setJSDOMWindowCSSUnparsedValueConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
    if (RuntimeEnabledFeatures::sharedFeatures().customElementsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().CustomElementRegistryPublicName(), CustomGetterSetter::create(vm, jsDOMWindowCustomElementRegistryConstructor, setJSDOMWindowCustomElementRegistryConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().dataTransferItemsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().DataTransferItemPublicName(), CustomGetterSetter::create(vm, jsDOMWindowDataTransferItemConstructor, setJSDOMWindowDataTransferItemConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().dataTransferItemsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().DataTransferItemListPublicName(), CustomGetterSetter::create(vm, jsDOMWindowDataTransferItemListConstructor, setJSDOMWindowDataTransferItemListConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().requestIdleCallbackEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().IdleDeadlinePublicName(), CustomGetterSetter::create(vm, jsDOMWindowIdleDeadlineConstructor, setJSDOMWindowIdleDeadlineConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().inputEventsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().InputEventPublicName(), CustomGetterSetter::create(vm, jsDOMWindowInputEventConstructor, setJSDOMWindowInputEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(POINTER_EVENTS)
    if ((!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().shouldDisablePointerEventsQuirk() && RuntimeEnabledFeatures::sharedFeatures().pointerEventsEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PointerEventPublicName(), CustomGetterSetter::create(vm, jsDOMWindowPointerEventConstructor, setJSDOMWindowPointerEventConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
    if (RuntimeEnabledFeatures::sharedFeatures().shadowDOMEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ShadowRootPublicName(), CustomGetterSetter::create(vm, jsDOMWindowShadowRootConstructor, setJSDOMWindowShadowRootConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().inputEventsEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().StaticRangePublicName(), CustomGetterSetter::create(vm, jsDOMWindowStaticRangeConstructor, setJSDOMWindowStaticRangeConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(ATTACHMENT_ELEMENT)
    if (RuntimeEnabledFeatures::sharedFeatures().attachmentElementEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().HTMLAttachmentElementPublicName(), CustomGetterSetter::create(vm, jsDOMWindowHTMLAttachmentElementConstructor, setJSDOMWindowHTMLAttachmentElementConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(DATALIST_ELEMENT)
    if (RuntimeEnabledFeatures::sharedFeatures().dataListElementEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().HTMLDataListElementPublicName(), CustomGetterSetter::create(vm, jsDOMWindowHTMLDataListElementConstructor, setJSDOMWindowHTMLDataListElementConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
    if (RuntimeEnabledFeatures::sharedFeatures().dialogElementEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().HTMLDialogElementPublicName(), CustomGetterSetter::create(vm, jsDOMWindowHTMLDialogElementConstructor, setJSDOMWindowHTMLDialogElementConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().keygenElementEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().HTMLKeygenElementPublicName(), CustomGetterSetter::create(vm, jsDOMWindowHTMLKeygenElementConstructor, setJSDOMWindowHTMLKeygenElementConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().menuItemElementEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().HTMLMenuItemElementPublicName(), CustomGetterSetter::create(vm, jsDOMWindowHTMLMenuItemElementConstructor, setJSDOMWindowHTMLMenuItemElementConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().shadowDOMEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().HTMLSlotElementPublicName(), CustomGetterSetter::create(vm, jsDOMWindowHTMLSlotElementConstructor, setJSDOMWindowHTMLSlotElementConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().imageBitmapEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ImageBitmapPublicName(), CustomGetterSetter::create(vm, jsDOMWindowImageBitmapConstructor, setJSDOMWindowImageBitmapConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(OFFSCREEN_CANVAS)
    if (RuntimeEnabledFeatures::sharedFeatures().offscreenCanvasEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().OffscreenCanvasPublicName(), CustomGetterSetter::create(vm, jsDOMWindowOffscreenCanvasConstructor, setJSDOMWindowOffscreenCanvasConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
    if (RuntimeEnabledFeatures::sharedFeatures().imageBitmapEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ImageBitmapRenderingContextPublicName(), CustomGetterSetter::create(vm, jsDOMWindowImageBitmapRenderingContextConstructor, setJSDOMWindowImageBitmapRenderingContextConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(OFFSCREEN_CANVAS)
    if (RuntimeEnabledFeatures::sharedFeatures().offscreenCanvasEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().OffscreenCanvasRenderingContext2DPublicName(), CustomGetterSetter::create(vm, jsDOMWindowOffscreenCanvasRenderingContext2DConstructor, setJSDOMWindowOffscreenCanvasRenderingContext2DConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(CSS_PAINTING_API)
    if (RuntimeEnabledFeatures::sharedFeatures().cssPaintingAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PaintRenderingContext2DPublicName(), CustomGetterSetter::create(vm, jsDOMWindowPaintRenderingContext2DConstructor, setJSDOMWindowPaintRenderingContext2DConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL2)
    if (RuntimeEnabledFeatures::sharedFeatures().webGL2Enabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().WebGL2RenderingContextPublicName(), CustomGetterSetter::create(vm, jsDOMWindowWebGL2RenderingContextConstructor, setJSDOMWindowWebGL2RenderingContextConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(WEBGL2)
    if (RuntimeEnabledFeatures::sharedFeatures().webGL2Enabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().WebGLVertexArrayObjectPublicName(), CustomGetterSetter::create(vm, jsDOMWindowWebGLVertexArrayObjectConstructor, setJSDOMWindowWebGLVertexArrayObjectConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(INTERSECTION_OBSERVER)
    if (RuntimeEnabledFeatures::sharedFeatures().intersectionObserverEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().IntersectionObserverPublicName(), CustomGetterSetter::create(vm, jsDOMWindowIntersectionObserverConstructor, setJSDOMWindowIntersectionObserverConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(INTERSECTION_OBSERVER)
    if (RuntimeEnabledFeatures::sharedFeatures().intersectionObserverEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().IntersectionObserverEntryPublicName(), CustomGetterSetter::create(vm, jsDOMWindowIntersectionObserverEntryConstructor, setJSDOMWindowIntersectionObserverEntryConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
    if (RuntimeEnabledFeatures::sharedFeatures().performanceTimelineEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PerformanceEntryPublicName(), CustomGetterSetter::create(vm, jsDOMWindowPerformanceEntryConstructor, setJSDOMWindowPerformanceEntryConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().userTimingEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PerformanceMarkPublicName(), CustomGetterSetter::create(vm, jsDOMWindowPerformanceMarkConstructor, setJSDOMWindowPerformanceMarkConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().userTimingEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PerformanceMeasurePublicName(), CustomGetterSetter::create(vm, jsDOMWindowPerformanceMeasureConstructor, setJSDOMWindowPerformanceMeasureConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().performanceTimelineEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PerformanceObserverPublicName(), CustomGetterSetter::create(vm, jsDOMWindowPerformanceObserverConstructor, setJSDOMWindowPerformanceObserverConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().performanceTimelineEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PerformanceObserverEntryListPublicName(), CustomGetterSetter::create(vm, jsDOMWindowPerformanceObserverEntryListConstructor, setJSDOMWindowPerformanceObserverEntryListConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().resourceTimingEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PerformanceResourceTimingPublicName(), CustomGetterSetter::create(vm, jsDOMWindowPerformanceResourceTimingConstructor, setJSDOMWindowPerformanceResourceTimingConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().serverTimingEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().PerformanceServerTimingPublicName(), CustomGetterSetter::create(vm, jsDOMWindowPerformanceServerTimingConstructor, setJSDOMWindowPerformanceServerTimingConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(RESIZE_OBSERVER)
    if (downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().resizeObserverEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ResizeObserverPublicName(), CustomGetterSetter::create(vm, jsDOMWindowResizeObserverConstructor, setJSDOMWindowResizeObserverConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(RESIZE_OBSERVER)
    if (downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().resizeObserverEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ResizeObserverEntryPublicName(), CustomGetterSetter::create(vm, jsDOMWindowResizeObserverEntryConstructor, setJSDOMWindowResizeObserverEntryConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
    if (RuntimeEnabledFeatures::sharedFeatures().undoManagerAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().UndoItemPublicName(), CustomGetterSetter::create(vm, jsDOMWindowUndoItemConstructor, setJSDOMWindowUndoItemConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (RuntimeEnabledFeatures::sharedFeatures().undoManagerAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().UndoManagerPublicName(), CustomGetterSetter::create(vm, jsDOMWindowUndoManagerConstructor, setJSDOMWindowUndoManagerConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
    if (downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().visualViewportAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().VisualViewportPublicName(), CustomGetterSetter::create(vm, jsDOMWindowVisualViewportConstructor, setJSDOMWindowVisualViewportConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#if ENABLE(SERVICE_WORKER)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && RuntimeEnabledFeatures::sharedFeatures().serviceWorkerEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ServiceWorkerPublicName(), CustomGetterSetter::create(vm, jsDOMWindowServiceWorkerConstructor, setJSDOMWindowServiceWorkerConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && RuntimeEnabledFeatures::sharedFeatures().serviceWorkerEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ServiceWorkerContainerPublicName(), CustomGetterSetter::create(vm, jsDOMWindowServiceWorkerContainerConstructor, setJSDOMWindowServiceWorkerContainerConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(SERVICE_WORKER)
    if ((jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->isSecureContext() && RuntimeEnabledFeatures::sharedFeatures().serviceWorkerEnabled()))
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ServiceWorkerRegistrationPublicName(), CustomGetterSetter::create(vm, jsDOMWindowServiceWorkerRegistrationConstructor, setJSDOMWindowServiceWorkerRegistrationConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(CSS_PAINTING_API)
    if (RuntimeEnabledFeatures::sharedFeatures().cssPaintingAPIEnabled())
        putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().WorkletPublicName(), CustomGetterSetter::create(vm, jsDOMWindowWorkletConstructor, setJSDOMWindowWorkletConstructor), attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::DontEnum)));
#endif
#if ENABLE(MEDIA_STREAM)
    putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().MediaStreamPrivateName(), CustomGetterSetter::create(vm, jsDOMWindowMediaStreamConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
#endif
#if ENABLE(MEDIA_STREAM)
    putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().MediaStreamTrackPrivateName(), CustomGetterSetter::create(vm, jsDOMWindowMediaStreamTrackConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
#endif
#if ENABLE(WEB_RTC)
    putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCIceCandidatePrivateName(), CustomGetterSetter::create(vm, jsDOMWindowRTCIceCandidateConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
#endif
#if ENABLE(WEB_RTC)
    putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().RTCSessionDescriptionPrivateName(), CustomGetterSetter::create(vm, jsDOMWindowRTCSessionDescriptionConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
#endif
#if ENABLE(STREAMS_API)
    putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ReadableByteStreamControllerPrivateName(), CustomGetterSetter::create(vm, jsDOMWindowReadableByteStreamControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
#endif
#if ENABLE(STREAMS_API)
    putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ReadableStreamPrivateName(), CustomGetterSetter::create(vm, jsDOMWindowReadableStreamConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
#endif
#if ENABLE(STREAMS_API)
    putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ReadableStreamBYOBReaderPrivateName(), CustomGetterSetter::create(vm, jsDOMWindowReadableStreamBYOBReaderConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
#endif
#if ENABLE(STREAMS_API)
    putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ReadableStreamBYOBRequestPrivateName(), CustomGetterSetter::create(vm, jsDOMWindowReadableStreamBYOBRequestConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
#endif
#if ENABLE(STREAMS_API)
    putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ReadableStreamDefaultControllerPrivateName(), CustomGetterSetter::create(vm, jsDOMWindowReadableStreamDefaultControllerConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
#endif
#if ENABLE(STREAMS_API)
    putDirectCustomAccessor(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().ReadableStreamDefaultReaderPrivateName(), CustomGetterSetter::create(vm, jsDOMWindowReadableStreamDefaultReaderConstructor, nullptr), attributesForStructure(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly));
#endif
    if (downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().requestIdleCallbackEnabled())
        putDirectNativeFunction(vm, this, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().requestIdleCallbackPublicName(), 1, jsDOMWindowInstanceFunctionRequestIdleCallback, NoIntrinsic, attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::Function)));
    if (downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().requestIdleCallbackEnabled())
        putDirectNativeFunction(vm, this, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().cancelIdleCallbackPublicName(), 1, jsDOMWindowInstanceFunctionCancelIdleCallback, NoIntrinsic, attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::Function)));
    if (worldForDOMObject(*this).shadowRootIsAlwaysOpen())
        putDirectNativeFunction(vm, this, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().collectMatchingElementsInFlatTreePublicName(), 2, jsDOMWindowInstanceFunctionCollectMatchingElementsInFlatTree, NoIntrinsic, attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::Function)));
    if (worldForDOMObject(*this).shadowRootIsAlwaysOpen())
        putDirectNativeFunction(vm, this, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().matchingElementInFlatTreePublicName(), 2, jsDOMWindowInstanceFunctionMatchingElementInFlatTree, NoIntrinsic, attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::Function)));
    if (RuntimeEnabledFeatures::sharedFeatures().fetchAPIEnabled())
        putDirectNativeFunction(vm, this, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().fetchPublicName(), 1, jsDOMWindowInstanceFunctionFetch, NoIntrinsic, attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::Function)));
    if (RuntimeEnabledFeatures::sharedFeatures().imageBitmapEnabled())
        putDirectNativeFunction(vm, this, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().createImageBitmapPublicName(), 1, jsDOMWindowInstanceFunctionCreateImageBitmap, NoIntrinsic, attributesForStructure(static_cast<unsigned>(JSC::PropertyAttribute::Function)));
}

JSValue JSDOMWindow::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMWindowConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSDOMWindow* IDLAttribute<JSDOMWindow>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto decodedThisValue = JSValue::decode(thisValue);
    if (decodedThisValue.isUndefinedOrNull())
        decodedThisValue = JSValue(&lexicalGlobalObject).toThis(&lexicalGlobalObject, NotStrictMode);
    return toJSDOMWindow(vm, decodedThisValue);
}

template<> inline JSDOMWindow* IDLOperation<JSDOMWindow>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return toJSDOMWindow(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue().toThis(&lexicalGlobalObject, NotStrictMode));
}

EncodedJSValue jsDOMWindowConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMWindowPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDOMWindow::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSDOMWindowConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDOMWindowPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsDOMWindowWindowGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.window(lexicalGlobalObject);
}

EncodedJSValue jsDOMWindowWindow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowWindowGetter>(*lexicalGlobalObject, thisValue, "window");
}

static inline JSValue jsDOMWindowSelfGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.self(lexicalGlobalObject);
}

EncodedJSValue jsDOMWindowSelf(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowSelfGetter>(*lexicalGlobalObject, thisValue, "self");
}

static inline bool setJSDOMWindowSelfSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("self"), strlen("self")), value);
}

bool setJSDOMWindowSelf(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowSelfSetter>(*lexicalGlobalObject, thisValue, encodedValue, "self");
}

static inline JSValue jsDOMWindowDocumentGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Document>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.document());
    return result;
}

EncodedJSValue jsDOMWindowDocument(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowDocumentGetter>(*lexicalGlobalObject, thisValue, "document");
}

static inline JSValue jsDOMWindowNameGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.name());
    return result;
}

EncodedJSValue jsDOMWindowName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowNameGetter>(*lexicalGlobalObject, thisValue, "name");
}

static inline bool setJSDOMWindowNameSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setName(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMWindowName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowNameSetter>(*lexicalGlobalObject, thisValue, encodedValue, "name");
}

static inline JSValue jsDOMWindowLocationGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Location>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.location());
    return result;
}

EncodedJSValue jsDOMWindowLocation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowLocationGetter>(*lexicalGlobalObject, thisValue, "location");
}

static inline bool setJSDOMWindowLocationSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    auto id = Identifier::fromString(vm, reinterpret_cast<const LChar*>("location"), strlen("location"));
    auto valueToForwardTo = thisObject.get(&lexicalGlobalObject, id);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!valueToForwardTo.isObject())) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return false;
    }
    auto forwardId = Identifier::fromString(vm, reinterpret_cast<const LChar*>("href"), strlen("href"));
    PutPropertySlot slot(valueToForwardTo, false);
    asObject(valueToForwardTo)->methodTable(vm)->put(asObject(valueToForwardTo), &lexicalGlobalObject, forwardId, value, slot);
    RETURN_IF_EXCEPTION(throwScope, false);
    return true;
}

bool setJSDOMWindowLocation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowLocationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "location");
}

static inline JSValue jsDOMWindowHistoryGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<History>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.history());
    return result;
}

EncodedJSValue jsDOMWindowHistory(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowHistoryGetter>(*lexicalGlobalObject, thisValue, "history");
}

static inline JSValue jsDOMWindowCustomElementsGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<CustomElementRegistry>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ensureCustomElementRegistry());
    return result;
}

EncodedJSValue jsDOMWindowCustomElements(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowCustomElementsGetter>(*lexicalGlobalObject, thisValue, "customElements");
}

static inline JSValue jsDOMWindowLocationbarGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<BarProp>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.locationbar());
    return result;
}

EncodedJSValue jsDOMWindowLocationbar(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowLocationbarGetter>(*lexicalGlobalObject, thisValue, "locationbar");
}

static inline bool setJSDOMWindowLocationbarSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("locationbar"), strlen("locationbar")), value);
}

bool setJSDOMWindowLocationbar(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowLocationbarSetter>(*lexicalGlobalObject, thisValue, encodedValue, "locationbar");
}

static inline JSValue jsDOMWindowMenubarGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<BarProp>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.menubar());
    return result;
}

EncodedJSValue jsDOMWindowMenubar(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowMenubarGetter>(*lexicalGlobalObject, thisValue, "menubar");
}

static inline bool setJSDOMWindowMenubarSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("menubar"), strlen("menubar")), value);
}

bool setJSDOMWindowMenubar(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowMenubarSetter>(*lexicalGlobalObject, thisValue, encodedValue, "menubar");
}

static inline JSValue jsDOMWindowPersonalbarGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<BarProp>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.personalbar());
    return result;
}

EncodedJSValue jsDOMWindowPersonalbar(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowPersonalbarGetter>(*lexicalGlobalObject, thisValue, "personalbar");
}

static inline bool setJSDOMWindowPersonalbarSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("personalbar"), strlen("personalbar")), value);
}

bool setJSDOMWindowPersonalbar(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowPersonalbarSetter>(*lexicalGlobalObject, thisValue, encodedValue, "personalbar");
}

static inline JSValue jsDOMWindowScrollbarsGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<BarProp>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.scrollbars());
    return result;
}

EncodedJSValue jsDOMWindowScrollbars(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowScrollbarsGetter>(*lexicalGlobalObject, thisValue, "scrollbars");
}

static inline bool setJSDOMWindowScrollbarsSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("scrollbars"), strlen("scrollbars")), value);
}

bool setJSDOMWindowScrollbars(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowScrollbarsSetter>(*lexicalGlobalObject, thisValue, encodedValue, "scrollbars");
}

static inline JSValue jsDOMWindowStatusbarGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<BarProp>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.statusbar());
    return result;
}

EncodedJSValue jsDOMWindowStatusbar(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowStatusbarGetter>(*lexicalGlobalObject, thisValue, "statusbar");
}

static inline bool setJSDOMWindowStatusbarSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("statusbar"), strlen("statusbar")), value);
}

bool setJSDOMWindowStatusbar(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowStatusbarSetter>(*lexicalGlobalObject, thisValue, encodedValue, "statusbar");
}

static inline JSValue jsDOMWindowToolbarGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<BarProp>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.toolbar());
    return result;
}

EncodedJSValue jsDOMWindowToolbar(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowToolbarGetter>(*lexicalGlobalObject, thisValue, "toolbar");
}

static inline bool setJSDOMWindowToolbarSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("toolbar"), strlen("toolbar")), value);
}

bool setJSDOMWindowToolbar(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowToolbarSetter>(*lexicalGlobalObject, thisValue, encodedValue, "toolbar");
}

static inline JSValue jsDOMWindowStatusGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.status());
    return result;
}

EncodedJSValue jsDOMWindowStatus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowStatusGetter>(*lexicalGlobalObject, thisValue, "status");
}

static inline bool setJSDOMWindowStatusSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setStatus(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMWindowStatus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowStatusSetter>(*lexicalGlobalObject, thisValue, encodedValue, "status");
}

static inline JSValue jsDOMWindowClosedGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.closed());
    return result;
}

EncodedJSValue jsDOMWindowClosed(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowClosedGetter>(*lexicalGlobalObject, thisValue, "closed");
}

static inline JSValue jsDOMWindowFramesGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.frames(lexicalGlobalObject);
}

EncodedJSValue jsDOMWindowFrames(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowFramesGetter>(*lexicalGlobalObject, thisValue, "frames");
}

static inline bool setJSDOMWindowFramesSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("frames"), strlen("frames")), value);
}

bool setJSDOMWindowFrames(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowFramesSetter>(*lexicalGlobalObject, thisValue, encodedValue, "frames");
}

static inline JSValue jsDOMWindowLengthGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.length());
    return result;
}

EncodedJSValue jsDOMWindowLength(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowLengthGetter>(*lexicalGlobalObject, thisValue, "length");
}

static inline bool setJSDOMWindowLengthSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("length"), strlen("length")), value);
}

bool setJSDOMWindowLength(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowLengthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "length");
}

static inline JSValue jsDOMWindowTopGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.top());
    return result;
}

EncodedJSValue jsDOMWindowTop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowTopGetter>(*lexicalGlobalObject, thisValue, "top");
}

static inline JSValue jsDOMWindowOpenerGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.opener());
    return result;
}

EncodedJSValue jsDOMWindowOpener(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOpenerGetter>(*lexicalGlobalObject, thisValue, "opener");
}

static inline bool setJSDOMWindowOpenerSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    thisObject.setOpener(lexicalGlobalObject, value);
    return true;
}

bool setJSDOMWindowOpener(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOpenerSetter>(*lexicalGlobalObject, thisValue, encodedValue, "opener");
}

static inline JSValue jsDOMWindowParentGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.parent());
    return result;
}

EncodedJSValue jsDOMWindowParent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowParentGetter>(*lexicalGlobalObject, thisValue, "parent");
}

static inline bool setJSDOMWindowParentSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("parent"), strlen("parent")), value);
}

bool setJSDOMWindowParent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowParentSetter>(*lexicalGlobalObject, thisValue, encodedValue, "parent");
}

static inline JSValue jsDOMWindowFrameElementGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, BindingSecurity::checkSecurityForNode(lexicalGlobalObject, impl.frameElement()));
    return result;
}

EncodedJSValue jsDOMWindowFrameElement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowFrameElementGetter>(*lexicalGlobalObject, thisValue, "frameElement");
}

static inline JSValue jsDOMWindowNavigatorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Navigator>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.navigator());
    return result;
}

EncodedJSValue jsDOMWindowNavigator(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowNavigatorGetter>(*lexicalGlobalObject, thisValue, "navigator");
}

static inline JSValue jsDOMWindowApplicationCacheGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMApplicationCache>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.applicationCache());
    return result;
}

EncodedJSValue jsDOMWindowApplicationCache(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowApplicationCacheGetter>(*lexicalGlobalObject, thisValue, "applicationCache");
}

static inline JSValue jsDOMWindowSessionStorageGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Storage>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.sessionStorage());
    return result;
}

EncodedJSValue jsDOMWindowSessionStorage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowSessionStorageGetter>(*lexicalGlobalObject, thisValue, "sessionStorage");
}

static inline JSValue jsDOMWindowLocalStorageGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Storage>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.localStorage());
    return result;
}

EncodedJSValue jsDOMWindowLocalStorage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowLocalStorageGetter>(*lexicalGlobalObject, thisValue, "localStorage");
}

static inline JSValue jsDOMWindowScreenGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Screen>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.screen());
    return result;
}

EncodedJSValue jsDOMWindowScreen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowScreenGetter>(*lexicalGlobalObject, thisValue, "screen");
}

static inline bool setJSDOMWindowScreenSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("screen"), strlen("screen")), value);
}

bool setJSDOMWindowScreen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowScreenSetter>(*lexicalGlobalObject, thisValue, encodedValue, "screen");
}

static inline JSValue jsDOMWindowInnerHeightGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.innerHeight());
    return result;
}

EncodedJSValue jsDOMWindowInnerHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowInnerHeightGetter>(*lexicalGlobalObject, thisValue, "innerHeight");
}

static inline bool setJSDOMWindowInnerHeightSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("innerHeight"), strlen("innerHeight")), value);
}

bool setJSDOMWindowInnerHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowInnerHeightSetter>(*lexicalGlobalObject, thisValue, encodedValue, "innerHeight");
}

static inline JSValue jsDOMWindowInnerWidthGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.innerWidth());
    return result;
}

EncodedJSValue jsDOMWindowInnerWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowInnerWidthGetter>(*lexicalGlobalObject, thisValue, "innerWidth");
}

static inline bool setJSDOMWindowInnerWidthSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("innerWidth"), strlen("innerWidth")), value);
}

bool setJSDOMWindowInnerWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowInnerWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "innerWidth");
}

static inline JSValue jsDOMWindowScrollXGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.scrollX());
    return result;
}

EncodedJSValue jsDOMWindowScrollX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowScrollXGetter>(*lexicalGlobalObject, thisValue, "scrollX");
}

static inline bool setJSDOMWindowScrollXSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("scrollX"), strlen("scrollX")), value);
}

bool setJSDOMWindowScrollX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowScrollXSetter>(*lexicalGlobalObject, thisValue, encodedValue, "scrollX");
}

static inline JSValue jsDOMWindowPageXOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.scrollX());
    return result;
}

EncodedJSValue jsDOMWindowPageXOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowPageXOffsetGetter>(*lexicalGlobalObject, thisValue, "pageXOffset");
}

static inline bool setJSDOMWindowPageXOffsetSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("pageXOffset"), strlen("pageXOffset")), value);
}

bool setJSDOMWindowPageXOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowPageXOffsetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "pageXOffset");
}

static inline JSValue jsDOMWindowScrollYGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.scrollY());
    return result;
}

EncodedJSValue jsDOMWindowScrollY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowScrollYGetter>(*lexicalGlobalObject, thisValue, "scrollY");
}

static inline bool setJSDOMWindowScrollYSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("scrollY"), strlen("scrollY")), value);
}

bool setJSDOMWindowScrollY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowScrollYSetter>(*lexicalGlobalObject, thisValue, encodedValue, "scrollY");
}

static inline JSValue jsDOMWindowPageYOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.scrollY());
    return result;
}

EncodedJSValue jsDOMWindowPageYOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowPageYOffsetGetter>(*lexicalGlobalObject, thisValue, "pageYOffset");
}

static inline bool setJSDOMWindowPageYOffsetSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("pageYOffset"), strlen("pageYOffset")), value);
}

bool setJSDOMWindowPageYOffset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowPageYOffsetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "pageYOffset");
}

static inline JSValue jsDOMWindowVisualViewportGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<VisualViewport>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.visualViewport());
    return result;
}

EncodedJSValue jsDOMWindowVisualViewport(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowVisualViewportGetter>(*lexicalGlobalObject, thisValue, "visualViewport");
}

static inline bool setJSDOMWindowVisualViewportSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("visualViewport"), strlen("visualViewport")), value);
}

bool setJSDOMWindowVisualViewport(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowVisualViewportSetter>(*lexicalGlobalObject, thisValue, encodedValue, "visualViewport");
}

static inline JSValue jsDOMWindowScreenXGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.screenX());
    return result;
}

EncodedJSValue jsDOMWindowScreenX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowScreenXGetter>(*lexicalGlobalObject, thisValue, "screenX");
}

static inline bool setJSDOMWindowScreenXSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("screenX"), strlen("screenX")), value);
}

bool setJSDOMWindowScreenX(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowScreenXSetter>(*lexicalGlobalObject, thisValue, encodedValue, "screenX");
}

static inline JSValue jsDOMWindowScreenYGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.screenY());
    return result;
}

EncodedJSValue jsDOMWindowScreenY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowScreenYGetter>(*lexicalGlobalObject, thisValue, "screenY");
}

static inline bool setJSDOMWindowScreenYSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("screenY"), strlen("screenY")), value);
}

bool setJSDOMWindowScreenY(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowScreenYSetter>(*lexicalGlobalObject, thisValue, encodedValue, "screenY");
}

static inline JSValue jsDOMWindowOuterWidthGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.outerWidth());
    return result;
}

EncodedJSValue jsDOMWindowOuterWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOuterWidthGetter>(*lexicalGlobalObject, thisValue, "outerWidth");
}

static inline bool setJSDOMWindowOuterWidthSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("outerWidth"), strlen("outerWidth")), value);
}

bool setJSDOMWindowOuterWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOuterWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "outerWidth");
}

static inline JSValue jsDOMWindowOuterHeightGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.outerHeight());
    return result;
}

EncodedJSValue jsDOMWindowOuterHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOuterHeightGetter>(*lexicalGlobalObject, thisValue, "outerHeight");
}

static inline bool setJSDOMWindowOuterHeightSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("outerHeight"), strlen("outerHeight")), value);
}

bool setJSDOMWindowOuterHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOuterHeightSetter>(*lexicalGlobalObject, thisValue, encodedValue, "outerHeight");
}

static inline JSValue jsDOMWindowDevicePixelRatioGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.devicePixelRatio());
    return result;
}

EncodedJSValue jsDOMWindowDevicePixelRatio(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowDevicePixelRatioGetter>(*lexicalGlobalObject, thisValue, "devicePixelRatio");
}

static inline bool setJSDOMWindowDevicePixelRatioSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("devicePixelRatio"), strlen("devicePixelRatio")), value);
}

bool setJSDOMWindowDevicePixelRatio(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowDevicePixelRatioSetter>(*lexicalGlobalObject, thisValue, encodedValue, "devicePixelRatio");
}

#if ENABLE(ORIENTATION_EVENTS)
static inline JSValue jsDOMWindowOrientationGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.orientation());
    return result;
}

EncodedJSValue jsDOMWindowOrientation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOrientationGetter>(*lexicalGlobalObject, thisValue, "orientation");
}

#endif

static inline JSValue jsDOMWindowEventGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return thisObject.event(lexicalGlobalObject);
}

EncodedJSValue jsDOMWindowEvent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowEventGetter>(*lexicalGlobalObject, thisValue, "event");
}

static inline bool setJSDOMWindowEventSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("event"), strlen("event")), value);
}

bool setJSDOMWindowEvent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowEventSetter>(*lexicalGlobalObject, thisValue, encodedValue, "event");
}

static inline JSValue jsDOMWindowDefaultStatusGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.defaultStatus());
    return result;
}

EncodedJSValue jsDOMWindowDefaultStatus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowDefaultStatusGetter>(*lexicalGlobalObject, thisValue, "defaultStatus");
}

static inline bool setJSDOMWindowDefaultStatusSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDefaultStatus(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMWindowDefaultStatus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowDefaultStatusSetter>(*lexicalGlobalObject, thisValue, encodedValue, "defaultStatus");
}

static inline JSValue jsDOMWindowDefaultstatusGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.defaultStatus());
    return result;
}

EncodedJSValue jsDOMWindowDefaultstatus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowDefaultstatusGetter>(*lexicalGlobalObject, thisValue, "defaultstatus");
}

static inline bool setJSDOMWindowDefaultstatusSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDefaultStatus(WTFMove(nativeValue));
    });
    return true;
}

bool setJSDOMWindowDefaultstatus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowDefaultstatusSetter>(*lexicalGlobalObject, thisValue, encodedValue, "defaultstatus");
}

static inline JSValue jsDOMWindowOffscreenBufferingGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.offscreenBuffering());
    return result;
}

EncodedJSValue jsDOMWindowOffscreenBuffering(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOffscreenBufferingGetter>(*lexicalGlobalObject, thisValue, "offscreenBuffering");
}

static inline bool setJSDOMWindowOffscreenBufferingSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("offscreenBuffering"), strlen("offscreenBuffering")), value);
}

bool setJSDOMWindowOffscreenBuffering(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOffscreenBufferingSetter>(*lexicalGlobalObject, thisValue, encodedValue, "offscreenBuffering");
}

static inline JSValue jsDOMWindowScreenLeftGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.screenLeft());
    return result;
}

EncodedJSValue jsDOMWindowScreenLeft(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowScreenLeftGetter>(*lexicalGlobalObject, thisValue, "screenLeft");
}

static inline bool setJSDOMWindowScreenLeftSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("screenLeft"), strlen("screenLeft")), value);
}

bool setJSDOMWindowScreenLeft(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowScreenLeftSetter>(*lexicalGlobalObject, thisValue, encodedValue, "screenLeft");
}

static inline JSValue jsDOMWindowScreenTopGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.screenTop());
    return result;
}

EncodedJSValue jsDOMWindowScreenTop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowScreenTopGetter>(*lexicalGlobalObject, thisValue, "screenTop");
}

static inline bool setJSDOMWindowScreenTopSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("screenTop"), strlen("screenTop")), value);
}

bool setJSDOMWindowScreenTop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowScreenTopSetter>(*lexicalGlobalObject, thisValue, encodedValue, "screenTop");
}

static inline JSValue jsDOMWindowClientInformationGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Navigator>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.clientInformation());
    return result;
}

EncodedJSValue jsDOMWindowClientInformation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowClientInformationGetter>(*lexicalGlobalObject, thisValue, "clientInformation");
}

static inline bool setJSDOMWindowClientInformationSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("clientInformation"), strlen("clientInformation")), value);
}

bool setJSDOMWindowClientInformation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowClientInformationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "clientInformation");
}

static inline JSValue jsDOMWindowStyleMediaGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<StyleMedia>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.styleMedia());
    return result;
}

EncodedJSValue jsDOMWindowStyleMedia(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowStyleMediaGetter>(*lexicalGlobalObject, thisValue, "styleMedia");
}

#if ENABLE(IOS_GESTURE_EVENTS)
static inline JSValue jsDOMWindowOngesturechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().gesturechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOngesturechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOngesturechangeGetter>(*lexicalGlobalObject, thisValue, "ongesturechange");
}

#endif

#if ENABLE(IOS_GESTURE_EVENTS)
static inline bool setJSDOMWindowOngesturechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().gesturechangeEvent, value);
    return true;
}

bool setJSDOMWindowOngesturechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOngesturechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ongesturechange");
}

#endif

#if ENABLE(IOS_GESTURE_EVENTS)
static inline JSValue jsDOMWindowOngestureendGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().gestureendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOngestureend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOngestureendGetter>(*lexicalGlobalObject, thisValue, "ongestureend");
}

#endif

#if ENABLE(IOS_GESTURE_EVENTS)
static inline bool setJSDOMWindowOngestureendSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().gestureendEvent, value);
    return true;
}

bool setJSDOMWindowOngestureend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOngestureendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ongestureend");
}

#endif

#if ENABLE(IOS_GESTURE_EVENTS)
static inline JSValue jsDOMWindowOngesturestartGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().gesturestartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOngesturestart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOngesturestartGetter>(*lexicalGlobalObject, thisValue, "ongesturestart");
}

#endif

#if ENABLE(IOS_GESTURE_EVENTS)
static inline bool setJSDOMWindowOngesturestartSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().gesturestartEvent, value);
    return true;
}

bool setJSDOMWindowOngesturestart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOngesturestartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ongesturestart");
}

#endif

#if ENABLE(DEVICE_ORIENTATION)
static inline JSValue jsDOMWindowOndevicemotionGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().devicemotionEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOndevicemotion(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOndevicemotionGetter>(*lexicalGlobalObject, thisValue, "ondevicemotion");
}

#endif

#if ENABLE(DEVICE_ORIENTATION)
static inline bool setJSDOMWindowOndevicemotionSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().devicemotionEvent, value);
    return true;
}

bool setJSDOMWindowOndevicemotion(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOndevicemotionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondevicemotion");
}

#endif

#if ENABLE(DEVICE_ORIENTATION)
static inline JSValue jsDOMWindowOndeviceorientationGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().deviceorientationEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOndeviceorientation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOndeviceorientationGetter>(*lexicalGlobalObject, thisValue, "ondeviceorientation");
}

#endif

#if ENABLE(DEVICE_ORIENTATION)
static inline bool setJSDOMWindowOndeviceorientationSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().deviceorientationEvent, value);
    return true;
}

bool setJSDOMWindowOndeviceorientation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOndeviceorientationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondeviceorientation");
}

#endif

static inline JSValue jsDOMWindowOnwebkitanimationendGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitAnimationEndEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnwebkitanimationend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnwebkitanimationendGetter>(*lexicalGlobalObject, thisValue, "onwebkitanimationend");
}

static inline bool setJSDOMWindowOnwebkitanimationendSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitAnimationEndEvent, value);
    return true;
}

bool setJSDOMWindowOnwebkitanimationend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnwebkitanimationendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitanimationend");
}

static inline JSValue jsDOMWindowOnwebkitanimationiterationGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitAnimationIterationEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnwebkitanimationiteration(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnwebkitanimationiterationGetter>(*lexicalGlobalObject, thisValue, "onwebkitanimationiteration");
}

static inline bool setJSDOMWindowOnwebkitanimationiterationSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitAnimationIterationEvent, value);
    return true;
}

bool setJSDOMWindowOnwebkitanimationiteration(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnwebkitanimationiterationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitanimationiteration");
}

static inline JSValue jsDOMWindowOnwebkitanimationstartGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitAnimationStartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnwebkitanimationstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnwebkitanimationstartGetter>(*lexicalGlobalObject, thisValue, "onwebkitanimationstart");
}

static inline bool setJSDOMWindowOnwebkitanimationstartSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitAnimationStartEvent, value);
    return true;
}

bool setJSDOMWindowOnwebkitanimationstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnwebkitanimationstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitanimationstart");
}

static inline JSValue jsDOMWindowOnwebkittransitionendGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitTransitionEndEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnwebkittransitionend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnwebkittransitionendGetter>(*lexicalGlobalObject, thisValue, "onwebkittransitionend");
}

static inline bool setJSDOMWindowOnwebkittransitionendSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitTransitionEndEvent, value);
    return true;
}

bool setJSDOMWindowOnwebkittransitionend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnwebkittransitionendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkittransitionend");
}

static inline JSValue jsDOMWindowCachesGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMCacheStorage>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::DOMWindowCaches::caches(*context, impl));
    return result;
}

EncodedJSValue jsDOMWindowCaches(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowCachesGetter>(*lexicalGlobalObject, thisValue, "caches");
}

#if ENABLE(INDEXED_DATABASE)
static inline JSValue jsDOMWindowIndexedDBGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<IDBFactory>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::DOMWindowIndexedDatabase::indexedDB(impl));
    return result;
}

EncodedJSValue jsDOMWindowIndexedDB(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowIndexedDBGetter>(*lexicalGlobalObject, thisValue, "indexedDB");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline JSValue jsDOMWindowWebkitIndexedDBGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<IDBFactory>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::DOMWindowIndexedDatabase::indexedDB(impl));
    return result;
}

EncodedJSValue jsDOMWindowWebkitIndexedDB(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowWebkitIndexedDBGetter>(*lexicalGlobalObject, thisValue, "webkitIndexedDB");
}

#endif

#if ENABLE(SPEECH_SYNTHESIS)
static inline JSValue jsDOMWindowSpeechSynthesisGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SpeechSynthesis>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::DOMWindowSpeechSynthesis::speechSynthesis(impl));
    return result;
}

EncodedJSValue jsDOMWindowSpeechSynthesis(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowSpeechSynthesisGetter>(*lexicalGlobalObject, thisValue, "speechSynthesis");
}

#endif

static inline JSValue jsDOMWindowOpenDatabaseGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return thisObject.openDatabase(lexicalGlobalObject);
}

EncodedJSValue jsDOMWindowOpenDatabase(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOpenDatabaseGetter>(*lexicalGlobalObject, thisValue, "openDatabase");
}

static inline bool setJSDOMWindowOpenDatabaseSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    thisObject.setOpenDatabase(lexicalGlobalObject, value);
    return true;
}

bool setJSDOMWindowOpenDatabase(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOpenDatabaseSetter>(*lexicalGlobalObject, thisValue, encodedValue, "openDatabase");
}

static inline JSValue jsDOMWindowOnabortGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().abortEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnabort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnabortGetter>(*lexicalGlobalObject, thisValue, "onabort");
}

static inline bool setJSDOMWindowOnabortSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().abortEvent, value);
    return true;
}

bool setJSDOMWindowOnabort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnabortSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onabort");
}

static inline JSValue jsDOMWindowOnblurGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().blurEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnblur(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnblurGetter>(*lexicalGlobalObject, thisValue, "onblur");
}

static inline bool setJSDOMWindowOnblurSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().blurEvent, value);
    return true;
}

bool setJSDOMWindowOnblur(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnblurSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onblur");
}

static inline JSValue jsDOMWindowOncanplayGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().canplayEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOncanplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOncanplayGetter>(*lexicalGlobalObject, thisValue, "oncanplay");
}

static inline bool setJSDOMWindowOncanplaySetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().canplayEvent, value);
    return true;
}

bool setJSDOMWindowOncanplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOncanplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncanplay");
}

static inline JSValue jsDOMWindowOncanplaythroughGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().canplaythroughEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOncanplaythrough(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOncanplaythroughGetter>(*lexicalGlobalObject, thisValue, "oncanplaythrough");
}

static inline bool setJSDOMWindowOncanplaythroughSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().canplaythroughEvent, value);
    return true;
}

bool setJSDOMWindowOncanplaythrough(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOncanplaythroughSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncanplaythrough");
}

static inline JSValue jsDOMWindowOnchangeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().changeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnchangeGetter>(*lexicalGlobalObject, thisValue, "onchange");
}

static inline bool setJSDOMWindowOnchangeSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().changeEvent, value);
    return true;
}

bool setJSDOMWindowOnchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onchange");
}

static inline JSValue jsDOMWindowOnclickGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().clickEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnclick(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnclickGetter>(*lexicalGlobalObject, thisValue, "onclick");
}

static inline bool setJSDOMWindowOnclickSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().clickEvent, value);
    return true;
}

bool setJSDOMWindowOnclick(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onclick");
}

static inline JSValue jsDOMWindowOncontextmenuGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().contextmenuEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOncontextmenu(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOncontextmenuGetter>(*lexicalGlobalObject, thisValue, "oncontextmenu");
}

static inline bool setJSDOMWindowOncontextmenuSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().contextmenuEvent, value);
    return true;
}

bool setJSDOMWindowOncontextmenu(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOncontextmenuSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncontextmenu");
}

static inline JSValue jsDOMWindowOncuechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().cuechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOncuechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOncuechangeGetter>(*lexicalGlobalObject, thisValue, "oncuechange");
}

static inline bool setJSDOMWindowOncuechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().cuechangeEvent, value);
    return true;
}

bool setJSDOMWindowOncuechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOncuechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oncuechange");
}

static inline JSValue jsDOMWindowOndblclickGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dblclickEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOndblclick(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOndblclickGetter>(*lexicalGlobalObject, thisValue, "ondblclick");
}

static inline bool setJSDOMWindowOndblclickSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dblclickEvent, value);
    return true;
}

bool setJSDOMWindowOndblclick(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOndblclickSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondblclick");
}

static inline JSValue jsDOMWindowOndragGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOndrag(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOndragGetter>(*lexicalGlobalObject, thisValue, "ondrag");
}

static inline bool setJSDOMWindowOndragSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragEvent, value);
    return true;
}

bool setJSDOMWindowOndrag(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOndragSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondrag");
}

static inline JSValue jsDOMWindowOndragendGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOndragend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOndragendGetter>(*lexicalGlobalObject, thisValue, "ondragend");
}

static inline bool setJSDOMWindowOndragendSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragendEvent, value);
    return true;
}

bool setJSDOMWindowOndragend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOndragendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondragend");
}

static inline JSValue jsDOMWindowOndragenterGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragenterEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOndragenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOndragenterGetter>(*lexicalGlobalObject, thisValue, "ondragenter");
}

static inline bool setJSDOMWindowOndragenterSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragenterEvent, value);
    return true;
}

bool setJSDOMWindowOndragenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOndragenterSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondragenter");
}

static inline JSValue jsDOMWindowOndragleaveGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragleaveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOndragleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOndragleaveGetter>(*lexicalGlobalObject, thisValue, "ondragleave");
}

static inline bool setJSDOMWindowOndragleaveSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragleaveEvent, value);
    return true;
}

bool setJSDOMWindowOndragleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOndragleaveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondragleave");
}

static inline JSValue jsDOMWindowOndragoverGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragoverEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOndragover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOndragoverGetter>(*lexicalGlobalObject, thisValue, "ondragover");
}

static inline bool setJSDOMWindowOndragoverSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragoverEvent, value);
    return true;
}

bool setJSDOMWindowOndragover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOndragoverSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondragover");
}

static inline JSValue jsDOMWindowOndragstartGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dragstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOndragstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOndragstartGetter>(*lexicalGlobalObject, thisValue, "ondragstart");
}

static inline bool setJSDOMWindowOndragstartSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dragstartEvent, value);
    return true;
}

bool setJSDOMWindowOndragstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOndragstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondragstart");
}

static inline JSValue jsDOMWindowOndropGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().dropEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOndrop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOndropGetter>(*lexicalGlobalObject, thisValue, "ondrop");
}

static inline bool setJSDOMWindowOndropSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().dropEvent, value);
    return true;
}

bool setJSDOMWindowOndrop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOndropSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondrop");
}

static inline JSValue jsDOMWindowOndurationchangeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().durationchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOndurationchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOndurationchangeGetter>(*lexicalGlobalObject, thisValue, "ondurationchange");
}

static inline bool setJSDOMWindowOndurationchangeSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().durationchangeEvent, value);
    return true;
}

bool setJSDOMWindowOndurationchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOndurationchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondurationchange");
}

static inline JSValue jsDOMWindowOnemptiedGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().emptiedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnemptied(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnemptiedGetter>(*lexicalGlobalObject, thisValue, "onemptied");
}

static inline bool setJSDOMWindowOnemptiedSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().emptiedEvent, value);
    return true;
}

bool setJSDOMWindowOnemptied(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnemptiedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onemptied");
}

static inline JSValue jsDOMWindowOnendedGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().endedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnended(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnendedGetter>(*lexicalGlobalObject, thisValue, "onended");
}

static inline bool setJSDOMWindowOnendedSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().endedEvent, value);
    return true;
}

bool setJSDOMWindowOnended(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnendedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onended");
}

static inline JSValue jsDOMWindowOnerrorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnerrorGetter>(*lexicalGlobalObject, thisValue, "onerror");
}

static inline bool setJSDOMWindowOnerrorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    thisObject.wrapped().setAttributeEventListener(eventNames().errorEvent, createJSErrorHandler(lexicalGlobalObject, value, thisObject), worldForDOMObject(thisObject));
    return true;
}

bool setJSDOMWindowOnerror(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onerror");
}

static inline JSValue jsDOMWindowOnfocusGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().focusEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnfocus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnfocusGetter>(*lexicalGlobalObject, thisValue, "onfocus");
}

static inline bool setJSDOMWindowOnfocusSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().focusEvent, value);
    return true;
}

bool setJSDOMWindowOnfocus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnfocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onfocus");
}

static inline JSValue jsDOMWindowOninputGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().inputEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOninput(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOninputGetter>(*lexicalGlobalObject, thisValue, "oninput");
}

static inline bool setJSDOMWindowOninputSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().inputEvent, value);
    return true;
}

bool setJSDOMWindowOninput(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOninputSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oninput");
}

static inline JSValue jsDOMWindowOninvalidGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().invalidEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOninvalid(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOninvalidGetter>(*lexicalGlobalObject, thisValue, "oninvalid");
}

static inline bool setJSDOMWindowOninvalidSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().invalidEvent, value);
    return true;
}

bool setJSDOMWindowOninvalid(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOninvalidSetter>(*lexicalGlobalObject, thisValue, encodedValue, "oninvalid");
}

static inline JSValue jsDOMWindowOnkeydownGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().keydownEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnkeydown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnkeydownGetter>(*lexicalGlobalObject, thisValue, "onkeydown");
}

static inline bool setJSDOMWindowOnkeydownSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().keydownEvent, value);
    return true;
}

bool setJSDOMWindowOnkeydown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnkeydownSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onkeydown");
}

static inline JSValue jsDOMWindowOnkeypressGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().keypressEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnkeypress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnkeypressGetter>(*lexicalGlobalObject, thisValue, "onkeypress");
}

static inline bool setJSDOMWindowOnkeypressSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().keypressEvent, value);
    return true;
}

bool setJSDOMWindowOnkeypress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnkeypressSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onkeypress");
}

static inline JSValue jsDOMWindowOnkeyupGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().keyupEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnkeyup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnkeyupGetter>(*lexicalGlobalObject, thisValue, "onkeyup");
}

static inline bool setJSDOMWindowOnkeyupSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().keyupEvent, value);
    return true;
}

bool setJSDOMWindowOnkeyup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnkeyupSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onkeyup");
}

static inline JSValue jsDOMWindowOnloadGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnloadGetter>(*lexicalGlobalObject, thisValue, "onload");
}

static inline bool setJSDOMWindowOnloadSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadEvent, value);
    return true;
}

bool setJSDOMWindowOnload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onload");
}

static inline JSValue jsDOMWindowOnloadeddataGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadeddataEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnloadeddata(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnloadeddataGetter>(*lexicalGlobalObject, thisValue, "onloadeddata");
}

static inline bool setJSDOMWindowOnloadeddataSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadeddataEvent, value);
    return true;
}

bool setJSDOMWindowOnloadeddata(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnloadeddataSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onloadeddata");
}

static inline JSValue jsDOMWindowOnloadedmetadataGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadedmetadataEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnloadedmetadata(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnloadedmetadataGetter>(*lexicalGlobalObject, thisValue, "onloadedmetadata");
}

static inline bool setJSDOMWindowOnloadedmetadataSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadedmetadataEvent, value);
    return true;
}

bool setJSDOMWindowOnloadedmetadata(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnloadedmetadataSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onloadedmetadata");
}

static inline JSValue jsDOMWindowOnloadstartGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().loadstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnloadstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnloadstartGetter>(*lexicalGlobalObject, thisValue, "onloadstart");
}

static inline bool setJSDOMWindowOnloadstartSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().loadstartEvent, value);
    return true;
}

bool setJSDOMWindowOnloadstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnloadstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onloadstart");
}

static inline JSValue jsDOMWindowOnmousedownGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mousedownEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnmousedown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnmousedownGetter>(*lexicalGlobalObject, thisValue, "onmousedown");
}

static inline bool setJSDOMWindowOnmousedownSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mousedownEvent, value);
    return true;
}

bool setJSDOMWindowOnmousedown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnmousedownSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmousedown");
}

static inline JSValue jsDOMWindowOnmouseenterGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseenterEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnmouseenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnmouseenterGetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, "onmouseenter");
}

static inline bool setJSDOMWindowOnmouseenterSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mouseenterEvent, value);
    return true;
}

bool setJSDOMWindowOnmouseenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnmouseenterSetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, encodedValue, "onmouseenter");
}

static inline JSValue jsDOMWindowOnmouseleaveGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseleaveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnmouseleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnmouseleaveGetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, "onmouseleave");
}

static inline bool setJSDOMWindowOnmouseleaveSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mouseleaveEvent, value);
    return true;
}

bool setJSDOMWindowOnmouseleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnmouseleaveSetter, CastedThisErrorBehavior::ReturnEarly>(*lexicalGlobalObject, thisValue, encodedValue, "onmouseleave");
}

static inline JSValue jsDOMWindowOnmousemoveGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mousemoveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnmousemove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnmousemoveGetter>(*lexicalGlobalObject, thisValue, "onmousemove");
}

static inline bool setJSDOMWindowOnmousemoveSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mousemoveEvent, value);
    return true;
}

bool setJSDOMWindowOnmousemove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnmousemoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmousemove");
}

static inline JSValue jsDOMWindowOnmouseoutGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseoutEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnmouseout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnmouseoutGetter>(*lexicalGlobalObject, thisValue, "onmouseout");
}

static inline bool setJSDOMWindowOnmouseoutSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mouseoutEvent, value);
    return true;
}

bool setJSDOMWindowOnmouseout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnmouseoutSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmouseout");
}

static inline JSValue jsDOMWindowOnmouseoverGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseoverEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnmouseover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnmouseoverGetter>(*lexicalGlobalObject, thisValue, "onmouseover");
}

static inline bool setJSDOMWindowOnmouseoverSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mouseoverEvent, value);
    return true;
}

bool setJSDOMWindowOnmouseover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnmouseoverSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmouseover");
}

static inline JSValue jsDOMWindowOnmouseupGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mouseupEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnmouseup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnmouseupGetter>(*lexicalGlobalObject, thisValue, "onmouseup");
}

static inline bool setJSDOMWindowOnmouseupSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mouseupEvent, value);
    return true;
}

bool setJSDOMWindowOnmouseup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnmouseupSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmouseup");
}

static inline JSValue jsDOMWindowOnmousewheelGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().mousewheelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnmousewheel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnmousewheelGetter>(*lexicalGlobalObject, thisValue, "onmousewheel");
}

static inline bool setJSDOMWindowOnmousewheelSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().mousewheelEvent, value);
    return true;
}

bool setJSDOMWindowOnmousewheel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnmousewheelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmousewheel");
}

static inline JSValue jsDOMWindowOnpauseGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pauseEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnpause(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnpauseGetter>(*lexicalGlobalObject, thisValue, "onpause");
}

static inline bool setJSDOMWindowOnpauseSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pauseEvent, value);
    return true;
}

bool setJSDOMWindowOnpause(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnpauseSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpause");
}

static inline JSValue jsDOMWindowOnplayGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().playEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnplayGetter>(*lexicalGlobalObject, thisValue, "onplay");
}

static inline bool setJSDOMWindowOnplaySetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().playEvent, value);
    return true;
}

bool setJSDOMWindowOnplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, "onplay");
}

static inline JSValue jsDOMWindowOnplayingGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().playingEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnplaying(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnplayingGetter>(*lexicalGlobalObject, thisValue, "onplaying");
}

static inline bool setJSDOMWindowOnplayingSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().playingEvent, value);
    return true;
}

bool setJSDOMWindowOnplaying(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnplayingSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onplaying");
}

static inline JSValue jsDOMWindowOnprogressGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().progressEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnprogress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnprogressGetter>(*lexicalGlobalObject, thisValue, "onprogress");
}

static inline bool setJSDOMWindowOnprogressSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().progressEvent, value);
    return true;
}

bool setJSDOMWindowOnprogress(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnprogressSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onprogress");
}

static inline JSValue jsDOMWindowOnratechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().ratechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnratechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnratechangeGetter>(*lexicalGlobalObject, thisValue, "onratechange");
}

static inline bool setJSDOMWindowOnratechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().ratechangeEvent, value);
    return true;
}

bool setJSDOMWindowOnratechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnratechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onratechange");
}

static inline JSValue jsDOMWindowOnrejectionhandledGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().rejectionhandledEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnrejectionhandled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnrejectionhandledGetter>(*lexicalGlobalObject, thisValue, "onrejectionhandled");
}

static inline bool setJSDOMWindowOnrejectionhandledSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().rejectionhandledEvent, value);
    return true;
}

bool setJSDOMWindowOnrejectionhandled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnrejectionhandledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onrejectionhandled");
}

static inline JSValue jsDOMWindowOnresetGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().resetEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnreset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnresetGetter>(*lexicalGlobalObject, thisValue, "onreset");
}

static inline bool setJSDOMWindowOnresetSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().resetEvent, value);
    return true;
}

bool setJSDOMWindowOnreset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnresetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onreset");
}

static inline JSValue jsDOMWindowOnresizeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().resizeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnresize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnresizeGetter>(*lexicalGlobalObject, thisValue, "onresize");
}

static inline bool setJSDOMWindowOnresizeSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().resizeEvent, value);
    return true;
}

bool setJSDOMWindowOnresize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnresizeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onresize");
}

static inline JSValue jsDOMWindowOnscrollGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().scrollEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnscroll(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnscrollGetter>(*lexicalGlobalObject, thisValue, "onscroll");
}

static inline bool setJSDOMWindowOnscrollSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().scrollEvent, value);
    return true;
}

bool setJSDOMWindowOnscroll(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnscrollSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onscroll");
}

static inline JSValue jsDOMWindowOnseekedGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().seekedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnseeked(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnseekedGetter>(*lexicalGlobalObject, thisValue, "onseeked");
}

static inline bool setJSDOMWindowOnseekedSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().seekedEvent, value);
    return true;
}

bool setJSDOMWindowOnseeked(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnseekedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onseeked");
}

static inline JSValue jsDOMWindowOnseekingGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().seekingEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnseeking(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnseekingGetter>(*lexicalGlobalObject, thisValue, "onseeking");
}

static inline bool setJSDOMWindowOnseekingSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().seekingEvent, value);
    return true;
}

bool setJSDOMWindowOnseeking(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnseekingSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onseeking");
}

static inline JSValue jsDOMWindowOnselectGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().selectEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnselect(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnselectGetter>(*lexicalGlobalObject, thisValue, "onselect");
}

static inline bool setJSDOMWindowOnselectSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().selectEvent, value);
    return true;
}

bool setJSDOMWindowOnselect(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnselectSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onselect");
}

static inline JSValue jsDOMWindowOnstalledGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().stalledEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnstalled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnstalledGetter>(*lexicalGlobalObject, thisValue, "onstalled");
}

static inline bool setJSDOMWindowOnstalledSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().stalledEvent, value);
    return true;
}

bool setJSDOMWindowOnstalled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnstalledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onstalled");
}

static inline JSValue jsDOMWindowOnsubmitGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().submitEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnsubmit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnsubmitGetter>(*lexicalGlobalObject, thisValue, "onsubmit");
}

static inline bool setJSDOMWindowOnsubmitSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().submitEvent, value);
    return true;
}

bool setJSDOMWindowOnsubmit(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnsubmitSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onsubmit");
}

static inline JSValue jsDOMWindowOnsuspendGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().suspendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnsuspend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnsuspendGetter>(*lexicalGlobalObject, thisValue, "onsuspend");
}

static inline bool setJSDOMWindowOnsuspendSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().suspendEvent, value);
    return true;
}

bool setJSDOMWindowOnsuspend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnsuspendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onsuspend");
}

static inline JSValue jsDOMWindowOntimeupdateGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().timeupdateEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOntimeupdate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOntimeupdateGetter>(*lexicalGlobalObject, thisValue, "ontimeupdate");
}

static inline bool setJSDOMWindowOntimeupdateSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().timeupdateEvent, value);
    return true;
}

bool setJSDOMWindowOntimeupdate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOntimeupdateSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontimeupdate");
}

static inline JSValue jsDOMWindowOntoggleGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().toggleEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOntoggle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOntoggleGetter>(*lexicalGlobalObject, thisValue, "ontoggle");
}

static inline bool setJSDOMWindowOntoggleSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().toggleEvent, value);
    return true;
}

bool setJSDOMWindowOntoggle(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOntoggleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontoggle");
}

static inline JSValue jsDOMWindowOnunhandledrejectionGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().unhandledrejectionEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnunhandledrejection(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnunhandledrejectionGetter>(*lexicalGlobalObject, thisValue, "onunhandledrejection");
}

static inline bool setJSDOMWindowOnunhandledrejectionSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().unhandledrejectionEvent, value);
    return true;
}

bool setJSDOMWindowOnunhandledrejection(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnunhandledrejectionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onunhandledrejection");
}

static inline JSValue jsDOMWindowOnvolumechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().volumechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnvolumechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnvolumechangeGetter>(*lexicalGlobalObject, thisValue, "onvolumechange");
}

static inline bool setJSDOMWindowOnvolumechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().volumechangeEvent, value);
    return true;
}

bool setJSDOMWindowOnvolumechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnvolumechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onvolumechange");
}

static inline JSValue jsDOMWindowOnwaitingGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().waitingEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnwaiting(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnwaitingGetter>(*lexicalGlobalObject, thisValue, "onwaiting");
}

static inline bool setJSDOMWindowOnwaitingSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().waitingEvent, value);
    return true;
}

bool setJSDOMWindowOnwaiting(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnwaitingSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwaiting");
}

static inline JSValue jsDOMWindowOntransitionendGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().transitionendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOntransitionend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOntransitionendGetter>(*lexicalGlobalObject, thisValue, "ontransitionend");
}

static inline bool setJSDOMWindowOntransitionendSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().transitionendEvent, value);
    return true;
}

bool setJSDOMWindowOntransitionend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOntransitionendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontransitionend");
}

static inline JSValue jsDOMWindowOntransitionrunGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().transitionrunEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOntransitionrun(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOntransitionrunGetter>(*lexicalGlobalObject, thisValue, "ontransitionrun");
}

static inline bool setJSDOMWindowOntransitionrunSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().transitionrunEvent, value);
    return true;
}

bool setJSDOMWindowOntransitionrun(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOntransitionrunSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontransitionrun");
}

static inline JSValue jsDOMWindowOntransitionstartGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().transitionstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOntransitionstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOntransitionstartGetter>(*lexicalGlobalObject, thisValue, "ontransitionstart");
}

static inline bool setJSDOMWindowOntransitionstartSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().transitionstartEvent, value);
    return true;
}

bool setJSDOMWindowOntransitionstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOntransitionstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontransitionstart");
}

static inline JSValue jsDOMWindowOntransitioncancelGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().transitioncancelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOntransitioncancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOntransitioncancelGetter>(*lexicalGlobalObject, thisValue, "ontransitioncancel");
}

static inline bool setJSDOMWindowOntransitioncancelSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().transitioncancelEvent, value);
    return true;
}

bool setJSDOMWindowOntransitioncancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOntransitioncancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontransitioncancel");
}

static inline JSValue jsDOMWindowOnanimationendGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().animationendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnanimationend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnanimationendGetter>(*lexicalGlobalObject, thisValue, "onanimationend");
}

static inline bool setJSDOMWindowOnanimationendSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().animationendEvent, value);
    return true;
}

bool setJSDOMWindowOnanimationend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnanimationendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onanimationend");
}

static inline JSValue jsDOMWindowOnanimationiterationGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().animationiterationEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnanimationiteration(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnanimationiterationGetter>(*lexicalGlobalObject, thisValue, "onanimationiteration");
}

static inline bool setJSDOMWindowOnanimationiterationSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().animationiterationEvent, value);
    return true;
}

bool setJSDOMWindowOnanimationiteration(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnanimationiterationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onanimationiteration");
}

static inline JSValue jsDOMWindowOnanimationstartGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().animationstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnanimationstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnanimationstartGetter>(*lexicalGlobalObject, thisValue, "onanimationstart");
}

static inline bool setJSDOMWindowOnanimationstartSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().animationstartEvent, value);
    return true;
}

bool setJSDOMWindowOnanimationstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnanimationstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onanimationstart");
}

static inline JSValue jsDOMWindowOnanimationcancelGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().animationcancelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnanimationcancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnanimationcancelGetter>(*lexicalGlobalObject, thisValue, "onanimationcancel");
}

static inline bool setJSDOMWindowOnanimationcancelSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().animationcancelEvent, value);
    return true;
}

bool setJSDOMWindowOnanimationcancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnanimationcancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onanimationcancel");
}

static inline JSValue jsDOMWindowOngotpointercaptureGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().gotpointercaptureEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOngotpointercapture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOngotpointercaptureGetter>(*lexicalGlobalObject, thisValue, "ongotpointercapture");
}

static inline bool setJSDOMWindowOngotpointercaptureSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().gotpointercaptureEvent, value);
    return true;
}

bool setJSDOMWindowOngotpointercapture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOngotpointercaptureSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ongotpointercapture");
}

static inline JSValue jsDOMWindowOnlostpointercaptureGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().lostpointercaptureEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnlostpointercapture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnlostpointercaptureGetter>(*lexicalGlobalObject, thisValue, "onlostpointercapture");
}

static inline bool setJSDOMWindowOnlostpointercaptureSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().lostpointercaptureEvent, value);
    return true;
}

bool setJSDOMWindowOnlostpointercapture(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnlostpointercaptureSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onlostpointercapture");
}

static inline JSValue jsDOMWindowOnpointerdownGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerdownEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnpointerdown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnpointerdownGetter>(*lexicalGlobalObject, thisValue, "onpointerdown");
}

static inline bool setJSDOMWindowOnpointerdownSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointerdownEvent, value);
    return true;
}

bool setJSDOMWindowOnpointerdown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnpointerdownSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerdown");
}

static inline JSValue jsDOMWindowOnpointermoveGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointermoveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnpointermove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnpointermoveGetter>(*lexicalGlobalObject, thisValue, "onpointermove");
}

static inline bool setJSDOMWindowOnpointermoveSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointermoveEvent, value);
    return true;
}

bool setJSDOMWindowOnpointermove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnpointermoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointermove");
}

static inline JSValue jsDOMWindowOnpointerupGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerupEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnpointerup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnpointerupGetter>(*lexicalGlobalObject, thisValue, "onpointerup");
}

static inline bool setJSDOMWindowOnpointerupSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointerupEvent, value);
    return true;
}

bool setJSDOMWindowOnpointerup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnpointerupSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerup");
}

static inline JSValue jsDOMWindowOnpointercancelGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointercancelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnpointercancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnpointercancelGetter>(*lexicalGlobalObject, thisValue, "onpointercancel");
}

static inline bool setJSDOMWindowOnpointercancelSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointercancelEvent, value);
    return true;
}

bool setJSDOMWindowOnpointercancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnpointercancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointercancel");
}

static inline JSValue jsDOMWindowOnpointeroverGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointeroverEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnpointerover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnpointeroverGetter>(*lexicalGlobalObject, thisValue, "onpointerover");
}

static inline bool setJSDOMWindowOnpointeroverSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointeroverEvent, value);
    return true;
}

bool setJSDOMWindowOnpointerover(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnpointeroverSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerover");
}

static inline JSValue jsDOMWindowOnpointeroutGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointeroutEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnpointerout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnpointeroutGetter>(*lexicalGlobalObject, thisValue, "onpointerout");
}

static inline bool setJSDOMWindowOnpointeroutSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointeroutEvent, value);
    return true;
}

bool setJSDOMWindowOnpointerout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnpointeroutSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerout");
}

static inline JSValue jsDOMWindowOnpointerenterGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerenterEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnpointerenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnpointerenterGetter>(*lexicalGlobalObject, thisValue, "onpointerenter");
}

static inline bool setJSDOMWindowOnpointerenterSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointerenterEvent, value);
    return true;
}

bool setJSDOMWindowOnpointerenter(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnpointerenterSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerenter");
}

static inline JSValue jsDOMWindowOnpointerleaveGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().pointerleaveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnpointerleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnpointerleaveGetter>(*lexicalGlobalObject, thisValue, "onpointerleave");
}

static inline bool setJSDOMWindowOnpointerleaveSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pointerleaveEvent, value);
    return true;
}

bool setJSDOMWindowOnpointerleave(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnpointerleaveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpointerleave");
}

static inline JSValue jsDOMWindowOnsearchGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().searchEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnsearch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnsearchGetter>(*lexicalGlobalObject, thisValue, "onsearch");
}

static inline bool setJSDOMWindowOnsearchSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().searchEvent, value);
    return true;
}

bool setJSDOMWindowOnsearch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnsearchSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onsearch");
}

static inline JSValue jsDOMWindowOnwheelGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().wheelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnwheel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnwheelGetter>(*lexicalGlobalObject, thisValue, "onwheel");
}

static inline bool setJSDOMWindowOnwheelSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().wheelEvent, value);
    return true;
}

bool setJSDOMWindowOnwheel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnwheelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwheel");
}

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsDOMWindowOntouchcancelGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchcancelEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOntouchcancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOntouchcancelGetter>(*lexicalGlobalObject, thisValue, "ontouchcancel");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSDOMWindowOntouchcancelSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().touchcancelEvent, value);
    return true;
}

bool setJSDOMWindowOntouchcancel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOntouchcancelSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontouchcancel");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsDOMWindowOntouchendGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchendEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOntouchend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOntouchendGetter>(*lexicalGlobalObject, thisValue, "ontouchend");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSDOMWindowOntouchendSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().touchendEvent, value);
    return true;
}

bool setJSDOMWindowOntouchend(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOntouchendSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontouchend");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsDOMWindowOntouchmoveGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchmoveEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOntouchmove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOntouchmoveGetter>(*lexicalGlobalObject, thisValue, "ontouchmove");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSDOMWindowOntouchmoveSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().touchmoveEvent, value);
    return true;
}

bool setJSDOMWindowOntouchmove(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOntouchmoveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontouchmove");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsDOMWindowOntouchstartGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchstartEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOntouchstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOntouchstartGetter>(*lexicalGlobalObject, thisValue, "ontouchstart");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSDOMWindowOntouchstartSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().touchstartEvent, value);
    return true;
}

bool setJSDOMWindowOntouchstart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOntouchstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontouchstart");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline JSValue jsDOMWindowOntouchforcechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().touchforcechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOntouchforcechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOntouchforcechangeGetter>(*lexicalGlobalObject, thisValue, "ontouchforcechange");
}

#endif

#if ENABLE(TOUCH_EVENTS)
static inline bool setJSDOMWindowOntouchforcechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().touchforcechangeEvent, value);
    return true;
}

bool setJSDOMWindowOntouchforcechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOntouchforcechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ontouchforcechange");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline JSValue jsDOMWindowOnwebkitmouseforcechangedGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcechangedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnwebkitmouseforcechanged(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnwebkitmouseforcechangedGetter>(*lexicalGlobalObject, thisValue, "onwebkitmouseforcechanged");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline bool setJSDOMWindowOnwebkitmouseforcechangedSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitmouseforcechangedEvent, value);
    return true;
}

bool setJSDOMWindowOnwebkitmouseforcechanged(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnwebkitmouseforcechangedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitmouseforcechanged");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline JSValue jsDOMWindowOnwebkitmouseforcedownGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcedownEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnwebkitmouseforcedown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnwebkitmouseforcedownGetter>(*lexicalGlobalObject, thisValue, "onwebkitmouseforcedown");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline bool setJSDOMWindowOnwebkitmouseforcedownSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitmouseforcedownEvent, value);
    return true;
}

bool setJSDOMWindowOnwebkitmouseforcedown(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnwebkitmouseforcedownSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitmouseforcedown");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline JSValue jsDOMWindowOnwebkitmouseforcewillbeginGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforcewillbeginEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnwebkitmouseforcewillbegin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnwebkitmouseforcewillbeginGetter>(*lexicalGlobalObject, thisValue, "onwebkitmouseforcewillbegin");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline bool setJSDOMWindowOnwebkitmouseforcewillbeginSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitmouseforcewillbeginEvent, value);
    return true;
}

bool setJSDOMWindowOnwebkitmouseforcewillbegin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnwebkitmouseforcewillbeginSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitmouseforcewillbegin");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline JSValue jsDOMWindowOnwebkitmouseforceupGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().webkitmouseforceupEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnwebkitmouseforceup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnwebkitmouseforceupGetter>(*lexicalGlobalObject, thisValue, "onwebkitmouseforceup");
}

#endif

#if ENABLE(MOUSE_FORCE_EVENTS)
static inline bool setJSDOMWindowOnwebkitmouseforceupSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().webkitmouseforceupEvent, value);
    return true;
}

bool setJSDOMWindowOnwebkitmouseforceup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnwebkitmouseforceupSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwebkitmouseforceup");
}

#endif

static inline JSValue jsDOMWindowCryptoGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Crypto>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.crypto());
    return result;
}

EncodedJSValue jsDOMWindowCrypto(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowCryptoGetter>(*lexicalGlobalObject, thisValue, "crypto");
}

static inline JSValue jsDOMWindowPerformanceGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Performance>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.performance());
    return result;
}

EncodedJSValue jsDOMWindowPerformance(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowPerformanceGetter>(*lexicalGlobalObject, thisValue, "performance");
}

static inline bool setJSDOMWindowPerformanceSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("performance"), strlen("performance")), value);
}

bool setJSDOMWindowPerformance(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowPerformanceSetter>(*lexicalGlobalObject, thisValue, encodedValue, "performance");
}

static inline JSValue jsDOMWindowOnafterprintGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().afterprintEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnafterprint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnafterprintGetter>(*lexicalGlobalObject, thisValue, "onafterprint");
}

static inline bool setJSDOMWindowOnafterprintSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().afterprintEvent, value);
    return true;
}

bool setJSDOMWindowOnafterprint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnafterprintSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onafterprint");
}

static inline JSValue jsDOMWindowOnbeforeprintGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().beforeprintEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnbeforeprint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnbeforeprintGetter>(*lexicalGlobalObject, thisValue, "onbeforeprint");
}

static inline bool setJSDOMWindowOnbeforeprintSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().beforeprintEvent, value);
    return true;
}

bool setJSDOMWindowOnbeforeprint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnbeforeprintSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onbeforeprint");
}

static inline JSValue jsDOMWindowOnbeforeunloadGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().beforeunloadEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnbeforeunload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnbeforeunloadGetter>(*lexicalGlobalObject, thisValue, "onbeforeunload");
}

static inline bool setJSDOMWindowOnbeforeunloadSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().beforeunloadEvent, value);
    return true;
}

bool setJSDOMWindowOnbeforeunload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnbeforeunloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onbeforeunload");
}

static inline JSValue jsDOMWindowOnhashchangeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().hashchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnhashchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnhashchangeGetter>(*lexicalGlobalObject, thisValue, "onhashchange");
}

static inline bool setJSDOMWindowOnhashchangeSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().hashchangeEvent, value);
    return true;
}

bool setJSDOMWindowOnhashchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnhashchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onhashchange");
}

static inline JSValue jsDOMWindowOnlanguagechangeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().languagechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnlanguagechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnlanguagechangeGetter>(*lexicalGlobalObject, thisValue, "onlanguagechange");
}

static inline bool setJSDOMWindowOnlanguagechangeSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().languagechangeEvent, value);
    return true;
}

bool setJSDOMWindowOnlanguagechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnlanguagechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onlanguagechange");
}

static inline JSValue jsDOMWindowOnmessageGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().messageEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnmessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnmessageGetter>(*lexicalGlobalObject, thisValue, "onmessage");
}

static inline bool setJSDOMWindowOnmessageSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().messageEvent, value);
    return true;
}

bool setJSDOMWindowOnmessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnmessageSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onmessage");
}

static inline JSValue jsDOMWindowOnofflineGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().offlineEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnoffline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnofflineGetter>(*lexicalGlobalObject, thisValue, "onoffline");
}

static inline bool setJSDOMWindowOnofflineSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().offlineEvent, value);
    return true;
}

bool setJSDOMWindowOnoffline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnofflineSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onoffline");
}

static inline JSValue jsDOMWindowOnonlineGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().onlineEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnonline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnonlineGetter>(*lexicalGlobalObject, thisValue, "ononline");
}

static inline bool setJSDOMWindowOnonlineSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().onlineEvent, value);
    return true;
}

bool setJSDOMWindowOnonline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnonlineSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ononline");
}

static inline JSValue jsDOMWindowOnpagehideGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().pagehideEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnpagehide(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnpagehideGetter>(*lexicalGlobalObject, thisValue, "onpagehide");
}

static inline bool setJSDOMWindowOnpagehideSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pagehideEvent, value);
    return true;
}

bool setJSDOMWindowOnpagehide(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnpagehideSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpagehide");
}

static inline JSValue jsDOMWindowOnpageshowGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().pageshowEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnpageshow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnpageshowGetter>(*lexicalGlobalObject, thisValue, "onpageshow");
}

static inline bool setJSDOMWindowOnpageshowSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().pageshowEvent, value);
    return true;
}

bool setJSDOMWindowOnpageshow(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnpageshowSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpageshow");
}

static inline JSValue jsDOMWindowOnpopstateGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().popstateEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnpopstate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnpopstateGetter>(*lexicalGlobalObject, thisValue, "onpopstate");
}

static inline bool setJSDOMWindowOnpopstateSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().popstateEvent, value);
    return true;
}

bool setJSDOMWindowOnpopstate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnpopstateSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onpopstate");
}

static inline JSValue jsDOMWindowOnstorageGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().storageEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnstorage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnstorageGetter>(*lexicalGlobalObject, thisValue, "onstorage");
}

static inline bool setJSDOMWindowOnstorageSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().storageEvent, value);
    return true;
}

bool setJSDOMWindowOnstorage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnstorageSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onstorage");
}

static inline JSValue jsDOMWindowOnunloadGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().unloadEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnunload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnunloadGetter>(*lexicalGlobalObject, thisValue, "onunload");
}

static inline bool setJSDOMWindowOnunloadSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().unloadEvent, value);
    return true;
}

bool setJSDOMWindowOnunload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnunloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onunload");
}

#if ENABLE(ORIENTATION_EVENTS)
static inline JSValue jsDOMWindowOnorientationchangeGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return windowEventHandlerAttribute(thisObject.wrapped(), eventNames().orientationchangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsDOMWindowOnorientationchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOnorientationchangeGetter>(*lexicalGlobalObject, thisValue, "onorientationchange");
}

#endif

#if ENABLE(ORIENTATION_EVENTS)
static inline bool setJSDOMWindowOnorientationchangeSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    setWindowEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().orientationchangeEvent, value);
    return true;
}

bool setJSDOMWindowOnorientationchange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOnorientationchangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onorientationchange");
}

#endif

static inline JSValue jsDOMWindowOriginGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.origin());
    return result;
}

EncodedJSValue jsDOMWindowOrigin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOriginGetter>(*lexicalGlobalObject, thisValue, "origin");
}

static inline bool setJSDOMWindowOriginSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in property.
    return replaceStaticPropertySlot(vm, &thisObject, Identifier::fromString(vm, reinterpret_cast<const LChar*>("origin"), strlen("origin")), value);
}

bool setJSDOMWindowOrigin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOriginSetter>(*lexicalGlobalObject, thisValue, encodedValue, "origin");
}

static inline JSValue jsDOMWindowIsSecureContextGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isSecureContext());
    return result;
}

EncodedJSValue jsDOMWindowIsSecureContext(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowIsSecureContextGetter>(*lexicalGlobalObject, thisValue, "isSecureContext");
}

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline JSValue jsDOMWindowWebKitPlaybackTargetAvailabilityEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebKitPlaybackTargetAvailabilityEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowWebKitPlaybackTargetAvailabilityEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowWebKitPlaybackTargetAvailabilityEventConstructorGetter>(*lexicalGlobalObject, thisValue, "WebKitPlaybackTargetAvailabilityEvent");
}

#endif

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline bool setJSDOMWindowWebKitPlaybackTargetAvailabilityEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("WebKitPlaybackTargetAvailabilityEvent"), strlen("WebKitPlaybackTargetAvailabilityEvent")), value);
}

bool setJSDOMWindowWebKitPlaybackTargetAvailabilityEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowWebKitPlaybackTargetAvailabilityEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "WebKitPlaybackTargetAvailabilityEvent");
}

#endif

static inline JSValue jsDOMWindowClipboardConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSClipboard::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowClipboardConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowClipboardConstructorGetter>(*lexicalGlobalObject, thisValue, "Clipboard");
}

static inline bool setJSDOMWindowClipboardConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("Clipboard"), strlen("Clipboard")), value);
}

bool setJSDOMWindowClipboardConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowClipboardConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "Clipboard");
}

static inline JSValue jsDOMWindowClipboardItemConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSClipboardItem::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowClipboardItemConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowClipboardItemConstructorGetter>(*lexicalGlobalObject, thisValue, "ClipboardItem");
}

static inline bool setJSDOMWindowClipboardItemConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ClipboardItem"), strlen("ClipboardItem")), value);
}

bool setJSDOMWindowClipboardItemConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowClipboardItemConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ClipboardItem");
}

static inline JSValue jsDOMWindowCacheConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSDOMCache::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowCacheConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowCacheConstructorGetter>(*lexicalGlobalObject, thisValue, "Cache");
}

static inline bool setJSDOMWindowCacheConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("Cache"), strlen("Cache")), value);
}

bool setJSDOMWindowCacheConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowCacheConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "Cache");
}

static inline JSValue jsDOMWindowCacheStorageConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSDOMCacheStorage::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowCacheStorageConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowCacheStorageConstructorGetter>(*lexicalGlobalObject, thisValue, "CacheStorage");
}

static inline bool setJSDOMWindowCacheStorageConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("CacheStorage"), strlen("CacheStorage")), value);
}

bool setJSDOMWindowCacheStorageConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowCacheStorageConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "CacheStorage");
}

#if ENABLE(WEB_AUTHN)
static inline JSValue jsDOMWindowCredentialConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSBasicCredential::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowCredentialConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowCredentialConstructorGetter>(*lexicalGlobalObject, thisValue, "Credential");
}

#endif

#if ENABLE(WEB_AUTHN)
static inline bool setJSDOMWindowCredentialConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("Credential"), strlen("Credential")), value);
}

bool setJSDOMWindowCredentialConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowCredentialConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "Credential");
}

#endif

#if ENABLE(WEB_AUTHN)
static inline JSValue jsDOMWindowCredentialsContainerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSCredentialsContainer::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowCredentialsContainerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowCredentialsContainerConstructorGetter>(*lexicalGlobalObject, thisValue, "CredentialsContainer");
}

#endif

#if ENABLE(WEB_AUTHN)
static inline bool setJSDOMWindowCredentialsContainerConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("CredentialsContainer"), strlen("CredentialsContainer")), value);
}

bool setJSDOMWindowCredentialsContainerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowCredentialsContainerConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "CredentialsContainer");
}

#endif

static inline JSValue jsDOMWindowFileSystemConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSDOMFileSystem::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowFileSystemConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowFileSystemConstructorGetter>(*lexicalGlobalObject, thisValue, "FileSystem");
}

static inline bool setJSDOMWindowFileSystemConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("FileSystem"), strlen("FileSystem")), value);
}

bool setJSDOMWindowFileSystemConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowFileSystemConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "FileSystem");
}

static inline JSValue jsDOMWindowFileSystemDirectoryEntryConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSFileSystemDirectoryEntry::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowFileSystemDirectoryEntryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowFileSystemDirectoryEntryConstructorGetter>(*lexicalGlobalObject, thisValue, "FileSystemDirectoryEntry");
}

static inline bool setJSDOMWindowFileSystemDirectoryEntryConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("FileSystemDirectoryEntry"), strlen("FileSystemDirectoryEntry")), value);
}

bool setJSDOMWindowFileSystemDirectoryEntryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowFileSystemDirectoryEntryConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "FileSystemDirectoryEntry");
}

static inline JSValue jsDOMWindowFileSystemDirectoryReaderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSFileSystemDirectoryReader::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowFileSystemDirectoryReaderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowFileSystemDirectoryReaderConstructorGetter>(*lexicalGlobalObject, thisValue, "FileSystemDirectoryReader");
}

static inline bool setJSDOMWindowFileSystemDirectoryReaderConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("FileSystemDirectoryReader"), strlen("FileSystemDirectoryReader")), value);
}

bool setJSDOMWindowFileSystemDirectoryReaderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowFileSystemDirectoryReaderConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "FileSystemDirectoryReader");
}

static inline JSValue jsDOMWindowFileSystemEntryConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSFileSystemEntry::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowFileSystemEntryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowFileSystemEntryConstructorGetter>(*lexicalGlobalObject, thisValue, "FileSystemEntry");
}

static inline bool setJSDOMWindowFileSystemEntryConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("FileSystemEntry"), strlen("FileSystemEntry")), value);
}

bool setJSDOMWindowFileSystemEntryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowFileSystemEntryConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "FileSystemEntry");
}

static inline JSValue jsDOMWindowFileSystemFileEntryConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSFileSystemFileEntry::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowFileSystemFileEntryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowFileSystemFileEntryConstructorGetter>(*lexicalGlobalObject, thisValue, "FileSystemFileEntry");
}

static inline bool setJSDOMWindowFileSystemFileEntryConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("FileSystemFileEntry"), strlen("FileSystemFileEntry")), value);
}

bool setJSDOMWindowFileSystemFileEntryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowFileSystemFileEntryConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "FileSystemFileEntry");
}

static inline JSValue jsDOMWindowHeadersConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSFetchHeaders::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowHeadersConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowHeadersConstructorGetter>(*lexicalGlobalObject, thisValue, "Headers");
}

static inline bool setJSDOMWindowHeadersConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("Headers"), strlen("Headers")), value);
}

bool setJSDOMWindowHeadersConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowHeadersConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "Headers");
}

static inline JSValue jsDOMWindowRequestConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSFetchRequest::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowRequestConstructorGetter>(*lexicalGlobalObject, thisValue, "Request");
}

static inline bool setJSDOMWindowRequestConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("Request"), strlen("Request")), value);
}

bool setJSDOMWindowRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowRequestConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "Request");
}

static inline JSValue jsDOMWindowResponseConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSFetchResponse::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowResponseConstructorGetter>(*lexicalGlobalObject, thisValue, "Response");
}

static inline bool setJSDOMWindowResponseConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("Response"), strlen("Response")), value);
}

bool setJSDOMWindowResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowResponseConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "Response");
}

#if ENABLE(GEOLOCATION)
static inline JSValue jsDOMWindowGeolocationConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSGeolocation::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGeolocationConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGeolocationConstructorGetter>(*lexicalGlobalObject, thisValue, "Geolocation");
}

#endif

#if ENABLE(GEOLOCATION)
static inline bool setJSDOMWindowGeolocationConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("Geolocation"), strlen("Geolocation")), value);
}

bool setJSDOMWindowGeolocationConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGeolocationConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "Geolocation");
}

#endif

#if ENABLE(GEOLOCATION)
static inline JSValue jsDOMWindowGeolocationCoordinatesConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSGeolocationCoordinates::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGeolocationCoordinatesConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGeolocationCoordinatesConstructorGetter>(*lexicalGlobalObject, thisValue, "GeolocationCoordinates");
}

#endif

#if ENABLE(GEOLOCATION)
static inline bool setJSDOMWindowGeolocationCoordinatesConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GeolocationCoordinates"), strlen("GeolocationCoordinates")), value);
}

bool setJSDOMWindowGeolocationCoordinatesConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGeolocationCoordinatesConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GeolocationCoordinates");
}

#endif

#if ENABLE(GEOLOCATION)
static inline JSValue jsDOMWindowGeolocationPositionConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSGeolocationPosition::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGeolocationPositionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGeolocationPositionConstructorGetter>(*lexicalGlobalObject, thisValue, "GeolocationPosition");
}

#endif

#if ENABLE(GEOLOCATION)
static inline bool setJSDOMWindowGeolocationPositionConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GeolocationPosition"), strlen("GeolocationPosition")), value);
}

bool setJSDOMWindowGeolocationPositionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGeolocationPositionConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GeolocationPosition");
}

#endif

#if ENABLE(GEOLOCATION)
static inline JSValue jsDOMWindowGeolocationPositionErrorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSGeolocationPositionError::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGeolocationPositionErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGeolocationPositionErrorConstructorGetter>(*lexicalGlobalObject, thisValue, "GeolocationPositionError");
}

#endif

#if ENABLE(GEOLOCATION)
static inline bool setJSDOMWindowGeolocationPositionErrorConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GeolocationPositionError"), strlen("GeolocationPositionError")), value);
}

bool setJSDOMWindowGeolocationPositionErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGeolocationPositionErrorConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GeolocationPositionError");
}

#endif

static inline JSValue jsDOMWindowHighlightMapConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSHighlightMap::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowHighlightMapConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowHighlightMapConstructorGetter>(*lexicalGlobalObject, thisValue, "HighlightMap");
}

static inline bool setJSDOMWindowHighlightMapConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("HighlightMap"), strlen("HighlightMap")), value);
}

bool setJSDOMWindowHighlightMapConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowHighlightMapConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "HighlightMap");
}

static inline JSValue jsDOMWindowHighlightRangeGroupConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSHighlightRangeGroup::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowHighlightRangeGroupConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowHighlightRangeGroupConstructorGetter>(*lexicalGlobalObject, thisValue, "HighlightRangeGroup");
}

static inline bool setJSDOMWindowHighlightRangeGroupConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("HighlightRangeGroup"), strlen("HighlightRangeGroup")), value);
}

bool setJSDOMWindowHighlightRangeGroupConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowHighlightRangeGroupConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "HighlightRangeGroup");
}

#if ENABLE(INDEXED_DATABASE)
static inline JSValue jsDOMWindowIDBCursorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSIDBCursor::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowIDBCursorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowIDBCursorConstructorGetter>(*lexicalGlobalObject, thisValue, "IDBCursor");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline bool setJSDOMWindowIDBCursorConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("IDBCursor"), strlen("IDBCursor")), value);
}

bool setJSDOMWindowIDBCursorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowIDBCursorConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "IDBCursor");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline JSValue jsDOMWindowIDBCursorWithValueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSIDBCursorWithValue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowIDBCursorWithValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowIDBCursorWithValueConstructorGetter>(*lexicalGlobalObject, thisValue, "IDBCursorWithValue");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline bool setJSDOMWindowIDBCursorWithValueConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("IDBCursorWithValue"), strlen("IDBCursorWithValue")), value);
}

bool setJSDOMWindowIDBCursorWithValueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowIDBCursorWithValueConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "IDBCursorWithValue");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline JSValue jsDOMWindowIDBDatabaseConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSIDBDatabase::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowIDBDatabaseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowIDBDatabaseConstructorGetter>(*lexicalGlobalObject, thisValue, "IDBDatabase");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline bool setJSDOMWindowIDBDatabaseConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("IDBDatabase"), strlen("IDBDatabase")), value);
}

bool setJSDOMWindowIDBDatabaseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowIDBDatabaseConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "IDBDatabase");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline JSValue jsDOMWindowIDBFactoryConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSIDBFactory::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowIDBFactoryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowIDBFactoryConstructorGetter>(*lexicalGlobalObject, thisValue, "IDBFactory");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline bool setJSDOMWindowIDBFactoryConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("IDBFactory"), strlen("IDBFactory")), value);
}

bool setJSDOMWindowIDBFactoryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowIDBFactoryConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "IDBFactory");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline JSValue jsDOMWindowIDBIndexConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSIDBIndex::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowIDBIndexConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowIDBIndexConstructorGetter>(*lexicalGlobalObject, thisValue, "IDBIndex");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline bool setJSDOMWindowIDBIndexConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("IDBIndex"), strlen("IDBIndex")), value);
}

bool setJSDOMWindowIDBIndexConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowIDBIndexConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "IDBIndex");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline JSValue jsDOMWindowIDBKeyRangeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSIDBKeyRange::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowIDBKeyRangeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowIDBKeyRangeConstructorGetter>(*lexicalGlobalObject, thisValue, "IDBKeyRange");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline bool setJSDOMWindowIDBKeyRangeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("IDBKeyRange"), strlen("IDBKeyRange")), value);
}

bool setJSDOMWindowIDBKeyRangeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowIDBKeyRangeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "IDBKeyRange");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline JSValue jsDOMWindowIDBObjectStoreConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSIDBObjectStore::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowIDBObjectStoreConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowIDBObjectStoreConstructorGetter>(*lexicalGlobalObject, thisValue, "IDBObjectStore");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline bool setJSDOMWindowIDBObjectStoreConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("IDBObjectStore"), strlen("IDBObjectStore")), value);
}

bool setJSDOMWindowIDBObjectStoreConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowIDBObjectStoreConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "IDBObjectStore");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline JSValue jsDOMWindowIDBOpenDBRequestConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSIDBOpenDBRequest::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowIDBOpenDBRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowIDBOpenDBRequestConstructorGetter>(*lexicalGlobalObject, thisValue, "IDBOpenDBRequest");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline bool setJSDOMWindowIDBOpenDBRequestConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("IDBOpenDBRequest"), strlen("IDBOpenDBRequest")), value);
}

bool setJSDOMWindowIDBOpenDBRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowIDBOpenDBRequestConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "IDBOpenDBRequest");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline JSValue jsDOMWindowIDBRequestConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSIDBRequest::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowIDBRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowIDBRequestConstructorGetter>(*lexicalGlobalObject, thisValue, "IDBRequest");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline bool setJSDOMWindowIDBRequestConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("IDBRequest"), strlen("IDBRequest")), value);
}

bool setJSDOMWindowIDBRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowIDBRequestConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "IDBRequest");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline JSValue jsDOMWindowIDBTransactionConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSIDBTransaction::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowIDBTransactionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowIDBTransactionConstructorGetter>(*lexicalGlobalObject, thisValue, "IDBTransaction");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline bool setJSDOMWindowIDBTransactionConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("IDBTransaction"), strlen("IDBTransaction")), value);
}

bool setJSDOMWindowIDBTransactionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowIDBTransactionConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "IDBTransaction");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline JSValue jsDOMWindowIDBVersionChangeEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSIDBVersionChangeEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowIDBVersionChangeEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowIDBVersionChangeEventConstructorGetter>(*lexicalGlobalObject, thisValue, "IDBVersionChangeEvent");
}

#endif

#if ENABLE(INDEXED_DATABASE)
static inline bool setJSDOMWindowIDBVersionChangeEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("IDBVersionChangeEvent"), strlen("IDBVersionChangeEvent")), value);
}

bool setJSDOMWindowIDBVersionChangeEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowIDBVersionChangeEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "IDBVersionChangeEvent");
}

#endif

static inline JSValue jsDOMWindowMediaCapabilitiesConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSMediaCapabilities::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowMediaCapabilitiesConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowMediaCapabilitiesConstructorGetter>(*lexicalGlobalObject, thisValue, "MediaCapabilities");
}

static inline bool setJSDOMWindowMediaCapabilitiesConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("MediaCapabilities"), strlen("MediaCapabilities")), value);
}

bool setJSDOMWindowMediaCapabilitiesConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowMediaCapabilitiesConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "MediaCapabilities");
}

#if ENABLE(MEDIA_STREAM)
static inline JSValue jsDOMWindowBlobEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSBlobEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowBlobEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowBlobEventConstructorGetter>(*lexicalGlobalObject, thisValue, "BlobEvent");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline bool setJSDOMWindowBlobEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("BlobEvent"), strlen("BlobEvent")), value);
}

bool setJSDOMWindowBlobEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowBlobEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "BlobEvent");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSValue jsDOMWindowMediaRecorderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSMediaRecorder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowMediaRecorderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowMediaRecorderConstructorGetter>(*lexicalGlobalObject, thisValue, "MediaRecorder");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline bool setJSDOMWindowMediaRecorderConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("MediaRecorder"), strlen("MediaRecorder")), value);
}

bool setJSDOMWindowMediaRecorderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowMediaRecorderConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "MediaRecorder");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSValue jsDOMWindowMediaRecorderErrorEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSMediaRecorderErrorEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowMediaRecorderErrorEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowMediaRecorderErrorEventConstructorGetter>(*lexicalGlobalObject, thisValue, "MediaRecorderErrorEvent");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline bool setJSDOMWindowMediaRecorderErrorEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("MediaRecorderErrorEvent"), strlen("MediaRecorderErrorEvent")), value);
}

bool setJSDOMWindowMediaRecorderErrorEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowMediaRecorderErrorEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "MediaRecorderErrorEvent");
}

#endif

#if ENABLE(MEDIA_SESSION)
static inline JSValue jsDOMWindowMediaRemoteControlsConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSMediaRemoteControls::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowMediaRemoteControlsConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowMediaRemoteControlsConstructorGetter>(*lexicalGlobalObject, thisValue, "MediaRemoteControls");
}

#endif

#if ENABLE(MEDIA_SESSION)
static inline bool setJSDOMWindowMediaRemoteControlsConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("MediaRemoteControls"), strlen("MediaRemoteControls")), value);
}

bool setJSDOMWindowMediaRemoteControlsConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowMediaRemoteControlsConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "MediaRemoteControls");
}

#endif

#if ENABLE(MEDIA_SESSION)
static inline JSValue jsDOMWindowMediaSessionConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSMediaSession::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowMediaSessionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowMediaSessionConstructorGetter>(*lexicalGlobalObject, thisValue, "MediaSession");
}

#endif

#if ENABLE(MEDIA_SESSION)
static inline bool setJSDOMWindowMediaSessionConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("MediaSession"), strlen("MediaSession")), value);
}

bool setJSDOMWindowMediaSessionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowMediaSessionConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "MediaSession");
}

#endif

#if ENABLE(MEDIA_SOURCE)
static inline JSValue jsDOMWindowMediaSourceConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSMediaSource::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowMediaSourceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowMediaSourceConstructorGetter>(*lexicalGlobalObject, thisValue, "MediaSource");
}

#endif

#if ENABLE(MEDIA_SOURCE)
static inline bool setJSDOMWindowMediaSourceConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("MediaSource"), strlen("MediaSource")), value);
}

bool setJSDOMWindowMediaSourceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowMediaSourceConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "MediaSource");
}

#endif

#if ENABLE(MEDIA_SOURCE)
static inline JSValue jsDOMWindowSourceBufferConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSSourceBuffer::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowSourceBufferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowSourceBufferConstructorGetter>(*lexicalGlobalObject, thisValue, "SourceBuffer");
}

#endif

#if ENABLE(MEDIA_SOURCE)
static inline bool setJSDOMWindowSourceBufferConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("SourceBuffer"), strlen("SourceBuffer")), value);
}

bool setJSDOMWindowSourceBufferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowSourceBufferConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "SourceBuffer");
}

#endif

#if ENABLE(MEDIA_SOURCE)
static inline JSValue jsDOMWindowSourceBufferListConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSSourceBufferList::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowSourceBufferListConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowSourceBufferListConstructorGetter>(*lexicalGlobalObject, thisValue, "SourceBufferList");
}

#endif

#if ENABLE(MEDIA_SOURCE)
static inline bool setJSDOMWindowSourceBufferListConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("SourceBufferList"), strlen("SourceBufferList")), value);
}

bool setJSDOMWindowSourceBufferListConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowSourceBufferListConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "SourceBufferList");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSValue jsDOMWindowCanvasCaptureMediaStreamTrackConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSCanvasCaptureMediaStreamTrack::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowCanvasCaptureMediaStreamTrackConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowCanvasCaptureMediaStreamTrackConstructorGetter>(*lexicalGlobalObject, thisValue, "CanvasCaptureMediaStreamTrack");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline bool setJSDOMWindowCanvasCaptureMediaStreamTrackConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("CanvasCaptureMediaStreamTrack"), strlen("CanvasCaptureMediaStreamTrack")), value);
}

bool setJSDOMWindowCanvasCaptureMediaStreamTrackConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowCanvasCaptureMediaStreamTrackConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "CanvasCaptureMediaStreamTrack");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSValue jsDOMWindowMediaDeviceInfoConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSMediaDeviceInfo::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowMediaDeviceInfoConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowMediaDeviceInfoConstructorGetter>(*lexicalGlobalObject, thisValue, "MediaDeviceInfo");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline bool setJSDOMWindowMediaDeviceInfoConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("MediaDeviceInfo"), strlen("MediaDeviceInfo")), value);
}

bool setJSDOMWindowMediaDeviceInfoConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowMediaDeviceInfoConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "MediaDeviceInfo");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSValue jsDOMWindowMediaDevicesConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSMediaDevices::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowMediaDevicesConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowMediaDevicesConstructorGetter>(*lexicalGlobalObject, thisValue, "MediaDevices");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline bool setJSDOMWindowMediaDevicesConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("MediaDevices"), strlen("MediaDevices")), value);
}

bool setJSDOMWindowMediaDevicesConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowMediaDevicesConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "MediaDevices");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSValue jsDOMWindowMediaStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSMediaStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowMediaStreamConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowMediaStreamConstructorGetter>(*lexicalGlobalObject, thisValue, "MediaStream");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline bool setJSDOMWindowMediaStreamConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("MediaStream"), strlen("MediaStream")), value);
}

bool setJSDOMWindowMediaStreamConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowMediaStreamConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "MediaStream");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSValue jsDOMWindowMediaStreamTrackConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSMediaStreamTrack::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowMediaStreamTrackConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowMediaStreamTrackConstructorGetter>(*lexicalGlobalObject, thisValue, "MediaStreamTrack");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline bool setJSDOMWindowMediaStreamTrackConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("MediaStreamTrack"), strlen("MediaStreamTrack")), value);
}

bool setJSDOMWindowMediaStreamTrackConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowMediaStreamTrackConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "MediaStreamTrack");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSValue jsDOMWindowMediaStreamTrackEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSMediaStreamTrackEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowMediaStreamTrackEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowMediaStreamTrackEventConstructorGetter>(*lexicalGlobalObject, thisValue, "MediaStreamTrackEvent");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline bool setJSDOMWindowMediaStreamTrackEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("MediaStreamTrackEvent"), strlen("MediaStreamTrackEvent")), value);
}

bool setJSDOMWindowMediaStreamTrackEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowMediaStreamTrackEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "MediaStreamTrackEvent");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSValue jsDOMWindowOverconstrainedErrorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSOverconstrainedError::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowOverconstrainedErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOverconstrainedErrorConstructorGetter>(*lexicalGlobalObject, thisValue, "OverconstrainedError");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline bool setJSDOMWindowOverconstrainedErrorConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("OverconstrainedError"), strlen("OverconstrainedError")), value);
}

bool setJSDOMWindowOverconstrainedErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOverconstrainedErrorConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "OverconstrainedError");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSValue jsDOMWindowOverconstrainedErrorEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSOverconstrainedErrorEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowOverconstrainedErrorEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOverconstrainedErrorEventConstructorGetter>(*lexicalGlobalObject, thisValue, "OverconstrainedErrorEvent");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline bool setJSDOMWindowOverconstrainedErrorEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("OverconstrainedErrorEvent"), strlen("OverconstrainedErrorEvent")), value);
}

bool setJSDOMWindowOverconstrainedErrorEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOverconstrainedErrorEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "OverconstrainedErrorEvent");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDOMWindowRTCCertificateConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSRTCCertificate::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowRTCCertificateConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowRTCCertificateConstructorGetter>(*lexicalGlobalObject, thisValue, "RTCCertificate");
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDOMWindowRTCCertificateConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("RTCCertificate"), strlen("RTCCertificate")), value);
}

bool setJSDOMWindowRTCCertificateConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowRTCCertificateConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "RTCCertificate");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDOMWindowRTCDTMFSenderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSRTCDTMFSender::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowRTCDTMFSenderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowRTCDTMFSenderConstructorGetter>(*lexicalGlobalObject, thisValue, "RTCDTMFSender");
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDOMWindowRTCDTMFSenderConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("RTCDTMFSender"), strlen("RTCDTMFSender")), value);
}

bool setJSDOMWindowRTCDTMFSenderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowRTCDTMFSenderConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "RTCDTMFSender");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDOMWindowRTCDTMFToneChangeEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSRTCDTMFToneChangeEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowRTCDTMFToneChangeEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowRTCDTMFToneChangeEventConstructorGetter>(*lexicalGlobalObject, thisValue, "RTCDTMFToneChangeEvent");
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDOMWindowRTCDTMFToneChangeEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("RTCDTMFToneChangeEvent"), strlen("RTCDTMFToneChangeEvent")), value);
}

bool setJSDOMWindowRTCDTMFToneChangeEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowRTCDTMFToneChangeEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "RTCDTMFToneChangeEvent");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDOMWindowRTCDataChannelConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSRTCDataChannel::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowRTCDataChannelConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowRTCDataChannelConstructorGetter>(*lexicalGlobalObject, thisValue, "RTCDataChannel");
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDOMWindowRTCDataChannelConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("RTCDataChannel"), strlen("RTCDataChannel")), value);
}

bool setJSDOMWindowRTCDataChannelConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowRTCDataChannelConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "RTCDataChannel");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDOMWindowRTCDataChannelEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSRTCDataChannelEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowRTCDataChannelEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowRTCDataChannelEventConstructorGetter>(*lexicalGlobalObject, thisValue, "RTCDataChannelEvent");
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDOMWindowRTCDataChannelEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("RTCDataChannelEvent"), strlen("RTCDataChannelEvent")), value);
}

bool setJSDOMWindowRTCDataChannelEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowRTCDataChannelEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "RTCDataChannelEvent");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDOMWindowRTCIceCandidateConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSRTCIceCandidate::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowRTCIceCandidateConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowRTCIceCandidateConstructorGetter>(*lexicalGlobalObject, thisValue, "RTCIceCandidate");
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDOMWindowRTCIceCandidateConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("RTCIceCandidate"), strlen("RTCIceCandidate")), value);
}

bool setJSDOMWindowRTCIceCandidateConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowRTCIceCandidateConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "RTCIceCandidate");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDOMWindowRTCIceTransportConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSRTCIceTransport::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowRTCIceTransportConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowRTCIceTransportConstructorGetter>(*lexicalGlobalObject, thisValue, "RTCIceTransport");
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDOMWindowRTCIceTransportConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("RTCIceTransport"), strlen("RTCIceTransport")), value);
}

bool setJSDOMWindowRTCIceTransportConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowRTCIceTransportConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "RTCIceTransport");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDOMWindowRTCPeerConnectionConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSRTCPeerConnection::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowRTCPeerConnectionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowRTCPeerConnectionConstructorGetter>(*lexicalGlobalObject, thisValue, "RTCPeerConnection");
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDOMWindowRTCPeerConnectionConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("RTCPeerConnection"), strlen("RTCPeerConnection")), value);
}

bool setJSDOMWindowRTCPeerConnectionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowRTCPeerConnectionConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "RTCPeerConnection");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDOMWindowRTCPeerConnectionIceEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSRTCPeerConnectionIceEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowRTCPeerConnectionIceEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowRTCPeerConnectionIceEventConstructorGetter>(*lexicalGlobalObject, thisValue, "RTCPeerConnectionIceEvent");
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDOMWindowRTCPeerConnectionIceEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("RTCPeerConnectionIceEvent"), strlen("RTCPeerConnectionIceEvent")), value);
}

bool setJSDOMWindowRTCPeerConnectionIceEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowRTCPeerConnectionIceEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "RTCPeerConnectionIceEvent");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDOMWindowRTCRtpReceiverConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSRTCRtpReceiver::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowRTCRtpReceiverConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowRTCRtpReceiverConstructorGetter>(*lexicalGlobalObject, thisValue, "RTCRtpReceiver");
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDOMWindowRTCRtpReceiverConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("RTCRtpReceiver"), strlen("RTCRtpReceiver")), value);
}

bool setJSDOMWindowRTCRtpReceiverConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowRTCRtpReceiverConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "RTCRtpReceiver");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDOMWindowRTCRtpSenderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSRTCRtpSender::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowRTCRtpSenderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowRTCRtpSenderConstructorGetter>(*lexicalGlobalObject, thisValue, "RTCRtpSender");
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDOMWindowRTCRtpSenderConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("RTCRtpSender"), strlen("RTCRtpSender")), value);
}

bool setJSDOMWindowRTCRtpSenderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowRTCRtpSenderConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "RTCRtpSender");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDOMWindowRTCRtpTransceiverConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSRTCRtpTransceiver::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowRTCRtpTransceiverConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowRTCRtpTransceiverConstructorGetter>(*lexicalGlobalObject, thisValue, "RTCRtpTransceiver");
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDOMWindowRTCRtpTransceiverConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("RTCRtpTransceiver"), strlen("RTCRtpTransceiver")), value);
}

bool setJSDOMWindowRTCRtpTransceiverConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowRTCRtpTransceiverConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "RTCRtpTransceiver");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDOMWindowRTCSessionDescriptionConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSRTCSessionDescription::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowRTCSessionDescriptionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowRTCSessionDescriptionConstructorGetter>(*lexicalGlobalObject, thisValue, "RTCSessionDescription");
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDOMWindowRTCSessionDescriptionConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("RTCSessionDescription"), strlen("RTCSessionDescription")), value);
}

bool setJSDOMWindowRTCSessionDescriptionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowRTCSessionDescriptionConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "RTCSessionDescription");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDOMWindowRTCStatsReportConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSRTCStatsReport::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowRTCStatsReportConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowRTCStatsReportConstructorGetter>(*lexicalGlobalObject, thisValue, "RTCStatsReport");
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDOMWindowRTCStatsReportConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("RTCStatsReport"), strlen("RTCStatsReport")), value);
}

bool setJSDOMWindowRTCStatsReportConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowRTCStatsReportConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "RTCStatsReport");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSValue jsDOMWindowRTCTrackEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSRTCTrackEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowRTCTrackEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowRTCTrackEventConstructorGetter>(*lexicalGlobalObject, thisValue, "RTCTrackEvent");
}

#endif

#if ENABLE(WEB_RTC)
static inline bool setJSDOMWindowRTCTrackEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("RTCTrackEvent"), strlen("RTCTrackEvent")), value);
}

bool setJSDOMWindowRTCTrackEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowRTCTrackEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "RTCTrackEvent");
}

#endif

#if ENABLE(NOTIFICATIONS)
static inline JSValue jsDOMWindowNotificationConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSNotification::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowNotificationConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowNotificationConstructorGetter>(*lexicalGlobalObject, thisValue, "Notification");
}

#endif

#if ENABLE(NOTIFICATIONS)
static inline bool setJSDOMWindowNotificationConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("Notification"), strlen("Notification")), value);
}

bool setJSDOMWindowNotificationConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowNotificationConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "Notification");
}

#endif

#if ENABLE(PAYMENT_REQUEST)
static inline JSValue jsDOMWindowMerchantValidationEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSMerchantValidationEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowMerchantValidationEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowMerchantValidationEventConstructorGetter>(*lexicalGlobalObject, thisValue, "MerchantValidationEvent");
}

#endif

#if ENABLE(PAYMENT_REQUEST)
static inline bool setJSDOMWindowMerchantValidationEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("MerchantValidationEvent"), strlen("MerchantValidationEvent")), value);
}

bool setJSDOMWindowMerchantValidationEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowMerchantValidationEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "MerchantValidationEvent");
}

#endif

#if ENABLE(PAYMENT_REQUEST)
static inline JSValue jsDOMWindowPaymentAddressConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSPaymentAddress::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowPaymentAddressConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowPaymentAddressConstructorGetter>(*lexicalGlobalObject, thisValue, "PaymentAddress");
}

#endif

#if ENABLE(PAYMENT_REQUEST)
static inline bool setJSDOMWindowPaymentAddressConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("PaymentAddress"), strlen("PaymentAddress")), value);
}

bool setJSDOMWindowPaymentAddressConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowPaymentAddressConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "PaymentAddress");
}

#endif

#if ENABLE(PAYMENT_REQUEST)
static inline JSValue jsDOMWindowPaymentMethodChangeEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSPaymentMethodChangeEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowPaymentMethodChangeEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowPaymentMethodChangeEventConstructorGetter>(*lexicalGlobalObject, thisValue, "PaymentMethodChangeEvent");
}

#endif

#if ENABLE(PAYMENT_REQUEST)
static inline bool setJSDOMWindowPaymentMethodChangeEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("PaymentMethodChangeEvent"), strlen("PaymentMethodChangeEvent")), value);
}

bool setJSDOMWindowPaymentMethodChangeEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowPaymentMethodChangeEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "PaymentMethodChangeEvent");
}

#endif

#if ENABLE(PAYMENT_REQUEST)
static inline JSValue jsDOMWindowPaymentRequestConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSPaymentRequest::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowPaymentRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowPaymentRequestConstructorGetter>(*lexicalGlobalObject, thisValue, "PaymentRequest");
}

#endif

#if ENABLE(PAYMENT_REQUEST)
static inline bool setJSDOMWindowPaymentRequestConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("PaymentRequest"), strlen("PaymentRequest")), value);
}

bool setJSDOMWindowPaymentRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowPaymentRequestConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "PaymentRequest");
}

#endif

#if ENABLE(PAYMENT_REQUEST)
static inline JSValue jsDOMWindowPaymentRequestUpdateEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSPaymentRequestUpdateEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowPaymentRequestUpdateEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowPaymentRequestUpdateEventConstructorGetter>(*lexicalGlobalObject, thisValue, "PaymentRequestUpdateEvent");
}

#endif

#if ENABLE(PAYMENT_REQUEST)
static inline bool setJSDOMWindowPaymentRequestUpdateEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("PaymentRequestUpdateEvent"), strlen("PaymentRequestUpdateEvent")), value);
}

bool setJSDOMWindowPaymentRequestUpdateEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowPaymentRequestUpdateEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "PaymentRequestUpdateEvent");
}

#endif

#if ENABLE(PAYMENT_REQUEST)
static inline JSValue jsDOMWindowPaymentResponseConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSPaymentResponse::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowPaymentResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowPaymentResponseConstructorGetter>(*lexicalGlobalObject, thisValue, "PaymentResponse");
}

#endif

#if ENABLE(PAYMENT_REQUEST)
static inline bool setJSDOMWindowPaymentResponseConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("PaymentResponse"), strlen("PaymentResponse")), value);
}

bool setJSDOMWindowPaymentResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowPaymentResponseConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "PaymentResponse");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSValue jsDOMWindowEnterPictureInPictureEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSEnterPictureInPictureEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowEnterPictureInPictureEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowEnterPictureInPictureEventConstructorGetter>(*lexicalGlobalObject, thisValue, "EnterPictureInPictureEvent");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline bool setJSDOMWindowEnterPictureInPictureEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("EnterPictureInPictureEvent"), strlen("EnterPictureInPictureEvent")), value);
}

bool setJSDOMWindowEnterPictureInPictureEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowEnterPictureInPictureEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "EnterPictureInPictureEvent");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSValue jsDOMWindowPictureInPictureWindowConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSPictureInPictureWindow::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowPictureInPictureWindowConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowPictureInPictureWindowConstructorGetter>(*lexicalGlobalObject, thisValue, "PictureInPictureWindow");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline bool setJSDOMWindowPictureInPictureWindowConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("PictureInPictureWindow"), strlen("PictureInPictureWindow")), value);
}

bool setJSDOMWindowPictureInPictureWindowConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowPictureInPictureWindowConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "PictureInPictureWindow");
}

#endif

#if ENABLE(SPEECH_SYNTHESIS)
static inline JSValue jsDOMWindowSpeechSynthesisEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSSpeechSynthesisEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowSpeechSynthesisEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowSpeechSynthesisEventConstructorGetter>(*lexicalGlobalObject, thisValue, "SpeechSynthesisEvent");
}

#endif

#if ENABLE(SPEECH_SYNTHESIS)
static inline bool setJSDOMWindowSpeechSynthesisEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("SpeechSynthesisEvent"), strlen("SpeechSynthesisEvent")), value);
}

bool setJSDOMWindowSpeechSynthesisEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowSpeechSynthesisEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "SpeechSynthesisEvent");
}

#endif

#if ENABLE(SPEECH_SYNTHESIS)
static inline JSValue jsDOMWindowSpeechSynthesisUtteranceConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSSpeechSynthesisUtterance::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowSpeechSynthesisUtteranceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowSpeechSynthesisUtteranceConstructorGetter>(*lexicalGlobalObject, thisValue, "SpeechSynthesisUtterance");
}

#endif

#if ENABLE(SPEECH_SYNTHESIS)
static inline bool setJSDOMWindowSpeechSynthesisUtteranceConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("SpeechSynthesisUtterance"), strlen("SpeechSynthesisUtterance")), value);
}

bool setJSDOMWindowSpeechSynthesisUtteranceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowSpeechSynthesisUtteranceConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "SpeechSynthesisUtterance");
}

#endif

#if ENABLE(STREAMS_API)
static inline JSValue jsDOMWindowByteLengthQueuingStrategyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSByteLengthQueuingStrategy::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowByteLengthQueuingStrategyConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowByteLengthQueuingStrategyConstructorGetter>(*lexicalGlobalObject, thisValue, "ByteLengthQueuingStrategy");
}

#endif

#if ENABLE(STREAMS_API)
static inline bool setJSDOMWindowByteLengthQueuingStrategyConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ByteLengthQueuingStrategy"), strlen("ByteLengthQueuingStrategy")), value);
}

bool setJSDOMWindowByteLengthQueuingStrategyConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowByteLengthQueuingStrategyConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ByteLengthQueuingStrategy");
}

#endif

#if ENABLE(STREAMS_API)
static inline JSValue jsDOMWindowCountQueuingStrategyConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSCountQueuingStrategy::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowCountQueuingStrategyConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowCountQueuingStrategyConstructorGetter>(*lexicalGlobalObject, thisValue, "CountQueuingStrategy");
}

#endif

#if ENABLE(STREAMS_API)
static inline bool setJSDOMWindowCountQueuingStrategyConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("CountQueuingStrategy"), strlen("CountQueuingStrategy")), value);
}

bool setJSDOMWindowCountQueuingStrategyConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowCountQueuingStrategyConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "CountQueuingStrategy");
}

#endif

#if ENABLE(STREAMS_API)
static inline JSValue jsDOMWindowReadableByteStreamControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSReadableByteStreamController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowReadableByteStreamControllerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowReadableByteStreamControllerConstructorGetter>(*lexicalGlobalObject, thisValue, "ReadableByteStreamController");
}

#endif

#if ENABLE(STREAMS_API)
static inline bool setJSDOMWindowReadableByteStreamControllerConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ReadableByteStreamController"), strlen("ReadableByteStreamController")), value);
}

bool setJSDOMWindowReadableByteStreamControllerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowReadableByteStreamControllerConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ReadableByteStreamController");
}

#endif

#if ENABLE(STREAMS_API)
static inline JSValue jsDOMWindowReadableStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSReadableStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowReadableStreamConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowReadableStreamConstructorGetter>(*lexicalGlobalObject, thisValue, "ReadableStream");
}

#endif

#if ENABLE(STREAMS_API)
static inline bool setJSDOMWindowReadableStreamConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ReadableStream"), strlen("ReadableStream")), value);
}

bool setJSDOMWindowReadableStreamConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowReadableStreamConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ReadableStream");
}

#endif

#if ENABLE(STREAMS_API)
static inline JSValue jsDOMWindowReadableStreamBYOBReaderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSReadableStreamBYOBReader::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowReadableStreamBYOBReaderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowReadableStreamBYOBReaderConstructorGetter>(*lexicalGlobalObject, thisValue, "ReadableStreamBYOBReader");
}

#endif

#if ENABLE(STREAMS_API)
static inline bool setJSDOMWindowReadableStreamBYOBReaderConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ReadableStreamBYOBReader"), strlen("ReadableStreamBYOBReader")), value);
}

bool setJSDOMWindowReadableStreamBYOBReaderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowReadableStreamBYOBReaderConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ReadableStreamBYOBReader");
}

#endif

#if ENABLE(STREAMS_API)
static inline JSValue jsDOMWindowReadableStreamBYOBRequestConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSReadableStreamBYOBRequest::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowReadableStreamBYOBRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowReadableStreamBYOBRequestConstructorGetter>(*lexicalGlobalObject, thisValue, "ReadableStreamBYOBRequest");
}

#endif

#if ENABLE(STREAMS_API)
static inline bool setJSDOMWindowReadableStreamBYOBRequestConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ReadableStreamBYOBRequest"), strlen("ReadableStreamBYOBRequest")), value);
}

bool setJSDOMWindowReadableStreamBYOBRequestConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowReadableStreamBYOBRequestConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ReadableStreamBYOBRequest");
}

#endif

#if ENABLE(STREAMS_API)
static inline JSValue jsDOMWindowReadableStreamDefaultControllerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSReadableStreamDefaultController::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowReadableStreamDefaultControllerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowReadableStreamDefaultControllerConstructorGetter>(*lexicalGlobalObject, thisValue, "ReadableStreamDefaultController");
}

#endif

#if ENABLE(STREAMS_API)
static inline bool setJSDOMWindowReadableStreamDefaultControllerConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ReadableStreamDefaultController"), strlen("ReadableStreamDefaultController")), value);
}

bool setJSDOMWindowReadableStreamDefaultControllerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowReadableStreamDefaultControllerConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ReadableStreamDefaultController");
}

#endif

#if ENABLE(STREAMS_API)
static inline JSValue jsDOMWindowReadableStreamDefaultReaderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSReadableStreamDefaultReader::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowReadableStreamDefaultReaderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowReadableStreamDefaultReaderConstructorGetter>(*lexicalGlobalObject, thisValue, "ReadableStreamDefaultReader");
}

#endif

#if ENABLE(STREAMS_API)
static inline bool setJSDOMWindowReadableStreamDefaultReaderConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ReadableStreamDefaultReader"), strlen("ReadableStreamDefaultReader")), value);
}

bool setJSDOMWindowReadableStreamDefaultReaderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowReadableStreamDefaultReaderConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ReadableStreamDefaultReader");
}

#endif

#if ENABLE(STREAMS_API)
static inline JSValue jsDOMWindowWritableStreamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWritableStream::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowWritableStreamConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowWritableStreamConstructorGetter>(*lexicalGlobalObject, thisValue, "WritableStream");
}

#endif

#if ENABLE(STREAMS_API)
static inline bool setJSDOMWindowWritableStreamConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("WritableStream"), strlen("WritableStream")), value);
}

bool setJSDOMWindowWritableStreamConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowWritableStreamConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "WritableStream");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowAnalyserNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSAnalyserNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowAnalyserNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowAnalyserNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "AnalyserNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowAnalyserNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("AnalyserNode"), strlen("AnalyserNode")), value);
}

bool setJSDOMWindowAnalyserNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowAnalyserNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "AnalyserNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowAudioBufferConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSAudioBuffer::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowAudioBufferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowAudioBufferConstructorGetter>(*lexicalGlobalObject, thisValue, "AudioBuffer");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowAudioBufferConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("AudioBuffer"), strlen("AudioBuffer")), value);
}

bool setJSDOMWindowAudioBufferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowAudioBufferConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "AudioBuffer");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowAudioBufferSourceNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSAudioBufferSourceNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowAudioBufferSourceNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowAudioBufferSourceNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "AudioBufferSourceNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowAudioBufferSourceNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("AudioBufferSourceNode"), strlen("AudioBufferSourceNode")), value);
}

bool setJSDOMWindowAudioBufferSourceNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowAudioBufferSourceNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "AudioBufferSourceNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowWebkitAudioContextConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSAudioContext::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowWebkitAudioContextConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowWebkitAudioContextConstructorGetter>(*lexicalGlobalObject, thisValue, "webkitAudioContext");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowWebkitAudioContextConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("webkitAudioContext"), strlen("webkitAudioContext")), value);
}

bool setJSDOMWindowWebkitAudioContextConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowWebkitAudioContextConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "webkitAudioContext");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowAudioDestinationNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSAudioDestinationNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowAudioDestinationNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowAudioDestinationNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "AudioDestinationNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowAudioDestinationNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("AudioDestinationNode"), strlen("AudioDestinationNode")), value);
}

bool setJSDOMWindowAudioDestinationNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowAudioDestinationNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "AudioDestinationNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowAudioListenerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSAudioListener::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowAudioListenerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowAudioListenerConstructorGetter>(*lexicalGlobalObject, thisValue, "AudioListener");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowAudioListenerConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("AudioListener"), strlen("AudioListener")), value);
}

bool setJSDOMWindowAudioListenerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowAudioListenerConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "AudioListener");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowAudioNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSAudioNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowAudioNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowAudioNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "AudioNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowAudioNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("AudioNode"), strlen("AudioNode")), value);
}

bool setJSDOMWindowAudioNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowAudioNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "AudioNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowAudioParamConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSAudioParam::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowAudioParamConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowAudioParamConstructorGetter>(*lexicalGlobalObject, thisValue, "AudioParam");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowAudioParamConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("AudioParam"), strlen("AudioParam")), value);
}

bool setJSDOMWindowAudioParamConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowAudioParamConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "AudioParam");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowAudioProcessingEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSAudioProcessingEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowAudioProcessingEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowAudioProcessingEventConstructorGetter>(*lexicalGlobalObject, thisValue, "AudioProcessingEvent");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowAudioProcessingEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("AudioProcessingEvent"), strlen("AudioProcessingEvent")), value);
}

bool setJSDOMWindowAudioProcessingEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowAudioProcessingEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "AudioProcessingEvent");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowBiquadFilterNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSBiquadFilterNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowBiquadFilterNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowBiquadFilterNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "BiquadFilterNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowBiquadFilterNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("BiquadFilterNode"), strlen("BiquadFilterNode")), value);
}

bool setJSDOMWindowBiquadFilterNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowBiquadFilterNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "BiquadFilterNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowChannelMergerNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSChannelMergerNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowChannelMergerNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowChannelMergerNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "ChannelMergerNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowChannelMergerNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ChannelMergerNode"), strlen("ChannelMergerNode")), value);
}

bool setJSDOMWindowChannelMergerNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowChannelMergerNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ChannelMergerNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowChannelSplitterNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSChannelSplitterNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowChannelSplitterNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowChannelSplitterNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "ChannelSplitterNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowChannelSplitterNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ChannelSplitterNode"), strlen("ChannelSplitterNode")), value);
}

bool setJSDOMWindowChannelSplitterNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowChannelSplitterNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ChannelSplitterNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowConvolverNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSConvolverNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowConvolverNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowConvolverNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "ConvolverNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowConvolverNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ConvolverNode"), strlen("ConvolverNode")), value);
}

bool setJSDOMWindowConvolverNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowConvolverNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ConvolverNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowDelayNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSDelayNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowDelayNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowDelayNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "DelayNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowDelayNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("DelayNode"), strlen("DelayNode")), value);
}

bool setJSDOMWindowDelayNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowDelayNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "DelayNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowDynamicsCompressorNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSDynamicsCompressorNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowDynamicsCompressorNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowDynamicsCompressorNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "DynamicsCompressorNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowDynamicsCompressorNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("DynamicsCompressorNode"), strlen("DynamicsCompressorNode")), value);
}

bool setJSDOMWindowDynamicsCompressorNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowDynamicsCompressorNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "DynamicsCompressorNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowGainNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSGainNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGainNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGainNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "GainNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowGainNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GainNode"), strlen("GainNode")), value);
}

bool setJSDOMWindowGainNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGainNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GainNode");
}

#endif

#if ENABLE(VIDEO) && ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowMediaElementAudioSourceNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSMediaElementAudioSourceNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowMediaElementAudioSourceNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowMediaElementAudioSourceNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "MediaElementAudioSourceNode");
}

#endif

#if ENABLE(VIDEO) && ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowMediaElementAudioSourceNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("MediaElementAudioSourceNode"), strlen("MediaElementAudioSourceNode")), value);
}

bool setJSDOMWindowMediaElementAudioSourceNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowMediaElementAudioSourceNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "MediaElementAudioSourceNode");
}

#endif

#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowMediaStreamAudioDestinationNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSMediaStreamAudioDestinationNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowMediaStreamAudioDestinationNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowMediaStreamAudioDestinationNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "MediaStreamAudioDestinationNode");
}

#endif

#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowMediaStreamAudioDestinationNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("MediaStreamAudioDestinationNode"), strlen("MediaStreamAudioDestinationNode")), value);
}

bool setJSDOMWindowMediaStreamAudioDestinationNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowMediaStreamAudioDestinationNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "MediaStreamAudioDestinationNode");
}

#endif

#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowMediaStreamAudioSourceNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSMediaStreamAudioSourceNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowMediaStreamAudioSourceNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowMediaStreamAudioSourceNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "MediaStreamAudioSourceNode");
}

#endif

#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowMediaStreamAudioSourceNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("MediaStreamAudioSourceNode"), strlen("MediaStreamAudioSourceNode")), value);
}

bool setJSDOMWindowMediaStreamAudioSourceNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowMediaStreamAudioSourceNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "MediaStreamAudioSourceNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowOfflineAudioCompletionEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSOfflineAudioCompletionEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowOfflineAudioCompletionEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOfflineAudioCompletionEventConstructorGetter>(*lexicalGlobalObject, thisValue, "OfflineAudioCompletionEvent");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowOfflineAudioCompletionEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("OfflineAudioCompletionEvent"), strlen("OfflineAudioCompletionEvent")), value);
}

bool setJSDOMWindowOfflineAudioCompletionEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOfflineAudioCompletionEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "OfflineAudioCompletionEvent");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowWebkitOfflineAudioContextConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSOfflineAudioContext::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowWebkitOfflineAudioContextConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowWebkitOfflineAudioContextConstructorGetter>(*lexicalGlobalObject, thisValue, "webkitOfflineAudioContext");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowWebkitOfflineAudioContextConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("webkitOfflineAudioContext"), strlen("webkitOfflineAudioContext")), value);
}

bool setJSDOMWindowWebkitOfflineAudioContextConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowWebkitOfflineAudioContextConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "webkitOfflineAudioContext");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowOscillatorNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSOscillatorNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowOscillatorNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowOscillatorNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "OscillatorNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowOscillatorNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("OscillatorNode"), strlen("OscillatorNode")), value);
}

bool setJSDOMWindowOscillatorNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowOscillatorNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "OscillatorNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowWebkitAudioPannerNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSPannerNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowWebkitAudioPannerNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowWebkitAudioPannerNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "webkitAudioPannerNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowWebkitAudioPannerNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("webkitAudioPannerNode"), strlen("webkitAudioPannerNode")), value);
}

bool setJSDOMWindowWebkitAudioPannerNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowWebkitAudioPannerNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "webkitAudioPannerNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowPeriodicWaveConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSPeriodicWave::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowPeriodicWaveConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowPeriodicWaveConstructorGetter>(*lexicalGlobalObject, thisValue, "PeriodicWave");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowPeriodicWaveConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("PeriodicWave"), strlen("PeriodicWave")), value);
}

bool setJSDOMWindowPeriodicWaveConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowPeriodicWaveConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "PeriodicWave");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowScriptProcessorNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSScriptProcessorNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowScriptProcessorNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowScriptProcessorNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "ScriptProcessorNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowScriptProcessorNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("ScriptProcessorNode"), strlen("ScriptProcessorNode")), value);
}

bool setJSDOMWindowScriptProcessorNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowScriptProcessorNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ScriptProcessorNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSValue jsDOMWindowWaveShaperNodeConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWaveShaperNode::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowWaveShaperNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowWaveShaperNodeConstructorGetter>(*lexicalGlobalObject, thisValue, "WaveShaperNode");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline bool setJSDOMWindowWaveShaperNodeConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("WaveShaperNode"), strlen("WaveShaperNode")), value);
}

bool setJSDOMWindowWaveShaperNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowWaveShaperNodeConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "WaveShaperNode");
}

#endif

#if ENABLE(WEB_AUTHN)
static inline JSValue jsDOMWindowAuthenticatorAssertionResponseConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSAuthenticatorAssertionResponse::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowAuthenticatorAssertionResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowAuthenticatorAssertionResponseConstructorGetter>(*lexicalGlobalObject, thisValue, "AuthenticatorAssertionResponse");
}

#endif

#if ENABLE(WEB_AUTHN)
static inline bool setJSDOMWindowAuthenticatorAssertionResponseConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("AuthenticatorAssertionResponse"), strlen("AuthenticatorAssertionResponse")), value);
}

bool setJSDOMWindowAuthenticatorAssertionResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowAuthenticatorAssertionResponseConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "AuthenticatorAssertionResponse");
}

#endif

#if ENABLE(WEB_AUTHN)
static inline JSValue jsDOMWindowAuthenticatorAttestationResponseConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSAuthenticatorAttestationResponse::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowAuthenticatorAttestationResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowAuthenticatorAttestationResponseConstructorGetter>(*lexicalGlobalObject, thisValue, "AuthenticatorAttestationResponse");
}

#endif

#if ENABLE(WEB_AUTHN)
static inline bool setJSDOMWindowAuthenticatorAttestationResponseConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("AuthenticatorAttestationResponse"), strlen("AuthenticatorAttestationResponse")), value);
}

bool setJSDOMWindowAuthenticatorAttestationResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowAuthenticatorAttestationResponseConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "AuthenticatorAttestationResponse");
}

#endif

#if ENABLE(WEB_AUTHN)
static inline JSValue jsDOMWindowAuthenticatorResponseConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSAuthenticatorResponse::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowAuthenticatorResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowAuthenticatorResponseConstructorGetter>(*lexicalGlobalObject, thisValue, "AuthenticatorResponse");
}

#endif

#if ENABLE(WEB_AUTHN)
static inline bool setJSDOMWindowAuthenticatorResponseConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("AuthenticatorResponse"), strlen("AuthenticatorResponse")), value);
}

bool setJSDOMWindowAuthenticatorResponseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowAuthenticatorResponseConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "AuthenticatorResponse");
}

#endif

#if ENABLE(WEB_AUTHN)
static inline JSValue jsDOMWindowPublicKeyCredentialConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSPublicKeyCredential::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowPublicKeyCredentialConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowPublicKeyCredentialConstructorGetter>(*lexicalGlobalObject, thisValue, "PublicKeyCredential");
}

#endif

#if ENABLE(WEB_AUTHN)
static inline bool setJSDOMWindowPublicKeyCredentialConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("PublicKeyCredential"), strlen("PublicKeyCredential")), value);
}

bool setJSDOMWindowPublicKeyCredentialConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowPublicKeyCredentialConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "PublicKeyCredential");
}

#endif

static inline JSValue jsDOMWindowDatabaseConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSDatabase::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowDatabaseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowDatabaseConstructorGetter>(*lexicalGlobalObject, thisValue, "Database");
}

static inline bool setJSDOMWindowDatabaseConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("Database"), strlen("Database")), value);
}

bool setJSDOMWindowDatabaseConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowDatabaseConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "Database");
}

static inline JSValue jsDOMWindowSQLErrorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSSQLError::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowSQLErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowSQLErrorConstructorGetter>(*lexicalGlobalObject, thisValue, "SQLError");
}

static inline bool setJSDOMWindowSQLErrorConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("SQLError"), strlen("SQLError")), value);
}

bool setJSDOMWindowSQLErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowSQLErrorConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "SQLError");
}

static inline JSValue jsDOMWindowSQLResultSetConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSSQLResultSet::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowSQLResultSetConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowSQLResultSetConstructorGetter>(*lexicalGlobalObject, thisValue, "SQLResultSet");
}

static inline bool setJSDOMWindowSQLResultSetConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("SQLResultSet"), strlen("SQLResultSet")), value);
}

bool setJSDOMWindowSQLResultSetConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowSQLResultSetConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "SQLResultSet");
}

static inline JSValue jsDOMWindowSQLResultSetRowListConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSSQLResultSetRowList::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowSQLResultSetRowListConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowSQLResultSetRowListConstructorGetter>(*lexicalGlobalObject, thisValue, "SQLResultSetRowList");
}

static inline bool setJSDOMWindowSQLResultSetRowListConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("SQLResultSetRowList"), strlen("SQLResultSetRowList")), value);
}

bool setJSDOMWindowSQLResultSetRowListConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowSQLResultSetRowListConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "SQLResultSetRowList");
}

static inline JSValue jsDOMWindowSQLTransactionConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSSQLTransaction::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowSQLTransactionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowSQLTransactionConstructorGetter>(*lexicalGlobalObject, thisValue, "SQLTransaction");
}

static inline bool setJSDOMWindowSQLTransactionConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("SQLTransaction"), strlen("SQLTransaction")), value);
}

bool setJSDOMWindowSQLTransactionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowSQLTransactionConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "SQLTransaction");
}

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUBufferUsageConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSGPUBufferUsage::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUBufferUsageConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUBufferUsageConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUBufferUsage");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUBufferUsageConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUBufferUsage"), strlen("GPUBufferUsage")), value);
}

bool setJSDOMWindowGPUBufferUsageConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUBufferUsageConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUBufferUsage");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUCanvasContextConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSGPUCanvasContext::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUCanvasContextConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUCanvasContextConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUCanvasContext");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUCanvasContextConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUCanvasContext"), strlen("GPUCanvasContext")), value);
}

bool setJSDOMWindowGPUCanvasContextConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUCanvasContextConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUCanvasContext");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUColorWriteConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSGPUColorWrite::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUColorWriteConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUColorWriteConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUColorWrite");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUColorWriteConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUColorWrite"), strlen("GPUColorWrite")), value);
}

bool setJSDOMWindowGPUColorWriteConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUColorWriteConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUColorWrite");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUOutOfMemoryErrorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSGPUOutOfMemoryError::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUOutOfMemoryErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUOutOfMemoryErrorConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUOutOfMemoryError");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUOutOfMemoryErrorConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUOutOfMemoryError"), strlen("GPUOutOfMemoryError")), value);
}

bool setJSDOMWindowGPUOutOfMemoryErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUOutOfMemoryErrorConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUOutOfMemoryError");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUShaderStageConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSGPUShaderStage::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUShaderStageConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUShaderStageConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUShaderStage");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUShaderStageConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUShaderStage"), strlen("GPUShaderStage")), value);
}

bool setJSDOMWindowGPUShaderStageConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUShaderStageConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUShaderStage");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUTextureUsageConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSGPUTextureUsage::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUTextureUsageConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUTextureUsageConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUTextureUsage");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUTextureUsageConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUTextureUsage"), strlen("GPUTextureUsage")), value);
}

bool setJSDOMWindowGPUTextureUsageConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUTextureUsageConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUTextureUsage");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUUncapturedErrorEventConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSGPUUncapturedErrorEvent::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUUncapturedErrorEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUUncapturedErrorEventConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUUncapturedErrorEvent");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUUncapturedErrorEventConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUUncapturedErrorEvent"), strlen("GPUUncapturedErrorEvent")), value);
}

bool setJSDOMWindowGPUUncapturedErrorEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUUncapturedErrorEventConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUUncapturedErrorEvent");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUValidationErrorConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSGPUValidationError::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUValidationErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUValidationErrorConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUValidationError");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUValidationErrorConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUValidationError"), strlen("GPUValidationError")), value);
}

bool setJSDOMWindowGPUValidationErrorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUValidationErrorConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUValidationError");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPU::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUConstructorGetter>(*lexicalGlobalObject, thisValue, "GPU");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPU"), strlen("GPU")), value);
}

bool setJSDOMWindowGPUConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPU");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUAdapterConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUAdapter::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUAdapterConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUAdapterConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUAdapter");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUAdapterConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUAdapter"), strlen("GPUAdapter")), value);
}

bool setJSDOMWindowGPUAdapterConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUAdapterConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUAdapter");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUBindGroupConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUBindGroup::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUBindGroupConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUBindGroupConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUBindGroup");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUBindGroupConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUBindGroup"), strlen("GPUBindGroup")), value);
}

bool setJSDOMWindowGPUBindGroupConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUBindGroupConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUBindGroup");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUBindGroupLayoutConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUBindGroupLayout::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUBindGroupLayoutConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUBindGroupLayoutConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUBindGroupLayout");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUBindGroupLayoutConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUBindGroupLayout"), strlen("GPUBindGroupLayout")), value);
}

bool setJSDOMWindowGPUBindGroupLayoutConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUBindGroupLayoutConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUBindGroupLayout");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUBufferConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUBuffer::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUBufferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUBufferConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUBuffer");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUBufferConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUBuffer"), strlen("GPUBuffer")), value);
}

bool setJSDOMWindowGPUBufferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUBufferConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUBuffer");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUCommandBufferConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUCommandBuffer::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUCommandBufferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUCommandBufferConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUCommandBuffer");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUCommandBufferConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUCommandBuffer"), strlen("GPUCommandBuffer")), value);
}

bool setJSDOMWindowGPUCommandBufferConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUCommandBufferConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUCommandBuffer");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUCommandEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUCommandEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUCommandEncoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUCommandEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUCommandEncoder");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUCommandEncoderConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUCommandEncoder"), strlen("GPUCommandEncoder")), value);
}

bool setJSDOMWindowGPUCommandEncoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUCommandEncoderConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUCommandEncoder");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUComputePassEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUComputePassEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUComputePassEncoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUComputePassEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUComputePassEncoder");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUComputePassEncoderConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUComputePassEncoder"), strlen("GPUComputePassEncoder")), value);
}

bool setJSDOMWindowGPUComputePassEncoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUComputePassEncoderConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUComputePassEncoder");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUComputePipelineConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUComputePipeline::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUComputePipelineConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUComputePipelineConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUComputePipeline");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUComputePipelineConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUComputePipeline"), strlen("GPUComputePipeline")), value);
}

bool setJSDOMWindowGPUComputePipelineConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUComputePipelineConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUComputePipeline");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUDeviceConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUDevice::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUDeviceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUDeviceConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUDevice");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUDeviceConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUDevice"), strlen("GPUDevice")), value);
}

bool setJSDOMWindowGPUDeviceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUDeviceConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUDevice");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUPipelineLayoutConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUPipelineLayout::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUPipelineLayoutConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUPipelineLayoutConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUPipelineLayout");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUPipelineLayoutConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUPipelineLayout"), strlen("GPUPipelineLayout")), value);
}

bool setJSDOMWindowGPUPipelineLayoutConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUPipelineLayoutConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUPipelineLayout");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUProgrammablePassEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUProgrammablePassEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUProgrammablePassEncoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUProgrammablePassEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUProgrammablePassEncoder");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUProgrammablePassEncoderConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUProgrammablePassEncoder"), strlen("GPUProgrammablePassEncoder")), value);
}

bool setJSDOMWindowGPUProgrammablePassEncoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUProgrammablePassEncoderConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUProgrammablePassEncoder");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUQueueConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUQueue::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUQueueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUQueueConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUQueue");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUQueueConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUQueue"), strlen("GPUQueue")), value);
}

bool setJSDOMWindowGPUQueueConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUQueueConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUQueue");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPURenderPassEncoderConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPURenderPassEncoder::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPURenderPassEncoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPURenderPassEncoderConstructorGetter>(*lexicalGlobalObject, thisValue, "GPURenderPassEncoder");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPURenderPassEncoderConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPURenderPassEncoder"), strlen("GPURenderPassEncoder")), value);
}

bool setJSDOMWindowGPURenderPassEncoderConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPURenderPassEncoderConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPURenderPassEncoder");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPURenderPipelineConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPURenderPipeline::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPURenderPipelineConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPURenderPipelineConstructorGetter>(*lexicalGlobalObject, thisValue, "GPURenderPipeline");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPURenderPipelineConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPURenderPipeline"), strlen("GPURenderPipeline")), value);
}

bool setJSDOMWindowGPURenderPipelineConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPURenderPipelineConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPURenderPipeline");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUSamplerConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUSampler::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUSamplerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUSamplerConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUSampler");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUSamplerConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUSampler"), strlen("GPUSampler")), value);
}

bool setJSDOMWindowGPUSamplerConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUSamplerConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUSampler");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUShaderModuleConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUShaderModule::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUShaderModuleConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUShaderModuleConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUShaderModule");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUShaderModuleConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUShaderModule"), strlen("GPUShaderModule")), value);
}

bool setJSDOMWindowGPUShaderModuleConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUShaderModuleConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUShaderModule");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUSwapChainConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUSwapChain::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUSwapChainConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUSwapChainConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUSwapChain");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUSwapChainConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUSwapChain"), strlen("GPUSwapChain")), value);
}

bool setJSDOMWindowGPUSwapChainConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUSwapChainConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUSwapChain");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUTextureConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUTexture::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUTextureConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUTextureConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUTexture");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUTextureConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    VM& vm = throwScope.vm();
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return false;
    // Shadowing a built-in constructor.
    return thisObject.putDirect(vm, Identifier::fromString(vm, reinterpret_cast<const LChar*>("GPUTexture"), strlen("GPUTexture")), value);
}

bool setJSDOMWindowGPUTextureConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSDOMWindow>::set<setJSDOMWindowGPUTextureConstructorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "GPUTexture");
}

#endif

#if ENABLE(WEBGPU)
static inline JSValue jsDOMWindowGPUTextureViewConstructorGetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped(), ThrowSecurityError))
        return jsUndefined();
    return JSWebGPUTextureView::getConstructor(JSC::getVM(&lexicalGlobalObject), &thisObject);
}

EncodedJSValue jsDOMWindowGPUTextureViewConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSDOMWindow>::get<jsDOMWindowGPUTextureViewConstructorGetter>(*lexicalGlobalObject, thisValue, "GPUTextureView");
}

#endif

#if ENABLE(WEBGPU)
static inline bool setJSDOMWindowGPUTextureViewConstructorSetter(JSGlobalObject& lexicalGlobalObject, JSDOMWindow& this